(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   1201271,      34306]
NotebookOptionsPosition[   1168547,      33425]
NotebookOutlinePosition[   1172815,      33556]
CellTagsIndexPosition[   1172740,      33551]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Dynamic AdS/CMT - Superconductor - Spectral - General Ansatz\
\>", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
   3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
   3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
   3.495174647742872*^9, 3.460515504326817*^9}, {3.503996600043788*^9, 
   3.503996603042028*^9}, {3.507011572545054*^9, 3.460340667971311*^9}, {
   3.5374843541262083`*^9, 3.537484358716886*^9}, 3.537484391202265*^9, {
   3.537484629914453*^9, 3.537484630281348*^9}, {3.5374893532274837`*^9, 
   3.537489358050692*^9}}],

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "^", "2"}]], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"-", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "0", "0"},
       {
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}], "0"},
       {"0", "0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.507011580676421*^9, 3.507011659804162*^9}, {3.507013755598536*^9, 
   3.460392698323369*^9}, {3.4604018613321533`*^9, 3.4604018646719627`*^9}, {
   3.460401965632374*^9, 3.460401968163259*^9}, {3.4604023388162813`*^9, 
   3.4604023558966084`*^9}, {3.460402422665003*^9, 3.460402426690833*^9}, {
   3.460402628586185*^9, 3.4604026419139843`*^9}, {3.460402674350209*^9, 
   3.4604026844332027`*^9}, {3.460512773931822*^9, 3.460512787444798*^9}, {
   3.4605146484667263`*^9, 3.460514650350994*^9}, {3.460514717258254*^9, 
   3.460514724283691*^9}, 3.460514770989304*^9, 3.4605223140457373`*^9, {
   3.4605327188171663`*^9, 3.460532727004561*^9}, {3.460532863547011*^9, 
   3.460532865145266*^9}, {3.460532977769042*^9, 3.4605329860852757`*^9}, {
   3.507275497143169*^9, 3.4603659980232763`*^9}, {3.537484515197036*^9, 
   3.537484572210073*^9}, 3.537484644682625*^9, {3.5374846959240923`*^9, 
   3.537484701892157*^9}, {3.537484976337736*^9, 3.5374849917355137`*^9}, {
   3.537486594817341*^9, 3.537486596777007*^9}}],

Cell[BoxData["Gd"], "Input"],

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",\

 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",\

 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[BoxData[
 RowBox[{
  RowBox[{"R2", "=", 
   RowBox[{"Simplify", "[", "R2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041067188341103`*^9, 3.404106720182616*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"GT", "[", 
       RowBox[{"R2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "A", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"A", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"A", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"v", ",", "d"}], "}"}], "}"}], ",", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"ST", "[", 
    RowBox[{"A", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"z", ",", "d"}], "}"}], "}"}], ",", 
     RowBox[{"az", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451383976248069*^9, 3.4513840125908737`*^9}, {
  3.451384057147691*^9, 3.451384064689735*^9}, {3.451385762395092*^9, 
  3.451385762480318*^9}, {3.451385800913571*^9, 3.451385805770357*^9}, {
  3.537484677141605*^9, 3.53748468964509*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "F", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"F", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"F", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}]}], "}"}], ",", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i2", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i1", "]"}], "]"}]}], "]"}]}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4041040239360247`*^9, 3.404104073416904*^9}, {
  3.4041057167733383`*^9, 3.4041057183570337`*^9}, {3.4513840707957897`*^9, 
  3.451384164343499*^9}, {3.460366100458836*^9, 3.460366108909464*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"trFF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"trT", "[", 
      RowBox[{
       RowBox[{"outerT", "[", 
        RowBox[{"F", ",", "F"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fsqr", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"trT", "[", 
     RowBox[{"trFF", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.404103126230957*^9, 3.404103206051724*^9}, 
   3.404103788928409*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "Dp", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"Dp", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Dp", "=", 
       RowBox[{"ST", "[", 
        RowBox[{"Dp", ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], "}"}], ",", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"\[Phi]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
          RowBox[{"I", " ", 
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], 
           RowBox[{"\[Phi]", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConjDp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "d", "}"}], ",", 
      RowBox[{"Conjugate", "[", 
       RowBox[{"Dp", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DpDp", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{"trT", "[", 
       RowBox[{
        RowBox[{"outerT", "[", 
         RowBox[{"ConjDp", ",", "Dp"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Vterm", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"\[Phi]", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "]"}], 
       RowBox[{"\[Phi]", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513844331121693`*^9, 3.451384521665413*^9}, {
   3.451384560554626*^9, 3.451384642158163*^9}, {3.4513849100950413`*^9, 
   3.451384915054587*^9}, 3.451385051803838*^9, {3.4513851171366262`*^9, 
   3.45138511927711*^9}, {3.451385175930884*^9, 3.451385183167452*^9}, {
   3.451385425505906*^9, 3.45138544324051*^9}, {3.451385490350021*^9, 
   3.451385493946774*^9}, {3.451385568392873*^9, 3.451385601054823*^9}, {
   3.451385813165941*^9, 3.4513858527683163`*^9}, {3.45138608116168*^9, 
   3.451386103913107*^9}, {3.46036707784975*^9, 3.460255762501432*^9}, {
   3.46025580130457*^9, 3.460255801461816*^9}, {3.53748492894665*^9, 
   3.53748495518618*^9}, {3.537485329580826*^9, 3.537485331297533*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DpDp", "=", 
   RowBox[{"(", 
    RowBox[{"DpDp", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Re", "[", "xx_", "]"}], "\[Rule]", "xx"}], ",", 
       RowBox[{
        RowBox[{"Im", "[", "xx_", "]"}], "\[Rule]", "0"}]}], "}"}]}], ")"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.451385894732107*^9, 3.451385976334114*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sqrtdetg", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Det", "[", 
       RowBox[{"-", "Gd"}], "]"}], "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041041692972*^9, 3.404104211096949*^9}, 
   3.404105293940057*^9, {3.4513842180130997`*^9, 3.4513842223260803`*^9}, {
   3.4513846617079067`*^9, 3.451384675916638*^9}}],

Cell[BoxData[
 RowBox[{"L", "=", 
  RowBox[{"sqrtdetg", 
   RowBox[{"(", 
    RowBox[{"Ricci", "+", "6", "-", 
     RowBox[{
      FractionBox["1", "4"], "Fsqr"}], "-", "DpDp", "-", "Vterm"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.451384367735067*^9, 3.451384393946628*^9}, {
   3.4513849054437723`*^9, 3.4513849068431387`*^9}, {3.451385606138598*^9, 
   3.451385607193993*^9}, 3.460366276193363*^9, {3.4603670917067547`*^9, 
   3.460255829896731*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp1", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp3", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.53748653613297*^9, 3.5374865918283*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GHBT", "+=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
     "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460366441552243*^9, 3.460366544772176*^9}, {
  3.4603665879440317`*^9, 3.460366626391823*^9}, {3.537486655723679*^9, 
  3.537486732610427*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L2", "=", 
   RowBox[{"L", "-", "GHBT"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460366546941235*^9, 3.460366557341961*^9}, 
   3.460366686117609*^9, {3.4603672960654507`*^9, 3.4603672977104673`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"L2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.460366666517003*^9, 3.460366674775579*^9}, {3.537486746662644*^9, 
  3.5374867639666147`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EOM", "[", "fld_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{"D", "[", 
      RowBox[{"L2", ",", "fld"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"tmp2", "=", 
           RowBox[{"D", "[", 
            RowBox[{"fld", ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ")"}], "=!=", "0"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tmp", "-=", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"L2", ",", "tmp2"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "tmp"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.4513849546200113`*^9, 3.451385039242148*^9}, {
  3.4603662728020573`*^9, 3.460366273871294*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqp", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"p", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"\[Alpha]", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513848144544163`*^9, 3.4513848150159073`*^9}, {
  3.451384869337384*^9, 3.451384875673843*^9}, {3.451384929950244*^9, 
  3.451384930100154*^9}, {3.451385060851385*^9, 3.451385213396349*^9}, {
  3.451385293160893*^9, 3.451385302528058*^9}, {3.4513853749547167`*^9, 
  3.45138537639461*^9}, {3.451385514552088*^9, 3.451385527943191*^9}, {
  3.451385862306609*^9, 3.451385882826736*^9}, {3.451386138230373*^9, 
  3.451386140019012*^9}, {3.451386241895258*^9, 3.4513862693654633`*^9}, {
  3.4603675858592987`*^9, 3.4603675914720583`*^9}, {3.537486779881022*^9, 
  3.537486784922683*^9}, {3.537486894453556*^9, 3.5374869009568243`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqav", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"av", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"az", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513855403702793`*^9, 3.451385540823719*^9}, {
  3.4513861532442207`*^9, 3.45138616739637*^9}, {3.451386251199284*^9, 
  3.4513862656960487`*^9}, {3.460367593073217*^9, 3.460367597640524*^9}, {
  3.5374867866028214`*^9, 3.537486788378339*^9}, {3.537486891597521*^9, 
  3.537486937732339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqgvz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gvz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqgzz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gzz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqT", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"T", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqS", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451386275930722*^9, 3.451386303859261*^9}, {
  3.460366711720347*^9, 3.4603667226381903`*^9}, {3.460367599130735*^9, 
  3.460367611985876*^9}, {3.53748678993122*^9, 3.53748680663302*^9}, {
  3.537486911477583*^9, 3.5374869187572203`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"gvz", ",", "gzz", ",", "az"}], "]"}]], "Input",
 CellChangeTimes->{{3.53748694036823*^9, 3.537486945275868*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"gvz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gzz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"az", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}]}], "Input",
 CellChangeTimes->{{3.460366755240944*^9, 3.460366765921853*^9}, {
   3.460379717667384*^9, 3.460379720321673*^9}, {3.4603938524268913`*^9, 
   3.4603938546559877`*^9}, 3.4603939628549967`*^9, {3.5374868640225983`*^9, 
   3.537486876197587*^9}, {3.537486924492758*^9, 3.537486925572747*^9}, {
   3.537487030062772*^9, 3.537487030117689*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqp2", "=", 
   RowBox[{"Simplify", "[", "eqp", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]2", "=", 
   RowBox[{"Simplify", "[", "eq\[Alpha]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqav2", "=", 
   RowBox[{"Simplify", "[", "eqav", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz2", "=", 
   RowBox[{"Simplify", "[", "eqaz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgvz2", "=", 
   RowBox[{"Simplify", "[", "eqgvz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgzz2", "=", 
   RowBox[{"Simplify", "[", "eqgzz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqT2", "=", 
   RowBox[{"Simplify", "[", "eqT", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"eqS2", "=", 
  RowBox[{"Simplify", "[", "eqS", "]"}]}]}], "Input",
 CellChangeTimes->{{3.460366768598325*^9, 3.4603668525536737`*^9}, {
  3.5374869590367947`*^9, 3.537486972220312*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"t_", ",", "r_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"t_", ",", "r_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"t_", ",", "r_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"t_", ",", "r_"}], "]"}], ":=", "1"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"t_", ",", "r_"}], "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", "eqp2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eq\[Alpha]2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqav2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqaz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqgvz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqgzz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqT2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "eqS2", "]"}]}], "Input",
 CellChangeTimes->{{3.507012905387106*^9, 3.507012910083256*^9}, {
  3.5070145245498*^9, 3.4603669411156473`*^9}, {3.5374870758129187`*^9, 
  3.5374870842285547`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"\[Alpha]", ",", "p", ",", "av", ",", "T", ",", "S"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4603676469897413`*^9, 3.460367657697607*^9}, {
  3.4603797352914047`*^9, 3.460379735508092*^9}, {3.5374870733721457`*^9, 
  3.537487073532263*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}]}], "Input",
 CellChangeTimes->{{3.460366755240944*^9, 3.460366765921853*^9}, {
  3.4603671792275887`*^9, 3.460367185762648*^9}, {3.4603797072573*^9, 
  3.460379707662807*^9}, {3.5374871010953836`*^9, 3.53748710115935*^9}, {
  3.5374871470762453`*^9, 3.537487152020032*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqp3", "=", 
   RowBox[{"Simplify", "[", "eqp", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgvz3", "=", 
   RowBox[{"Simplify", "[", "eqgvz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgzz3", "=", 
   RowBox[{"Simplify", "[", "eqgzz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqT3", "=", 
   RowBox[{"Simplify", "[", "eqT", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"eqS3", "=", 
  RowBox[{"Simplify", "[", "eqS", "]"}]}]}], "Input",
 CellChangeTimes->{{3.460367206768211*^9, 3.460367207075877*^9}, {
  3.537487175483944*^9, 3.5374871829395657`*^9}}],

Cell[BoxData[
 RowBox[{"Momsol", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqT3", "\[Equal]", "0"}], ",", 
        RowBox[{"eqgzz3", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.460367890469932*^9, 3.460367921924135*^9}, {
  3.5374871927249537`*^9, 3.537487195819868*^9}, {3.5374874553153*^9, 
  3.537487502516226*^9}}],

Cell[BoxData[
 RowBox[{"Evsol", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqgvz3", "\[Equal]", "0"}], ",", 
        RowBox[{"eqS3", "\[Equal]", "0"}], ",", 
        RowBox[{"eqp3", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["p", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.46053374107543*^9, 3.460533788442417*^9}, {
  3.4605339589207497`*^9, 3.4603677468152027`*^9}, {3.460367859122974*^9, 
  3.460367860906866*^9}, {3.537487202275996*^9, 3.537487216187519*^9}, {
  3.537487432633148*^9, 3.537487447187475*^9}}],

Cell[BoxData[
 RowBox[{"Print", "[", 
  "\"\<\\n\\nTO DO: check these agree with previous!\\n\\n\>\"", 
  "]"}]], "Input",
 CellChangeTimes->{{3.460368109280581*^9, 3.460368124162081*^9}, {
  3.53748752258011*^9, 3.537487526387782*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"\[Alpha]", ",", "p", ",", "av", ",", "T", ",", "S"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4603676469897413`*^9, 3.460367657697607*^9}, {
  3.46037975752*^9, 3.4603797578530273`*^9}, {3.537487136884354*^9, 
  3.5374871369561577`*^9}}],

Cell[BoxData[
 RowBox[{"Evsol", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqgvz2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqS2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqp2", "\[Equal]", "0"}], ",", 
        RowBox[{"eq\[Alpha]2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqaz", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["p", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["\[Alpha]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["av", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4603794747692738`*^9, 3.4603795051117373`*^9}, {
   3.460379770556391*^9, 3.460379778090231*^9}, {3.537487575145343*^9, 
   3.537487601737835*^9}, {3.5374876320607243`*^9, 3.537487632172414*^9}, 
   3.5374876986147537`*^9}],

Cell[BoxData[
 RowBox[{"Momsol", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqT2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqgzz", "\[Equal]", "0"}], ",", 
        RowBox[{"eqav", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["av", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.460379791348405*^9, 3.460379854266864*^9}, {
  3.537487577120059*^9, 3.537487629667873*^9}, {3.5374877038531513`*^9, 
  3.537487709515881*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqT2", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqav", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"eqgzz", ",", "z"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"Evsol", ",", "v"}], "]"}]}], "/.", "Evsol"}], "/.", "Momsol"}],
   "]"}]}], "Input",
 CellChangeTimes->{{3.460379877349128*^9, 3.460379983100644*^9}, {
  3.460380087445326*^9, 3.460380091873478*^9}, {3.537487726936469*^9, 
  3.5374877500015907`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"a", "[", 
    RowBox[{"v", ",", "z"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"h", "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.460380576942815*^9, 3.46038057950566*^9}, {
  3.4603806147948647`*^9, 3.460380638346624*^9}, {3.5374877590000763`*^9, 
  3.537487759103163*^9}, {3.537487795719556*^9, 3.537487805166259*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Const1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Const2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Const3", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["S", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["S", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.46031768644937*^9, 3.46031772334064*^9}, {
  3.537487772329159*^9, 3.5374878178010073`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Eq1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["p", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["p", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq3", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq4", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq5", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["T", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["T", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.537489066732723*^9, 3.5374891410817547`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "deriv", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"deriv", "[", "X_", "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"X", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "X"}], ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<v\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "z"}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<v\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"X", "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], ",", "z"}], 
        "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<vz\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"v", ",", "2"}], "}"}]}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<vv\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "2"}], "}"}]}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<zz\>\""}], "]"}]}]}],
      "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"deriv", "[", "j", "]"}]}], "Input",
 CellChangeTimes->{{3.537488129955064*^9, 3.537488303539091*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "pow", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pow", ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Power", "[", 
      RowBox[{"X_", ",", "n_"}], "]"}], "\[Rule]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Hold", "[", 
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "p", ",", "a", ",", "h", ",", "T", ",", "S", ",", "pv", ",", "av",
              ",", "hv", ",", "Tv", ",", "Sv", ",", "az", ",", "hz", ",", 
             "Tz", ",", "Sz", ",", "z"}], "}"}], ",", "X"}], "]"}], "&&", 
         RowBox[{"n", ">", "1"}]}], "]"}], ",", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", 
         RowBox[{"ToString", "[", "n", "]"}]}], "]"}], ",", 
       RowBox[{"Power", "[", 
        RowBox[{"X", ",", "n"}], "]"}]}], "]"}]}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"pow2", ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Power", "[", 
     RowBox[{"z", ",", "n_"}], "]"}], "\[Rule]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"Hold", "[", 
       RowBox[{"n", "<", "0"}], "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<invz\>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"-", "n"}], "]"}]}], "]"}], ",", 
      RowBox[{"Power", "[", 
       RowBox[{"z", ",", "n"}], "]"}]}], "]"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.537488415657971*^9, 3.5374884857824373`*^9}, {
  3.5374885190861607`*^9, 3.5374885912861147`*^9}, {3.537488646701576*^9, 
  3.537488718313038*^9}, {3.537488805397175*^9, 3.537488872363184*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"deriv", "[", "p", "]"}], ",", 
     RowBox[{"deriv", "[", "a", "]"}], ",", 
     RowBox[{"deriv", "[", "h", "]"}], ",", 
     RowBox[{"deriv", "[", "T", "]"}], ",", 
     RowBox[{"deriv", "[", "S", "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460533850988061*^9, 3.460317762594681*^9}, {
  3.460317899777432*^9, 3.460317913876012*^9}, {3.4603179946260138`*^9, 
  3.460317994880909*^9}, {3.460318028461433*^9, 3.4603180359232483`*^9}, {
  3.5374878304982758`*^9, 3.537487855625393*^9}, {3.53748801305739*^9, 
  3.537488044943592*^9}, {3.537488108469489*^9, 3.537488111403976*^9}, {
  3.5374883167609386`*^9, 3.537488354940011*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{"Release", "[", 
       RowBox[{
        RowBox[{"Release", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Const1", "//.", "repl"}], ")"}], "/.", "pow"}], "]"}], "/.",
         "pow2"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"C1str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537488755459847*^9, 3.5374888008681593`*^9}, {
  3.5374888802505913`*^9, 3.537488889690336*^9}, {3.5374892313945293`*^9, 
  3.537489256238434*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{"Release", "[", 
       RowBox[{
        RowBox[{"Release", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Const2", "//.", "repl"}], ")"}], "/.", "pow"}], "]"}], "/.",
         "pow2"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"C2str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5374892622494698`*^9, 3.537489262301381*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{"Release", "[", 
       RowBox[{
        RowBox[{"Release", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Const3", "//.", "repl"}], ")"}], "/.", "pow"}], "]"}], "/.",
         "pow2"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"C3str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.46031774040781*^9, 3.460317740459159*^9}, 
   3.460317775256096*^9, 3.460318001123889*^9, {3.537488894755899*^9, 
   3.53748889633001*^9}, {3.537489253282872*^9, 3.537489264569295*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{"Release", "[", 
       RowBox[{
        RowBox[{"Release", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Eq1", "//.", "repl"}], ")"}], "/.", "pow"}], "]"}], "/.", 
        "pow2"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq1str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489304806736*^9, 3.537489309341483*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{"Release", "[", 
       RowBox[{
        RowBox[{"Release", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Eq2", "//.", "repl"}], ")"}], "/.", "pow"}], "]"}], "/.", 
        "pow2"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq2str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489318982319*^9, 3.537489320813158*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{"Release", "[", 
       RowBox[{
        RowBox[{"Release", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Eq3", "//.", "repl"}], ")"}], "/.", "pow"}], "]"}], "/.", 
        "pow2"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq3str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489322317545*^9, 3.5374893272850323`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{"Release", "[", 
       RowBox[{
        RowBox[{"Release", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Eq4", "//.", "repl"}], ")"}], "/.", "pow"}], "]"}], "/.", 
        "pow2"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq4str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5374893239336042`*^9, 3.53748932876528*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{"Release", "[", 
       RowBox[{
        RowBox[{"Release", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Eq5", "//.", "repl"}], ")"}], "/.", "pow"}], "]"}], "/.", 
        "pow2"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq5str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489325205411*^9, 3.5374893303250504`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", " ", 
       RowBox[{"p1", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"p2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"p3", "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"p4", "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"p5", "[", "z", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", " ", 
       RowBox[{"h1", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"h2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"h3", "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"h4", "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"h5", "[", "z", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
  3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
  3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
  3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
  3.5374902204790897`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "3"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Series", "[", 
   RowBox[{"Eq2", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", "3"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
  3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
  3.537489829726491*^9}, {3.537490149033115*^9, 3.5374902057652407`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", " ", 
       RowBox[{"p1", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"p2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"p3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"p4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"p5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", " ", 
       RowBox[{"h1", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"h2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"h3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"h4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"h5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"a1", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"a2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"a3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"a4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"a5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
  3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
  3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
  3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
  3.537490237348768*^9}, {3.53749080821659*^9, 3.53749081622396*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Series", "[", 
   RowBox[{"Const2", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
  3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
  3.537489829726491*^9}, {3.537490149033115*^9, 3.5374902057652407`*^9}, {
  3.537490262342108*^9, 3.5374903130109043`*^9}, {3.537490481623724*^9, 
  3.537490521599202*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "]"}]], "Input",
 CellChangeTimes->{{3.537490562717019*^9, 3.537490567417604*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"p2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"p3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"p4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"p5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"h2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"h3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"h4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"h5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"a1", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], 
      RowBox[{"a2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"a3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"a4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"a5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
  3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
  3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
  3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
  3.537490237348768*^9}, {3.537490394647192*^9, 3.537490453890482*^9}, {
  3.537490792048935*^9, 3.537490804720195*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"Const2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
  3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
  3.537489829726491*^9}, {3.537490149033115*^9, 3.5374902057652407`*^9}, {
  3.537490262342108*^9, 3.5374903130109043`*^9}, {3.537490409219372*^9, 
  3.537490411643456*^9}, {3.537490468359522*^9, 3.5374904760314198`*^9}, {
  3.537490533703246*^9, 3.537490534182864*^9}, {3.537490590875092*^9, 
  3.537490636158053*^9}, {3.537490743064454*^9, 3.537490762064205*^9}, {
  3.537490911375699*^9, 3.537490936931161*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"p2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"p3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"p4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"p5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"h2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"h3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"h4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"h5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"a1", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"a2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"a3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"a4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"a5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
  3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
  3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
  3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
  3.537490237348768*^9}, {3.537490394647192*^9, 3.537490453890482*^9}, {
  3.537490792048935*^9, 3.537490804720195*^9}, {3.537490860205984*^9, 
  3.537490863100896*^9}, {3.5374908962097483`*^9, 3.537490902905895*^9}, {
  3.537491099280459*^9, 3.5374911037619123`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"Const2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
  3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
  3.537489829726491*^9}, {3.537490149033115*^9, 3.5374902057652407`*^9}, {
  3.537490262342108*^9, 3.5374903130109043`*^9}, {3.537490409219372*^9, 
  3.537490411643456*^9}, {3.537490468359522*^9, 3.5374904760314198`*^9}, {
  3.537490533703246*^9, 3.537490534182864*^9}, {3.537490590875092*^9, 
  3.537490636158053*^9}, {3.537490743064454*^9, 3.537490762064205*^9}, {
  3.5374908661951437`*^9, 3.537490868403438*^9}}],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4"}], "}"}], 
    "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p3", "[", "v", "]"}], ",", 
     RowBox[{"h3", "[", "v", "]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.537490773642297*^9, 3.5374907851256247`*^9}, {
  3.5374909698599043`*^9, 3.5374909759077177`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", " ", "=", " ", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"p2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"p3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"p4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"p5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"h2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"h3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"h4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"h5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"a1", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"a2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"a3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"a4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"a5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], 
      RowBox[{"T2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"T3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"T4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"T5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], 
     RowBox[{"S2", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "3"}], " ", 
     RowBox[{"S3", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "4"}], " ", 
     RowBox[{"S4", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "5"}], " ", 
     RowBox[{"S5", "[", "v", "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
  3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
  3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
  3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
  3.537490237348768*^9}, {3.537490394647192*^9, 3.537490453890482*^9}, {
  3.537490792048935*^9, 3.537490804720195*^9}, {3.537490860205984*^9, 
  3.537490863100896*^9}, {3.5374908962097483`*^9, 3.537490902905895*^9}, {
  3.537491099280459*^9, 3.5374911037619123`*^9}, {3.5374911421214113`*^9, 
  3.537491208593452*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Const1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Const2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Const3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq4", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"Eq5", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", 
      RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
  3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
  3.537489829726491*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"p2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"p3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"p4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"p5", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "6"}], 
       RowBox[{"p6", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"h2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"h3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"h4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"h5", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "6"}], " ", 
       RowBox[{"h6", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"a1", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"a4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"a5", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "6"}], " ", 
      RowBox[{"a6", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"T3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"T4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"T5", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "6"}], " ", 
      RowBox[{"T6", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "4"}], " ", 
     RowBox[{"S4", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "5"}], " ", 
     RowBox[{"S5", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "6"}], " ", 
     RowBox[{"S6", "[", "v", "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
   3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
   3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
   3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
   3.537490237348768*^9}, {3.537490394647192*^9, 3.537490453890482*^9}, {
   3.537490792048935*^9, 3.537490804720195*^9}, {3.537490860205984*^9, 
   3.537490863100896*^9}, {3.5374908962097483`*^9, 3.537490902905895*^9}, {
   3.537491099280459*^9, 3.5374911037619123`*^9}, {3.5374911421214113`*^9, 
   3.537491208593452*^9}, {3.537491243062257*^9, 3.537491303338913*^9}, {
   3.53749259693082*^9, 3.537492636305485*^9}, {3.537493118757263*^9, 
   3.53749311902004*^9}, 3.5374931908433867`*^9, 3.53749323181747*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "2"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"repltmp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"a1", "'"}], "[", "v", "]"}], "\[Rule]", "0"}], "}"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Eq5", "//.", "repltmp"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
  3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
  3.537489829726491*^9}, {3.5374913369695187`*^9, 3.537491383848136*^9}, {
  3.537492455743868*^9, 3.537492509807266*^9}, {3.537492710362728*^9, 
  3.537492710514277*^9}, {3.537492765776664*^9, 3.537492765928492*^9}, {
  3.537493169402782*^9, 3.537493175233514*^9}, {3.537493221945931*^9, 
  3.5374932250087757`*^9}}],

Cell[BoxData[
 RowBox[{"repl", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
        "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"h3", "[", "v", "]"}], ",", 
       RowBox[{"p3", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537489831616275*^9, 3.5374898801274137`*^9}, {
  3.537491317375599*^9, 3.537491321759262*^9}, {3.537492699591785*^9, 
  3.537492702071735*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "3"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"repltmp", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "'"}], "[", "v", "]"}], "\[Rule]", "0"}], "}"}], ",", 
      "repl", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl", ",", "v"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Eq5", "//.", "repltmp"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
  3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
  3.537489829726491*^9}, {3.5374913369695187`*^9, 3.537491383848136*^9}, {
  3.537492455743868*^9, 3.537492509807266*^9}, {3.537492710362728*^9, 
  3.537492710514277*^9}, {3.537492765776664*^9, 3.537492765928492*^9}, {
  3.53749324118568*^9, 3.537493241384499*^9}}],

Cell[BoxData[
 RowBox[{"repl2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"T3", "'"}], "[", "v", "]"}], ",", 
        RowBox[{"a4", "[", "v", "]"}], ",", 
        RowBox[{"h4", "[", "v", "]"}], ",", 
        RowBox[{"p4", "[", "v", "]"}], ",", 
        RowBox[{"S4", "[", "v", "]"}], ",", 
        RowBox[{"T4", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5374914244686213`*^9, 3.537491468167574*^9}, {
  3.5374915105206013`*^9, 3.537491548039349*^9}, {3.537492546503677*^9, 
  3.537492546942692*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"repltmp", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "'"}], "[", "v", "]"}], "\[Rule]", "0"}], "}"}], ",", 
      "repl", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl", ",", "v"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl", ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", "2"}], "}"}]}], "]"}], ",", "repl2", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl2", ",", "v"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Eq5", "//.", "repltmp"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537492560482047*^9, 3.537492572712871*^9}, 
   3.537493267055489*^9}],

Cell[BoxData[
 RowBox[{"repl3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T5", "[", "v", "]"}], ",", 
        RowBox[{"a5", "[", "v", "]"}], ",", 
        RowBox[{"h5", "[", "v", "]"}], ",", 
        RowBox[{"p5", "[", "v", "]"}], ",", 
        RowBox[{"S5", "[", "v", "]"}], ",", 
        RowBox[{"T5", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537492237653405*^9, 3.537492248948183*^9}, {
  3.53749258274236*^9, 3.537492583625291*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "5"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"repltmp", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "'"}], "[", "v", "]"}], "\[Rule]", "0"}], "}"}], ",", 
      "repl", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl", ",", "v"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl", ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", "2"}], "}"}]}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl", ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", "3"}], "}"}]}], "]"}], ",", "repl2", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl2", ",", "v"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl2", ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", "2"}], "}"}]}], "]"}], ",", "repl3", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl3", ",", "v"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Eq5", "//.", "repltmp"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537492560482047*^9, 3.537492572712871*^9}, {
   3.537492784281299*^9, 3.5374928039519253`*^9}, 3.537493274018837*^9}],

Cell[BoxData[
 RowBox[{"repl4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T6", "[", "v", "]"}], ",", 
        RowBox[{"a6", "[", "v", "]"}], ",", 
        RowBox[{"h6", "[", "v", "]"}], ",", 
        RowBox[{"p6", "[", "v", "]"}], ",", 
        RowBox[{"S6", "[", "v", "]"}], ",", 
        RowBox[{"T6", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537492237653405*^9, 3.537492248948183*^9}, {
  3.53749258274236*^9, 3.537492583625291*^9}, {3.53749280997325*^9, 
  3.537492818444707*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "3"}], "}"}]}], "]"}], "/.", "repltmp"}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"h", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "3"}], "}"}]}], "]"}], "/.", "repltmp"}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "4"}], "}"}]}], "]"}], "/.", "repltmp"}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "4"}], "}"}]}], "]"}], "/.", "repltmp"}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "4"}], "}"}]}], "]"}], "/.", "repltmp"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.537493510732931*^9, 3.53749356426119*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"p", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "/.", "repltmp"}], 
    "]"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "/.", "repltmp"}], 
    "]"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "/.", "repltmp"}], 
    "]"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "/.", "repltmp"}], 
    "]"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Normal", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "/.", "repltmp"}], 
   "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5374928365914*^9, 3.5374929059121637`*^9}, {
  3.5374933513754997`*^9, 3.537493363628664*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"p2", "[", "v", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"h2", "[", "v", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["p2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"h2", "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox[
              RowBox[{"a0", "[", "v", "]"}], "2"]}], " ", 
            RowBox[{"p2", "[", "v", "]"}]}], "+", 
           RowBox[{
            RowBox[{"h2", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["a0", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"a0", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["p2", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], ")"}]}], 
     "+", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"a0", "[", "v", "]"}], "3"]}], " ", 
         RowBox[{"h2", "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{"T3", "[", "v", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"a1", "[", "v", "]"}], " ", 
            RowBox[{"p2", "[", "v", "]"}]}], "-", 
           RowBox[{"3", " ", 
            RowBox[{"p2", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["a0", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{"3", " ", 
            RowBox[{
             SuperscriptBox["h2", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["p2", 
          TagBox[
           RowBox[{"(", "3", ")"}],
           Derivative],
          MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"h2", "[", "v", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"a0", "[", "v", "]"}]}], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{"h2", "[", "v", "]"}]}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"8", " ", 
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "3"], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"T3", "[", "v", "]"}]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"3", " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"a1", "[", "v", "]"}], " ", 
            RowBox[{"h2", "[", "v", "]"}]}], "+", 
           RowBox[{"3", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"h2", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["a0", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["p2", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["h2", 
          TagBox[
           RowBox[{"(", "3", ")"}],
           Derivative],
          MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"a1", "[", "v", "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"p2", "[", "v", "]"}], "2"]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "30"], " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"p2", "[", "v", "]"}], "2"]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"h2", "[", "v", "]"}], "2"], " ", 
            RowBox[{
             SuperscriptBox["a0", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{
            RowBox[{"p2", "[", "v", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"p2", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["a0", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"a0", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["p2", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["h2", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"h2", "[", "v", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{"a0", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["h2", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["p2", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"1", "+", 
     RowBox[{
      FractionBox["1", "12"], " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"a1", "[", "v", "]"}], "2"]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"p2", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"T3", "[", "v", "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"h2", "[", "v", "]"}]}], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     SuperscriptBox["z", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"h2", "[", "v", "]"}], "2"]}], "-", 
       SuperscriptBox[
        RowBox[{"p2", "[", "v", "]"}], "2"]}], ")"}]}], "-", 
    RowBox[{
     FractionBox["3", "10"], " ", 
     SuperscriptBox["z", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"p2", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["p2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.537492963821166*^9, 3.537493045909999*^9}, {
  3.5374932879492693`*^9, 3.537493317604496*^9}, {3.5374933681066713`*^9, 
  3.537493395425406*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq4", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq5", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537492560482047*^9, 3.537492572712871*^9}, {
  3.53749294172685*^9, 3.537492958193097*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "]"}]], "Input",
 CellChangeTimes->{{3.537493027333661*^9, 3.537493033148741*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", " ", "=", " ", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", " ", 
       RowBox[{"p1", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"p2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"p3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"p4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"p5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"h2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"h3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"h4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"h5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"a1", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"a2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"a3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"a4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"a5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], 
      RowBox[{"T2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"T3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"T4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"T5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], 
     RowBox[{"S2", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "3"}], " ", 
     RowBox[{"S3", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "4"}], " ", 
     RowBox[{"S4", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "5"}], " ", 
     RowBox[{"S5", "[", "v", "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
  3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
  3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
  3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
  3.537490237348768*^9}, {3.537490394647192*^9, 3.537490453890482*^9}, {
  3.537490792048935*^9, 3.537490804720195*^9}, {3.537490860205984*^9, 
  3.537490863100896*^9}, {3.5374908962097483`*^9, 3.537490902905895*^9}, {
  3.537491099280459*^9, 3.5374911037619123`*^9}, {3.5374911421214113`*^9, 
  3.537491208593452*^9}, {3.537577393872981*^9, 3.537577398304707*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Const1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Const2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Const3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq4", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"Eq5", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", 
      RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
  3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
  3.537489829726491*^9}}],

Cell[BoxData[
 RowBox[{"repl", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "'"}], "[", "v", "]"}], ",", 
        RowBox[{"S2", "[", "v", "]"}], ",", 
        RowBox[{"T2", "[", "v", "]"}], ",", 
        RowBox[{"a2", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537577513364431*^9, 3.537577544243544*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", " ", "=", " ", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", " ", 
       RowBox[{"p1", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"p2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"p3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"p4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"p5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"h2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"h3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"h4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"h5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"a1", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"h2", "[", "v", "]"}]}], " ", 
        RowBox[{"p1", "[", "v", "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"a3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"a4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"a5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", 
        SuperscriptBox[
         RowBox[{"p1", "[", "v", "]"}], "2"]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"T3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"T4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"T5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       SuperscriptBox[
        RowBox[{"p1", "[", "v", "]"}], "2"]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "3"}], " ", 
     RowBox[{"S3", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "4"}], " ", 
     RowBox[{"S4", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "5"}], " ", 
     RowBox[{"S5", "[", "v", "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
  3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
  3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
  3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
  3.537490237348768*^9}, {3.537490394647192*^9, 3.537490453890482*^9}, {
  3.537490792048935*^9, 3.537490804720195*^9}, {3.537490860205984*^9, 
  3.537490863100896*^9}, {3.5374908962097483`*^9, 3.537490902905895*^9}, {
  3.537491099280459*^9, 3.5374911037619123`*^9}, {3.5374911421214113`*^9, 
  3.537491208593452*^9}, {3.537577393872981*^9, 3.537577398304707*^9}, {
  3.537577484472924*^9, 3.5375774969987288`*^9}, {3.537577575335558*^9, 
  3.537577594057679*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "2"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"repltmp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"a1", "'"}], "[", "v", "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"p1", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"h2", "[", "v", "]"}], "+", 
         RowBox[{
          RowBox[{"a0", "[", "v", "]"}], " ", 
          RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Eq5", "//.", "repltmp"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
  3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
  3.537489829726491*^9}, {3.5374913369695187`*^9, 3.537491383848136*^9}, {
  3.537492455743868*^9, 3.537492509807266*^9}, {3.537492710362728*^9, 
  3.537492710514277*^9}, {3.537492765776664*^9, 3.537492765928492*^9}, {
  3.537493169402782*^9, 3.537493175233514*^9}, {3.537493221945931*^9, 
  3.5374932250087757`*^9}, {3.537577455742991*^9, 3.537577457366817*^9}, {
  3.5375775669894953`*^9, 3.537577567909832*^9}}],

Cell[BoxData[
 RowBox[{"repl", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
        "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"h3", "[", "v", "]"}], ",", 
       RowBox[{"p3", "[", "v", "]"}], ",", 
       RowBox[{"S3", "[", "v", "]"}], ",", 
       RowBox[{"a3", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537489831616275*^9, 3.5374898801274137`*^9}, {
  3.537491317375599*^9, 3.537491321759262*^9}, {3.537492699591785*^9, 
  3.537492702071735*^9}, {3.5375776114741364`*^9, 3.537577623767392*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "3"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"repltmp", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "'"}], "[", "v", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", "[", "v", "]"}], "+", 
           RowBox[{
            RowBox[{"a0", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}]}], "}"}], ",", "repl", 
      ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl", ",", "v"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Eq5", "//.", "repltmp"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
   3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
   3.537489829726491*^9}, {3.5374913369695187`*^9, 3.537491383848136*^9}, {
   3.537492455743868*^9, 3.537492509807266*^9}, {3.537492710362728*^9, 
   3.537492710514277*^9}, {3.537492765776664*^9, 3.537492765928492*^9}, {
   3.53749324118568*^9, 3.537493241384499*^9}, 3.537577642100482*^9}],

Cell[BoxData[
 RowBox[{"repl2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"T3", "'"}], "[", "v", "]"}], ",", 
        RowBox[{"a4", "[", "v", "]"}], ",", 
        RowBox[{"h4", "[", "v", "]"}], ",", 
        RowBox[{"p4", "[", "v", "]"}], ",", 
        RowBox[{"S4", "[", "v", "]"}], ",", 
        RowBox[{"T4", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5374914244686213`*^9, 3.537491468167574*^9}, {
  3.5374915105206013`*^9, 3.537491548039349*^9}, {3.537492546503677*^9, 
  3.537492546942692*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"repltmp", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "'"}], "[", "v", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", "[", "v", "]"}], "+", 
           RowBox[{
            RowBox[{"a0", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}]}], "}"}], ",", "repl", 
      ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl", ",", "v"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl", ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", "2"}], "}"}]}], "]"}], ",", "repl2", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl2", ",", "v"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Eq5", "//.", "repltmp"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537492560482047*^9, 3.537492572712871*^9}, 
   3.537493267055489*^9, {3.537577657018985*^9, 3.5375776839549417`*^9}}],

Cell[BoxData[
 RowBox[{"repl3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T5", "[", "v", "]"}], ",", 
        RowBox[{"a5", "[", "v", "]"}], ",", 
        RowBox[{"h5", "[", "v", "]"}], ",", 
        RowBox[{"p5", "[", "v", "]"}], ",", 
        RowBox[{"S5", "[", "v", "]"}], ",", 
        RowBox[{"T5", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537492237653405*^9, 3.537492248948183*^9}, {
  3.53749258274236*^9, 3.537492583625291*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repltmp", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"a1", "'"}], "[", "v", "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"p1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"h2", "[", "v", "]"}], "+", 
          RowBox[{
           RowBox[{"a0", "[", "v", "]"}], " ", 
           RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}]}], "}"}], ",", "repl", 
     ",", 
     RowBox[{"D", "[", 
      RowBox[{"repl", ",", "v"}], "]"}], ",", 
     RowBox[{"D", "[", 
      RowBox[{"repl", ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"D", "[", 
      RowBox[{"repl", ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "3"}], "}"}]}], "]"}], ",", "repl2", ",", 
     RowBox[{"D", "[", 
      RowBox[{"repl2", ",", "v"}], "]"}], ",", 
     RowBox[{"D", "[", 
      RowBox[{"repl2", ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "2"}], "}"}]}], "]"}], ",", "repl3", ",", 
     RowBox[{"D", "[", 
      RowBox[{"repl3", ",", "v"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.53757813482145*^9, 3.537578165436287*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "3"}], "}"}]}], "]"}], "/.", "repltmp"}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"h", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "3"}], "}"}]}], "]"}], "/.", "repltmp"}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "4"}], "}"}]}], "]"}], "/.", "repltmp"}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "4"}], "}"}]}], "]"}], "/.", "repltmp"}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "4"}], "}"}]}], "]"}], "/.", "repltmp"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.537493510732931*^9, 3.53749356426119*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"p", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "/.", "repltmp"}], 
    "]"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "/.", "repltmp"}], 
    "]"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "/.", "repltmp"}], 
    "]"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "/.", "repltmp"}], 
    "]"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Normal", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "/.", "repltmp"}], 
   "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5374928365914*^9, 3.5374929059121637`*^9}, {
  3.5374933513754997`*^9, 3.537493363628664*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{"p1", "[", "v", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"p2", "[", "v", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"h2", "[", "v", "]"}]}], "+", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "3"], "2"], "+", 
        RowBox[{
         SuperscriptBox["p2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{"h2", "[", "v", "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"a0", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"T3", "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"8", " ", 
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "12"], " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "3"], " ", 
         RowBox[{"h2", "[", "v", "]"}]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"a1", "[", "v", "]"}], "2"], " ", 
         RowBox[{"p1", "[", "v", "]"}]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox[
          RowBox[{"h2", "[", "v", "]"}], "2"], " ", 
         RowBox[{"p1", "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "5"]}], "+", 
        RowBox[{"6", " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"p2", "[", "v", "]"}], "2"]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{"T3", "[", "v", "]"}]}], "+", 
        RowBox[{"12", " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["a0", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{"8", " ", 
            RowBox[{
             SuperscriptBox["h2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"T3", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"8", " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["p1", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "3"]}], "-", 
           RowBox[{"3", " ", 
            RowBox[{
             SuperscriptBox["p2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"13", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"17", " ", 
            RowBox[{"h2", "[", "v", "]"}], " ", 
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "2"]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               RowBox[{"p2", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["a0", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "+", 
              RowBox[{
               RowBox[{"a1", "[", "v", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  RowBox[{"p2", "[", "v", "]"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p1", "\[Prime]",
                   MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "-", 
              
              RowBox[{"3", " ", 
               RowBox[{
                SuperscriptBox["h2", "\[Prime]\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["p2", 
           TagBox[
            RowBox[{"(", "3", ")"}],
            Derivative],
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"h2", "[", "v", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "2"]}], " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{"h2", "[", "v", "]"}]}], "+", 
        RowBox[{"9", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"]}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "3"]}], "-", 
           RowBox[{"8", " ", 
            RowBox[{
             SuperscriptBox["p2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "12"], " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "3"], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "+", 
        RowBox[{"14", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"T3", "[", "v", "]"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "3"], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"a1", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}]}], "-", 
           RowBox[{"6", " ", 
            RowBox[{
             SuperscriptBox["h2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"20", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"12", " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "3"]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["p2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["p1", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], " ", 
            RowBox[{"a1", "[", "v", "]"}], " ", 
            RowBox[{"h2", "[", "v", "]"}]}], "+", 
           RowBox[{
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{"T3", "[", "v", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "4"}], " ", 
               RowBox[{"p2", "[", "v", "]"}]}], "+", 
              RowBox[{"9", " ", 
               RowBox[{
                SuperscriptBox["p1", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "-", 
           
           RowBox[{"12", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"h2", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["a0", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["p2", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["h2", 
           TagBox[
            RowBox[{"(", "3", ")"}],
            Derivative],
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"a1", "[", "v", "]"}]}], "-", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"p1", "[", "v", "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"p1", "[", "v", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "12"], " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"h2", "[", "v", "]"}], "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"p2", "[", "v", "]"}], "2"]}], "+", 
           RowBox[{"8", " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{"p2", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["a0", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "-", 
           RowBox[{
            RowBox[{"p2", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{
            RowBox[{"a1", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               RowBox[{"p2", "[", "v", "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["p1", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"h2", "[", "v", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "5"}], " ", 
               SuperscriptBox[
                RowBox[{"p1", "[", "v", "]"}], "3"]}], "+", 
              RowBox[{
               SuperscriptBox["p2", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h2", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
       ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "30"], " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "3"], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "-", 
        RowBox[{"24", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"T3", "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"h2", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "4"], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p2", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"19", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "3"], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"16", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"12", " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox[
             RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
           RowBox[{"9", " ", 
            RowBox[{"a0", "[", "v", "]"}], " ", 
            RowBox[{"h2", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "2"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox[
             RowBox[{"p2", "[", "v", "]"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"p2", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p1", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{"11", " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p1", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox[
              RowBox[{"p1", "[", "v", "]"}], "2"]}], " ", 
            RowBox[{"T3", "[", "v", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{"p2", "[", "v", "]"}]}], "-", 
              RowBox[{"9", " ", 
               RowBox[{
                SuperscriptBox["p1", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
           
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"h2", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["h2", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "+", 
              RowBox[{
               RowBox[{"p2", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["p2", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
           
           RowBox[{"12", " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"h2", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["a0", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["p2", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], 
          ")"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", 
           TagBox[
            RowBox[{"(", "3", ")"}],
            Derivative],
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"1", "-", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"p1", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"T3", "[", "v", "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "12"], " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"a1", "[", "v", "]"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
           RowBox[{"6", " ", 
            RowBox[{"a0", "[", "v", "]"}], " ", 
            RowBox[{"h2", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}]}], "+", 
           SuperscriptBox[
            RowBox[{"p1", "[", "v", "]"}], "4"], "+", 
           RowBox[{"2", " ", 
            RowBox[{"p2", "[", "v", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p2", "[", "v", "]"}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["p1", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
           
           RowBox[{"2", " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
       ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            RowBox[{"h2", "[", "v", "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"a0", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "3"], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{"T3", "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{"3", " ", 
            RowBox[{"h2", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p1", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     SuperscriptBox["z", "2"], " ", 
     SuperscriptBox[
      RowBox[{"p1", "[", "v", "]"}], "2"]}], "-", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     SuperscriptBox["z", "3"], " ", 
     RowBox[{"p1", "[", "v", "]"}], " ", 
     RowBox[{"p2", "[", "v", "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "96"], " ", 
     SuperscriptBox["z", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", 
        SuperscriptBox[
         RowBox[{"h2", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"24", " ", 
        RowBox[{"a0", "[", "v", "]"}], " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"p1", "[", "v", "]"}]}], "-", 
       RowBox[{"11", " ", 
        SuperscriptBox[
         RowBox[{"p1", "[", "v", "]"}], "4"]}], "-", 
       RowBox[{"16", " ", 
        SuperscriptBox[
         RowBox[{"p2", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"24", " ", 
        RowBox[{"p1", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["p2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "60"], " ", 
     SuperscriptBox["z", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"p1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"h2", "[", "v", "]"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"a0", "[", "v", "]"}], " ", 
           RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox[
         RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
        RowBox[{"p1", "[", "v", "]"}], " ", 
        RowBox[{"p2", "[", "v", "]"}]}], "-", 
       RowBox[{"17", " ", 
        SuperscriptBox[
         RowBox[{"p1", "[", "v", "]"}], "3"], " ", 
        RowBox[{"p2", "[", "v", "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
        RowBox[{"T3", "[", "v", "]"}]}], "-", 
       RowBox[{"8", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"p1", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["a0", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"18", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"16", " ", 
        RowBox[{"a0", "[", "v", "]"}], " ", 
        RowBox[{"p1", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox[
         RowBox[{"p1", "[", "v", "]"}], "3"], " ", 
        RowBox[{
         SuperscriptBox["p1", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"18", " ", 
        RowBox[{"p2", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["p2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"8", " ", 
        RowBox[{"p1", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["p2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.537492963821166*^9, 3.537493045909999*^9}, {
  3.5374932879492693`*^9, 3.537493317604496*^9}, {3.5374933681066713`*^9, 
  3.537493395425406*^9}, {3.537578226128375*^9, 3.537578265829267*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq4", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq5", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537492560482047*^9, 3.537492572712871*^9}, {
  3.53749294172685*^9, 3.537492958193097*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"crepl", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a1", "'"}], "[", "v", "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"p1", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"h2", "[", "v", "]"}], "+", 
         RowBox[{
          RowBox[{"a0", "[", "v", "]"}], " ", 
          RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T3", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"p1", "[", "v", "]"}]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"a0", "[", "v", "]"}], " ", 
          RowBox[{"h2", "[", "v", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
          RowBox[{"p1", "[", "v", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], "-", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.537578295515046*^9, 3.5375782975235357`*^9}, {
  3.537578376610682*^9, 3.5375783769473963`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", "tmp1", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "tmp2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"tmp3", "/.", "crepl"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"tmp4", "/.", "crepl"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"tmp5", "/.", "crepl"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"tmp6", "/.", "crepl"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "tmp7", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "tmp8", "]"}]}], "Input",
 CellChangeTimes->{{3.5375783064344482`*^9, 3.537578349339065*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Dynamic AdS/CMT - Superconductor - Spectral - Numerial Ansatz\
\>", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
   3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
   3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
   3.495174647742872*^9, 3.460515504326817*^9}, {3.503996600043788*^9, 
   3.503996603042028*^9}, {3.507011572545054*^9, 3.460340667971311*^9}, {
   3.5374843541262083`*^9, 3.537484358716886*^9}, 3.537484391202265*^9, {
   3.537484629914453*^9, 3.537484630281348*^9}, {3.5374893532274837`*^9, 
   3.537489358050692*^9}, {3.53749388933057*^9, 3.537493890193932*^9}, {
   3.537578587160997*^9, 3.5375785895997057`*^9}, {3.537578682265374*^9, 
   3.537578682504321*^9}}],

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "^", "2"}]], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"-", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "0", "0"},
       {
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}], "0"},
       {"0", "0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.507011580676421*^9, 3.507011659804162*^9}, {3.507013755598536*^9, 
   3.460392698323369*^9}, {3.4604018613321533`*^9, 3.4604018646719627`*^9}, {
   3.460401965632374*^9, 3.460401968163259*^9}, {3.4604023388162813`*^9, 
   3.4604023558966084`*^9}, {3.460402422665003*^9, 3.460402426690833*^9}, {
   3.460402628586185*^9, 3.4604026419139843`*^9}, {3.460402674350209*^9, 
   3.4604026844332027`*^9}, {3.460512773931822*^9, 3.460512787444798*^9}, {
   3.4605146484667263`*^9, 3.460514650350994*^9}, {3.460514717258254*^9, 
   3.460514724283691*^9}, 3.460514770989304*^9, 3.4605223140457373`*^9, {
   3.4605327188171663`*^9, 3.460532727004561*^9}, {3.460532863547011*^9, 
   3.460532865145266*^9}, {3.460532977769042*^9, 3.4605329860852757`*^9}, {
   3.507275497143169*^9, 3.4603659980232763`*^9}, {3.537484515197036*^9, 
   3.537484572210073*^9}, 3.537484644682625*^9, {3.5374846959240923`*^9, 
   3.537484701892157*^9}, {3.537484976337736*^9, 3.5374849917355137`*^9}, {
   3.537486594817341*^9, 3.537486596777007*^9}}],

Cell[BoxData["Gd"], "Input"],

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",\

 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",\

 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[BoxData[
 RowBox[{
  RowBox[{"R2", "=", 
   RowBox[{"Simplify", "[", "R2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041067188341103`*^9, 3.404106720182616*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"GT", "[", 
       RowBox[{"R2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "A", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"A", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"A", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"v", ",", "d"}], "}"}], "}"}], ",", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"ST", "[", 
    RowBox[{"A", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"z", ",", "d"}], "}"}], "}"}], ",", 
     RowBox[{"az", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451383976248069*^9, 3.4513840125908737`*^9}, {
  3.451384057147691*^9, 3.451384064689735*^9}, {3.451385762395092*^9, 
  3.451385762480318*^9}, {3.451385800913571*^9, 3.451385805770357*^9}, {
  3.537484677141605*^9, 3.53748468964509*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "F", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"F", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"F", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}]}], "}"}], ",", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i2", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i1", "]"}], "]"}]}], "]"}]}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4041040239360247`*^9, 3.404104073416904*^9}, {
  3.4041057167733383`*^9, 3.4041057183570337`*^9}, {3.4513840707957897`*^9, 
  3.451384164343499*^9}, {3.460366100458836*^9, 3.460366108909464*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"trFF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"trT", "[", 
      RowBox[{
       RowBox[{"outerT", "[", 
        RowBox[{"F", ",", "F"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fsqr", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"trT", "[", 
     RowBox[{"trFF", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.404103126230957*^9, 3.404103206051724*^9}, 
   3.404103788928409*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "Dp", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"Dp", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Dp", "=", 
       RowBox[{"ST", "[", 
        RowBox[{"Dp", ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], "}"}], ",", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"\[Phi]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
          RowBox[{"I", " ", 
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], 
           RowBox[{"\[Phi]", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConjDp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "d", "}"}], ",", 
      RowBox[{"Conjugate", "[", 
       RowBox[{"Dp", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DpDp", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{"trT", "[", 
       RowBox[{
        RowBox[{"outerT", "[", 
         RowBox[{"ConjDp", ",", "Dp"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Vterm", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"\[Phi]", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "]"}], 
       RowBox[{"\[Phi]", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513844331121693`*^9, 3.451384521665413*^9}, {
   3.451384560554626*^9, 3.451384642158163*^9}, {3.4513849100950413`*^9, 
   3.451384915054587*^9}, 3.451385051803838*^9, {3.4513851171366262`*^9, 
   3.45138511927711*^9}, {3.451385175930884*^9, 3.451385183167452*^9}, {
   3.451385425505906*^9, 3.45138544324051*^9}, {3.451385490350021*^9, 
   3.451385493946774*^9}, {3.451385568392873*^9, 3.451385601054823*^9}, {
   3.451385813165941*^9, 3.4513858527683163`*^9}, {3.45138608116168*^9, 
   3.451386103913107*^9}, {3.46036707784975*^9, 3.460255762501432*^9}, {
   3.46025580130457*^9, 3.460255801461816*^9}, {3.53748492894665*^9, 
   3.53748495518618*^9}, {3.537485329580826*^9, 3.537485331297533*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DpDp", "=", 
   RowBox[{"(", 
    RowBox[{"DpDp", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Re", "[", "xx_", "]"}], "\[Rule]", "xx"}], ",", 
       RowBox[{
        RowBox[{"Im", "[", "xx_", "]"}], "\[Rule]", "0"}]}], "}"}]}], ")"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.451385894732107*^9, 3.451385976334114*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sqrtdetg", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Det", "[", 
       RowBox[{"-", "Gd"}], "]"}], "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041041692972*^9, 3.404104211096949*^9}, 
   3.404105293940057*^9, {3.4513842180130997`*^9, 3.4513842223260803`*^9}, {
   3.4513846617079067`*^9, 3.451384675916638*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"sqrtdetg", 
    RowBox[{"(", 
     RowBox[{"Ricci", "+", "6", "-", 
      RowBox[{
       FractionBox["1", "4"], "Fsqr"}], "-", "DpDp", "-", "Vterm"}], 
     ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.451384367735067*^9, 3.451384393946628*^9}, {
   3.4513849054437723`*^9, 3.4513849068431387`*^9}, {3.451385606138598*^9, 
   3.451385607193993*^9}, 3.460366276193363*^9, {3.4603670917067547`*^9, 
   3.460255829896731*^9}, 3.537493905932642*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp1", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp3", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.53748653613297*^9, 3.5374865918283*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GHBT", "+=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
     "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460366441552243*^9, 3.460366544772176*^9}, {
  3.4603665879440317`*^9, 3.460366626391823*^9}, {3.537486655723679*^9, 
  3.537486732610427*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L2", "=", 
   RowBox[{"L", "-", "GHBT"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460366546941235*^9, 3.460366557341961*^9}, 
   3.460366686117609*^9, {3.4603672960654507`*^9, 3.4603672977104673`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"L2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.460366666517003*^9, 3.460366674775579*^9}, {3.537486746662644*^9, 
  3.5374867639666147`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EOM", "[", "fld_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{"D", "[", 
      RowBox[{"L2", ",", "fld"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"tmp2", "=", 
           RowBox[{"D", "[", 
            RowBox[{"fld", ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ")"}], "=!=", "0"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tmp", "-=", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"L2", ",", "tmp2"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "tmp"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.4513849546200113`*^9, 3.451385039242148*^9}, {
  3.4603662728020573`*^9, 3.460366273871294*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqp", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"p", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"\[Alpha]", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513848144544163`*^9, 3.4513848150159073`*^9}, {
  3.451384869337384*^9, 3.451384875673843*^9}, {3.451384929950244*^9, 
  3.451384930100154*^9}, {3.451385060851385*^9, 3.451385213396349*^9}, {
  3.451385293160893*^9, 3.451385302528058*^9}, {3.4513853749547167`*^9, 
  3.45138537639461*^9}, {3.451385514552088*^9, 3.451385527943191*^9}, {
  3.451385862306609*^9, 3.451385882826736*^9}, {3.451386138230373*^9, 
  3.451386140019012*^9}, {3.451386241895258*^9, 3.4513862693654633`*^9}, {
  3.4603675858592987`*^9, 3.4603675914720583`*^9}, {3.537486779881022*^9, 
  3.537486784922683*^9}, {3.537486894453556*^9, 3.5374869009568243`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqav", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"av", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"az", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513855403702793`*^9, 3.451385540823719*^9}, {
  3.4513861532442207`*^9, 3.45138616739637*^9}, {3.451386251199284*^9, 
  3.4513862656960487`*^9}, {3.460367593073217*^9, 3.460367597640524*^9}, {
  3.5374867866028214`*^9, 3.537486788378339*^9}, {3.537486891597521*^9, 
  3.537486937732339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqgvz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gvz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqgzz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gzz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqT", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"T", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqS", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451386275930722*^9, 3.451386303859261*^9}, {
  3.460366711720347*^9, 3.4603667226381903`*^9}, {3.460367599130735*^9, 
  3.460367611985876*^9}, {3.53748678993122*^9, 3.53748680663302*^9}, {
  3.537486911477583*^9, 3.5374869187572203`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"gvz", ",", "gzz", ",", "az"}], "]"}]], "Input",
 CellChangeTimes->{{3.53748694036823*^9, 3.537486945275868*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"gvz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gzz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"az", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}]}], "Input",
 CellChangeTimes->{{3.460366755240944*^9, 3.460366765921853*^9}, {
   3.460379717667384*^9, 3.460379720321673*^9}, {3.4603938524268913`*^9, 
   3.4603938546559877`*^9}, 3.4603939628549967`*^9, {3.5374868640225983`*^9, 
   3.537486876197587*^9}, {3.537486924492758*^9, 3.537486925572747*^9}, {
   3.537487030062772*^9, 3.537487030117689*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqp2", "=", 
   RowBox[{"Simplify", "[", "eqp", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]2", "=", 
   RowBox[{"Simplify", "[", "eq\[Alpha]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqav2", "=", 
   RowBox[{"Simplify", "[", "eqav", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz2", "=", 
   RowBox[{"Simplify", "[", "eqaz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgvz2", "=", 
   RowBox[{"Simplify", "[", "eqgvz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgzz2", "=", 
   RowBox[{"Simplify", "[", "eqgzz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqT2", "=", 
   RowBox[{"Simplify", "[", "eqT", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"eqS2", "=", 
  RowBox[{"Simplify", "[", "eqS", "]"}]}]}], "Input",
 CellChangeTimes->{{3.460366768598325*^9, 3.4603668525536737`*^9}, {
  3.5374869590367947`*^9, 3.537486972220312*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"z", "^", "3"}], "+", 
    RowBox[{
     FractionBox["1", "4"], 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", "eqp2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eq\[Alpha]2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqav2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqaz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqgvz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqgzz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqT2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "eqS2", "]"}]}], "Input",
 CellChangeTimes->{{3.507012905387106*^9, 3.507012910083256*^9}, {
  3.5070145245498*^9, 3.4603669411156473`*^9}, {3.5374870758129187`*^9, 
  3.5374870842285547`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"\[Alpha]", ",", "p", ",", "av", ",", "T", ",", "S"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4603676469897413`*^9, 3.460367657697607*^9}, {
  3.4603797352914047`*^9, 3.460379735508092*^9}, {3.5374870733721457`*^9, 
  3.537487073532263*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"z", " ", 
    RowBox[{"f", "[", 
     RowBox[{"v", ",", "z"}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"z", " ", 
    RowBox[{"h", "[", 
     RowBox[{"v", ",", "z"}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"m", "[", "v", "]"}], "-", 
    RowBox[{"q", " ", "z"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], 
     RowBox[{"a", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], " ", 
     RowBox[{"t", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"z", "^", "2"}], " ", 
    RowBox[{"s", "[", 
     RowBox[{"v", ",", "z"}], "]"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.537494166786066*^9, 3.537494209239134*^9}, 
   3.5375534855250597`*^9}],

Cell[BoxData[
 RowBox[{"Evsol", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqgvz2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqS2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqp2", "\[Equal]", "0"}], ",", 
        RowBox[{"eq\[Alpha]2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqaz", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4603794747692738`*^9, 3.4603795051117373`*^9}, {
   3.460379770556391*^9, 3.460379778090231*^9}, {3.537487575145343*^9, 
   3.537487601737835*^9}, {3.5374876320607243`*^9, 3.537487632172414*^9}, 
   3.5374876986147537`*^9, {3.537494224185582*^9, 3.537494230128457*^9}, {
   3.537494336674205*^9, 3.537494337210093*^9}}],

Cell[BoxData[
 RowBox[{"Momsol", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqT2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqgzz", "\[Equal]", "0"}], ",", 
        RowBox[{"eqav", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.460379791348405*^9, 3.460379854266864*^9}, {
  3.537487577120059*^9, 3.537487629667873*^9}, {3.5374877038531513`*^9, 
  3.537487709515881*^9}, {3.537494238680642*^9, 3.53749424053545*^9}, {
  3.5374943297700453`*^9, 3.537494330345728*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqT2", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqav", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"eqgzz", ",", "z"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"Evsol", ",", "v"}], "]"}]}], "/.", "Evsol"}], "/.", "Momsol"}],
   "]"}]}], "Input",
 CellChangeTimes->{{3.460379877349128*^9, 3.460379983100644*^9}, {
  3.460380087445326*^9, 3.460380091873478*^9}, {3.537487726936469*^9, 
  3.5374877500015907`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Const1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Const2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Const3", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["s", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["s", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.46031768644937*^9, 3.46031772334064*^9}, {
  3.537487772329159*^9, 3.5374878178010073`*^9}, {3.537494258424617*^9, 
  3.537494262447569*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Eq1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq3", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq4", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq5", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["t", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["t", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.537489066732723*^9, 3.5374891410817547`*^9}, {
  3.537494265681246*^9, 3.537494272120749*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "deriv", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"deriv", "[", "X_", "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"X", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "X"}], ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<v\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "z"}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<z\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"X", "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], ",", "z"}], 
        "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<vz\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"v", ",", "2"}], "}"}]}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<vv\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "2"}], "}"}]}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<zz\>\""}], "]"}]}]}],
      "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"deriv", "[", "j", "]"}]}], "Input",
 CellChangeTimes->{{3.537488129955064*^9, 3.537488303539091*^9}, 
   3.537565624076147*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"m", "[", "v", "]"}], "\[Rule]", "m"}], "}"}], ",", 
     RowBox[{"deriv", "[", "f", "]"}], ",", 
     RowBox[{"deriv", "[", "a", "]"}], ",", 
     RowBox[{"deriv", "[", "h", "]"}], ",", 
     RowBox[{"deriv", "[", "t", "]"}], ",", 
     RowBox[{"deriv", "[", "s", "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460533850988061*^9, 3.460317762594681*^9}, {
  3.460317899777432*^9, 3.460317913876012*^9}, {3.4603179946260138`*^9, 
  3.460317994880909*^9}, {3.460318028461433*^9, 3.4603180359232483`*^9}, {
  3.5374878304982758`*^9, 3.537487855625393*^9}, {3.53748801305739*^9, 
  3.537488044943592*^9}, {3.537488108469489*^9, 3.537488111403976*^9}, {
  3.5374883167609386`*^9, 3.537488354940011*^9}, {3.537494360528582*^9, 
  3.537494365432303*^9}, {3.5374953043244743`*^9, 3.5374953101843863`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"C1str", "=", "\"\<\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"C2str", "=", "\"\<\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C3str", "=", "\"\<\>\""}], ";"}]}], "Input",
 CellChangeTimes->{{3.537552090430543*^9, 3.537552100935237*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Eq1", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq1str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489304806736*^9, 3.537489309341483*^9}, {
   3.5374972785438137`*^9, 3.537497285903635*^9}, {3.537540737136909*^9, 
   3.537540745480649*^9}, 3.5375407900484257`*^9, {3.537541358740419*^9, 
   3.537541372163848*^9}, {3.5375414874019747`*^9, 3.537541501177627*^9}, {
   3.537541543216469*^9, 3.537541545224094*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Eq2", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq2str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537551719171803*^9, 3.537551720666493*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Eq3", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq3str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537551722346656*^9, 3.537551723954479*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Eq4", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq4str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537551725538599*^9, 3.537551726962449*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Eq5", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq5str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5375517285546923`*^9, 3.537551730078916*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<~/Work/AdSCMTDyn/matlab/eqn.text\>\"", ",", 
   RowBox[{
   "\"\<\\n\\neq1 = \>\"", "<>", "Eq1str", "<>", "\"\< ; \\n\\neq2 = \>\"", "<>",
     "Eq2str", "<>", "\"\< ; \\n\\neq3 = \>\"", "<>", "Eq3str", "<>", 
    "\"\< ; \\n\\neq4 = \>\"", "<>", "Eq4str", "<>", 
    "\"\< ; \\n\\neq5 = \>\"", "<>", "Eq5str", "<>", 
    "\"\< ; \\n\\nconst1 = \>\"", "<>", "C1str", "<>", 
    "\"\< ; \\n\\nconst2 = \>\"", "<>", "C2str", "<>", 
    "\"\< ; \\n\\nconst3 = \>\"", "<>", "C3str", "<>", "\"\< ; \\n\\n\>\""}], 
   ",", "\"\<string\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.537499515937183*^9, 3.5374995738978567`*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Dynamic AdS/CMT - Superconductor - Spectral - Numerial Ansatz II\
\>", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
   3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
   3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
   3.495174647742872*^9, 3.460515504326817*^9}, {3.503996600043788*^9, 
   3.503996603042028*^9}, {3.507011572545054*^9, 3.460340667971311*^9}, {
   3.5374843541262083`*^9, 3.537484358716886*^9}, 3.537484391202265*^9, {
   3.537484629914453*^9, 3.537484630281348*^9}, {3.5374893532274837`*^9, 
   3.537489358050692*^9}, {3.53749388933057*^9, 3.537493890193932*^9}, {
   3.537578587160997*^9, 3.5375785895997057`*^9}, {3.537578682265374*^9, 
   3.537578682504321*^9}, {3.537578812305402*^9, 3.537578812720454*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[BoxData["\<\"hmm\"\>"], "Print",
 CellChangeTimes->{3.53880794268043*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
   "gzz"}], "}"}]], "Output",
 CellChangeTimes->{3.538807942880889*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"gtt", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "grr", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "g\[Theta]\[Theta]", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "g\[Phi]\[Phi]", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "gzz"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538807942882306*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{3.538807942964953*^9}],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{3.538807942966185*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538807943254242*^9}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{3.538807943255474*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "^", "2"}]], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"-", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "0", "0"},
       {
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}], "0"},
       {"0", "0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.507011580676421*^9, 3.507011659804162*^9}, {3.507013755598536*^9, 
   3.460392698323369*^9}, {3.4604018613321533`*^9, 3.4604018646719627`*^9}, {
   3.460401965632374*^9, 3.460401968163259*^9}, {3.4604023388162813`*^9, 
   3.4604023558966084`*^9}, {3.460402422665003*^9, 3.460402426690833*^9}, {
   3.460402628586185*^9, 3.4604026419139843`*^9}, {3.460402674350209*^9, 
   3.4604026844332027`*^9}, {3.460512773931822*^9, 3.460512787444798*^9}, {
   3.4605146484667263`*^9, 3.460514650350994*^9}, {3.460514717258254*^9, 
   3.460514724283691*^9}, 3.460514770989304*^9, 3.4605223140457373`*^9, {
   3.4605327188171663`*^9, 3.460532727004561*^9}, {3.460532863547011*^9, 
   3.460532865145266*^9}, {3.460532977769042*^9, 3.4605329860852757`*^9}, {
   3.507275497143169*^9, 3.4603659980232763`*^9}, {3.537484515197036*^9, 
   3.537484572210073*^9}, 3.537484644682625*^9, {3.5374846959240923`*^9, 
   3.537484701892157*^9}, {3.537484976337736*^9, 3.5374849917355137`*^9}, {
   3.537486594817341*^9, 3.537486596777007*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     FractionBox[
      RowBox[{"gzz", "[", 
       RowBox[{"v", ",", "z"}], "]"}], 
      SuperscriptBox["z", "2"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5388079438542337`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]], "Output",
 CellChangeTimes->{3.5388079438571377`*^9}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.538807943859365*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gd"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     FractionBox[
      RowBox[{"gzz", "[", 
       RowBox[{"v", ",", "z"}], "]"}], 
      SuperscriptBox["z", "2"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807943934894*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
       RowBox[{
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"T", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}]], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["z", "2"], 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["z", "2"], 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807944009327*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
      RowBox[{
       RowBox[{"gzz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
   SuperscriptBox["z", "8"]]}]], "Output",
 CellChangeTimes->{3.538807944075788*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[BoxData[
 RowBox[{
  RowBox[{"R2", "=", 
   RowBox[{"Simplify", "[", "R2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041067188341103`*^9, 3.404106720182616*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"GT", "[", 
       RowBox[{"R2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "A", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"A", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"A", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"v", ",", "d"}], "}"}], "}"}], ",", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"ST", "[", 
    RowBox[{"A", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"z", ",", "d"}], "}"}], "}"}], ",", 
     RowBox[{"az", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451383976248069*^9, 3.4513840125908737`*^9}, {
  3.451384057147691*^9, 3.451384064689735*^9}, {3.451385762395092*^9, 
  3.451385762480318*^9}, {3.451385800913571*^9, 3.451385805770357*^9}, {
  3.537484677141605*^9, 3.53748468964509*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "F", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"F", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"F", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}]}], "}"}], ",", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i2", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i1", "]"}], "]"}]}], "]"}]}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4041040239360247`*^9, 3.404104073416904*^9}, {
  3.4041057167733383`*^9, 3.4041057183570337`*^9}, {3.4513840707957897`*^9, 
  3.451384164343499*^9}, {3.460366100458836*^9, 3.460366108909464*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"trFF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"trT", "[", 
      RowBox[{
       RowBox[{"outerT", "[", 
        RowBox[{"F", ",", "F"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fsqr", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"trT", "[", 
     RowBox[{"trFF", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.404103126230957*^9, 3.404103206051724*^9}, 
   3.404103788928409*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "Dp", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"Dp", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Dp", "=", 
       RowBox[{"ST", "[", 
        RowBox[{"Dp", ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], "}"}], ",", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"\[Phi]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
          RowBox[{"I", " ", 
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], 
           RowBox[{"\[Phi]", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConjDp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "d", "}"}], ",", 
      RowBox[{"Conjugate", "[", 
       RowBox[{"Dp", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DpDp", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{"trT", "[", 
       RowBox[{
        RowBox[{"outerT", "[", 
         RowBox[{"ConjDp", ",", "Dp"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Vterm", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"\[Phi]", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "]"}], 
       RowBox[{"\[Phi]", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513844331121693`*^9, 3.451384521665413*^9}, {
   3.451384560554626*^9, 3.451384642158163*^9}, {3.4513849100950413`*^9, 
   3.451384915054587*^9}, 3.451385051803838*^9, {3.4513851171366262`*^9, 
   3.45138511927711*^9}, {3.451385175930884*^9, 3.451385183167452*^9}, {
   3.451385425505906*^9, 3.45138544324051*^9}, {3.451385490350021*^9, 
   3.451385493946774*^9}, {3.451385568392873*^9, 3.451385601054823*^9}, {
   3.451385813165941*^9, 3.4513858527683163`*^9}, {3.45138608116168*^9, 
   3.451386103913107*^9}, {3.46036707784975*^9, 3.460255762501432*^9}, {
   3.46025580130457*^9, 3.460255801461816*^9}, {3.53748492894665*^9, 
   3.53748495518618*^9}, {3.537485329580826*^9, 3.537485331297533*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DpDp", "=", 
   RowBox[{"(", 
    RowBox[{"DpDp", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Re", "[", "xx_", "]"}], "\[Rule]", "xx"}], ",", 
       RowBox[{
        RowBox[{"Im", "[", "xx_", "]"}], "\[Rule]", "0"}]}], "}"}]}], ")"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.451385894732107*^9, 3.451385976334114*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sqrtdetg", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Det", "[", 
       RowBox[{"-", "Gd"}], "]"}], "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041041692972*^9, 3.404104211096949*^9}, 
   3.404105293940057*^9, {3.4513842180130997`*^9, 3.4513842223260803`*^9}, {
   3.4513846617079067`*^9, 3.451384675916638*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"sqrtdetg", 
    RowBox[{"(", 
     RowBox[{"Ricci", "+", "6", "-", 
      RowBox[{
       FractionBox["1", "4"], "Fsqr"}], "-", "DpDp", "-", "Vterm"}], 
     ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.451384367735067*^9, 3.451384393946628*^9}, {
   3.4513849054437723`*^9, 3.4513849068431387`*^9}, {3.451385606138598*^9, 
   3.451385607193993*^9}, 3.460366276193363*^9, {3.4603670917067547`*^9, 
   3.460255829896731*^9}, 3.537493905932642*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp1", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp3", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.53748653613297*^9, 3.5374865918283*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GHBT", "+=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
     "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460366441552243*^9, 3.460366544772176*^9}, {
  3.4603665879440317`*^9, 3.460366626391823*^9}, {3.537486655723679*^9, 
  3.537486732610427*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L2", "=", 
   RowBox[{"L", "-", "GHBT"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460366546941235*^9, 3.460366557341961*^9}, 
   3.460366686117609*^9, {3.4603672960654507`*^9, 3.4603672977104673`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"L2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.460366666517003*^9, 3.460366674775579*^9}, {3.537486746662644*^9, 
  3.5374867639666147`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949746984*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949749422*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949751644*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"EOM", "[", "fld_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{"D", "[", 
      RowBox[{"L2", ",", "fld"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"tmp2", "=", 
           RowBox[{"D", "[", 
            RowBox[{"fld", ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ")"}], "=!=", "0"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tmp", "-=", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"L2", ",", "tmp2"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "tmp"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.4513849546200113`*^9, 3.451385039242148*^9}, {
  3.4603662728020573`*^9, 3.460366273871294*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqp", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"p", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"\[Alpha]", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513848144544163`*^9, 3.4513848150159073`*^9}, {
  3.451384869337384*^9, 3.451384875673843*^9}, {3.451384929950244*^9, 
  3.451384930100154*^9}, {3.451385060851385*^9, 3.451385213396349*^9}, {
  3.451385293160893*^9, 3.451385302528058*^9}, {3.4513853749547167`*^9, 
  3.45138537639461*^9}, {3.451385514552088*^9, 3.451385527943191*^9}, {
  3.451385862306609*^9, 3.451385882826736*^9}, {3.451386138230373*^9, 
  3.451386140019012*^9}, {3.451386241895258*^9, 3.4513862693654633`*^9}, {
  3.4603675858592987`*^9, 3.4603675914720583`*^9}, {3.537486779881022*^9, 
  3.537486784922683*^9}, {3.537486894453556*^9, 3.5374869009568243`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqav", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"av", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"az", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513855403702793`*^9, 3.451385540823719*^9}, {
  3.4513861532442207`*^9, 3.45138616739637*^9}, {3.451386251199284*^9, 
  3.4513862656960487`*^9}, {3.460367593073217*^9, 3.460367597640524*^9}, {
  3.5374867866028214`*^9, 3.537486788378339*^9}, {3.537486891597521*^9, 
  3.537486937732339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqgvz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gvz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqgzz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gzz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqT", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"T", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqS", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451386275930722*^9, 3.451386303859261*^9}, {
  3.460366711720347*^9, 3.4603667226381903`*^9}, {3.460367599130735*^9, 
  3.460367611985876*^9}, {3.53748678993122*^9, 3.53748680663302*^9}, {
  3.537486911477583*^9, 3.5374869187572203`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"gvz", ",", "gzz", ",", "az"}], "]"}]], "Input",
 CellChangeTimes->{{3.53748694036823*^9, 3.537486945275868*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"gvz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gzz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"az", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}]}], "Input",
 CellChangeTimes->{{3.460366755240944*^9, 3.460366765921853*^9}, {
   3.460379717667384*^9, 3.460379720321673*^9}, {3.4603938524268913`*^9, 
   3.4603938546559877`*^9}, 3.4603939628549967`*^9, {3.5374868640225983`*^9, 
   3.537486876197587*^9}, {3.537486924492758*^9, 3.537486925572747*^9}, {
   3.537487030062772*^9, 3.537487030117689*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqp2", "=", 
   RowBox[{"Simplify", "[", "eqp", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]2", "=", 
   RowBox[{"Simplify", "[", "eq\[Alpha]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqav2", "=", 
   RowBox[{"Simplify", "[", "eqav", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz2", "=", 
   RowBox[{"Simplify", "[", "eqaz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgvz2", "=", 
   RowBox[{"Simplify", "[", "eqgvz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgzz2", "=", 
   RowBox[{"Simplify", "[", "eqgzz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqT2", "=", 
   RowBox[{"Simplify", "[", "eqT", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"eqS2", "=", 
  RowBox[{"Simplify", "[", "eqS", "]"}]}]}], "Input",
 CellChangeTimes->{{3.460366768598325*^9, 3.4603668525536737`*^9}, {
  3.5374869590367947`*^9, 3.537486972220312*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}]], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"S", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "4"], 
       SuperscriptBox["z", "8"]]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"p", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"av", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"\[Alpha]", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["S", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"S", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"\[Alpha]", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["\[Alpha]", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"T", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], " ", 
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["S", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{
              SuperscriptBox["S", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["S", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"S", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"\[Alpha]", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["av", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["T", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"T", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                RowBox[{
                 SuperscriptBox["p", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "-", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["p", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"2", " ", "z", " ", 
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"S", "[", 
    RowBox[{"v", ",", "z"}], "]"}]], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", " ", 
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"S", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["av", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               RowBox[{
                SuperscriptBox["\[Alpha]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["\[Alpha]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079501869287`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["av", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["av", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["z", "6"], " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]]}]]], "Output",
 CellChangeTimes->{3.53880795026598*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["z", "14"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "4"], 
        SuperscriptBox["z", "8"]]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "7"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["av", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["av", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.538807950269804*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "2"]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"\[Alpha]", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["av", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "6"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
     "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.538807950351424*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "2"]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"av", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"T", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{"\[Alpha]", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"T", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "6"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"12", "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"p", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"\[Alpha]", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["z", "4"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["av", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{"4", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{"z", " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
     "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox[
          RowBox[{"T", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{
              SuperscriptBox["T", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"2", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.538807950620874*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["z", "6"], " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]]}]]], "Output",
 CellChangeTimes->{3.538807950683655*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["z", "16"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "4"], 
        SuperscriptBox["z", "8"]]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "6"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"\[Alpha]", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["av", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"av", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"8", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"av", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"6", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079507546873`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"z", "^", "3"}], "+", 
    RowBox[{
     FractionBox["1", "4"], 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", "eqp2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eq\[Alpha]2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqav2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqaz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqgvz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqgzz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqT2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "eqS2", "]"}]}], "Input",
 CellChangeTimes->{{3.507012905387106*^9, 3.507012910083256*^9}, {
  3.5070145245498*^9, 3.4603669411156473`*^9}, {3.5374870758129187`*^9, 
  3.5374870842285547`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.53880795094726*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950949555*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950951844*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950954144*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950956482*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950958794*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.5388079509610987`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"\[Alpha]", ",", "p", ",", "av", ",", "T", ",", "S"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4603676469897413`*^9, 3.460367657697607*^9}, {
  3.4603797352914047`*^9, 3.460379735508092*^9}, {3.5374870733721457`*^9, 
  3.537487073532263*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"z", " ", 
    RowBox[{"f", "[", 
     RowBox[{"v", ",", "z"}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"z", " ", 
    RowBox[{"h", "[", 
     RowBox[{"v", ",", "z"}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"m", "[", "v", "]"}], "+", 
    RowBox[{"z", " ", 
     RowBox[{"a", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], " ", 
     RowBox[{"t", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"z", "^", "2"}], " ", 
    RowBox[{"s", "[", 
     RowBox[{"v", ",", "z"}], "]"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.537494166786066*^9, 3.537494209239134*^9}, 
   3.5375534855250597`*^9, {3.537578844859714*^9, 3.537578847402349*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Evsol", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqgvz2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqS2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqp2", "\[Equal]", "0"}], ",", 
        RowBox[{"eq\[Alpha]2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqaz", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4603794747692738`*^9, 3.4603795051117373`*^9}, {
   3.460379770556391*^9, 3.460379778090231*^9}, {3.537487575145343*^9, 
   3.537487601737835*^9}, {3.5374876320607243`*^9, 3.537487632172414*^9}, 
   3.5374876986147537`*^9, {3.537494224185582*^9, 3.537494230128457*^9}, {
   3.537494336674205*^9, 3.537494337210093*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"z", " ", 
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"m", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "z", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["z", "3"], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["z", "3"], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "z", " ", 
              RowBox[{"m", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"4", "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "3"], " ", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "2"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             RowBox[{"4", " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", "z", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "3"], " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"4", " ", "z", " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["z", "3"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "z", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["z", "3"], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           SuperscriptBox["z", "3"], " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"4", " ", "z", " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}]], 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], 
          SuperscriptBox["z", "2"]]}], "-", 
        RowBox[{
         FractionBox["1", 
          SuperscriptBox["z", "2"]], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"a", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"f", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
               SuperscriptBox[
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"f", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
             RowBox[{"m", "[", "v", "]"}]}], "+", 
            RowBox[{
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], " ", 
                RowBox[{"m", "[", "v", "]"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                RowBox[{
                 SuperscriptBox["h", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "-", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["a", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["t", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", 
         RowBox[{
          SuperscriptBox["z", "3"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"a", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
          RowBox[{"6", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "3"], " ", 
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"m", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
       RowBox[{"z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "z", " ", 
           SuperscriptBox[
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "z"}], " ", 
              RowBox[{"m", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"6", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "-", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["z", "2"]}], " ", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["a", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["z", "6"]}], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["z", "2"], "+", 
                   RowBox[{
                    SuperscriptBox["z", "6"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", 
                   RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"6", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                   RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["s", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                   RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
             "+", 
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"4", "+", 
                   RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"z", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["z", "3"]}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                   RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "4"]}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"12", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
         RowBox[{
          SuperscriptBox["z", "4"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["a", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"f", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}]}], 
           ")"}]}], "+", 
         FractionBox[
          RowBox[{"16", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}]], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["z", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["t", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}]], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["z", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["s", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
             RowBox[{"2", " ", "z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]]}], 
        ")"}]}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807968763275*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Momsol", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqT2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqgzz", "\[Equal]", "0"}], ",", 
        RowBox[{"eqav", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.460379791348405*^9, 3.460379854266864*^9}, {
  3.537487577120059*^9, 3.537487629667873*^9}, {3.5374877038531513`*^9, 
  3.537487709515881*^9}, {3.537494238680642*^9, 3.53749424053545*^9}, {
  3.5374943297700453`*^9, 3.537494330345728*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"z", "+", 
        RowBox[{
         SuperscriptBox["z", "3"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "3"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]}]}], 
   ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"2", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "2"], "+", 
          RowBox[{
           SuperscriptBox["z", "4"], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox[
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"32", " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"f", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"h", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"t", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"m", "[", "v", "]"}], "2"]}], "+", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"4", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "3"], " ", 
         RowBox[{"a", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"m", "[", "v", "]"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["a", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"m", "[", "v", "]"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"f", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{"m", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"m", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "z", " ", 
            SuperscriptBox[
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"m", "[", "v", "]"}], "2"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
              RowBox[{"3", " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
               SuperscriptBox[
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"z", " ", 
               RowBox[{"m", "[", "v", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["t", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}], "-", 
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["t", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["z", "4"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "4"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}]}], 
                ")"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                 RowBox[{"2", " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                 RowBox[{"2", " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                ")"}]}], "-", 
              RowBox[{"z", " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                 RowBox[{"4", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "z"}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                    RowBox[{"z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "6"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{"16", "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["z", "4"], " ", 
                  SuperscriptBox[
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["z", "6"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "z"}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                 RowBox[{"4", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", 
                  SuperscriptBox["z", "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
                 "-", 
                 RowBox[{"2", " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "20"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "6"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                    RowBox[{"2", " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
                 "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                   ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}]}], 
   ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], ")"}]}], 
        "+", 
        RowBox[{"8", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807992285688*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqT2", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqav", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"eqgzz", ",", "z"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"Evsol", ",", "v"}], "]"}]}], "/.", "Evsol"}], "/.", "Momsol"}],
   "]"}]}], "Input",
 CellChangeTimes->{{3.460379877349128*^9, 3.460379983100644*^9}, {
  3.460380087445326*^9, 3.460380091873478*^9}, {3.537487726936469*^9, 
  3.5374877500015907`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807993193884*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538808034120454*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Const1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Const2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Const3", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["s", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["s", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.46031768644937*^9, 3.46031772334064*^9}, {
  3.537487772329159*^9, 3.5374878178010073`*^9}, {3.537494258424617*^9, 
  3.537494262447569*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "2"]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], ")"}]}], "+", 
     RowBox[{"8", " ", "z", " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388080342469997`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"z", "+", 
     RowBox[{
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]}]], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["z", "3"], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["a", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388080342514267`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["z", "2"], "+", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"32", " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"f", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              SuperscriptBox[
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"m", "[", "v", "]"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"4", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"m", "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["a", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"m", "[", "v", "]"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{"m", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"m", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "z", " ", 
         SuperscriptBox[
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"m", "[", "v", "]"}], "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
           RowBox[{"3", " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
            SuperscriptBox[
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            RowBox[{"m", "[", "v", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "-", 
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["z", "4"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
              RowBox[{
               SuperscriptBox["z", "4"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["h", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "3"], " ", 
                   RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}]}], 
             ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{"z", " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["z", "3"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["a", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "z"}], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                 RowBox[{"z", " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "6"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
                 "+", 
                 RowBox[{"2", " ", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
           "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{"16", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "4"], " ", 
               SuperscriptBox[
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["z", "6"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                 RowBox[{"4", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "3"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "z"}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                   ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "3"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                 RowBox[{"2", " ", "z", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}], "+", 
                 RowBox[{"4", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["a", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["z", "2"], " ", 
               SuperscriptBox[
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"2", " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "20"}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "6"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                    RowBox[{"2", " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"2", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388080342638597`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Eq1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq3", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq4", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq5", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["t", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["t", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.537489066732723*^9, 3.5374891410817547`*^9}, {
  3.537494265681246*^9, 3.537494272120749*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{"z", " ", 
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"m", "[", "v", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["z", "3"], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "z", " ", 
             RowBox[{"m", "[", "v", "]"}], " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{"4", "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "3"], " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "2"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            RowBox[{"4", " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["t", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.538808034338485*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["z", "3"], " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["h", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.538808034352503*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}]], 
    RowBox[{"z", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], 
         SuperscriptBox["z", "2"]]}], "-", 
       RowBox[{
        FractionBox["1", 
         SuperscriptBox["z", "2"]], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            RowBox[{"a", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"f", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              SuperscriptBox[
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"m", "[", "v", "]"}]}], "+", 
           RowBox[{
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"m", "[", "v", "]"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"f", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}]}], "+", 
  RowBox[{
   SuperscriptBox["a", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.538808034366467*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"8", " ", 
     SuperscriptBox["z", "4"]}]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"12", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
      RowBox[{
       SuperscriptBox["z", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "6"}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}]}], ")"}]}], 
      "+", 
      FractionBox[
       RowBox[{"16", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]], "-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]]}], ")"}]}]}], 
  "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.538808034377557*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["t", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}], "-", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", 
       RowBox[{
        SuperscriptBox["z", "3"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{"6", " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], "+", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"m", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "z", " ", 
         SuperscriptBox[
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "z"}], " ", 
            RowBox[{"m", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["z", "2"]}], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["a", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["z", "6"]}], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["a", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["z", "2"], "+", 
                 RowBox[{
                  SuperscriptBox["z", "6"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "2"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["s", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "-", 
                 RowBox[{"2", " ", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
           "+", 
           RowBox[{"2", " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"4", "+", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"z", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["z", "3"]}], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.538808034390798*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "deriv", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"deriv", "[", "X_", "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"X", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "X"}], ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<v\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "z"}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<z\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"X", "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], ",", "z"}], 
        "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<vz\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"v", ",", "2"}], "}"}]}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<vv\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "2"}], "}"}]}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<zz\>\""}], "]"}]}]}],
      "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"deriv", "[", "j", "]"}]}], "Input",
 CellChangeTimes->{{3.537488129955064*^9, 3.537488303539091*^9}, 
   3.537565624076147*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"j", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "j"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jv"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jz"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jvz"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"2", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jvv"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jzz"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5388080344525146`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"m", "[", "v", "]"}], "\[Rule]", "m"}], "}"}], ",", 
     RowBox[{"deriv", "[", "f", "]"}], ",", 
     RowBox[{"deriv", "[", "a", "]"}], ",", 
     RowBox[{"deriv", "[", "h", "]"}], ",", 
     RowBox[{"deriv", "[", "t", "]"}], ",", 
     RowBox[{"deriv", "[", "s", "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460533850988061*^9, 3.460317762594681*^9}, {
  3.460317899777432*^9, 3.460317913876012*^9}, {3.4603179946260138`*^9, 
  3.460317994880909*^9}, {3.460318028461433*^9, 3.4603180359232483`*^9}, {
  3.5374878304982758`*^9, 3.537487855625393*^9}, {3.53748801305739*^9, 
  3.537488044943592*^9}, {3.537488108469489*^9, 3.537488111403976*^9}, {
  3.5374883167609386`*^9, 3.537488354940011*^9}, {3.537494360528582*^9, 
  3.537494365432303*^9}, {3.5374953043244743`*^9, 3.5374953101843863`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Eq1", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq1str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489304806736*^9, 3.537489309341483*^9}, {
   3.5374972785438137`*^9, 3.537497285903635*^9}, {3.537540737136909*^9, 
   3.537540745480649*^9}, 3.5375407900484257`*^9, {3.537541358740419*^9, 
   3.537541372163848*^9}, {3.5375414874019747`*^9, 3.537541501177627*^9}, {
   3.537541543216469*^9, 3.537541545224094*^9}}],

Cell[BoxData["\<\"fvz - (fzz - 2.*hz.*m + 4.*f.*s - h.*z.*(2.*m.*(2.*s + \
sz.*z) + az.*(1 + s.*power(z,2))) - a.*(2.*hz.*z.*(1 + s.*power(z,2)) + h.*(1 \
+ 5.*s.*power(z,2) + 2.*sz.*power(z,3))) + z.*(2.*fz.*t - 2.*fz.*sv.*z - \
2.*fv.*sz.*z + 2.*fz.*sz.*z + fzz.*t.*z + fz.*tz.*z + f.*(-2.*sv + tz + \
s.*z.*(4.*t + tz.*z) + 2.*sz.*(1 + t.*power(z,2))) + 2.*fz.*sz.*t.*power(z,3) \
+ s.*(-4.*fv - 2.*hz.*m.*z + fzz.*z.*(1 + t.*power(z,2)) + fz.*(4 + \
6.*t.*power(z,2) + tz.*power(z,3))))).*power(2 + 2.*s.*power(z,2),-1)\"\>"], \
"Output",
 CellChangeTimes->{3.538808034531695*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Eq2", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq2str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537551719171803*^9, 3.537551720666493*^9}}],

Cell[BoxData["\<\"hvz - (hzz + 2.*fz.*m + az.*f.*z - 4.*hv.*s.*z + \
4.*hz.*s.*z + 4.*f.*m.*s.*z + 2.*hz.*t.*z + h.*tz.*z - 2.*sv.*z.*(h + hz.*z) \
+ hzz.*s.*power(z,2) + 2.*fz.*m.*s.*power(z,2) - 2.*hv.*sz.*power(z,2) + \
2.*hz.*sz.*power(z,2) + 2.*f.*m.*sz.*power(z,2) + hzz.*t.*power(z,2) + \
hz.*tz.*power(z,2) + 2.*h.*sz.*z.*(1 + t.*power(z,2)) + az.*f.*s.*power(z,3) \
+ 6.*hz.*s.*t.*power(z,3) + h.*s.*(4 + 4.*t.*power(z,2) + tz.*power(z,3)) + \
a.*(2.*fz.*z.*(1 + s.*power(z,2)) + f.*(1 + 5.*s.*power(z,2) + \
2.*sz.*power(z,3))) + hzz.*s.*t.*power(z,4) + 2.*hz.*sz.*t.*power(z,4) + \
hz.*s.*tz.*power(z,4)).*power(2 + 2.*s.*power(z,2),-1)\"\>"], "Output",
 CellChangeTimes->{3.538808034586948*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Eq3", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq3str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537551722346656*^9, 3.537551723954479*^9}}],

Cell[BoxData["\<\"avz - z.*(-2.*sv.*(a + az.*z) - av.*power(z,-2).*(1 + \
s.*power(z,2)) - 2.*power(z,-2).*(1 + s.*power(z,2)).*(m.*power(f,2) + \
a.*z.*(power(f,2) + power(h,2)) + h.*(fv + h.*m - fz.*(1 + t.*power(z,2))) + \
f.*(-hv + hz.*(1 + t.*power(z,2))))).*power(1 + s.*power(z,2),-1)\"\>"], \
"Output",
 CellChangeTimes->{3.538808034636338*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Eq4", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq4str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537551725538599*^9, 3.537551726962449*^9}}],

Cell[BoxData["\<\"svz + (power(z,-4).*(1 + s.*power(z,2)).*(12 + 4.*(2.*t + \
tz.*z).*power(z,2) + 4.*power(f,2).*power(z,2) + 4.*power(h,2).*power(z,2) - \
power(z,4).*power(a + az.*z,2) + 2.*(1 + t.*power(z,2)).*(-6 + \
power(z,2).*power(f + fz.*z,2) + power(z,2).*power(h + hz.*z,2)) - 4.*(2.*s + \
sz.*z).*(-2.*sv.*z + (2.*s + sz.*z).*(1 + \
t.*power(z,2))).*power(z,4).*power(1 + s.*power(z,2),-2) + 16.*(2.*s + \
sz.*z).*power(z,2).*(1 + t.*power(z,2)).*power(1 + s.*power(z,2),-1) - \
4.*(2.*s + sz.*z).*(2.*t + tz.*z).*power(z,4).*power(1 + \
s.*power(z,2),-1)))/8.\"\>"], "Output",
 CellChangeTimes->{3.538808034686864*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Eq5", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq5str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5375517285546923`*^9, 3.537551730078916*^9}}],

Cell[BoxData["\<\"tzz - (-2.*(6.*s - t + power(h,2)) + \
power(a,2).*power(z,2).*power(1 + s.*power(z,2),2) - 2.*power(f,2).*(1 + \
t.*power(z,2)).*power(1 + s.*power(z,2),2) - 2.*f.*z.*(-fv + hz.*m.*z + \
2.*fz.*(1 + t.*power(z,2))).*power(1 + s.*power(z,2),2) + 2.*a.*(az + fz.*h - \
f.*hz).*power(z,3).*power(1 + s.*power(z,2),2) - z.*(2.*(-2.*sv + 6.*sz + tz) \
+ 2.*z.*power(h,2).*(t + s.*(2 + s.*power(z,2)).*(1 + t.*power(z,2))) + \
z.*(-(power(az,2).*power(z,2)) + 2.*(-(fv.*fz) - hv.*hz + szz + power(hz,2) - \
sz.*(-2.*sv + sz).*power(z,2) + power(fz,2).*(1 + t.*power(z,2)) + \
t.*z.*(6.*sz + z.*(szz + power(hz,2) - power(sz,2).*power(z,2)))) + \
2.*s.*(z.*(2.*(sv + sz + tz) + (2.*fz.*(-fv + fz) + 2.*hz.*(-hv + hz) + \
szz).*z - power(az,2).*power(z,3)) + t.*(4 + (szz.*z + 2.*(sz + \
z.*(power(fz,2) + power(hz,2)))).*power(z,3))) + power(s,2).*(2.*(2 + (tz + \
z.*(-(fv.*fz) - hv.*hz + power(fz,2) + power(hz,2))).*power(z,3)) - \
power(az,2).*power(z,6) + 2.*t.*(power(z,2) + (power(fz,2) + \
power(hz,2)).*power(z,6)))) + 2.*h.*(-hv - fz.*m.*z + 2.*hz.*(1 + \
t.*power(z,2))).*power(1 + s.*power(z,2),2))).*power(z + \
s.*power(z,3),-2)\"\>"], "Output",
 CellChangeTimes->{3.538807898663368*^9, 3.538808034774719*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Const1", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"C1str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489304806736*^9, 3.537489309341483*^9}, {
   3.5374972785438137`*^9, 3.537497285903635*^9}, {3.537540737136909*^9, 
   3.537540745480649*^9}, 3.5375407900484257`*^9, {3.537541358740419*^9, 
   3.537541372163848*^9}, {3.5375414874019747`*^9, 3.537541501177627*^9}, {
   3.537541543216469*^9, 3.537541545224094*^9}, {3.538807876854679*^9, 
   3.538807885102872*^9}}],

Cell[BoxData["\<\"szz + (power(z,-2).*(4.*s + 8.*sz.*z + 2.*f.*fz.*z.*(1 + \
s.*power(z,2)) + power(f,2).*(1 + s.*power(z,2)) + (1 + \
s.*power(z,2)).*(power(fz,2).*power(z,2) + power(h + hz.*z,2))))/2.\"\>"], \
"Output",
 CellChangeTimes->{3.53880803482358*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Const2", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"C2str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5388078907580767`*^9, 3.538807892116951*^9}}],

Cell[BoxData["\<\"azz + 2.*(a.*z.*(2.*s + sz.*z) - (fz.*h - f.*hz).*(1 + \
s.*power(z,2)) + az.*(1 + 3.*s.*power(z,2) + sz.*power(z,3))).*power(z + \
s.*power(z,3),-1)\"\>"], "Output",
 CellChangeTimes->{3.5388080348711023`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Const3", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"C3str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.538807893564623*^9, 3.538807895276726*^9}}],

Cell[BoxData["\<\"svv + ((32.*s - 4.*t + 6.*power(h,2) + \
power(a,2).*power(z,2).*(-1 + (-t + 4.*(power(f,2) + \
power(h,2))).*power(z,2)).*power(1 + s.*power(z,2),2) + \
4.*f.*z.*(-2.*hv.*m.*z + (1 + t.*power(z,2)).*(-fv + hz.*m.*z + fz.*(1 + \
t.*power(z,2)))).*power(1 + s.*power(z,2),2) + 2.*power(f,2).*(3 + \
power(z,2).*(2.*power(m,2) + t.*(4 + t.*power(z,2)))).*power(1 + \
s.*power(z,2),2) + 2.*a.*(4.*m.*power(f,2) - az.*(1 + t.*power(z,2)) + \
2.*h.*(2.*fv + 2.*h.*m - fz.*(1 + t.*power(z,2))) + 2.*f.*(-2.*hv + hz.*(1 + \
t.*power(z,2)))).*power(z,3).*power(1 + s.*power(z,2),2) + z.*(4.*(-4.*sv + \
4.*sz + tv + tz) + 4.*h.*(m.*z.*(2.*fv - fz.*(1 + t.*power(z,2))) + (1 + \
t.*power(z,2)).*(-hv + hz.*(1 + t.*power(z,2)))).*power(1 + s.*power(z,2),2) \
+ 2.*z.*power(h,2).*(3.*s.*(2 + s.*power(z,2)) + 4.*t.*power(1 + \
s.*power(z,2),2) + 2.*power(m,2).*power(1 + s.*power(z,2),2) + \
power(t,2).*power(z,2).*power(1 + s.*power(z,2),2)) + z.*(2.*(-2.*fv.*fz - \
2.*hv.*hz + power(fz,2) + 2.*(power(fv,2) + power(hv,2)) + power(hz,2)) - \
(power(az,2) + 4.*(-(sv.*tz) + sz.*(-2.*sv + tv + tz) + \
power(sz,2))).*power(z,2) - t.*z.*(power(az,2).*power(z,3) + 4.*(2.*sv - tz + \
fv.*fz.*z + hv.*hz.*z - z.*power(fz,2) - z.*power(hz,2) + sz.*(-6 + (-2.*sv + \
2.*sz + tz).*power(z,3)))) + power(s,2).*(16 - power(z,3).*(4.*(tv + tz) - \
2.*z.*(-2.*fv.*fz - 2.*hv.*hz + power(fz,2) + 2.*(power(fv,2) + power(hv,2)) \
+ power(hz,2)) + power(az,2).*power(z,3)) + 2.*power(t,2).*power(z,4).*(-2 + \
(power(fz,2) + power(hz,2)).*power(z,4)) - t.*power(z,2).*(4.*(-3 + (tz + \
fv.*fz.*z + (hv - hz).*hz.*z - z.*power(fz,2)).*power(z,3)) + \
power(az,2).*power(z,6))) + s.*(-2.*power(z,2).*(-2.*(-2.*fv.*fz - 2.*hv.*hz \
+ power(fz,2) + 2.*(power(fv,2) + power(hv,2)) + power(hz,2)) + (-2.*sv.*tz + \
2.*sz.*(tv + tz) + power(az,2)).*power(z,2)) + 4.*power(t,2).*power(z,2).*(2 \
+ (-2.*sz + z.*(power(fz,2) + power(hz,2))).*power(z,3)) - 2.*t.*(-20 + \
2.*power(z,3).*(-2.*sv + 2.*fv.*fz.*z + 2.*hv.*hz.*z - 2.*z.*power(fz,2) - \
2.*z.*power(hz,2) + sz.*(2 + tz.*power(z,3))) + power(az,2).*power(z,6))) + \
2.*power(t,2).*(power(fz,2).*power(z,4) + power(hz,2).*power(z,4) - \
2.*power(-1 + sz.*power(z,3),2))))).*power(power(z,2) + s.*power(z,4),-1))/8.\
\"\>"], "Output",
 CellChangeTimes->{3.538808034920526*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<~/Work/AdSCMTDyn2/matlab/eqn.text\>\"", ",", 
   RowBox[{
   "\"\<\\n\\neq1 = \>\"", "<>", "Eq1str", "<>", "\"\< ; \\n\\neq2 = \>\"", "<>",
     "Eq2str", "<>", "\"\< ; \\n\\neq3 = \>\"", "<>", "Eq3str", "<>", 
    "\"\< ; \\n\\neq4 = \>\"", "<>", "Eq4str", "<>", 
    "\"\< ; \\n\\neq5 = \>\"", "<>", "Eq5str", "<>", 
    "\"\< ; \\n\\nconst1 = \>\"", "<>", "C1str", "<>", 
    "\"\< ; \\n\\nconst2 = \>\"", "<>", "C2str", "<>", 
    "\"\< ; \\n\\nconst3 = \>\"", "<>", "C3str", "<>", "\"\< ; \\n\\n\>\""}], 
   ",", "\"\<string\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.537499515937183*^9, 3.5374995738978567`*^9}, 
   3.538808081344832*^9}],

Cell[BoxData["\<\"~/Work/AdSCMTDyn2/matlab/eqn.text\"\>"], "Output",
 CellChangeTimes->{3.538808035236641*^9, 3.538808081883874*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"f2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"f3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"f4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"f5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{"h2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"h3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"h4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"h5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"a1", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"a2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"a3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"a4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"a5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"t", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"t3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"t4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"t5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "4"]}], " ", 
     SuperscriptBox[
      RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], " ", "+", 
    RowBox[{"z", " ", 
     RowBox[{"s3", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], " ", 
     RowBox[{"s4", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "3"}], " ", 
     RowBox[{"s5", "[", "v", "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5375807547496643`*^9, 3.5375809546462297`*^9}, {
   3.5375810316510153`*^9, 3.5375810327382927`*^9}, 3.537581219874021*^9, {
   3.537581535999511*^9, 3.537581540295803*^9}, {3.537581711272689*^9, 
   3.537581738881206*^9}, 3.537582147695653*^9, {3.537582192382326*^9, 
   3.5375821924540586`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq4", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq5", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"Const3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5375809932541857`*^9, 3.537581041069994*^9}, {
  3.5375810809508543`*^9, 3.537581091428672*^9}, {3.537581792470584*^9, 
  3.53758183798702*^9}}],

Cell[BoxData[
 RowBox[{"repl1", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "'"}], "[", "v", "]"}], ",", 
        RowBox[{"a2", "[", "v", "]"}], ",", 
        RowBox[{"f3", "[", "v", "]"}], ",", 
        RowBox[{"h3", "[", "v", "]"}], ",", 
        RowBox[{"s3", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537581094869306*^9, 3.5375811411847267`*^9}, {
  3.537581846545319*^9, 3.5375818604809847`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"repl", "=", 
    RowBox[{"Join", "[", " ", 
     RowBox[{"repl1", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl1", ",", "v"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq5", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Const3", "/.", "repl"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537581149514593*^9, 3.5375811704734163`*^9}, {
  3.537581319335538*^9, 3.537581326214385*^9}, {3.53758187837607*^9, 
  3.5375818960440483`*^9}}],

Cell[BoxData[
 RowBox[{"repl2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"t3", "'"}], "[", "v", "]"}], ",", 
        RowBox[{"a3", "[", "v", "]"}], ",", 
        RowBox[{"t4", "[", "v", "]"}], ",", 
        RowBox[{"s4", "[", "v", "]"}], ",", 
        RowBox[{"h4", "[", "v", "]"}], ",", 
        RowBox[{"f4", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537581176657216*^9, 3.537581176712451*^9}, {
  3.537581208479423*^9, 3.5375812350544767`*^9}, {3.537581285831032*^9, 
  3.537581335172854*^9}, {3.537581579672551*^9, 3.537581582928306*^9}, {
  3.537581907656845*^9, 3.537581928696844*^9}, {3.53758196021669*^9, 
  3.537581962015414*^9}, {3.537582000083522*^9, 3.537582009971553*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"repl", "=", 
    RowBox[{"Join", "[", " ", 
     RowBox[{"repl1", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl1", ",", "v"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl1", ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", "2"}], "}"}]}], "]"}], ",", "repl2", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl2", ",", "v"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq5", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Const3", "//.", "repl"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537581149514593*^9, 3.5375811704734163`*^9}, {
  3.537581319335538*^9, 3.537581326214385*^9}, {3.53758187837607*^9, 
  3.5375818960440483`*^9}, {3.537582027350095*^9, 3.537582048852798*^9}, {
  3.537582117159115*^9, 3.537582123535061*^9}}],

Cell[BoxData[
 RowBox[{"repl3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a4", "[", "v", "]"}], ",", 
        RowBox[{"t5", "[", "v", "]"}], ",", 
        RowBox[{"s5", "[", "v", "]"}], ",", 
        RowBox[{"h5", "[", "v", "]"}], ",", 
        RowBox[{"f5", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537581176657216*^9, 3.537581176712451*^9}, {
  3.537581208479423*^9, 3.5375812350544767`*^9}, {3.537581285831032*^9, 
  3.537581335172854*^9}, {3.537581579672551*^9, 3.537581582928306*^9}, {
  3.537581907656845*^9, 3.537581928696844*^9}, {3.53758196021669*^9, 
  3.537581962015414*^9}, {3.537582000083522*^9, 3.537582009971553*^9}, {
  3.537582054866674*^9, 3.537582086618279*^9}, {3.5375821613248863`*^9, 
  3.5375822160917*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"bceq1", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "+", 
    RowBox[{"2", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "z"}], "]"}], "+", 
       RowBox[{
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}]}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.537582638122479*^9, 3.5375827515296707`*^9}, {
  3.537582794820052*^9, 3.537582800155078*^9}, {3.5375841048066683`*^9, 
  3.537584107478177*^9}, {3.537584358367179*^9, 3.537584371717182*^9}}],

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"bceq1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5375827543771067`*^9, 3.5375827552168913`*^9}, 
   3.537582807266088*^9}],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"tmp", "/.", "repl"}], "]"}]], "Input",
 CellChangeTimes->{{3.537582756209517*^9, 3.53758276104853*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"bceq2", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "+", 
    RowBox[{
     RowBox[{"m", "[", "v", "]"}], 
     RowBox[{"f", "[", 
      RowBox[{"v", ",", "z"}], "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"v", ",", "z"}], "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}]}], "-", 
    RowBox[{"z", " ", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "z"}], "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}]}], "-", " ", 
    RowBox[{"z", " ", 
     RowBox[{"f", "[", 
      RowBox[{"v", ",", "z"}], "]"}], " ", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "2"}], "}"}]}], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.537583454390378*^9, 3.537583584316988*^9}, {
  3.537583627792901*^9, 3.5375836286954517`*^9}, {3.53758367467208*^9, 
  3.537583682998909*^9}, {3.537583741939487*^9, 3.53758374254697*^9}, {
  3.537583789908886*^9, 3.53758380650729*^9}, {3.537583864503531*^9, 
  3.53758392754637*^9}, {3.537584157247345*^9, 3.5375841601333523`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"bceq2", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "+", 
    RowBox[{
     RowBox[{"m", "[", "v", "]"}], 
     RowBox[{"\[Sigma]", "[", "v", "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"\[Sigma]", "[", "v", "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}]}], "-", 
    RowBox[{"z", " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
     RowBox[{
      RowBox[{"\[Sigma]", "''"}], "[", "v", "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.537584449977281*^9, 3.537584540147512*^9}}],

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"bceq2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5375835627555237`*^9, 3.537583563483652*^9}, {
  3.5375837293866577`*^9, 3.537583730810493*^9}, {3.5375839307205544`*^9, 
  3.537583938135961*^9}}],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"tmp", "/.", "repl2"}], "]"}]], "Input",
 CellChangeTimes->{{3.537583943735824*^9, 3.537583946472803*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Dynamic AdS/CMT - Superconductor - Spectral - Broken phase\
\>", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
   3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
   3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
   3.495174647742872*^9, 3.460515504326817*^9}, {3.503996600043788*^9, 
   3.503996603042028*^9}, {3.507011572545054*^9, 3.460340667971311*^9}, {
   3.5374843541262083`*^9, 3.537484358716886*^9}, 3.537484391202265*^9, {
   3.537484629914453*^9, 3.537484630281348*^9}, {3.5374893532274837`*^9, 
   3.537489358050692*^9}, {3.5376274940424433`*^9, 3.537627498480837*^9}}],

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "^", "2"}]], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"-", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "0", "0"},
       {
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}], "0"},
       {"0", "0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.507011580676421*^9, 3.507011659804162*^9}, {3.507013755598536*^9, 
   3.460392698323369*^9}, {3.4604018613321533`*^9, 3.4604018646719627`*^9}, {
   3.460401965632374*^9, 3.460401968163259*^9}, {3.4604023388162813`*^9, 
   3.4604023558966084`*^9}, {3.460402422665003*^9, 3.460402426690833*^9}, {
   3.460402628586185*^9, 3.4604026419139843`*^9}, {3.460402674350209*^9, 
   3.4604026844332027`*^9}, {3.460512773931822*^9, 3.460512787444798*^9}, {
   3.4605146484667263`*^9, 3.460514650350994*^9}, {3.460514717258254*^9, 
   3.460514724283691*^9}, 3.460514770989304*^9, 3.4605223140457373`*^9, {
   3.4605327188171663`*^9, 3.460532727004561*^9}, {3.460532863547011*^9, 
   3.460532865145266*^9}, {3.460532977769042*^9, 3.4605329860852757`*^9}, {
   3.507275497143169*^9, 3.4603659980232763`*^9}, {3.537484515197036*^9, 
   3.537484572210073*^9}, 3.537484644682625*^9, {3.5374846959240923`*^9, 
   3.537484701892157*^9}, {3.537484976337736*^9, 3.5374849917355137`*^9}, {
   3.537486594817341*^9, 3.537486596777007*^9}}],

Cell[BoxData["Gd"], "Input"],

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",\

 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",\

 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[BoxData[
 RowBox[{
  RowBox[{"R2", "=", 
   RowBox[{"Simplify", "[", "R2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041067188341103`*^9, 3.404106720182616*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"GT", "[", 
       RowBox[{"R2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "A", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"A", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"A", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"v", ",", "d"}], "}"}], "}"}], ",", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"ST", "[", 
    RowBox[{"A", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"z", ",", "d"}], "}"}], "}"}], ",", 
     RowBox[{"az", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451383976248069*^9, 3.4513840125908737`*^9}, {
  3.451384057147691*^9, 3.451384064689735*^9}, {3.451385762395092*^9, 
  3.451385762480318*^9}, {3.451385800913571*^9, 3.451385805770357*^9}, {
  3.537484677141605*^9, 3.53748468964509*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "F", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"F", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"F", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}]}], "}"}], ",", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i2", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i1", "]"}], "]"}]}], "]"}]}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4041040239360247`*^9, 3.404104073416904*^9}, {
  3.4041057167733383`*^9, 3.4041057183570337`*^9}, {3.4513840707957897`*^9, 
  3.451384164343499*^9}, {3.460366100458836*^9, 3.460366108909464*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"trFF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"trT", "[", 
      RowBox[{
       RowBox[{"outerT", "[", 
        RowBox[{"F", ",", "F"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fsqr", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"trT", "[", 
     RowBox[{"trFF", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.404103126230957*^9, 3.404103206051724*^9}, 
   3.404103788928409*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "Dp", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"Dp", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Dp", "=", 
       RowBox[{"ST", "[", 
        RowBox[{"Dp", ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], "}"}], ",", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"\[Phi]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
          RowBox[{"I", " ", 
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], 
           RowBox[{"\[Phi]", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConjDp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "d", "}"}], ",", 
      RowBox[{"Conjugate", "[", 
       RowBox[{"Dp", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DpDp", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{"trT", "[", 
       RowBox[{
        RowBox[{"outerT", "[", 
         RowBox[{"ConjDp", ",", "Dp"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Vterm", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"\[Phi]", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "]"}], 
       RowBox[{"\[Phi]", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513844331121693`*^9, 3.451384521665413*^9}, {
   3.451384560554626*^9, 3.451384642158163*^9}, {3.4513849100950413`*^9, 
   3.451384915054587*^9}, 3.451385051803838*^9, {3.4513851171366262`*^9, 
   3.45138511927711*^9}, {3.451385175930884*^9, 3.451385183167452*^9}, {
   3.451385425505906*^9, 3.45138544324051*^9}, {3.451385490350021*^9, 
   3.451385493946774*^9}, {3.451385568392873*^9, 3.451385601054823*^9}, {
   3.451385813165941*^9, 3.4513858527683163`*^9}, {3.45138608116168*^9, 
   3.451386103913107*^9}, {3.46036707784975*^9, 3.460255762501432*^9}, {
   3.46025580130457*^9, 3.460255801461816*^9}, {3.53748492894665*^9, 
   3.53748495518618*^9}, {3.537485329580826*^9, 3.537485331297533*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DpDp", "=", 
   RowBox[{"(", 
    RowBox[{"DpDp", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Re", "[", "xx_", "]"}], "\[Rule]", "xx"}], ",", 
       RowBox[{
        RowBox[{"Im", "[", "xx_", "]"}], "\[Rule]", "0"}]}], "}"}]}], ")"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.451385894732107*^9, 3.451385976334114*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sqrtdetg", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Det", "[", 
       RowBox[{"-", "Gd"}], "]"}], "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041041692972*^9, 3.404104211096949*^9}, 
   3.404105293940057*^9, {3.4513842180130997`*^9, 3.4513842223260803`*^9}, {
   3.4513846617079067`*^9, 3.451384675916638*^9}}],

Cell[BoxData[
 RowBox[{"L", "=", 
  RowBox[{"sqrtdetg", 
   RowBox[{"(", 
    RowBox[{"Ricci", "+", "6", "-", 
     RowBox[{
      FractionBox["1", "4"], "Fsqr"}], "-", "DpDp", "-", "Vterm"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.451384367735067*^9, 3.451384393946628*^9}, {
   3.4513849054437723`*^9, 3.4513849068431387`*^9}, {3.451385606138598*^9, 
   3.451385607193993*^9}, 3.460366276193363*^9, {3.4603670917067547`*^9, 
   3.460255829896731*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp1", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp3", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.53748653613297*^9, 3.5374865918283*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GHBT", "+=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
     "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460366441552243*^9, 3.460366544772176*^9}, {
  3.4603665879440317`*^9, 3.460366626391823*^9}, {3.537486655723679*^9, 
  3.537486732610427*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L2", "=", 
   RowBox[{"L", "-", "GHBT"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460366546941235*^9, 3.460366557341961*^9}, 
   3.460366686117609*^9, {3.4603672960654507`*^9, 3.4603672977104673`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"L2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.460366666517003*^9, 3.460366674775579*^9}, {3.537486746662644*^9, 
  3.5374867639666147`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EOM", "[", "fld_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{"D", "[", 
      RowBox[{"L2", ",", "fld"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"tmp2", "=", 
           RowBox[{"D", "[", 
            RowBox[{"fld", ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ")"}], "=!=", "0"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tmp", "-=", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"L2", ",", "tmp2"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "tmp"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.4513849546200113`*^9, 3.451385039242148*^9}, {
  3.4603662728020573`*^9, 3.460366273871294*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqp", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"p", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"\[Alpha]", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513848144544163`*^9, 3.4513848150159073`*^9}, {
  3.451384869337384*^9, 3.451384875673843*^9}, {3.451384929950244*^9, 
  3.451384930100154*^9}, {3.451385060851385*^9, 3.451385213396349*^9}, {
  3.451385293160893*^9, 3.451385302528058*^9}, {3.4513853749547167`*^9, 
  3.45138537639461*^9}, {3.451385514552088*^9, 3.451385527943191*^9}, {
  3.451385862306609*^9, 3.451385882826736*^9}, {3.451386138230373*^9, 
  3.451386140019012*^9}, {3.451386241895258*^9, 3.4513862693654633`*^9}, {
  3.4603675858592987`*^9, 3.4603675914720583`*^9}, {3.537486779881022*^9, 
  3.537486784922683*^9}, {3.537486894453556*^9, 3.5374869009568243`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqav", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"av", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"az", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513855403702793`*^9, 3.451385540823719*^9}, {
  3.4513861532442207`*^9, 3.45138616739637*^9}, {3.451386251199284*^9, 
  3.4513862656960487`*^9}, {3.460367593073217*^9, 3.460367597640524*^9}, {
  3.5374867866028214`*^9, 3.537486788378339*^9}, {3.537486891597521*^9, 
  3.537486937732339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqgvz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gvz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqgzz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gzz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqT", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"T", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqS", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451386275930722*^9, 3.451386303859261*^9}, {
  3.460366711720347*^9, 3.4603667226381903`*^9}, {3.460367599130735*^9, 
  3.460367611985876*^9}, {3.53748678993122*^9, 3.53748680663302*^9}, {
  3.537486911477583*^9, 3.5374869187572203`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"gvz", ",", "gzz", ",", "az"}], "]"}]], "Input",
 CellChangeTimes->{{3.53748694036823*^9, 3.537486945275868*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"gvz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gzz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"az", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}]}], "Input",
 CellChangeTimes->{{3.460366755240944*^9, 3.460366765921853*^9}, {
   3.460379717667384*^9, 3.460379720321673*^9}, {3.4603938524268913`*^9, 
   3.4603938546559877`*^9}, 3.4603939628549967`*^9, {3.5374868640225983`*^9, 
   3.537486876197587*^9}, {3.537486924492758*^9, 3.537486925572747*^9}, {
   3.537487030062772*^9, 3.537487030117689*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqp2", "=", 
   RowBox[{"Simplify", "[", "eqp", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]2", "=", 
   RowBox[{"Simplify", "[", "eq\[Alpha]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqav2", "=", 
   RowBox[{"Simplify", "[", "eqav", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz2", "=", 
   RowBox[{"Simplify", "[", "eqaz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgvz2", "=", 
   RowBox[{"Simplify", "[", "eqgvz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgzz2", "=", 
   RowBox[{"Simplify", "[", "eqgzz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqT2", "=", 
   RowBox[{"Simplify", "[", "eqT", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"eqS2", "=", 
  RowBox[{"Simplify", "[", "eqS", "]"}]}]}], "Input",
 CellChangeTimes->{{3.460366768598325*^9, 3.4603668525536737`*^9}, {
  3.5374869590367947`*^9, 3.537486972220312*^9}}],

Cell[BoxData[
 RowBox[{"Evsol", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqgvz2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqS2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqp2", "\[Equal]", "0"}], ",", 
        RowBox[{"eq\[Alpha]2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqaz", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["p", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["\[Alpha]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["av", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4603794747692738`*^9, 3.4603795051117373`*^9}, {
   3.460379770556391*^9, 3.460379778090231*^9}, {3.537487575145343*^9, 
   3.537487601737835*^9}, {3.5374876320607243`*^9, 3.537487632172414*^9}, 
   3.5374876986147537`*^9}],

Cell[BoxData[
 RowBox[{"Momsol", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqT2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqgzz", "\[Equal]", "0"}], ",", 
        RowBox[{"eqav", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["av", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.460379791348405*^9, 3.460379854266864*^9}, {
  3.537487577120059*^9, 3.537487629667873*^9}, {3.5374877038531513`*^9, 
  3.537487709515881*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqT2", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqav", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"eqgzz", ",", "z"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"Evsol", ",", "v"}], "]"}]}], "/.", "Evsol"}], "/.", "Momsol"}],
   "]"}]}], "Input",
 CellChangeTimes->{{3.460379877349128*^9, 3.460379983100644*^9}, {
  3.460380087445326*^9, 3.460380091873478*^9}, {3.537487726936469*^9, 
  3.5374877500015907`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"a", "[", 
    RowBox[{"v", ",", "z"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"h", "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.460380576942815*^9, 3.46038057950566*^9}, {
  3.4603806147948647`*^9, 3.460380638346624*^9}, {3.5374877590000763`*^9, 
  3.537487759103163*^9}, {3.537487795719556*^9, 3.537487805166259*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Const1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Const2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Const3", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["S", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["S", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.46031768644937*^9, 3.46031772334064*^9}, {
  3.537487772329159*^9, 3.5374878178010073`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Eq1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["p", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["p", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq3", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq4", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq5", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["T", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["T", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.537489066732723*^9, 3.5374891410817547`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "]"}]], "Input",
 CellChangeTimes->{{3.537493027333661*^9, 3.537493033148741*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", " ", "=", " ", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", " ", 
       RowBox[{"p1", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"p2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"p3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"p4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"p5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"h2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"h3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"h4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"h5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"a1", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"a2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"a3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"a4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"a5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], 
      RowBox[{"T2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"T3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"T4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"T5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], 
     RowBox[{"S2", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "3"}], " ", 
     RowBox[{"S3", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "4"}], " ", 
     RowBox[{"S4", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "5"}], " ", 
     RowBox[{"S5", "[", "v", "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
  3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
  3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
  3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
  3.537490237348768*^9}, {3.537490394647192*^9, 3.537490453890482*^9}, {
  3.537490792048935*^9, 3.537490804720195*^9}, {3.537490860205984*^9, 
  3.537490863100896*^9}, {3.5374908962097483`*^9, 3.537490902905895*^9}, {
  3.537491099280459*^9, 3.5374911037619123`*^9}, {3.5374911421214113`*^9, 
  3.537491208593452*^9}, {3.537577393872981*^9, 3.537577398304707*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Const1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Const2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Const3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq4", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"Eq5", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", 
      RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
  3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
  3.537489829726491*^9}}],

Cell[BoxData[
 RowBox[{"repl", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "'"}], "[", "v", "]"}], ",", 
        RowBox[{"S2", "[", "v", "]"}], ",", 
        RowBox[{"T2", "[", "v", "]"}], ",", 
        RowBox[{"a2", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537577513364431*^9, 3.537577544243544*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", " ", "=", " ", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", " ", 
       RowBox[{"p1", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"p2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"p3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"p4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"p5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"h2", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", 
       RowBox[{"h3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"h4", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"h5", "[", "v", "]"}]}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"a1", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"h2", "[", "v", "]"}]}], " ", 
        RowBox[{"p1", "[", "v", "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"a3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"a4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"a5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", 
        SuperscriptBox[
         RowBox[{"p1", "[", "v", "]"}], "2"]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"T3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"T4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"T5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       SuperscriptBox[
        RowBox[{"p1", "[", "v", "]"}], "2"]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "3"}], " ", 
     RowBox[{"S3", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "4"}], " ", 
     RowBox[{"S4", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "5"}], " ", 
     RowBox[{"S5", "[", "v", "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
  3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
  3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
  3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
  3.537490237348768*^9}, {3.537490394647192*^9, 3.537490453890482*^9}, {
  3.537490792048935*^9, 3.537490804720195*^9}, {3.537490860205984*^9, 
  3.537490863100896*^9}, {3.5374908962097483`*^9, 3.537490902905895*^9}, {
  3.537491099280459*^9, 3.5374911037619123`*^9}, {3.5374911421214113`*^9, 
  3.537491208593452*^9}, {3.537577393872981*^9, 3.537577398304707*^9}, {
  3.537577484472924*^9, 3.5375774969987288`*^9}, {3.537577575335558*^9, 
  3.537577594057679*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "2"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"repltmp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"a1", "'"}], "[", "v", "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"p1", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"h2", "[", "v", "]"}], "+", 
         RowBox[{
          RowBox[{"a0", "[", "v", "]"}], " ", 
          RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Eq5", "//.", "repltmp"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
  3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
  3.537489829726491*^9}, {3.5374913369695187`*^9, 3.537491383848136*^9}, {
  3.537492455743868*^9, 3.537492509807266*^9}, {3.537492710362728*^9, 
  3.537492710514277*^9}, {3.537492765776664*^9, 3.537492765928492*^9}, {
  3.537493169402782*^9, 3.537493175233514*^9}, {3.537493221945931*^9, 
  3.5374932250087757`*^9}, {3.537577455742991*^9, 3.537577457366817*^9}, {
  3.5375775669894953`*^9, 3.537577567909832*^9}}],

Cell[BoxData[
 RowBox[{"repl", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
        "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"h3", "[", "v", "]"}], ",", 
       RowBox[{"p3", "[", "v", "]"}], ",", 
       RowBox[{"S3", "[", "v", "]"}], ",", 
       RowBox[{"a3", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537489831616275*^9, 3.5374898801274137`*^9}, {
  3.537491317375599*^9, 3.537491321759262*^9}, {3.537492699591785*^9, 
  3.537492702071735*^9}, {3.5375776114741364`*^9, 3.537577623767392*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "3"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"repltmp", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "'"}], "[", "v", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", "[", "v", "]"}], "+", 
           RowBox[{
            RowBox[{"a0", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}]}], "}"}], ",", "repl", 
      ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl", ",", "v"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Eq5", "//.", "repltmp"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
   3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
   3.537489829726491*^9}, {3.5374913369695187`*^9, 3.537491383848136*^9}, {
   3.537492455743868*^9, 3.537492509807266*^9}, {3.537492710362728*^9, 
   3.537492710514277*^9}, {3.537492765776664*^9, 3.537492765928492*^9}, {
   3.53749324118568*^9, 3.537493241384499*^9}, 3.537577642100482*^9}],

Cell[BoxData[
 RowBox[{"repl2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"T3", "'"}], "[", "v", "]"}], ",", 
        RowBox[{"a4", "[", "v", "]"}], ",", 
        RowBox[{"h4", "[", "v", "]"}], ",", 
        RowBox[{"p4", "[", "v", "]"}], ",", 
        RowBox[{"S4", "[", "v", "]"}], ",", 
        RowBox[{"T4", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5374914244686213`*^9, 3.537491468167574*^9}, {
  3.5374915105206013`*^9, 3.537491548039349*^9}, {3.537492546503677*^9, 
  3.537492546942692*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"repltmp", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "'"}], "[", "v", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", "[", "v", "]"}], "+", 
           RowBox[{
            RowBox[{"a0", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}]}], "}"}], ",", "repl", 
      ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl", ",", "v"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl", ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", "2"}], "}"}]}], "]"}], ",", "repl2", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl2", ",", "v"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "//.", "repltmp"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Eq5", "//.", "repltmp"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537492560482047*^9, 3.537492572712871*^9}, 
   3.537493267055489*^9, {3.537577657018985*^9, 3.5375776839549417`*^9}}],

Cell[BoxData[
 RowBox[{"repl3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T5", "[", "v", "]"}], ",", 
        RowBox[{"a5", "[", "v", "]"}], ",", 
        RowBox[{"h5", "[", "v", "]"}], ",", 
        RowBox[{"p5", "[", "v", "]"}], ",", 
        RowBox[{"S5", "[", "v", "]"}], ",", 
        RowBox[{"T5", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537492237653405*^9, 3.537492248948183*^9}, {
  3.53749258274236*^9, 3.537492583625291*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repltmp", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"a1", "'"}], "[", "v", "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"p1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"h2", "[", "v", "]"}], "+", 
          RowBox[{
           RowBox[{"a0", "[", "v", "]"}], " ", 
           RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}]}], "}"}], ",", "repl", 
     ",", 
     RowBox[{"D", "[", 
      RowBox[{"repl", ",", "v"}], "]"}], ",", 
     RowBox[{"D", "[", 
      RowBox[{"repl", ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"D", "[", 
      RowBox[{"repl", ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "3"}], "}"}]}], "]"}], ",", "repl2", ",", 
     RowBox[{"D", "[", 
      RowBox[{"repl2", ",", "v"}], "]"}], ",", 
     RowBox[{"D", "[", 
      RowBox[{"repl2", ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "2"}], "}"}]}], "]"}], ",", "repl3", ",", 
     RowBox[{"D", "[", 
      RowBox[{"repl3", ",", "v"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.53757813482145*^9, 3.537578165436287*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "3"}], "}"}]}], "]"}], "/.", "repltmp"}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"h", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "3"}], "}"}]}], "]"}], "/.", "repltmp"}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "4"}], "}"}]}], "]"}], "/.", "repltmp"}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "4"}], "}"}]}], "]"}], "/.", "repltmp"}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "4"}], "}"}]}], "]"}], "/.", "repltmp"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.537493510732931*^9, 3.53749356426119*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"p", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "/.", "repltmp"}], 
    "]"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "/.", "repltmp"}], 
    "]"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "/.", "repltmp"}], 
    "]"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "/.", "repltmp"}], 
    "]"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Normal", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "/.", "repltmp"}], 
   "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5374928365914*^9, 3.5374929059121637`*^9}, {
  3.5374933513754997`*^9, 3.537493363628664*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{"p1", "[", "v", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"p2", "[", "v", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"h2", "[", "v", "]"}]}], "+", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "3"], "2"], "+", 
        RowBox[{
         SuperscriptBox["p2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{"h2", "[", "v", "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"a0", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"T3", "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"8", " ", 
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "12"], " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "3"], " ", 
         RowBox[{"h2", "[", "v", "]"}]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"a1", "[", "v", "]"}], "2"], " ", 
         RowBox[{"p1", "[", "v", "]"}]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox[
          RowBox[{"h2", "[", "v", "]"}], "2"], " ", 
         RowBox[{"p1", "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "5"]}], "+", 
        RowBox[{"6", " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"p2", "[", "v", "]"}], "2"]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{"T3", "[", "v", "]"}]}], "+", 
        RowBox[{"12", " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["a0", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{"8", " ", 
            RowBox[{
             SuperscriptBox["h2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"T3", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"8", " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["p1", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "3"]}], "-", 
           RowBox[{"3", " ", 
            RowBox[{
             SuperscriptBox["p2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"13", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"17", " ", 
            RowBox[{"h2", "[", "v", "]"}], " ", 
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "2"]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               RowBox[{"p2", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["a0", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "+", 
              RowBox[{
               RowBox[{"a1", "[", "v", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  RowBox[{"p2", "[", "v", "]"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p1", "\[Prime]",
                   MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "-", 
              
              RowBox[{"3", " ", 
               RowBox[{
                SuperscriptBox["h2", "\[Prime]\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["p2", 
           TagBox[
            RowBox[{"(", "3", ")"}],
            Derivative],
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"h2", "[", "v", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "2"]}], " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{"h2", "[", "v", "]"}]}], "+", 
        RowBox[{"9", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"]}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "3"]}], "-", 
           RowBox[{"8", " ", 
            RowBox[{
             SuperscriptBox["p2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "12"], " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "3"], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "+", 
        RowBox[{"14", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"T3", "[", "v", "]"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "3"], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"a1", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}]}], "-", 
           RowBox[{"6", " ", 
            RowBox[{
             SuperscriptBox["h2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"20", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"12", " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "3"]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["p2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["p1", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], " ", 
            RowBox[{"a1", "[", "v", "]"}], " ", 
            RowBox[{"h2", "[", "v", "]"}]}], "+", 
           RowBox[{
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{"T3", "[", "v", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "4"}], " ", 
               RowBox[{"p2", "[", "v", "]"}]}], "+", 
              RowBox[{"9", " ", 
               RowBox[{
                SuperscriptBox["p1", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "-", 
           
           RowBox[{"12", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"h2", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["a0", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["p2", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["h2", 
           TagBox[
            RowBox[{"(", "3", ")"}],
            Derivative],
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"a1", "[", "v", "]"}]}], "-", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"p1", "[", "v", "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"p1", "[", "v", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "12"], " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"h2", "[", "v", "]"}], "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"p2", "[", "v", "]"}], "2"]}], "+", 
           RowBox[{"8", " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{"p2", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["a0", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "-", 
           RowBox[{
            RowBox[{"p2", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{
            RowBox[{"a1", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               RowBox[{"p2", "[", "v", "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["p1", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"h2", "[", "v", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "5"}], " ", 
               SuperscriptBox[
                RowBox[{"p1", "[", "v", "]"}], "3"]}], "+", 
              RowBox[{
               SuperscriptBox["p2", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h2", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
       ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "30"], " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "3"], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "-", 
        RowBox[{"24", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"T3", "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"h2", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "4"], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p2", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"19", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "3"], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"16", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"12", " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox[
             RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
           RowBox[{"9", " ", 
            RowBox[{"a0", "[", "v", "]"}], " ", 
            RowBox[{"h2", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "2"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox[
             RowBox[{"p2", "[", "v", "]"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"p2", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p1", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{"11", " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p1", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox[
              RowBox[{"p1", "[", "v", "]"}], "2"]}], " ", 
            RowBox[{"T3", "[", "v", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"p1", "[", "v", "]"}], "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{"p2", "[", "v", "]"}]}], "-", 
              RowBox[{"9", " ", 
               RowBox[{
                SuperscriptBox["p1", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
           
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"h2", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["h2", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "+", 
              RowBox[{
               RowBox[{"p2", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["p2", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
           
           RowBox[{"12", " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"h2", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["a0", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["p2", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], 
          ")"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", 
           TagBox[
            RowBox[{"(", "3", ")"}],
            Derivative],
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"1", "-", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"p1", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"T3", "[", "v", "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "12"], " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"a1", "[", "v", "]"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
           RowBox[{"6", " ", 
            RowBox[{"a0", "[", "v", "]"}], " ", 
            RowBox[{"h2", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}]}], "+", 
           SuperscriptBox[
            RowBox[{"p1", "[", "v", "]"}], "4"], "+", 
           RowBox[{"2", " ", 
            RowBox[{"p2", "[", "v", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p2", "[", "v", "]"}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["p1", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
           
           RowBox[{"2", " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
       ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            RowBox[{"h2", "[", "v", "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"a0", "[", "v", "]"}], " ", 
            RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "3"], " ", 
         RowBox[{"p2", "[", "v", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
         RowBox[{"T3", "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a0", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{
         RowBox[{"a0", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            RowBox[{"p1", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h2", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{"3", " ", 
            RowBox[{"h2", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p1", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"p2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"p1", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     SuperscriptBox["z", "2"], " ", 
     SuperscriptBox[
      RowBox[{"p1", "[", "v", "]"}], "2"]}], "-", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     SuperscriptBox["z", "3"], " ", 
     RowBox[{"p1", "[", "v", "]"}], " ", 
     RowBox[{"p2", "[", "v", "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "96"], " ", 
     SuperscriptBox["z", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", 
        SuperscriptBox[
         RowBox[{"h2", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"24", " ", 
        RowBox[{"a0", "[", "v", "]"}], " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"p1", "[", "v", "]"}]}], "-", 
       RowBox[{"11", " ", 
        SuperscriptBox[
         RowBox[{"p1", "[", "v", "]"}], "4"]}], "-", 
       RowBox[{"16", " ", 
        SuperscriptBox[
         RowBox[{"p2", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"24", " ", 
        RowBox[{"p1", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["p2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "60"], " ", 
     SuperscriptBox["z", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"p1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"h2", "[", "v", "]"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"a0", "[", "v", "]"}], " ", 
           RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox[
         RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
        RowBox[{"p1", "[", "v", "]"}], " ", 
        RowBox[{"p2", "[", "v", "]"}]}], "-", 
       RowBox[{"17", " ", 
        SuperscriptBox[
         RowBox[{"p1", "[", "v", "]"}], "3"], " ", 
        RowBox[{"p2", "[", "v", "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"p1", "[", "v", "]"}], "2"], " ", 
        RowBox[{"T3", "[", "v", "]"}]}], "-", 
       RowBox[{"8", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"p1", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["a0", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"18", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"16", " ", 
        RowBox[{"a0", "[", "v", "]"}], " ", 
        RowBox[{"p1", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox[
         RowBox[{"p1", "[", "v", "]"}], "3"], " ", 
        RowBox[{
         SuperscriptBox["p1", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"18", " ", 
        RowBox[{"p2", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["p2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"8", " ", 
        RowBox[{"p1", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["p2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.537492963821166*^9, 3.537493045909999*^9}, {
  3.5374932879492693`*^9, 3.537493317604496*^9}, {3.5374933681066713`*^9, 
  3.537493395425406*^9}, {3.537578226128375*^9, 3.537578265829267*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq4", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"Eq5", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537492560482047*^9, 3.537492572712871*^9}, {
  3.53749294172685*^9, 3.537492958193097*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"crepl", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a1", "'"}], "[", "v", "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"p1", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"h2", "[", "v", "]"}], "+", 
         RowBox[{
          RowBox[{"a0", "[", "v", "]"}], " ", 
          RowBox[{"p1", "[", "v", "]"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T3", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"p1", "[", "v", "]"}]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"a0", "[", "v", "]"}], " ", 
          RowBox[{"h2", "[", "v", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"a0", "[", "v", "]"}], "2"], " ", 
          RowBox[{"p1", "[", "v", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["p2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], "-", 
         RowBox[{
          SuperscriptBox["p1", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.537578295515046*^9, 3.5375782975235357`*^9}, {
  3.537578376610682*^9, 3.5375783769473963`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", "tmp1", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "tmp2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"tmp3", "/.", "crepl"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"tmp4", "/.", "crepl"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"tmp5", "/.", "crepl"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"tmp6", "/.", "crepl"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "tmp7", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "tmp8", "]"}]}], "Input",
 CellChangeTimes->{{3.5375783064344482`*^9, 3.537578349339065*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "]"}]], "Input",
 CellChangeTimes->{{3.537627657747676*^9, 3.537627677965989*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"p", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"h", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"a", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"T", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"S", "[", "z", "]"}]}]}], "Input",
 CellChangeTimes->{{3.537627682228917*^9, 3.537627713970744*^9}, {
  3.537636882057424*^9, 3.537636897297038*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ell1", "=", 
   RowBox[{"Simplify", "[", "Eq1", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell2", "=", 
   RowBox[{"Simplify", "[", "Eq2", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ellc1", "=", 
   RowBox[{"Simplify", "[", "Eq3", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ellc2", "=", 
   RowBox[{"Simplify", "[", "Eq4", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell3", "=", 
   RowBox[{"Simplify", "[", "Eq5", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell4", "=", 
   RowBox[{"Simplify", "[", "Const1", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell5", "=", 
   RowBox[{"Simplify", "[", "Const2", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"ellc3", "=", 
  RowBox[{"Simplify", "[", "Const3", "]"}]}]}], "Input",
 CellChangeTimes->{{3.537627679175139*^9, 3.537627742317072*^9}, {
  3.537636876281947*^9, 3.53763687844884*^9}, {3.5376379765369062`*^9, 
  3.537638074206946*^9}, {3.537638144466118*^9, 3.537638162905325*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ell1", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}], "+", 
        RowBox[{
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["1", "z"]}], "+", 
           FractionBox[
            RowBox[{
             SuperscriptBox["S", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}], 
            RowBox[{"S", "[", "z", "]"}]]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"p", "[", "z", "]"}]}], 
          SuperscriptBox["z", "2"]]}], "+", 
        RowBox[{
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"T", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["p", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "z"], "-", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"T", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["p", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["S", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], 
         RowBox[{"S", "[", "z", "]"}]], "-", 
        RowBox[{
         RowBox[{
          SuperscriptBox["p", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["T", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{
         RowBox[{"T", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ell2", "=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"S", "[", "z", "]"}]}]]}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"T", "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["S", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"a", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", " ", 
           RowBox[{"S", "[", "z", "]"}], " ", 
           RowBox[{
            SuperscriptBox["p", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{"p", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"S", "[", "z", "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["S", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
         ")"}]}], "+", 
       RowBox[{
        RowBox[{"S", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"h", "[", "z", "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"z", " ", 
              RowBox[{"p", "[", "z", "]"}], " ", 
              RowBox[{
               SuperscriptBox["a", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{"T", "[", "z", "]"}], " ", 
              RowBox[{
               SuperscriptBox["h", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["h", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], " ", 
              RowBox[{
               SuperscriptBox["T", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{"T", "[", "z", "]"}], " ", 
              RowBox[{
               SuperscriptBox["h", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ellc1", "=", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"h", "[", "z", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"p", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "-", 
           RowBox[{
            RowBox[{"h", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
       ")"}]}], 
     SuperscriptBox["z", "2"]]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ellc2", "=", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"T", "[", "z", "]"}], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["S", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
       RowBox[{"4", " ", "z", " ", 
        RowBox[{"S", "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["S", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           RowBox[{"T", "[", "z", "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["T", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "-", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"S", "[", "z", "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"12", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"h", "[", "z", "]"}], "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"p", "[", "z", "]"}], "2"]}], "-", 
          RowBox[{
           SuperscriptBox["z", "4"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["a", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"T", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "6"}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["h", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["p", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], "2"]}]}], ")"}]}],
           "+", 
          RowBox[{"4", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["T", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
      RowBox[{"8", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"S", "[", "z", "]"}]}]]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ell3", "=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"T", "[", "z", "]"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["S", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"S", "[", "z", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["z", "3"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["a", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"z", " ", 
               RowBox[{"a", "[", "z", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"p", "[", "z", "]"}]}], " ", 
                  RowBox[{
                   SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                 RowBox[{
                  RowBox[{"h", "[", "z", "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["p", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"z", " ", 
               RowBox[{"T", "[", "z", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["p", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], 
                ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["T", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
          ")"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"S", "[", "z", "]"}], " ", 
         RowBox[{"T", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["S", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
       RowBox[{"z", " ", 
        SuperscriptBox[
         RowBox[{"S", "[", "z", "]"}], "2"]}]]}], "+", 
     RowBox[{
      SuperscriptBox["T", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ell4", "=", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"S", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["p", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], "2"]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["S", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ell5", "=", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"p", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], 
      SuperscriptBox["z", "2"]], "-", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["p", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], 
      SuperscriptBox["z", "2"]], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["S", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], 
      RowBox[{"S", "[", "z", "]"}]], "+", 
     RowBox[{
      SuperscriptBox["a", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ellc3", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"S", "[", "z", "]"}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"a", "[", "z", "]"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"h", "[", "z", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"S", "[", "z", "]"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"a", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"S", "[", "z", "]"}], "2"], " ", 
       RowBox[{"T", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"p", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["h", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "-", 
         RowBox[{
          RowBox[{"h", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["p", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"T", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"T", "[", "z", "]"}], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["S", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
         RowBox[{"4", " ", "z", " ", 
          RowBox[{"S", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["S", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             RowBox[{"T", "[", "z", "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["T", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"S", "[", "z", "]"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"12", "+", 
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "2"]}], "-", 
            RowBox[{"12", " ", 
             RowBox[{"T", "[", "z", "]"}]}], "-", 
            RowBox[{
             SuperscriptBox["z", "4"], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["a", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"T", "[", "z", "]"}], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["h", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"T", "[", "z", "]"}], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["p", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
            RowBox[{"4", " ", "z", " ", 
             RowBox[{
              SuperscriptBox["T", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
        ")"}]}]}], ")"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.537640397292142*^9, 3.537640504029217*^9}}],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ell1", ",", "ell2", ",", "ell3", ",", "ell4", ",", "ell5"}], 
        "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"h", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"a", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"T", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"S", "''"}], "[", "z", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.537638077410537*^9, {3.5376381314247913`*^9, 3.537638256008617*^9}, {
   3.537638739449127*^9, 3.537638740135255*^9}, {3.537638891437305*^9, 
   3.5376388944848833`*^9}}],

Cell[BoxData[
 RowBox[{"Expand", "[", "ellc1", "]"}]], "Input",
 CellChangeTimes->{{3.537638754409368*^9, 3.537638756597229*^9}}],

Cell[BoxData[
 RowBox[{"Expand", "[", "ellc2", "]"}]], "Input",
 CellChangeTimes->{{3.537638758349153*^9, 3.537638760740986*^9}}],

Cell[BoxData[
 RowBox[{"Expand", "[", "ellc3", "]"}]], "Input",
 CellChangeTimes->{{3.537638761869357*^9, 3.537638765020914*^9}}],

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ellc1", ",", "ellc2"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"p", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537638619736205*^9, 3.53763872186449*^9}, {
  3.53763882686869*^9, 3.537638830835917*^9}, {3.537638862507595*^9, 
  3.5376388755551147`*^9}}],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"ellc3", "/.", "sol2"}], "]"}]], "Input",
 CellChangeTimes->{{3.537638838836076*^9, 3.5376388709387693`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"ellc1", ",", "z"}], "]"}], "+", 
      RowBox[{"2", 
       FractionBox[
        RowBox[{
         RowBox[{"S", "'"}], "[", "z", "]"}], 
        RowBox[{"S", "[", "z", "]"}]], " ", "ellc1"}]}], ")"}], "/.", "sol"}],
    "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"S", "[", "z", "]"}], "^", "2"}], "ellc1"}], ",", "z"}], "]"}],
    "/.", "sol"}], "]"}]}], "Input",
 CellChangeTimes->{{3.537640004014365*^9, 3.5376400814389057`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"ellc2", ",", "z"}], "]"}], "-", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"S", "'"}], "[", "z", "]"}], 
        RowBox[{"S", "[", "z", "]"}]], " ", "ellc2"}], "+", 
      RowBox[{
       FractionBox["2", "z"], " ", "ellc2"}]}], ")"}], "/.", "sol"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"z", "^", "2"}], 
       RowBox[{"S", "[", "z", "]"}]], "ellc2"}], ",", "z"}], "]"}], "/.", 
   "sol"}], "]"}]}], "Input",
 CellChangeTimes->{{3.537640004014365*^9, 3.5376401691466208`*^9}, {
  3.537640206992764*^9, 3.537640234528932*^9}}],

Cell[BoxData[
 RowBox[{"Print", "[", 
  "\"\<\\n\\nSo, if c1 and c2 are zero, and they obey simple decoupled eqns, \
then c3 also zero!\\n\\n\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.5376403237255774`*^9, 3.537640353177024*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "p2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "p3"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", "p4"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", "p5"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "6"}], " ", "p6"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "7"}], " ", "p7"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "8"}], " ", "p8"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "9"}], " ", "p9"}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "h2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "h3"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", "h4"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", "h5"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "6"}], " ", "h6"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "7"}], " ", "h7"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "8"}], " ", "h8"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "9"}], " ", "h9"}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "z_", "]"}], ":=", 
    RowBox[{"a0", "+", 
     RowBox[{"z", " ", "a1"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", "a2"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", "a3"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", "a4"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", "a5"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "6"}], " ", "a6"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "7"}], " ", "a7"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "8"}], " ", "a8"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "9"}], " ", "a9"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "z_", "]"}], ":=", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], "T2"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", "T3"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", "T4"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", "T5"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "6"}], " ", "T6"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "7"}], " ", "T7"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "8"}], " ", "T8"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "9"}], " ", "T9"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], "S2"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "3"}], " ", "S3"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "4"}], " ", "S4"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "5"}], " ", "S5"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "6"}], " ", "S6"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "7"}], " ", "S7"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "8"}], " ", "S8"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "9"}], " ", "S9"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
   3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
   3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
   3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
   3.537490237348768*^9}, {3.537490394647192*^9, 3.537490453890482*^9}, {
   3.537490792048935*^9, 3.537490804720195*^9}, {3.537490860205984*^9, 
   3.537490863100896*^9}, {3.5374908962097483`*^9, 3.537490902905895*^9}, {
   3.537491099280459*^9, 3.5374911037619123`*^9}, {3.5374911421214113`*^9, 
   3.537491208593452*^9}, {3.537577393872981*^9, 3.537577398304707*^9}, {
   3.537639022648444*^9, 3.537639113606564*^9}, {3.5381377672688637`*^9, 
   3.5381378365486183`*^9}, 3.538137882235326*^9}],

Cell[BoxData[
 RowBox[{"runeq", ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp1", "=", 
     RowBox[{"Series", "[", 
      RowBox[{"ellc1", ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp2", "=", 
     RowBox[{"Series", "[", 
      RowBox[{"ellc2", ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp3", "=", 
     RowBox[{"Series", "[", 
      RowBox[{"ellc3", ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp4", "=", 
     RowBox[{"Series", "[", 
      RowBox[{"ell1", ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp5", "=", 
     RowBox[{"Series", "[", 
      RowBox[{"ell2", ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp6", "=", 
     RowBox[{"Series", "[", 
      RowBox[{"ell3", ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp7", "=", 
     RowBox[{"Series", "[", 
      RowBox[{"ell4", ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp8", "=", 
     RowBox[{"Series", "[", 
      RowBox[{"ell5", ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.5376392293063307`*^9, 3.5376392299215183`*^9}, {
  3.538137895519271*^9, 3.538137930215798*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"T2", ",", "S2", ",", "a2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.538137931998144*^9, 3.5381379817888117`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell4", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"ell5", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", 
      RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
   3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
   3.537489829726491*^9}, {3.5376391234797773`*^9, 3.537639144840652*^9}, 
   3.537639225819255*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", " ", "=", " ", "2"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "p2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "p3"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", "p4"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", "p5"}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "h2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "h3"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", "h4"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", "h5"}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "z_", "]"}], ":=", 
    RowBox[{"a0", "+", 
     RowBox[{"z", " ", "a1"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", "a3"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", "a4"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", "a5"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "z_", "]"}], ":=", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", "T3"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", "T4"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", "T5"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "3"}], " ", "S3"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "4"}], " ", "S4"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "5"}], " ", "S5"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
  3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
  3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
  3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
  3.537490237348768*^9}, {3.537490394647192*^9, 3.537490453890482*^9}, {
  3.537490792048935*^9, 3.537490804720195*^9}, {3.537490860205984*^9, 
  3.537490863100896*^9}, {3.5374908962097483`*^9, 3.537490902905895*^9}, {
  3.537491099280459*^9, 3.5374911037619123`*^9}, {3.5374911421214113`*^9, 
  3.537491208593452*^9}, {3.537577393872981*^9, 3.537577398304707*^9}, {
  3.537639022648444*^9, 3.537639113606564*^9}, {3.537639180366321*^9, 
  3.53763919283671*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ellc1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ellc2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp3", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"ellc3", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", 
      RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
   3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
   3.537489829726491*^9}, {3.5376391234797773`*^9, 3.537639144840652*^9}, 
   3.537639285134715*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell4", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"ell5", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", 
      RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
   3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
   3.537489829726491*^9}, {3.5376391234797773`*^9, 3.537639144840652*^9}, 
   3.537639285134715*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", " ", "=", " ", "3"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "p2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "a0", " ", "h2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", "p4"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", "p5"}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "h2"}], "-", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "a0", " ", "p2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", "h4"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", "h5"}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "z_", "]"}], ":=", 
    RowBox[{"a0", "+", 
     RowBox[{"z", " ", "a1"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", "a4"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", "a5"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "z_", "]"}], ":=", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", "T3"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", "T4"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", "T5"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "4"}], " ", "S4"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "5"}], " ", "S5"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
  3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
  3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
  3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
  3.537490237348768*^9}, {3.537490394647192*^9, 3.537490453890482*^9}, {
  3.537490792048935*^9, 3.537490804720195*^9}, {3.537490860205984*^9, 
  3.537490863100896*^9}, {3.5374908962097483`*^9, 3.537490902905895*^9}, {
  3.537491099280459*^9, 3.5374911037619123`*^9}, {3.5374911421214113`*^9, 
  3.537491208593452*^9}, {3.537577393872981*^9, 3.537577398304707*^9}, {
  3.537639022648444*^9, 3.537639113606564*^9}, {3.537639180366321*^9, 
  3.53763919283671*^9}, {3.537639316417922*^9, 3.537639361895536*^9}, {
  3.5376405437385273`*^9, 3.537640546642747*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ellc1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ellc2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp3", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"ellc3", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", 
      RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
   3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
   3.537489829726491*^9}, {3.5376391234797773`*^9, 3.537639144840652*^9}, 
   3.537639285134715*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell4", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"ell5", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", 
      RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
   3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
   3.537489829726491*^9}, {3.5376391234797773`*^9, 3.537639144840652*^9}, 
   3.537639285134715*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", " ", "=", " ", "4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "p2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "a0", " ", "h2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"a1", " ", "h2"}], "2"], "-", 
         RowBox[{
          FractionBox["2", "3"], " ", 
          SuperscriptBox["a0", "2"], " ", "p2"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", "p5"}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "h2"}], "-", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "a0", " ", "p2"}], "-", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"a1", " ", "p2"}], "2"], "+", 
         RowBox[{
          FractionBox["2", "3"], " ", 
          SuperscriptBox["a0", "2"], " ", "h2"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", "h5"}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "z_", "]"}], ":=", 
    RowBox[{"a0", "+", 
     RowBox[{"z", " ", "a1"}], "+", 
     RowBox[{
      FractionBox["1", "6"], 
      RowBox[{"z", "^", "4"}], " ", "a0", 
      RowBox[{"(", " ", 
       RowBox[{
        SuperscriptBox["h2", "2"], "+", " ", 
        SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", "a5"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "z_", "]"}], ":=", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", "T3"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         SuperscriptBox["a1", "2"], "4"], "-", 
        FractionBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["h2", "2"], "+", 
           SuperscriptBox["p2", "2"]}], ")"}], "3"]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", "T5"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{
     FractionBox["1", "6"], 
     RowBox[{"z", "^", "4"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["h2", "2"], "+", 
       SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "5"}], " ", "S5"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
  3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
  3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
  3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
  3.537490237348768*^9}, {3.537490394647192*^9, 3.537490453890482*^9}, {
  3.537490792048935*^9, 3.537490804720195*^9}, {3.537490860205984*^9, 
  3.537490863100896*^9}, {3.5374908962097483`*^9, 3.537490902905895*^9}, {
  3.537491099280459*^9, 3.5374911037619123`*^9}, {3.5374911421214113`*^9, 
  3.537491208593452*^9}, {3.537577393872981*^9, 3.537577398304707*^9}, {
  3.537639022648444*^9, 3.537639113606564*^9}, {3.537639180366321*^9, 
  3.53763919283671*^9}, {3.537639316417922*^9, 3.537639556258574*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ellc1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ellc2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp3", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"ellc3", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", 
      RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
   3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
   3.537489829726491*^9}, {3.5376391234797773`*^9, 3.537639144840652*^9}, 
   3.537639285134715*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell4", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"ell5", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", 
      RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
   3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
   3.537489829726491*^9}, {3.5376391234797773`*^9, 3.537639144840652*^9}, 
   3.537639285134715*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", " ", "=", " ", "4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "p2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "a0", " ", "h2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"a1", " ", "h2"}], "2"], "-", 
         RowBox[{
          FractionBox["2", "3"], " ", 
          SuperscriptBox["a0", "2"], " ", "p2"}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox["1", "3"], " ", 
          SuperscriptBox["a0", "3"], " ", "h2"}], "+", 
         RowBox[{
          FractionBox["2", "3"], " ", "a0", " ", "a1", " ", "p2"}], "+", 
         RowBox[{
          FractionBox["1", "3"], " ", "p2", " ", "T3"}]}], ")"}]}]}], ")"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "h2"}], "-", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "a0", " ", "p2"}], "-", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"a1", " ", "p2"}], "2"], "+", 
         RowBox[{
          FractionBox["2", "3"], " ", 
          SuperscriptBox["a0", "2"], " ", "h2"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox["1", "3"], " ", 
          SuperscriptBox["a0", "3"], " ", "p2"}], "-", 
         RowBox[{
          FractionBox["2", "3"], " ", "a0", " ", "a1", " ", "h2"}], "-", 
         RowBox[{
          FractionBox["1", "3"], " ", "h2", " ", "T3"}]}], ")"}]}]}], ")"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "z_", "]"}], ":=", 
    RowBox[{"a0", "+", 
     RowBox[{"z", " ", "a1"}], "+", 
     RowBox[{
      FractionBox["1", "6"], 
      RowBox[{"z", "^", "4"}], " ", "a0", 
      RowBox[{"(", " ", 
       RowBox[{
        SuperscriptBox["h2", "2"], "+", " ", 
        SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"z", "^", "5"}], " ", "a1", " ", 
      RowBox[{"(", " ", 
       RowBox[{
        SuperscriptBox["h2", "2"], "+", " ", 
        SuperscriptBox["p2", "2"]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "z_", "]"}], ":=", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", "T3"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         SuperscriptBox["a1", "2"], "4"], "-", 
        FractionBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["h2", "2"], "+", 
           SuperscriptBox["p2", "2"]}], ")"}], "3"]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", "*", "0"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{
     FractionBox["1", "6"], 
     RowBox[{"z", "^", "4"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["h2", "2"], "+", 
       SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "5"}], " ", "*", "0"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
  3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
  3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
  3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
  3.537490237348768*^9}, {3.537490394647192*^9, 3.537490453890482*^9}, {
  3.537490792048935*^9, 3.537490804720195*^9}, {3.537490860205984*^9, 
  3.537490863100896*^9}, {3.5374908962097483`*^9, 3.537490902905895*^9}, {
  3.537491099280459*^9, 3.5374911037619123`*^9}, {3.5374911421214113`*^9, 
  3.537491208593452*^9}, {3.537577393872981*^9, 3.537577398304707*^9}, {
  3.537639022648444*^9, 3.537639113606564*^9}, {3.537639180366321*^9, 
  3.53763919283671*^9}, {3.537639316417922*^9, 3.5376395976745663`*^9}, {
  3.537639704878818*^9, 3.537639726403778*^9}, {3.53763975947656*^9, 
  3.53763987013841*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ellc1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ellc2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp3", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"ellc3", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", 
      RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
   3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
   3.537489829726491*^9}, {3.5376391234797773`*^9, 3.537639144840652*^9}, 
   3.537639285134715*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"ell4", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Series", "[", 
   RowBox[{"ell5", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", 
      RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489543645871*^9, 3.53748960312015*^9}, {
   3.537489694238214*^9, 3.537489738642725*^9}, {3.537489800224758*^9, 
   3.537489829726491*^9}, {3.5376391234797773`*^9, 3.537639144840652*^9}, 
   3.537639285134715*^9}],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"S", "[", "z", "]"}], "^", "2"}], "ellc1"}], ",", "z"}], "]"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.537640004014365*^9, 3.5376400814389057`*^9}, {
  3.537640573151676*^9, 3.537640599133205*^9}}],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"z", "^", "2"}], 
       RowBox[{"S", "[", "z", "]"}]], "ellc2"}], ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.537640004014365*^9, 3.5376401691466208`*^9}, {
  3.537640206992764*^9, 3.537640234528932*^9}, {3.537640576190969*^9, 
  3.537640603267757*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", "\"\<Nice\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.53764060809135*^9, 3.537640611304142*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "]"}]], "Input",
 CellChangeTimes->{{3.537640737015723*^9, 3.5376407595390577`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"initp", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "p2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "a0", " ", "h2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"a1", " ", "h2"}], "2"], "-", 
         RowBox[{
          FractionBox["2", "3"], " ", 
          SuperscriptBox["a0", "2"], " ", "p2"}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox["1", "3"], " ", 
          SuperscriptBox["a0", "3"], " ", "h2"}], "+", 
         RowBox[{
          FractionBox["2", "3"], " ", "a0", " ", "a1", " ", "p2"}], "+", 
         RowBox[{
          FractionBox["1", "3"], " ", "p2", " ", "T3"}]}], ")"}]}]}], ")"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"inith", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "h2"}], "-", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "a0", " ", "p2"}], "-", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"a1", " ", "p2"}], "2"], "+", 
         RowBox[{
          FractionBox["2", "3"], " ", 
          SuperscriptBox["a0", "2"], " ", "h2"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox["1", "3"], " ", 
          SuperscriptBox["a0", "3"], " ", "p2"}], "-", 
         RowBox[{
          FractionBox["2", "3"], " ", "a0", " ", "a1", " ", "h2"}], "-", 
         RowBox[{
          FractionBox["1", "3"], " ", "h2", " ", "T3"}]}], ")"}]}]}], ")"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"inita", "[", "z_", "]"}], ":=", 
    RowBox[{"a0", "+", 
     RowBox[{"z", " ", "a1"}], "+", 
     RowBox[{
      FractionBox["1", "6"], 
      RowBox[{"z", "^", "4"}], " ", "a0", 
      RowBox[{"(", " ", 
       RowBox[{
        SuperscriptBox["h2", "2"], "+", " ", 
        SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"z", "^", "5"}], " ", "a1", " ", 
      RowBox[{"(", " ", 
       RowBox[{
        SuperscriptBox["h2", "2"], "+", " ", 
        SuperscriptBox["p2", "2"]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"initT", "[", "z_", "]"}], ":=", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", "T3"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         SuperscriptBox["a1", "2"], "4"], "-", 
        FractionBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["h2", "2"], "+", 
           SuperscriptBox["p2", "2"]}], ")"}], "3"]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", "*", "0"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initS", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{
     FractionBox["1", "6"], 
     RowBox[{"z", "^", "4"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["h2", "2"], "+", 
       SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "5"}], " ", "*", "0"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.537640798221807*^9, 3.5376408063887777`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Check : Normal phase RN soln", "Subsubtitle",
 CellChangeTimes->{{3.537641365795959*^9, 3.537641379781547*^9}, {
  3.537692123387228*^9, 3.53769212490541*^9}, {3.5378102077595577`*^9, 
  3.537810209958619*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p2", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h2", "=", "0"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5376408331474543`*^9, 3.537640843976453*^9}, {
  3.537641005880987*^9, 3.53764100596068*^9}, {3.537641224558692*^9, 
  3.537641224830652*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eps", "=", "0.001"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zmax", "=", "2"}], ";"}]}], "Input",
 CellChangeTimes->{{3.537640888681366*^9, 3.537640891919183*^9}, {
  3.537641169191256*^9, 3.537641169558916*^9}, {3.537641303924184*^9, 
  3.5376413072198143`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a0", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a1", "=", 
   RowBox[{"-", "1"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T3", "=", 
    RowBox[{"-", "1"}]}], " ", ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nsol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ell1", "\[Equal]", "0"}], ",", 
        RowBox[{"ell2", "\[Equal]", "0"}], ",", 
        RowBox[{"ell3", "\[Equal]", "0"}], ",", 
        RowBox[{"ell4", "\[Equal]", "0"}], ",", 
        RowBox[{"ell5", "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"p", "[", "eps", "]"}], "\[Equal]", 
         RowBox[{"initp", "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"p", "'"}], "[", "eps", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"initp", "'"}], "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{"h", "[", "eps", "]"}], "\[Equal]", 
         RowBox[{"inith", "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"h", "'"}], "[", "eps", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"inith", "'"}], "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{"a", "[", "eps", "]"}], "\[Equal]", 
         RowBox[{"inita", "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "'"}], "[", "eps", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"inita", "'"}], "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{"T", "[", "eps", "]"}], "\[Equal]", 
         RowBox[{"initT", "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"T", "'"}], "[", "eps", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"initT", "'"}], "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{"S", "[", "eps", "]"}], "\[Equal]", 
         RowBox[{"initS", "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"S", "'"}], "[", "eps", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"initS", "'"}], "[", "eps", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5376407771099586`*^9, 3.53764077742128*^9}, {
  3.537640849432414*^9, 3.537641029700471*^9}, {3.537641083186082*^9, 
  3.5376410832815037`*^9}, {3.537641227496984*^9, 3.537641241071927*^9}, {
  3.537641278231781*^9, 3.53764129200132*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"T", "[", "z", "]"}], "/.", "nsol"}], ",", 
      RowBox[{"1", "-", 
       RowBox[{"z", "^", "3"}], "+", 
       RowBox[{
        FractionBox["1", "4"], 
        RowBox[{"a1", "^", "2"}], " ", 
        RowBox[{"z", "^", "4"}]}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "eps", ",", "zmax"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"S", "[", "z", "]"}], "/.", "nsol"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "eps", ",", "zmax"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.537641021281739*^9, 3.5376410662087173`*^9}, {
  3.537641156431985*^9, 3.5376411621997757`*^9}, {3.537641246199189*^9, 
  3.537641249886531*^9}, {3.537641281045887*^9, 3.537641289735113*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"p", "[", "z", "]"}], "/.", "nsol"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "eps", ",", "zmax"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", "z", "]"}], "/.", "nsol"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "eps", ",", "zmax"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.537641050904498*^9, 3.537641055312849*^9}, {
  3.537641294238761*^9, 3.537641295518605*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "z", "]"}], "/.", "nsol"}], ",", 
     RowBox[{"1", "+", 
      RowBox[{"a1", " ", "z"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "eps", ",", "zmax"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.537641059744339*^9, {3.537641261805554*^9, 3.5376412988785667`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar soln", "Subsubtitle",
 CellChangeTimes->{{3.537641348236147*^9, 3.537641360845842*^9}, {
  3.537810217330121*^9, 3.537810218054635*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"+", "0.0001"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h2", "=", "0"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5376408331474543`*^9, 3.537640843976453*^9}, {
  3.537641005880987*^9, 3.53764100596068*^9}, {3.537641224558692*^9, 
  3.537641224830652*^9}, {3.537692168427661*^9, 3.537692201057229*^9}, {
  3.537692270022526*^9, 3.537692295357997*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eps", "=", "0.001"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zmax", "=", "1.1"}], ";"}]}], "Input",
 CellChangeTimes->{{3.537640888681366*^9, 3.537640891919183*^9}, {
   3.537641169191256*^9, 3.537641169558916*^9}, {3.537641303924184*^9, 
   3.5376413072198143`*^9}, 3.5376922088451233`*^9, {3.5376922522948723`*^9, 
   3.5376922570380983`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a0", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a1", "=", 
   RowBox[{"-", "1"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T3", "=", 
    RowBox[{"-", "1"}]}], " ", ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nsol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ell1", "\[Equal]", "0"}], ",", 
        RowBox[{"ell2", "\[Equal]", "0"}], ",", 
        RowBox[{"ell3", "\[Equal]", "0"}], ",", 
        RowBox[{"ell4", "\[Equal]", "0"}], ",", 
        RowBox[{"ell5", "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"p", "[", "eps", "]"}], "\[Equal]", 
         RowBox[{"initp", "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"p", "'"}], "[", "eps", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"initp", "'"}], "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{"h", "[", "eps", "]"}], "\[Equal]", 
         RowBox[{"inith", "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"h", "'"}], "[", "eps", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"inith", "'"}], "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{"a", "[", "eps", "]"}], "\[Equal]", 
         RowBox[{"inita", "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "'"}], "[", "eps", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"inita", "'"}], "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{"T", "[", "eps", "]"}], "\[Equal]", 
         RowBox[{"initT", "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"T", "'"}], "[", "eps", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"initT", "'"}], "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{"S", "[", "eps", "]"}], "\[Equal]", 
         RowBox[{"initS", "[", "eps", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"S", "'"}], "[", "eps", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"initS", "'"}], "[", "eps", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5376407771099586`*^9, 3.53764077742128*^9}, {
  3.537640849432414*^9, 3.537641029700471*^9}, {3.537641083186082*^9, 
  3.5376410832815037`*^9}, {3.537641227496984*^9, 3.537641241071927*^9}, {
  3.537641278231781*^9, 3.53764129200132*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"T", "[", "z", "]"}], "/.", "nsol"}], ",", 
      RowBox[{"1", "-", 
       RowBox[{"z", "^", "3"}], "+", 
       RowBox[{
        FractionBox["1", "4"], 
        RowBox[{"a1", "^", "2"}], " ", 
        RowBox[{"z", "^", "4"}]}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "eps", ",", "zmax"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"S", "[", "z", "]"}], "/.", "nsol"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "eps", ",", "zmax"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.537641021281739*^9, 3.5376410662087173`*^9}, {
  3.537641156431985*^9, 3.5376411621997757`*^9}, {3.537641246199189*^9, 
  3.537641249886531*^9}, {3.537641281045887*^9, 3.537641289735113*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"p", "[", "z", "]"}], "/.", "nsol"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "eps", ",", "zmax"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", "z", "]"}], "/.", "nsol"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "eps", ",", "zmax"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.537641050904498*^9, 3.537641055312849*^9}, {
  3.537641294238761*^9, 3.537641295518605*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "z", "]"}], "/.", "nsol"}], ",", 
     RowBox[{"1", "+", 
      RowBox[{"a1", " ", "z"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "eps", ",", "zmax"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.537641059744339*^9, {3.537641261805554*^9, 3.5376412988785667`*^9}}],

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<\\n\\nHorizon expansion\\n\\n\>\"", 
  "]"}]], "Input",
 CellChangeTimes->{{3.537692438367104*^9, 3.537692455488873*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"a0", ",", "a1", ",", "T3", ",", "p2", ",", "h2"}], "]"}]], "Input",\

 CellChangeTimes->{{3.5376925800122547`*^9, 3.537692597336418*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"t1", 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{"t2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"t3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", "z_", "]"}], ":=", 
   RowBox[{"s0", "+", 
    RowBox[{"s1", 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{"s2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"s3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{"a0", "+", 
    RowBox[{"a1", 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{"a2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"a3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", 
   RowBox[{"p0", "+", 
    RowBox[{"p1", 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{"p2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"p3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "[", "z_", "]"}], ":=", 
  RowBox[{"h0", "+", 
   RowBox[{"h1", 
    RowBox[{"(", 
     RowBox[{"1", "-", "z"}], ")"}]}], "+", 
   RowBox[{"h2", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
   RowBox[{"h3", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.537692460831832*^9, 3.537692571971863*^9}, {
  3.537692934161448*^9, 3.537692935150085*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell4", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell5", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ellc1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ellc2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"ellc3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}]}], "Input",\

 CellChangeTimes->{{3.5376924313861713`*^9, 3.5376924321280107`*^9}, {
  3.537692603024666*^9, 3.5376926626752777`*^9}, {3.5376929142931623`*^9, 
  3.5376929231515837`*^9}, {3.537693005499406*^9, 3.537693011387006*^9}, {
  3.537693059895008*^9, 3.537693100288628*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"t1", 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{"t2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"t3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", "z_", "]"}], ":=", 
   RowBox[{"s0", "+", 
    RowBox[{"s1", 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{"s2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"s3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"a1", 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{"a2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"a3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", 
   RowBox[{"p0", "+", 
    RowBox[{"p1", 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{"p2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"p3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "[", "z_", "]"}], ":=", 
  RowBox[{"h0", "+", 
   RowBox[{"h1", 
    RowBox[{"(", 
     RowBox[{"1", "-", "z"}], ")"}]}], "+", 
   RowBox[{"h2", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
   RowBox[{"h3", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.537692460831832*^9, 3.537692571971863*^9}, {
  3.537692934161448*^9, 3.53769296635035*^9}, {3.537693140229848*^9, 
  3.537693141045608*^9}, {3.53786590354208*^9, 3.5378659039737663`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell4", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell5", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ellc1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ellc2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"ellc3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}]}], "Input",\

 CellChangeTimes->{{3.5376924313861713`*^9, 3.5376924321280107`*^9}, {
  3.537692603024666*^9, 3.5376926626752777`*^9}, {3.5376929142931623`*^9, 
  3.5376929231515837`*^9}, {3.537693005499406*^9, 3.537693011387006*^9}, {
  3.537693059895008*^9, 3.537693100288628*^9}}],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmp1", ",", "tmp2", ",", "tmp7"}], "}"}], "\[Equal]", "0"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"h1", ",", "p1", ",", "s1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.537693102712153*^9, 3.53769311358339*^9}, {
  3.5376931532121267`*^9, 3.537693191714161*^9}, {3.5378111068659687`*^9, 
  3.5378111069455633`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"t1", 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{"t2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"t3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", "z_", "]"}], ":=", 
   RowBox[{"s0", "-", 
    RowBox[{
     FractionBox[
      RowBox[{"s0", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a1", "2"], "-", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            SuperscriptBox["h0", "2"], "+", 
            SuperscriptBox["p0", "2"], "-", "t1"}], ")"}]}]}], ")"}]}], 
      RowBox[{"4", " ", "t1"}]], 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{"s2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"s3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"a1", 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{"a2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"a3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", 
   RowBox[{"p0", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"a1", " ", "h0"}], "+", 
         RowBox[{"2", " ", "p0"}]}], "t1"]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{"p2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"p3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "[", "z_", "]"}], ":=", 
  RowBox[{"h0", "+", 
   RowBox[{
    RowBox[{"(", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "h0"}], "+", 
       RowBox[{"a1", " ", "p0"}]}], "t1"], ")"}], 
    RowBox[{"(", 
     RowBox[{"1", "-", "z"}], ")"}]}], "+", 
   RowBox[{"h2", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
   RowBox[{"h3", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.537692460831832*^9, 3.537692571971863*^9}, {
   3.537692934161448*^9, 3.53769296635035*^9}, {3.537693140229848*^9, 
   3.537693141045608*^9}, {3.537810802983768*^9, 3.537810816647912*^9}, 
   3.537810855901505*^9, {3.537811131706603*^9, 3.5378111636978893`*^9}, {
   3.53786591840762*^9, 3.537865930935507*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell4", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell5", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ellc1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ellc2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"ellc3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}]}], "Input",\

 CellChangeTimes->{{3.5376924313861713`*^9, 3.5376924321280107`*^9}, {
  3.537692603024666*^9, 3.5376926626752777`*^9}, {3.5376929142931623`*^9, 
  3.5376929231515837`*^9}, {3.537693005499406*^9, 3.537693011387006*^9}, {
  3.537693059895008*^9, 3.537693100288628*^9}}],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
       "tmp7"}], "}"}], "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"t2", ",", "p2", ",", "h2", ",", "s2", ",", "a2"}], "}"}]}], 
   "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.537693102712153*^9, 3.53769311358339*^9}, {
  3.5376931532121267`*^9, 3.537693191714161*^9}, {3.537810943517749*^9, 
  3.537810974935748*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"t1", 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a1", "2"], "-", 
         RowBox[{"2", " ", "t1"}]}], ")"}]}], ")"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"t3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", "z_", "]"}], ":=", 
   RowBox[{"s0", "-", 
    RowBox[{
     FractionBox[
      RowBox[{"s0", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a1", "2"], "-", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            SuperscriptBox["h0", "2"], "+", 
            SuperscriptBox["p0", "2"], "-", "t1"}], ")"}]}]}], ")"}]}], 
      RowBox[{"4", " ", "t1"}]], 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "+", 
           SuperscriptBox["a1", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["h0", "2"], "+", 
           SuperscriptBox["p0", "2"]}], ")"}], " ", "s0"}], 
        RowBox[{"4", " ", 
         SuperscriptBox["t1", "2"]}]]}], ")"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"s3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"a1", 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      FractionBox[
       RowBox[{"a1", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a1", "2"], "+", 
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "3"}], "+", "t1"}], ")"}]}]}], ")"}]}], 
       RowBox[{"4", " ", "t1"}]], ")"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"a3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", 
   RowBox[{"p0", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"a1", " ", "h0"}], "+", 
         RowBox[{"2", " ", "p0"}]}], "t1"]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      FractionBox[
       RowBox[{
        RowBox[{
         SuperscriptBox["a1", "3"], " ", "h0"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a1", "2"], " ", "p0"}], "+", 
        RowBox[{"4", " ", "a1", " ", "h0", " ", 
         RowBox[{"(", 
          RowBox[{"7", "-", 
           RowBox[{"2", " ", "t1"}]}], ")"}]}], "+", 
        RowBox[{"8", " ", "p0", " ", 
         RowBox[{"(", 
          RowBox[{"4", "+", 
           SuperscriptBox["h0", "2"], "+", 
           SuperscriptBox["p0", "2"], "-", 
           RowBox[{"2", " ", "t1"}]}], ")"}]}]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["t1", "2"]}]], ")"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"p3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "[", "z_", "]"}], ":=", 
  RowBox[{"h0", "+", 
   RowBox[{
    RowBox[{"(", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "h0"}], "+", 
       RowBox[{"a1", " ", "p0"}]}], "t1"], ")"}], 
    RowBox[{"(", 
     RowBox[{"1", "-", "z"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "8"}], " ", 
         SuperscriptBox["h0", "3"]}], "+", 
        RowBox[{"a1", " ", "p0", " ", 
         RowBox[{"(", 
          RowBox[{"28", "+", 
           SuperscriptBox["a1", "2"], "-", 
           RowBox[{"8", " ", "t1"}]}], ")"}]}], "+", 
        RowBox[{"4", " ", "h0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "8"}], "+", 
           SuperscriptBox["a1", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p0", "2"]}], "+", 
           RowBox[{"4", " ", "t1"}]}], ")"}]}]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["t1", "2"]}]]}], ")"}], " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}], "+", 
   RowBox[{"h3", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.537692460831832*^9, 3.537692571971863*^9}, {
   3.537692934161448*^9, 3.53769296635035*^9}, {3.537693140229848*^9, 
   3.537693141045608*^9}, {3.537810802983768*^9, 3.537810816647912*^9}, 
   3.537810855901505*^9, {3.537811131706603*^9, 3.5378111636978893`*^9}, {
   3.537811299180726*^9, 3.537811332180176*^9}, {3.537865939344338*^9, 
   3.537865984490509*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell4", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ell5", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", 
        RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ellc1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"ellc2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"ellc3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "1", ",", "pos"}], "}"}]}], "]"}], "]"}]}]}], "Input",\

 CellChangeTimes->{{3.5376924313861713`*^9, 3.5376924321280107`*^9}, {
  3.537692603024666*^9, 3.5376926626752777`*^9}, {3.5376929142931623`*^9, 
  3.5376929231515837`*^9}, {3.537693005499406*^9, 3.537693011387006*^9}, {
  3.537693059895008*^9, 3.537693100288628*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"T", ",", "S", ",", "a", ",", "p", ",", "h"}], "]"}]], "Input",
 CellChangeTimes->{{3.5378113744696207`*^9, 3.537811377716566*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"initT", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"t1", 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a1", "2"], "-", 
         RowBox[{"2", " ", "t1"}]}], ")"}]}], ")"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initS", "[", "z_", "]"}], ":=", 
   RowBox[{"s0", "-", 
    RowBox[{
     FractionBox[
      RowBox[{"s0", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a1", "2"], "-", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            SuperscriptBox["h0", "2"], "+", 
            SuperscriptBox["p0", "2"], "-", "t1"}], ")"}]}]}], ")"}]}], 
      RowBox[{"4", " ", "t1"}]], 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "+", 
           SuperscriptBox["a1", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["h0", "2"], "+", 
           SuperscriptBox["p0", "2"]}], ")"}], " ", "s0"}], 
        RowBox[{"4", " ", 
         SuperscriptBox["t1", "2"]}]]}], ")"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"inita", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"a1", 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      FractionBox[
       RowBox[{"a1", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a1", "2"], "+", 
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "3"}], "+", "t1"}], ")"}]}]}], ")"}]}], 
       RowBox[{"4", " ", "t1"}]], ")"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initp", "[", "z_", "]"}], ":=", 
   RowBox[{"p0", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"a1", " ", "h0"}], "+", 
         RowBox[{"2", " ", "p0"}]}], "t1"]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      FractionBox[
       RowBox[{
        RowBox[{
         SuperscriptBox["a1", "3"], " ", "h0"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a1", "2"], " ", "p0"}], "+", 
        RowBox[{"4", " ", "a1", " ", "h0", " ", 
         RowBox[{"(", 
          RowBox[{"7", "-", 
           RowBox[{"2", " ", "t1"}]}], ")"}]}], "+", 
        RowBox[{"8", " ", "p0", " ", 
         RowBox[{"(", 
          RowBox[{"4", "+", 
           SuperscriptBox["h0", "2"], "+", 
           SuperscriptBox["p0", "2"], "-", 
           RowBox[{"2", " ", "t1"}]}], ")"}]}]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["t1", "2"]}]], ")"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inith", "[", "z_", "]"}], ":=", 
  RowBox[{"h0", "+", 
   RowBox[{
    RowBox[{"(", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "h0"}], "+", 
       RowBox[{"a1", " ", "p0"}]}], "t1"], ")"}], 
    RowBox[{"(", 
     RowBox[{"1", "-", "z"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "8"}], " ", 
         SuperscriptBox["h0", "3"]}], "+", 
        RowBox[{"a1", " ", "p0", " ", 
         RowBox[{"(", 
          RowBox[{"28", "+", 
           SuperscriptBox["a1", "2"], "-", 
           RowBox[{"8", " ", "t1"}]}], ")"}]}], "+", 
        RowBox[{"4", " ", "h0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "8"}], "+", 
           SuperscriptBox["a1", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p0", "2"]}], "+", 
           RowBox[{"4", " ", "t1"}]}], ")"}]}]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["t1", "2"]}]]}], ")"}], " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], "^", "2"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.5378659985212517`*^9, 3.537866017991253*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p0", ",", "h0", ",", "a1", ",", "t1", ",", "s0"}], "]"}]], "Input",\

 CellChangeTimes->{{3.537811555196025*^9, 3.537811562350465*^9}, {
  3.537866029254941*^9, 3.5378660295589943`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p0", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h0", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a1", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t1", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s0", "=", "1"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5376408331474543`*^9, 3.537640843976453*^9}, {
   3.537641005880987*^9, 3.53764100596068*^9}, {3.537641224558692*^9, 
   3.537641224830652*^9}, {3.537692168427661*^9, 3.537692201057229*^9}, {
   3.537692270022526*^9, 3.537692295357997*^9}, {3.53781149172398*^9, 
   3.537811521446629*^9}, {3.537811876268148*^9, 3.537811876675826*^9}, 
   3.537811927176146*^9, {3.537866032846787*^9, 3.537866035070747*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"zhoriz", "=", "1.00001"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eps", "=", "0.0001"}], " ", ";"}]}], "Input",
 CellChangeTimes->{{3.537640888681366*^9, 3.537640891919183*^9}, {
   3.537641169191256*^9, 3.537641169558916*^9}, {3.537641303924184*^9, 
   3.5376413072198143`*^9}, 3.5376922088451233`*^9, {3.5376922522948723`*^9, 
   3.5376922570380983`*^9}, {3.537811573311179*^9, 3.537811578798229*^9}, {
   3.5378116149204397`*^9, 3.537811618199891*^9}, {3.5378117042540007`*^9, 
   3.5378117091418324`*^9}, {3.5378117876885777`*^9, 
   3.5378117881843357`*^9}, {3.537865825552787*^9, 3.537865825712695*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"nsol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ell1", "\[Equal]", "0"}], ",", 
        RowBox[{"ell2", "\[Equal]", "0"}], ",", 
        RowBox[{"ell3", "\[Equal]", "0"}], ",", 
        RowBox[{"ell4", "\[Equal]", "0"}], ",", 
        RowBox[{"ell5", "\[Equal]", "0"}], ",", 
        RowB