(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    680935,      18602]
NotebookOptionsPosition[    671710,      18329]
NotebookOutlinePosition[    673052,      18376]
CellTagsIndexPosition[    672978,      18371]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Dynamic AdS/CMT - Superconductor - Spectral", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
   3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
   3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
   3.495174647742872*^9, 3.460515504326817*^9}, {3.503996600043788*^9, 
   3.503996603042028*^9}, {3.507011572545054*^9, 3.460340667971311*^9}, {
   3.5374843541262083`*^9, 3.537484358716886*^9}, 3.537484391202265*^9, {
   3.537484629914453*^9, 3.537484630281348*^9}, {3.5374893532274837`*^9, 
   3.537489358050692*^9}, {3.53749388933057*^9, 3.537493890193932*^9}, {
   3.537578587160997*^9, 3.5375785895997057`*^9}, {3.537578682265374*^9, 
   3.537578682504321*^9}, {3.537578812305402*^9, 3.537578812720454*^9}, 
   3.5388963971621933`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[BoxData["\<\"hmm\"\>"], "Print",
 CellChangeTimes->{3.53880794268043*^9, 3.5388094999351063`*^9, 
  3.538892998666171*^9, 3.53889645098283*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
   "gzz"}], "}"}]], "Output",
 CellChangeTimes->{3.538807942880889*^9, 3.538809500119602*^9, 
  3.5388929991734333`*^9, 3.538896451199483*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"gtt", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "grr", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "g\[Theta]\[Theta]", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "g\[Phi]\[Phi]", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "gzz"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538807942880889*^9, 3.538809500119602*^9, 
  3.5388929991734333`*^9, 3.538896451201378*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{3.538807942964953*^9, 3.5388095002033463`*^9, 
  3.538892999259852*^9, 3.5388964512545843`*^9}],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{3.538807942964953*^9, 3.5388095002033463`*^9, 
  3.538892999259852*^9, 3.5388964512559433`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538807943254242*^9, 3.5388095003420277`*^9, 
  3.538893001752389*^9, 3.5388964518555117`*^9}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{3.538807943254242*^9, 3.5388095003420277`*^9, 
  3.538893001752389*^9, 3.538896451856819*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "^", "2"}]], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"-", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "0", "0"},
       {
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}], "0"},
       {"0", "0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.507011580676421*^9, 3.507011659804162*^9}, {3.507013755598536*^9, 
   3.460392698323369*^9}, {3.4604018613321533`*^9, 3.4604018646719627`*^9}, {
   3.460401965632374*^9, 3.460401968163259*^9}, {3.4604023388162813`*^9, 
   3.4604023558966084`*^9}, {3.460402422665003*^9, 3.460402426690833*^9}, {
   3.460402628586185*^9, 3.4604026419139843`*^9}, {3.460402674350209*^9, 
   3.4604026844332027`*^9}, {3.460512773931822*^9, 3.460512787444798*^9}, {
   3.4605146484667263`*^9, 3.460514650350994*^9}, {3.460514717258254*^9, 
   3.460514724283691*^9}, 3.460514770989304*^9, 3.4605223140457373`*^9, {
   3.4605327188171663`*^9, 3.460532727004561*^9}, {3.460532863547011*^9, 
   3.460532865145266*^9}, {3.460532977769042*^9, 3.4605329860852757`*^9}, {
   3.507275497143169*^9, 3.4603659980232763`*^9}, {3.537484515197036*^9, 
   3.537484572210073*^9}, 3.537484644682625*^9, {3.5374846959240923`*^9, 
   3.537484701892157*^9}, {3.537484976337736*^9, 3.5374849917355137`*^9}, {
   3.537486594817341*^9, 3.537486596777007*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     FractionBox[
      RowBox[{"gzz", "[", 
       RowBox[{"v", ",", "z"}], "]"}], 
      SuperscriptBox["z", "2"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5388079438542337`*^9, 3.5388095008098*^9, 
  3.538893002447278*^9, 3.538896452961425*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]], "Output",
 CellChangeTimes->{3.5388079438542337`*^9, 3.5388095008098*^9, 
  3.538893002447278*^9, 3.538896452964883*^9}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.5388079438542337`*^9, 3.5388095008098*^9, 
  3.538893002447278*^9, 3.53889645296719*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gd"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     FractionBox[
      RowBox[{"gzz", "[", 
       RowBox[{"v", ",", "z"}], "]"}], 
      SuperscriptBox["z", "2"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807943934894*^9, 3.538809500888975*^9, 
  3.53889300261425*^9, 3.538896453190695*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
       RowBox[{
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"T", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}]], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["z", "2"], 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["z", "2"], 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807944009327*^9, 3.538809500962566*^9, 
  3.538893002689948*^9, 3.5388964532649927`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
      RowBox[{
       RowBox[{"gzz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
   SuperscriptBox["z", "8"]]}]], "Output",
 CellChangeTimes->{3.538807944075788*^9, 3.538809501123672*^9, 
  3.5388930027566423`*^9, 3.538896453331575*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",\

 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",\

 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[BoxData[
 RowBox[{
  RowBox[{"R2", "=", 
   RowBox[{"Simplify", "[", "R2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041067188341103`*^9, 3.404106720182616*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"GT", "[", 
       RowBox[{"R2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "A", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"A", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"A", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"v", ",", "d"}], "}"}], "}"}], ",", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"ST", "[", 
    RowBox[{"A", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"z", ",", "d"}], "}"}], "}"}], ",", 
     RowBox[{"az", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451383976248069*^9, 3.4513840125908737`*^9}, {
  3.451384057147691*^9, 3.451384064689735*^9}, {3.451385762395092*^9, 
  3.451385762480318*^9}, {3.451385800913571*^9, 3.451385805770357*^9}, {
  3.537484677141605*^9, 3.53748468964509*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "F", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"F", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"F", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}]}], "}"}], ",", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i2", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i1", "]"}], "]"}]}], "]"}]}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4041040239360247`*^9, 3.404104073416904*^9}, {
  3.4041057167733383`*^9, 3.4041057183570337`*^9}, {3.4513840707957897`*^9, 
  3.451384164343499*^9}, {3.460366100458836*^9, 3.460366108909464*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"trFF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"trT", "[", 
      RowBox[{
       RowBox[{"outerT", "[", 
        RowBox[{"F", ",", "F"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fsqr", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"trT", "[", 
     RowBox[{"trFF", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.404103126230957*^9, 3.404103206051724*^9}, 
   3.404103788928409*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "Dp", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"Dp", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Dp", "=", 
       RowBox[{"ST", "[", 
        RowBox[{"Dp", ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], "}"}], ",", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"\[Phi]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
          RowBox[{"I", " ", 
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], 
           RowBox[{"\[Phi]", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConjDp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "d", "}"}], ",", 
      RowBox[{"Conjugate", "[", 
       RowBox[{"Dp", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DpDp", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{"trT", "[", 
       RowBox[{
        RowBox[{"outerT", "[", 
         RowBox[{"ConjDp", ",", "Dp"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Vterm", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"\[Phi]", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "]"}], 
       RowBox[{"\[Phi]", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513844331121693`*^9, 3.451384521665413*^9}, {
   3.451384560554626*^9, 3.451384642158163*^9}, {3.4513849100950413`*^9, 
   3.451384915054587*^9}, 3.451385051803838*^9, {3.4513851171366262`*^9, 
   3.45138511927711*^9}, {3.451385175930884*^9, 3.451385183167452*^9}, {
   3.451385425505906*^9, 3.45138544324051*^9}, {3.451385490350021*^9, 
   3.451385493946774*^9}, {3.451385568392873*^9, 3.451385601054823*^9}, {
   3.451385813165941*^9, 3.4513858527683163`*^9}, {3.45138608116168*^9, 
   3.451386103913107*^9}, {3.46036707784975*^9, 3.460255762501432*^9}, {
   3.46025580130457*^9, 3.460255801461816*^9}, {3.53748492894665*^9, 
   3.53748495518618*^9}, {3.537485329580826*^9, 3.537485331297533*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DpDp", "=", 
   RowBox[{"(", 
    RowBox[{"DpDp", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Re", "[", "xx_", "]"}], "\[Rule]", "xx"}], ",", 
       RowBox[{
        RowBox[{"Im", "[", "xx_", "]"}], "\[Rule]", "0"}]}], "}"}]}], ")"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.451385894732107*^9, 3.451385976334114*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sqrtdetg", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Det", "[", 
       RowBox[{"-", "Gd"}], "]"}], "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041041692972*^9, 3.404104211096949*^9}, 
   3.404105293940057*^9, {3.4513842180130997`*^9, 3.4513842223260803`*^9}, {
   3.4513846617079067`*^9, 3.451384675916638*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"sqrtdetg", 
    RowBox[{"(", 
     RowBox[{"Ricci", "+", "6", "-", 
      RowBox[{
       FractionBox["1", "4"], "Fsqr"}], "-", "DpDp", "-", "Vterm"}], 
     ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.451384367735067*^9, 3.451384393946628*^9}, {
   3.4513849054437723`*^9, 3.4513849068431387`*^9}, {3.451385606138598*^9, 
   3.451385607193993*^9}, 3.460366276193363*^9, {3.4603670917067547`*^9, 
   3.460255829896731*^9}, 3.537493905932642*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp1", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp3", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.53748653613297*^9, 3.5374865918283*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GHBT", "+=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
     "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460366441552243*^9, 3.460366544772176*^9}, {
  3.4603665879440317`*^9, 3.460366626391823*^9}, {3.537486655723679*^9, 
  3.537486732610427*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L2", "=", 
   RowBox[{"L", "-", "GHBT"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460366546941235*^9, 3.460366557341961*^9}, 
   3.460366686117609*^9, {3.4603672960654507`*^9, 3.4603672977104673`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"L2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.460366666517003*^9, 3.460366674775579*^9}, {3.537486746662644*^9, 
  3.5374867639666147`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.538809506685401*^9, 
  3.538893008907069*^9, 3.538896459564533*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.538809506685401*^9, 
  3.538893008907069*^9, 3.538896459621476*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.538809506685401*^9, 
  3.538893008907069*^9, 3.538896459623784*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.538809506685401*^9, 
  3.538893008907069*^9, 3.538896459687975*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"EOM", "[", "fld_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{"D", "[", 
      RowBox[{"L2", ",", "fld"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"tmp2", "=", 
           RowBox[{"D", "[", 
            RowBox[{"fld", ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ")"}], "=!=", "0"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tmp", "-=", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"L2", ",", "tmp2"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "tmp"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.4513849546200113`*^9, 3.451385039242148*^9}, {
  3.4603662728020573`*^9, 3.460366273871294*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqp", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"p", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"\[Alpha]", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513848144544163`*^9, 3.4513848150159073`*^9}, {
  3.451384869337384*^9, 3.451384875673843*^9}, {3.451384929950244*^9, 
  3.451384930100154*^9}, {3.451385060851385*^9, 3.451385213396349*^9}, {
  3.451385293160893*^9, 3.451385302528058*^9}, {3.4513853749547167`*^9, 
  3.45138537639461*^9}, {3.451385514552088*^9, 3.451385527943191*^9}, {
  3.451385862306609*^9, 3.451385882826736*^9}, {3.451386138230373*^9, 
  3.451386140019012*^9}, {3.451386241895258*^9, 3.4513862693654633`*^9}, {
  3.4603675858592987`*^9, 3.4603675914720583`*^9}, {3.537486779881022*^9, 
  3.537486784922683*^9}, {3.537486894453556*^9, 3.5374869009568243`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqav", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"av", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"az", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513855403702793`*^9, 3.451385540823719*^9}, {
  3.4513861532442207`*^9, 3.45138616739637*^9}, {3.451386251199284*^9, 
  3.4513862656960487`*^9}, {3.460367593073217*^9, 3.460367597640524*^9}, {
  3.5374867866028214`*^9, 3.537486788378339*^9}, {3.537486891597521*^9, 
  3.537486937732339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqgvz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gvz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqgzz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gzz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqT", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"T", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqS", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451386275930722*^9, 3.451386303859261*^9}, {
  3.460366711720347*^9, 3.4603667226381903`*^9}, {3.460367599130735*^9, 
  3.460367611985876*^9}, {3.53748678993122*^9, 3.53748680663302*^9}, {
  3.537486911477583*^9, 3.5374869187572203`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"gvz", ",", "gzz", ",", "az"}], "]"}]], "Input",
 CellChangeTimes->{{3.53748694036823*^9, 3.537486945275868*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"gvz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gzz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"az", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}]}], "Input",
 CellChangeTimes->{{3.460366755240944*^9, 3.460366765921853*^9}, {
   3.460379717667384*^9, 3.460379720321673*^9}, {3.4603938524268913`*^9, 
   3.4603938546559877`*^9}, 3.4603939628549967`*^9, {3.5374868640225983`*^9, 
   3.537486876197587*^9}, {3.537486924492758*^9, 3.537486925572747*^9}, {
   3.537487030062772*^9, 3.537487030117689*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqp2", "=", 
   RowBox[{"Simplify", "[", "eqp", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]2", "=", 
   RowBox[{"Simplify", "[", "eq\[Alpha]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqav2", "=", 
   RowBox[{"Simplify", "[", "eqav", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz2", "=", 
   RowBox[{"Simplify", "[", "eqaz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgvz2", "=", 
   RowBox[{"Simplify", "[", "eqgvz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgzz2", "=", 
   RowBox[{"Simplify", "[", "eqgzz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqT2", "=", 
   RowBox[{"Simplify", "[", "eqT", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"eqS2", "=", 
  RowBox[{"Simplify", "[", "eqS", "]"}]}]}], "Input",
 CellChangeTimes->{{3.460366768598325*^9, 3.4603668525536737`*^9}, {
  3.5374869590367947`*^9, 3.537486972220312*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}]], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"S", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "4"], 
       SuperscriptBox["z", "8"]]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"p", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"av", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"\[Alpha]", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["S", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"S", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"\[Alpha]", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["\[Alpha]", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
         
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"T", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], " ", 
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["S", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{
              SuperscriptBox["S", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["S", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"S", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"\[Alpha]", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["av", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["T", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"T", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                RowBox[{
                 SuperscriptBox["p", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "-", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["p", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"2", " ", "z", " ", 
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.538896460226338*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"S", "[", 
    RowBox[{"v", ",", "z"}], "]"}]], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", " ", 
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"S", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["av", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               RowBox[{
                SuperscriptBox["\[Alpha]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["\[Alpha]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.538896460317429*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["av", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["av", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["z", "6"], " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]]}]]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.538896460391739*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["z", "14"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "4"], 
        SuperscriptBox["z", "8"]]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "7"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["av", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["av", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",\

 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.538896460395775*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "2"]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"\[Alpha]", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["av", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "6"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
     "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",\

 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.5388964605896873`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "2"]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"av", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"T", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{"\[Alpha]", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"T", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "6"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"12", "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"p", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"\[Alpha]", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["z", "4"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["av", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{"4", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{"z", " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
     "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox[
          RowBox[{"T", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{
              SuperscriptBox["T", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"2", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.5388964608675747`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["z", "6"], " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]]}]]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.538896460943019*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["z", "16"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "4"], 
        SuperscriptBox["z", "8"]]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "6"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"\[Alpha]", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["av", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"av", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"8", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"av", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"6", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",\

 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.538896461049302*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"z", "^", "3"}], "+", 
    RowBox[{
     FractionBox["1", "4"], 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", "eqp2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eq\[Alpha]2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqav2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqaz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqgvz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqgzz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqT2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "eqS2", "]"}]}], "Input",
 CellChangeTimes->{{3.507012905387106*^9, 3.507012910083256*^9}, {
  3.5070145245498*^9, 3.4603669411156473`*^9}, {3.5374870758129187`*^9, 
  3.5374870842285547`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.538809508015464*^9, 
  3.538893010261808*^9, 3.538896461337632*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.538809508015464*^9, 
  3.538893010261808*^9, 3.538896461339913*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.538809508015464*^9, 
  3.538893010261808*^9, 3.538896461341598*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.538809508015464*^9, 
  3.538893010261808*^9, 3.538896461343306*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.538809508015464*^9, 
  3.538893010261808*^9, 3.538896461345006*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.538809508015464*^9, 
  3.538893010261808*^9, 3.53889646134669*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.538809508015464*^9, 
  3.538893010261808*^9, 3.538896461348382*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.538809508015464*^9, 
  3.538893010261808*^9, 3.538896461350051*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"\[Alpha]", ",", "p", ",", "av", ",", "T", ",", "S"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4603676469897413`*^9, 3.460367657697607*^9}, {
  3.4603797352914047`*^9, 3.460379735508092*^9}, {3.5374870733721457`*^9, 
  3.537487073532263*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"z", " ", 
    RowBox[{"f", "[", 
     RowBox[{"v", ",", "z"}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"z", " ", 
    RowBox[{"h", "[", 
     RowBox[{"v", ",", "z"}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"m", "[", "v", "]"}], "+", 
    RowBox[{"z", " ", 
     RowBox[{"a", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], " ", 
     RowBox[{"t", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"z", "^", "2"}], " ", 
    RowBox[{"s", "[", 
     RowBox[{"v", ",", "z"}], "]"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.537494166786066*^9, 3.537494209239134*^9}, 
   3.5375534855250597`*^9, {3.537578844859714*^9, 3.537578847402349*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Evsol", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqgvz2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqS2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqp2", "\[Equal]", "0"}], ",", 
        RowBox[{"eq\[Alpha]2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqaz", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4603794747692738`*^9, 3.4603795051117373`*^9}, {
   3.460379770556391*^9, 3.460379778090231*^9}, {3.537487575145343*^9, 
   3.537487601737835*^9}, {3.5374876320607243`*^9, 3.537487632172414*^9}, 
   3.5374876986147537`*^9, {3.537494224185582*^9, 3.537494230128457*^9}, {
   3.537494336674205*^9, 3.537494337210093*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"z", " ", 
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"m", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "z", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["z", "3"], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["z", "3"], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "z", " ", 
              RowBox[{"m", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"4", "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "3"], " ", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "2"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             RowBox[{"4", " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", "z", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "3"], " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"4", " ", "z", " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["z", "3"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "z", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["z", "3"], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           SuperscriptBox["z", "3"], " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"4", " ", "z", " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}]], 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], 
          SuperscriptBox["z", "2"]]}], "-", 
        RowBox[{
         FractionBox["1", 
          SuperscriptBox["z", "2"]], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"a", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"f", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
               SuperscriptBox[
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"f", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
             RowBox[{"m", "[", "v", "]"}]}], "+", 
            RowBox[{
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], " ", 
                RowBox[{"m", "[", "v", "]"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                RowBox[{
                 SuperscriptBox["h", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "-", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["a", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["t", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", 
         RowBox[{
          SuperscriptBox["z", "3"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"a", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
          RowBox[{"6", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "3"], " ", 
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"m", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
       RowBox[{"z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "z", " ", 
           SuperscriptBox[
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "z"}], " ", 
              RowBox[{"m", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"6", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "-", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["z", "2"]}], " ", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["a", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["z", "6"]}], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["z", "2"], "+", 
                   RowBox[{
                    SuperscriptBox["z", "6"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", 
                   RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"6", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                   RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["s", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                   RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
             "+", 
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"4", "+", 
                   RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"z", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["z", "3"]}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                   RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "4"]}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"12", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
         RowBox[{
          SuperscriptBox["z", "4"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["a", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"f", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}]}], 
           ")"}]}], "+", 
         FractionBox[
          RowBox[{"16", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}]], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["z", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["t", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}]], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["z", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["s", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
             RowBox[{"2", " ", "z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]]}], 
        ")"}]}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807968763275*^9, 3.53880952562223*^9, 
  3.538893028348871*^9, 3.538896480461392*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Momsol", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqT2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqgzz", "\[Equal]", "0"}], ",", 
        RowBox[{"eqav", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.460379791348405*^9, 3.460379854266864*^9}, {
  3.537487577120059*^9, 3.537487629667873*^9}, {3.5374877038531513`*^9, 
  3.537487709515881*^9}, {3.537494238680642*^9, 3.53749424053545*^9}, {
  3.5374943297700453`*^9, 3.537494330345728*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"z", "+", 
        RowBox[{
         SuperscriptBox["z", "3"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "3"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]}]}], 
   ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"2", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "2"], "+", 
          RowBox[{
           SuperscriptBox["z", "4"], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox[
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"32", " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"f", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"h", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"t", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"m", "[", "v", "]"}], "2"]}], "+", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"4", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "3"], " ", 
         RowBox[{"a", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"m", "[", "v", "]"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["a", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"m", "[", "v", "]"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"f", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{"m", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"m", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "z", " ", 
            SuperscriptBox[
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"m", "[", "v", "]"}], "2"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
              RowBox[{"3", " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
               SuperscriptBox[
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"z", " ", 
               RowBox[{"m", "[", "v", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["t", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}], "-", 
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["t", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["z", "4"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "4"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}]}], 
                ")"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                 RowBox[{"2", " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                 RowBox[{"2", " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                ")"}]}], "-", 
              RowBox[{"z", " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                 RowBox[{"4", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "z"}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                    RowBox[{"z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "6"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{"16", "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["z", "4"], " ", 
                  SuperscriptBox[
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["z", "6"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "z"}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                 RowBox[{"4", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", 
                  SuperscriptBox["z", "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
                 "-", 
                 RowBox[{"2", " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "20"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "6"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                    RowBox[{"2", " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
                 "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                   ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}]}], 
   ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], ")"}]}], 
        "+", 
        RowBox[{"8", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}]}]}], "}"}]], "Output",\

 CellChangeTimes->{3.538807992285688*^9, 3.538809549204625*^9, 
  3.538893052647325*^9, 3.538896505678155*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqT2", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqav", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"eqgzz", ",", "z"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"Evsol", ",", "v"}], "]"}]}], "/.", "Evsol"}], "/.", "Momsol"}],
   "]"}]}], "Input",
 CellChangeTimes->{{3.460379877349128*^9, 3.460379983100644*^9}, {
  3.460380087445326*^9, 3.460380091873478*^9}, {3.537487726936469*^9, 
  3.5374877500015907`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9, 3.538809549745694*^9, 
  3.538893053183429*^9, 3.538896506321733*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9, 3.538809549745694*^9, 
  3.538893053183429*^9, 3.53889650673358*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9, 3.538809549745694*^9, 
  3.538893053183429*^9, 3.53889655232594*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Const1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Const2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Const3", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["s", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["s", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.46031768644937*^9, 3.46031772334064*^9}, {
  3.537487772329159*^9, 3.5374878178010073`*^9}, {3.537494258424617*^9, 
  3.537494262447569*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "2"]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], ")"}]}], "+", 
     
     RowBox[{"8", " ", "z", " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388080342469997`*^9, 3.5388095916039963`*^9, 
  3.538893096137225*^9, 3.53889655254184*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"z", "+", 
     RowBox[{
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]}]], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["z", "3"], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["a", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388080342469997`*^9, 3.5388095916039963`*^9, 
  3.538893096137225*^9, 3.538896552546095*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["z", "2"], "+", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"32", " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"f", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              SuperscriptBox[
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"m", "[", "v", "]"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"4", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"m", "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["a", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"m", "[", "v", "]"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{"m", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"m", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "z", " ", 
         SuperscriptBox[
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"m", "[", "v", "]"}], "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
           RowBox[{"3", " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
            SuperscriptBox[
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            RowBox[{"m", "[", "v", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "-", 
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["z", "4"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
              RowBox[{
               SuperscriptBox["z", "4"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["h", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "3"], " ", 
                   RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}]}], 
             ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{"z", " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["z", "3"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["a", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "z"}], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                 RowBox[{"z", " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "6"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
                 "+", 
                 RowBox[{"2", " ", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
           "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{"16", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "4"], " ", 
               SuperscriptBox[
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["z", "6"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                 RowBox[{"4", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "3"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "z"}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                   ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "3"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                 RowBox[{"2", " ", "z", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}], "+", 
                 RowBox[{"4", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["a", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["z", "2"], " ", 
               SuperscriptBox[
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"2", " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "20"}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "6"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                    RowBox[{"2", " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"2", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388080342469997`*^9, 3.5388095916039963`*^9, 
  3.538893096137225*^9, 3.538896552556382*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Eq1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq3", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq4", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq5", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["t", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["t", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.537489066732723*^9, 3.5374891410817547`*^9}, {
  3.537494265681246*^9, 3.537494272120749*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{"z", " ", 
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"m", "[", "v", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["z", "3"], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "z", " ", 
             RowBox[{"m", "[", "v", "]"}], " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{"4", "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "3"], " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "2"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            RowBox[{"4", " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["t", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388965526955137`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["z", "3"], " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["h", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388965527578287`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}]], 
    RowBox[{"z", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], 
         SuperscriptBox["z", "2"]]}], "-", 
       RowBox[{
        FractionBox["1", 
         SuperscriptBox["z", "2"]], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            RowBox[{"a", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"f", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              SuperscriptBox[
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"m", "[", "v", "]"}]}], "+", 
           RowBox[{
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"m", "[", "v", "]"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"f", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}]}], "+", 
  RowBox[{
   SuperscriptBox["a", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.538896552808381*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"8", " ", 
     SuperscriptBox["z", "4"]}]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"12", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
      RowBox[{
       SuperscriptBox["z", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "6"}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}]}], ")"}]}], 
      "+", 
      FractionBox[
       RowBox[{"16", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]], "-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]]}], ")"}]}]}], 
  "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388965528619556`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["t", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}], "-", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", 
       RowBox[{
        SuperscriptBox["z", "3"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{"6", " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], "+", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"m", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "z", " ", 
         SuperscriptBox[
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "z"}], " ", 
            RowBox[{"m", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["z", "2"]}], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["a", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["z", "6"]}], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["a", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["z", "2"], "+", 
                 RowBox[{
                  SuperscriptBox["z", "6"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "2"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["s", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "-", 
                 RowBox[{"2", " ", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
           "+", 
           RowBox[{"2", " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"4", "+", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"z", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["z", "3"]}], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.538896552928934*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", "v_", "]"}], ":=", "m"}], ";"}]], "Input",
 CellChangeTimes->{{3.538894616535939*^9, 3.538894621636359*^9}, 
   3.538896479565377*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"f", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"h", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"a", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"s", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"t", "[", "z", "]"}]}]}], "Input",
 CellChangeTimes->{{3.538893220712365*^9, 3.5388932773084*^9}, {
  3.538896496023963*^9, 3.5388965000073137`*^9}, {3.538896659656444*^9, 
  3.538896669399289*^9}, {3.538896722265585*^9, 3.538896726142902*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ell1", "=", 
   RowBox[{"Simplify", "[", "Eq1", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell2", "=", 
   RowBox[{"Simplify", "[", "Eq2", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ellc1", "=", 
   RowBox[{"Simplify", "[", "Eq3", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ellc2", "=", 
   RowBox[{"Simplify", "[", "Eq4", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell3", "=", 
   RowBox[{"Simplify", "[", "Eq5", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell4", "=", 
   RowBox[{"Simplify", "[", "Const1", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell5", "=", 
   RowBox[{"Simplify", "[", "Const2", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"ellc3", "=", 
  RowBox[{"Simplify", "[", "Const3", "]"}]}]}], "Input",
 CellChangeTimes->{{3.537627679175139*^9, 3.537627742317072*^9}, {
  3.537636876281947*^9, 3.53763687844884*^9}, {3.5376379765369062`*^9, 
  3.537638074206946*^9}, {3.537638144466118*^9, 3.537638162905325*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", "z", "]"}]}]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", "m", " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"z", " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}], "+", 
        RowBox[{
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "m"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{
             SuperscriptBox["a", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", "m", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"a", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", "z", "]"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["z", "3"], " ", 
            RowBox[{
             SuperscriptBox["s", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
       ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["f", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "z", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "3"], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["t", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["s", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["t", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}], "+", 
           RowBox[{"z", " ", 
            RowBox[{"s", "[", "z", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{"t", "[", "z", "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["t", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "m", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["h", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "+", 
           RowBox[{
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"4", "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", "z", "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["z", "3"], " ", 
               RowBox[{
                SuperscriptBox["t", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
           
           RowBox[{"z", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["f", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
       ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.538896728036908*^9}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", "z", "]"}]}]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", "m", " ", "z", " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", "m", " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", "m", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", "m", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      RowBox[{"a", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", "z", "]"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["z", "3"], " ", 
            RowBox[{
             SuperscriptBox["s", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
       ")"}]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", "z", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "3"], " ", 
         RowBox[{
          SuperscriptBox["t", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["h", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "z", "]"}], "+", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.538896728171282*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"z", " ", 
         RowBox[{"a", "[", "z", "]"}]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"f", "[", "z", "]"}], "2"]}], "+", 
     RowBox[{
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", 
           RowBox[{"z", " ", 
            RowBox[{"a", "[", "z", "]"}]}]}], ")"}], " ", 
         RowBox[{"h", "[", "z", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
  "z"]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.538896728211772*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", 
    SuperscriptBox["z", "4"]}]], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"12", "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"f", "[", "z", "]"}], "2"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"h", "[", "z", "]"}], "2"]}], "-", 
     RowBox[{
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "[", "z", "]"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["a", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], "2"]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "6"}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", "[", "z", "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["f", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], "2"]}], 
        "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"h", "[", "z", "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["h", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], "2"]}]}],
        ")"}]}], "+", 
     FractionBox[
      RowBox[{"16", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"s", "[", "z", "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["s", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", "z", "]"}]}]}]], "-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"s", "[", "z", "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"]], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"t", "[", "z", "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["t", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"s", "[", "z", "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["s", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"t", "[", "z", "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["t", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", "z", "]"}]}]}]]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.538896728264453*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "+", 
        RowBox[{
         SuperscriptBox["z", "3"], " ", 
         RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"a", "[", "z", "]"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"h", "[", "z", "]"}], "2"], "+", 
         RowBox[{"6", " ", 
          RowBox[{"s", "[", "z", "]"}]}], "-", 
         RowBox[{"t", "[", "z", "]"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "z", "]"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"t", "[", "z", "]"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "+", 
         RowBox[{"m", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["h", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"a", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], "+", 
         RowBox[{
          RowBox[{"h", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "-", 
         RowBox[{
          RowBox[{"f", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["h", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "-", 
      RowBox[{"z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "z", " ", 
          SuperscriptBox[
           RowBox[{"h", "[", "z", "]"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"t", "[", "z", "]"}], "+", 
            RowBox[{
             RowBox[{"s", "[", "z", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"t", "[", "z", "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"h", "[", "z", "]"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "m"}], " ", "z", " ", 
             RowBox[{
              SuperscriptBox["f", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
             RowBox[{
              SuperscriptBox["h", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["t", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], ")"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["z", "2"]}], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["a", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"s", "[", "z", "]"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["z", "6"]}], " ", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["a", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"t", "[", "z", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["z", "2"], "+", 
                  RowBox[{
                   SuperscriptBox["z", "6"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], 
                    ")"}]}]}], ")"}]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", 
                  RowBox[{
                   SuperscriptBox["z", "3"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["h", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], "2"], "-", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["s", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["s", "\[Prime]\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], "+", 
               RowBox[{"z", " ", 
                RowBox[{"t", "[", "z", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"6", " ", 
                   RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                  RowBox[{"z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"], "-", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"s", "[", "z", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox["z", "3"]}], " ", 
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                  RowBox[{"2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], ")"}]}], "+", 
                  RowBox[{"z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                RowBox[{"t", "[", "z", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{"4", "+", 
                  RowBox[{
                   SuperscriptBox["z", "3"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], ")"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["t", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "z", "]"}]}]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.5388967286074867`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"4", " ", 
     RowBox[{"s", "[", "z", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"f", "[", "z", "]"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", "z", "]"}]}]}], ")"}]}], "+", 
    RowBox[{"2", " ", "z", " ", 
     RowBox[{"f", "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["f", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"h", "[", "z", "]"}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["h", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], "2"]}], 
      ")"}]}], "+", 
    RowBox[{"8", " ", "z", " ", 
     RowBox[{
      SuperscriptBox["s", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["z", "2"]}]], "+", 
  RowBox[{
   SuperscriptBox["s", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "z", "]"}]}]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.538896728733691*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", "z", "]"}]}]}], ")"}]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"h", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "-", 
         RowBox[{
          RowBox[{"f", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["h", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"a", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"s", "[", "z", "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["s", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", "z", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["z", "3"], " ", 
          RowBox[{
           SuperscriptBox["s", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], ")"}]}], 
   RowBox[{"z", "+", 
    RowBox[{
     SuperscriptBox["z", "3"], " ", 
     RowBox[{"s", "[", "z", "]"}]}]}]], "+", 
  RowBox[{
   SuperscriptBox["a", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "z", "]"}]}]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.53889672878319*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["z", "2"], "+", 
      RowBox[{
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", "z", "]"}]}]}], ")"}]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"h", "[", "z", "]"}], "2"]}], "+", 
    RowBox[{"32", " ", 
     RowBox[{"s", "[", "z", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     SuperscriptBox[
      RowBox[{"a", "[", "z", "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"f", "[", "z", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"]}], ")"}]}], "-", 
          RowBox[{"t", "[", "z", "]"}]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"t", "[", "z", "]"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"f", "[", "z", "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["m", "2"]}], "+", 
          RowBox[{
           RowBox[{"t", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{"4", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", "z", "]"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}],
     "+", 
    RowBox[{"4", " ", "z", " ", 
     RowBox[{"f", "[", "z", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}], "+", 
       RowBox[{"m", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["h", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "3"], " ", 
     RowBox[{"a", "[", "z", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "2"]}], "+", 
       RowBox[{"4", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"h", "[", "z", "]"}], "2"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"h", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"f", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["h", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
    RowBox[{"z", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "z", " ", 
        SuperscriptBox[
         RowBox[{"h", "[", "z", "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"s", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", "z", "]"}]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"m", "+", 
              RowBox[{"m", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
           RowBox[{"t", "[", "z", "]"}]}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"t", "[", "z", "]"}], "2"]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"h", "[", "z", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "m"}], " ", "z", " ", 
           RowBox[{
            SuperscriptBox["f", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["h", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{
            SuperscriptBox["s", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}], "+", 
          RowBox[{
           SuperscriptBox["t", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], ")"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["f", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["h", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "2"]}], ")"}]}], 
          "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"t", "[", "z", "]"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["z", "4"], " ", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["f", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
             RowBox[{
              SuperscriptBox["z", "4"], " ", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["h", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{
                   SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], 
               "2"]}]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["a", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
             RowBox[{"4", " ", 
              RowBox[{
               SuperscriptBox["s", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["s", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], "+", 
                RowBox[{
                 SuperscriptBox["t", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
            ")"}]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"s", "[", "z", "]"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["z", "6"]}], " ", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["a", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", "z", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{
                 SuperscriptBox["z", "4"], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "4"], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
               ")"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"8", "+", 
                RowBox[{
                 SuperscriptBox["z", "4"], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "4"], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox["z", "3"], " ", 
                 RowBox[{
                  SuperscriptBox["t", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
            ")"}]}], "-", 
          RowBox[{"z", " ", 
           RowBox[{"t", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["z", "3"], " ", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["a", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
             RowBox[{"4", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "z"}], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                RowBox[{"z", " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                RowBox[{
                 SuperscriptBox["t", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], "+", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["s", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "6"}], "+", 
                   RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"s", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox["z", "2"], " ", 
              SuperscriptBox[
               RowBox[{"t", "[", "z", "]"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", 
                RowBox[{
                 SuperscriptBox["z", "3"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], 
                    ")"}]}], "-", 
                   RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
               ")"}]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], 
                  ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
                   RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
               ")"}]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{"t", "[", "z", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "20"}], "+", 
                RowBox[{
                 SuperscriptBox["z", "6"], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["z", "3"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                   RowBox[{"2", " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.5388967292974043`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"sols", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "ell1", ",", "ell4", ",", "ell5", ",", "ellc1", ",", "ellc2"}], 
         "}"}], "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"f", "''"}], "[", "z", "]"}], ",", 
         RowBox[{
          RowBox[{"h", "'"}], "[", "z", "]"}], ",", 
         RowBox[{
          RowBox[{"a", "''"}], "[", "z", "]"}], ",", 
         RowBox[{
          RowBox[{"s", "''"}], "[", "z", "]"}], ",", 
         RowBox[{
          RowBox[{"t", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5388933905436563`*^9, 3.5388934127976503`*^9}, {
  3.538893443616728*^9, 3.538893463678727*^9}, {3.538894006097336*^9, 
  3.538894008494485*^9}, {3.538894136848188*^9, 3.5388941669361773`*^9}, {
  3.5388942439526367`*^9, 3.538894301336754*^9}, {3.5388965181369534`*^9, 
  3.538896523583788*^9}, {3.538896622968113*^9, 3.5388966294887323`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ell1", ",", "ell2", ",", "ell3", ",", "ell4", ",", "ell5"}], 
     "}"}], "/.", 
    RowBox[{"D", "[", 
     RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}]], "Input",
 CellChangeTimes->{{3.538894401365067*^9, 3.538894438420658*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.538894422363475*^9, 3.5388944466122417`*^9}, 
   3.5388946326671247`*^9, 3.538896571211697*^9, 3.5388967403625927`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ellc1", ",", "ellc2", ",", "ellc3"}], "}"}], "/.", 
    RowBox[{"D", "[", 
     RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}]], "Input",
 CellChangeTimes->{{3.538894421190186*^9, 3.538894449542976*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538894452163848*^9, 3.538894633133789*^9, 
  3.538896572204898*^9, 3.538896740861245*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", "v_", "]"}], ":=", "m"}], ";"}]], "Input",
 CellChangeTimes->{{3.538894616535939*^9, 3.538894621636359*^9}, 
   3.538896479565377*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"f", "[", "z", "]"}], "+", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"fp", "[", "z", "]"}], " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"h", "[", "z", "]"}], "+", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"hp", "[", "z", "]"}], 
     RowBox[{"Exp", "[", 
      RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"a", "[", "z", "]"}], "+", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"ap", "[", "z", "]"}], 
     RowBox[{"Exp", "[", 
      RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"s", "[", "z", "]"}], "+", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"sp", "[", "z", "]"}], 
     RowBox[{"Exp", "[", 
      RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"t", "[", "z", "]"}], "+", 
   RowBox[{"\[Lambda]", " ", 
    RowBox[{"tp", "[", "z", "]"}], 
    RowBox[{"Exp", "[", 
     RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.538893220712365*^9, 3.5388932773084*^9}, {
  3.538896496023963*^9, 3.5388965000073137`*^9}, {3.538896659656444*^9, 
  3.538896669399289*^9}, {3.538896722265585*^9, 3.53889675657655*^9}, {
  3.538910797475553*^9, 3.538910812169138*^9}, {3.538910933172551*^9, 
  3.5389109555646267`*^9}, {3.538911003454258*^9, 3.538911007619445*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Pell1", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"Eq1", ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Pell2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"Eq2", ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Pell3", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"Eq3", ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Pell4", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"Eq4", ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Pell5", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"Eq5", ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Pellc1", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"Const1", ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Pellc2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"Const2", ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pellc3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const3", ",", 
      RowBox[{"{", 
       RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.537627679175139*^9, 3.537627742317072*^9}, {
  3.537636876281947*^9, 3.53763687844884*^9}, {3.5376379765369062`*^9, 
  3.537638074206946*^9}, {3.537638144466118*^9, 3.537638162905325*^9}, {
  3.53889676419934*^9, 3.5388968130405397`*^9}, {3.53891063130486*^9, 
  3.538910667357551*^9}, {3.538911037688806*^9, 3.538911077439234*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SeriesCoefficient", "[", 
      RowBox[{"Pell1", ",", "0"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SeriesCoefficient", "[", 
      RowBox[{"Pell2", ",", "0"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SeriesCoefficient", "[", 
      RowBox[{"Pell3", ",", "0"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SeriesCoefficient", "[", 
      RowBox[{"Pell4", ",", "0"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SeriesCoefficient", "[", 
      RowBox[{"Pell5", ",", "0"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SeriesCoefficient", "[", 
      RowBox[{"Pellc1", ",", "0"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SeriesCoefficient", "[", 
      RowBox[{"Pellc2", ",", "0"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pellc3", ",", "0"}], "]"}], "/.", 
    RowBox[{"D", "[", 
     RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}]}], "Input",
 CellChangeTimes->{{3.538910635586172*^9, 3.538910678672346*^9}, {
  3.538911084801166*^9, 3.538911099381049*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.538911099991852*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.538911101709434*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.5389111017548933`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.5389111018645153`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.538911109895821*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.5389111098973618`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.538911109969605*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.538911110608883*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Lin1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pell1", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lin2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pell2", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lin3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pell3", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lin4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pell4", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lin5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pell5", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinC1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pellc1", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinC2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pellc2", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"LinC3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"Pellc3", ",", "1"}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.53891068699997*^9, {3.538910874784109*^9, 3.5389108826653137`*^9}, 
   3.538910968039218*^9, {3.538911030185012*^9, 3.538911032974782*^9}, {
   3.538911107200781*^9, 3.5389111365949783`*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"]}]], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}]}], "-", 
      RowBox[{"4", " ", "z", " ", "\[CapitalOmega]", " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}]}], "-", 
      RowBox[{"4", " ", "m", " ", "z", " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "3"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"]}], "-", 
      RowBox[{"4", " ", "m", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", "z", " ", "\[CapitalOmega]", " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}]}], "-", 
      RowBox[{"4", " ", "m", " ", "z", " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"t", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"tp", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"tp", "[", "z", "]"}]}], "-", 
      RowBox[{"z", " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"z", " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["ap", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["ap", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["ap", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["z", "5"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", "\[CapitalOmega]", " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "3"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", "\[CapitalOmega]", " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["z", "5"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", "m", " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"4", " ", "m", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", "m", " ", 
       SuperscriptBox["z", "4"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", "m", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", "m", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "m", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "6"], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "6"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "6"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{
       RowBox[{"ap", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["h", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "+", 
         RowBox[{
          RowBox[{"h", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", "z", "]"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
        ")"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", "m", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", "m", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "6"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{
       RowBox[{"a", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"hp", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", "z", "]"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
             RowBox[{
              SuperscriptBox["hp", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"h", "[", "z", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"sp", "[", "z", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "-", 
                  RowBox[{
                   SuperscriptBox["z", "3"], " ", 
                   RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{"z", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
                RowBox[{
                 SuperscriptBox["sp", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["t", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "6"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["tp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["tp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["tp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["tp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["tp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "6"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["tp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "6"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["fp", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "4"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "6"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}]}]], "Output",\

 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.538911139750238*^9}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"]}]], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", "m", " ", "z", " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}]}], "-", 
      RowBox[{"4", " ", "z", " ", "\[CapitalOmega]", " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", "m", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "3"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"]}], "+", 
      RowBox[{"4", " ", "m", " ", "z", " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", "z", " ", "\[CapitalOmega]", " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"t", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"tp", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"tp", "[", "z", "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["ap", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["ap", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["ap", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "m", " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", "m", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "m", " ", 
       SuperscriptBox["z", "4"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["fp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["z", "5"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", "\[CapitalOmega]", " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "3"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", "\[CapitalOmega]", " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["z", "5"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "m", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "m", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", "m", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "6"], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "6"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "6"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"ap", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", "z", "]"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
        ")"}]}], "+", 
      RowBox[{"2", " ", "m", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "m", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "6"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"a", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"fp", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", "z", "]"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
             RowBox[{
              SuperscriptBox["fp", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"f", "[", "z", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"sp", "[", "z", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "-", 
                  RowBox[{
                   SuperscriptBox["z", "3"], " ", 
                   RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{"z", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
                RowBox[{
                 SuperscriptBox["sp", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["t", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "6"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["tp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["tp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "5"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["tp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["tp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["tp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "6"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["tp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "6"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["hp", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "4"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "6"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}]}]], "Output",\

 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.5389111398199463`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"z", "+", 
    RowBox[{
     SuperscriptBox["z", "3"], " ", 
     RowBox[{"s", "[", "z", "]"}]}]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "\[CapitalOmega]", " ", 
      RowBox[{"fp", "[", "z", "]"}], " ", 
      RowBox[{"h", "[", "z", "]"}]}], "+", 
     RowBox[{"4", " ", "m", " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"hp", "[", "z", "]"}]}], "+", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"a", "[", "z", "]"}], " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"hp", "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
      RowBox[{"fp", "[", "z", "]"}], " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}]}], "+", 
     RowBox[{"4", " ", "m", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"hp", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"a", "[", "z", "]"}], " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"hp", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}]}], "+", 
     RowBox[{
      RowBox[{"ap", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[CapitalOmega]", "+", 
        RowBox[{"2", " ", "z", " ", 
         SuperscriptBox[
          RowBox[{"f", "[", "z", "]"}], "2"]}], "+", 
        RowBox[{"2", " ", "z", " ", 
         SuperscriptBox[
          RowBox[{"h", "[", "z", "]"}], "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", "z", "]"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
      RowBox[{"a", "[", "z", "]"}], " ", 
      RowBox[{"sp", "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "3"], " ", "\[CapitalOmega]", " ", 
      RowBox[{"sp", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"z", " ", "\[CapitalOmega]", " ", 
      RowBox[{
       SuperscriptBox["ap", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "3"], " ", "\[CapitalOmega]", " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["ap", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"hp", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"hp", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"hp", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"hp", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"tp", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"tp", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["fp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["fp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["fp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["fp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"fp", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"fp", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"fp", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"fp", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", 
           RowBox[{"z", " ", 
            RowBox[{"a", "[", "z", "]"}]}]}], ")"}], " ", 
         RowBox[{"fp", "[", "z", "]"}]}], "-", 
        RowBox[{"\[CapitalOmega]", " ", 
         RowBox[{"hp", "[", "z", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["hp", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["hp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.538911139892004*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"8", " ", "\[CapitalOmega]", " ", 
     RowBox[{
      SuperscriptBox["sp", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}], "+", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["z", "2"]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"sp", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"12", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{"f", "[", "z", "]"}], "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{"h", "[", "z", "]"}], "2"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", "z", "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["z", "4"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "[", "z", "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["a", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], "2"]}],
           "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "6"}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"f", "[", "z", "]"}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{
                   SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], 
               "2"]}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"h", "[", "z", "]"}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{
                   SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], 
               "2"]}]}], ")"}]}], "+", 
          FractionBox[
           RowBox[{"16", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{"s", "[", "z", "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["s", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", "z", "]"}]}]}]], "-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["z", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                RowBox[{"s", "[", "z", "]"}]}], "+", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["s", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], 
             "2"]}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"]], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "3"], " ", 
           RowBox[{
            SuperscriptBox["t", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}], "-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["z", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{"s", "[", "z", "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["s", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{"t", "[", "z", "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["t", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", "z", "]"}]}]}]]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{"f", "[", "z", "]"}], " ", 
           RowBox[{"fp", "[", "z", "]"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"h", "[", "z", "]"}], " ", 
           RowBox[{"hp", "[", "z", "]"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"tp", "[", "z", "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "[", "z", "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["a", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ap", "[", "z", "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["ap", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"tp", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "6"}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"f", "[", "z", "]"}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{
                   SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], 
               "2"]}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"h", "[", "z", "]"}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{
                   SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], 
               "2"]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"f", "[", "z", "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
              
              RowBox[{"(", 
               RowBox[{
                RowBox[{"fp", "[", "z", "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["fp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
             "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"h", "[", "z", "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["h", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
              
              RowBox[{"(", 
               RowBox[{
                RowBox[{"hp", "[", "z", "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["hp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
            ")"}]}], "+", 
          FractionBox[
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"sp", "[", "z", "]"}]}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{
                   SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"z", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "z", " ", 
                  RowBox[{"s", "[", "z", "]"}], " ", 
                  RowBox[{"tp", "[", "z", "]"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"tp", "[", "z", "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                  RowBox[{
                   SuperscriptBox["sp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
             ")"}]}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"]], "-", 
          RowBox[{
           FractionBox["1", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "3"]], 
           RowBox[{"2", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{"s", "[", "z", "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["s", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               RowBox[{"sp", "[", "z", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 RowBox[{"z", " ", "\[CapitalOmega]"}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", "\[CapitalOmega]", " ", 
                  RowBox[{"s", "[", "z", "]"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{
                   SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", "z", "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "z", " ", 
                  RowBox[{"s", "[", "z", "]"}], " ", 
                  RowBox[{"tp", "[", "z", "]"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"tp", "[", "z", "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                  RowBox[{
                   SuperscriptBox["sp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
             ")"}]}]}], "+", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["tp", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}], "-", 
          RowBox[{
           FractionBox["1", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"]], 
           RowBox[{"2", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"sp", "[", "z", "]"}]}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{
                   SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  RowBox[{"t", "[", "z", "]"}]}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{
                   SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
              "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  RowBox[{"s", "[", "z", "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"tp", "[", "z", "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["tp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
                 "+", 
                 RowBox[{"z", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"tp", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["sp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["sp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["tp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.538911139954241*^9}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", 
         RowBox[{
          SuperscriptBox["z", "3"], " ", 
          RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "3"]], 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"sp", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox[
          RowBox[{"h", "[", "z", "]"}], "2"]}], "-", 
        RowBox[{"12", " ", 
         RowBox[{"s", "[", "z", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"a", "[", "z", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"t", "[", "z", "]"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"f", "[", "z", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"t", "[", "z", "]"}]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"f", "[", "z", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "+", 
           RowBox[{"m", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["h", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "3"], " ", 
         RowBox[{"a", "[", "z", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}], "+", 
           RowBox[{
            RowBox[{"h", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "-", 
           RowBox[{
            RowBox[{"f", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "z", " ", 
            SuperscriptBox[
             RowBox[{"h", "[", "z", "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"t", "[", "z", "]"}], "+", 
              RowBox[{
               RowBox[{"s", "[", "z", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", "z", "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"h", "[", "z", "]"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "m"}], " ", "z", " ", 
               RowBox[{
                SuperscriptBox["f", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["h", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "-", 
           
           RowBox[{"12", " ", 
            RowBox[{
             SuperscriptBox["s", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["t", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "-", 
           RowBox[{"z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["z", "2"]}], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["a", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"s", "[", "z", "]"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["z", "6"]}], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"t", "[", "z", "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["z", "2"], "+", 
                    RowBox[{
                    SuperscriptBox["z", "6"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "6"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                   ")"}]}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                 RowBox[{"6", " ", "z", " ", 
                  RowBox[{"t", "[", "z", "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                 RowBox[{
                  SuperscriptBox["z", "4"], " ", 
                  RowBox[{"t", "[", "z", "]"}], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["s", "\[Prime]\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", "z", "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["s", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"2", " ", 
               RowBox[{"s", "[", "z", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"z", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["z", "3"]}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
                 "+", 
                 RowBox[{
                  RowBox[{"t", "[", "z", "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"4", "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], "-", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", 
         RowBox[{
          SuperscriptBox["z", "3"], " ", 
          RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"]], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{"hp", "[", "z", "]"}]}], "-", 
        RowBox[{"6", " ", 
         RowBox[{"sp", "[", "z", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"a", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ap", "[", "z", "]"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"ap", "[", "z", "]"}], " ", 
            RowBox[{"s", "[", "z", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"a", "[", "z", "]"}], " ", 
            RowBox[{"sp", "[", "z", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"tp", "[", "z", "]"}], "-", 
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"fp", "[", "z", "]"}], "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"fp", "[", "z", "]"}], " ", 
               RowBox[{"s", "[", "z", "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"f", "[", "z", "]"}], " ", 
               RowBox[{"sp", "[", "z", "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", "z", "]"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"f", "[", "z", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
            RowBox[{"tp", "[", "z", "]"}]}]}], ")"}]}], "-", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"fp", "[", "z", "]"}], "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"fp", "[", "z", "]"}], " ", 
               RowBox[{"s", "[", "z", "]"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"f", "[", "z", "]"}], " ", 
               RowBox[{"sp", "[", "z", "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["f", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "+", 
              RowBox[{"m", " ", "z", " ", 
               RowBox[{
                SuperscriptBox["h", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
           
           RowBox[{
            RowBox[{"f", "[", "z", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "\[CapitalOmega]"}], " ", 
               RowBox[{"fp", "[", "z", "]"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"tp", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["f", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["fp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["fp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "+", 
              RowBox[{"m", " ", "z", " ", 
               RowBox[{
                SuperscriptBox["hp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "3"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"ap", "[", "z", "]"}], "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"ap", "[", "z", "]"}], " ", 
               RowBox[{"s", "[", "z", "]"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"a", "[", "z", "]"}], " ", 
               RowBox[{"sp", "[", "z", "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "+", 
              RowBox[{
               RowBox[{"h", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["f", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "-", 
              RowBox[{
               RowBox[{"f", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["h", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
           
           RowBox[{
            RowBox[{"a", "[", "z", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["ap", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "+", 
              RowBox[{
               RowBox[{"hp", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["f", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "+", 
              RowBox[{
               RowBox[{"h", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["fp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "-", 
              RowBox[{
               RowBox[{"fp", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["h", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "-", 
              RowBox[{
               RowBox[{"f", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["hp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "\[CapitalOmega]", " ", 
            RowBox[{"sp", "[", "z", "]"}]}], "-", 
           RowBox[{"z", " ", 
            RowBox[{"h", "[", "z", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{"hp", "[", "z", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"t", "[", "z", "]"}], "+", 
                 RowBox[{
                  RowBox[{"s", "[", "z", "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"h", "[", "z", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  RowBox[{"sp", "[", "z", "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
                  RowBox[{"tp", "[", "z", "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
           
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"hp", "[", "z", "]"}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"hp", "[", "z", "]"}], " ", 
                  RowBox[{"s", "[", "z", "]"}]}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"h", "[", "z", "]"}], " ", 
                  RowBox[{"sp", "[", "z", "]"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "m"}], " ", "z", " ", 
                  RowBox[{
                   SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                  RowBox[{
                   SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
              "+", 
              RowBox[{
               RowBox[{"h", "[", "z", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "\[CapitalOmega]"}], " ", 
                  RowBox[{"hp", "[", "z", "]"}]}], "-", 
                 RowBox[{"m", " ", "z", " ", 
                  RowBox[{
                   SuperscriptBox["fp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"tp", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                    RowBox[{
                    SuperscriptBox["hp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}], "-", 
           RowBox[{"6", " ", 
            RowBox[{
             SuperscriptBox["sp", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "-", 
           RowBox[{
            SuperscriptBox["tp", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}], "+", 
           RowBox[{"z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{
                SuperscriptBox["a", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["ap", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "+", 
              RowBox[{"\[CapitalOmega]", " ", 
               RowBox[{"fp", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["f", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"tp", "[", "z", "]"}], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["f", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["fp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["f", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["fp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "+", 
              RowBox[{"\[CapitalOmega]", " ", 
               RowBox[{"hp", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["h", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"tp", "[", "z", "]"}], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["h", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["h", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["hp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["h", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["hp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "-", 
              RowBox[{"6", " ", "z", " ", 
               RowBox[{"tp", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["s", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["z", "4"], " ", 
               RowBox[{"tp", "[", "z", "]"}], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["s", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
              RowBox[{"6", " ", "z", " ", 
               RowBox[{"t", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["sp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{
                SuperscriptBox["s", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["sp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "4"], " ", 
               RowBox[{"t", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["s", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["sp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               SuperscriptBox[
                RowBox[{"s", "[", "z", "]"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"tp", "[", "z", "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                   ")"}]}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["z", "3"]}], " ", 
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["ap", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                    RowBox[{"z", " ", "\[CapitalOmega]", " ", 
                    RowBox[{"fp", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["fp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["fp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                    RowBox[{"z", " ", "\[CapitalOmega]", " ", 
                    RowBox[{"hp", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["hp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["hp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["tp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
                ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"tp", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["s", "\[Prime]\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "-", 
              RowBox[{
               RowBox[{"sp", "[", "z", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"z", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["z", "3"]}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", "\[CapitalOmega]", " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
                 "+", 
                 RowBox[{
                  RowBox[{"t", "[", "z", "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"4", "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["sp", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["sp", "\[Prime]\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "-", 
              RowBox[{
               RowBox[{"s", "[", "z", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"sp", "[", "z", "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["z", "6"]}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["z", "2"], "+", 
                    RowBox[{
                    SuperscriptBox["z", "6"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "6"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                    ")"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{"z", " ", "\[CapitalOmega]"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                   ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"tp", "[", "z", "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"4", "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
                 "+", 
                 RowBox[{"z", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["ap", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                    RowBox[{"2", " ", "z", " ", "\[CapitalOmega]", " ", 
                    RowBox[{"fp", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"4", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["fp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["fp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                    RowBox[{"2", " ", "z", " ", "\[CapitalOmega]", " ", 
                    RowBox[{"hp", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"4", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["hp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["hp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["sp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["sp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["tp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["sp", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["sp", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], "+", 
    RowBox[{
     SuperscriptBox["tp", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.538911140023017*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["z", "2"]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"f", "[", "z", "]"}], " ", 
        RowBox[{"fp", "[", "z", "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"f", "[", "z", "]"}], " ", 
        RowBox[{"fp", "[", "z", "]"}], " ", 
        RowBox[{"s", "[", "z", "]"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"sp", "[", "z", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "2"], " ", 
        RowBox[{"sp", "[", "z", "]"}]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"fp", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["f", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{"f", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"sp", "[", "z", "]"}], " ", 
              RowBox[{
               SuperscriptBox["f", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["fp", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
         ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"sp", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"h", "[", "z", "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["h", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], "2"]}], 
         ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{
            SuperscriptBox["f", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}], " ", 
           RowBox[{
            SuperscriptBox["fp", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"h", "[", "z", "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["h", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"hp", "[", "z", "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["hp", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
         ")"}]}], "+", 
       RowBox[{"8", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["sp", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{
      SuperscriptBox["sp", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.538911140097986*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"z", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"sp", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SuperscriptBox["ap", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["ap", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["ap", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"hp", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"hp", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"hp", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["fp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["fp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["fp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"fp", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"fp", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"fp", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["hp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["hp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["hp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"sp", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{
       SuperscriptBox["ap", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["ap", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"ap", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"s", "[", "z", "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["sp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["sp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"a", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"sp", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"2", "-", 
           RowBox[{
            SuperscriptBox["z", "3"], " ", 
            RowBox[{
             SuperscriptBox["s", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["sp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{
       SuperscriptBox["ap", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["ap", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "5"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["ap", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.538911140218856*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"8", " ", 
     SuperscriptBox["\[CapitalOmega]", "2"], " ", 
     RowBox[{"sp", "[", "z", "]"}]}], "+", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["z", "2"], "+", 
         RowBox[{
          SuperscriptBox["z", "4"], " ", 
          RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["z", "4"]}], " ", 
        RowBox[{"sp", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", 
           SuperscriptBox[
            RowBox[{"h", "[", "z", "]"}], "2"]}], "+", 
          RowBox[{"32", " ", 
           RowBox[{"s", "[", "z", "]"}]}], "-", 
          RowBox[{"4", " ", 
           RowBox[{"t", "[", "z", "]"}]}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{"a", "[", "z", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["z", "2"], " ", 
              SuperscriptBox[
               RowBox[{"f", "[", "z", "]"}], "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["z", "2"], " ", 
              SuperscriptBox[
               RowBox[{"h", "[", "z", "]"}], "2"]}], "-", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", "z", "]"}]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"f", "[", "z", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["m", "2"], " ", 
              SuperscriptBox["z", "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", "z", "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["z", "4"], " ", 
              SuperscriptBox[
               RowBox[{"t", "[", "z", "]"}], "2"]}]}], ")"}]}], "+", 
          RowBox[{"4", " ", "z", " ", 
           RowBox[{"f", "[", "z", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["f", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], "+", 
             RowBox[{"m", " ", "z", " ", 
              RowBox[{
               SuperscriptBox["h", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["z", "3"], " ", 
           RowBox[{"a", "[", "z", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "m", " ", 
              SuperscriptBox[
               RowBox[{"f", "[", "z", "]"}], "2"]}], "+", 
             RowBox[{"4", " ", "m", " ", 
              SuperscriptBox[
               RowBox[{"h", "[", "z", "]"}], "2"]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["a", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{"h", "[", "z", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["f", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"f", "[", "z", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["h", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "z", " ", 
              SuperscriptBox[
               RowBox[{"h", "[", "z", "]"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"6", " ", 
                 RowBox[{"s", "[", "z", "]"}]}], "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"s", "[", "z", "]"}], "2"]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"m", "+", 
                    RowBox[{"m", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
                 RowBox[{"t", "[", "z", "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"t", "[", "z", "]"}], "2"]}]}], ")"}]}], "+", 
             RowBox[{"4", " ", 
              RowBox[{"h", "[", "z", "]"}], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "m"}], " ", "z", " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                 RowBox[{
                  SuperscriptBox["h", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
             "+", 
             RowBox[{"16", " ", 
              RowBox[{
               SuperscriptBox["s", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], "+", 
             RowBox[{"4", " ", 
              RowBox[{
               SuperscriptBox["t", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["z", "2"]}], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  RowBox[{"t", "[", "z", "]"}], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                   RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], 
                    "2"]}]}], ")"}]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["s", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["t", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"z", " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                   RowBox[{"4", " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                   RowBox[{"4", " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                   RowBox[{"24", " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                   RowBox[{"8", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                   RowBox[{"4", " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
                "+", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"s", "[", "z", "]"}], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["z", "6"]}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                    ")"}]}], "+", 
                   RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"8", "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                  ")"}]}], "+", 
                RowBox[{
                 RowBox[{"s", "[", "z", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"t", "[", "z", "]"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
                   "+", 
                   RowBox[{
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"40", "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "6"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["z", "6"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
                   "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"], "-", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
       
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "2"], "+", 
          RowBox[{
           SuperscriptBox["z", "4"], " ", 
           RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"12", " ", 
           RowBox[{"h", "[", "z", "]"}], " ", 
           RowBox[{"hp", "[", "z", "]"}]}], "+", 
          RowBox[{"32", " ", 
           RowBox[{"sp", "[", "z", "]"}]}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"a", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"ap", "[", "z", "]"}], "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"ap", "[", "z", "]"}], " ", 
                 RowBox[{"s", "[", "z", "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"a", "[", "z", "]"}], " ", 
                 RowBox[{"sp", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"f", "[", "z", "]"}], "2"]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"h", "[", "z", "]"}], "2"]}], "-", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", "z", "]"}]}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"a", "[", "z", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"8", " ", 
                 RowBox[{"f", "[", "z", "]"}], " ", 
                 RowBox[{"fp", "[", "z", "]"}]}], "+", 
                RowBox[{"8", " ", 
                 RowBox[{"h", "[", "z", "]"}], " ", 
                 RowBox[{"hp", "[", "z", "]"}]}], "-", 
                RowBox[{"tp", "[", "z", "]"}]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"4", " ", 
           RowBox[{"tp", "[", "z", "]"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"f", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"fp", "[", "z", "]"}], "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"fp", "[", "z", "]"}], " ", 
                 RowBox[{"s", "[", "z", "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"f", "[", "z", "]"}], " ", 
                 RowBox[{"sp", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["m", "2"], " ", 
                 SuperscriptBox["z", "2"]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", "z", "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "4"], " ", 
                 SuperscriptBox[
                  RowBox[{"t", "[", "z", "]"}], "2"]}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"f", "[", "z", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{"tp", "[", "z", "]"}]}]}], ")"}]}], "+", 
          RowBox[{"4", " ", "z", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"fp", "[", "z", "]"}], "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"fp", "[", "z", "]"}], " ", 
                 RowBox[{"s", "[", "z", "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"f", "[", "z", "]"}], " ", 
                 RowBox[{"sp", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"m", " ", "z", " ", 
                 RowBox[{
                  SuperscriptBox["h", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
             "+", 
             RowBox[{
              RowBox[{"f", "[", "z", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", "m", " ", "z", " ", 
                 "\[CapitalOmega]", " ", 
                 RowBox[{"hp", "[", "z", "]"}]}], "-", 
                RowBox[{
                 RowBox[{"fp", "[", "z", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"\[CapitalOmega]", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["z", "4"], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["fp", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["fp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "4"], " ", 
                 SuperscriptBox[
                  RowBox[{"t", "[", "z", "]"}], "2"], " ", 
                 RowBox[{
                  SuperscriptBox["fp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"m", " ", 
                 SuperscriptBox["z", "3"], " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"m", " ", "z", " ", 
                 RowBox[{
                  SuperscriptBox["hp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"m", " ", 
                 SuperscriptBox["z", "3"], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["hp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
            ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["z", "3"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"ap", "[", "z", "]"}], "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"ap", "[", "z", "]"}], " ", 
                 RowBox[{"s", "[", "z", "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"a", "[", "z", "]"}], " ", 
                 RowBox[{"sp", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "m", " ", 
                 SuperscriptBox[
                  RowBox[{"f", "[", "z", "]"}], "2"]}], "+", 
                RowBox[{"4", " ", "m", " ", 
                 SuperscriptBox[
                  RowBox[{"h", "[", "z", "]"}], "2"]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                 RowBox[{
                  SuperscriptBox["a", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"2", " ", 
                 RowBox[{"h", "[", "z", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"f", "[", "z", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                 RowBox[{
                  SuperscriptBox["h", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
             "+", 
             RowBox[{
              RowBox[{"a", "[", "z", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"8", " ", "m", " ", 
                 RowBox[{"h", "[", "z", "]"}], " ", 
                 RowBox[{"hp", "[", "z", "]"}]}], "-", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["a", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{
                 SuperscriptBox["ap", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], "-", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["ap", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"2", " ", 
                 RowBox[{"hp", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"hp", "[", "z", "]"}], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"h", "[", "z", "]"}], " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"2", " ", 
                 RowBox[{"h", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["fp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"h", "[", "z", "]"}], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["fp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"fp", "[", "z", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "\[CapitalOmega]", " ", 
                    RowBox[{"h", "[", "z", "]"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"2", " ", 
                 RowBox[{"f", "[", "z", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", " ", "m", " ", 
                    RowBox[{"fp", "[", "z", "]"}]}], "-", 
                   RowBox[{"2", " ", "\[CapitalOmega]", " ", 
                    RowBox[{"hp", "[", "z", "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"tp", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["hp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["hp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "16"}], " ", "\[CapitalOmega]", " ", 
              RowBox[{"sp", "[", "z", "]"}]}], "+", 
             RowBox[{"4", " ", "\[CapitalOmega]", " ", 
              RowBox[{"tp", "[", "z", "]"}]}], "+", 
             RowBox[{"4", " ", "z", " ", 
              RowBox[{"h", "[", "z", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"hp", "[", "z", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"6", " ", 
                    RowBox[{"s", "[", "z", "]"}]}], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"s", "[", "z", "]"}], "2"]}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"m", "+", 
                    RowBox[{"m", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"]}], "+", 
                   RowBox[{"4", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"s", "[", "z", "]"}]}]}], ")"}], "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"t", "[", "z", "]"}], "2"]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"h", "[", "z", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"sp", "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["m", "2"], " ", 
                    SuperscriptBox["z", "2"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{"t", "[", "z", "]"}], "2"]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                    RowBox[{"tp", "[", "z", "]"}]}]}], ")"}]}]}], ")"}]}], 
             "+", 
             RowBox[{"4", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"hp", "[", "z", "]"}], "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"hp", "[", "z", "]"}], " ", 
                    RowBox[{"s", "[", "z", "]"}]}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"h", "[", "z", "]"}], " ", 
                    RowBox[{"sp", "[", "z", "]"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "m"}], " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
                "+", 
                RowBox[{
                 RowBox[{"h", "[", "z", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"s", "[", "z", "]"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                   "2", " ", "m", " ", "z", " ", "\[CapitalOmega]", " ", 
                    RowBox[{"fp", "[", "z", "]"}]}], "-", 
                   RowBox[{
                    RowBox[{"hp", "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"\[CapitalOmega]", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}]}], "-", 
                   RowBox[{"m", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"tp", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                   RowBox[{"m", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["fp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                   RowBox[{"m", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["fp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"tp", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["z", "4"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{"tp", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["hp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["hp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{"t", "[", "z", "]"}], "2"], " ", 
                    RowBox[{
                    SuperscriptBox["hp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
               ")"}]}], "+", 
             RowBox[{"16", " ", 
              RowBox[{
               SuperscriptBox["sp", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], "+", 
             RowBox[{"4", " ", 
              RowBox[{
               SuperscriptBox["tp", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "8"}], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{"tp", "[", "z", "]"}]}], "-", 
                RowBox[{
                 SuperscriptBox["z", "4"], " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["a", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["ap", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox["z", "4"], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["a", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["ap", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"4", " ", "\[CapitalOmega]", " ", 
                 RowBox[{"fp", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
                 RowBox[{"fp", "[", "z", "]"}], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "4"], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                RowBox[{"4", " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["fp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"8", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["fp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "4"], " ", 
                 SuperscriptBox[
                  RowBox[{"t", "[", "z", "]"}], "2"], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["fp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"4", " ", "\[CapitalOmega]", " ", 
                 RowBox[{"hp", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
                 RowBox[{"hp", "[", "z", "]"}], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "4"], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                RowBox[{"4", " ", 
                 RowBox[{
                  SuperscriptBox["h", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["hp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"8", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["hp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "4"], " ", 
                 SuperscriptBox[
                  RowBox[{"t", "[", "z", "]"}], "2"], " ", 
                 RowBox[{
                  SuperscriptBox["h", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["hp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"24", " ", "z", " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["s", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["s", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"16", " ", 
                 SuperscriptBox["z", "3"], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["s", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"8", " ", 
                 SuperscriptBox["z", "4"], " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                RowBox[{"8", " ", 
                 SuperscriptBox["z", "6"], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                RowBox[{"24", " ", "z", " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["sp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"8", " ", 
                 SuperscriptBox["z", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"t", "[", "z", "]"}], "2"], " ", 
                 RowBox[{
                  SuperscriptBox["sp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"8", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["s", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["sp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"16", " ", 
                 SuperscriptBox["z", "4"], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["s", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["sp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"8", " ", 
                 SuperscriptBox["z", "6"], " ", 
                 SuperscriptBox[
                  RowBox[{"t", "[", "z", "]"}], "2"], " ", 
                 RowBox[{
                  SuperscriptBox["s", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["sp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"4", " ", "z", " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["t", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "4"], " ", 
                 RowBox[{"tp", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["s", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["t", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["sp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["t", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "4"], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["sp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["t", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{
                 RowBox[{"sp", "[", "z", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"t", "[", "z", "]"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
                   "+", 
                   RowBox[{
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"40", "-", 
                    RowBox[{"8", " ", "z", " ", "\[CapitalOmega]"}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "6"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["z", "4"], " ", "\[CapitalOmega]", " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["z", "6"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
                   "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["z", "2"]}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]", " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"\[CapitalOmega]", " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"s", "[", "z", "]"}], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"tp", "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["z", "6"]}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                    ")"}]}], "+", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "-", 
                    RowBox[{"z", " ", "\[CapitalOmega]"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                    ")"}]}], "+", 
                   RowBox[{"2", " ", "z", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["z", "3"]}], " ", 
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["ap", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "z"}], " ", "\[CapitalOmega]", " ", 
                    RowBox[{"fp", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["fp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                    RowBox[{"z", " ", "\[CapitalOmega]", " ", 
                    RowBox[{"hp", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["hp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["hp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                    RowBox[{
                    SuperscriptBox["tp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                RowBox[{"4", " ", "z", " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["tp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["s", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["tp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["z", "4"], " ", 
                 RowBox[{"t", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["s", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["tp", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"s", "[", "z", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"tp", "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"20", "-", 
                    RowBox[{
                    SuperscriptBox["z", "6"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "4"], " ", "\[CapitalOmega]", " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
                    "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "6"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
                   "+", 
                   RowBox[{
                    RowBox[{"sp", "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["z", "6"]}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{"t", "[", "z", "]"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                    ")"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"8", "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", "\[CapitalOmega]", " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
                    "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["z", "6"]}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"z", " ", "\[CapitalOmega]"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}]}]}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["ap", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]", " ", 
                    RowBox[{"fp", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["fp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["fp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]", " ", 
                    RowBox[{"hp", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["hp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["hp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{"t", "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["sp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["sp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["t", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["s", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["tp", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.538911140284951*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sollin", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Lin1", "\[Equal]", "0"}], ",", 
        RowBox[{"Lin4", "\[Equal]", "0"}], ",", 
        RowBox[{"Lin5", "\[Equal]", "0"}], ",", 
        RowBox[{"LinC1", "\[Equal]", "0"}], ",", 
        RowBox[{"LinC2", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"fp", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"ap", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"sp", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"tp", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"hp", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.538911161594118*^9, 3.538911221252846*^9}, {
  3.538911418456649*^9, 3.538911421696932*^9}}],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{{3.5389112051181393`*^9, 3.5389112246866093`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{968, 986},
WindowMargins->{{12, Automatic}, {Automatic, 24}},
FrontEndVersion->"7.0 for Mac OS X x86 (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "calcgeom"->{
  Cell[38038, 1051, 308, 10, 73, "Input",
   CellTags->"calcgeom"],
  Cell[38349, 1063, 293, 10, 73, "Input",
   CellTags->"calcgeom"],
  Cell[38645, 1075, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[38912, 1086, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[39179, 1097, 3569, 101, 139, "Input",
   CellTags->"calcgeom"],
  Cell[42751, 1200, 157, 5, 27, "Input",
   CellTags->"calcgeom"],
  Cell[43115, 1213, 5599, 153, 178, "Input",
   CellTags->"calcgeom"],
  Cell[48717, 1368, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[48862, 1374, 1615, 48, 88, "Input",
   CellTags->"calcgeom"],
  Cell[50480, 1424, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[50625, 1430, 633, 22, 27, "Input",
   CellTags->"calcgeom"],
  Cell[51261, 1454, 1648, 51, 113, "Input",
   CellTags->"calcgeom"],
  Cell[52912, 1507, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[53057, 1513, 145, 4, 27, "Input",
   CellTags->"calcgeom"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"calcgeom", 672000, 18339}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 822, 11, 46, "Subtitle"],
Cell[CellGroupData[{
Cell[1414, 37, 68, 1, 27, "Input"],
Cell[1485, 40, 148, 2, 20, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1670, 47, 111, 1, 26, "Subsubtitle"],
Cell[1784, 50, 95, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[1904, 56, 279, 8, 58, "Input"],
Cell[2186, 66, 257, 6, 70, "Output"],
Cell[2446, 74, 657, 17, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3140, 96, 266, 9, 58, "Input"],
Cell[3409, 107, 145, 2, 70, "Output"],
Cell[3557, 111, 145, 2, 70, "Output"]
}, Open  ]],
Cell[3717, 116, 407, 13, 27, "Input"],
Cell[4127, 131, 37, 0, 27, "Input"],
Cell[CellGroupData[{
Cell[4189, 135, 257, 8, 58, "Input"],
Cell[4449, 145, 233, 5, 70, "Output"],
Cell[4685, 152, 141, 2, 70, "Output"]
}, Open  ]],
Cell[4841, 157, 2028, 63, 103, "Input"],
Cell[6872, 222, 26, 0, 27, "Input"],
Cell[6901, 224, 841, 25, 43, "Input"],
Cell[7745, 251, 1026, 31, 58, "Input"],
Cell[8774, 284, 227, 8, 86, "Text"],
Cell[9004, 294, 4015, 95, 238, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[13056, 394, 111, 3, 26, "Subsubtitle"],
Cell[13170, 399, 128, 4, 26, "Text"],
Cell[13301, 405, 6139, 139, 718, "Input"],
Cell[19443, 546, 68, 1, 26, "Text"],
Cell[19514, 549, 3727, 84, 523, "Input"],
Cell[23244, 635, 824, 18, 208, "Input"],
Cell[24071, 655, 4051, 89, 583, "Input"],
Cell[28125, 746, 99, 2, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[28261, 753, 34, 0, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[28320, 757, 3220, 66, 175, "Input"],
Cell[31543, 825, 1293, 41, 50, "Output"],
Cell[32839, 868, 206, 4, 27, "Output"],
Cell[33048, 874, 138, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33223, 881, 28, 0, 27, "Input"],
Cell[33254, 883, 1292, 41, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34583, 929, 28, 0, 27, "Input"],
Cell[34614, 931, 2573, 83, 98, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37224, 1019, 119, 3, 27, "Input"],
Cell[37346, 1024, 608, 19, 52, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38003, 1049, 32, 0, 26, "Subsubtitle"],
Cell[38038, 1051, 308, 10, 73, "Input",
 CellTags->"calcgeom"],
Cell[38349, 1063, 293, 10, 73, "Input",
 CellTags->"calcgeom"],
Cell[38645, 1075, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[38912, 1086, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[39179, 1097, 3569, 101, 139, "Input",
 CellTags->"calcgeom"],
Cell[42751, 1200, 157, 5, 27, "Input",
 CellTags->"calcgeom"],
Cell[42911, 1207, 201, 4, 27, "Input"],
Cell[43115, 1213, 5599, 153, 178, "Input",
 CellTags->"calcgeom"],
Cell[48717, 1368, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[48862, 1374, 1615, 48, 88, "Input",
 CellTags->"calcgeom"],
Cell[50480, 1424, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[50625, 1430, 633, 22, 27, "Input",
 CellTags->"calcgeom"],
Cell[51261, 1454, 1648, 51, 113, "Input",
 CellTags->"calcgeom"],
Cell[52912, 1507, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[53057, 1513, 145, 4, 27, "Input",
 CellTags->"calcgeom"]
}, Closed]],
Cell[CellGroupData[{
Cell[53239, 1522, 41, 0, 26, "Subsubtitle"],
Cell[53283, 1524, 173, 4, 27, "Input"],
Cell[53459, 1530, 645, 21, 27, "Input"],
Cell[54107, 1553, 1146, 34, 118, "Input"],
Cell[55256, 1589, 1792, 51, 118, "Input"],
Cell[57051, 1642, 710, 23, 58, "Input"],
Cell[57764, 1667, 3424, 95, 238, "Input"],
Cell[61191, 1764, 388, 12, 27, "Input"],
Cell[61582, 1778, 434, 10, 27, "Input"],
Cell[62019, 1790, 508, 12, 46, "Input"],
Cell[62530, 1804, 4135, 133, 141, "Input"],
Cell[66668, 1939, 6843, 214, 199, "Input"],
Cell[73514, 2155, 237, 5, 27, "Input"],
Cell[CellGroupData[{
Cell[73776, 2164, 3999, 129, 141, "Input"],
Cell[77778, 2295, 194, 4, 27, "Output"],
Cell[77975, 2301, 194, 4, 27, "Output"],
Cell[78172, 2307, 194, 4, 27, "Output"],
Cell[78369, 2313, 194, 4, 27, "Output"]
}, Open  ]],
Cell[78578, 2320, 1262, 33, 148, "Input"],
Cell[79843, 2355, 1027, 21, 58, "Input"],
Cell[80873, 2378, 677, 17, 58, "Input"],
Cell[81553, 2397, 1027, 30, 118, "Input"],
Cell[82583, 2429, 161, 3, 27, "Input"],
Cell[82747, 2434, 745, 18, 88, "Input"],
Cell[CellGroupData[{
Cell[83517, 2456, 1146, 32, 238, "Input"],
Cell[84666, 2490, 6681, 192, 110, "Output"],
Cell[91350, 2684, 6184, 188, 130, "Output"],
Cell[97537, 2874, 2246, 74, 77, "Output"],
Cell[99786, 2950, 3726, 118, 87, "Output"],
Cell[103515, 3070, 5225, 166, 132, "Output"],
Cell[108743, 3238, 11966, 360, 217, "Output"],
Cell[120712, 3600, 1478, 50, 78, "Output"],
Cell[122193, 3652, 7097, 218, 151, "Output"]
}, Open  ]],
Cell[129305, 3873, 2631, 55, 169, "Input"],
Cell[CellGroupData[{
Cell[131961, 3932, 975, 25, 238, "Input"],
Cell[132939, 3959, 139, 2, 27, "Output"],
Cell[133081, 3963, 139, 2, 27, "Output"],
Cell[133223, 3967, 139, 2, 27, "Output"],
Cell[133365, 3971, 139, 2, 27, "Output"],
Cell[133507, 3975, 139, 2, 27, "Output"],
Cell[133649, 3979, 138, 2, 27, "Output"],
Cell[133790, 3983, 139, 2, 27, "Output"],
Cell[133932, 3987, 139, 2, 27, "Output"]
}, Open  ]],
Cell[134086, 3992, 292, 6, 27, "Input"],
Cell[134381, 4000, 3095, 69, 148, "Input"],
Cell[CellGroupData[{
Cell[137501, 4073, 2122, 60, 87, "Input"],
Cell[139626, 4135, 63788, 1801, 928, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[203451, 5941, 1438, 41, 33, "Input"],
Cell[204892, 5984, 56219, 1473, 679, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[261148, 7462, 1074, 32, 88, "Input"],
Cell[262225, 7496, 141, 2, 27, "Output"],
Cell[262369, 7500, 140, 2, 27, "Output"],
Cell[262512, 7504, 140, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[262689, 7511, 1910, 67, 105, "Input"],
Cell[264602, 7580, 2756, 91, 70, "Output"],
Cell[267361, 7673, 2935, 95, 72, "Output"],
Cell[270299, 7770, 48256, 1283, 512, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[318592, 9058, 3045, 110, 177, "Input"],
Cell[321640, 9170, 11859, 350, 172, "Output"],
Cell[333502, 9522, 12029, 384, 188, "Output"],
Cell[345534, 9908, 5025, 149, 120, "Output"],
Cell[350562, 10059, 7384, 229, 196, "Output"],
Cell[357949, 10290, 25218, 692, 316, "Output"]
}, Open  ]],
Cell[383182, 10985, 190, 5, 27, "Input"],
Cell[383375, 10992, 1044, 31, 148, "Input"],
Cell[CellGroupData[{
Cell[384444, 11027, 1224, 33, 238, "Input"],
Cell[385671, 11062, 6077, 166, 112, "Output"],
Cell[391751, 11230, 6105, 170, 112, "Output"],
Cell[397859, 11402, 1456, 44, 51, "Output"],
Cell[399318, 11448, 4588, 140, 150, "Output"],
Cell[403909, 11590, 13096, 337, 180, "Output"],
Cell[417008, 11929, 1904, 58, 52, "Output"],
Cell[418915, 11989, 1987, 58, 54, "Output"],
Cell[420905, 12049, 18362, 494, 245, "Output"]
}, Open  ]],
Cell[439282, 12546, 1146, 29, 27, "Input"],
Cell[CellGroupData[{
Cell[440453, 12579, 340, 9, 27, "Input"],
Cell[440796, 12590, 245, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[441078, 12599, 311, 8, 27, "Input"],
Cell[441392, 12609, 194, 4, 27, "Output"]
}, Open  ]],
Cell[441601, 12616, 190, 5, 27, "Input"],
Cell[441794, 12623, 2034, 58, 148, "Input"],
Cell[443831, 12683, 2645, 76, 238, "Input"],
Cell[CellGroupData[{
Cell[446501, 12763, 2426, 72, 238, "Input"],
Cell[448930, 12837, 195, 3, 27, "Output"],
Cell[449128, 12842, 195, 3, 27, "Output"],
Cell[449326, 12847, 197, 3, 27, "Output"],
Cell[449526, 12852, 197, 3, 27, "Output"],
Cell[449726, 12857, 195, 3, 27, "Output"],
Cell[449924, 12862, 197, 3, 27, "Output"],
Cell[450124, 12867, 195, 3, 27, "Output"],
Cell[450322, 12872, 195, 3, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[450554, 12880, 1813, 50, 238, "Input"],
Cell[452370, 12932, 27147, 717, 392, "Output"],
Cell[479520, 13651, 27149, 717, 392, "Output"],
Cell[506672, 14370, 7612, 205, 166, "Output"],
Cell[514287, 14577, 17834, 461, 444, "Output"],
Cell[532124, 15040, 46512, 1101, 590, "Output"],
Cell[578639, 16143, 4409, 123, 101, "Output"],
Cell[583051, 16268, 7773, 218, 152, "Output"],
Cell[590827, 16488, 79710, 1801, 942, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[670574, 18294, 988, 27, 43, "Input"],
Cell[671565, 18323, 105, 1, 27, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
