(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    739528,      18736]
NotebookOptionsPosition[    724667,      18318]
NotebookOutlinePosition[    726016,      18366]
CellTagsIndexPosition[    725942,      18361]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Dynamic AdS/CMT - Superconductor - Spectral - Broken phase

q = 2 case of H^3\
\>", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
   3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
   3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
   3.495174647742872*^9, 3.460515504326817*^9}, {3.503996600043788*^9, 
   3.503996603042028*^9}, {3.507011572545054*^9, 3.460340667971311*^9}, {
   3.5374843541262083`*^9, 3.537484358716886*^9}, 3.537484391202265*^9, {
   3.537484629914453*^9, 3.537484630281348*^9}, {3.5374893532274837`*^9, 
   3.537489358050692*^9}, {3.5376274940424433`*^9, 3.537627498480837*^9}, {
   3.543863578659968*^9, 3.543863585914144*^9}}],

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "^", "2"}]], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"-", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "0", "0"},
       {
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}], "0"},
       {"0", "0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.507011580676421*^9, 3.507011659804162*^9}, {3.507013755598536*^9, 
   3.460392698323369*^9}, {3.4604018613321533`*^9, 3.4604018646719627`*^9}, {
   3.460401965632374*^9, 3.460401968163259*^9}, {3.4604023388162813`*^9, 
   3.4604023558966084`*^9}, {3.460402422665003*^9, 3.460402426690833*^9}, {
   3.460402628586185*^9, 3.4604026419139843`*^9}, {3.460402674350209*^9, 
   3.4604026844332027`*^9}, {3.460512773931822*^9, 3.460512787444798*^9}, {
   3.4605146484667263`*^9, 3.460514650350994*^9}, {3.460514717258254*^9, 
   3.460514724283691*^9}, 3.460514770989304*^9, 3.4605223140457373`*^9, {
   3.4605327188171663`*^9, 3.460532727004561*^9}, {3.460532863547011*^9, 
   3.460532865145266*^9}, {3.460532977769042*^9, 3.4605329860852757`*^9}, {
   3.507275497143169*^9, 3.4603659980232763`*^9}, {3.537484515197036*^9, 
   3.537484572210073*^9}, 3.537484644682625*^9, {3.5374846959240923`*^9, 
   3.537484701892157*^9}, {3.537484976337736*^9, 3.5374849917355137`*^9}, {
   3.537486594817341*^9, 3.537486596777007*^9}}],

Cell[BoxData["Gd"], "Input"],

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[BoxData[
 RowBox[{
  RowBox[{"R2", "=", 
   RowBox[{"Simplify", "[", "R2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041067188341103`*^9, 3.404106720182616*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"GT", "[", 
       RowBox[{"R2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "A", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"A", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"A", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"v", ",", "d"}], "}"}], "}"}], ",", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"ST", "[", 
    RowBox[{"A", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"z", ",", "d"}], "}"}], "}"}], ",", 
     RowBox[{"az", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451383976248069*^9, 3.4513840125908737`*^9}, {
  3.451384057147691*^9, 3.451384064689735*^9}, {3.451385762395092*^9, 
  3.451385762480318*^9}, {3.451385800913571*^9, 3.451385805770357*^9}, {
  3.537484677141605*^9, 3.53748468964509*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "F", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"F", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"F", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}]}], "}"}], ",", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i2", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i1", "]"}], "]"}]}], "]"}]}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4041040239360247`*^9, 3.404104073416904*^9}, {
  3.4041057167733383`*^9, 3.4041057183570337`*^9}, {3.4513840707957897`*^9, 
  3.451384164343499*^9}, {3.460366100458836*^9, 3.460366108909464*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"trFF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"trT", "[", 
      RowBox[{
       RowBox[{"outerT", "[", 
        RowBox[{"F", ",", "F"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fsqr", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"trT", "[", 
     RowBox[{"trFF", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.404103126230957*^9, 3.404103206051724*^9}, 
   3.404103788928409*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "Dp", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"Dp", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Note", " ", "that", " ", "now", " ", "q"}], " ", "=", " ", 
    RowBox[{"2", "!!"}]}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Dp", "=", 
       RowBox[{"ST", "[", 
        RowBox[{"Dp", ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], "}"}], ",", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"\[Phi]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
          RowBox[{"2", "I", " ", 
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], 
           RowBox[{"\[Phi]", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConjDp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "d", "}"}], ",", 
      RowBox[{"Conjugate", "[", 
       RowBox[{"Dp", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DpDp", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{"trT", "[", 
       RowBox[{
        RowBox[{"outerT", "[", 
         RowBox[{"ConjDp", ",", "Dp"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Vterm", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"\[Phi]", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "]"}], 
       RowBox[{"\[Phi]", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513844331121693`*^9, 3.451384521665413*^9}, {
   3.451384560554626*^9, 3.451384642158163*^9}, {3.4513849100950413`*^9, 
   3.451384915054587*^9}, 3.451385051803838*^9, {3.4513851171366262`*^9, 
   3.45138511927711*^9}, {3.451385175930884*^9, 3.451385183167452*^9}, {
   3.451385425505906*^9, 3.45138544324051*^9}, {3.451385490350021*^9, 
   3.451385493946774*^9}, {3.451385568392873*^9, 3.451385601054823*^9}, {
   3.451385813165941*^9, 3.4513858527683163`*^9}, {3.45138608116168*^9, 
   3.451386103913107*^9}, {3.46036707784975*^9, 3.460255762501432*^9}, {
   3.46025580130457*^9, 3.460255801461816*^9}, {3.53748492894665*^9, 
   3.53748495518618*^9}, {3.537485329580826*^9, 3.537485331297533*^9}, {
   3.5438636009106503`*^9, 3.543863617484816*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DpDp", "=", 
   RowBox[{"(", 
    RowBox[{"DpDp", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Re", "[", "xx_", "]"}], "\[Rule]", "xx"}], ",", 
       RowBox[{
        RowBox[{"Im", "[", "xx_", "]"}], "\[Rule]", "0"}]}], "}"}]}], ")"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.451385894732107*^9, 3.451385976334114*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sqrtdetg", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Det", "[", 
       RowBox[{"-", "Gd"}], "]"}], "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041041692972*^9, 3.404104211096949*^9}, 
   3.404105293940057*^9, {3.4513842180130997`*^9, 3.4513842223260803`*^9}, {
   3.4513846617079067`*^9, 3.451384675916638*^9}}],

Cell[BoxData[
 RowBox[{"L", "=", 
  RowBox[{"sqrtdetg", 
   RowBox[{"(", 
    RowBox[{"Ricci", "+", "6", "-", 
     RowBox[{
      FractionBox["1", "4"], "Fsqr"}], "-", "DpDp", "-", "Vterm"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.451384367735067*^9, 3.451384393946628*^9}, {
   3.4513849054437723`*^9, 3.4513849068431387`*^9}, {3.451385606138598*^9, 
   3.451385607193993*^9}, 3.460366276193363*^9, {3.4603670917067547`*^9, 
   3.460255829896731*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp1", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp3", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.53748653613297*^9, 3.5374865918283*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GHBT", "+=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
     "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460366441552243*^9, 3.460366544772176*^9}, {
  3.4603665879440317`*^9, 3.460366626391823*^9}, {3.537486655723679*^9, 
  3.537486732610427*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L2", "=", 
   RowBox[{"L", "-", "GHBT"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460366546941235*^9, 3.460366557341961*^9}, 
   3.460366686117609*^9, {3.4603672960654507`*^9, 3.4603672977104673`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"L2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.460366666517003*^9, 3.460366674775579*^9}, {3.537486746662644*^9, 
  3.5374867639666147`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EOM", "[", "fld_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{"D", "[", 
      RowBox[{"L2", ",", "fld"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"tmp2", "=", 
           RowBox[{"D", "[", 
            RowBox[{"fld", ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ")"}], "=!=", "0"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tmp", "-=", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"L2", ",", "tmp2"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "tmp"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.4513849546200113`*^9, 3.451385039242148*^9}, {
  3.4603662728020573`*^9, 3.460366273871294*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqp", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"p", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"\[Alpha]", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513848144544163`*^9, 3.4513848150159073`*^9}, {
  3.451384869337384*^9, 3.451384875673843*^9}, {3.451384929950244*^9, 
  3.451384930100154*^9}, {3.451385060851385*^9, 3.451385213396349*^9}, {
  3.451385293160893*^9, 3.451385302528058*^9}, {3.4513853749547167`*^9, 
  3.45138537639461*^9}, {3.451385514552088*^9, 3.451385527943191*^9}, {
  3.451385862306609*^9, 3.451385882826736*^9}, {3.451386138230373*^9, 
  3.451386140019012*^9}, {3.451386241895258*^9, 3.4513862693654633`*^9}, {
  3.4603675858592987`*^9, 3.4603675914720583`*^9}, {3.537486779881022*^9, 
  3.537486784922683*^9}, {3.537486894453556*^9, 3.5374869009568243`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqav", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"av", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"az", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513855403702793`*^9, 3.451385540823719*^9}, {
  3.4513861532442207`*^9, 3.45138616739637*^9}, {3.451386251199284*^9, 
  3.4513862656960487`*^9}, {3.460367593073217*^9, 3.460367597640524*^9}, {
  3.5374867866028214`*^9, 3.537486788378339*^9}, {3.537486891597521*^9, 
  3.537486937732339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqgvz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gvz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqgzz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gzz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqT", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"T", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqS", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451386275930722*^9, 3.451386303859261*^9}, {
  3.460366711720347*^9, 3.4603667226381903`*^9}, {3.460367599130735*^9, 
  3.460367611985876*^9}, {3.53748678993122*^9, 3.53748680663302*^9}, {
  3.537486911477583*^9, 3.5374869187572203`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"gvz", ",", "gzz", ",", "az"}], "]"}]], "Input",
 CellChangeTimes->{{3.53748694036823*^9, 3.537486945275868*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"gvz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gzz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"az", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}]}], "Input",
 CellChangeTimes->{{3.460366755240944*^9, 3.460366765921853*^9}, {
   3.460379717667384*^9, 3.460379720321673*^9}, {3.4603938524268913`*^9, 
   3.4603938546559877`*^9}, 3.4603939628549967`*^9, {3.5374868640225983`*^9, 
   3.537486876197587*^9}, {3.537486924492758*^9, 3.537486925572747*^9}, {
   3.537487030062772*^9, 3.537487030117689*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqp2", "=", 
   RowBox[{"Simplify", "[", "eqp", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]2", "=", 
   RowBox[{"Simplify", "[", "eq\[Alpha]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqav2", "=", 
   RowBox[{"Simplify", "[", "eqav", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz2", "=", 
   RowBox[{"Simplify", "[", "eqaz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgvz2", "=", 
   RowBox[{"Simplify", "[", "eqgvz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgzz2", "=", 
   RowBox[{"Simplify", "[", "eqgzz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqT2", "=", 
   RowBox[{"Simplify", "[", "eqT", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"eqS2", "=", 
  RowBox[{"Simplify", "[", "eqS", "]"}]}]}], "Input",
 CellChangeTimes->{{3.460366768598325*^9, 3.4603668525536737`*^9}, {
  3.5374869590367947`*^9, 3.537486972220312*^9}}],

Cell[BoxData[
 RowBox[{"Evsol", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqgvz2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqS2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqp2", "\[Equal]", "0"}], ",", 
        RowBox[{"eq\[Alpha]2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqaz", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["p", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["\[Alpha]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["av", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4603794747692738`*^9, 3.4603795051117373`*^9}, {
   3.460379770556391*^9, 3.460379778090231*^9}, {3.537487575145343*^9, 
   3.537487601737835*^9}, {3.5374876320607243`*^9, 3.537487632172414*^9}, 
   3.5374876986147537`*^9}],

Cell[BoxData[
 RowBox[{"Momsol", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqT2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqgzz", "\[Equal]", "0"}], ",", 
        RowBox[{"eqav", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["av", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.460379791348405*^9, 3.460379854266864*^9}, {
  3.537487577120059*^9, 3.537487629667873*^9}, {3.5374877038531513`*^9, 
  3.537487709515881*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqT2", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqav", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"eqgzz", ",", "z"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"Evsol", ",", "v"}], "]"}]}], "/.", "Evsol"}], "/.", "Momsol"}],
   "]"}]}], "Input",
 CellChangeTimes->{{3.460379877349128*^9, 3.460379983100644*^9}, {
  3.460380087445326*^9, 3.460380091873478*^9}, {3.537487726936469*^9, 
  3.5374877500015907`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"a", "[", 
    RowBox[{"v", ",", "z"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"h", "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.460380576942815*^9, 3.46038057950566*^9}, {
  3.4603806147948647`*^9, 3.460380638346624*^9}, {3.5374877590000763`*^9, 
  3.537487759103163*^9}, {3.537487795719556*^9, 3.537487805166259*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Const1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Const2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Const3", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["S", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["S", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.46031768644937*^9, 3.46031772334064*^9}, {
  3.537487772329159*^9, 3.5374878178010073`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Eq1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["p", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["p", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq3", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq4", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq5", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["T", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["T", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.537489066732723*^9, 3.5374891410817547`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"p", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"h", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"a", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"T", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"S", "[", "z", "]"}]}]}], "Input",
 CellChangeTimes->{{3.537627682228917*^9, 3.537627713970744*^9}, {
  3.537636882057424*^9, 3.537636897297038*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ell1", "=", 
   RowBox[{"Simplify", "[", "Eq1", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell2", "=", 
   RowBox[{"Simplify", "[", "Eq2", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ellc1", "=", 
   RowBox[{"Simplify", "[", "Eq3", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ellc2", "=", 
   RowBox[{"Simplify", "[", "Eq4", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell3", "=", 
   RowBox[{"Simplify", "[", "Eq5", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell4", "=", 
   RowBox[{"Simplify", "[", "Const1", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell5", "=", 
   RowBox[{"Simplify", "[", "Const2", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"ellc3", "=", 
  RowBox[{"Simplify", "[", "Const3", "]"}]}]}], "Input",
 CellChangeTimes->{{3.537627679175139*^9, 3.537627742317072*^9}, {
  3.537636876281947*^9, 3.53763687844884*^9}, {3.5376379765369062`*^9, 
  3.537638074206946*^9}, {3.537638144466118*^9, 3.537638162905325*^9}}],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ell1", ",", "ell2", ",", "ell3", ",", "ell4", ",", "ell5"}], 
        "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"h", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"a", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"T", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"S", "''"}], "[", "z", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.537638077410537*^9, {3.5376381314247913`*^9, 3.537638256008617*^9}, {
   3.537638739449127*^9, 3.537638740135255*^9}, {3.537638891437305*^9, 
   3.5376388944848833`*^9}}],

Cell[BoxData[
 RowBox[{"Expand", "[", "ellc1", "]"}]], "Input",
 CellChangeTimes->{{3.537638754409368*^9, 3.537638756597229*^9}}],

Cell[BoxData[
 RowBox[{"Expand", "[", "ellc2", "]"}]], "Input",
 CellChangeTimes->{{3.537638758349153*^9, 3.537638760740986*^9}}],

Cell[BoxData[
 RowBox[{"Expand", "[", "ellc3", "]"}]], "Input",
 CellChangeTimes->{{3.537638761869357*^9, 3.537638765020914*^9}}],

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ellc1", ",", "ellc2"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"p", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537638619736205*^9, 3.53763872186449*^9}, {
  3.53763882686869*^9, 3.537638830835917*^9}, {3.537638862507595*^9, 
  3.5376388755551147`*^9}}],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"ellc3", "/.", "sol2"}], "]"}]], "Input",
 CellChangeTimes->{{3.537638838836076*^9, 3.5376388709387693`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"ellc1", ",", "z"}], "]"}], "+", 
      RowBox[{"2", 
       FractionBox[
        RowBox[{
         RowBox[{"S", "'"}], "[", "z", "]"}], 
        RowBox[{"S", "[", "z", "]"}]], " ", "ellc1"}]}], ")"}], "/.", "sol"}],
    "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"S", "[", "z", "]"}], "^", "2"}], "ellc1"}], ",", "z"}], "]"}],
    "/.", "sol"}], "]"}]}], "Input",
 CellChangeTimes->{{3.537640004014365*^9, 3.5376400814389057`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"ellc2", ",", "z"}], "]"}], "-", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"S", "'"}], "[", "z", "]"}], 
        RowBox[{"S", "[", "z", "]"}]], " ", "ellc2"}], "+", 
      RowBox[{
       FractionBox["2", "z"], " ", "ellc2"}]}], ")"}], "/.", "sol"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"z", "^", "2"}], 
       RowBox[{"S", "[", "z", "]"}]], "ellc2"}], ",", "z"}], "]"}], "/.", 
   "sol"}], "]"}]}], "Input",
 CellChangeTimes->{{3.537640004014365*^9, 3.5376401691466208`*^9}, {
  3.537640206992764*^9, 3.537640234528932*^9}}],

Cell[BoxData[
 RowBox[{"Print", "[", 
  "\"\<\\n\\nSo, if c1 and c2 are zero, and they obey simple decoupled eqns, \
then c3 also zero!\\n\\n\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.5376403237255774`*^9, 3.537640353177024*^9}, {
  3.538462192473542*^9, 3.538462193016658*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Asymptotic expansion", "Subsubtitle",
 CellChangeTimes->{{3.538463067865754*^9, 3.5384630721521673`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "p2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "p3"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", "p4"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", "p5"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "6"}], " ", "p6"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "7"}], " ", "p7"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "8"}], " ", "p8"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "9"}], " ", "p9"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "10"}], " ", "p10"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "11"}], " ", "p11"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "12"}], " ", "p12"}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "h2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "h3"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", "h4"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", "h5"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "6"}], " ", "h6"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "7"}], " ", "h7"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "8"}], " ", "h8"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "9"}], " ", "h9"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "10"}], " ", "h10"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "11"}], " ", "h11"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "12"}], " ", "h12"}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "z_", "]"}], ":=", 
    RowBox[{"a0", "+", 
     RowBox[{"z", " ", "a1"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", "a2"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", "a3"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", "a4"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", "a5"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "6"}], " ", "a6"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "7"}], " ", "a7"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "8"}], " ", "a8"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "9"}], " ", "a9"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "10"}], " ", "a10"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "11"}], " ", "a11"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "12"}], " ", "a12"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "z_", "]"}], ":=", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], "T2"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", "T3"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", "T4"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", "T5"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "6"}], " ", "T6"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "7"}], " ", "T7"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "8"}], " ", "T8"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "9"}], " ", "T9"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "10"}], " ", "T10"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "11"}], " ", "T11"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "12"}], " ", "T12"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], "S2"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "3"}], " ", "S3"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "4"}], " ", "S4"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "5"}], " ", "S5"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "6"}], " ", "S6"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "7"}], " ", "S7"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "8"}], " ", "S8"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "9"}], " ", "S9"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "10"}], " ", "S10"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "11"}], " ", "S11"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "12"}], " ", "S12"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
   3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
   3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
   3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
   3.537490237348768*^9}, {3.537490394647192*^9, 3.537490453890482*^9}, {
   3.537490792048935*^9, 3.537490804720195*^9}, {3.537490860205984*^9, 
   3.537490863100896*^9}, {3.5374908962097483`*^9, 3.537490902905895*^9}, {
   3.537491099280459*^9, 3.5374911037619123`*^9}, {3.5374911421214113`*^9, 
   3.537491208593452*^9}, {3.537577393872981*^9, 3.537577398304707*^9}, {
   3.537639022648444*^9, 3.537639113606564*^9}, {3.5381377672688637`*^9, 
   3.5381378365486183`*^9}, 3.538137882235326*^9, {3.538462674627036*^9, 
   3.538462715657539*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "repl", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp1", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ellc1", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp2", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ellc2", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp3", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ellc3", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp4", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell1", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp5", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell2", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp6", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell3", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp7", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell4", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp8", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell5", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}]}], "Input",
 CellChangeTimes->{{3.5376392293063307`*^9, 3.5376392299215183`*^9}, {
  3.538137895519271*^9, 3.538137930215798*^9}, {3.538462288648322*^9, 
  3.538462297761071*^9}, {3.538462392692498*^9, 3.538462394764674*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538462300919333*^9, 3.538462302093458*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol2", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"T2", ",", "S2", ",", "a2"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", "sol2"}], ";"}]}], "Input",
 CellChangeTimes->{{3.538137931998144*^9, 3.5381379817888117`*^9}, {
  3.538462209912683*^9, 3.53846221643303*^9}, {3.538462371290099*^9, 
  3.538462373609942*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "2"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p3", ",", "h3", ",", "a3", ",", "S3"}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol3"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538137931998144*^9, 3.5381379817888117`*^9}, {
  3.538462209912683*^9, 3.53846221643303*^9}, {3.5384623133361*^9, 
  3.5384623208626213`*^9}, {3.538462364372213*^9, 3.538462367474139*^9}, {
  3.53846240258596*^9, 3.538462463009907*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "3"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p4", ",", "h4", ",", "a4", ",", "S4", ",", "T4"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol4"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538137931998144*^9, 3.5381379817888117`*^9}, {
  3.538462209912683*^9, 3.53846221643303*^9}, {3.5384623133361*^9, 
  3.5384623208626213`*^9}, {3.538462364372213*^9, 3.538462367474139*^9}, {
  3.53846240258596*^9, 3.538462491570972*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p5", ",", "h5", ",", "a5", ",", "S5", ",", "T5"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol5"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538137931998144*^9, 3.5381379817888117`*^9}, {
  3.538462209912683*^9, 3.53846221643303*^9}, {3.5384623133361*^9, 
  3.5384623208626213`*^9}, {3.538462364372213*^9, 3.538462367474139*^9}, {
  3.53846240258596*^9, 3.5384625169946136`*^9}, {3.538462592429839*^9, 
  3.538462602884987*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "5"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p6", ",", "h6", ",", "a6", ",", "S6", ",", "T6"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol6"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538462610229724*^9, 3.5384626262991323`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "6"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p7", ",", "h7", ",", "a7", ",", "S7", ",", "T7"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol7"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538462610229724*^9, 3.53846264220479*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "7"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol8", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p8", ",", "h8", ",", "a8", ",", "S8", ",", "T8"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol8"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538462610229724*^9, 3.53846264220479*^9}, {
  3.5384627311973467`*^9, 3.53846274069244*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "8"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol9", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p9", ",", "h9", ",", "a9", ",", "S9", ",", "T9"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol9"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538462747749477*^9, 3.5384627639226007`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "9"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol10", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p10", ",", "h10", ",", "a10", ",", "S10", ",", "T10"}], 
        "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol10"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538462772165017*^9, 3.53846278770794*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "10"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol11", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p11", ",", "h11", ",", "a11", ",", "S11", ",", "T11"}], 
        "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol11"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538462774004135*^9, 3.538462809307893*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "11"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol12", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p12", ",", "h12", ",", "a12", ",", "S12", ",", "T12"}], 
        "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol12"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538462776243325*^9, 3.538462824259987*^9}}],

Cell[BoxData[
 RowBox[{"repl", "=", 
  RowBox[{"FullSimplify", "[", "repl", "]"}]}]], "Input",
 CellChangeTimes->{{3.538462876166841*^9, 3.5384628864493513`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{{3.538462838910104*^9, 3.538462866002865*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{3.538462864194768*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{3.53846286309058*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", "z", "]"}], "//.", "repl"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"S", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{3.5384628615876102`*^9}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "]"}]], "Input",
 CellChangeTimes->{{3.537640737015723*^9, 3.5376407595390577`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Horizon expansion", "Subsubtitle",
 CellChangeTimes->{{3.538463067865754*^9, 3.5384630721521673`*^9}, {
  3.5384631960168037`*^9, 3.538463196751625*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"T", ",", "S", ",", "a", ",", "p", ",", "h"}], "]"}]], "Input",
 CellChangeTimes->{{3.5384635355243692`*^9, 3.5384635391803713`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "repl", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp1", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ellc1", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", "pos"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp2", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ellc2", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", "pos"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp3", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ellc3", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", "pos"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp4", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell1", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", "pos"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp5", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell2", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", "pos"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp6", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell3", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp7", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell4", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp8", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell5", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}]}], "Input",
 CellChangeTimes->{{3.5376392293063307`*^9, 3.5376392299215183`*^9}, {
  3.538137895519271*^9, 3.538137930215798*^9}, {3.538462288648322*^9, 
  3.538462297761071*^9}, {3.538462392692498*^9, 3.538462394764674*^9}, {
  3.538463498120213*^9, 3.538463502943193*^9}, {3.538463596257093*^9, 
  3.538463601832757*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"t1", 
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}]}], "+", 
    RowBox[{"t2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"t3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"t4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "4"}]}], "+", 
    RowBox[{"t5", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "5"}]}], "+", 
    RowBox[{"t6", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "6"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", "z_", "]"}], ":=", 
   RowBox[{"s0", "+", 
    RowBox[{"s1", 
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}]}], "+", 
    RowBox[{"s2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"s3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"s4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "4"}]}], "+", 
    RowBox[{"s5", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "5"}]}], "+", 
    RowBox[{"s6", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "6"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{"a0", "+", 
    RowBox[{"a1", 
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}]}], "+", 
    RowBox[{"a2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"a3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"a4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "4"}]}], "+", 
    RowBox[{"a5", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "5"}]}], "+", 
    RowBox[{"a6", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "6"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", 
   RowBox[{"p0", "+", 
    RowBox[{"p1", 
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}]}], "+", 
    RowBox[{"p2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"p3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"p4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "4"}]}], "+", 
    RowBox[{"p5", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "5"}]}], "+", 
    RowBox[{"p6", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "6"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "[", "z_", "]"}], ":=", 
  RowBox[{"h0", "+", 
   RowBox[{"h1", 
    RowBox[{"(", 
     RowBox[{"z0", "-", "z"}], ")"}]}], "+", 
   RowBox[{"h2", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}], "^", "2"}]}], "+", 
   RowBox[{"h3", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}], "^", "3"}]}], "+", 
   RowBox[{"h4", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}], "^", "4"}]}], "+", 
   RowBox[{"h5", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}], "^", "5"}]}], "+", 
   RowBox[{"h6", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}], "^", "6"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.537692460831832*^9, 3.537692571971863*^9}, {
   3.537692934161448*^9, 3.537692935150085*^9}, {3.5384635465997868`*^9, 
   3.5384635932491283`*^9}, 3.538463667298936*^9, {3.538463699260297*^9, 
   3.5384636995001097`*^9}, {3.538463822292626*^9, 3.538463863510054*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538462300919333*^9, 3.538462302093458*^9}, {
  3.538463560317108*^9, 3.538463563740576*^9}, {3.5384636102038717`*^9, 
  3.538463611852014*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"a0", ",", "p1", ",", "h1", ",", "s1"}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol1"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538137931998144*^9, 3.5381379817888117`*^9}, {
  3.538462209912683*^9, 3.53846221643303*^9}, {3.538462371290099*^9, 
  3.538462373609942*^9}, {3.5384635209823008`*^9, 3.538463551212698*^9}, {
  3.538463617916279*^9, 3.5384637274578114`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"a2", ",", "p2", ",", "h2", ",", "s2", ",", "t2"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol2"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538463738305477*^9, 3.5384637769691477`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "2"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"a3", ",", "p3", ",", "h3", ",", "s3", ",", "t3"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol3"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538463738305477*^9, 3.538463797800817*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "3"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"a4", ",", "p4", ",", "h4", ",", "s4", ",", "t4"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol4"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538463738305477*^9, 3.538463797800817*^9}, {
  3.5384639094954557`*^9, 3.538463917350461*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"a5", ",", "p5", ",", "h5", ",", "s5", ",", "t5"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol5"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538463738305477*^9, 3.538463797800817*^9}, {
  3.5384639094954557`*^9, 3.5384639327501297`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "5"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"a6", ",", "p6", ",", "h6", ",", "s6", ",", "t6"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol6"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538463738305477*^9, 3.538463797800817*^9}, {
  3.5384639094954557`*^9, 3.538463956934313*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{{3.538463967809574*^9, 3.5384639792942257`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{3.538463981029242*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{3.538463982933107*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", "z", "]"}], "//.", "repl"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"S", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{3.538463984821121*^9}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "]"}]], "Input",
 CellChangeTimes->{{3.5384640959611263`*^9, 3.538464099700382*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Radial evolution equations", "Subsubtitle",
 CellChangeTimes->{{3.538463067865754*^9, 3.5384630910323133`*^9}}],

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ellc1", "\[Equal]", "0"}], ",", 
       RowBox[{"ellc2", "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"T", "'"}], "[", "z", "]"}], ",", 
       RowBox[{
        RowBox[{"h", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.538046181988859*^9, 3.538046275572392*^9}, {
  3.538118511452941*^9, 3.5381185296755857`*^9}}],

Cell[BoxData[
 RowBox[{"Expand", "[", "tmp", "]"}]], "Input",
 CellChangeTimes->{{3.538138653550453*^9, 3.538138655138913*^9}}],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"ellc3", "/.", "tmp"}], "]"}]], "Input",
 CellChangeTimes->{{3.538046278386948*^9, 3.538046283644046*^9}}],

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ell1", "\[Equal]", "0"}], ",", 
       RowBox[{"ell4", "\[Equal]", "0"}], ",", 
       RowBox[{"ell5", "\[Equal]", "0"}], ",", 
       RowBox[{"ellc1", "\[Equal]", "0"}], ",", 
       RowBox[{"ellc2", "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"p", "''"}], "[", "z", "]"}], ",", 
       RowBox[{
        RowBox[{"a", "''"}], "[", "z", "]"}], ",", 
       RowBox[{
        RowBox[{"S", "''"}], "[", "z", "]"}], ",", 
       RowBox[{
        RowBox[{"T", "'"}], "[", "z", "]"}], ",", 
       RowBox[{
        RowBox[{"h", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.538046946386949*^9, 3.538046971865954*^9}, {
  3.538047767565443*^9, 3.538047777835328*^9}, {3.538118570663123*^9, 
  3.538118592110586*^9}}],

Cell[BoxData[
 RowBox[{"eqlist", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"p", "''"}], "[", "z", "]"}], ",", 
      RowBox[{
       RowBox[{"a", "''"}], "[", "z", "]"}], ",", 
      RowBox[{
       RowBox[{"S", "''"}], "[", "z", "]"}], ",", 
      RowBox[{
       RowBox[{"T", "'"}], "[", "z", "]"}], ",", 
      RowBox[{
       RowBox[{"h", "'"}], "[", "z", "]"}]}], "}"}], "==", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"a", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"S", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"T", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"h", "'"}], "[", "z", "]"}]}], "}"}], "/.", 
      RowBox[{"tmp", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.538046982617304*^9, 3.538047031616665*^9}, {
  3.538047095238578*^9, 3.538047109277329*^9}, {3.538047742727194*^9, 
  3.538047743310781*^9}, {3.538047780875566*^9, 3.53804778166721*^9}, {
  3.5381186282311773`*^9, 3.5381186428306227`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Summary - Must Run.", "Subsubtitle",
 CellChangeTimes->{{3.538463037602364*^9, 3.538463043377323*^9}, {
  3.538464312857139*^9, 3.538464319392853*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"replasym", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p2", "\[Rule]", "asymp2"}], ",", 
      RowBox[{"h2", "\[Rule]", "asymh2"}], ",", 
      RowBox[{"a0", "\[Rule]", "asyma0"}], ",", 
      RowBox[{"a1", "\[Rule]", "asyma1"}], ",", 
      RowBox[{"T3", "\[Rule]", "asymT3"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"replhoriz", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t1", "\[Rule]", "horizt1"}], ",", 
     RowBox[{"a1", "\[Rule]", "horiza1"}], ",", 
     RowBox[{"p0", "\[Rule]", "horizp0"}], ",", 
     RowBox[{"h0", "\[Rule]", "horizh0"}], ",", 
     RowBox[{"s0", "\[Rule]", "horizs0"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.537873163678542*^9, 3.537873275606132*^9}, {
  3.538464304756454*^9, 3.53846431129167*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"horizp", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"p0", "-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"p0", "+", 
          RowBox[{"a1", " ", "h0", " ", 
           SuperscriptBox["z0", "2"]}]}], ")"}]}], 
       RowBox[{"t1", " ", 
        SuperscriptBox["z0", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["p0", "3"]}], "-", 
          RowBox[{"12", " ", "a1", " ", "h0", " ", 
           SuperscriptBox["p0", "2"], " ", 
           SuperscriptBox["z0", "2"]}], "+", 
          RowBox[{"p0", " ", 
           RowBox[{"(", 
            RowBox[{"16", "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["h0", "2"]}], "-", 
             RowBox[{"8", " ", "t1", " ", "z0"}], "-", 
             RowBox[{"11", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
          RowBox[{"a1", " ", "h0", " ", 
           SuperscriptBox["z0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"28", "-", 
             RowBox[{"12", " ", 
              SuperscriptBox["h0", "2"]}], "-", 
             RowBox[{"8", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["t1", "2"], " ", 
        SuperscriptBox["z0", "4"]}]], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"72", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "6"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"48", " ", 
          SuperscriptBox["p0", "5"]}], "+", 
         RowBox[{"96", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "4"], " ", 
          SuperscriptBox["z0", "2"]}], "-", 
         RowBox[{"24", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"36", "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"18", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"3", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"11", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"p0", " ", 
          RowBox[{"(", 
           RowBox[{"592", "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "4"]}], "-", 
            RowBox[{"576", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"972", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"396", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "-", 
            RowBox[{"51", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               RowBox[{"3", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"12", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "108"}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["h0", "4"]}], "+", 
            RowBox[{"84", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"72", "-", 
               RowBox[{"36", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"14", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"576", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"288", " ", 
          SuperscriptBox["p0", "7"]}], "-", 
         RowBox[{"96", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "6"], " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["p0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"85", "+", 
            RowBox[{"18", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"24", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"104", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"48", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "4"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"60", "-", 
            RowBox[{"6", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"48", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"85", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"6", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"2640", "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "4"]}], "+", 
            RowBox[{"864", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"940", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"57", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "60"}], "+", 
               RowBox[{"48", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"85", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"36", "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"2352", "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["h0", "4"]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"3880", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"703", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"192", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "11792"}], "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "6"]}], "+", 
            RowBox[{"576", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"1968", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"273", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"24", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "60"}], "+", 
               RowBox[{"48", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"85", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"576", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "27"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"216", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2640", "+", 
               RowBox[{"864", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"940", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"57", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"96", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"p0", " ", 
          RowBox[{"(", 
           RowBox[{"10240", "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["h0", "6"]}], "-", 
            RowBox[{"1152", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"24624", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"2847", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"27", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"432", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"24", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "592"}], "+", 
               RowBox[{"972", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "+", 
               RowBox[{"288", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"3880", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"703", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"192", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"9", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"7200", " ", 
         SuperscriptBox["t1", "5"], " ", 
         SuperscriptBox["z0", "10"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2880", " ", 
          SuperscriptBox["p0", "9"]}], "-", 
         RowBox[{"192", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "8"], " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["p0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"1158", "+", 
            RowBox[{"240", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"300", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"769", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"12", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "4"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5940", "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["h0", "4"]}], "+", 
            RowBox[{"4800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"29596", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"3345", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"60", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1000", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"12", "+", 
               RowBox[{"17", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"80860", "+", 
            RowBox[{"4320", " ", 
             SuperscriptBox["h0", "4"]}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"98520", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"50325", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"36", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1158"}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"600", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"48", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "6"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["h0", "2"]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"8", "-", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"3", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"83712", "+", 
            RowBox[{"256", " ", 
             SuperscriptBox["h0", "6"]}], "-", 
            RowBox[{"28800", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"79320", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"8952", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"165", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"240", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"4800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"36", "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"100", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2640", "+", 
               RowBox[{"940", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"57", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"5940", "+", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"29596", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3345", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"1000", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"618016", "+", 
            RowBox[{"11520", " ", 
             SuperscriptBox["h0", "6"]}], "-", 
            RowBox[{"28800", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"918720", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"467922", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"17925", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"144", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1158"}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"28800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"300", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2352", "+", 
               RowBox[{"3880", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"703", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"40", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"16172", "+", 
               RowBox[{"1440", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"19704", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"10065", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"p0", " ", 
          RowBox[{"(", 
           RowBox[{"294400", "+", 
            RowBox[{"2880", " ", 
             SuperscriptBox["h0", "8"]}], "-", 
            RowBox[{"787376", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"14400", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"176115", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"177", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1158"}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"600", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "592"}], "+", 
               RowBox[{"972", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"50", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "10240"}], "+", 
               RowBox[{"24624", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2847", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"20", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"16172", "+", 
               RowBox[{"1440", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"19704", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"10065", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"618016", "-", 
               RowBox[{"28800", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"918720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"467922", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"17925", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"28800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"9", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "+", 
                  RowBox[{"3880", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"703", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"192", " ", 
             SuperscriptBox["h0", "8"]}], "-", 
            RowBox[{"240", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"5940", "+", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"29596", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3345", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"1000", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "127904"}], "+", 
               RowBox[{"34864", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"2880", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13509", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"201", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"5760", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "27"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"1440", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"28", "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"20", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "11792"}], "+", 
                  RowBox[{"1968", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"273", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"28800", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2640", "+", 
                  RowBox[{"940", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"57", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"3", " ", 
                RowBox[{"(", 
                 RowBox[{"27904", "+", 
                  RowBox[{"26440", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"2984", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"55", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"518400", " ", 
         SuperscriptBox["t1", "6"], " ", 
         SuperscriptBox["z0", "12"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"172800", " ", 
          SuperscriptBox["p0", "11"]}], "-", 
         RowBox[{"4608", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "10"], " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"1152", " ", 
          SuperscriptBox["p0", "9"], " ", 
          RowBox[{"(", 
           RowBox[{"3655", "+", 
            RowBox[{"750", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"900", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"741", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"1152", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "8"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "124"}], "-", 
            RowBox[{"20", " ", 
             SuperscriptBox["h0", "2"]}], "+", 
            RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"5375", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"288", " ", 
          SuperscriptBox["p0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"121042", "+", 
            RowBox[{"6000", " ", 
             SuperscriptBox["h0", "4"]}], "+", 
            RowBox[{"9000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"57561", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"109660", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"60", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1158", "+", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"288", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "6"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1982"}], "+", 
            RowBox[{"160", " ", 
             SuperscriptBox["h0", "4"]}], "+", 
            RowBox[{"3000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"182508", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"42045", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"300", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"24", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "4"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"482264", "-", 
            RowBox[{"1920", " ", 
             SuperscriptBox["h0", "6"]}], "-", 
            RowBox[{"288000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"4989942", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"549546", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"42795", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"90000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"12", "+", 
               RowBox[{"17", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"180", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"5940", "+", 
               RowBox[{"29596", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3345", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"36", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1982"}], "+", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"182508", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"42045", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"351", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"72", " ", 
          SuperscriptBox["p0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"1609360", "+", 
            RowBox[{"24000", " ", 
             SuperscriptBox["h0", "6"]}], "-", 
            RowBox[{"48000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"1453810", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"2057109", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"170735", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"6000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"100", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16172"}], "+", 
               RowBox[{"19704", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"10065", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"121042", "+", 
               RowBox[{"9000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"57561", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"109660", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"1158", "+", 
                  RowBox[{"769", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"48395008", "+", 
            RowBox[{"288000", " ", 
             SuperscriptBox["h0", "8"]}], "+", 
            RowBox[{"47872928", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"864000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"62340036", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"4514562", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"71055", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1536", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"18000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "+", 
               RowBox[{"3880", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"703", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"120", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"618016", "+", 
               RowBox[{"918720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"467922", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"17925", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"121042", "+", 
               RowBox[{"9000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"57561", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"109660", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"1158", "+", 
                  RowBox[{"769", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1609360"}], "+", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"1453810", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2057109", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"170735", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"6000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16172"}], "+", 
                  RowBox[{"19704", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"10065", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"12", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1920", " ", 
             SuperscriptBox["h0", "8"]}], "-", 
            RowBox[{"384", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"72", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1982"}], "+", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"182508", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"42045", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"351", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "482264"}], "+", 
               RowBox[{"288000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"4989942", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"549546", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"42795", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"90000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"5940", "+", 
                  RowBox[{"29596", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3345", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "521600"}], "+", 
               RowBox[{"2056640", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"216000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"966577", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"52500", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "-", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"1500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2640", "+", 
                  RowBox[{"940", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"57", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"90", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"27904", "+", 
                  RowBox[{"26440", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"2984", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"55", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"3", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "33384960"}], "+", 
            RowBox[{"1536", " ", 
             SuperscriptBox["h0", "10"]}], "+", 
            RowBox[{"8375008", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"345600", " ", 
             SuperscriptBox["t1", "5"], " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{"9631980", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"342219", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"1125", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "27"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"216000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"384", " ", 
             SuperscriptBox["h0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"6000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "11792"}], "+", 
               RowBox[{"1968", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"273", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"600", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "127904"}], "+", 
               RowBox[{"34864", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13509", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"201", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1982"}], "+", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"182508", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"42045", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"351", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "482264"}], "+", 
               RowBox[{"288000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"4989942", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"549546", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"42795", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"90000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"5940", "+", 
                  RowBox[{"29596", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3345", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "521600"}], "+", 
               RowBox[{"2056640", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"216000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"966577", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"52500", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "-", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"1500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2640", "+", 
                  RowBox[{"940", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"57", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"90", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"27904", "+", 
                  RowBox[{"26440", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"2984", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"55", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"p0", " ", 
          RowBox[{"(", 
           RowBox[{"51673600", "+", 
            RowBox[{"172800", " ", 
             SuperscriptBox["h0", "10"]}], "-", 
            RowBox[{"126831744", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"1036800", " ", 
             SuperscriptBox["t1", "5"], " ", 
             SuperscriptBox["z0", "5"]}], "-", 
            RowBox[{"55181280", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"1195533", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"82845", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"648000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1152", " ", 
             SuperscriptBox["h0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"72000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "592"}], "+", 
               RowBox[{"972", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"9000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "10240"}], "+", 
               RowBox[{"24624", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2847", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "-", 
            RowBox[{"360", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"294400", "-", 
               RowBox[{"787376", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"176115", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"177", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"121042", "+", 
               RowBox[{"9000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"57561", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"109660", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"1158", "+", 
                  RowBox[{"769", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1609360"}], "+", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"1453810", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2057109", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"170735", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"6000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16172"}], "+", 
                  RowBox[{"19704", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"10065", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"48395008", "+", 
               RowBox[{"47872928", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"864000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"62340036", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"4514562", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"71055", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "-", 
               RowBox[{"1152000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"9", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"18000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "+", 
                  RowBox[{"3880", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"703", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"618016", "+", 
                  RowBox[{"918720", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"467922", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"17925", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"horizh", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"h0", "+", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "h0"}], "+", 
          RowBox[{"a1", " ", "p0", " ", 
           SuperscriptBox["z0", "2"]}]}], ")"}]}], 
       RowBox[{"t1", " ", 
        SuperscriptBox["z0", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["h0", "3"]}], "+", 
          RowBox[{"12", " ", "a1", " ", 
           SuperscriptBox["h0", "2"], " ", "p0", " ", 
           SuperscriptBox["z0", "2"]}], "+", 
          RowBox[{"h0", " ", 
           RowBox[{"(", 
            RowBox[{"16", "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["p0", "2"]}], "-", 
             RowBox[{"8", " ", "t1", " ", "z0"}], "-", 
             RowBox[{"11", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
          RowBox[{"a1", " ", "p0", " ", 
           SuperscriptBox["z0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "28"}], "+", 
             RowBox[{"12", " ", 
              SuperscriptBox["p0", "2"]}], "+", 
             RowBox[{"8", " ", "t1", " ", "z0"}], "-", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["t1", "2"], " ", 
        SuperscriptBox["z0", "4"]}]], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"72", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "6"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"48", " ", 
          SuperscriptBox["h0", "5"]}], "-", 
         RowBox[{"96", " ", "a1", " ", 
          SuperscriptBox["h0", "4"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"24", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"36", "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"18", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"3", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"11", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"h0", " ", 
          RowBox[{"(", 
           RowBox[{"592", "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"576", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"972", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"396", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "-", 
            RowBox[{"51", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               RowBox[{"3", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"12", " ", "a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "108"}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"84", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"72", "-", 
               RowBox[{"36", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"14", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"576", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"288", " ", 
          SuperscriptBox["h0", "7"]}], "+", 
         RowBox[{"96", " ", "a1", " ", 
          SuperscriptBox["h0", "6"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["h0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"85", "+", 
            RowBox[{"18", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"24", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"104", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"48", " ", "a1", " ", 
          SuperscriptBox["h0", "4"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"60", "-", 
            RowBox[{"6", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"48", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"85", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"6", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"2640", "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"864", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"940", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"57", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "60"}], "+", 
               RowBox[{"48", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"85", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"36", "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"2352", "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"3880", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"703", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"192", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "11792"}], "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "6"]}], "+", 
            RowBox[{"576", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"1968", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"273", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"24", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "60"}], "+", 
               RowBox[{"48", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"85", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"576", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "27"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"216", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2640", "+", 
               RowBox[{"864", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"940", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"57", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"96", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"h0", " ", 
          RowBox[{"(", 
           RowBox[{"10240", "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"1152", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"24624", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"2847", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"27", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"432", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"24", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "592"}], "+", 
               RowBox[{"972", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "+", 
               RowBox[{"288", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"3880", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"703", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"192", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"9", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"7200", " ", 
         SuperscriptBox["t1", "5"], " ", 
         SuperscriptBox["z0", "10"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2880", " ", 
          SuperscriptBox["h0", "9"]}], "+", 
         RowBox[{"192", " ", "a1", " ", 
          SuperscriptBox["h0", "8"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["h0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"1158", "+", 
            RowBox[{"240", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"300", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"769", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"12", " ", "a1", " ", 
          SuperscriptBox["h0", "4"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5940", "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"4800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"29596", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"3345", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"60", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1000", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"12", "+", 
               RowBox[{"17", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"80860", "+", 
            RowBox[{"4320", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"98520", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"50325", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"36", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1158"}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"600", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"48", " ", "a1", " ", 
          SuperscriptBox["h0", "6"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"8", "-", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"83712", "+", 
            RowBox[{"256", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"28800", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"79320", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"8952", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"165", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"240", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"4800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"36", "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"100", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2640", "+", 
               RowBox[{"940", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"57", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"5940", "+", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"29596", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3345", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"1000", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"618016", "+", 
            RowBox[{"11520", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"28800", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"918720", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"467922", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"17925", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"144", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1158"}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"28800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"300", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2352", "+", 
               RowBox[{"3880", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"703", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"40", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"16172", "+", 
               RowBox[{"1440", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"19704", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"10065", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"h0", " ", 
          RowBox[{"(", 
           RowBox[{"294400", "+", 
            RowBox[{"2880", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"787376", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"14400", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"176115", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"177", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1158"}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"600", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "592"}], "+", 
               RowBox[{"972", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"50", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "10240"}], "+", 
               RowBox[{"24624", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2847", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"20", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"16172", "+", 
               RowBox[{"1440", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"19704", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"10065", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"618016", "-", 
               RowBox[{"28800", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"918720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"467922", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"17925", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"28800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"9", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "+", 
                  RowBox[{"3880", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"703", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"192", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"240", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"5940", "+", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"29596", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3345", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"1000", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "127904"}], "+", 
               RowBox[{"34864", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"2880", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13509", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"201", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"5760", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "27"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"1440", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"28", "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"20", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "11792"}], "+", 
                  RowBox[{"1968", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"273", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"28800", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2640", "+", 
                  RowBox[{"940", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"57", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"3", " ", 
                RowBox[{"(", 
                 RowBox[{"27904", "+", 
                  RowBox[{"26440", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"2984", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"55", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"518400", " ", 
         SuperscriptBox["t1", "6"], " ", 
         SuperscriptBox["z0", "12"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"172800", " ", 
          SuperscriptBox["h0", "11"]}], "+", 
         RowBox[{"4608", " ", "a1", " ", 
          SuperscriptBox["h0", "10"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"1152", " ", 
          SuperscriptBox["h0", "9"], " ", 
          RowBox[{"(", 
           RowBox[{"3655", "+", 
            RowBox[{"750", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"900", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"741", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"1152", " ", "a1", " ", 
          SuperscriptBox["h0", "8"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "124"}], "-", 
            RowBox[{"20", " ", 
             SuperscriptBox["p0", "2"]}], "+", 
            RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"5375", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"288", " ", 
          SuperscriptBox["h0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"121042", "+", 
            RowBox[{"6000", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"9000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"57561", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"109660", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"60", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1158", "+", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"288", " ", "a1", " ", 
          SuperscriptBox["h0", "6"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1982"}], "+", 
            RowBox[{"160", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"3000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"182508", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"42045", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"300", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"24", " ", "a1", " ", 
          SuperscriptBox["h0", "4"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"482264", "-", 
            RowBox[{"1920", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"288000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"4989942", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"549546", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"42795", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"90000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"12", "+", 
               RowBox[{"17", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"180", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"5940", "+", 
               RowBox[{"29596", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3345", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"36", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1982"}], "+", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"182508", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"42045", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"351", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"72", " ", 
          SuperscriptBox["h0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"1609360", "+", 
            RowBox[{"24000", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"48000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"1453810", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"2057109", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"170735", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"6000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"100", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16172"}], "+", 
               RowBox[{"19704", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"10065", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"121042", "+", 
               RowBox[{"9000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"57561", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"109660", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"1158", "+", 
                  RowBox[{"769", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"48395008", "+", 
            RowBox[{"288000", " ", 
             SuperscriptBox["p0", "8"]}], "+", 
            RowBox[{"47872928", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"864000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"62340036", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"4514562", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"71055", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1536", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"18000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "+", 
               RowBox[{"3880", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"703", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"120", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"618016", "+", 
               RowBox[{"918720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"467922", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"17925", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"121042", "+", 
               RowBox[{"9000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"57561", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"109660", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"1158", "+", 
                  RowBox[{"769", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1609360"}], "+", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"1453810", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2057109", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"170735", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"6000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16172"}], "+", 
                  RowBox[{"19704", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"10065", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"12", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1920", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"384", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"72", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1982"}], "+", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"182508", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"42045", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"351", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "482264"}], "+", 
               RowBox[{"288000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"4989942", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"549546", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"42795", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"90000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"5940", "+", 
                  RowBox[{"29596", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3345", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "521600"}], "+", 
               RowBox[{"2056640", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"216000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"966577", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"52500", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "-", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"1500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2640", "+", 
                  RowBox[{"940", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"57", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"90", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"27904", "+", 
                  RowBox[{"26440", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"2984", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"55", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"3", " ", "a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "33384960"}], "+", 
            RowBox[{"1536", " ", 
             SuperscriptBox["p0", "10"]}], "+", 
            RowBox[{"8375008", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"345600", " ", 
             SuperscriptBox["t1", "5"], " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{"9631980", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"342219", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"1125", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "27"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"216000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"384", " ", 
             SuperscriptBox["p0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"6000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "11792"}], "+", 
               RowBox[{"1968", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"273", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"600", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "127904"}], "+", 
               RowBox[{"34864", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13509", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"201", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1982"}], "+", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"182508", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"42045", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"351", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "482264"}], "+", 
               RowBox[{"288000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"4989942", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"549546", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"42795", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"90000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"5940", "+", 
                  RowBox[{"29596", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3345", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "521600"}], "+", 
               RowBox[{"2056640", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"216000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"966577", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"52500", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "-", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"1500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2640", "+", 
                  RowBox[{"940", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"57", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"90", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"27904", "+", 
                  RowBox[{"26440", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"2984", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"55", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"h0", " ", 
          RowBox[{"(", 
           RowBox[{"51673600", "+", 
            RowBox[{"172800", " ", 
             SuperscriptBox["p0", "10"]}], "-", 
            RowBox[{"126831744", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"1036800", " ", 
             SuperscriptBox["t1", "5"], " ", 
             SuperscriptBox["z0", "5"]}], "-", 
            RowBox[{"55181280", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"1195533", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"82845", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"648000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1152", " ", 
             SuperscriptBox["p0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"72000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "592"}], "+", 
               RowBox[{"972", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"9000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "10240"}], "+", 
               RowBox[{"24624", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2847", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "-", 
            RowBox[{"360", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"294400", "-", 
               RowBox[{"787376", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"176115", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"177", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"121042", "+", 
               RowBox[{"9000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"57561", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"109660", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"1158", "+", 
                  RowBox[{"769", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1609360"}], "+", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"1453810", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2057109", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"170735", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"6000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16172"}], "+", 
                  RowBox[{"19704", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"10065", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"48395008", "+", 
               RowBox[{"47872928", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"864000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"62340036", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"4514562", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"71055", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "-", 
               RowBox[{"1152000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"9", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"18000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "+", 
                  RowBox[{"3880", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"703", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"618016", "+", 
                  RowBox[{"918720", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"467922", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"17925", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"horiza", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"a1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}]}], "+", 
      FractionBox[
       RowBox[{"a1", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "12"}], "+", 
          RowBox[{"12", " ", 
           SuperscriptBox["h0", "2"]}], "+", 
          RowBox[{"12", " ", 
           SuperscriptBox["p0", "2"]}], "+", 
          RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
          RowBox[{
           SuperscriptBox["a1", "2"], " ", 
           SuperscriptBox["z0", "4"]}]}], ")"}]}], 
       RowBox[{"4", " ", "t1", " ", 
        SuperscriptBox["z0", "2"]}]], "+", 
      FractionBox[
       RowBox[{"a1", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"112", " ", 
           SuperscriptBox["h0", "4"]}], "+", 
          RowBox[{"112", " ", 
           SuperscriptBox["p0", "4"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "12"}], "+", 
              RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
              RowBox[{
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}], "2"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["p0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "64"}], "+", 
             RowBox[{"36", " ", "t1", " ", "z0"}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["h0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "64"}], "+", 
             RowBox[{"28", " ", 
              SuperscriptBox["p0", "2"]}], "+", 
             RowBox[{"36", " ", "t1", " ", "z0"}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"48", " ", 
        SuperscriptBox["t1", "2"], " ", 
        SuperscriptBox["z0", "4"]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"192", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "6"]}]], "a1", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"192", " ", 
          SuperscriptBox["h0", "6"]}], "+", 
         RowBox[{"192", " ", 
          SuperscriptBox["p0", "6"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "3"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "96"}], "+", 
            RowBox[{"84", " ", "t1", " ", "z0"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "96"}], "+", 
            RowBox[{"36", " ", 
             SuperscriptBox["p0", "2"]}], "+", 
            RowBox[{"84", " ", "t1", " ", "z0"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1232", "+", 
            RowBox[{"432", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"188", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"24", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "64"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1232", "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"432", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"188", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "96"}], "+", 
               RowBox[{"84", " ", "t1", " ", "z0"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"24", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "64"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"3840", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}]], "a1", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "256"}], " ", 
          SuperscriptBox["h0", "8"]}], "-", 
         RowBox[{"256", " ", 
          SuperscriptBox["p0", "8"]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "166"}], "+", 
            RowBox[{"120", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"29", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "4"]}], "-", 
         RowBox[{"128", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"166", "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"120", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"29", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"1456", "+", 
            RowBox[{"1680", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"240", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"51", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "96"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1456"}], "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"1680", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"240", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"51", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "96"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"166", "-", 
               RowBox[{"120", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"29", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "20096"}], "+", 
            RowBox[{"5760", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"8464", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"762", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"27", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"480", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "64"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1232", "-", 
               RowBox[{"188", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"20096", "+", 
            RowBox[{"128", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"5760", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"8464", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"762", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"27", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "166"}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"29", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"480", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "64"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1232", "-", 
               RowBox[{"188", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1456", "+", 
               RowBox[{"1680", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"240", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"40", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "96"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"691200", " ", 
         SuperscriptBox["t1", "5"], " ", 
         SuperscriptBox["z0", "10"]}]], "a1", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"95232", " ", 
          SuperscriptBox["h0", "10"]}], "+", 
         RowBox[{"95232", " ", 
          SuperscriptBox["p0", "10"]}], "+", 
         RowBox[{"3840", " ", 
          SuperscriptBox["h0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{"536", "+", 
            RowBox[{"124", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"60", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"369", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"675", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "5"]}], "-", 
         RowBox[{"3840", " ", 
          SuperscriptBox["p0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "536"}], "+", 
            RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"369", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"1536", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"11825", "+", 
            RowBox[{"4500", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"3443", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"600", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"75", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"166", "+", 
               RowBox[{"29", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"1536", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"11825", "+", 
            RowBox[{"620", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"4500", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"3443", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"600", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"75", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"166", "+", 
               RowBox[{"29", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"10", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "536"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"369", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"37424", "+", 
            RowBox[{"252000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"120120", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"30459", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"1035", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"9000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "96"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"450", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1456", "-", 
               RowBox[{"240", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"20", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "23296"}], "-", 
            RowBox[{"1991040", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"518400", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"281256", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"24624", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"567", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "64"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1232", "-", 
               RowBox[{"188", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"360", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "20096"}], "+", 
               RowBox[{"8464", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"762", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"37424", "+", 
            RowBox[{"14880", " ", 
             SuperscriptBox["p0", "6"]}], "+", 
            RowBox[{"252000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"120120", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"30459", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"1035", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"9000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "96"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"360", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "536"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"369", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"450", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1456", "-", 
               RowBox[{"240", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"72", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"11825", "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"3443", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"600", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"75", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"166", "+", 
                  RowBox[{"29", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"119040", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"3840", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "536"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"369", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"1152", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"11825", "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"3443", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"600", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"75", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"166", "+", 
                  RowBox[{"29", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"32", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"37424", "+", 
               RowBox[{"252000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"120120", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"30459", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1035", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"9000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "96"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"450", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"1456", "-", 
                  RowBox[{"240", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"51", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "23296"}], "-", 
               RowBox[{"1991040", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"518400", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"281256", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"24624", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"567", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"57600", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "64"}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"7200", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"1232", "-", 
                  RowBox[{"188", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"9", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"360", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "20096"}], "+", 
                  RowBox[{"8464", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"762", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"27", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"horizT", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"t1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["t1", "z0"]}], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a1", "2"], " ", 
           SuperscriptBox["z0", "2"]}], "2"]}], ")"}]}], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["h0", "4"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["p0", "4"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["p0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"15", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["h0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["p0", "2"]}], "+", 
             RowBox[{"15", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"48", "-", 
             RowBox[{"40", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["a1", "4"], " ", 
              SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"48", " ", "t1", " ", 
        SuperscriptBox["z0", "4"]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"48", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["h0", "6"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["p0", "6"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"18", "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"2", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"35", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "18"}], "+", 
            RowBox[{"2", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"35", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"12", "-", 
            RowBox[{"13", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "400"}], "-", 
            RowBox[{"728", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"39", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"8", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "400"}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"728", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"39", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"8", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "18"}], "+", 
               RowBox[{"2", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"3840", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "8"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1280", " ", 
          SuperscriptBox["h0", "8"]}], "+", 
         RowBox[{"1280", " ", 
          SuperscriptBox["p0", "8"]}], "-", 
         RowBox[{"128", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"20", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"67", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"40", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"20", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"67", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"604", "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"1182", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"29", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"10", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "18"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"604", "+", 
            RowBox[{"60", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"1182", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"29", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"10", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "18"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"402", "-", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"603", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"15", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "12"}], "+", 
                RowBox[{
                 SuperscriptBox["a1", "2"], " ", 
                 SuperscriptBox["z0", "4"]}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"32", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"12", "-", 
               RowBox[{"13", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"18560", "+", 
            RowBox[{"29744", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"3778", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"147", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"80", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"20", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "400"}], "-", 
               RowBox[{"728", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"18560", "+", 
            RowBox[{"640", " ", 
             SuperscriptBox["p0", "6"]}], "+", 
            RowBox[{"29744", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"3778", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"147", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"80", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"20", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "400"}], "-", 
               RowBox[{"728", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "20"}], " ", "t1", " ", "z0"}], "+", 
               RowBox[{"67", " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"32", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"604", "+", 
               RowBox[{"10", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"1182", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"29", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"10", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "18"}], "+", 
                  RowBox[{"35", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"69120", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "10"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"23040", " ", 
          SuperscriptBox["h0", "10"]}], "+", 
         RowBox[{"23040", " ", 
          SuperscriptBox["p0", "10"]}], "+", 
         RowBox[{"768", " ", 
          SuperscriptBox["h0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{"534", "+", 
            RowBox[{"150", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"90", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"437", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"768", " ", 
          SuperscriptBox["p0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "534"}], "+", 
            RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"437", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"135", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"24", "-", 
            RowBox[{"8", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"38", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
         RowBox[{"192", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"13760", "+", 
            RowBox[{"360", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"16732", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"573", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"2412", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"192", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"13760", "+", 
            RowBox[{"1200", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"360", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"16732", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"573", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"2412", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "534"}], "+", 
               RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"437", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"256", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"90", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"135", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "18"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"27", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"604", "-", 
               RowBox[{"1182", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"29", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"8", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3827"}], "+", 
               RowBox[{"5487", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"384", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5474560"}], "-", 
            RowBox[{"7142016", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"1601088", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"126936", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"3699", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "+", 
            RowBox[{"5760", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"2160", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "400"}], "-", 
               RowBox[{"728", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"216", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"18560", "+", 
               RowBox[{"29744", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"3778", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"147", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3600", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "534"}], "+", 
               RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"437", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"13760", "+", 
               RowBox[{"360", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"16732", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"573", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"2412", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"90", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"135", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "18"}], "+", 
                  RowBox[{"35", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"27", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"604", "-", 
                  RowBox[{"1182", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"29", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"8", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3827"}], "+", 
                  RowBox[{"5487", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"384", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"27", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5474560", "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["p0", "8"]}], "+", 
            RowBox[{"7142016", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"1601088", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"126936", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"3699", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"5760", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1536", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "534"}], "+", 
               RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"437", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"2160", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "400"}], "-", 
               RowBox[{"728", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"216", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"18560", "+", 
               RowBox[{"29744", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"3778", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"147", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"13760", "+", 
               RowBox[{"360", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"16732", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"573", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"2412", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"256", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"90", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"135", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "18"}], "+", 
                  RowBox[{"35", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"27", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"604", "-", 
                  RowBox[{"1182", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"29", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"8", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3827"}], "+", 
                  RowBox[{"5487", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"384", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"27", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"horizS", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"s0", "+", 
     FractionBox[
      RowBox[{"s0", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"12", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "2"]}], "-", 
         RowBox[{"4", " ", "t1", " ", "z0"}], "-", 
         RowBox[{
          SuperscriptBox["a1", "2"], " ", 
          SuperscriptBox["z0", "4"]}]}], ")"}]}], 
      RowBox[{"4", " ", "t1", " ", 
       SuperscriptBox["z0", "2"]}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h0", "2"], "+", 
         SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["a1", "2"], " ", 
          SuperscriptBox["z0", "4"]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["t1", "2"], " ", 
       SuperscriptBox["z0", "4"]}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h0", "2"], "+", 
         SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "20"}], "+", 
            RowBox[{"12", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
      RowBox[{"12", " ", 
       SuperscriptBox["t1", "3"], " ", 
       SuperscriptBox["z0", "6"]}]], "-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"288", " ", 
        SuperscriptBox["t1", "4"], " ", 
        SuperscriptBox["z0", "8"]}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h0", "2"], "+", 
        SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
      RowBox[{"(", 
       RowBox[{"800", "-", 
        RowBox[{"960", " ", "t1", " ", "z0"}], "+", 
        RowBox[{"288", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "2"]}], "+", 
        RowBox[{"816", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["z0", "4"]}], "-", 
        RowBox[{"1104", " ", 
         SuperscriptBox["a1", "2"], " ", "t1", " ", 
         SuperscriptBox["z0", "5"]}], "+", 
        RowBox[{"288", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}], "+", 
        RowBox[{"363", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "-", 
        RowBox[{"144", " ", 
         SuperscriptBox["a1", "4"], " ", "t1", " ", 
         SuperscriptBox["z0", "9"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["z0", "12"]}], "+", 
        RowBox[{"48", " ", 
         SuperscriptBox["h0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"19", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
        RowBox[{"48", " ", 
         SuperscriptBox["p0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"19", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
        RowBox[{"24", " ", 
         SuperscriptBox["p0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"22", "-", 
           RowBox[{"8", " ", "t1", " ", "z0"}], "-", 
           RowBox[{"107", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"56", " ", 
            SuperscriptBox["a1", "2"], " ", "t1", " ", 
            SuperscriptBox["z0", "5"]}], "-", 
           RowBox[{"23", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
        RowBox[{"24", " ", 
         SuperscriptBox["h0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"22", "-", 
           RowBox[{"8", " ", "t1", " ", "z0"}], "-", 
           RowBox[{"107", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"56", " ", 
            SuperscriptBox["a1", "2"], " ", "t1", " ", 
            SuperscriptBox["z0", "5"]}], "-", 
           RowBox[{"23", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"4", "+", 
              RowBox[{"76", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
     "-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"5760", " ", 
        SuperscriptBox["t1", "5"], " ", 
        SuperscriptBox["z0", "10"]}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h0", "2"], "+", 
        SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "27520"}], "+", 
        RowBox[{"48000", " ", "t1", " ", "z0"}], "-", 
        RowBox[{"28800", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "2"]}], "+", 
        RowBox[{"5760", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "3"]}], "-", 
        RowBox[{"17056", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["z0", "4"]}], "+", 
        RowBox[{"48960", " ", 
         SuperscriptBox["a1", "2"], " ", "t1", " ", 
         SuperscriptBox["z0", "5"]}], "-", 
        RowBox[{"33120", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}], "+", 
        RowBox[{"5760", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "7"]}], "-", 
        RowBox[{"25680", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "+", 
        RowBox[{"21780", " ", 
         SuperscriptBox["a1", "4"], " ", "t1", " ", 
         SuperscriptBox["z0", "9"]}], "-", 
        RowBox[{"4320", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "10"]}], "-", 
        RowBox[{"1677", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["z0", "12"]}], "+", 
        RowBox[{"540", " ", 
         SuperscriptBox["a1", "6"], " ", "t1", " ", 
         SuperscriptBox["z0", "13"]}], "-", 
        RowBox[{"9", " ", 
         SuperscriptBox["a1", "8"], " ", 
         SuperscriptBox["z0", "16"]}], "+", 
        RowBox[{"192", " ", 
         SuperscriptBox["h0", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"77", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
        RowBox[{"192", " ", 
         SuperscriptBox["p0", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"77", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
        RowBox[{"48", " ", 
         SuperscriptBox["p0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "204"}], "-", 
           RowBox[{"2005", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"845", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"60", " ", "t1", " ", 
            RowBox[{"(", 
             RowBox[{"z0", "+", 
              RowBox[{"19", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "5"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"48", " ", 
         SuperscriptBox["h0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "204"}], "-", 
           RowBox[{"2005", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"845", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "+", 
              RowBox[{"77", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
           RowBox[{"60", " ", "t1", " ", 
            RowBox[{"(", 
             RowBox[{"z0", "+", 
              RowBox[{"19", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "5"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["p0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3184"}], "+", 
           RowBox[{"11228", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"6359", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"339", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "+", 
           RowBox[{"480", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"120", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "22"}], "+", 
              RowBox[{"107", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"23", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["h0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3184"}], "+", 
           RowBox[{"11228", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"6359", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"339", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "+", 
           RowBox[{"480", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
           RowBox[{"48", " ", 
            SuperscriptBox["p0", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "+", 
              RowBox[{"77", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"120", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "22"}], "+", 
              RowBox[{"107", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"23", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "204"}], "-", 
              RowBox[{"2005", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "-", 
              RowBox[{"845", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"60", " ", "t1", " ", 
               RowBox[{"(", 
                RowBox[{"z0", "+", 
                 RowBox[{"19", " ", 
                  SuperscriptBox["a1", "2"], " ", 
                  SuperscriptBox["z0", "5"]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}], "-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"172800", " ", 
        SuperscriptBox["t1", "6"], " ", 
        SuperscriptBox["z0", "12"]}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h0", "2"], "+", 
        SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
      RowBox[{"(", 
       RowBox[{"1516800", "-", 
        RowBox[{"3302400", " ", "t1", " ", "z0"}], "+", 
        RowBox[{"2880000", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "2"]}], "-", 
        RowBox[{"1152000", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "3"]}], "+", 
        RowBox[{"153472", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["z0", "4"]}], "+", 
        RowBox[{"172800", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "4"]}], "-", 
        RowBox[{"2046720", " ", 
         SuperscriptBox["a1", "2"], " ", "t1", " ", 
         SuperscriptBox["z0", "5"]}], "+", 
        RowBox[{"2937600", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}], "-", 
        RowBox[{"1324800", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "7"]}], "+", 
        RowBox[{"2265960", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "+", 
        RowBox[{"172800", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "-", 
        RowBox[{"3081600", " ", 
         SuperscriptBox["a1", "4"], " ", "t1", " ", 
         SuperscriptBox["z0", "9"]}], "+", 
        RowBox[{"1306800", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "10"]}], "-", 
        RowBox[{"172800", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "11"]}], "+", 
        RowBox[{"313536", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["z0", "12"]}], "-", 
        RowBox[{"201240", " ", 
         SuperscriptBox["a1", "6"], " ", "t1", " ", 
         SuperscriptBox["z0", "13"]}], "+", 
        RowBox[{"32400", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "14"]}], "+", 
        RowBox[{"3915", " ", 
         SuperscriptBox["a1", "8"], " ", 
         SuperscriptBox["z0", "16"]}], "-", 
        RowBox[{"1080", " ", 
         SuperscriptBox["a1", "8"], " ", "t1", " ", 
         SuperscriptBox["z0", "17"]}], "+", 
        RowBox[{"768", " ", 
         SuperscriptBox["h0", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"15", "+", 
           RowBox[{"278", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
        RowBox[{"768", " ", 
         SuperscriptBox["p0", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"15", "+", 
           RowBox[{"278", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
        RowBox[{"384", " ", 
         SuperscriptBox["p0", "6"], " ", 
         RowBox[{"(", 
          RowBox[{"683", "-", 
           RowBox[{"7261", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"7240", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"60", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "+", 
              RowBox[{"77", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"384", " ", 
         SuperscriptBox["h0", "6"], " ", 
         RowBox[{"(", 
          RowBox[{"683", "-", 
           RowBox[{"7261", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"7240", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"60", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "+", 
              RowBox[{"77", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"15", "+", 
              RowBox[{"278", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["p0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"54040", "+", 
           RowBox[{"291390", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"328548", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"30285", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "+", 
           RowBox[{"5400", " ", 
            SuperscriptBox["t1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["z0", "2"], "+", 
              RowBox[{"19", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "6"]}]}], ")"}]}], "-", 
           RowBox[{"180", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{"204", "+", 
              RowBox[{"2005", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"845", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["p0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"437376", "-", 
           RowBox[{"1112096", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"1250343", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "-", 
           RowBox[{"162069", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "-", 
           RowBox[{"3150", " ", 
            SuperscriptBox["a1", "8"], " ", 
            SuperscriptBox["z0", "16"]}], "+", 
           RowBox[{"28800", " ", 
            SuperscriptBox["t1", "3"], " ", 
            SuperscriptBox["z0", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"10800", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "22"}], "+", 
              RowBox[{"107", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"23", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
           RowBox[{"180", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3184"}], "+", 
              RowBox[{"11228", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"6359", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"339", " ", 
               SuperscriptBox["a1", "6"], " ", 
               SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["h0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"54040", "+", 
           RowBox[{"291390", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"328548", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"30285", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "+", 
           RowBox[{"144", " ", 
            SuperscriptBox["p0", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"15", "+", 
              RowBox[{"278", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
           RowBox[{"5400", " ", 
            SuperscriptBox["t1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["z0", "2"], "+", 
              RowBox[{"19", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "6"]}]}], ")"}]}], "-", 
           RowBox[{"180", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{"204", "+", 
              RowBox[{"2005", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"845", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
           RowBox[{"36", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"683", "-", 
              RowBox[{"7261", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "-", 
              RowBox[{"7240", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"60", " ", "t1", " ", "z0", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "3"}], "+", 
                 RowBox[{"77", " ", 
                  SuperscriptBox["a1", "2"], " ", 
                  SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["h0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"437376", "-", 
           RowBox[{"1112096", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"1250343", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "-", 
           RowBox[{"162069", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "-", 
           RowBox[{"3150", " ", 
            SuperscriptBox["a1", "8"], " ", 
            SuperscriptBox["z0", "16"]}], "+", 
           RowBox[{"28800", " ", 
            SuperscriptBox["t1", "3"], " ", 
            SuperscriptBox["z0", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
           RowBox[{"384", " ", 
            SuperscriptBox["p0", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"15", "+", 
              RowBox[{"278", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"10800", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "22"}], "+", 
              RowBox[{"107", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"23", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
           RowBox[{"180", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3184"}], "+", 
              RowBox[{"11228", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"6359", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"339", " ", 
               SuperscriptBox["a1", "6"], " ", 
               SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
           RowBox[{"144", " ", 
            SuperscriptBox["p0", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"683", "-", 
              RowBox[{"7261", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "-", 
              RowBox[{"7240", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"60", " ", "t1", " ", "z0", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "3"}], "+", 
                 RowBox[{"77", " ", 
                  SuperscriptBox["a1", "2"], " ", 
                  SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"54040", "+", 
              RowBox[{"291390", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"328548", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"30285", " ", 
               SuperscriptBox["a1", "6"], " ", 
               SuperscriptBox["z0", "12"]}], "+", 
              RowBox[{"5400", " ", 
               SuperscriptBox["t1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["z0", "2"], "+", 
                 RowBox[{"19", " ", 
                  SuperscriptBox["a1", "2"], " ", 
                  SuperscriptBox["z0", "6"]}]}], ")"}]}], "-", 
              RowBox[{"180", " ", "t1", " ", "z0", " ", 
               RowBox[{"(", 
                RowBox[{"204", "+", 
                 RowBox[{"2005", " ", 
                  SuperscriptBox["a1", "2"], " ", 
                  SuperscriptBox["z0", "4"]}], "+", 
                 RowBox[{"845", " ", 
                  SuperscriptBox["a1", "4"], " ", 
                  SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5384640040309467`*^9, 3.5384640865225697`*^9}, {
  3.538464329491736*^9, 3.538464352894101*^9}, {3.543863781948699*^9, 
  3.543863800923451*^9}, {3.543863915894534*^9, 3.543863966433701*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"asymp", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"p2", " ", 
       SuperscriptBox["z", "2"]}], "+", 
      RowBox[{"2", " ", "a0", " ", "h2", " ", 
       SuperscriptBox["z", "3"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a1", " ", "h2"}], "-", 
         FractionBox[
          RowBox[{"8", " ", 
           SuperscriptBox["a0", "2"], " ", "p2"}], "3"]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["a0", "3"], " ", "h2"}], "-", 
         RowBox[{"8", " ", "a0", " ", "a1", " ", "p2"}], "-", 
         RowBox[{"p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "5"]}], "+", 
      RowBox[{
       FractionBox["1", "120"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "480"}], " ", 
          SuperscriptBox["a0", "2"], " ", "a1", " ", "h2"}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["a0", "4"], " ", "p2"}], "-", 
         RowBox[{"93", " ", 
          SuperscriptBox["a1", "2"], " ", "p2"}], "+", 
         RowBox[{"28", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}], "-", 
         RowBox[{"140", " ", "a0", " ", "h2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "+", 
      RowBox[{
       FractionBox["1", "180"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"256", " ", 
          SuperscriptBox["a0", "5"], " ", "h2"}], "+", 
         RowBox[{"768", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{"3", " ", "a0", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "139"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"52", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"132", " ", "a1", " ", "h2", " ", "T3"}], "+", 
         RowBox[{"396", " ", 
          SuperscriptBox["a0", "2"], " ", "p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8960", " ", 
           SuperscriptBox["a0", "4"], " ", "a1", " ", "h2"}], "-", 
          RowBox[{"1323", " ", 
           SuperscriptBox["a1", "3"], " ", "h2"}], "-", 
          RowBox[{"2048", " ", 
           SuperscriptBox["a0", "6"], " ", "p2"}], "+", 
          RowBox[{"1260", " ", "a1", " ", "h2", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["h2", "2"], "+", 
             SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["a0", "2"], " ", "p2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"1177", " ", 
              SuperscriptBox["a1", "2"]}], "-", 
             RowBox[{"586", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"7168", " ", 
           SuperscriptBox["a0", "3"], " ", "h2", " ", "T3"}], "+", 
          RowBox[{"6596", " ", "a0", " ", "a1", " ", "p2", " ", "T3"}], "+", 
          RowBox[{"500", " ", "p2", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "8"]}], "2520"], "+", 
      RowBox[{
       FractionBox["1", "1260"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"128", " ", 
             SuperscriptBox["a0", "6"], " ", "h2"}], "+", 
            RowBox[{"768", " ", 
             SuperscriptBox["a0", "4"], " ", "a1", " ", "p2"}], "-", 
            RowBox[{"534", " ", 
             SuperscriptBox["a1", "3"], " ", "p2"}], "+", 
            RowBox[{"650", " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"25", " ", 
             SuperscriptBox["a0", "2"], " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "53"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"36", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
         "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6176", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "h2"}], "-", 
            RowBox[{"3520", " ", 
             SuperscriptBox["a0", "4"], " ", "p2"}], "+", 
            RowBox[{"p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"1113", " ", 
                SuperscriptBox["a1", "2"]}], "-", 
               RowBox[{"334", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "+", 
         RowBox[{"1070", " ", "a0", " ", "h2", " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "9"]}], "+", 
      RowBox[{
       FractionBox["1", "362880"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "516096"}], " ", 
          SuperscriptBox["a0", "6"], " ", "a1", " ", "h2"}], "+", 
         RowBox[{"65536", " ", 
          SuperscriptBox["a0", "8"], " ", "p2"}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["a0", "4"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5191"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"4985", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"27", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4459", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"8800", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"1296", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
         RowBox[{"801792", " ", 
          SuperscriptBox["a0", "5"], " ", "h2", " ", "T3"}], "-", 
         RowBox[{"2274304", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "p2", " ", "T3"}], "-", 
         RowBox[{"72", " ", "a0", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "16279"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"6152", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "+", 
         RowBox[{"211104", " ", "a1", " ", "h2", " ", 
          SuperscriptBox["T3", "2"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"65628", " ", 
             SuperscriptBox["a1", "3"], " ", "h2"}], "-", 
            RowBox[{"106344", " ", "a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "-", 
            RowBox[{"42517", " ", "p2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "10"]}], "+", 
      RowBox[{
       FractionBox["1", "907200"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"65536", " ", 
             SuperscriptBox["a0", "8"], " ", "h2"}], "+", 
            RowBox[{"655360", " ", 
             SuperscriptBox["a0", "6"], " ", "a1", " ", "p2"}], "+", 
            RowBox[{"256", " ", 
             SuperscriptBox["a0", "4"], " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "9239"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"12877", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"128", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "24170"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"53921", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"342771", " ", 
                SuperscriptBox["a1", "4"]}], "-", 
               RowBox[{"878720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
               RowBox[{"131344", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["h2", "2"], "+", 
                   SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "690688"}], " ", 
             SuperscriptBox["a0", "4"], " ", "a1", " ", "h2"}], "+", 
            RowBox[{"165760", " ", 
             SuperscriptBox["a0", "6"], " ", "p2"}], "+", 
            RowBox[{"6", " ", "a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"15519", " ", 
                SuperscriptBox["a1", "2"]}], "-", 
               RowBox[{"14764", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a0", "2"], " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "696615"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"349432", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "-", 
         RowBox[{"80", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"31441", " ", 
             SuperscriptBox["a0", "2"], " ", "h2"}], "+", 
            RowBox[{"27384", " ", "a1", " ", "p2"}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}], "-", 
         RowBox[{"128000", " ", "p2", " ", 
          SuperscriptBox["T3", "3"]}]}], ")"}], " ", 
       SuperscriptBox["z", "11"]}], "+", 
      RowBox[{
       FractionBox["1", "19958400"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6488064", " ", 
          SuperscriptBox["a0", "8"], " ", "a1", " ", "h2"}], "-", 
         RowBox[{"524288", " ", 
          SuperscriptBox["a0", "10"], " ", "p2"}], "-", 
         RowBox[{"2048", " ", 
          SuperscriptBox["a0", "6"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "15323"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"31837", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"99", " ", "a1", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"40425", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"137664", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"53104", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "+", 
         RowBox[{"16580608", " ", 
          SuperscriptBox["a0", "7"], " ", "h2", " ", "T3"}], "+", 
         RowBox[{"95269888", " ", 
          SuperscriptBox["a0", "5"], " ", "a1", " ", "p2", " ", "T3"}], "+", 
         RowBox[{"1408", " ", 
          SuperscriptBox["a0", "3"], " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "112858"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"77229", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "+", 
         RowBox[{"1232", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "14319"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"4438", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}], "-", 
         RowBox[{"8", " ", "a0", " ", "T3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7711461", " ", 
             SuperscriptBox["a1", "3"], " ", "p2"}], "-", 
            RowBox[{"9329680", " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"1688060", " ", "h2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5047569", " ", 
             SuperscriptBox["a1", "4"], " ", "p2"}], "-", 
            RowBox[{"17420908", " ", 
             SuperscriptBox["a1", "2"], " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"3059776", " ", "p2", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}], "+", 
            RowBox[{"12810974", " ", "a1", " ", "h2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["a0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "481338"}], " ", 
             SuperscriptBox["a1", "3"], " ", "h2"}], "+", 
            RowBox[{"1519606", " ", "a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"477965", " ", "p2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}]}], "//.", "replasym"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"asymh", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"h2", " ", 
       SuperscriptBox["z", "2"]}], "-", 
      RowBox[{"2", " ", "a0", " ", "p2", " ", 
       SuperscriptBox["z", "3"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"8", " ", 
            SuperscriptBox["a0", "2"], " ", "h2"}], "3"]}], "-", 
         RowBox[{"a1", " ", "p2"}]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", "a0", " ", "a1", " ", "h2"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "3"], " ", "p2"}], "-", 
         RowBox[{"h2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "5"]}], "+", 
      RowBox[{
       FractionBox["1", "120"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"256", " ", 
          SuperscriptBox["a0", "4"], " ", "h2"}], "-", 
         RowBox[{"93", " ", 
          SuperscriptBox["a1", "2"], " ", "h2"}], "+", 
         RowBox[{"480", " ", 
          SuperscriptBox["a0", "2"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{"28", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
         RowBox[{"140", " ", "a0", " ", "p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "+", 
      RowBox[{
       FractionBox["1", "180"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"768", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "h2"}], "-", 
         RowBox[{"256", " ", 
          SuperscriptBox["a0", "5"], " ", "p2"}], "+", 
         RowBox[{"3", " ", "a0", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"139", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"52", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"396", " ", 
          SuperscriptBox["a0", "2"], " ", "h2", " ", "T3"}], "+", 
         RowBox[{"132", " ", "a1", " ", "p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2048"}], " ", 
           SuperscriptBox["a0", "6"], " ", "h2"}], "-", 
          RowBox[{"8960", " ", 
           SuperscriptBox["a0", "4"], " ", "a1", " ", "p2"}], "+", 
          RowBox[{"63", " ", "a1", " ", "p2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"21", " ", 
              SuperscriptBox["a1", "2"]}], "-", 
             RowBox[{"20", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["a0", "2"], " ", "h2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1177"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"586", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"6596", " ", "a0", " ", "a1", " ", "h2", " ", "T3"}], "-", 
          RowBox[{"7168", " ", 
           SuperscriptBox["a0", "3"], " ", "p2", " ", "T3"}], "+", 
          RowBox[{"500", " ", "h2", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "8"]}], "2520"], "+", 
      RowBox[{
       FractionBox["1", "1260"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3072"}], " ", 
          SuperscriptBox["a0", "5"], " ", "a1", " ", "h2"}], "+", 
         RowBox[{"512", " ", 
          SuperscriptBox["a0", "7"], " ", "p2"}], "+", 
         RowBox[{"8", " ", "a0", " ", "a1", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"267", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"325", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"100", " ", 
          SuperscriptBox["a0", "3"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "53"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"36", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"3520", " ", 
          SuperscriptBox["a0", "4"], " ", "h2", " ", "T3"}], "-", 
         RowBox[{"6176", " ", 
          SuperscriptBox["a0", "2"], " ", "a1", " ", "p2", " ", "T3"}], "+", 
         RowBox[{"h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1113", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"334", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "-", 
         RowBox[{"1070", " ", "a0", " ", "p2", " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "9"]}], "+", 
      RowBox[{
       FractionBox["1", "362880"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"65536", " ", 
          SuperscriptBox["a0", "8"], " ", "h2"}], "+", 
         RowBox[{"516096", " ", 
          SuperscriptBox["a0", "6"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["a0", "4"], " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5191"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"4985", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"27", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4459", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"8800", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"1296", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
         RowBox[{"2274304", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "h2", " ", "T3"}], "+", 
         RowBox[{"801792", " ", 
          SuperscriptBox["a0", "5"], " ", "p2", " ", "T3"}], "+", 
         RowBox[{"72", " ", "a0", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "16279"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"6152", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "-", 
         RowBox[{"211104", " ", "a1", " ", "p2", " ", 
          SuperscriptBox["T3", "2"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["a0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"65628", " ", 
             SuperscriptBox["a1", "3"], " ", "p2"}], "-", 
            RowBox[{"106344", " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"42517", " ", "h2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "10"]}], "+", 
      RowBox[{
       FractionBox["1", "907200"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"655360", " ", 
             SuperscriptBox["a0", "6"], " ", "a1", " ", "h2"}], "-", 
            RowBox[{"65536", " ", 
             SuperscriptBox["a0", "8"], " ", "p2"}], "-", 
            RowBox[{"256", " ", 
             SuperscriptBox["a0", "4"], " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "9239"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"12877", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"128", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "24170"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"53921", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "342771"}], " ", 
                SuperscriptBox["a1", "4"]}], "+", 
               RowBox[{"878720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}], "-", 
               RowBox[{"131344", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["h2", "2"], "+", 
                   SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"165760", " ", 
             SuperscriptBox["a0", "6"], " ", "h2"}], "+", 
            RowBox[{"690688", " ", 
             SuperscriptBox["a0", "4"], " ", "a1", " ", "p2"}], "-", 
            RowBox[{"93114", " ", 
             SuperscriptBox["a1", "3"], " ", "p2"}], "+", 
            RowBox[{"88584", " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a0", "2"], " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "696615"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"349432", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "+", 
         RowBox[{"80", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "27384"}], " ", "a1", " ", "h2"}], "+", 
            RowBox[{"31441", " ", 
             SuperscriptBox["a0", "2"], " ", "p2"}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}], "-", 
         RowBox[{"128000", " ", "h2", " ", 
          SuperscriptBox["T3", "3"]}]}], ")"}], " ", 
       SuperscriptBox["z", "11"]}], "+", 
      RowBox[{
       FractionBox["1", "19958400"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "524288"}], " ", 
          SuperscriptBox["a0", "10"], " ", "h2"}], "-", 
         RowBox[{"6488064", " ", 
          SuperscriptBox["a0", "8"], " ", "a1", " ", "p2"}], "-", 
         RowBox[{"2048", " ", 
          SuperscriptBox["a0", "6"], " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "15323"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"31837", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"99", " ", "a1", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"40425", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"137664", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"53104", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "+", 
         RowBox[{"95269888", " ", 
          SuperscriptBox["a0", "5"], " ", "a1", " ", "h2", " ", "T3"}], "-", 
         RowBox[{"16580608", " ", 
          SuperscriptBox["a0", "7"], " ", "p2", " ", "T3"}], "-", 
         RowBox[{"1408", " ", 
          SuperscriptBox["a0", "3"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "112858"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"77229", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "+", 
         RowBox[{"1232", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "14319"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"4438", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["a0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"481338", " ", 
             SuperscriptBox["a1", "3"], " ", "p2"}], "-", 
            RowBox[{"1519606", " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"477965", " ", "h2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", "a0", " ", "T3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "7711461"}], " ", 
             SuperscriptBox["a1", "3"], " ", "h2"}], "+", 
            RowBox[{"9329680", " ", "a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"1688060", " ", "p2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5047569", " ", 
             SuperscriptBox["a1", "4"], " ", "h2"}], "-", 
            RowBox[{"17420908", " ", 
             SuperscriptBox["a1", "2"], " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"3059776", " ", "h2", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}], "-", 
            RowBox[{"12810974", " ", "a1", " ", "p2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}]}], "//.", "replasym"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"asyma", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "+", 
      RowBox[{"a1", " ", "z"}], "+", 
      RowBox[{
       FractionBox["2", "3"], " ", "a0", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["7", "15"], " ", "a1", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "5"]}], "-", 
      RowBox[{
       FractionBox["16", "45"], " ", 
       SuperscriptBox["a0", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "-", 
      RowBox[{
       FractionBox["2", "63"], " ", "a0", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"17", " ", "a0", " ", "a1"}], "+", 
         RowBox[{"10", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "a0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"32", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"101", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"86", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"325", " ", "a1", " ", "T3"}]}], ")"}], " ", 
        SuperscriptBox["z", "8"]}], "1260"], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5600", " ", 
           SuperscriptBox["a0", "4"], " ", "a1"}], "+", 
          RowBox[{"9", " ", "a1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "237"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"496", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"7168", " ", 
           SuperscriptBox["a0", "3"], " ", "T3"}]}], ")"}], " ", 
        SuperscriptBox["z", "9"]}], "22680"], "-", 
      FractionBox[
       RowBox[{"a0", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"256", " ", 
           SuperscriptBox["a0", "6"]}], "+", 
          RowBox[{
           SuperscriptBox["a0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4222"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"5864", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"7723", " ", "a0", " ", "a1", " ", "T3"}], "-", 
          RowBox[{"2740", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "10"]}], "14175"], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a0", "2"], " ", "a1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"19008", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"69085", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"208696", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"32", " ", "a0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"1314", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"3728", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"3063", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
          "-", 
          RowBox[{"52195", " ", "a1", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "11"]}], "311850"], "+", 
      RowBox[{
       FractionBox["1", "7484400"], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16384", " ", 
          SuperscriptBox["a0", "9"]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["a0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "6647"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"18283", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"18", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"40299", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"175246", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"51752", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
         RowBox[{"2703136", " ", 
          SuperscriptBox["a0", "4"], " ", "a1", " ", "T3"}], "+", 
         RowBox[{"63", " ", "a1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15201", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"29176", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "-", 
         RowBox[{"1978000", " ", 
          SuperscriptBox["a0", "3"], " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}]}], "//.", "replasym"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"asymT", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"T3", " ", 
       SuperscriptBox["z", "3"]}], "+", 
      RowBox[{
       FractionBox["1", "12"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["a1", "2"]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["2", "3"], " ", 
       SuperscriptBox["a0", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "+", 
      RowBox[{
       FractionBox["1", "9"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", "a0", " ", "a1"}], "+", "T3"}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"448", " ", 
           SuperscriptBox["a0", "4"]}], "-", 
          RowBox[{"447", " ", 
           SuperscriptBox["a1", "2"]}], "+", 
          RowBox[{"76", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["h2", "2"], "+", 
             SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["z", "8"]}], "1260"], "-", 
      RowBox[{
       FractionBox["4", "45"], " ", 
       SuperscriptBox["a0", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", "a0", " ", "a1"}], "+", 
         RowBox[{"4", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "9"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"576", " ", 
           SuperscriptBox["a0", "6"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["a0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1067"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"662", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"2900", " ", "a0", " ", "a1", " ", "T3"}], "-", 
          RowBox[{"215", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "10"]}], "5670"], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", "a0", " ", "a1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"768", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"849", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"1504", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"12384", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"8367", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"2192", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}]}], 
         ")"}], " ", 
        SuperscriptBox["z", "11"]}], "37800"], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"22528", " ", 
           SuperscriptBox["a0", "8"]}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["a0", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "12981"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"15646", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"9", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"11148", " ", 
              SuperscriptBox["a1", "4"]}], "-", 
             RowBox[{"33831", " ", 
              SuperscriptBox["a1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
             RowBox[{"2908", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["h2", "2"], "+", 
                 SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
          RowBox[{"1016240", " ", 
           SuperscriptBox["a0", "3"], " ", "a1", " ", "T3"}], "-", 
          RowBox[{"270940", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "12"]}], "1247400"]}], "//.", "replasym"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymS", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["h2", "2"]}], "-", 
        SuperscriptBox["p2", "2"]}], ")"}], " ", 
      SuperscriptBox["z", "4"]}], "+", 
     RowBox[{
      FractionBox["1", "9"], " ", 
      SuperscriptBox["a0", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h2", "2"], "+", 
        SuperscriptBox["p2", "2"]}], ")"}], " ", 
      SuperscriptBox["z", "6"]}], "+", 
     RowBox[{
      FractionBox["1", "63"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h2", "2"], "+", 
        SuperscriptBox["p2", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "a0", " ", "a1"}], "+", 
        RowBox[{"5", " ", "T3"}]}], ")"}], " ", 
      SuperscriptBox["z", "7"]}], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"224", " ", 
          SuperscriptBox["a0", "4"]}], "+", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "39"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"74", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "8"]}], "5040"], "-", 
     RowBox[{
      FractionBox["1", "405"], " ", 
      SuperscriptBox["a0", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h2", "2"], "+", 
        SuperscriptBox["p2", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"26", " ", "a0", " ", "a1"}], "+", 
        RowBox[{"37", " ", "T3"}]}], ")"}], " ", 
      SuperscriptBox["z", "9"]}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"576", " ", 
          SuperscriptBox["a0", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["a0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3133"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"4738", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"3340", " ", "a0", " ", "a1", " ", "T3"}], "-", 
         RowBox[{"2875", " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "10"]}], "56700"], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "a0", " ", "a1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"832", " ", 
             SuperscriptBox["a0", "4"]}], "-", 
            RowBox[{"771", " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"2196", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2528", " ", 
             SuperscriptBox["a0", "4"]}], "-", 
            RowBox[{"1309", " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"2684", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}]}], 
        ")"}], " ", 
       SuperscriptBox["z", "11"]}], "138600"], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"22528", " ", 
          SuperscriptBox["a0", "8"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "33238"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"77633", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"27", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2716", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"14037", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"9886", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
         RowBox[{"1322560", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "T3"}], "-", 
         RowBox[{"1103800", " ", 
          SuperscriptBox["a0", "2"], " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}], "14968800"]}], "//.", "replasym"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.537640798221807*^9, 3.5376408063887777`*^9}, {
  3.538462913984427*^9, 3.53846295871097*^9}, {3.538463135071212*^9, 
  3.538463146908863*^9}, {3.538464374794805*^9, 3.538464392634185*^9}, {
  3.5438638049546547`*^9, 3.543863817644617*^9}, {3.5438638714988747`*^9, 
  3.54386390248771*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqlist", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["p", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"p", "[", "z", "]"}], "2"], " ", 
          RowBox[{"S", "[", "z", "]"}], " ", 
          SuperscriptBox[
           RowBox[{"T", "[", "z", "]"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"S", "[", "z", "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["S", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]]}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"a", "[", "z", "]"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"h", "[", "z", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], " ", 
          RowBox[{"S", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"], " ", 
             RowBox[{"S", "[", "z", "]"}], " ", 
             RowBox[{
              SuperscriptBox["p", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], "+", 
            RowBox[{"z", " ", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "2"], " ", 
             RowBox[{"S", "[", "z", "]"}], " ", 
             RowBox[{
              SuperscriptBox["p", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], "-", 
            RowBox[{"4", " ", 
             RowBox[{"p", "[", "z", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"S", "[", "z", "]"}], "-", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["S", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"8", " ", "z", " ", 
          RowBox[{"a", "[", "z", "]"}], " ", 
          RowBox[{"h", "[", "z", "]"}], " ", 
          RowBox[{"T", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{"S", "[", "z", "]"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["p", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"p", "[", "z", "]"}], " ", 
             RowBox[{"S", "[", "z", "]"}], " ", 
             RowBox[{
              SuperscriptBox["p", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"S", "[", "z", "]"}]}], "+", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["S", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox[
                 RowBox[{"S", "[", "z", "]"}], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["p", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                 ")"}]}], "-", 
               RowBox[{"4", " ", "z", " ", 
                RowBox[{"S", "[", "z", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["S", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["z", "2"], " ", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["S", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
              ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"T", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "z", " ", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "4"], " ", 
             SuperscriptBox[
              RowBox[{"S", "[", "z", "]"}], "2"], " ", 
             RowBox[{
              SuperscriptBox["p", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "3"], " ", 
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{"S", "[", "z", "]"}], "2"], " ", 
             RowBox[{"T", "[", "z", "]"}], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["p", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "3"]}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "3"], " ", 
             RowBox[{"S", "[", "z", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"S", "[", "z", "]"}], "-", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["S", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"h", "[", "z", "]"}], "2"], " ", 
                SuperscriptBox[
                 RowBox[{"S", "[", "z", "]"}], "2"], " ", 
                RowBox[{
                 SuperscriptBox["p", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}], "+", 
               RowBox[{"8", " ", "z", " ", 
                RowBox[{"h", "[", "z", "]"}], " ", 
                RowBox[{"S", "[", "z", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["a", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"S", "[", "z", "]"}], "-", 
                  RowBox[{"z", " ", 
                   RowBox[{
                    SuperscriptBox["S", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["p", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"S", "[", "z", "]"}], "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{"12", "-", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"T", "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["p", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"T", "[", "z", "]"}], " ", 
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["S", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{
        RowBox[{"8", " ", 
         RowBox[{"a", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"h", "[", "z", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], " ", 
         RowBox[{"S", "[", "z", "]"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"T", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"S", "[", "z", "]"}], " ", 
        RowBox[{"T", "[", "z", "]"}]}]]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "\[Equal]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"h", "[", "z", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], " ", 
         RowBox[{"S", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"a", "[", "z", "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"h", "[", "z", "]"}], "2"], "+", 
              SuperscriptBox[
               RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"a", "[", "z", "]"}], " ", 
            RowBox[{"h", "[", "z", "]"}], " ", 
            RowBox[{"T", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"T", "[", "z", "]"}], "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}], "2"]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", "z", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"T", "[", "z", "]"}], "2"]}]]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "\[Equal]", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"4", " ", "z", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", "z", "]"}], "2"], " ", 
         RowBox[{"S", "[", "z", "]"}], " ", 
         RowBox[{"T", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"S", "[", "z", "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"a", "[", "z", "]"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"S", "[", "z", "]"}], "2"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"a", "[", "z", "]"}], " ", 
          RowBox[{"h", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"h", "[", "z", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"S", "[", "z", "]"}], "2"], " ", 
          RowBox[{"T", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["p", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "+", 
         RowBox[{
          RowBox[{"T", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "4"], " ", 
             SuperscriptBox[
              RowBox[{"S", "[", "z", "]"}], "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{"S", "[", "z", "]"}], "2"], " ", 
             RowBox[{"T", "[", "z", "]"}], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["p", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox[
                 RowBox[{"S", "[", "z", "]"}], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"4", " ", 
                   SuperscriptBox[
                    RowBox[{"h", "[", "z", "]"}], "2"]}], "-", 
                  RowBox[{
                   SuperscriptBox["z", "4"], " ", 
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                  RowBox[{"2", " ", 
                   RowBox[{"T", "[", "z", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "6"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["p", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                    ")"}]}]}], ")"}]}], "+", 
               RowBox[{"16", " ", "z", " ", 
                RowBox[{"S", "[", "z", "]"}], " ", 
                RowBox[{"T", "[", "z", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["S", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"T", "[", "z", "]"}], " ", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["S", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
              ")"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"a", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"h", "[", "z", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{"T", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], 
       RowBox[{
        RowBox[{"p", "[", "z", "]"}], " ", 
        RowBox[{"T", "[", "z", "]"}]}]]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.53804704493528*^9, 3.538047048094969*^9}, 
   3.538047118025202*^9, 3.538118653167184*^9, {3.5384641317446833`*^9, 
   3.538464140783781*^9}, {3.543863826974758*^9, 3.5438638283529997`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerics", "Subsubtitle",
 CellChangeTimes->{{3.538463013798025*^9, 3.5384630213987093`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"inteq", ",", "zhoriz", ",", "eps"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"inteq", "[", 
    RowBox[{
    "z0in_Real", ",", "horizp0in_Real", ",", "horiza1in_Real", ",", 
     "horizt1in_Real", ",", "horizs0in_Real", ",", "asymp2in_Real", ",", 
     "asymh2in_Real", ",", "asyma0in_Real", ",", "asyma1in_Real", ",", 
     "asymT3in_Real", ",", "output_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"z0", "=", "z0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizp0", "=", "horizp0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizh0", "=", "0"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horiza1", "=", "horiza1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizt1", "=", "horizt1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizs0", "=", "horizs0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymp2", "=", "asymp2in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymh2", "=", "asymh2in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asyma0", "=", "asyma0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asyma1", "=", "asyma1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymT3", "=", "asymT3in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"eps", "=", "0.01"}], " ", ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"eps2", "=", "0.001"}], " ", ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zmid", " ", "=", " ", "0.4"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zhoriz", "=", 
      RowBox[{"1", "-", "eps2"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"nsol1", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"eqlist", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"p", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymp", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asymp", "'"}], "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"h", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymh", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"a", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asyma", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asyma", "'"}], "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"T", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymT", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"S", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymS", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asymS", "'"}], "[", "eps", "]"}]}]}], "}"}]}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "eps", ",", "zhoriz"}], "}"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zcut1", "=", 
      RowBox[{"nsol1", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "2"}], "]"}], "]"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"zcut1", "<", "zmid"}], ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Error 1 \>\"", ",", "zcut2"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"nsol2", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"eqlist", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"p", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizp", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horizp", "'"}], "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"h", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizh", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"a", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horiza", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horiza", "'"}], "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"T", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizT", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"S", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizS", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horizS", "'"}], "[", "zhoriz", "]"}]}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "eps", ",", "zhoriz"}], "}"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zcut2", "=", 
      RowBox[{"nsol2", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "1"}], "]"}], "]"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"zcut2", ">", "zmid"}], ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Error 2 \>\"", ",", "zcut2"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", 
      RowBox[{
      "horizp0", ",", "horizh0", ",", "horiza1", ",", "horizt1", ",", 
       "horizs0", ",", "asymp2", ",", "asymh2", ",", "asyma0", ",", "asyma1", 
       ",", "asymT3"}], "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Return", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"h", "'"}], "[", "eps", "]"}], ",", 
             RowBox[{
              RowBox[{"T", "'"}], "[", "eps", "]"}]}], "}"}], "/.", "nsol2"}],
           "]"}], ";"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"htab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"h", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Ttab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"T", "[", "z", "]"}], "-", "1"}], "/.", "nsol2"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Coefficient", "[", 
            RowBox[{"hfit", ",", "z"}], "]"}], ",", 
           RowBox[{"Coefficient", "[", 
            RowBox[{"Tfit", ",", "z"}], "]"}]}], "}"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "2"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"T", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"T", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"S", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"S", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"dlist", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"Join", "[", 
          RowBox[{"list", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"dlist", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"dlist", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"dlist", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}], "]"}], 
        ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ptab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"p", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"htab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"h", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"atab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"a", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Ttab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"T", "[", "z", "]"}], "-", "1"}], "/.", "nsol2"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Stab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"S", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"pfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"ptab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"afit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"atab", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "z"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}], ",", 
             RowBox[{"z", "^", "3"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Sfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Stab", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "z"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"pfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"ptab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "2"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "2"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "3"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"pf", "==", "pfit"}], ",", 
             RowBox[{"hf", "\[Equal]", "hfit"}], ",", 
             RowBox[{"af", "\[Equal]", "afit"}], ",", 
             RowBox[{"Tf", "\[Equal]", "Tfit"}], ",", 
             RowBox[{"Sf", "\[Equal]", "Sfit"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pfit2", ",", "hfit2", ",", "Tfit2"}], "}"}]}], "}"}], 
         "]"}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], 
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.5376407771099586`*^9, 3.53764077742128*^9}, {
   3.537640849432414*^9, 3.537641029700471*^9}, {3.537641083186082*^9, 
   3.5376410832815037`*^9}, {3.537641227496984*^9, 3.537641241071927*^9}, {
   3.537641278231781*^9, 3.53764129200132*^9}, {3.537811594660029*^9, 
   3.537811661635552*^9}, 3.537811712330718*^9, {3.537812313668707*^9, 
   3.537812329718534*^9}, {3.537812368025175*^9, 3.537812466952651*^9}, {
   3.537812574550178*^9, 3.53781262207281*^9}, {3.537855902100842*^9, 
   3.537855910975484*^9}, {3.537863637889791*^9, 3.537863642968212*^9}, {
   3.53786405512639*^9, 3.5378640577014513`*^9}, {3.5378642740193357`*^9, 
   3.5378642823266706`*^9}, {3.537864945886372*^9, 3.537864949610241*^9}, {
   3.537865324468916*^9, 3.5378653414829493`*^9}, {3.537865422417637*^9, 
   3.537865426010881*^9}, {3.537865668894218*^9, 3.5378656720161123`*^9}, {
   3.537866060689427*^9, 3.537866086110963*^9}, {3.537866821965849*^9, 
   3.537866824468356*^9}, {3.537866935754058*^9, 3.5378669532770844`*^9}, {
   3.537867277477654*^9, 3.537867283864683*^9}, {3.5378673736645327`*^9, 
   3.53786741047612*^9}, {3.537867724358015*^9, 3.537867770909184*^9}, {
   3.537867812374217*^9, 3.537867814824875*^9}, {3.537867862682262*^9, 
   3.537867863608501*^9}, {3.537867935345325*^9, 3.537867952471974*^9}, {
   3.537867984898217*^9, 3.5378679871300287`*^9}, {3.537870400150711*^9, 
   3.537870402077724*^9}, {3.537870448958918*^9, 3.5378704524785967`*^9}, {
   3.537870930220189*^9, 3.537870930900414*^9}, 3.537871139674671*^9, {
   3.537871192589308*^9, 3.53787120155658*^9}, {3.537871653378598*^9, 
   3.5378716648098917`*^9}, {3.537871703252593*^9, 3.537871787942024*^9}, {
   3.537871824557847*^9, 3.537871910740779*^9}, {3.537871941253039*^9, 
   3.5378719525649443`*^9}, {3.537871994498852*^9, 3.537872049059258*^9}, {
   3.537872138421897*^9, 3.537872144006673*^9}, {3.537872196836445*^9, 
   3.53787224947705*^9}, {3.5378722878468122`*^9, 3.537872372883222*^9}, {
   3.537872490150178*^9, 3.537872496093255*^9}, {3.537872547385435*^9, 
   3.537872561998753*^9}, {3.537872800792879*^9, 3.5378728967451353`*^9}, {
   3.537872969967389*^9, 3.537872993322166*^9}, {3.5378733845638*^9, 
   3.537873523491342*^9}, {3.537874990501849*^9, 3.5378750749448233`*^9}, {
   3.538046326178605*^9, 3.5380463263452587`*^9}, {3.538046359506956*^9, 
   3.5380464610359497`*^9}, {3.538046502103581*^9, 3.538046513481264*^9}, {
   3.53804657410702*^9, 3.538046614577108*^9}, {3.53804665505602*^9, 
   3.538046715360199*^9}, {3.538046757351519*^9, 3.53804676998315*^9}, {
   3.5380468595384607`*^9, 3.5380468659616413`*^9}, {3.538046897437215*^9, 
   3.538046897572302*^9}, {3.538047066640044*^9, 3.538047074544244*^9}, {
   3.538047229999874*^9, 3.5380472836305647`*^9}, {3.538047353035921*^9, 
   3.538047363818179*^9}, {3.538047476249525*^9, 3.538047522111104*^9}, {
   3.5380475966181917`*^9, 3.5380475967702713`*^9}, {3.538047801532692*^9, 
   3.538047822201064*^9}, {3.538047948516816*^9, 3.538047948684765*^9}, {
   3.538114366350466*^9, 3.5381144299925222`*^9}, {3.538114576757052*^9, 
   3.5381146749454412`*^9}, {3.538114791107875*^9, 3.5381148266944447`*^9}, {
   3.538114878968347*^9, 3.538115127215603*^9}, {3.53811552595366*^9, 
   3.538115590252236*^9}, {3.5381156363832006`*^9, 3.538115704042387*^9}, {
   3.53811589099817*^9, 3.53811590783984*^9}, {3.538115999280501*^9, 
   3.5381160364460382`*^9}, 3.538116068499432*^9, {3.5381163172614202`*^9, 
   3.5381163185592117`*^9}, 3.538116587083933*^9, {3.538116795975728*^9, 
   3.5381167961435547`*^9}, {3.538116915101754*^9, 3.538116916845715*^9}, {
   3.538117082639504*^9, 3.5381170838467207`*^9}, {3.538117120446578*^9, 
   3.538117121605109*^9}, {3.538117912630061*^9, 3.5381179255489893`*^9}, {
   3.538118168821506*^9, 3.538118170682723*^9}, {3.5381182778513527`*^9, 
   3.538118288943109*^9}, {3.5381183580154047`*^9, 3.5381183581193533`*^9}, {
   3.538118848337666*^9, 3.538118920486744*^9}, {3.538119184188271*^9, 
   3.53811918440349*^9}, {3.5381193489118156`*^9, 3.538119350612996*^9}, {
   3.538119892508926*^9, 3.538119895751055*^9}, {3.538119927591441*^9, 
   3.538119936248074*^9}, {3.538120029047421*^9, 3.538120037965654*^9}, {
   3.538120194027095*^9, 3.538120201471917*^9}, {3.53812028017563*^9, 
   3.538120301265314*^9}, {3.5381381252717533`*^9, 3.538138126469459*^9}, {
   3.538328246372367*^9, 3.5383282504354353`*^9}, {3.5383283005077343`*^9, 
   3.538328335488717*^9}, {3.538329001230315*^9, 3.538329010372521*^9}, {
   3.5383292041149054`*^9, 3.538329214953123*^9}, {3.5383314262207823`*^9, 
   3.538331427882743*^9}, {3.543859340083334*^9, 3.543859341979192*^9}}],

Cell[BoxData["\"\<inteq[z0,horizp0,horiza1,horizt1,horizs0,asymp2,asymh2,\
asyma0,asyma1,asymT3,output_]\>\""], "Input",
 CellChangeTimes->{{3.5383293550725*^9, 3.538329380846671*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{"q", 
    RowBox[{"(", 
     RowBox[{"1", "-", "z"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       FractionBox[
        SuperscriptBox["q", "2"], "4"]}], ")"}], " ", 
     RowBox[{"z", "^", "3"}]}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"q", "^", "2"}], "4"], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", "z_", "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.538329462610435*^9, 3.53832946748561*^9}, {
  3.538329521299446*^9, 3.5383295310616198`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"-", 
    RowBox[{
     RowBox[{"a", "'"}], "[", "1", "]"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"-", 
   RowBox[{
    RowBox[{"T", "'"}], "[", "1", "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.538329559252846*^9, 3.53832957654383*^9}, {
  3.5383316175594177`*^9, 3.53833162076753*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"a", ",", "T", ",", "S"}], "]"}]], "Input",
 CellChangeTimes->{{3.538329687225774*^9, 3.538329690184968*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"inteq", "[", 
    RowBox[{"1.", ",", "0.0001", ",", "q", ",", 
     RowBox[{"3.", "-", 
      FractionBox[
       SuperscriptBox["q", "2"], "4"]}], ",", "1.", ",", "0.0001", ",", 
     "0.0001", ",", "q", ",", 
     RowBox[{"-", "q"}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"1.", "+", 
        FractionBox[
         SuperscriptBox["q", "2"], "4"]}], ")"}]}], ",", "2"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", "0.3"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5383294791064587`*^9, 3.538329480386127*^9}, {
  3.538329552120495*^9, 3.538329698586186*^9}, {3.538331199106153*^9, 
  3.538331232043847*^9}, {3.538331650792227*^9, 3.538331661359701*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"T", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"T", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5383316585937967`*^9, 3.538331734439353*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", "0.3"}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"solx", "=", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"inteq", "[", 
      RowBox[{
      "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", 
       ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", "0.001"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", "3."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x3", ",", "1."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x4", ",", "0.001"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x5", ",", "0.001"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x6", ",", "q"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x7", ",", 
       RowBox[{"-", "q"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x8", ",", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"1.", "+", 
          FractionBox[
           SuperscriptBox["q", "2"], "4"]}], ")"}]}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inteq", "[", 
   RowBox[{
   "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", ",",
     "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", "solx"}]}], "Input",
 CellChangeTimes->{{3.538332379828829*^9, 3.538332479861409*^9}, {
  3.538332516308981*^9, 3.5383325571714373`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", "0.3427"}], ";"}]], "Input",
 CellChangeTimes->{{3.538331888911525*^9, 3.538331890488124*^9}, {
  3.5383332721236134`*^9, 3.538333358209091*^9}, {3.538372556610911*^9, 
  3.538372684298564*^9}, {3.538372774294757*^9, 3.5383727935021143`*^9}, {
  3.538380435266081*^9, 3.5383804358499737`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"{", 
    RowBox[{"0.000001", ",", 
     RowBox[{"3.", "-", 
      FractionBox[
       SuperscriptBox["q", "2"], "4"]}], ",", "1.", ",", "0.000001", ",", 
     "0.000001", ",", "q", ",", 
     RowBox[{"-", "q"}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"1.", "+", 
        FractionBox[
         SuperscriptBox["q", "2"], "4"]}], ")"}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.5381366020899467`*^9, {3.538328422257468*^9, 3.5383284518318768`*^9}, 
   3.538328887038381*^9, {3.538331754993125*^9, 3.5383317597446136`*^9}, {
   3.538331893617297*^9, 3.538331896097275*^9}, {3.538331961393141*^9, 
   3.538331965384636*^9}, {3.538380438091875*^9, 3.538380445343212*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq0", "=", 
    RowBox[{"inteq", "[", 
     RowBox[{"1.", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "3", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "4", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "5", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "6", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "7", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DX", " ", "=", " ", "0.0001"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"vec0", "=", "vec"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "-=", "DX"}], " ", ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"eq1", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"1.", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "+=", 
       RowBox[{"2", "*", "DX"}]}], " ", ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"eq2", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"1.", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"mat", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"eq2", "-", "eq1"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "DX"}], ")"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "8"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<det = \>\"", ",", 
     RowBox[{"Det", "[", "mat", "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dvec", "=", 
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{"Transpose", "[", "mat", "]"}], "]"}], ".", "eq0"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vec", " ", "=", " ", 
    RowBox[{"vec", "-", "dvec"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<vec = \>\"", ",", "vec", ",", "\"\<  ->  eq = \>\"", ",", "eq0"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.538120490121634*^9, 3.538120518932563*^9}, {
   3.5381205558741503`*^9, 3.538120610837431*^9}, {3.5381206659362717`*^9, 
   3.538120712255209*^9}, {3.5383285846229553`*^9, 3.538328585388818*^9}, {
   3.538328684844769*^9, 3.5383286852597733`*^9}, 3.538328770081517*^9, {
   3.5383289405611877`*^9, 3.5383289561436033`*^9}, {3.538329024216524*^9, 
   3.538329027272518*^9}, {3.538329231307086*^9, 3.538329245530115*^9}, {
   3.53832928014611*^9, 3.5383292802257977`*^9}, {3.538331899292232*^9, 
   3.538331918317177*^9}, {3.5383320080930357`*^9, 3.53833201029294*^9}, {
   3.5383320534615726`*^9, 3.538332054173419*^9}, {3.538332091130785*^9, 
   3.538332091290278*^9}, {3.538332148467001*^9, 3.538332166530912*^9}, {
   3.538332763655594*^9, 3.538332763839275*^9}, 3.538332811566271*^9, {
   3.5383329603107758`*^9, 3.538333014609095*^9}, {3.538372704879333*^9, 
   3.538372748091798*^9}, {3.538380094711239*^9, 3.538380095245941*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "q", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"matlist", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"vec", "=", 
       RowBox[{"{", 
        RowBox[{"0.0000000000001", ",", 
         RowBox[{"3.", "-", 
          FractionBox[
           SuperscriptBox["q", "2"], "4"]}], ",", "1.", ",", 
         "0.0000000000001", ",", "0.0000000000001", ",", "q", ",", 
         RowBox[{"-", "q"}], ",", 
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"1.", "+", 
            FractionBox[
             SuperscriptBox["q", "2"], "4"]}], ")"}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"mat", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"eq0", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"1.", ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"DX", " ", "=", " ", "0.000001"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"vec0", "=", "vec"}], ";", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"vec0", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], "-=", "DX"}], " ", ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"eq1", "=", 
          RowBox[{"inteq", "[", 
           RowBox[{"1.", ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "3", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "4", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "5", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "6", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "7", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"vec0", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], "+=", 
          RowBox[{"2", "*", "DX"}]}], " ", ";", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{"eq2", "=", 
          RowBox[{"inteq", "[", 
           RowBox[{"1.", ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "3", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "4", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "5", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "6", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "7", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"mat", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"eq2", "-", "eq1"}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"2", "*", "DX"}], ")"}]}]}], "]"}], ";"}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "8"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"tmp", "=", 
       RowBox[{"Eigenvalues", "[", "mat", "]"}]}], ";", "\[IndentingNewLine]",
       "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<q = \>\"", ",", "q", ",", "\"\<\\n\\n    evals = \>\"", ",", 
        RowBox[{"Sort", "[", 
         RowBox[{"Abs", "[", "tmp", "]"}], "]"}], ",", "\"\<\\n\\n\>\""}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"matlist", ",", 
        RowBox[{"{", 
         RowBox[{"q", ",", 
          RowBox[{"Eigenvalues", "[", "mat", "]"}]}], "}"}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "0.1", ",", "3.3", ",", "0.1"}], "}"}]}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "q", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.538120490121634*^9, 3.538120518932563*^9}, {
   3.5381205558741503`*^9, 3.538120610837431*^9}, {3.5381206659362717`*^9, 
   3.538120712255209*^9}, {3.5383285846229553`*^9, 3.538328585388818*^9}, {
   3.538328684844769*^9, 3.5383286852597733`*^9}, 3.538328770081517*^9, {
   3.5383289405611877`*^9, 3.5383289561436033`*^9}, {3.538329024216524*^9, 
   3.538329027272518*^9}, {3.538329231307086*^9, 3.538329245530115*^9}, {
   3.53832928014611*^9, 3.5383292802257977`*^9}, {3.538331899292232*^9, 
   3.538331918317177*^9}, {3.5383320080930357`*^9, 3.53833201029294*^9}, {
   3.5383320534615726`*^9, 3.538332054173419*^9}, {3.538332091130785*^9, 
   3.538332091290278*^9}, {3.538332148467001*^9, 3.538332166530912*^9}, {
   3.538332763655594*^9, 3.538332763839275*^9}, 3.538332811566271*^9, {
   3.5383329603107758`*^9, 3.538333014609095*^9}, {3.538372704879333*^9, 
   3.538372748091798*^9}, {3.538380094711239*^9, 3.538380301811192*^9}, {
   3.538380346386833*^9, 3.53838035277041*^9}, {3.5383804228339043`*^9, 
   3.538380465316924*^9}, {3.5383805155001173`*^9, 3.538380517170929*^9}, {
   3.538394417410356*^9, 3.5383944338261538`*^9}, {3.538394492189281*^9, 
   3.538394500156169*^9}, {3.538394576260153*^9, 3.538394585499764*^9}, {
   3.538464511316242*^9, 3.538464545454879*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", "1.86"}], ";"}]], "Input",
 CellChangeTimes->{{3.538331888911525*^9, 3.538331890488124*^9}, {
  3.5383332721236134`*^9, 3.538333358209091*^9}, {3.538372556610911*^9, 
  3.538372684298564*^9}, {3.538372774294757*^9, 3.5383727935021143`*^9}, {
  3.538380435266081*^9, 3.5383804358499737`*^9}, {3.538394561420013*^9, 
  3.538394565754445*^9}, {3.538394711436935*^9, 3.538394712492588*^9}, {
  3.5438641485138273`*^9, 3.54386423873822*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"{", 
    RowBox[{"0.0000000000001", ",", 
     RowBox[{"3.", "-", 
      FractionBox[
       SuperscriptBox["q", "2"], "4"]}], ",", "1.", ",", "0.0000000000001", 
     ",", "0.0000000000001", ",", "q", ",", 
     RowBox[{"-", "q"}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"1.", "+", 
        FractionBox[
         SuperscriptBox["q", "2"], "4"]}], ")"}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.5381366020899467`*^9, {3.538328422257468*^9, 3.5383284518318768`*^9}, 
   3.538328887038381*^9, {3.538331754993125*^9, 3.5383317597446136`*^9}, {
   3.538331893617297*^9, 3.538331896097275*^9}, {3.538331961393141*^9, 
   3.538331965384636*^9}, {3.538380438091875*^9, 3.538380445343212*^9}, 
   3.5383946710003633`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq0", "=", 
    RowBox[{"inteq", "[", 
     RowBox[{"1.", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "3", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "4", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "5", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "6", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "7", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DX", " ", "=", " ", "0.000001"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"vec0", "=", "vec"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "-=", "DX"}], " ", ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"eq1", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"1.", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "+=", 
       RowBox[{"2", "*", "DX"}]}], " ", ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"eq2", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"1.", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"mat", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"eq2", "-", "eq1"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "DX"}], ")"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "8"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<det = \>\"", ",", 
     RowBox[{"Det", "[", "mat", "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dvec", "=", 
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{"Transpose", "[", "mat", "]"}], "]"}], ".", "eq0"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vec", " ", "=", " ", 
    RowBox[{"vec", "-", "dvec"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<vec = \>\"", ",", "vec", ",", "\"\<  ->  eq = \>\"", ",", "eq0"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.538120490121634*^9, 3.538120518932563*^9}, {
   3.5381205558741503`*^9, 3.538120610837431*^9}, {3.5381206659362717`*^9, 
   3.538120712255209*^9}, {3.5383285846229553`*^9, 3.538328585388818*^9}, {
   3.538328684844769*^9, 3.5383286852597733`*^9}, 3.538328770081517*^9, {
   3.5383289405611877`*^9, 3.5383289561436033`*^9}, {3.538329024216524*^9, 
   3.538329027272518*^9}, {3.538329231307086*^9, 3.538329245530115*^9}, {
   3.53832928014611*^9, 3.5383292802257977`*^9}, {3.538331899292232*^9, 
   3.538331918317177*^9}, {3.5383320080930357`*^9, 3.53833201029294*^9}, {
   3.5383320534615726`*^9, 3.538332054173419*^9}, {3.538332091130785*^9, 
   3.538332091290278*^9}, {3.538332148467001*^9, 3.538332166530912*^9}, {
   3.538332763655594*^9, 3.538332763839275*^9}, 3.538332811566271*^9, {
   3.5383329603107758`*^9, 3.538333014609095*^9}, {3.538372704879333*^9, 
   3.538372748091798*^9}, {3.538380094711239*^9, 3.538380095245941*^9}, {
   3.538394672675757*^9, 3.538394672818479*^9}}],

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "mat", "]"}]], "Input",
 CellChangeTimes->{{3.538394632584487*^9, 3.538394636242876*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigensystem", "[", "mat", "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.5383947953079863`*^9, 3.538394802096307*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigensystem", "[", "mat", "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.538394806318841*^9, 3.538394810078865*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"evec", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8387438991397353`"}], ",", 
     RowBox[{"-", "0.5048338557576975`"}], ",", "4.802249822056543`*^-6", ",",
      "6.527743542629014`*^-9", ",", 
     RowBox[{"-", "1.130064259699803`*^-10"}], ",", "0.20408686726757524`", 
     ",", 
     RowBox[{"-", "1.9207896688472736`*^-6"}], ",", 
     "0.00001785625746224001`"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5383948180312023`*^9, 3.538394843959775*^9}, {
   3.538467289519421*^9, 3.5384672925812597`*^9}, 3.543864278492502*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", ".", "evec"}], "/", "evec"}]], "Input",
 CellChangeTimes->{{3.538394822310273*^9, 3.5383948269747343`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "\"\<inteq[z0,horizp0,horiza1,horizt1,horizs0,asymp2,asymh2,asyma0,asyma1,\
asymT3,output_]\>\"", ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"\"\<inteq[1.,vec[[1]],q,vec[[2]],vec[[3]],vec[[4]],vec[[5]],vec[[6]]\
,vec[[7]],vec[[8]],2]\>\"", ";"}]}], "Input",
 CellChangeTimes->{{3.5383948714318027`*^9, 3.538394893951269*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"evec", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.839"}], ",", 
     RowBox[{"-", "0.505"}], ",", "0.", ",", "0.", ",", "0.", ",", "0.204", 
     ",", "0.", ",", "0."}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.543864309227271*^9, 3.543864344155504*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", "1.868"}], ";"}]], "Input",
 CellChangeTimes->{{3.538331888911525*^9, 3.538331890488124*^9}, {
  3.5383332721236134`*^9, 3.538333358209091*^9}, {3.538372556610911*^9, 
  3.538372684298564*^9}, {3.538372774294757*^9, 3.5383727935021143`*^9}, {
  3.538380435266081*^9, 3.5383804358499737`*^9}, {3.538394561420013*^9, 
  3.538394565754445*^9}, {3.538394711436935*^9, 3.538394712492588*^9}, {
  3.538395089032036*^9, 3.538395092535534*^9}, {3.5383951245277033`*^9, 
  3.5383951282713623`*^9}, {3.538395211807301*^9, 3.538395211902952*^9}, {
  3.538395388596758*^9, 3.538395440076084*^9}, {3.5438643501473217`*^9, 
  3.5438643502028913`*^9}, {3.5438646725522842`*^9, 3.5438646748080273`*^9}, {
  3.543864720662712*^9, 3.543864763431411*^9}, {3.543864801742606*^9, 
  3.543864876032649*^9}}],

Cell[BoxData[
 RowBox[{"vec", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.0000000000001", ",", 
     RowBox[{"3.", "-", 
      FractionBox[
       SuperscriptBox["q", "2"], "4"]}], ",", "1.", ",", "0.0000000000001", 
     ",", "0.0000000000001", ",", "q", ",", 
     RowBox[{"-", "q"}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"1.", "+", 
        FractionBox[
         SuperscriptBox["q", "2"], "4"]}], ")"}]}]}], "}"}], "-", 
   RowBox[{"0.2", "*", "evec"}]}]}]], "Input",
 CellChangeTimes->{
  3.5381366020899467`*^9, {3.538328422257468*^9, 3.5383284518318768`*^9}, 
   3.538328887038381*^9, {3.538331754993125*^9, 3.5383317597446136`*^9}, {
   3.538331893617297*^9, 3.538331896097275*^9}, {3.538331961393141*^9, 
   3.538331965384636*^9}, {3.538380438091875*^9, 3.538380445343212*^9}, 
   3.5383946710003633`*^9, {3.538395044041169*^9, 3.538395050152924*^9}, 
   3.538395130768721*^9, 3.538395162688527*^9, {3.538395256440628*^9, 
   3.538395297883622*^9}, {3.538395364429879*^9, 3.53839537602993*^9}, 
   3.543864401543051*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq0", "=", 
    RowBox[{"inteq", "[", 
     RowBox[{"1.", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "3", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "4", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "5", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "6", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "7", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DX", " ", "=", " ", "0.000001"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"vec0", "=", "vec"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "-=", "DX"}], " ", ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"eq1", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"1.", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "+=", 
       RowBox[{"2", "*", "DX"}]}], " ", ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"eq2", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"1.", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"mat", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"eq2", "-", "eq1"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "DX"}], ")"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "8"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<det = \>\"", ",", 
     RowBox[{"Det", "[", "mat", "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dvec", "=", 
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{"Transpose", "[", "mat", "]"}], "]"}], ".", "eq0"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vec", " ", "=", " ", 
    RowBox[{"vec", "-", "dvec"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<vec = \>\"", ",", "vec", ",", "\"\<  ->  eq = \>\"", ",", "eq0"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.538120490121634*^9, 3.538120518932563*^9}, {
   3.5381205558741503`*^9, 3.538120610837431*^9}, {3.5381206659362717`*^9, 
   3.538120712255209*^9}, {3.5383285846229553`*^9, 3.538328585388818*^9}, {
   3.538328684844769*^9, 3.5383286852597733`*^9}, 3.538328770081517*^9, {
   3.5383289405611877`*^9, 3.5383289561436033`*^9}, {3.538329024216524*^9, 
   3.538329027272518*^9}, {3.538329231307086*^9, 3.538329245530115*^9}, {
   3.53832928014611*^9, 3.5383292802257977`*^9}, {3.538331899292232*^9, 
   3.538331918317177*^9}, {3.5383320080930357`*^9, 3.53833201029294*^9}, {
   3.5383320534615726`*^9, 3.538332054173419*^9}, {3.538332091130785*^9, 
   3.538332091290278*^9}, {3.538332148467001*^9, 3.538332166530912*^9}, {
   3.538332763655594*^9, 3.538332763839275*^9}, 3.538332811566271*^9, {
   3.5383329603107758`*^9, 3.538333014609095*^9}, {3.538372704879333*^9, 
   3.538372748091798*^9}, {3.538380094711239*^9, 3.538380095245941*^9}, {
   3.538394672675757*^9, 3.538394672818479*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"{", 
    RowBox[{
    "0.07409605575656962`", ",", "2.1201685519886437`", ",", 
     "0.9979641465618678`", ",", 
     RowBox[{"-", "0.13206619702576264`"}], ",", "0.10968030666158247`", ",", 
     "1.8798507183298143`", ",", 
     RowBox[{"-", "1.8883455742059834`"}], ",", 
     RowBox[{"-", "1.8849422182089117`"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538395488974235*^9, 3.538395494671344*^9}, 
   3.543864910514452*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", "1.868"}], ";"}]], "Input",
 CellChangeTimes->{3.543864920913033*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nsol", "=", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"inteq", "[", 
      RowBox[{
      "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", 
       ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x3", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x4", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x5", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x6", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "6", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x7", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "7", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x8", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "8", "]"}], "]"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"inteq", "[", 
     RowBox[{
     "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", 
      ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", "nsol"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5383955289097357`*^9, 3.538395607280014*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"p", "[", "z", "]"}], "^", "2"}], "+", 
          RowBox[{
           RowBox[{"h", "[", "z", "]"}], "^", "2"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"p", "[", "z", "]"}], "^", "2"}], "+", 
          RowBox[{
           RowBox[{"h", "[", "z", "]"}], "^", "2"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.538395735376672*^9, 3.53839575583502*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"p", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"p", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.538395645101112*^9, 3.5383956470443773`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"h", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"h", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.538395660340578*^9, 3.538395661228434*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"T", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"T", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5383956126740437`*^9, 3.538395637955501*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.53839567437263*^9, 3.538395675044032*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"S", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"S", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5383956807250023`*^9, 3.538395683147913*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Interp", "[", 
    RowBox[{"val_", ",", "x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Return", "[", 
      RowBox[{
       RowBox[{"Interpolation", "[", 
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "]"}], "]"}], "[", "val", "]"}], 
      "]"}], ";"}], "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.543862196234021*^9, 3.543862204133967*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vec", "=", 
    RowBox[{"{", 
     RowBox[{
     "0.07409605575656962`", ",", "2.1201685519886437`", ",", 
      "0.9979641465618678`", ",", 
      RowBox[{"-", "0.13206619702576264`"}], ",", "0.10968030666158247`", ",",
       "1.8798507183298143`", ",", 
      RowBox[{"-", "1.8883455742059834`"}], ",", 
      RowBox[{"-", "1.8849422182089117`"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"veclist", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "veclist", "]"}], ">", "3"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"vec", "=", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Interp", "[", 
             RowBox[{"q", ",", 
              RowBox[{"veclist", "[", 
               RowBox[{"[", 
                RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
              RowBox[{"veclist", "[", 
               RowBox[{"[", 
                RowBox[{"All", ",", "2", ",", "ii"}], "]"}], "]"}]}], "]"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{"ii", ",", "1", ",", "8"}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<   Interp -> \>\"", ",", "vec"}], "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"nsol", "=", 
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{"inteq", "[", 
          RowBox[{
          "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", 
           "x5", ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x1", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x2", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x3", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x4", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x5", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x6", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x7", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x8", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"tmp", "=", 
       RowBox[{
        RowBox[{"inteq", "[", 
         RowBox[{
         "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", 
          "x5", ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", 
        "nsol"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Norm", "[", "tmp", "]"}], "<", 
         RowBox[{"10", "^", 
          RowBox[{"-", "8"}]}]}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"vec", "=", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5", ",", "x6", ",", 
             "x7", ",", "x8"}], "}"}], "/.", "nsol"}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<q = \>\"", ",", "q", ",", "\"\< -> \>\"", ",", 
           RowBox[{"Norm", "[", "tmp", "]"}], ",", "\"\<\\n   \>\"", ",", 
           "vec", ",", "\"\<\\n\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"veclist", ",", 
           RowBox[{"{", 
            RowBox[{"q", ",", "vec"}], "}"}]}], "]"}], ";"}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Print", "[", "\"\<Done\>\"", "]"}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"q", " ", "=", " ", "10."}], " ", ";"}]}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "1.868", ",", "\[InvisibleSpace]", "1.874", ",", 
       RowBox[{"+", "0.001"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "veclist"}], "Input",
 CellChangeTimes->{{3.5383955289097357`*^9, 3.538395607280014*^9}, {
   3.5383960750003557`*^9, 3.538396215074095*^9}, {3.538396289910667*^9, 
   3.5383963203716497`*^9}, {3.538396509259591*^9, 3.5383965728440866`*^9}, {
   3.5383966941917267`*^9, 3.538396697847146*^9}, 3.538396737895993*^9, {
   3.53839744436998*^9, 3.538397450144785*^9}, {3.543859011482007*^9, 
   3.543859019853387*^9}, {3.54385943160946*^9, 3.543859434520225*^9}, {
   3.5438594682683983`*^9, 3.543859468412384*^9}, {3.543859512900823*^9, 
   3.543859525812529*^9}, {3.5438619583810987`*^9, 3.5438620011365232`*^9}, {
   3.5438620782478237`*^9, 3.543862119990341*^9}, {3.543862209076723*^9, 
   3.543862253163559*^9}, {3.543862399753991*^9, 3.543862402105969*^9}, {
   3.543864951450734*^9, 3.543864980108522*^9}, {3.5438650166185627`*^9, 
   3.54386504319676*^9}, {3.543865131587582*^9, 3.5438651452592287`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vec", "=", 
    RowBox[{"{", 
     RowBox[{
     "0.07409605575656962`", ",", "2.1201685519886437`", ",", 
      "0.9979641465618678`", ",", 
      RowBox[{"-", "0.13206619702576264`"}], ",", "0.10968030666158247`", ",",
       "1.8798507183298143`", ",", 
      RowBox[{"-", "1.8883455742059834`"}], ",", 
      RowBox[{"-", "1.8849422182089117`"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"veclist", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "veclist", "]"}], ">", "3"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"vec", "=", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Interp", "[", 
             RowBox[{"q", ",", 
              RowBox[{"veclist", "[", 
               RowBox[{"[", 
                RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
              RowBox[{"veclist", "[", 
               RowBox[{"[", 
                RowBox[{"All", ",", "2", ",", "ii"}], "]"}], "]"}]}], "]"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{"ii", ",", "1", ",", "8"}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<   Interp -> \>\"", ",", "vec"}], "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"nsol", "=", 
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{"inteq", "[", 
          RowBox[{
          "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", 
           "x5", ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x1", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x2", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x3", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x4", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x5", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x6", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x7", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x8", ",", 
           RowBox[{"vec", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"tmp", "=", 
       RowBox[{
        RowBox[{"inteq", "[", 
         RowBox[{
         "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", 
          "x5", ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", 
        "nsol"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Norm", "[", "tmp", "]"}], "<", 
         RowBox[{"10", "^", 
          RowBox[{"-", "8"}]}]}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"vec", "=", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5", ",", "x6", ",", 
             "x7", ",", "x8"}], "}"}], "/.", "nsol"}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<q = \>\"", ",", "q", ",", "\"\< -> \>\"", ",", 
           RowBox[{"Norm", "[", "tmp", "]"}], ",", "\"\<\\n   \>\"", ",", 
           "vec", ",", "\"\<\\n\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"veclist", ",", 
           RowBox[{"{", 
            RowBox[{"q", ",", "vec"}], "}"}]}], "]"}], ";"}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Print", "[", "\"\<Done\>\"", "]"}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"q", " ", "=", " ", "10."}], " ", ";"}]}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "1.868", ",", "1.843", ",", 
       RowBox[{"-", "0.005"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "veclist"}], "Input",
 CellChangeTimes->{{3.5383955289097357`*^9, 3.538395607280014*^9}, {
   3.5383960750003557`*^9, 3.538396215074095*^9}, {3.538396289910667*^9, 
   3.5383963203716497`*^9}, {3.538396509259591*^9, 3.5383965728440866`*^9}, {
   3.5383966941917267`*^9, 3.538396697847146*^9}, 3.538396737895993*^9, {
   3.53839744436998*^9, 3.538397450144785*^9}, {3.543859011482007*^9, 
   3.543859019853387*^9}, {3.54385943160946*^9, 3.543859434520225*^9}, {
   3.5438594682683983`*^9, 3.543859468412384*^9}, {3.543859512900823*^9, 
   3.543859525812529*^9}, {3.5438619583810987`*^9, 3.5438620011365232`*^9}, {
   3.5438620782478237`*^9, 3.543862119990341*^9}, {3.543862209076723*^9, 
   3.543862253163559*^9}, {3.543862399753991*^9, 3.543862402105969*^9}, {
   3.543864951450734*^9, 3.543864980108522*^9}, {3.5438650166185627`*^9, 
   3.54386504319676*^9}, {3.543865131587582*^9, 3.5438651452592287`*^9}, {
   3.543865208456072*^9, 3.543865250580008*^9}, {3.543865307673115*^9, 
   3.543865335772135*^9}, {3.543865406330448*^9, 3.543865410681417*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"veclist", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.868`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.07409605574209051`", ",", "2.120168551991567`", ",", 
         "0.9979641465626632`", ",", 
         RowBox[{"-", "0.13206619699953426`"}], ",", "0.1096803066408052`", 
         ",", "1.8798507183251827`", ",", 
         RowBox[{"-", "1.8883455741980362`"}], ",", 
         RowBox[{"-", "1.8849422184581242`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8630000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.10094946961325645`", ",", "2.11843896557585`", ",", 
         "0.996221622879231`", ",", 
         RowBox[{"-", "0.1804917165177124`"}], ",", "0.1492701497125977`", 
         ",", "1.884992279481818`", ",", 
         RowBox[{"-", "1.9007800178918746`"}], ",", 
         RowBox[{"-", "1.8930351877297216`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.858`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.12197000170131408`", ",", "2.1167233983193694`", ",", 
         "0.9944850339762491`", ",", 
         RowBox[{"-", "0.21876327909130314`"}], ",", "0.1801886009746716`", 
         ",", "1.8900978504268293`", ",", 
         RowBox[{"-", "1.9131742069140136`"}], ",", 
         RowBox[{"-", "1.9016726924990976`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8530000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.13991378424453033`", ",", "2.1149837348926606`", ",", 
         "0.9927440162648846`", ",", 
         RowBox[{"-", "0.2517293820681301`"}], ",", "0.20648020601257608`", 
         ",", "1.8952275889273653`", ",", 
         RowBox[{"-", "1.9256311591239745`"}], ",", 
         RowBox[{"-", "1.909808191488722`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.848`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.1558346013771002`", ",", "2.113225412671581`", ",", 
         "0.9910000469003952`", ",", 
         RowBox[{"-", "0.28124731545350495`"}], ",", "0.22972733575964316`", 
         ",", "1.900372935353736`", ",", 
         RowBox[{"-", "1.9381362448249575`"}], ",", 
         RowBox[{"-", "1.9180104248625407`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8430000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17016875000194848`", ",", "2.1115098780778703`", ",", 
         "0.9892697750637398`", ",", 
         RowBox[{"-", "0.3080592423512553`"}], ",", "0.2506153749130479`", 
         ",", "1.9054371593492085`", ",", 
         RowBox[{"-", "1.9505236948034614`"}], ",", 
         RowBox[{"-", "1.9261627936566683`"}]}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.543865467476842*^9, 3.543865475124302*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "veclist", "]"}], ">", "3"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vec", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Interp", "[", 
            RowBox[{"q", ",", 
             RowBox[{"veclist", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
             RowBox[{"veclist", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "2", ",", "ii"}], "]"}], "]"}]}], "]"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", "8"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<   Interp -> \>\"", ",", "vec"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"nsol", "=", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"inteq", "[", 
         RowBox[{
         "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", 
          "x5", ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x1", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x2", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x3", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x4", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x5", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x6", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "6", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x7", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "7", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x8", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "8", "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmp", "=", 
      RowBox[{
       RowBox[{"inteq", "[", 
        RowBox[{
        "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5",
          ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", 
       "nsol"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Norm", "[", "tmp", "]"}], "<", 
        RowBox[{"10", "^", 
         RowBox[{"-", "8"}]}]}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vec", "=", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5", ",", "x6", ",", 
            "x7", ",", "x8"}], "}"}], "/.", "nsol"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<q = \>\"", ",", "q", ",", "\"\< -> \>\"", ",", 
          RowBox[{"Norm", "[", "tmp", "]"}], ",", "\"\<\\n   \>\"", ",", 
          "vec", ",", "\"\<\\n\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"veclist", ",", 
          RowBox[{"{", 
           RowBox[{"q", ",", "vec"}], "}"}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Done\>\"", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"q", " ", "=", " ", "10."}], " ", ";"}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{
     "q", ",", "\[InvisibleSpace]", "1.84", ",", "1.", "\[InvisibleSpace]", 
      ",", 
      RowBox[{"-", "0.02"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.543865454321499*^9, 3.543865543074542*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"veclist", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.868`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.07409605574209051`", ",", "2.120168551991567`", ",", 
         "0.9979641465626632`", ",", 
         RowBox[{"-", "0.13206619699953426`"}], ",", "0.1096803066408052`", 
         ",", "1.8798507183251827`", ",", 
         RowBox[{"-", "1.8883455741980362`"}], ",", 
         RowBox[{"-", "1.8849422184581242`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8630000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.10094946961325645`", ",", "2.11843896557585`", ",", 
         "0.996221622879231`", ",", 
         RowBox[{"-", "0.1804917165177124`"}], ",", "0.1492701497125977`", 
         ",", "1.884992279481818`", ",", 
         RowBox[{"-", "1.9007800178918746`"}], ",", 
         RowBox[{"-", "1.8930351877297216`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.858`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.12197000170131408`", ",", "2.1167233983193694`", ",", 
         "0.9944850339762491`", ",", 
         RowBox[{"-", "0.21876327909130314`"}], ",", "0.1801886009746716`", 
         ",", "1.8900978504268293`", ",", 
         RowBox[{"-", "1.9131742069140136`"}], ",", 
         RowBox[{"-", "1.9016726924990976`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8530000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.13991378424453033`", ",", "2.1149837348926606`", ",", 
         "0.9927440162648846`", ",", 
         RowBox[{"-", "0.2517293820681301`"}], ",", "0.20648020601257608`", 
         ",", "1.8952275889273653`", ",", 
         RowBox[{"-", "1.9256311591239745`"}], ",", 
         RowBox[{"-", "1.909808191488722`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.848`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.1558346013771002`", ",", "2.113225412671581`", ",", 
         "0.9910000469003952`", ",", 
         RowBox[{"-", "0.28124731545350495`"}], ",", "0.22972733575964316`", 
         ",", "1.900372935353736`", ",", 
         RowBox[{"-", "1.9381362448249575`"}], ",", 
         RowBox[{"-", "1.9180104248625407`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8430000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17016875000194848`", ",", "2.1115098780778703`", ",", 
         "0.9892697750637398`", ",", 
         RowBox[{"-", "0.3080592423512553`"}], ",", "0.2506153749130479`", 
         ",", "1.9054371593492085`", ",", 
         RowBox[{"-", "1.9505236948034614`"}], ",", 
         RowBox[{"-", "1.9261627936566683`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.84`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17826167507411272`", ",", "2.1104559051192573`", ",", 
         "0.9882259326796118`", ",", 
         RowBox[{"-", "0.32330581600520547`"}], ",", "0.26236779856342607`", 
         ",", "1.9085078859494449`", ",", 
         RowBox[{"-", "1.9580215612745053`"}], ",", 
         RowBox[{"-", "1.931121256897245`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.82`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.22488694197749054`", ",", "2.103380714521802`", ",", 
         "0.9812728968525489`", ",", 
         RowBox[{"-", "0.41286781222427793`"}], ",", "0.3296044742182707`", 
         ",", "1.9289306281682954`", ",", 
         RowBox[{"-", "2.008120303091178`"}], ",", 
         RowBox[{"-", "1.9650601848404534`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.263403558765456`", ",", "2.096205608174961`", ",", 
         "0.9743256730333851`", ",", 
         RowBox[{"-", "0.48939211154605033`"}], ",", "0.3843975474769295`", 
         ",", "1.9492937907951573`", ",", 
         RowBox[{"-", "2.05845848599753`"}], ",", 
         RowBox[{"-", "1.9995561358962997`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.78`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.29697518455095745`", ",", "2.0889423128476263`", ",", 
         "0.9673869185290676`", ",", 
         RowBox[{"-", "0.558279652709024`"}], ",", "0.4315291947985173`", ",",
          "1.9695814694547868`", ",", 
         RowBox[{"-", "2.1090091196394116`"}], ",", 
         RowBox[{"-", "2.0352685093571585`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.76`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.3271598204456268`", ",", "2.081567124294121`", ",", 
         "0.9604497669481518`", ",", 
         RowBox[{"-", "0.6221486306454592`"}], ",", "0.47328486423405836`", 
         ",", "1.9898325723528631`", ",", 
         RowBox[{"-", "2.1598388644472086`"}], ",", 
         RowBox[{"-", "2.071552595488018`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7200000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.3805021914087528`", ",", "2.066514870321669`", ",", 
         "0.9465874464830879`", ",", 
         RowBox[{"-", "0.7400039977668367`"}], ",", "0.5455047926770815`", 
         ",", "2.0301803808864767`", ",", 
         RowBox[{"-", "2.2622601874863317`"}], ",", 
         RowBox[{"-", "2.1473061767619304`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7000000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.4046128853375105`", ",", "2.0588198731087877`", ",", 
         "0.9396565452523309`", ",", 
         RowBox[{"-", "0.795537154126863`"}], ",", "0.5773661902403812`", ",",
          "2.0503081121045224`", ",", 
         RowBox[{"-", "2.3139052814335432`"}], ",", 
         RowBox[{"-", "2.186433658947585`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6800000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.42738986570203724`", ",", "2.0510415737040817`", ",", 
         "0.932732941463491`", ",", 
         RowBox[{"-", "0.8493817405747806`"}], ",", "0.607017515193857`", ",",
          "2.070362854344421`", ",", 
         RowBox[{"-", "2.3657698062065`"}], ",", 
         RowBox[{"-", "2.226488748803607`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6600000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.4490644897242795`", ",", "2.0431503052332096`", ",", 
         "0.9258082749841597`", ",", 
         RowBox[{"-", "0.9019290716600774`"}], ",", "0.6347851658005186`", 
         ",", "2.090391510684943`", ",", 
         RowBox[{"-", "2.4179342410329308`"}], ",", 
         RowBox[{"-", "2.2678968345073445`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.62`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.48966127102623513`", ",", "2.0270829673417428`", ",", 
         "0.9119680934315914`", ",", 
         RowBox[{"-", "1.0038852676290009`"}], ",", "0.6855185237246182`", 
         ",", "2.13029486109991`", ",", 
         RowBox[{"-", "2.5230393049728153`"}], ",", 
         RowBox[{"-", "2.3528071117321376`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5088314372895092`", ",", "2.018878236095998`", ",", 
         "0.9050440626366997`", ",", 
         RowBox[{"-", "1.0536960221886291`"}], ",", "0.7088332820279133`", 
         ",", "2.1502152257033487`", ",", 
         RowBox[{"-", "2.5760592963152127`"}], ",", 
         RowBox[{"-", "2.3967672740185004`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.58`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5273545275263245`", ",", "2.010575258529651`", ",", 
         "0.8981208966176263`", ",", 
         RowBox[{"-", "1.1028793495786011`"}], ",", "0.7309985511711032`", 
         ",", "2.170093522850811`", ",", 
         RowBox[{"-", "2.6293577550798335`"}], ",", 
         RowBox[{"-", "2.442127737440482`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.56`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5453077255774209`", ",", "2.0021626572013895`", ",", 
         "0.8911951179108348`", ",", 
         RowBox[{"-", "1.1515364877849836`"}], ",", "0.7520675842519604`", 
         ",", "2.189947276035549`", ",", 
         RowBox[{"-", "2.682965705949222`"}], ",", 
         RowBox[{"-", "2.4880947291761606`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.52`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5797281594432059`", ",", "1.9850115064241494`", ",", 
         "0.8773345210374353`", ",", 
         RowBox[{"-", "1.2476078725156199`"}], ",", "0.7913395670399445`", 
         ",", "2.229582003315571`", ",", 
         RowBox[{"-", "2.791119378501514`"}], ",", 
         RowBox[{"-", "2.5830794221371645`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5962865178030728`", ",", "1.9762766204423838`", ",", 
         "0.8703996350381962`", ",", 
         RowBox[{"-", "1.2951477748864133`"}], ",", "0.8097010177996378`", 
         ",", "2.2493599143445286`", ",", 
         RowBox[{"-", "2.845665400722957`"}], ",", 
         RowBox[{"-", "2.6321062777511957`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.48`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6124714214301092`", ",", "1.9674207398689028`", ",", 
         "0.8634571985828617`", ",", 
         RowBox[{"-", "1.3424501191023754`"}], ",", "0.8272732318349333`", 
         ",", "2.2691341396915985`", ",", 
         RowBox[{"-", "2.9005642737031407`"}], ",", 
         RowBox[{"-", "2.6822204172706203`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.44`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6438209671286115`", ",", "1.9493940340092228`", ",", 
         "0.849559994780463`", ",", 
         RowBox[{"-", "1.4364446858730455`"}], ",", "0.8603685854903844`", 
         ",", "2.308605812587862`", ",", 
         RowBox[{"-", "3.011326105997462`"}], ",", 
         RowBox[{"-", "2.7860539537726856`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.4200000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6590456785721874`", ",", "1.9402159607617797`", ",", 
         "0.8426022906426062`", ",", 
         RowBox[{"-", "1.4832140488394734`"}], ",", "0.8759550669907962`", 
         ",", "2.328315490980453`", ",", 
         RowBox[{"-", "3.067216233533839`"}], ",", 
         RowBox[{"-", "2.839376372487654`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.3800000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6887287617582241`", ",", "1.9215013977136444`", ",", 
         "0.8286586577921988`", ",", 
         RowBox[{"-", "1.5764938761555642`"}], ",", "0.9053719458902377`", 
         ",", "2.367726088123225`", ",", 
         RowBox[{"-", "3.1801001723213007`"}], ",", 
         RowBox[{"-", "2.9494204405805933`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.36`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7032264406191593`", ",", "1.911966636481573`", ",", 
         "0.8216720594144495`", ",", 
         RowBox[{"-", "1.6230575588931981`"}], ",", "0.9192800184979449`", 
         ",", "2.3874262771487995`", ",", 
         RowBox[{"-", "3.2371024942745943`"}], ",", 
         RowBox[{"-", "3.0061441868231955`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.34`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7175184633466903`", ",", "1.9023140363077047`", ",", 
         "0.8146750132812847`", ",", 
         RowBox[{"-", "1.6695961776918746`"}], ",", "0.9326989945280368`", 
         ",", "2.4071224483050213`", ",", 
         RowBox[{"-", "3.2944823760345705`"}], ",", 
         RowBox[{"-", "3.0640137430428847`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.32`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7316236278236997`", ",", "1.892538357642916`", ",", 
         "0.8076656225360733`", ",", 
         RowBox[{"-", "1.716138544533985`"}], ",", "0.9456473034737107`", ",",
          "2.4268225920081994`", ",", 
         RowBox[{"-", "3.352257372105316`"}], ",", 
         RowBox[{"-", "3.1230544109686846`"}]}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5438657819026747`*^9, 3.543865789759406*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "veclist", "]"}], ">", "3"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vec", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Interp", "[", 
            RowBox[{"q", ",", 
             RowBox[{"veclist", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
             RowBox[{"veclist", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "2", ",", "ii"}], "]"}], "]"}]}], "]"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", "8"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<   Interp -> \>\"", ",", "vec"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"nsol", "=", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"inteq", "[", 
         RowBox[{
         "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", 
          "x5", ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x1", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x2", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x3", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x4", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x5", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x6", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "6", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x7", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "7", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x8", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "8", "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmp", "=", 
      RowBox[{
       RowBox[{"inteq", "[", 
        RowBox[{
        "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5",
          ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", 
       "nsol"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Norm", "[", "tmp", "]"}], "<", 
        RowBox[{"10", "^", 
         RowBox[{"-", "8"}]}]}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vec", "=", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5", ",", "x6", ",", 
            "x7", ",", "x8"}], "}"}], "/.", "nsol"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<q = \>\"", ",", "q", ",", "\"\< -> \>\"", ",", 
          RowBox[{"Norm", "[", "tmp", "]"}], ",", "\"\<\\n   \>\"", ",", 
          "vec", ",", "\"\<\\n\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"veclist", ",", 
          RowBox[{"{", 
           RowBox[{"q", ",", "vec"}], "}"}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Done\>\"", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"q", " ", "=", " ", "10."}], " ", ";"}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{
     "q", ",", "\[InvisibleSpace]", "1.28", ",", "0.", "\[InvisibleSpace]", 
      ",", 
      RowBox[{"-", "0.05"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.543865454321499*^9, 3.543865543074542*^9}, {
  3.543865808164957*^9, 3.543865810308543*^9}, {3.5438658496434526`*^9, 
  3.543865873090691*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"veclist", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.868`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.07409605574209051`", ",", "2.120168551991567`", ",", 
         "0.9979641465626632`", ",", 
         RowBox[{"-", "0.13206619699953426`"}], ",", "0.1096803066408052`", 
         ",", "1.8798507183251827`", ",", 
         RowBox[{"-", "1.8883455741980362`"}], ",", 
         RowBox[{"-", "1.8849422184581242`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8630000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.10094946961325645`", ",", "2.11843896557585`", ",", 
         "0.996221622879231`", ",", 
         RowBox[{"-", "0.1804917165177124`"}], ",", "0.1492701497125977`", 
         ",", "1.884992279481818`", ",", 
         RowBox[{"-", "1.9007800178918746`"}], ",", 
         RowBox[{"-", "1.8930351877297216`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.858`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.12197000170131408`", ",", "2.1167233983193694`", ",", 
         "0.9944850339762491`", ",", 
         RowBox[{"-", "0.21876327909130314`"}], ",", "0.1801886009746716`", 
         ",", "1.8900978504268293`", ",", 
         RowBox[{"-", "1.9131742069140136`"}], ",", 
         RowBox[{"-", "1.9016726924990976`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8530000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.13991378424453033`", ",", "2.1149837348926606`", ",", 
         "0.9927440162648846`", ",", 
         RowBox[{"-", "0.2517293820681301`"}], ",", "0.20648020601257608`", 
         ",", "1.8952275889273653`", ",", 
         RowBox[{"-", "1.9256311591239745`"}], ",", 
         RowBox[{"-", "1.909808191488722`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.848`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.1558346013771002`", ",", "2.113225412671581`", ",", 
         "0.9910000469003952`", ",", 
         RowBox[{"-", "0.28124731545350495`"}], ",", "0.22972733575964316`", 
         ",", "1.900372935353736`", ",", 
         RowBox[{"-", "1.9381362448249575`"}], ",", 
         RowBox[{"-", "1.9180104248625407`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8430000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17016875000194848`", ",", "2.1115098780778703`", ",", 
         "0.9892697750637398`", ",", 
         RowBox[{"-", "0.3080592423512553`"}], ",", "0.2506153749130479`", 
         ",", "1.9054371593492085`", ",", 
         RowBox[{"-", "1.9505236948034614`"}], ",", 
         RowBox[{"-", "1.9261627936566683`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.84`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17826167507411272`", ",", "2.1104559051192573`", ",", 
         "0.9882259326796118`", ",", 
         RowBox[{"-", "0.32330581600520547`"}], ",", "0.26236779856342607`", 
         ",", "1.9085078859494449`", ",", 
         RowBox[{"-", "1.9580215612745053`"}], ",", 
         RowBox[{"-", "1.931121256897245`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.82`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.22488694197749054`", ",", "2.103380714521802`", ",", 
         "0.9812728968525489`", ",", 
         RowBox[{"-", "0.41286781222427793`"}], ",", "0.3296044742182707`", 
         ",", "1.9289306281682954`", ",", 
         RowBox[{"-", "2.008120303091178`"}], ",", 
         RowBox[{"-", "1.9650601848404534`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.263403558765456`", ",", "2.096205608174961`", ",", 
         "0.9743256730333851`", ",", 
         RowBox[{"-", "0.48939211154605033`"}], ",", "0.3843975474769295`", 
         ",", "1.9492937907951573`", ",", 
         RowBox[{"-", "2.05845848599753`"}], ",", 
         RowBox[{"-", "1.9995561358962997`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.78`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.29697518455095745`", ",", "2.0889423128476263`", ",", 
         "0.9673869185290676`", ",", 
         RowBox[{"-", "0.558279652709024`"}], ",", "0.4315291947985173`", ",",
          "1.9695814694547868`", ",", 
         RowBox[{"-", "2.1090091196394116`"}], ",", 
         RowBox[{"-", "2.0352685093571585`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.76`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.3271598204456268`", ",", "2.081567124294121`", ",", 
         "0.9604497669481518`", ",", 
         RowBox[{"-", "0.6221486306454592`"}], ",", "0.47328486423405836`", 
         ",", "1.9898325723528631`", ",", 
         RowBox[{"-", "2.1598388644472086`"}], ",", 
         RowBox[{"-", "2.071552595488018`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7200000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.3805021914087528`", ",", "2.066514870321669`", ",", 
         "0.9465874464830879`", ",", 
         RowBox[{"-", "0.7400039977668367`"}], ",", "0.5455047926770815`", 
         ",", "2.0301803808864767`", ",", 
         RowBox[{"-", "2.2622601874863317`"}], ",", 
         RowBox[{"-", "2.1473061767619304`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7000000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.4046128853375105`", ",", "2.0588198731087877`", ",", 
         "0.9396565452523309`", ",", 
         RowBox[{"-", "0.795537154126863`"}], ",", "0.5773661902403812`", ",",
          "2.0503081121045224`", ",", 
         RowBox[{"-", "2.3139052814335432`"}], ",", 
         RowBox[{"-", "2.186433658947585`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6800000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.42738986570203724`", ",", "2.0510415737040817`", ",", 
         "0.932732941463491`", ",", 
         RowBox[{"-", "0.8493817405747806`"}], ",", "0.607017515193857`", ",",
          "2.070362854344421`", ",", 
         RowBox[{"-", "2.3657698062065`"}], ",", 
         RowBox[{"-", "2.226488748803607`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6600000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.4490644897242795`", ",", "2.0431503052332096`", ",", 
         "0.9258082749841597`", ",", 
         RowBox[{"-", "0.9019290716600774`"}], ",", "0.6347851658005186`", 
         ",", "2.090391510684943`", ",", 
         RowBox[{"-", "2.4179342410329308`"}], ",", 
         RowBox[{"-", "2.2678968345073445`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.62`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.48966127102623513`", ",", "2.0270829673417428`", ",", 
         "0.9119680934315914`", ",", 
         RowBox[{"-", "1.0038852676290009`"}], ",", "0.6855185237246182`", 
         ",", "2.13029486109991`", ",", 
         RowBox[{"-", "2.5230393049728153`"}], ",", 
         RowBox[{"-", "2.3528071117321376`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5088314372895092`", ",", "2.018878236095998`", ",", 
         "0.9050440626366997`", ",", 
         RowBox[{"-", "1.0536960221886291`"}], ",", "0.7088332820279133`", 
         ",", "2.1502152257033487`", ",", 
         RowBox[{"-", "2.5760592963152127`"}], ",", 
         RowBox[{"-", "2.3967672740185004`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.58`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5273545275263245`", ",", "2.010575258529651`", ",", 
         "0.8981208966176263`", ",", 
         RowBox[{"-", "1.1028793495786011`"}], ",", "0.7309985511711032`", 
         ",", "2.170093522850811`", ",", 
         RowBox[{"-", "2.6293577550798335`"}], ",", 
         RowBox[{"-", "2.442127737440482`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.56`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5453077255774209`", ",", "2.0021626572013895`", ",", 
         "0.8911951179108348`", ",", 
         RowBox[{"-", "1.1515364877849836`"}], ",", "0.7520675842519604`", 
         ",", "2.189947276035549`", ",", 
         RowBox[{"-", "2.682965705949222`"}], ",", 
         RowBox[{"-", "2.4880947291761606`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.52`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5797281594432059`", ",", "1.9850115064241494`", ",", 
         "0.8773345210374353`", ",", 
         RowBox[{"-", "1.2476078725156199`"}], ",", "0.7913395670399445`", 
         ",", "2.229582003315571`", ",", 
         RowBox[{"-", "2.791119378501514`"}], ",", 
         RowBox[{"-", "2.5830794221371645`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5962865178030728`", ",", "1.9762766204423838`", ",", 
         "0.8703996350381962`", ",", 
         RowBox[{"-", "1.2951477748864133`"}], ",", "0.8097010177996378`", 
         ",", "2.2493599143445286`", ",", 
         RowBox[{"-", "2.845665400722957`"}], ",", 
         RowBox[{"-", "2.6321062777511957`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.48`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6124714214301092`", ",", "1.9674207398689028`", ",", 
         "0.8634571985828617`", ",", 
         RowBox[{"-", "1.3424501191023754`"}], ",", "0.8272732318349333`", 
         ",", "2.2691341396915985`", ",", 
         RowBox[{"-", "2.9005642737031407`"}], ",", 
         RowBox[{"-", "2.6822204172706203`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.44`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6438209671286115`", ",", "1.9493940340092228`", ",", 
         "0.849559994780463`", ",", 
         RowBox[{"-", "1.4364446858730455`"}], ",", "0.8603685854903844`", 
         ",", "2.308605812587862`", ",", 
         RowBox[{"-", "3.011326105997462`"}], ",", 
         RowBox[{"-", "2.7860539537726856`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.4200000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6590456785721874`", ",", "1.9402159607617797`", ",", 
         "0.8426022906426062`", ",", 
         RowBox[{"-", "1.4832140488394734`"}], ",", "0.8759550669907962`", 
         ",", "2.328315490980453`", ",", 
         RowBox[{"-", "3.067216233533839`"}], ",", 
         RowBox[{"-", "2.839376372487654`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.3800000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6887287617582241`", ",", "1.9215013977136444`", ",", 
         "0.8286586577921988`", ",", 
         RowBox[{"-", "1.5764938761555642`"}], ",", "0.9053719458902377`", 
         ",", "2.367726088123225`", ",", 
         RowBox[{"-", "3.1801001723213007`"}], ",", 
         RowBox[{"-", "2.9494204405805933`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.36`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7032264406191593`", ",", "1.911966636481573`", ",", 
         "0.8216720594144495`", ",", 
         RowBox[{"-", "1.6230575588931981`"}], ",", "0.9192800184979449`", 
         ",", "2.3874262771487995`", ",", 
         RowBox[{"-", "3.2371024942745943`"}], ",", 
         RowBox[{"-", "3.0061441868231955`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.34`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7175184633466903`", ",", "1.9023140363077047`", ",", 
         "0.8146750132812847`", ",", 
         RowBox[{"-", "1.6695961776918746`"}], ",", "0.9326989945280368`", 
         ",", "2.4071224483050213`", ",", 
         RowBox[{"-", "3.2944823760345705`"}], ",", 
         RowBox[{"-", "3.0640137430428847`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.32`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7316236278236997`", ",", "1.892538357642916`", ",", 
         "0.8076656225360733`", ",", 
         RowBox[{"-", "1.716138544533985`"}], ",", "0.9456473034737107`", ",",
          "2.4268225920081994`", ",", 
         RowBox[{"-", "3.352257372105316`"}], ",", 
         RowBox[{"-", "3.1230544109686846`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.28`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.759327630044047`", ",", "1.8726252884090915`", ",", 
         "0.7936093988176277`", ",", 
         RowBox[{"-", "1.8092946252978641`"}], ",", "0.9702715256209089`", 
         ",", "2.4662250249723754`", ",", 
         RowBox[{"-", "3.468998672177377`"}], ",", 
         RowBox[{"-", "3.244691808425779`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.23`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.793157516173759`", ",", "1.8470221833116771`", ",", 
         "0.7759543195536678`", ",", 
         RowBox[{"-", "1.926084168284337`"}], ",", "0.9988649230120109`", ",",
          "2.5155298343116375`", ",", 
         RowBox[{"-", "3.6172923759074913`"}], ",", 
         RowBox[{"-", "3.403639782925374`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.18`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.8262833012364006`", ",", "1.8205837200802935`", ",", 
         "0.7581849149437223`", ",", 
         RowBox[{"-", "2.043517834789346`"}], ",", "1.0252809707518953`", ",",
          "2.564951928019079`", ",", 
         RowBox[{"-", "3.768399956744153`"}], ",", 
         RowBox[{"-", "3.5705963723620657`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.03`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.9230488688213225`", ",", "1.73588609398436`", ",", 
         "0.7039940643249193`", ",", 
         RowBox[{"-", "2.4019805149276023`"}], ",", "1.0942543883857436`", 
         ",", "2.7143508760863733`", ",", 
         RowBox[{"-", "4.240489973931262`"}], ",", 
         RowBox[{"-", "4.123436603974003`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.98`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.9549279981238569`", ",", "1.7056750601798654`", ",", 
         "0.6855521428817635`", ",", 
         RowBox[{"-", "2.5242985092271657`"}], ",", "1.114555308899134`", ",",
          "2.7647280495543316`", ",", 
         RowBox[{"-", "4.404914229188696`"}], ",", 
         RowBox[{"-", "4.326628213569345`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9299999999999999`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.986857615616634`", ",", "1.6743550719995128`", ",", 
         "0.6668700888623107`", ",", 
         RowBox[{"-", "2.6484410797834674`"}], ",", "1.1338173625182217`", 
         ",", "2.815515897460275`", ",", 
         RowBox[{"-", "4.573359485184544`"}], ",", 
         RowBox[{"-", "4.540306961248853`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.88`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0189782070091018`", ",", "1.6418495888986004`", ",", 
         "0.6479144619747503`", ",", 
         RowBox[{"-", "2.7746598884801315`"}], ",", "1.1522566054543582`", 
         ",", "2.8667820124242054`", ",", 
         RowBox[{"-", "4.746155719065648`"}], ",", 
         RowBox[{"-", "4.76514244154874`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8300000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0514363539949725`", ",", "1.6080712188475348`", ",", 
         "0.6286476155983801`", ",", 
         RowBox[{"-", "2.903241545154152`"}], ",", "1.1701212378997488`", ",",
          "2.9185998862859255`", ",", 
         RowBox[{"-", "4.923682903219094`"}], ",", 
         RowBox[{"-", "5.002008900278566`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.78`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0844010454097461`", ",", "1.572887661093316`", ",", 
         "0.6090193365955197`", ",", 
         RowBox[{"-", "3.034504887082299`"}], ",", "1.1875031258439983`", ",",
          "2.971090532668834`", ",", 
         RowBox[{"-", "5.106421449956452`"}], ",", 
         RowBox[{"-", "5.251811873544956`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.73`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1180479966266779`", ",", "1.5361730163991627`", ",", 
         "0.588978613592471`", ",", 
         RowBox[{"-", "3.1688120759508878`"}], ",", "1.2046503944973106`", 
         ",", "3.024353579034675`", ",", 
         RowBox[{"-", "5.294886464737035`"}], ",", 
         RowBox[{"-", "5.515627155864887`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.6799999999999999`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1525837188902464`", ",", "1.4977570080308695`", ",", 
         "0.568461058774028`", ",", 
         RowBox[{"-", "3.306576091782493`"}], ",", "1.2217108459212238`", ",",
          "3.078528825897698`", ",", 
         RowBox[{"-", "5.489706657652221`"}], ",", 
         RowBox[{"-", "5.794792774146105`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.63`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1882418065099052`", ",", "1.4574526479500487`", ",", 
         "0.5473946051470174`", ",", 
         RowBox[{"-", "3.44828153950453`"}], ",", "1.2389675741800101`", ",", 
         "3.1337571079417206`", ",", 
         RowBox[{"-", "5.69160646740515`"}], ",", 
         RowBox[{"-", "6.091006264154231`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.58`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.225305531795742`", ",", "1.415017305618747`", ",", 
         "0.5256894636474833`", ",", 
         RowBox[{"-", "3.5945070249561994`"}], ",", "1.2566285813178981`", 
         ",", "3.190224734457376`", ",", 
         RowBox[{"-", "5.901477288136015`"}], ",", 
         RowBox[{"-", "6.406073534076588`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.53`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.2641202878210855`", ",", "1.3701532912838383`", ",", 
         "0.5032367592682069`", ",", 
         RowBox[{"-", "3.745944023702552`"}], ",", "1.2749492456089138`", ",",
          "3.2481515787097424`", ",", 
         RowBox[{"-", "6.12039536605819`"}], ",", 
         RowBox[{"-", "6.742346946394514`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.48`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3051173605423914`", ",", "1.3224924070876931`", ",", 
         "0.47990281899507703`", ",", 
         RowBox[{"-", "3.903453166116109`"}], ",", "1.2942804705700126`", ",",
          "3.3078010338537096`", ",", 
         RowBox[{"-", "6.3496994746537645`"}], ",", 
         RowBox[{"-", "7.102722008787847`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.42999999999999994`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3488591460162878`", ",", "1.271548393431121`", ",", 
         "0.4555152710323542`", ",", 
         RowBox[{"-", "4.0681096407769`"}], ",", "1.3149514902873514`", ",", 
         "3.3695179164521227`", ",", 
         RowBox[{"-", "6.591085402958407`"}], ",", 
         RowBox[{"-", "7.490873737285019`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.38`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3960957591064582`", ",", "1.216685753047732`", ",", 
         "0.42985107157498326`", ",", 
         RowBox[{"-", "4.241312742141526`"}], ",", "1.337427292084789`", ",", 
         "3.4337399590177204`", ",", 
         RowBox[{"-", "6.84675801294185`"}], ",", 
         RowBox[{"-", "7.911597762080053`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.32999999999999996`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.447873230106782`", ",", "1.1570340351583543`", ",", 
         "0.4026093032641672`", ",", 
         RowBox[{"-", "4.4249325467136185`"}], ",", "1.3622900283129145`", 
         ",", "3.501054633931335`", ",", 
         RowBox[{"-", "7.119675995248774`"}], ",", 
         RowBox[{"-", "8.371305919012228`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.28`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.5057236960045268`", ",", "1.0913518674675085`", ",", 
         "0.373367196787542`", ",", 
         RowBox[{"-", "4.621576053138501`"}], ",", "1.390318997704208`", ",", 
         "3.572281474924267`", ",", 
         RowBox[{"-", "7.413971974028285`"}], ",", 
         RowBox[{"-", "8.878975020794677`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.22999999999999998`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.57203980735116`", ",", "1.0177678673734798`", ",", 
         "0.34149736181382523`", ",", 
         RowBox[{"-", "4.835076798074535`"}], ",", "1.4226214179605465`", ",",
          "3.6486273990264926`", ",", 
         RowBox[{"-", "7.735734242987447`"}], ",", 
         RowBox[{"-", "9.44782848881641`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.07999999999999985`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.8892842980600542`", ",", "0.7021647764329307`", ",", 
         "0.21477094825370602`", ",", 
         RowBox[{"-", "5.668698911077289`"}], ",", "1.571068461292025`", ",", 
         "3.937321470523456`", ",", 
         RowBox[{"-", "9.011955267383346`"}], ",", 
         RowBox[{"-", "11.838448294690265`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.030000000000000027`", ",", 
       RowBox[{"{", 
        RowBox[{
        "2.14505629502275`", ",", "0.5002442116584971`", ",", 
         "0.14210334806045316`", ",", 
         RowBox[{"-", "6.127329861034945`"}], ",", "1.6695931030439755`", ",",
          "4.090153831975672`", ",", 
         RowBox[{"-", "9.72589898707181`"}], ",", 
         RowBox[{"-", "13.263510038735388`"}]}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5438660636904173`*^9, 3.543866071836761*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"inteq", "[", 
      RowBox[{
      "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", 
       ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", "nsol"}], 
    "]"}], ";"}]}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerics - High precision", "Subsubtitle",
 CellChangeTimes->{{3.538463013798025*^9, 3.5384630213987093`*^9}, {
  3.538467402992407*^9, 3.5384674058714247`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"precision", "=", "25"}], ";"}]], "Input",
 CellChangeTimes->{{3.538467418163487*^9, 3.5384674209374638`*^9}, {
  3.538467503829393*^9, 3.538467504196958*^9}, {3.5384675867083883`*^9, 
  3.5384675867768393`*^9}, {3.538475778689355*^9, 3.538475779473031*^9}, {
  3.5384759893975153`*^9, 3.538475989501337*^9}, {3.538483715861815*^9, 
  3.5384837159415283`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"inteq", ",", "zhoriz", ",", "eps"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"inteq", "[", 
    RowBox[{
    "z0in_Real", ",", "horizp0in_Real", ",", "horiza1in_Real", ",", 
     "horizt1in_Real", ",", "horizs0in_Real", ",", "asymp2in_Real", ",", 
     "asymh2in_Real", ",", "asyma0in_Real", ",", "asyma1in_Real", ",", 
     "asymT3in_Real", ",", "output_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"z0", "=", "z0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizp0", "=", "horizp0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizh0", "=", "0"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horiza1", "=", "horiza1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizt1", "=", "horizt1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizs0", "=", "horizs0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymp2", "=", "asymp2in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymh2", "=", "asymh2in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asyma0", "=", "asyma0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asyma1", "=", "asyma1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymT3", "=", "asymT3in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"eps", "=", 
      RowBox[{"SetPrecision", "[", 
       RowBox[{"0.0001", ",", "30"}], "]"}]}], " ", ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"eps2", "=", 
      RowBox[{"SetPrecision", "[", 
       RowBox[{"0.0001", ",", "30"}], "]"}]}], " ", ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"zmid", " ", "=", " ", 
      RowBox[{"SetPrecision", "[", 
       RowBox[{"0.4", ",", "30"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zhoriz", "=", 
      RowBox[{"1", "-", "eps2"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"nsol1", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"eqlist", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"p", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymp", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asymp", "'"}], "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"h", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymh", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"a", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asyma", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asyma", "'"}], "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"T", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymT", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"S", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymS", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asymS", "'"}], "[", "eps", "]"}]}]}], "}"}]}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "eps", ",", "zhoriz"}], "}"}], ",", 
         RowBox[{"WorkingPrecision", "\[Rule]", "precision"}], ",", 
         RowBox[{"MaxSteps", "\[Rule]", "100000"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zcut1", "=", 
      RowBox[{"nsol1", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "2"}], "]"}], "]"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"zcut1", "<", "zmid"}], ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Error  \>\"", ",", "zcut2"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"nsol2", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"eqlist", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"p", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizp", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horizp", "'"}], "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"h", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizh", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"a", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horiza", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horiza", "'"}], "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"T", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizT", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"S", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizS", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horizS", "'"}], "[", "zhoriz", "]"}]}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "eps", ",", "zhoriz"}], "}"}], ",", 
         RowBox[{"WorkingPrecision", "\[Rule]", "precision"}], ",", 
         RowBox[{"MaxSteps", "\[Rule]", "100000"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zcut2", "=", 
      RowBox[{"nsol2", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "1"}], "]"}], "]"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"zcut2", ">", "zmid"}], ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Error  \>\"", ",", "zcut2"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", 
      RowBox[{
      "horizp0", ",", "horizh0", ",", "horiza1", ",", "horizt1", ",", 
       "horizs0", ",", "asymp2", ",", "asymh2", ",", "asyma0", ",", "asyma1", 
       ",", "asymT3"}], "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Return", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"h", "'"}], "[", "eps", "]"}], ",", 
             RowBox[{
              RowBox[{"T", "'"}], "[", "eps", "]"}]}], "}"}], "/.", "nsol2"}],
           "]"}], ";"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"htab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"h", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Ttab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"T", "[", "z", "]"}], "-", "1"}], "/.", "nsol2"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Coefficient", "[", 
            RowBox[{"hfit", ",", "z"}], "]"}], ",", 
           RowBox[{"Coefficient", "[", 
            RowBox[{"Tfit", ",", "z"}], "]"}]}], "}"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "2"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"T", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"T", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"S", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"S", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"dlist", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"Join", "[", 
          RowBox[{"list", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"dlist", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"dlist", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"dlist", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}], "]"}], 
        ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ptab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"p", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"htab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"h", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"atab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"a", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Ttab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"T", "[", "z", "]"}], "-", "1"}], "/.", "nsol2"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Stab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"S", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"pfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"ptab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"afit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"atab", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "z"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}], ",", 
             RowBox[{"z", "^", "3"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Sfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Stab", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "z"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"pfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"ptab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "2"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "2"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "3"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"pf", "==", "pfit"}], ",", 
             RowBox[{"hf", "\[Equal]", "hfit"}], ",", 
             RowBox[{"af", "\[Equal]", "afit"}], ",", 
             RowBox[{"Tf", "\[Equal]", "Tfit"}], ",", 
             RowBox[{"Sf", "\[Equal]", "Sfit"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pfit2", ",", "hfit2", ",", "Tfit2"}], "}"}]}], "}"}], 
         "]"}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], 
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.5376407771099586`*^9, 3.53764077742128*^9}, {
   3.537640849432414*^9, 3.537641029700471*^9}, {3.537641083186082*^9, 
   3.5376410832815037`*^9}, {3.537641227496984*^9, 3.537641241071927*^9}, {
   3.537641278231781*^9, 3.53764129200132*^9}, {3.537811594660029*^9, 
   3.537811661635552*^9}, 3.537811712330718*^9, {3.537812313668707*^9, 
   3.537812329718534*^9}, {3.537812368025175*^9, 3.537812466952651*^9}, {
   3.537812574550178*^9, 3.53781262207281*^9}, {3.537855902100842*^9, 
   3.537855910975484*^9}, {3.537863637889791*^9, 3.537863642968212*^9}, {
   3.53786405512639*^9, 3.5378640577014513`*^9}, {3.5378642740193357`*^9, 
   3.5378642823266706`*^9}, {3.537864945886372*^9, 3.537864949610241*^9}, {
   3.537865324468916*^9, 3.5378653414829493`*^9}, {3.537865422417637*^9, 
   3.537865426010881*^9}, {3.537865668894218*^9, 3.5378656720161123`*^9}, {
   3.537866060689427*^9, 3.537866086110963*^9}, {3.537866821965849*^9, 
   3.537866824468356*^9}, {3.537866935754058*^9, 3.5378669532770844`*^9}, {
   3.537867277477654*^9, 3.537867283864683*^9}, {3.5378673736645327`*^9, 
   3.53786741047612*^9}, {3.537867724358015*^9, 3.537867770909184*^9}, {
   3.537867812374217*^9, 3.537867814824875*^9}, {3.537867862682262*^9, 
   3.537867863608501*^9}, {3.537867935345325*^9, 3.537867952471974*^9}, {
   3.537867984898217*^9, 3.5378679871300287`*^9}, {3.537870400150711*^9, 
   3.537870402077724*^9}, {3.537870448958918*^9, 3.5378704524785967`*^9}, {
   3.537870930220189*^9, 3.537870930900414*^9}, 3.537871139674671*^9, {
   3.537871192589308*^9, 3.53787120155658*^9}, {3.537871653378598*^9, 
   3.5378716648098917`*^9}, {3.537871703252593*^9, 3.537871787942024*^9}, {
   3.537871824557847*^9, 3.537871910740779*^9}, {3.537871941253039*^9, 
   3.5378719525649443`*^9}, {3.537871994498852*^9, 3.537872049059258*^9}, {
   3.537872138421897*^9, 3.537872144006673*^9}, {3.537872196836445*^9, 
   3.53787224947705*^9}, {3.5378722878468122`*^9, 3.537872372883222*^9}, {
   3.537872490150178*^9, 3.537872496093255*^9}, {3.537872547385435*^9, 
   3.537872561998753*^9}, {3.537872800792879*^9, 3.5378728967451353`*^9}, {
   3.537872969967389*^9, 3.537872993322166*^9}, {3.5378733845638*^9, 
   3.537873523491342*^9}, {3.537874990501849*^9, 3.5378750749448233`*^9}, {
   3.538046326178605*^9, 3.5380463263452587`*^9}, {3.538046359506956*^9, 
   3.5380464610359497`*^9}, {3.538046502103581*^9, 3.538046513481264*^9}, {
   3.53804657410702*^9, 3.538046614577108*^9}, {3.53804665505602*^9, 
   3.538046715360199*^9}, {3.538046757351519*^9, 3.53804676998315*^9}, {
   3.5380468595384607`*^9, 3.5380468659616413`*^9}, {3.538046897437215*^9, 
   3.538046897572302*^9}, {3.538047066640044*^9, 3.538047074544244*^9}, {
   3.538047229999874*^9, 3.5380472836305647`*^9}, {3.538047353035921*^9, 
   3.538047363818179*^9}, {3.538047476249525*^9, 3.538047522111104*^9}, {
   3.5380475966181917`*^9, 3.5380475967702713`*^9}, {3.538047801532692*^9, 
   3.538047822201064*^9}, {3.538047948516816*^9, 3.538047948684765*^9}, {
   3.538114366350466*^9, 3.5381144299925222`*^9}, {3.538114576757052*^9, 
   3.5381146749454412`*^9}, {3.538114791107875*^9, 3.5381148266944447`*^9}, {
   3.538114878968347*^9, 3.538115127215603*^9}, {3.53811552595366*^9, 
   3.538115590252236*^9}, {3.5381156363832006`*^9, 3.538115704042387*^9}, {
   3.53811589099817*^9, 3.53811590783984*^9}, {3.538115999280501*^9, 
   3.5381160364460382`*^9}, 3.538116068499432*^9, {3.5381163172614202`*^9, 
   3.5381163185592117`*^9}, 3.538116587083933*^9, {3.538116795975728*^9, 
   3.5381167961435547`*^9}, {3.538116915101754*^9, 3.538116916845715*^9}, {
   3.538117082639504*^9, 3.5381170838467207`*^9}, {3.538117120446578*^9, 
   3.538117121605109*^9}, {3.538117912630061*^9, 3.5381179255489893`*^9}, {
   3.538118168821506*^9, 3.538118170682723*^9}, {3.5381182778513527`*^9, 
   3.538118288943109*^9}, {3.5381183580154047`*^9, 3.5381183581193533`*^9}, {
   3.538118848337666*^9, 3.538118920486744*^9}, {3.538119184188271*^9, 
   3.53811918440349*^9}, {3.5381193489118156`*^9, 3.538119350612996*^9}, {
   3.538119892508926*^9, 3.538119895751055*^9}, {3.538119927591441*^9, 
   3.538119936248074*^9}, {3.538120029047421*^9, 3.538120037965654*^9}, {
   3.538120194027095*^9, 3.538120201471917*^9}, {3.53812028017563*^9, 
   3.538120301265314*^9}, {3.5381381252717533`*^9, 3.538138126469459*^9}, {
   3.538328246372367*^9, 3.5383282504354353`*^9}, {3.5383283005077343`*^9, 
   3.538328335488717*^9}, {3.538329001230315*^9, 3.538329010372521*^9}, {
   3.5383292041149054`*^9, 3.538329214953123*^9}, {3.5383314262207823`*^9, 
   3.538331427882743*^9}, {3.538467415297628*^9, 3.538467417025399*^9}, {
   3.538467483475766*^9, 3.538467496260305*^9}, {3.53846768282121*^9, 
   3.538467684491909*^9}, 3.538467751698575*^9, 3.538467834293067*^9, 
   3.538467910310305*^9, {3.538474665252652*^9, 3.5384747132015*^9}, {
   3.53847578605576*^9, 3.538475802638404*^9}, {3.538483710131217*^9, 
   3.5384837122828617`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"veclist", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.868`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.07409605574209051`", ",", "2.120168551991567`", ",", 
         "0.9979641465626632`", ",", 
         RowBox[{"-", "0.13206619699953426`"}], ",", "0.1096803066408052`", 
         ",", "1.8798507183251827`", ",", 
         RowBox[{"-", "1.8883455741980362`"}], ",", 
         RowBox[{"-", "1.8849422184581242`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8630000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.10094946961325645`", ",", "2.11843896557585`", ",", 
         "0.996221622879231`", ",", 
         RowBox[{"-", "0.1804917165177124`"}], ",", "0.1492701497125977`", 
         ",", "1.884992279481818`", ",", 
         RowBox[{"-", "1.9007800178918746`"}], ",", 
         RowBox[{"-", "1.8930351877297216`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.858`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.12197000170131408`", ",", "2.1167233983193694`", ",", 
         "0.9944850339762491`", ",", 
         RowBox[{"-", "0.21876327909130314`"}], ",", "0.1801886009746716`", 
         ",", "1.8900978504268293`", ",", 
         RowBox[{"-", "1.9131742069140136`"}], ",", 
         RowBox[{"-", "1.9016726924990976`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8530000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.13991378424453033`", ",", "2.1149837348926606`", ",", 
         "0.9927440162648846`", ",", 
         RowBox[{"-", "0.2517293820681301`"}], ",", "0.20648020601257608`", 
         ",", "1.8952275889273653`", ",", 
         RowBox[{"-", "1.9256311591239745`"}], ",", 
         RowBox[{"-", "1.909808191488722`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.848`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.1558346013771002`", ",", "2.113225412671581`", ",", 
         "0.9910000469003952`", ",", 
         RowBox[{"-", "0.28124731545350495`"}], ",", "0.22972733575964316`", 
         ",", "1.900372935353736`", ",", 
         RowBox[{"-", "1.9381362448249575`"}], ",", 
         RowBox[{"-", "1.9180104248625407`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8430000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17016875000194848`", ",", "2.1115098780778703`", ",", 
         "0.9892697750637398`", ",", 
         RowBox[{"-", "0.3080592423512553`"}], ",", "0.2506153749130479`", 
         ",", "1.9054371593492085`", ",", 
         RowBox[{"-", "1.9505236948034614`"}], ",", 
         RowBox[{"-", "1.9261627936566683`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.84`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17826167507411272`", ",", "2.1104559051192573`", ",", 
         "0.9882259326796118`", ",", 
         RowBox[{"-", "0.32330581600520547`"}], ",", "0.26236779856342607`", 
         ",", "1.9085078859494449`", ",", 
         RowBox[{"-", "1.9580215612745053`"}], ",", 
         RowBox[{"-", "1.931121256897245`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.82`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.22488694197749054`", ",", "2.103380714521802`", ",", 
         "0.9812728968525489`", ",", 
         RowBox[{"-", "0.41286781222427793`"}], ",", "0.3296044742182707`", 
         ",", "1.9289306281682954`", ",", 
         RowBox[{"-", "2.008120303091178`"}], ",", 
         RowBox[{"-", "1.9650601848404534`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.263403558765456`", ",", "2.096205608174961`", ",", 
         "0.9743256730333851`", ",", 
         RowBox[{"-", "0.48939211154605033`"}], ",", "0.3843975474769295`", 
         ",", "1.9492937907951573`", ",", 
         RowBox[{"-", "2.05845848599753`"}], ",", 
         RowBox[{"-", "1.9995561358962997`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.78`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.29697518455095745`", ",", "2.0889423128476263`", ",", 
         "0.9673869185290676`", ",", 
         RowBox[{"-", "0.558279652709024`"}], ",", "0.4315291947985173`", ",",
          "1.9695814694547868`", ",", 
         RowBox[{"-", "2.1090091196394116`"}], ",", 
         RowBox[{"-", "2.0352685093571585`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.76`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.3271598204456268`", ",", "2.081567124294121`", ",", 
         "0.9604497669481518`", ",", 
         RowBox[{"-", "0.6221486306454592`"}], ",", "0.47328486423405836`", 
         ",", "1.9898325723528631`", ",", 
         RowBox[{"-", "2.1598388644472086`"}], ",", 
         RowBox[{"-", "2.071552595488018`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7200000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.3805021914087528`", ",", "2.066514870321669`", ",", 
         "0.9465874464830879`", ",", 
         RowBox[{"-", "0.7400039977668367`"}], ",", "0.5455047926770815`", 
         ",", "2.0301803808864767`", ",", 
         RowBox[{"-", "2.2622601874863317`"}], ",", 
         RowBox[{"-", "2.1473061767619304`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7000000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.4046128853375105`", ",", "2.0588198731087877`", ",", 
         "0.9396565452523309`", ",", 
         RowBox[{"-", "0.795537154126863`"}], ",", "0.5773661902403812`", ",",
          "2.0503081121045224`", ",", 
         RowBox[{"-", "2.3139052814335432`"}], ",", 
         RowBox[{"-", "2.186433658947585`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6800000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.42738986570203724`", ",", "2.0510415737040817`", ",", 
         "0.932732941463491`", ",", 
         RowBox[{"-", "0.8493817405747806`"}], ",", "0.607017515193857`", ",",
          "2.070362854344421`", ",", 
         RowBox[{"-", "2.3657698062065`"}], ",", 
         RowBox[{"-", "2.226488748803607`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6600000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.4490644897242795`", ",", "2.0431503052332096`", ",", 
         "0.9258082749841597`", ",", 
         RowBox[{"-", "0.9019290716600774`"}], ",", "0.6347851658005186`", 
         ",", "2.090391510684943`", ",", 
         RowBox[{"-", "2.4179342410329308`"}], ",", 
         RowBox[{"-", "2.2678968345073445`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.62`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.48966127102623513`", ",", "2.0270829673417428`", ",", 
         "0.9119680934315914`", ",", 
         RowBox[{"-", "1.0038852676290009`"}], ",", "0.6855185237246182`", 
         ",", "2.13029486109991`", ",", 
         RowBox[{"-", "2.5230393049728153`"}], ",", 
         RowBox[{"-", "2.3528071117321376`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5088314372895092`", ",", "2.018878236095998`", ",", 
         "0.9050440626366997`", ",", 
         RowBox[{"-", "1.0536960221886291`"}], ",", "0.7088332820279133`", 
         ",", "2.1502152257033487`", ",", 
         RowBox[{"-", "2.5760592963152127`"}], ",", 
         RowBox[{"-", "2.3967672740185004`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.58`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5273545275263245`", ",", "2.010575258529651`", ",", 
         "0.8981208966176263`", ",", 
         RowBox[{"-", "1.1028793495786011`"}], ",", "0.7309985511711032`", 
         ",", "2.170093522850811`", ",", 
         RowBox[{"-", "2.6293577550798335`"}], ",", 
         RowBox[{"-", "2.442127737440482`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.56`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5453077255774209`", ",", "2.0021626572013895`", ",", 
         "0.8911951179108348`", ",", 
         RowBox[{"-", "1.1515364877849836`"}], ",", "0.7520675842519604`", 
         ",", "2.189947276035549`", ",", 
         RowBox[{"-", "2.682965705949222`"}], ",", 
         RowBox[{"-", "2.4880947291761606`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.52`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5797281594432059`", ",", "1.9850115064241494`", ",", 
         "0.8773345210374353`", ",", 
         RowBox[{"-", "1.2476078725156199`"}], ",", "0.7913395670399445`", 
         ",", "2.229582003315571`", ",", 
         RowBox[{"-", "2.791119378501514`"}], ",", 
         RowBox[{"-", "2.5830794221371645`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5962865178030728`", ",", "1.9762766204423838`", ",", 
         "0.8703996350381962`", ",", 
         RowBox[{"-", "1.2951477748864133`"}], ",", "0.8097010177996378`", 
         ",", "2.2493599143445286`", ",", 
         RowBox[{"-", "2.845665400722957`"}], ",", 
         RowBox[{"-", "2.6321062777511957`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.48`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6124714214301092`", ",", "1.9674207398689028`", ",", 
         "0.8634571985828617`", ",", 
         RowBox[{"-", "1.3424501191023754`"}], ",", "0.8272732318349333`", 
         ",", "2.2691341396915985`", ",", 
         RowBox[{"-", "2.9005642737031407`"}], ",", 
         RowBox[{"-", "2.6822204172706203`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.44`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6438209671286115`", ",", "1.9493940340092228`", ",", 
         "0.849559994780463`", ",", 
         RowBox[{"-", "1.4364446858730455`"}], ",", "0.8603685854903844`", 
         ",", "2.308605812587862`", ",", 
         RowBox[{"-", "3.011326105997462`"}], ",", 
         RowBox[{"-", "2.7860539537726856`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.4200000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6590456785721874`", ",", "1.9402159607617797`", ",", 
         "0.8426022906426062`", ",", 
         RowBox[{"-", "1.4832140488394734`"}], ",", "0.8759550669907962`", 
         ",", "2.328315490980453`", ",", 
         RowBox[{"-", "3.067216233533839`"}], ",", 
         RowBox[{"-", "2.839376372487654`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.3800000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6887287617582241`", ",", "1.9215013977136444`", ",", 
         "0.8286586577921988`", ",", 
         RowBox[{"-", "1.5764938761555642`"}], ",", "0.9053719458902377`", 
         ",", "2.367726088123225`", ",", 
         RowBox[{"-", "3.1801001723213007`"}], ",", 
         RowBox[{"-", "2.9494204405805933`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.36`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7032264406191593`", ",", "1.911966636481573`", ",", 
         "0.8216720594144495`", ",", 
         RowBox[{"-", "1.6230575588931981`"}], ",", "0.9192800184979449`", 
         ",", "2.3874262771487995`", ",", 
         RowBox[{"-", "3.2371024942745943`"}], ",", 
         RowBox[{"-", "3.0061441868231955`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.34`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7175184633466903`", ",", "1.9023140363077047`", ",", 
         "0.8146750132812847`", ",", 
         RowBox[{"-", "1.6695961776918746`"}], ",", "0.9326989945280368`", 
         ",", "2.4071224483050213`", ",", 
         RowBox[{"-", "3.2944823760345705`"}], ",", 
         RowBox[{"-", "3.0640137430428847`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.32`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7316236278236997`", ",", "1.892538357642916`", ",", 
         "0.8076656225360733`", ",", 
         RowBox[{"-", "1.716138544533985`"}], ",", "0.9456473034737107`", ",",
          "2.4268225920081994`", ",", 
         RowBox[{"-", "3.352257372105316`"}], ",", 
         RowBox[{"-", "3.1230544109686846`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.28`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.759327630044047`", ",", "1.8726252884090915`", ",", 
         "0.7936093988176277`", ",", 
         RowBox[{"-", "1.8092946252978641`"}], ",", "0.9702715256209089`", 
         ",", "2.4662250249723754`", ",", 
         RowBox[{"-", "3.468998672177377`"}], ",", 
         RowBox[{"-", "3.244691808425779`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.23`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.793157516173759`", ",", "1.8470221833116771`", ",", 
         "0.7759543195536678`", ",", 
         RowBox[{"-", "1.926084168284337`"}], ",", "0.9988649230120109`", ",",
          "2.5155298343116375`", ",", 
         RowBox[{"-", "3.6172923759074913`"}], ",", 
         RowBox[{"-", "3.403639782925374`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.18`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.8262833012364006`", ",", "1.8205837200802935`", ",", 
         "0.7581849149437223`", ",", 
         RowBox[{"-", "2.043517834789346`"}], ",", "1.0252809707518953`", ",",
          "2.564951928019079`", ",", 
         RowBox[{"-", "3.768399956744153`"}], ",", 
         RowBox[{"-", "3.5705963723620657`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.03`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.9230488688213225`", ",", "1.73588609398436`", ",", 
         "0.7039940643249193`", ",", 
         RowBox[{"-", "2.4019805149276023`"}], ",", "1.0942543883857436`", 
         ",", "2.7143508760863733`", ",", 
         RowBox[{"-", "4.240489973931262`"}], ",", 
         RowBox[{"-", "4.123436603974003`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.98`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.9549279981238569`", ",", "1.7056750601798654`", ",", 
         "0.6855521428817635`", ",", 
         RowBox[{"-", "2.5242985092271657`"}], ",", "1.114555308899134`", ",",
          "2.7647280495543316`", ",", 
         RowBox[{"-", "4.404914229188696`"}], ",", 
         RowBox[{"-", "4.326628213569345`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9299999999999999`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.986857615616634`", ",", "1.6743550719995128`", ",", 
         "0.6668700888623107`", ",", 
         RowBox[{"-", "2.6484410797834674`"}], ",", "1.1338173625182217`", 
         ",", "2.815515897460275`", ",", 
         RowBox[{"-", "4.573359485184544`"}], ",", 
         RowBox[{"-", "4.540306961248853`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.88`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0189782070091018`", ",", "1.6418495888986004`", ",", 
         "0.6479144619747503`", ",", 
         RowBox[{"-", "2.7746598884801315`"}], ",", "1.1522566054543582`", 
         ",", "2.8667820124242054`", ",", 
         RowBox[{"-", "4.746155719065648`"}], ",", 
         RowBox[{"-", "4.76514244154874`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8300000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0514363539949725`", ",", "1.6080712188475348`", ",", 
         "0.6286476155983801`", ",", 
         RowBox[{"-", "2.903241545154152`"}], ",", "1.1701212378997488`", ",",
          "2.9185998862859255`", ",", 
         RowBox[{"-", "4.923682903219094`"}], ",", 
         RowBox[{"-", "5.002008900278566`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.78`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0844010454097461`", ",", "1.572887661093316`", ",", 
         "0.6090193365955197`", ",", 
         RowBox[{"-", "3.034504887082299`"}], ",", "1.1875031258439983`", ",",
          "2.971090532668834`", ",", 
         RowBox[{"-", "5.106421449956452`"}], ",", 
         RowBox[{"-", "5.251811873544956`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.73`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1180479966266779`", ",", "1.5361730163991627`", ",", 
         "0.588978613592471`", ",", 
         RowBox[{"-", "3.1688120759508878`"}], ",", "1.2046503944973106`", 
         ",", "3.024353579034675`", ",", 
         RowBox[{"-", "5.294886464737035`"}], ",", 
         RowBox[{"-", "5.515627155864887`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.6799999999999999`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1525837188902464`", ",", "1.4977570080308695`", ",", 
         "0.568461058774028`", ",", 
         RowBox[{"-", "3.306576091782493`"}], ",", "1.2217108459212238`", ",",
          "3.078528825897698`", ",", 
         RowBox[{"-", "5.489706657652221`"}], ",", 
         RowBox[{"-", "5.794792774146105`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.63`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1882418065099052`", ",", "1.4574526479500487`", ",", 
         "0.5473946051470174`", ",", 
         RowBox[{"-", "3.44828153950453`"}], ",", "1.2389675741800101`", ",", 
         "3.1337571079417206`", ",", 
         RowBox[{"-", "5.69160646740515`"}], ",", 
         RowBox[{"-", "6.091006264154231`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.58`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.225305531795742`", ",", "1.415017305618747`", ",", 
         "0.5256894636474833`", ",", 
         RowBox[{"-", "3.5945070249561994`"}], ",", "1.2566285813178981`", 
         ",", "3.190224734457376`", ",", 
         RowBox[{"-", "5.901477288136015`"}], ",", 
         RowBox[{"-", "6.406073534076588`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.53`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.2641202878210855`", ",", "1.3701532912838383`", ",", 
         "0.5032367592682069`", ",", 
         RowBox[{"-", "3.745944023702552`"}], ",", "1.2749492456089138`", ",",
          "3.2481515787097424`", ",", 
         RowBox[{"-", "6.12039536605819`"}], ",", 
         RowBox[{"-", "6.742346946394514`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.48`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3051173605423914`", ",", "1.3224924070876931`", ",", 
         "0.47990281899507703`", ",", 
         RowBox[{"-", "3.903453166116109`"}], ",", "1.2942804705700126`", ",",
          "3.3078010338537096`", ",", 
         RowBox[{"-", "6.3496994746537645`"}], ",", 
         RowBox[{"-", "7.102722008787847`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.42999999999999994`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3488591460162878`", ",", "1.271548393431121`", ",", 
         "0.4555152710323542`", ",", 
         RowBox[{"-", "4.0681096407769`"}], ",", "1.3149514902873514`", ",", 
         "3.3695179164521227`", ",", 
         RowBox[{"-", "6.591085402958407`"}], ",", 
         RowBox[{"-", "7.490873737285019`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.38`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3960957591064582`", ",", "1.216685753047732`", ",", 
         "0.42985107157498326`", ",", 
         RowBox[{"-", "4.241312742141526`"}], ",", "1.337427292084789`", ",", 
         "3.4337399590177204`", ",", 
         RowBox[{"-", "6.84675801294185`"}], ",", 
         RowBox[{"-", "7.911597762080053`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.32999999999999996`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.447873230106782`", ",", "1.1570340351583543`", ",", 
         "0.4026093032641672`", ",", 
         RowBox[{"-", "4.4249325467136185`"}], ",", "1.3622900283129145`", 
         ",", "3.501054633931335`", ",", 
         RowBox[{"-", "7.119675995248774`"}], ",", 
         RowBox[{"-", "8.371305919012228`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.28`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.5057236960045268`", ",", "1.0913518674675085`", ",", 
         "0.373367196787542`", ",", 
         RowBox[{"-", "4.621576053138501`"}], ",", "1.390318997704208`", ",", 
         "3.572281474924267`", ",", 
         RowBox[{"-", "7.413971974028285`"}], ",", 
         RowBox[{"-", "8.878975020794677`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.22999999999999998`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.57203980735116`", ",", "1.0177678673734798`", ",", 
         "0.34149736181382523`", ",", 
         RowBox[{"-", "4.835076798074535`"}], ",", "1.4226214179605465`", ",",
          "3.6486273990264926`", ",", 
         RowBox[{"-", "7.735734242987447`"}], ",", 
         RowBox[{"-", "9.44782848881641`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.07999999999999985`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.8892842980600542`", ",", "0.7021647764329307`", ",", 
         "0.21477094825370602`", ",", 
         RowBox[{"-", "5.668698911077289`"}], ",", "1.571068461292025`", ",", 
         "3.937321470523456`", ",", 
         RowBox[{"-", "9.011955267383346`"}], ",", 
         RowBox[{"-", "11.838448294690265`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.030000000000000027`", ",", 
       RowBox[{"{", 
        RowBox[{
        "2.14505629502275`", ",", "0.5002442116584971`", ",", 
         "0.14210334806045316`", ",", 
         RowBox[{"-", "6.127329861034945`"}], ",", "1.6695931030439755`", ",",
          "4.090153831975672`", ",", 
         RowBox[{"-", "9.72589898707181`"}], ",", 
         RowBox[{"-", "13.263510038735388`"}]}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "10"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"veclist", "[", 
  RowBox[{"[", "pos", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.543869146102605*^9, 3.54386916194459*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.78`", ",", 
   RowBox[{"{", 
    RowBox[{
    "0.29697518455095745`", ",", "2.0889423128476263`", ",", 
     "0.9673869185290676`", ",", 
     RowBox[{"-", "0.558279652709024`"}], ",", "0.4315291947985173`", ",", 
     "1.9695814694547868`", ",", 
     RowBox[{"-", "2.1090091196394116`"}], ",", 
     RowBox[{"-", "2.0352685093571585`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.543870699014021*^9, 3.5438974632465067`*^9, {3.544176797272922*^9, 
   3.544176810296845*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", 
    RowBox[{"-", "2"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"veclist", "[", 
  RowBox[{"[", "pos", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5438974702824497`*^9, 3.5438974936199408`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.07999999999999985`", ",", 
   RowBox[{"{", 
    RowBox[{
    "1.8892842980600542`", ",", "0.7021647764329307`", ",", 
     "0.21477094825370602`", ",", 
     RowBox[{"-", "5.668698911077289`"}], ",", "1.571068461292025`", ",", 
     "3.937321470523456`", ",", 
     RowBox[{"-", "9.011955267383346`"}], ",", 
     RowBox[{"-", "11.838448294690265`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.543897471398058*^9, 3.5438974941642447`*^9}, {
   3.543903395306219*^9, 3.5439033994374866`*^9}, 3.543984943190824*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", 
    RowBox[{"-", "4"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"veclist", "[", 
  RowBox[{"[", "pos", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.543904987541423*^9, 3.543904987620802*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.28`", ",", 
   RowBox[{"{", 
    RowBox[{
    "1.5057236960045268`", ",", "1.0913518674675085`", ",", 
     "0.373367196787542`", ",", 
     RowBox[{"-", "4.621576053138501`"}], ",", "1.390318997704208`", ",", 
     "3.572281474924267`", ",", 
     RowBox[{"-", "7.413971974028285`"}], ",", 
     RowBox[{"-", "8.878975020794677`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.543904988405908*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", 
    RowBox[{"-", "15"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"veclist", "[", 
  RowBox[{"[", "pos", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.544359736524322*^9, 3.544359736604233*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8300000000000001`", ",", 
   RowBox[{"{", 
    RowBox[{
    "1.0514363539949725`", ",", "1.6080712188475348`", ",", 
     "0.6286476155983801`", ",", 
     RowBox[{"-", "2.903241545154152`"}], ",", "1.1701212378997488`", ",", 
     "2.9185998862859255`", ",", 
     RowBox[{"-", "4.923682903219094`"}], ",", 
     RowBox[{"-", "5.002008900278566`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.544359737152526*^9, 3.544359740846984*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", 
    RowBox[{"-", "10"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"veclist", "[", 
  RowBox[{"[", "pos", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.543869146102605*^9, 3.54386916194459*^9}, {
  3.543900205228382*^9, 3.5439002066761827`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.58`", ",", 
   RowBox[{"{", 
    RowBox[{
    "1.225305531795742`", ",", "1.415017305618747`", ",", 
     "0.5256894636474833`", ",", 
     RowBox[{"-", "3.5945070249561994`"}], ",", "1.2566285813178981`", ",", 
     "3.190224734457376`", ",", 
     RowBox[{"-", "5.901477288136015`"}], ",", 
     RowBox[{"-", "6.406073534076588`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.543870699014021*^9, 3.5438974632465067`*^9, 3.543900207300161*^9, 
   3.543906185472377*^9, 3.543993508782652*^9, 3.543993873310853*^9, {
   3.544013070181954*^9, 3.5440130741741257`*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{
     RowBox[{"veclist", "[", 
      RowBox[{"[", 
       RowBox[{"pos", ",", "2"}], "]"}], "]"}], ",", "30"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.538395488974235*^9, 3.538395494671344*^9}, {
  3.538475270148683*^9, 3.538475278100976*^9}, {3.5384753323016653`*^9, 
  3.538475399427929*^9}, {3.5384755290732517`*^9, 3.538475544392206*^9}, {
  3.543869127892708*^9, 3.54386915139429*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"q", "=", 
    RowBox[{"SetPrecision", "[", 
     RowBox[{
      RowBox[{"veclist", "[", 
       RowBox[{"[", 
        RowBox[{"pos", ",", "1"}], "]"}], "]"}], ",", "30"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"z0", "=", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{"1.0", ",", "30"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5384755568817177`*^9, 3.5384755586157703`*^9}, {
  3.5384757492560873`*^9, 3.538475756552244*^9}, {3.543869138276383*^9, 
  3.5438691571702213`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq0", "=", 
  RowBox[{"inteq", "[", 
   RowBox[{"z0", ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "5", "]"}], "]"}], ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "6", "]"}], "]"}], ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "7", "]"}], "]"}], ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.53847589349119*^9, 3.5384758939548798`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9919927466159977920609533199255648442044683131143476195461`\
25.\\)\[NoBreak], step size is effectively zero; singularity or stiff system \
suspected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", \
ButtonNote -> \\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.544359748602953*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.0000853312680432104111585908479396764428800706437277205584`20.\
48749350027643", ",", 
   RowBox[{
   "-", "0.0000137856376897252125985371044181999847001606649666514507`19.\
81496248202689"}], ",", 
   "0.0000299636019038220232771671085425033829529531196363246887`19.\
483207484712505", ",", 
   RowBox[{
   "-", "0.0006532923739875875229048171237655817305011263879540486635`21.\
13491375131682"}], ",", 
   RowBox[{
   "-", "4.3204176498339607574825251618999847763419512730428804`19.\
019797429599375*^-6"}], ",", 
   "0.001063852766144517447397703402255838642654198580430047399`18.\
802328005049098", ",", 
   "0.0005456321719394377576761596025819427688232022717269137095`17.\
96261331328103", ",", 
   RowBox[{
   "-", "0.0000796284516132627347882247077397294770417266806958423514`17.\
505296643096585"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.543897478014126*^9, 3.543897497621963*^9}, {
   3.5439002220672626`*^9, 3.543900236532469*^9}, 3.543904996068302*^9, 
   3.543993514296494*^9, 3.544359748958366*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "eq0", "]"}]], "Input",
 CellChangeTimes->{{3.538475941247263*^9, 3.538475945849679*^9}}],

Cell[BoxData["17.505296643096585`"], "Output",
 CellChangeTimes->{3.5438975028884773`*^9, 3.5439002399421453`*^9, 
  3.543904997439242*^9, 3.543993517467445*^9, 3.544359749109573*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq0", "=", 
    RowBox[{"inteq", "[", 
     RowBox[{"z0", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "3", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "4", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "5", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "6", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "7", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DX", " ", "=", 
    RowBox[{"SetPrecision", "[", 
     RowBox[{"0.001", ",", "30"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"vec0", "=", "vec"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "-=", "DX"}], " ", ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"eq1", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"z0", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "+=", 
       RowBox[{"2", "*", "DX"}]}], " ", ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"eq2", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"z0", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"mat", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"eq2", "-", "eq1"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "DX"}], ")"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "8"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<det = \>\"", ",", 
     RowBox[{"Det", "[", "mat", "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dvec", "=", 
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{"Transpose", "[", "mat", "]"}], "]"}], ".", "eq0"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vec", " ", "=", " ", 
    RowBox[{"vec", "-", "dvec"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<vec = \>\"", ",", "vec", ",", "\"\<  ->  eq = \>\"", ",", "eq0"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.538120490121634*^9, 3.538120518932563*^9}, {
   3.5381205558741503`*^9, 3.538120610837431*^9}, {3.5381206659362717`*^9, 
   3.538120712255209*^9}, {3.5383285846229553`*^9, 3.538328585388818*^9}, {
   3.538328684844769*^9, 3.5383286852597733`*^9}, 3.538328770081517*^9, {
   3.5383289405611877`*^9, 3.5383289561436033`*^9}, {3.538329024216524*^9, 
   3.538329027272518*^9}, {3.538329231307086*^9, 3.538329245530115*^9}, {
   3.53832928014611*^9, 3.5383292802257977`*^9}, {3.538331899292232*^9, 
   3.538331918317177*^9}, {3.5383320080930357`*^9, 3.53833201029294*^9}, {
   3.5383320534615726`*^9, 3.538332054173419*^9}, {3.538332091130785*^9, 
   3.538332091290278*^9}, {3.538332148467001*^9, 3.538332166530912*^9}, {
   3.538332763655594*^9, 3.538332763839275*^9}, 3.538332811566271*^9, {
   3.5383329603107758`*^9, 3.538333014609095*^9}, {3.538372704879333*^9, 
   3.538372748091798*^9}, {3.538380094711239*^9, 3.538380095245941*^9}, {
   3.538475565399063*^9, 3.538475570349143*^9}, {3.538475761638802*^9, 
   3.5384757666307983`*^9}, {3.538475930088382*^9, 3.538475933711309*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "precw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The precision of the differential equation \
(\[NoBreak]\\!\\({\\(\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"p\\\", \\\"\
\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \
\\(\\(-\\(\\(\\(\\(\\(8\\\\ z\\^2\\\\ \\(a[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) - \\(\\(8\\\\ z\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\(h[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) + \\(\\(\\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 5 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\)\\)\\/\\(4\\\\ z\\^2\\\\ \\(p[z]\\)\
\\^2\\\\ \\(\\(S[z]\\)\\)\\\\ \\(T[z]\\)\\^2\\\\ \\(\\((\\(\\(-\\(\\(S[\\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\)\\)\\) + \\(\\(z\\\\ \\(\\(\\(\
\\(\\*SuperscriptBox[\\(\[LeftSkeleton] 1 \[RightSkeleton]\\), TagBox[\\((\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\))\\), Derivative], \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\
\\)\\)]\\)\\)\\)\\))\\)\\)\\)\\)\\)\\)\\)\\)\\), \
\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\[Prime]\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \\(\\(\\(8\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\)\\) - \\(\\(2\\\\ \
z\\^2\\\\ \\(\\(T[z]\\)\\)\\\\ \\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\\\ \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\)\\)\\)\\/\\(z\\^2\\\\ \
\\(\\(S[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\)\\)\\), \\(\\(\[LeftSkeleton] 10 \
\[RightSkeleton]\\)\\), \\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, \
None]]\\)\\)[0.0001000000000000000047921736023859295983129413798451423645`30.]\
\\)\\) \[Equal] \
\\(\\(-6.5325277956272088617108937425268609606472579074`18.640937195207844*^-\
12\\)\\)\\)\\)}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \
\\(\\({}\\)\\)}\\)\[NoBreak]) is less than WorkingPrecision \
(\[NoBreak]\\!\\(25.`\\)\[NoBreak]). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/precw\\\", \
ButtonNote -> \\\"NDSolve::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.5438975256611567`*^9, 3.543897545698044*^9}, 
   3.543897596893161*^9, 3.5439002485564623`*^9, 3.543900360299883*^9, 
   3.543900418347234*^9, 3.543905002006506*^9, 3.54390508125359*^9, 
   3.544359755408731*^9, 3.5443598266125317`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "precw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The precision of the differential equation \
(\[NoBreak]\\!\\({\\(\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"p\\\", \\\"\
\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \
\\(\\(-\\(\\(\\(\\(\\(8\\\\ z\\^2\\\\ \\(a[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) - \\(\\(8\\\\ z\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\(h[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) + \\(\\(\\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 5 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\)\\)\\/\\(4\\\\ z\\^2\\\\ \\(p[z]\\)\
\\^2\\\\ \\(\\(S[z]\\)\\)\\\\ \\(T[z]\\)\\^2\\\\ \\(\\((\\(\\(-\\(\\(S[\\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\)\\)\\) + \\(\\(z\\\\ \\(\\(\\(\
\\(\\*SuperscriptBox[\\(\[LeftSkeleton] 1 \[RightSkeleton]\\), TagBox[\\((\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\))\\), Derivative], \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\
\\)\\)]\\)\\)\\)\\))\\)\\)\\)\\)\\)\\)\\)\\)\\), \
\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\[Prime]\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \\(\\(\\(8\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\)\\) - \\(\\(2\\\\ \
z\\^2\\\\ \\(\\(T[z]\\)\\)\\\\ \\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\\\ \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\)\\)\\)\\/\\(z\\^2\\\\ \
\\(\\(S[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\)\\)\\), \\(\\(\[LeftSkeleton] 10 \
\[RightSkeleton]\\)\\), \\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, \
None]]\\)\\)[0.9998999999999999999952078263976140704016870586201548576355`33.\
99995656838019]\\)\\) \[Equal] \
\\(\\(-0.90891578913199836539327947070592460135`18.841600066524656\\)\\)\\)\\)\
}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\)}\\)\
\[NoBreak]) is less than WorkingPrecision \
(\[NoBreak]\\!\\(25.`\\)\[NoBreak]). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/precw\\\", \
ButtonNote -> \\\"NDSolve::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.5438975256611567`*^9, 3.543897545698044*^9}, 
   3.543897596893161*^9, 3.5439002485564623`*^9, 3.543900360299883*^9, 
   3.543900418347234*^9, 3.543905002006506*^9, 3.54390508125359*^9, 
   3.544359755408731*^9, 3.544359828089872*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "precw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The precision of the differential equation \
(\[NoBreak]\\!\\({\\(\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"p\\\", \\\"\
\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \
\\(\\(-\\(\\(\\(\\(\\(8\\\\ z\\^2\\\\ \\(a[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) - \\(\\(8\\\\ z\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\(h[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) + \\(\\(\\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 5 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\)\\)\\/\\(4\\\\ z\\^2\\\\ \\(p[z]\\)\
\\^2\\\\ \\(\\(S[z]\\)\\)\\\\ \\(T[z]\\)\\^2\\\\ \\(\\((\\(\\(-\\(\\(S[\\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\)\\)\\) + \\(\\(z\\\\ \\(\\(\\(\
\\(\\*SuperscriptBox[\\(\[LeftSkeleton] 1 \[RightSkeleton]\\), TagBox[\\((\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\))\\), Derivative], \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\
\\)\\)]\\)\\)\\)\\))\\)\\)\\)\\)\\)\\)\\)\\)\\), \
\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\[Prime]\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \\(\\(\\(8\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\)\\) - \\(\\(2\\\\ \
z\\^2\\\\ \\(\\(T[z]\\)\\)\\\\ \\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\\\ \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\)\\)\\)\\/\\(z\\^2\\\\ \
\\(\\(S[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\)\\)\\), \\(\\(\[LeftSkeleton] 10 \
\[RightSkeleton]\\)\\), \\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, \
None]]\\)\\)[0.0001000000000000000047921736023859295983129413798451423645`30.]\
\\)\\) \[Equal] \
\\(\\(-6.5325277956272088617108937425268609606472579074`18.640937195207844*^-\
12\\)\\)\\)\\)}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \
\\(\\({}\\)\\)}\\)\[NoBreak]) is less than WorkingPrecision \
(\[NoBreak]\\!\\(25.`\\)\[NoBreak]). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/precw\\\", \
ButtonNote -> \\\"NDSolve::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.5438975256611567`*^9, 3.543897545698044*^9}, 
   3.543897596893161*^9, 3.5439002485564623`*^9, 3.543900360299883*^9, 
   3.543900418347234*^9, 3.543905002006506*^9, 3.54390508125359*^9, 
   3.544359755408731*^9, 3.544359828641059*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "precw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The precision of the differential equation \
(\[NoBreak]\\!\\({\\(\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"p\\\", \\\"\
\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \
\\(\\(-\\(\\(\\(\\(\\(8\\\\ z\\^2\\\\ \\(a[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) - \\(\\(8\\\\ z\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\(h[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) + \\(\\(\\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 5 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\)\\)\\/\\(4\\\\ z\\^2\\\\ \\(p[z]\\)\
\\^2\\\\ \\(\\(S[z]\\)\\)\\\\ \\(T[z]\\)\\^2\\\\ \\(\\((\\(\\(-\\(\\(S[\\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\)\\)\\) + \\(\\(z\\\\ \\(\\(\\(\
\\(\\*SuperscriptBox[\\(\[LeftSkeleton] 1 \[RightSkeleton]\\), TagBox[\\((\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\))\\), Derivative], \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\
\\)\\)]\\)\\)\\)\\))\\)\\)\\)\\)\\)\\)\\)\\)\\), \
\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\[Prime]\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \\(\\(\\(8\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\)\\) - \\(\\(2\\\\ \
z\\^2\\\\ \\(\\(T[z]\\)\\)\\\\ \\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\\\ \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\)\\)\\)\\/\\(z\\^2\\\\ \
\\(\\(S[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\)\\)\\), \\(\\(\[LeftSkeleton] 10 \
\[RightSkeleton]\\)\\), \\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, \
None]]\\)\\)[0.9998999999999999999952078263976140704016870586201548576355`33.\
99995656838019]\\)\\) \[Equal] \
\\(\\(-0.90809427034079998427671721661217267583`18.841507725147277\\)\\)\\)\\)\
}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\)}\\)\
\[NoBreak]) is less than WorkingPrecision \
(\[NoBreak]\\!\\(25.`\\)\[NoBreak]). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/precw\\\", \
ButtonNote -> \\\"NDSolve::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.5438975256611567`*^9, 3.543897545698044*^9}, 
   3.543897596893161*^9, 3.5439002485564623`*^9, 3.543900360299883*^9, 
   3.543900418347234*^9, 3.543905002006506*^9, 3.54390508125359*^9, 
   3.544359755408731*^9, 3.544359830123419*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "precw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The precision of the differential equation \
(\[NoBreak]\\!\\({\\(\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"p\\\", \\\"\
\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \
\\(\\(-\\(\\(\\(\\(\\(8\\\\ z\\^2\\\\ \\(a[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) - \\(\\(8\\\\ z\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\(h[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) + \\(\\(\\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 5 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\)\\)\\/\\(4\\\\ z\\^2\\\\ \\(p[z]\\)\
\\^2\\\\ \\(\\(S[z]\\)\\)\\\\ \\(T[z]\\)\\^2\\\\ \\(\\((\\(\\(-\\(\\(S[\\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\)\\)\\) + \\(\\(z\\\\ \\(\\(\\(\
\\(\\*SuperscriptBox[\\(\[LeftSkeleton] 1 \[RightSkeleton]\\), TagBox[\\((\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\))\\), Derivative], \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\
\\)\\)]\\)\\)\\)\\))\\)\\)\\)\\)\\)\\)\\)\\)\\), \
\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\[Prime]\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \\(\\(\\(8\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\)\\) - \\(\\(2\\\\ \
z\\^2\\\\ \\(\\(T[z]\\)\\)\\\\ \\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\\\ \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\)\\)\\)\\/\\(z\\^2\\\\ \
\\(\\(S[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\)\\)\\), \\(\\(\[LeftSkeleton] 10 \
\[RightSkeleton]\\)\\), \\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, \
None]]\\)\\)[0.0001000000000000000047921736023859295983129413798451423645`30.]\
\\)\\) \[Equal] \
\\(\\(-6.5325277956272088617108937425268609606472579074`18.640937195207844*^-\
12\\)\\)\\)\\)}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \
\\(\\({}\\)\\)}\\)\[NoBreak]) is less than WorkingPrecision \
(\[NoBreak]\\!\\(25.`\\)\[NoBreak]). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/precw\\\", \
ButtonNote -> \\\"NDSolve::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.5438975256611567`*^9, 3.543897545698044*^9}, 
   3.543897596893161*^9, 3.5439002485564623`*^9, 3.543900360299883*^9, 
   3.543900418347234*^9, 3.543905002006506*^9, 3.54390508125359*^9, 
   3.544359755408731*^9, 3.544359830572968*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(NDSolve \
:: precw\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.5438975256611567`*^9, 3.543897545698044*^9}, 
   3.543897596893161*^9, 3.5439002485564623`*^9, 3.543900360299883*^9, 
   3.543900418347234*^9, 3.543905002006506*^9, 3.54390508125359*^9, 
   3.544359755408731*^9, 3.5443598305780287`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9996484879750189871957608007143424484839732325084512720444`\
25.\\)\[NoBreak], step size is effectively zero; singularity or stiff system \
suspected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", \
ButtonNote -> \\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.5438975256611567`*^9, 3.543897545698044*^9}, 
   3.543897596893161*^9, 3.5439002485564623`*^9, 3.543900360299883*^9, 
   3.543900418347234*^9, 3.543905002006506*^9, 3.54390508125359*^9, 
   3.544359755408731*^9, 3.5443598439085484`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9977811923440212225969402466454794566019276566303480373718`\
25.\\)\[NoBreak], step size is effectively zero; singularity or stiff system \
suspected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", \
ButtonNote -> \\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.5438975256611567`*^9, 3.543897545698044*^9}, 
   3.543897596893161*^9, 3.5439002485564623`*^9, 3.543900360299883*^9, 
   3.543900418347234*^9, 3.543905002006506*^9, 3.54390508125359*^9, 
   3.544359755408731*^9, 3.544359853777564*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9992655233108168699474825896904490399557979078962533000871`\
25.\\)\[NoBreak], step size is effectively zero; singularity or stiff system \
suspected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", \
ButtonNote -> \\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.5438975256611567`*^9, 3.543897545698044*^9}, 
   3.543897596893161*^9, 3.5439002485564623`*^9, 3.543900360299883*^9, 
   3.543900418347234*^9, 3.543905002006506*^9, 3.54390508125359*^9, 
   3.544359755408731*^9, 3.544359862095541*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(NDSolve \
:: ndsz\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.5438975256611567`*^9, 3.543897545698044*^9}, 
   3.543897596893161*^9, 3.5439002485564623`*^9, 3.543900360299883*^9, 
   3.543900418347234*^9, 3.543905002006506*^9, 3.54390508125359*^9, 
   3.544359755408731*^9, 3.54435986209748*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"det = \"\>", "\[InvisibleSpace]", 
   RowBox[{
   "-", "0.0015659765949672174109125037796557343239256213289927886065`16.\
727476235838623"}]}],
  SequenceForm[
  "det = ", \
-0.0015659765949672174109125037796557343239256213289927886065`16.\
727476235838623],
  Editable->False]], "Print",
 CellChangeTimes->{3.543897533602006*^9, 3.543897568394943*^9, 
  3.5438976198414927`*^9, 3.54390035642667*^9, 3.543900398716414*^9, 
  3.5439004573053083`*^9, 3.543905074135914*^9, 3.543905114324893*^9, 
  3.544359815555179*^9, 3.5443598688344593`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vec = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1.0514372429042203375562594196243562228373953569940051398153`19.\
575737080677218", ",", 
     "1.60806906929638127795544371494463124145`19.292411507784227", ",", 
     "0.6286470349209578111109977926158731683829688337958375306897`19.\
484682135155662", ",", 
     RowBox[{
     "-", "2.90336942339238371772102781826423056419`19.07274839606759"}], ",",
      "1.17014687176092472413088338629161576568`18.52453289805585", ",", 
     "2.91860268717924982569977129865931673798`19.35231759205413", ",", 
     RowBox[{
     "-", "4.92368667325038081812426738727014797736`19.292355909532297"}], 
     ",", 
     RowBox[{
     "-", "4.99184034619885460045701727438889923335`18.95896208462151"}]}], 
    "}"}], "\[InvisibleSpace]", "\<\"  ->  eq = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "7.31821740696696839218316714776117603064465364596452`17.68748321870983*^-\
8", ",", 
     RowBox[{
     "-", "2.3381175771033707446814139054208613853924301087501`17.\
274662682556908*^-8"}], ",", 
     "3.10528337393112385535199235201855044459663091570638`16.760253080875124*^\
-8", ",", 
     RowBox[{
     "-", "2.638611256692098642058618981537655738539805183976831`17.\
970848948424678*^-7"}], ",", 
     RowBox[{
     "-", "4.5747147341759474357293336331408111008814347011298`16.\
30569423668926*^-9"}], ",", 
     "1.1414082018273824752467564979652057505235991852841482`16.\
521015095752215*^-6", ",", 
     "5.809155003156249238737609464565007666067112188358008`15.67049524187497*^\
-7", ",", 
     RowBox[{
     "-", "9.14765602697320368193210420164516998075559842304354`15.\
250420566952405*^-8"}]}], "}"}]}],
  SequenceForm[
  "vec = ", {
   1.0514372429042203375562594196243562228373953569940051398153`19.\
575737080677218, 1.60806906929638127795544371494463124145`19.292411507784227, 
    0.6286470349209578111109977926158731683829688337958375306897`19.\
484682135155662, -2.90336942339238371772102781826423056419`19.07274839606759, 
    1.17014687176092472413088338629161576568`18.52453289805585, 
    2.91860268717924982569977129865931673798`19.35231759205413, \
-4.92368667325038081812426738727014797736`19.292355909532297, \
-4.99184034619885460045701727438889923335`18.95896208462151}, "  ->  eq = ", {
   7.31821740696696839218316714776117603064465364596452`17.68748321870983*^-8,\
 -2.3381175771033707446814139054208613853924301087501`17.274662682556908*^-8, 
    3.10528337393112385535199235201855044459663091570638`16.760253080875124*^-\
8, -2.638611256692098642058618981537655738539805183976831`17.970848948424678*^\
-7, -4.5747147341759474357293336331408111008814347011298`16.30569423668926*^-\
9, 1.1414082018273824752467564979652057505235991852841482`16.521015095752215*^\
-6, 5.809155003156249238737609464565007666067112188358008`15.67049524187497*^-\
7, -9.14765602697320368193210420164516998075559842304354`15.250420566952405*^-\
8}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543897533602006*^9, 3.543897568394943*^9, 
  3.5438976198414927`*^9, 3.54390035642667*^9, 3.543900398716414*^9, 
  3.5439004573053083`*^9, 3.543905074135914*^9, 3.543905114324893*^9, 
  3.544359815555179*^9, 3.5443598688365726`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["vec"], "Input",
 CellChangeTimes->{{3.543869312139802*^9, 3.5438693125224667`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.0514372429042203375562594196243562228373953569940051398153`19.\
575737080677218", ",", 
   "1.60806906929638127795544371494463124145`19.292411507784227", ",", 
   "0.6286470349209578111109977926158731683829688337958375306897`19.\
484682135155662", ",", 
   RowBox[{
   "-", "2.90336942339238371772102781826423056419`19.07274839606759"}], ",", 
   "1.17014687176092472413088338629161576568`18.52453289805585", ",", 
   "2.91860268717924982569977129865931673798`19.35231759205413", ",", 
   RowBox[{
   "-", "4.92368667325038081812426738727014797736`19.292355909532297"}], ",", 
   RowBox[{
   "-", "4.99184034619885460045701727438889923335`18.95896208462151"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.543897648022059*^9, 3.543900603721711*^9, 
  3.5439051821324177`*^9, 3.544359868922455*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "pos"}], "=", "10"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"vec", "=", 
    RowBox[{"SetPrecision", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "0.29697363542613545937691590416647227748`17.20250397781238", ",", 
        "2.08894358534780424367318105192768800917`18.13685924825164", ",", 
        "0.96738725367736208075386374888031263026`18.372428591509202", ",", 
        RowBox[{
        "-", "0.55827474229845810904233306344697176166`17.107865265240648"}], 
        ",", "0.43154252960170968610754051615184673972`17.519179915607896", 
        ",", "1.96957958849580014784243259519123048591`17.91790748377006", 
        ",", 
        RowBox[{
        "-", "2.10900610437849584091238444794489094089`17.710818168552525"}], 
        ",", 
        RowBox[{
        "-", "2.02035177575709567233601406563594564888`17.505433280375204"}]}]\
, "}"}], ",", "30"}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.538395488974235*^9, 3.538395494671344*^9}, {
   3.538487155497856*^9, 3.5384871600489283`*^9}, {3.538487422110376*^9, 
   3.53848743906916*^9}, 3.543869321101018*^9, {3.543897522162199*^9, 
   3.5438975310016108`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "pos"}], "=", 
    RowBox[{"-", "2"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"vec", "=", 
    RowBox[{"SetPrecision", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "1.8892844524867614437504491639893515186971844353659410873146`20.\
22423459005405", ",", 
        "0.7021645475278859333939346880403492965507353157484182216638`19.\
17347823010585", ",", 
        "0.2147708913389526631402214769327323266982326252288431498949`19.\
313177032768163", ",", 
        RowBox[{
        "-", "5.66870034036873178374394749293889384491`19.150132294414927"}], 
        ",", "1.57105272049004662649142397540219506392`18.394179673138456", 
        ",", "3.93732173764543766712035444763577872493`19.459340637655462", 
        ",", 
        RowBox[{
        "-", "9.01195460356254563516825487611162135223`19.337931527630595"}], 
        ",", 
        RowBox[{
        "-", "11.82129051889452589779289842894425894981`19.025886865407752"}]}\
], "}"}], ",", "30"}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.543897655458242*^9, 3.543897671955442*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "pos"}], "=", 
    RowBox[{"-", "4"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"vec", "=", 
    RowBox[{"SetPrecision", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "1.5057237131236946149572585277001824715547604249937523528014`20.\
198489839014602", ",", 
        "1.0913520186069008169023962405756889384286004585925752288334`19.\
45425754351719", ",", 
        "0.3733671977741275317827716090449990681224663915491298672491`19.\
609798741566237", ",", 
        RowBox[{
        "-", "4.62160136115503603924571522000341036396`19.37673763017697"}], 
        ",", "1.3903207060443585196081175574042790746`18.643859092522224", 
        ",", "3.57228115704934353697166528552304459294`19.66148809577124", 
        ",", 
        RowBox[{
        "-", "7.41397203469514625133211363434975096847`19.578083192017885"}], 
        ",", 
        RowBox[{
        "-", "8.86898196995222814779997966770086529663`19.23867673419304"}]}],
        "}"}], ",", "30"}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.543905189672185*^9, 3.543905197098374*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "pos"}], "=", 
    RowBox[{"-", "15"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"vec", "=", 
    RowBox[{"SetPrecision", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "1.0514372429042203375562594196243562228373953569940051398153`19.\
575737080677218", ",", 
        "1.60806906929638127795544371494463124145`19.292411507784227", ",", 
        "0.6286470349209578111109977926158731683829688337958375306897`19.\
484682135155662", ",", 
        RowBox[{
        "-", "2.90336942339238371772102781826423056419`19.07274839606759"}], 
        ",", "1.17014687176092472413088338629161576568`18.52453289805585", 
        ",", "2.91860268717924982569977129865931673798`19.35231759205413", 
        ",", 
        RowBox[{
        "-", "4.92368667325038081812426738727014797736`19.292355909532297"}], 
        ",", 
        RowBox[{
        "-", "4.99184034619885460045701727438889923335`18.95896208462151"}]}],
        "}"}], ",", "30"}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.544359839464635*^9, 3.5443598523183823`*^9}, 
   3.544359882698133*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "pos"}], "=", 
    RowBox[{"-", "10"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"vec", "=", 
    RowBox[{"SetPrecision", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "1.2253058947424784588215155611788016165515547704948190356405`19.\
645376195503864", ",", 
        "1.41501644238059762867360974244311560369`19.174568259913467", ",", 
        "0.5256892109567251090535488404918756067355932361892882240715`19.\
351077820461178", ",", 
        RowBox[{
        "-", "3.5945959466535168245217380912834868539`19.025902052129865"}], 
        ",", "1.25663965001164235059577719311566080406`18.37333071547694", 
        ",", "3.1902258454721581346468094202216547031`19.297085788079837", 
        ",", 
        RowBox[{
        "-", "5.90147885173273852073711409536465271795`19.23740566531368"}], 
        ",", 
        RowBox[{
        "-", "6.39244021232910792635573669843619841537`18.876704127014893"}]}]\
, "}"}], ",", "30"}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.543900252999133*^9, 3.543900269953738*^9}, {
  3.543900610457769*^9, 3.543900611410213*^9}}],

Cell[CellGroupData[{

Cell[BoxData["q"], "Input",
 CellChangeTimes->{{3.5384871726643677`*^9, 3.538487176504283*^9}, 
   3.543869337075305*^9}],

Cell[BoxData["0.8300000000000000710542735760100185871124267578125`30."], \
"Output",
 CellChangeTimes->{3.5438707097180157`*^9, 3.54389767616061*^9, 
  3.543900613607512*^9, 3.543903420076044*^9, 3.543905198562233*^9, 
  3.543906194575984*^9, 3.5439849570510283`*^9, 3.543993524747137*^9, 
  3.54401308373941*^9, 3.54417682286864*^9, 3.544359886575349*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nsol", "=", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"inteq", "[", 
      RowBox[{
       RowBox[{"SetPrecision", "[", 
        RowBox[{"1.", ",", "30"}], "]"}], ",", "x1", ",", "q", ",", "x2", ",",
        "x3", ",", "x4", ",", "x5", ",", "x6", ",", "x7", ",", "x8", ",", 
       "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x3", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x4", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x5", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x6", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "6", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x7", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "7", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x8", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "8", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "25"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"inteq", "[", 
     RowBox[{
     "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", 
      ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", "nsol"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5383955289097357`*^9, 3.538395607280014*^9}, {
  3.5384675702538347`*^9, 3.538467573581067*^9}, {3.538467922768297*^9, 
  3.5384679239991417`*^9}, {3.5384871845792227`*^9, 3.538487189060872*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "precw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The precision of the differential equation \
(\[NoBreak]\\!\\({\\(\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"p\\\", \\\"\
\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \
\\(\\(-\\(\\(\\(\\(\\(8\\\\ z\\^2\\\\ \\(a[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) - \\(\\(8\\\\ z\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\(h[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) + \\(\\(\\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 5 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\)\\)\\/\\(4\\\\ z\\^2\\\\ \\(p[z]\\)\
\\^2\\\\ \\(\\(S[z]\\)\\)\\\\ \\(T[z]\\)\\^2\\\\ \\(\\((\\(\\(-\\(\\(S[\\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\)\\)\\) + \\(\\(z\\\\ \\(\\(\\(\
\\(\\*SuperscriptBox[\\(\[LeftSkeleton] 1 \[RightSkeleton]\\), TagBox[\\((\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\))\\), Derivative], \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\
\\)\\)]\\)\\)\\)\\))\\)\\)\\)\\)\\)\\)\\)\\)\\), \
\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\[Prime]\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \\(\\(\\(8\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\)\\) - \\(\\(2\\\\ \
z\\^2\\\\ \\(\\(T[z]\\)\\)\\\\ \\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\\\ \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\)\\)\\)\\/\\(z\\^2\\\\ \
\\(\\(S[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\)\\)\\), \\(\\(\[LeftSkeleton] 10 \
\[RightSkeleton]\\)\\), \\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, \
None]]\\)\\)[0.0001000000000000000047921736023859295983129413798451423645`30.]\
\\)\\) \[Equal] \
\\(\\(-6.5325312504207381400185388190178164059857175854`24.698963378980014*^-\
12\\)\\)\\)\\)}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \
\\(\\({}\\)\\)}\\)\[NoBreak]) is less than WorkingPrecision \
(\[NoBreak]\\!\\(25.`\\)\[NoBreak]). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/precw\\\", \
ButtonNote -> \\\"NDSolve::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543870710897341*^9, 3.543897677705892*^9, 
  3.543900614562106*^9, 3.54390342119906*^9, 3.543905200115779*^9, 
  3.543906195542021*^9, 3.543984967199746*^9, 3.543993525797584*^9, 
  3.544013085152*^9, 3.5441768238149443`*^9, 3.5443598959771357`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "precw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The precision of the differential equation \
(\[NoBreak]\\!\\({\\(\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"p\\\", \\\"\
\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \
\\(\\(-\\(\\(\\(\\(\\(8\\\\ z\\^2\\\\ \\(a[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) - \\(\\(8\\\\ z\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\(h[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) + \\(\\(\\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 5 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\)\\)\\/\\(4\\\\ z\\^2\\\\ \\(p[z]\\)\
\\^2\\\\ \\(\\(S[z]\\)\\)\\\\ \\(T[z]\\)\\^2\\\\ \\(\\((\\(\\(-\\(\\(S[\\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\)\\)\\) + \\(\\(z\\\\ \\(\\(\\(\
\\(\\*SuperscriptBox[\\(\[LeftSkeleton] 1 \[RightSkeleton]\\), TagBox[\\((\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\))\\), Derivative], \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\
\\)\\)]\\)\\)\\)\\))\\)\\)\\)\\)\\)\\)\\)\\)\\), \
\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\[Prime]\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \\(\\(\\(8\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\)\\) - \\(\\(2\\\\ \
z\\^2\\\\ \\(\\(T[z]\\)\\)\\\\ \\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\\\ \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\)\\)\\)\\/\\(z\\^2\\\\ \
\\(\\(S[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\)\\)\\), \\(\\(\[LeftSkeleton] 10 \
\[RightSkeleton]\\)\\), \\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, \
None]]\\)\\)[0.9998999999999999999952078263976140704016870586201548576355`33.\
99995656838019]\\)\\) \[Equal] \
\\(\\(-0.9089165364419084279953916470680052540930161241712376690208`24.\
438496407559352\\)\\)\\)\\)}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \
\\(\\({}\\)\\), \\(\\({}\\)\\)}\\)\[NoBreak]) is less than WorkingPrecision (\
\[NoBreak]\\!\\(25.`\\)\[NoBreak]). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/precw\\\", ButtonNote -> \
\\\"NDSolve::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543870710897341*^9, 3.543897677705892*^9, 
  3.543900614562106*^9, 3.54390342119906*^9, 3.543905200115779*^9, 
  3.543906195542021*^9, 3.543984967199746*^9, 3.543993525797584*^9, 
  3.544013085152*^9, 3.5441768238149443`*^9, 3.544359897392948*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "precw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The precision of the differential equation \
(\[NoBreak]\\!\\({\\(\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"p\\\", \\\"\
\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \
\\(\\(-\\(\\(\\(\\(\\(8\\\\ z\\^2\\\\ \\(a[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) - \\(\\(8\\\\ z\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\(h[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) + \\(\\(\\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 5 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\)\\)\\/\\(4\\\\ z\\^2\\\\ \\(p[z]\\)\
\\^2\\\\ \\(\\(S[z]\\)\\)\\\\ \\(T[z]\\)\\^2\\\\ \\(\\((\\(\\(-\\(\\(S[\\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\)\\)\\) + \\(\\(z\\\\ \\(\\(\\(\
\\(\\*SuperscriptBox[\\(\[LeftSkeleton] 1 \[RightSkeleton]\\), TagBox[\\((\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\))\\), Derivative], \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\
\\)\\)]\\)\\)\\)\\))\\)\\)\\)\\)\\)\\)\\)\\)\\), \
\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\[Prime]\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \\(\\(\\(8\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\)\\) - \\(\\(2\\\\ \
z\\^2\\\\ \\(\\(T[z]\\)\\)\\\\ \\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\\\ \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\)\\)\\)\\/\\(z\\^2\\\\ \
\\(\\(S[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\)\\)\\), \\(\\(\[LeftSkeleton] 10 \
\[RightSkeleton]\\)\\), \\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, \
None]]\\)\\)[0.0001000000000000000047921736023859295983129413798451423645`30.]\
\\)\\) \[Equal] \
\\(\\(-6.5325312504207381400185388190178164059857175854`24.698963378980014*^-\
12\\)\\)\\)\\)}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \
\\(\\({}\\)\\)}\\)\[NoBreak]) is less than WorkingPrecision \
(\[NoBreak]\\!\\(25.`\\)\[NoBreak]). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/precw\\\", \
ButtonNote -> \\\"NDSolve::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543870710897341*^9, 3.543897677705892*^9, 
  3.543900614562106*^9, 3.54390342119906*^9, 3.543905200115779*^9, 
  3.543906195542021*^9, 3.543984967199746*^9, 3.543993525797584*^9, 
  3.544013085152*^9, 3.5441768238149443`*^9, 3.544359898011303*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(NDSolve \
:: precw\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543870710897341*^9, 3.543897677705892*^9, 
  3.543900614562106*^9, 3.54390342119906*^9, 3.543905200115779*^9, 
  3.543906195542021*^9, 3.543984967199746*^9, 3.543993525797584*^9, 
  3.544013085152*^9, 3.5441768238149443`*^9, 3.544359898013126*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "x1", "\[Rule]", 
    "1.0514372428997404261338372034195566671592838920852743842233`25."}], ",", 
   RowBox[{
   "x2", "\[Rule]", 
    "1.6080690693166806051590867653020556439759261770349132057489`25."}], ",", 
   RowBox[{
   "x3", "\[Rule]", 
    "0.628647034926294727652250665476971820348933209120405014492`25."}], ",", 
   RowBox[{"x4", "\[Rule]", 
    RowBox[{
    "-", "2.9033694220131474928816778453375852889038084841627065838074`25."}]}\
], ",", 
   RowBox[{
   "x5", "\[Rule]", 
    "1.1701468725496203141803464468593347448503975679377003727474`25."}], ",", 
   RowBox[{
   "x6", "\[Rule]", 
    "2.9186026871581839454568096632793730849843330689496585896846`25."}], ",", 
   RowBox[{"x7", "\[Rule]", 
    RowBox[{
    "-", "4.9236866732013754761463408722959614851714412862781842871241`25."}]}\
], ",", 
   RowBox[{"x8", "\[Rule]", 
    RowBox[{
    "-", "4.991840908985049783261625414842964650510428213265500535578`25."}]}]\
}], "}"}]], "Output",
 CellChangeTimes->{3.543870737897235*^9, 3.543897703962099*^9, 
  3.543900631753766*^9, 3.543903447916299*^9, 3.543905230465464*^9, 
  3.5439062128110943`*^9, 3.543984993650907*^9, 3.543993543032385*^9, 
  3.5440131023291197`*^9, 3.544176850954287*^9, 3.5443599385166388`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "precw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The precision of the differential equation \
(\[NoBreak]\\!\\({\\(\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"p\\\", \\\"\
\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \
\\(\\(-\\(\\(\\(\\(\\(8\\\\ z\\^2\\\\ \\(a[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) - \\(\\(8\\\\ z\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\(h[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) + \\(\\(\\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 5 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\)\\)\\/\\(4\\\\ z\\^2\\\\ \\(p[z]\\)\
\\^2\\\\ \\(\\(S[z]\\)\\)\\\\ \\(T[z]\\)\\^2\\\\ \\(\\((\\(\\(-\\(\\(S[\\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\)\\)\\) + \\(\\(z\\\\ \\(\\(\\(\
\\(\\*SuperscriptBox[\\(\[LeftSkeleton] 1 \[RightSkeleton]\\), TagBox[\\((\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\))\\), Derivative], \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\
\\)\\)]\\)\\)\\)\\))\\)\\)\\)\\)\\)\\)\\)\\)\\), \
\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\[Prime]\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \\(\\(\\(8\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\)\\) - \\(\\(2\\\\ \
z\\^2\\\\ \\(\\(T[z]\\)\\)\\\\ \\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\\\ \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\)\\)\\)\\/\\(z\\^2\\\\ \
\\(\\(S[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\)\\)\\), \\(\\(\[LeftSkeleton] 10 \
\[RightSkeleton]\\)\\), \\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, \
None]]\\)\\)[0.0001000000000000000047921736023859295983129413798451423645`30.]\
\\)\\) \[Equal] \
\\(\\(-6.5325312463120150289104130583213292164871391382`24.698963378980004*^-\
12\\)\\)\\)\\)}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \
\\(\\({}\\)\\)}\\)\[NoBreak]) is less than WorkingPrecision \
(\[NoBreak]\\!\\(25.`\\)\[NoBreak]). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/precw\\\", \
ButtonNote -> \\\"NDSolve::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543870710897341*^9, 3.543897677705892*^9, 
  3.543900614562106*^9, 3.54390342119906*^9, 3.543905200115779*^9, 
  3.543906195542021*^9, 3.543984967199746*^9, 3.543993525797584*^9, 
  3.544013085152*^9, 3.5441768238149443`*^9, 3.544359938563484*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "precw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The precision of the differential equation \
(\[NoBreak]\\!\\({\\(\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"p\\\", \\\"\
\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \
\\(\\(-\\(\\(\\(\\(\\(8\\\\ z\\^2\\\\ \\(a[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) - \\(\\(8\\\\ z\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\(h[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) + \\(\\(\\(\\(T[z]\\)\\)\\\\ \
\\(\\((\\(\\(Times[\\(\\(\[LeftSkeleton] 5 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\)\\)\\/\\(4\\\\ z\\^2\\\\ \\(p[z]\\)\
\\^2\\\\ \\(\\(S[z]\\)\\)\\\\ \\(T[z]\\)\\^2\\\\ \\(\\((\\(\\(-\\(\\(S[\\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\)\\)\\) + \\(\\(z\\\\ \\(\\(\\(\
\\(\\*SuperscriptBox[\\(\[LeftSkeleton] 1 \[RightSkeleton]\\), TagBox[\\((\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\))\\), Derivative], \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\
\\)\\)]\\)\\)\\)\\))\\)\\)\\)\\)\\)\\)\\)\\)\\), \
\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\[Prime]\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\) \[Equal] \\(\\(\\(8\\\\ \
\\(\\(a[z]\\)\\)\\\\ \\(\\((\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\) + \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\\\ \\(\\(S[z]\\)\\)\\)\\) - \\(\\(2\\\\ \
z\\^2\\\\ \\(\\(T[z]\\)\\)\\\\ \\(\\(\\(\\(\\*SuperscriptBox[\\\"a\\\", \\\"\
\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\\\ \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[z]\\)\\)\\)\\)\\)\\/\\(z\\^2\\\\ \
\\(\\(S[z]\\)\\)\\\\ \\(\\(T[z]\\)\\)\\)\\)\\), \\(\\(\[LeftSkeleton] 9 \
\[RightSkeleton]\\)\\), \
\\(\\(\\(\\(S[0.9998999999999999999952078263976140704016870586201548576355`33.\
99995656838019]\\)\\) \[Equal] 0.6287379311193608`\\)\\), \
\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"S\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, \
None]]\\)\\)[0.9998999999999999999952078263976140704016870586201548576355`33.\
99995656838019]\\)\\) \[Equal] \\(\\(-0.9089165364265345`\\)\\)\\)\\)}\\)\\), \
\\(\\({}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\), \\(\\({}\\)\\)}\\)\[NoBreak]) \
is less than WorkingPrecision (\[NoBreak]\\!\\(25.`\\)\[NoBreak]). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/precw\\\", \
ButtonNote -> \\\"NDSolve::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543870710897341*^9, 3.543897677705892*^9, 
  3.543900614562106*^9, 3.54390342119906*^9, 3.543905200115779*^9, 
  3.543906195542021*^9, 3.543984967199746*^9, 3.543993525797584*^9, 
  3.544013085152*^9, 3.5441768238149443`*^9, 3.544359939921008*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "-", "2.21567332124389676406442276421260234819185`8.169504501618603*^-17"}]\
, ",", 
   RowBox[{
   "-", "4.1317938183377145810660024132011571472097865`10.523015257001097*^-\
15"}], ",", 
   RowBox[{
   "-", "1.950914034994620470171435535816246483272075`8.559299700708081*^-16"}\
], ",", "4.17792756827979405930397743825854323921`8.171504332061197*^-17", 
   ",", "1.143104630319350535844917759944413521061773`8.704320021059074*^-16",
    ",", 
   RowBox[{
   "-", "1.870931248720017704024077956167752507577033`6.745066267984653*^-16"}\
], ",", "1.1336421535307043237562957230306360167799171`6.970310362354268*^-\
15", ",", 
   RowBox[{
   "-", "1.217649299190524939132271216975005442581958`6.384167017372189*^-16"}\
]}], "}"}]], "Print",
 CellChangeTimes->{3.543870739188024*^9, 3.543897705286119*^9, 
  3.543900633327525*^9, 3.5439034492311087`*^9, 3.543905231880114*^9, 
  3.543906214397779*^9, 3.543984994974272*^9, 3.543993544608184*^9, 
  3.5440131038937693`*^9, 3.544176852249515*^9, 3.544359940300705*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"NR", "=", "14"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NN", "=", 
   RowBox[{"NR", "-", "1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.51763841954007*^9, 3.517638421220167*^9}, {
   3.53850182798134*^9, 3.538501830676206*^9}, {3.53873119805525*^9, 
   3.538731198141795*^9}, 3.538741113249531*^9, 3.538808539493106*^9, 
   3.538808990452856*^9, {3.5388105439971848`*^9, 3.538810586676996*^9}, {
   3.543736247015036*^9, 3.543736247074452*^9}, {3.543870715483357*^9, 
   3.543870715611312*^9}, {3.5438978857628527`*^9, 3.543897885919701*^9}, {
   3.5439006298100147`*^9, 3.543900629881624*^9}, {3.543903426456932*^9, 
   3.5439034280245743`*^9}, {3.543903488357287*^9, 3.54390348850725*^9}, {
   3.5439052037907667`*^9, 3.543905203894629*^9}, {3.543905298643736*^9, 
   3.5439052990099363`*^9}, {3.5439053567107677`*^9, 3.543905356851726*^9}, {
   3.543906198943074*^9, 3.543906199078765*^9}, {3.543906294584394*^9, 
   3.543906294655184*^9}, {3.543909603963183*^9, 3.543909604089979*^9}, {
   3.543909770014927*^9, 3.5439097701162148`*^9}, {3.5439852233386717`*^9, 
   3.543985223449888*^9}, {3.543993530100072*^9, 3.543993532539686*^9}, {
   3.5440130884367943`*^9, 3.5440130889003887`*^9}, {3.5440157640141783`*^9, 
   3.544015764108427*^9}, {3.544017796041869*^9, 3.54401779614489*^9}, {
   3.544018008043001*^9, 3.54401800814524*^9}, {3.5440184195612793`*^9, 
   3.544018419639524*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ChebR", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"\[Pi]", " ", "ii"}], "NN"], "]"}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "NN", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "ChebR", "]"}]}], "Input",
 CellChangeTimes->{{3.5175504275379143`*^9, 3.517550473868642*^9}, {
   3.5175505088539352`*^9, 3.51755057150263*^9}, {3.5175531815270977`*^9, 
   3.517553182781066*^9}, {3.5175532841430807`*^9, 3.517553285717567*^9}, {
   3.5175533447190742`*^9, 3.517553345933249*^9}, {3.517553478839162*^9, 
   3.5175534801413918`*^9}, {3.517553697086974*^9, 3.5175537300535307`*^9}, {
   3.517636043667302*^9, 3.517636082342285*^9}, {3.517636156121964*^9, 
   3.517636163909718*^9}, 3.517636245951754*^9, {3.517637708503521*^9, 
   3.517637710805746*^9}, {3.5176384245898523`*^9, 3.5176384266140013`*^9}, {
   3.517639920088458*^9, 3.517639921413632*^9}, {3.517639981975692*^9, 
   3.517640027901559*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.014529091286973994`", ",", "0.057271987173395045`", ",", 
   "0.12574462591444946`", ",", "0.2159676266344221`", ",", 
   "0.3226975564787322`", ",", "0.4397316598723385`", ",", 
   "0.5602683401276616`", ",", "0.6773024435212678`", ",", 
   "0.7840323733655779`", ",", "0.8742553740855505`", ",", 
   "0.9427280128266049`", ",", "0.985470908713026`", ",", "1.`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.543870739392371*^9, 3.543897705433078*^9, 3.543897887188406*^9, {
   3.543900633462542*^9, 3.543900635535335*^9}, 3.543903449450348*^9, 
   3.543903489749435*^9, 3.54390523197713*^9, 3.543905300465917*^9, 
   3.543905358152334*^9, 3.543906214512739*^9, 3.5439062957046127`*^9, 
   3.543909605348913*^9, 3.5439097711701727`*^9, 3.5439849951746597`*^9, 
   3.543985224809361*^9, 3.543993544870913*^9, 3.544013104203844*^9, 
   3.544015765513586*^9, 3.544017797954611*^9, 3.544018009418353*^9, 
   3.544018421107025*^9, 3.544176852460023*^9, 3.544359940563209*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"aval", "=", 
  RowBox[{
   RowBox[{"asyma0", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"asymp2", "\[Rule]", "x4"}], ",", 
      RowBox[{"asymh2", "\[Rule]", "x5"}], ",", 
      RowBox[{"asyma0", "\[Rule]", "x6"}], ",", 
      RowBox[{"asyma1", "\[Rule]", "x7"}], ",", 
      RowBox[{"asymT3", "\[Rule]", "x8"}]}], "}"}]}], "/.", 
   "nsol"}]}]], "Input",
 CellChangeTimes->{{3.538503869006027*^9, 3.538503871118003*^9}, {
  3.538504557033042*^9, 3.538504557751896*^9}}],

Cell[BoxData["2.9186026871581839454568096632793730849843330689496585896846`25.\
"], "Output",
 CellChangeTimes->{
  3.5438707395501633`*^9, 3.543897705549638*^9, 3.5438978880104647`*^9, {
   3.543900633528144*^9, 3.543900636183416*^9}, 3.5439034495692043`*^9, 
   3.543903490363604*^9, 3.543905232044415*^9, 3.5439053013465557`*^9, 
   3.54390535877492*^9, 3.543906214561221*^9, 3.543906296254818*^9, 
   3.543909606031376*^9, 3.5439097719222193`*^9, 3.5439849952916813`*^9, 
   3.5439852256081467`*^9, 3.543993544951775*^9, 3.5440131043801537`*^9, 
   3.5440157662486553`*^9, 3.544017798805656*^9, 3.544018010118741*^9, 
   3.544018422007257*^9, 3.544176852560392*^9, 3.5443599406970253`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", "z"], 
         RowBox[{"p", "[", "z", "]"}]}], "/.", "nsol1"}], "/.", 
       RowBox[{"{", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", 
            RowBox[{"-", "2"}]}], "]"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{"horizp", "[", "z", "]"}], "z"], "/.", 
          RowBox[{"{", 
           RowBox[{"z", "\[Rule]", "1"}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"horizp0", "\[Rule]", "x1"}], ",", 
           RowBox[{"horizh0", "\[Rule]", "0"}], ",", 
           RowBox[{"horiza1", "\[Rule]", "q"}], ",", 
           RowBox[{"horizt1", "\[Rule]", "x2"}], ",", 
           RowBox[{"horizs0", "\[Rule]", "x3"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hlist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", "z"], 
         RowBox[{"h", "[", "z", "]"}]}], "/.", "nsol1"}], "/.", 
       RowBox[{"{", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", 
            RowBox[{"-", "2"}]}], "]"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{"horizh", "[", "z", "]"}], "z"], "/.", 
          RowBox[{"{", 
           RowBox[{"z", "\[Rule]", "1"}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"horizp0", "\[Rule]", "x1"}], ",", 
           RowBox[{"horizh0", "\[Rule]", "0"}], ",", 
           RowBox[{"horiza1", "\[Rule]", "q"}], ",", 
           RowBox[{"horizt1", "\[Rule]", "x2"}], ",", 
           RowBox[{"horizs0", "\[Rule]", "x3"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"alist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Expand", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"asyma", "[", "z", "]"}], "-", "asyma0"}], "z"], "]"}], "/.", 
          RowBox[{"{", 
           RowBox[{"z", "\[Rule]", "0"}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"asymp2", "\[Rule]", "x4"}], ",", 
           RowBox[{"asymh2", "\[Rule]", "x5"}], ",", 
           RowBox[{"asyma0", "\[Rule]", "x6"}], ",", 
           RowBox[{"asyma1", "\[Rule]", "x7"}], ",", 
           RowBox[{"asymT3", "\[Rule]", "x8"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           FractionBox["1", "z"], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "[", "z", "]"}], "-", "asyma0"}], ")"}]}], "/.", 
          "nsol1"}], "/.", 
         RowBox[{"{", 
          RowBox[{"z", "\[Rule]", 
           RowBox[{"ChebR", "[", 
            RowBox[{"[", 
             RowBox[{"2", ";;", 
              RowBox[{"-", "2"}]}], "]"}], "]"}]}], "}"}]}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"asymp2", "\[Rule]", "x4"}], ",", 
          RowBox[{"asymh2", "\[Rule]", "x5"}], ",", 
          RowBox[{"asyma0", "\[Rule]", "x6"}], ",", 
          RowBox[{"asyma1", "\[Rule]", "x7"}], ",", 
          RowBox[{"asymT3", "\[Rule]", "x8"}]}], "}"}]}], "/.", "nsol"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           FractionBox[
            RowBox[{
             RowBox[{"horiza", "[", "z", "]"}], "-", "asyma0"}], "z"], "/.", 
           RowBox[{"{", 
            RowBox[{"z", "\[Rule]", "1"}], "}"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"horizp0", "\[Rule]", "x1"}], ",", 
            RowBox[{"horizh0", "\[Rule]", "0"}], ",", 
            RowBox[{"horiza1", "\[Rule]", "q"}], ",", 
            RowBox[{"horizt1", "\[Rule]", "x2"}], ",", 
            RowBox[{"horizs0", "\[Rule]", "x3"}]}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"asymp2", "\[Rule]", "x4"}], ",", 
           RowBox[{"asymh2", "\[Rule]", "x5"}], ",", 
           RowBox[{"asyma0", "\[Rule]", "x6"}], ",", 
           RowBox[{"asyma1", "\[Rule]", "x7"}], ",", 
           RowBox[{"asymT3", "\[Rule]", "x8"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tlist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", 
          RowBox[{"z", "^", "2"}]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"T", "[", "z", "]"}], "-", "1"}], ")"}]}], "/.", "nsol1"}],
        "/.", 
       RowBox[{"{", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", 
            RowBox[{"-", "2"}]}], "]"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{
            RowBox[{"horizT", "[", "z", "]"}], "-", "1"}], 
           RowBox[{"z", "^", "2"}]], "/.", 
          RowBox[{"{", 
           RowBox[{"z", "\[Rule]", "1"}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"horizp0", "\[Rule]", "x1"}], ",", 
           RowBox[{"horizh0", "\[Rule]", "0"}], ",", 
           RowBox[{"horiza1", "\[Rule]", "q"}], ",", 
           RowBox[{"horizt1", "\[Rule]", "x2"}], ",", 
           RowBox[{"horizs0", "\[Rule]", "x3"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Slist", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        FractionBox["1", 
         RowBox[{"z", "^", "2"}]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"S", "[", "z", "]"}], "-", "1"}], ")"}]}], "/.", "nsol1"}], 
      "/.", 
      RowBox[{"{", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"ChebR", "[", 
         RowBox[{"[", 
          RowBox[{"2", ";;", 
           RowBox[{"-", "2"}]}], "]"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"horizS", "[", "z", "]"}], "-", "1"}], 
          RowBox[{"z", "^", "2"}]], "/.", 
         RowBox[{"{", 
          RowBox[{"z", "\[Rule]", "1"}], "}"}]}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"horizp0", "\[Rule]", "x1"}], ",", 
          RowBox[{"horizh0", "\[Rule]", "0"}], ",", 
          RowBox[{"horiza1", "\[Rule]", "q"}], ",", 
          RowBox[{"horizt1", "\[Rule]", "x2"}], ",", 
          RowBox[{"horizs0", "\[Rule]", "x3"}]}], "}"}]}], "/.", "nsol"}], 
      "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538502159684472*^9, 3.538502221978693*^9}, {
  3.538503165035289*^9, 3.538503299421774*^9}, {3.5385033330026503`*^9, 
  3.5385033914641247`*^9}, {3.5385034512324057`*^9, 3.538503487889101*^9}, {
  3.538503647371841*^9, 3.538503649375634*^9}, {3.538503718913886*^9, 
  3.538503801543604*^9}, {3.538503905800393*^9, 3.538503951275783*^9}, {
  3.538504241391078*^9, 3.53850425647017*^9}, {3.5385044634506683`*^9, 
  3.538504467631667*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"file", " ", "=", " ", 
    RowBox[{"OpenWrite", "[", 
     RowBox[{"\"\<~/Work/AdSCMTDyn2/matlab/init.dat\>\"", ",", " ", 
      RowBox[{"BinaryFormat", " ", "\[Rule]", " ", "True"}]}], "]"}]}], ";"}],
   "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "file", "]"}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{"  ", 
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", "aval", ",", " ", "\"\<Real64\>\""}], "]"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\n", "  ", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"plist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"hlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"alist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"Tlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"Slist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", " ", "1", ",", " ", "NR"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.5385020074997997`*^9, 3.538502020253977*^9}, {
   3.538502054087071*^9, 3.5385021529179296`*^9}, {3.538504511144497*^9, 
   3.538504585717393*^9}, {3.538504623909217*^9, 3.5385046463399553`*^9}, {
   3.538726443406577*^9, 3.538726445469967*^9}, 3.54373434032411*^9, {
   3.543869390715309*^9, 3.543869400209799*^9}, {3.544359987694792*^9, 
   3.544360019155982*^9}}],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"/Users/tobywiseman/Work/AdSCMTDyn2/C/test/init.dat\"\>", ",", 
   "22"}], "]"}]], "Print",
 CellChangeTimes->{
  3.543870739843649*^9, 3.54389770570118*^9, 3.5438978895770683`*^9, 
   3.543900637754362*^9, 3.543903449750566*^9, 3.543903491784194*^9, 
   3.5439052321618757`*^9, 3.543905302751437*^9, 3.543905360228271*^9, 
   3.5439062146795483`*^9, 3.543906297507106*^9, 3.54390960743325*^9, 
   3.5439097734608307`*^9, 3.5439849955264807`*^9, 3.543985227478544*^9, 
   3.543993545084722*^9, 3.544013104646346*^9, 3.5440157679022217`*^9, 
   3.5440178003926907`*^9, 3.544018011772894*^9, 3.54401842364427*^9, 
   3.544176852762247*^9, 3.544359940938347*^9, {3.544359988762312*^9, 
   3.544360002655764*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["aval"], "Input",
 CellChangeTimes->{{3.538727363712104*^9, 3.538727364132785*^9}, {
  3.538727421558289*^9, 3.5387274460290956`*^9}}],

Cell[BoxData["2.9186026871581839454568096632793730849843330689496585896846`25.\
"], "Output",
 CellChangeTimes->{
  3.543870739960412*^9, 3.543897705818008*^9, 3.543897890762136*^9, 
   3.543900638991445*^9, 3.54390344986966*^9, 3.54390349245078*^9, 
   3.543905232227572*^9, 3.543905303385976*^9, 3.543905361015544*^9, 
   3.5439062147298326`*^9, 3.543906298176248*^9, 3.543909608117972*^9, 
   3.5439097742115517`*^9, 3.543984995741992*^9, 3.5439852283494368`*^9, 
   3.543993545150743*^9, 3.544013104779636*^9, 3.54401576868683*^9, 
   3.5440178014278297`*^9, 3.5440180127242126`*^9, 3.5440184246961117`*^9, 
   3.544176852862018*^9, 3.544359941081149*^9, {3.5443599899287167`*^9, 
   3.544360003553217*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["NR"], "Input",
 CellChangeTimes->{{3.538727377866576*^9, 3.538727377933123*^9}}],

Cell[BoxData["14"], "Output",
 CellChangeTimes->{
  3.543870740027174*^9, 3.543897705883712*^9, 3.5438978913661747`*^9, 
   3.543900639692007*^9, 3.543903449950717*^9, 3.5439034930525923`*^9, 
   3.543905232294208*^9, 3.5439053039521217`*^9, 3.54390536173057*^9, 
   3.543906214778412*^9, 3.543906298762147*^9, 3.543909608855256*^9, 
   3.5439097749773197`*^9, 3.5439849964110937`*^9, 3.543985229048131*^9, 
   3.543993545218513*^9, 3.544013104846434*^9, 3.5440157693220654`*^9, 
   3.5440178022294283`*^9, 3.544018013375474*^9, 3.544018425414282*^9, 
   3.54417685292704*^9, 3.5443599411486073`*^9, {3.544359990494914*^9, 
   3.54436000407194*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerics - Unbroken", "Subsubtitle",
 CellChangeTimes->{{3.538463013798025*^9, 3.5384630213987093`*^9}, {
  3.538467402992407*^9, 3.5384674058714247`*^9}, {3.538985525635343*^9, 
  3.538985527153359*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"NR", "=", "30"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NN", "=", 
   RowBox[{"NR", "-", "1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.51763841954007*^9, 3.517638421220167*^9}, {
   3.53850182798134*^9, 3.538501830676206*^9}, {3.53873119805525*^9, 
   3.538731198141795*^9}, 3.538741113249531*^9, 3.538808539493106*^9, 
   3.538808990452856*^9, {3.5388105439971848`*^9, 3.538810586676996*^9}, {
   3.543734747237671*^9, 3.5437347473106213`*^9}, 3.5437353134547043`*^9, 
   3.543749518444067*^9, {3.544183116641727*^9, 3.544183116712715*^9}, {
   3.544185774514337*^9, 3.544185774633152*^9}, {3.54418629459544*^9, 
   3.544186296250272*^9}, {3.5441871346949663`*^9, 3.544187134830748*^9}, {
   3.5441884512644587`*^9, 3.544188451335978*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ChebR", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"\[Pi]", " ", "ii"}], "NN"], "]"}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "NN", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "ChebR", "]"}]}], "Input",
 CellChangeTimes->{{3.5175504275379143`*^9, 3.517550473868642*^9}, {
   3.5175505088539352`*^9, 3.51755057150263*^9}, {3.5175531815270977`*^9, 
   3.517553182781066*^9}, {3.5175532841430807`*^9, 3.517553285717567*^9}, {
   3.5175533447190742`*^9, 3.517553345933249*^9}, {3.517553478839162*^9, 
   3.5175534801413918`*^9}, {3.517553697086974*^9, 3.5175537300535307`*^9}, {
   3.517636043667302*^9, 3.517636082342285*^9}, {3.517636156121964*^9, 
   3.517636163909718*^9}, 3.517636245951754*^9, {3.517637708503521*^9, 
   3.517637710805746*^9}, {3.5176384245898523`*^9, 3.5176384266140013`*^9}, {
   3.517639920088458*^9, 3.517639921413632*^9}, {3.517639981975692*^9, 
   3.517640027901559*^9}, {3.5389860399222803`*^9, 3.538986051129409*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.0029310214228202014`", ",", "0.011689722144956671`", ",", 
   "0.026173414408598772`", ",", "0.0462122901645215`", ",", 
   "0.07157141191620536`", ",", "0.10195346714717812`", ",", 
   "0.13700225403843458`", ",", "0.1763068576090862`", ",", 
   "0.21940646731880886`", ",", "0.2657957796501049`", ",", 
   "0.31493092233004283`", ",", "0.36623583073538957`", ",", 
   "0.41910900172361765`", ",", "0.47293054570729126`", ",", 
   "0.5270694542927088`", ",", "0.5808909982763824`", ",", 
   "0.6337641692646104`", ",", "0.6850690776699572`", ",", 
   "0.7342042203498951`", ",", "0.7805935326811911`", ",", 
   "0.8236931423909137`", ",", "0.8629977459615654`", ",", 
   "0.8980465328528219`", ",", "0.9284285880837946`", ",", 
   "0.9537877098354786`", ",", "0.9738265855914012`", ",", 
   "0.9883102778550433`", ",", "0.9970689785771798`", ",", "1.`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.5441831367588463`*^9, 3.544184943742947*^9, {3.54418577588002*^9, 
   3.544185786704729*^9}, 3.544186297366206*^9, 3.5441871361212254`*^9, 
   3.544188452366641*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "aval", ",", "p", ",", "h", ",", "a", ",", "T", ",", "S", ",", "q"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5389856150179768`*^9, 3.538985619269599*^9}, {
  3.5389867130184183`*^9, 3.538986714170092*^9}, {3.538986804615107*^9, 
  3.538986816726158*^9}, {3.544185784218293*^9, 3.5441857842780457`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", "\[Epsilon]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", "z_", "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{"3", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        FractionBox["1", "4"], 
        RowBox[{"q", "^", "2"}]}]}], ")"}], " ", 
     RowBox[{"z", "^", "3"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", "z_", "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.538985584177477*^9, 3.538985599024313*^9}, {
   3.53898566037003*^9, 3.538985663298764*^9}, {3.538985694375431*^9, 
   3.538985752536989*^9}, 3.538985795674563*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T", "[", "1", "]"}]], "Input",
 CellChangeTimes->{{3.538985754767921*^9, 3.5389857560546093`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.544183139242879*^9, 3.544184945674158*^9, {3.544185778417626*^9, 
   3.5441857885700083`*^9}, 3.544186299437686*^9, 3.544187138226829*^9, 
   3.544188454164185*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", "eqlist", "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"\[Epsilon]", "\[Rule]", "0"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5389856530849533`*^9, 3.538985700420933*^9}, {
  3.538985764598106*^9, 3.5389857663737926`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.5441831399653387`*^9, 3.5441849464375353`*^9, {3.544185779281598*^9, 
   3.544185789168182*^9}, 3.544186300085904*^9, 3.544187138906105*^9, 
   3.544188454730049*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S", ",", "q"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5389867601265717`*^9, 3.538986761510334*^9}, {
  3.54418495562226*^9, 3.544184955734089*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plist", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", "z"], 
         RowBox[{"p", "[", "z", "]"}]}], "/.", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hlist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", "z"], 
          RowBox[{"h", "[", "z", "]"}]}], "/.", 
         RowBox[{"z", "\[Rule]", 
          RowBox[{"ChebR", "[", 
           RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"alist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", "z"], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "[", "z", "]"}], "-", "aval"}], ")"}]}], "/.", 
         RowBox[{"z", "\[Rule]", 
          RowBox[{"ChebR", "[", 
           RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tlist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", 
           RowBox[{"z", "^", "2"}]], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"T", "[", "z", "]"}], "-", "1"}], ")"}]}], "/.", 
         RowBox[{"z", "\[Rule]", 
          RowBox[{"ChebR", "[", 
           RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Slist", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", 
          RowBox[{"z", "^", "2"}]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"S", "[", "z", "]"}], "-", "1"}], ")"}]}], "/.", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.538502159684472*^9, 3.538502221978693*^9}, {
  3.538503165035289*^9, 3.538503299421774*^9}, {3.5385033330026503`*^9, 
  3.5385033914641247`*^9}, {3.5385034512324057`*^9, 3.538503487889101*^9}, {
  3.538503647371841*^9, 3.538503649375634*^9}, {3.538503718913886*^9, 
  3.538503801543604*^9}, {3.538503905800393*^9, 3.538503951275783*^9}, {
  3.538504241391078*^9, 3.53850425647017*^9}, {3.5385044634506683`*^9, 
  3.538504467631667*^9}, {3.538985892124278*^9, 3.538985994625936*^9}, {
  3.538986027757465*^9, 3.5389860283252296`*^9}, {3.538986835591592*^9, 
  3.538986835671126*^9}, {3.538999265602706*^9, 3.538999328993082*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", "z_", "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{"3", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        FractionBox["1", "4"], 
        RowBox[{"q", "^", "2"}]}]}], ")"}], " ", 
     RowBox[{"z", "^", "3"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", "z_", "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.538985584177477*^9, 3.538985599024313*^9}, {
   3.53898566037003*^9, 3.538985663298764*^9}, {3.538985694375431*^9, 
   3.538985752536989*^9}, 3.538985795674563*^9, 3.538986011486863*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"T", "'"}], "[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.543856049182849*^9, 3.5438560548742228`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], "+", 
  FractionBox[
   SuperscriptBox["q", "2"], "4"]}]], "Output",
 CellChangeTimes->{
  3.544183142781864*^9, {3.544184949965303*^9, 3.544184958231073*^9}, 
   3.5441857925112047`*^9, 3.544186305281146*^9, 3.54418714181639*^9, 
   3.544188457186646*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     FractionBox[
      SuperscriptBox["q", "2"], "4"]}], "\[Equal]", "0"}], ",", "q"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.54385607503798*^9, 3.543856082329897*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SqrtBox["3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", 
     RowBox[{"2", " ", 
      SqrtBox["3"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.544183143461433*^9, {3.544184950906867*^9, 3.5441849593497343`*^9}, 
   3.5441857931187*^9, 3.544186305900652*^9, 3.544187142586246*^9, 
   3.5441884579219646`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"2", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5438560862931547`*^9, 3.5438560893374767`*^9}}],

Cell[BoxData["3.4641016151377544`"], "Output",
 CellChangeTimes->{3.544183143969009*^9, 3.544184960435174*^9, 
  3.544185793847559*^9, 3.5441863065164433`*^9, 3.544187143201706*^9, 
  3.544188458807325*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"aval", "=", 
   RowBox[{"a", "[", "0", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538503869006027*^9, 3.538503871118003*^9}, {
  3.538504557033042*^9, 3.538504557751896*^9}, {3.538985779939569*^9, 
  3.538985810144496*^9}, {3.544184963629833*^9, 3.544184965661772*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", "2."}], ";"}]], "Input",
 CellChangeTimes->{{3.5389867796132174`*^9, 3.538986782685376*^9}, {
  3.543749500757925*^9, 3.543749501435857*^9}, {3.544184967589922*^9, 
  3.544184970277432*^9}, {3.5441871185849543`*^9, 3.544187124782961*^9}, {
  3.5441874014648533`*^9, 3.544187401562845*^9}, {3.5441881579959087`*^9, 
  3.544188158082137*^9}, {3.544188251954484*^9, 3.5441882524721317`*^9}, {
  3.544188445473291*^9, 3.5441884456001797`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"file", " ", "=", " ", 
    RowBox[{"OpenWrite", "[", 
     RowBox[{"\"\<~/Work/AdSCMTDyn2/matlab/init.dat\>\"", ",", " ", 
      RowBox[{"BinaryFormat", " ", "\[Rule]", " ", "True"}]}], "]"}]}], ";"}],
   "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "file", "]"}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{"  ", 
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", "aval", ",", " ", "\"\<Real64\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\n", "  ", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"plist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"hlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"alist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"Tlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"Slist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", " ", "1", ",", " ", "NR"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.5385020074997997`*^9, 3.538502020253977*^9}, {
   3.538502054087071*^9, 3.5385021529179296`*^9}, {3.538504511144497*^9, 
   3.538504585717393*^9}, {3.538504623909217*^9, 3.5385046463399553`*^9}, {
   3.538726443406577*^9, 3.538726445469967*^9}, {3.5389858674047813`*^9, 
   3.538985868491022*^9}, 3.543734330538042*^9, {3.5441831500034533`*^9, 
   3.544183150875201*^9}}],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"/Users/tobywiseman/Work/AdSCMTDyn2/matlab/init.dat\"\>", ",", 
   "31"}], "]"}]], "Print",
 CellChangeTimes->{{3.5441831459160957`*^9, 3.544183151502741*^9}, 
   3.5441849719257927`*^9, 3.544185802014778*^9, 3.5441863108582907`*^9, {
   3.544187121577783*^9, 3.544187145495882*^9}, 3.544187403209553*^9, 
   3.544188159922214*^9, 3.5441882538891563`*^9, 3.544188461060587*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["aval"], "Input",
 CellChangeTimes->{{3.538727363712104*^9, 3.538727364132785*^9}, {
  3.538727421558289*^9, 3.5387274460290956`*^9}}],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{
  3.544186313229228*^9, {3.544187127187419*^9, 3.544187146375787*^9}, 
   3.5441874038940268`*^9, 3.544188160623032*^9, 3.5441882545403*^9, 
   3.54418846226274*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["NR"], "Input",
 CellChangeTimes->{{3.538727377866576*^9, 3.538727377933123*^9}}],

Cell[BoxData["30"], "Output",
 CellChangeTimes->{
  3.544186313799322*^9, {3.544187127804501*^9, 3.544187146925308*^9}, 
   3.544187404395194*^9, 3.5441881611247063`*^9, 3.544188255091736*^9, 
   3.544188462863867*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", "\[Epsilon]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", "z_", "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{"3", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"m", " ", 
     RowBox[{"z", "^", "3"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", "z_", "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.538985584177477*^9, 3.538985599024313*^9}, {
   3.53898566037003*^9, 3.538985663298764*^9}, {3.538985694375431*^9, 
   3.538985752536989*^9}, 3.538985795674563*^9, {3.5437500541453943`*^9, 
   3.543750078325849*^9}, {3.543750150584614*^9, 3.5437501564071293`*^9}, {
   3.543750187672286*^9, 3.5437502107664747`*^9}, {3.543750291367196*^9, 
   3.543750307126504*^9}}],

Cell[BoxData[
 RowBox[{"T", "[", "zh", "]"}]], "Input",
 CellChangeTimes->{{3.538985754767921*^9, 3.5389857560546093`*^9}, {
  3.543750221565905*^9, 3.5437502487476*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", "eqlist", "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"\[Epsilon]", "\[Rule]", "0"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5389856530849533`*^9, 3.538985700420933*^9}, {
  3.538985764598106*^9, 3.5389857663737926`*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"a", "[", "z", "]"}], "-", 
      RowBox[{"a", "[", "0", "]"}]}], "z"], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"q", "\[Rule]", "3.05"}], ",", 
      RowBox[{"m", "\[Rule]", "0"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.543750351519446*^9, 3.5437503743583717`*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "z", "]"}], "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"q", "\[Rule]", "3.05"}], ",", 
      RowBox[{"m", "\[Rule]", "4.5"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.543750413519299*^9, 3.543750517452866*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{
        RowBox[{"T", "[", "z", "]"}], "-", "1"}], 
       RowBox[{"z", "^", "2"}]], ")"}], "z"], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"q", "\[Rule]", "3.05"}], ",", 
      RowBox[{"m", "\[Rule]", "4.5"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "5"}], ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.543749538683271*^9, 3.543749603108762*^9}, {
  3.543750322598619*^9, 3.543750336989295*^9}, {3.543750527519599*^9, 
  3.543750550461568*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plist", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", "z"], 
         RowBox[{"p", "[", "z", "]"}]}], "/.", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hlist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", "z"], 
          RowBox[{"h", "[", "z", "]"}]}], "/.", 
         RowBox[{"z", "\[Rule]", 
          RowBox[{"ChebR", "[", 
           RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"alist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", "z"], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "[", "z", "]"}], "-", "aval"}], ")"}]}], "/.", 
         RowBox[{"z", "\[Rule]", 
          RowBox[{"ChebR", "[", 
           RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tlist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", 
           RowBox[{"z", "^", "2"}]], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"T", "[", "z", "]"}], "-", "1"}], ")"}]}], "/.", 
         RowBox[{"z", "\[Rule]", 
          RowBox[{"ChebR", "[", 
           RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Slist", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", 
          RowBox[{"z", "^", "2"}]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"S", "[", "z", "]"}], "-", "1"}], ")"}]}], "/.", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.538502159684472*^9, 3.538502221978693*^9}, {
  3.538503165035289*^9, 3.538503299421774*^9}, {3.5385033330026503`*^9, 
  3.5385033914641247`*^9}, {3.5385034512324057`*^9, 3.538503487889101*^9}, {
  3.538503647371841*^9, 3.538503649375634*^9}, {3.538503718913886*^9, 
  3.538503801543604*^9}, {3.538503905800393*^9, 3.538503951275783*^9}, {
  3.538504241391078*^9, 3.53850425647017*^9}, {3.5385044634506683`*^9, 
  3.538504467631667*^9}, {3.538985892124278*^9, 3.538985994625936*^9}, {
  3.538986027757465*^9, 3.5389860283252296`*^9}, {3.538986835591592*^9, 
  3.538986835671126*^9}, {3.538999265602706*^9, 3.538999328993082*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", "z_", "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{"3", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"m", " ", 
     RowBox[{"z", "^", "3"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", "z_", "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.538985584177477*^9, 3.538985599024313*^9}, {
   3.53898566037003*^9, 3.538985663298764*^9}, {3.538985694375431*^9, 
   3.538985752536989*^9}, 3.538985795674563*^9, 3.538986011486863*^9, {
   3.54375228922278*^9, 3.543752289606523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"aval", "=", 
   RowBox[{"a", "[", "0", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538503869006027*^9, 3.538503871118003*^9}, {
  3.538504557033042*^9, 3.538504557751896*^9}, {3.538985779939569*^9, 
  3.538985810144496*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"q", "=", "3.05"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", "=", "4.5"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5389867796132174`*^9, 3.538986782685376*^9}, {
  3.543749500757925*^9, 3.543749501435857*^9}, {3.543752292948531*^9, 
  3.543752314067997*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"file", " ", "=", " ", 
    RowBox[{"OpenWrite", "[", 
     RowBox[{"\"\<~/Work/AdSCMTDyn3/matlab/init.dat\>\"", ",", " ", 
      RowBox[{"BinaryFormat", " ", "\[Rule]", " ", "True"}]}], "]"}]}], ";"}],
   "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "file", "]"}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{"  ", 
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", "aval", ",", " ", "\"\<Real64\>\""}], "]"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\n", "  ", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"plist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"hlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"alist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"Tlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"Slist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", " ", "1", ",", " ", "NR"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.5385020074997997`*^9, 3.538502020253977*^9}, {
   3.538502054087071*^9, 3.5385021529179296`*^9}, {3.538504511144497*^9, 
   3.538504585717393*^9}, {3.538504623909217*^9, 3.5385046463399553`*^9}, {
   3.538726443406577*^9, 3.538726445469967*^9}, {3.5389858674047813`*^9, 
   3.538985868491022*^9}, 3.543734330538042*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1246, 869},
WindowMargins->{{Automatic, 14}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "calcgeom"->{
  Cell[29814, 776, 306, 9, 73, "Input",
   CellTags->"calcgeom"],
  Cell[30123, 787, 293, 10, 73, "Input",
   CellTags->"calcgeom"],
  Cell[30419, 799, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[30686, 810, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[30953, 821, 3551, 100, 139, "Input",
   CellTags->"calcgeom"],
  Cell[34507, 923, 155, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[34869, 935, 5599, 153, 178, "Input",
   CellTags->"calcgeom"],
  Cell[40471, 1090, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[40616, 1096, 1615, 48, 88, "Input",
   CellTags->"calcgeom"],
  Cell[42234, 1146, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[42379, 1152, 633, 22, 27, "Input",
   CellTags->"calcgeom"],
  Cell[43015, 1176, 1648, 51, 113, "Input",
   CellTags->"calcgeom"],
  Cell[44666, 1229, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[44811, 1235, 145, 4, 27, "Input",
   CellTags->"calcgeom"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"calcgeom", 724972, 18329}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 741, 13, 96, "Subtitle"],
Cell[1323, 37, 68, 1, 27, "Input"],
Cell[CellGroupData[{
Cell[1416, 42, 111, 1, 26, "Subsubtitle"],
Cell[1530, 45, 95, 2, 27, "Input"],
Cell[1628, 49, 279, 8, 58, "Input"],
Cell[1910, 59, 266, 9, 58, "Input"],
Cell[2179, 70, 407, 13, 27, "Input"],
Cell[2589, 85, 37, 0, 27, "Input"],
Cell[2629, 87, 257, 8, 58, "Input"],
Cell[2889, 97, 2020, 62, 103, "Input"],
Cell[4912, 161, 26, 0, 27, "Input"],
Cell[4941, 163, 841, 25, 43, "Input"],
Cell[5785, 190, 1026, 31, 58, "Input"],
Cell[6814, 223, 227, 8, 86, "Text"],
Cell[7044, 233, 4015, 95, 238, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[11096, 333, 111, 3, 26, "Subsubtitle"],
Cell[11210, 338, 128, 4, 26, "Text"],
Cell[11341, 344, 6139, 139, 718, "Input"],
Cell[17483, 485, 68, 1, 26, "Text"],
Cell[17554, 488, 3727, 84, 523, "Input"],
Cell[21284, 574, 824, 18, 208, "Input"],
Cell[22111, 594, 4051, 89, 583, "Input"],
Cell[26165, 685, 99, 2, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[26301, 692, 34, 0, 26, "Subsubtitle"],
Cell[26338, 694, 3220, 66, 173, "Input"],
Cell[29561, 762, 28, 0, 27, "Input"],
Cell[29592, 764, 28, 0, 27, "Input"],
Cell[29623, 766, 119, 3, 27, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29779, 774, 32, 0, 26, "Subsubtitle"],
Cell[29814, 776, 306, 9, 73, "Input",
 CellTags->"calcgeom"],
Cell[30123, 787, 293, 10, 73, "Input",
 CellTags->"calcgeom"],
Cell[30419, 799, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[30686, 810, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[30953, 821, 3551, 100, 139, "Input",
 CellTags->"calcgeom"],
Cell[34507, 923, 155, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[34665, 929, 201, 4, 27, "Input"],
Cell[34869, 935, 5599, 153, 178, "Input",
 CellTags->"calcgeom"],
Cell[40471, 1090, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[40616, 1096, 1615, 48, 88, "Input",
 CellTags->"calcgeom"],
Cell[42234, 1146, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[42379, 1152, 633, 22, 27, "Input",
 CellTags->"calcgeom"],
Cell[43015, 1176, 1648, 51, 113, "Input",
 CellTags->"calcgeom"],
Cell[44666, 1229, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[44811, 1235, 145, 4, 27, "Input",
 CellTags->"calcgeom"]
}, Closed]],
Cell[CellGroupData[{
Cell[44993, 1244, 41, 0, 26, "Subsubtitle"],
Cell[45037, 1246, 173, 4, 27, "Input"],
Cell[45213, 1252, 645, 21, 27, "Input"],
Cell[45861, 1275, 1146, 34, 118, "Input"],
Cell[47010, 1311, 1792, 51, 118, "Input"],
Cell[48805, 1364, 710, 23, 58, "Input"],
Cell[49518, 1389, 3771, 101, 328, "Input"],
Cell[53292, 1492, 388, 12, 27, "Input"],
Cell[53683, 1506, 434, 10, 27, "Input"],
Cell[54120, 1518, 462, 11, 46, "Input"],
Cell[54585, 1531, 4135, 133, 141, "Input"],
Cell[58723, 1666, 6843, 214, 199, "Input"],
Cell[65569, 1882, 237, 5, 27, "Input"],
Cell[65809, 1889, 3999, 129, 141, "Input"],
Cell[69811, 2020, 1262, 33, 148, "Input"],
Cell[71076, 2055, 1027, 21, 58, "Input"],
Cell[72106, 2078, 677, 17, 58, "Input"],
Cell[72786, 2097, 1027, 30, 118, "Input"],
Cell[73816, 2129, 161, 3, 27, "Input"],
Cell[73980, 2134, 745, 18, 88, "Input"],
Cell[74728, 2154, 1146, 32, 238, "Input"],
Cell[75877, 2188, 2030, 59, 33, "Input"],
Cell[77910, 2249, 1339, 40, 33, "Input"],
Cell[79252, 2291, 1074, 32, 88, "Input"],
Cell[80329, 2325, 579, 15, 58, "Input"],
Cell[80911, 2342, 1861, 66, 105, "Input"],
Cell[82775, 2410, 2996, 109, 177, "Input"],
Cell[85774, 2521, 949, 30, 148, "Input"],
Cell[86726, 2553, 1224, 33, 238, "Input"],
Cell[87953, 2588, 929, 26, 27, "Input"],
Cell[88885, 2616, 129, 2, 27, "Input"],
Cell[89017, 2620, 129, 2, 27, "Input"],
Cell[89149, 2624, 129, 2, 27, "Input"],
Cell[89281, 2628, 641, 18, 27, "Input"],
Cell[89925, 2648, 160, 3, 27, "Input"],
Cell[90088, 2653, 699, 22, 83, "Input"],
Cell[90790, 2677, 835, 26, 104, "Input"],
Cell[91628, 2705, 281, 5, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[91946, 2715, 111, 1, 26, "Subsubtitle"],
Cell[92060, 2718, 5196, 153, 148, "Input"],
Cell[97259, 2873, 2758, 74, 328, "Input"],
Cell[100020, 2949, 155, 4, 27, "Input"],
Cell[100178, 2955, 970, 27, 148, "Input"],
Cell[101151, 2984, 1178, 31, 148, "Input"],
Cell[102332, 3017, 1196, 32, 148, "Input"],
Cell[103531, 3051, 1247, 33, 148, "Input"],
Cell[104781, 3086, 1005, 29, 148, "Input"],
Cell[105789, 3117, 1002, 29, 148, "Input"],
Cell[106794, 3148, 1052, 30, 148, "Input"],
Cell[107849, 3180, 1005, 29, 148, "Input"],
Cell[108857, 3211, 1011, 29, 148, "Input"],
Cell[109871, 3242, 1013, 29, 148, "Input"],
Cell[110887, 3273, 1013, 29, 148, "Input"],
Cell[111903, 3304, 162, 3, 27, "Input"],
Cell[112068, 3309, 148, 3, 27, "Input"],
Cell[112219, 3314, 124, 3, 27, "Input"],
Cell[112346, 3319, 123, 3, 27, "Input"],
Cell[112472, 3324, 82, 2, 27, "Input"],
Cell[112557, 3328, 126, 3, 27, "Input"],
Cell[112686, 3333, 179, 3, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[112902, 3341, 159, 2, 26, "Subsubtitle"],
Cell[113064, 3345, 181, 3, 27, "Input"],
Cell[113248, 3350, 2714, 71, 328, "Input"],
Cell[115965, 3423, 4166, 142, 148, "Input"],
Cell[120134, 3567, 255, 6, 27, "Input"],
Cell[120392, 3575, 1183, 31, 148, "Input"],
Cell[121578, 3608, 1005, 29, 148, "Input"],
Cell[122586, 3639, 1003, 29, 148, "Input"],
Cell[123592, 3670, 1054, 30, 148, "Input"],
Cell[124649, 3702, 1056, 30, 148, "Input"],
Cell[125708, 3734, 1054, 30, 148, "Input"],
Cell[126765, 3766, 150, 3, 27, "Input"],
Cell[126918, 3771, 124, 3, 27, "Input"],
Cell[127045, 3776, 124, 3, 27, "Input"],
Cell[127172, 3781, 82, 2, 27, "Input"],
Cell[127257, 3785, 124, 3, 27, "Input"],
Cell[127384, 3790, 179, 3, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[127600, 3798, 117, 1, 26, "Subsubtitle"],
Cell[127720, 3801, 563, 17, 27, "Input"],
Cell[128286, 3820, 127, 2, 27, "Input"],
Cell[128416, 3824, 157, 3, 27, "Input"],
Cell[128576, 3829, 958, 27, 27, "Input"],
Cell[129537, 3858, 1230, 35, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[130804, 3898, 157, 2, 26, "Subsubtitle"],
Cell[130964, 3902, 856, 22, 58, "Input"],
Cell[131823, 3926, 229421, 5577, 3604, "Input"],
Cell[361247, 9505, 52820, 1419, 1224, "Input"],
Cell[414070, 10926, 17051, 436, 329, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[431158, 11367, 99, 1, 26, "Subsubtitle"],
Cell[431260, 11370, 23141, 527, 1708, "Input"],
Cell[454404, 11899, 184, 2, 27, "Input"],
Cell[454591, 11903, 803, 26, 116, "Input"],
Cell[455397, 11931, 416, 12, 58, "Input"],
Cell[455816, 11945, 157, 3, 27, "Input"],
Cell[455976, 11950, 745, 19, 52, "Input"],
Cell[456724, 11971, 771, 23, 88, "Input"],
Cell[457498, 11996, 69, 2, 27, "Input"],
Cell[457570, 12000, 1349, 38, 85, "Input"],
Cell[458922, 12040, 337, 6, 27, "Input"],
Cell[459262, 12048, 758, 19, 52, "Input"],
Cell[460023, 12069, 5289, 134, 448, "Input"],
Cell[465315, 12205, 6963, 158, 678, "Input"],
Cell[472281, 12365, 480, 8, 27, "Input"],
Cell[472764, 12375, 807, 20, 52, "Input"],
Cell[473574, 12397, 5341, 135, 448, "Input"],
Cell[478918, 12534, 132, 2, 27, "Input"],
Cell[479053, 12538, 185, 4, 27, "Input"],
Cell[479241, 12544, 227, 6, 27, "Input"],
Cell[479471, 12552, 586, 13, 27, "Input"],
Cell[480060, 12567, 148, 3, 27, "Input"],
Cell[480211, 12572, 385, 7, 58, "Input"],
Cell[480599, 12581, 310, 8, 27, "Input"],
Cell[480912, 12591, 829, 13, 27, "Input"],
Cell[481744, 12606, 1056, 24, 52, "Input"],
Cell[482803, 12632, 5341, 135, 448, "Input"],
Cell[488147, 12769, 497, 12, 27, "Input"],
Cell[488647, 12783, 113, 3, 27, "Input"],
Cell[488763, 12788, 1693, 50, 58, "Input"],
Cell[490459, 12840, 1266, 39, 88, "Input"],
Cell[491728, 12881, 771, 23, 88, "Input"],
Cell[492502, 12906, 769, 23, 88, "Input"],
Cell[493274, 12931, 771, 23, 88, "Input"],
Cell[494048, 12956, 768, 23, 88, "Input"],
Cell[494819, 12981, 771, 23, 88, "Input"],
Cell[495593, 13006, 523, 14, 58, "Input"],
Cell[496119, 13022, 6019, 142, 523, "Input"],
Cell[502141, 13166, 6144, 144, 523, "Input"],
Cell[508288, 13312, 2810, 66, 103, "Input"],
Cell[511101, 13380, 4454, 114, 433, "Input"],
Cell[515558, 13496, 12364, 286, 433, "Input"],
Cell[527925, 13784, 4554, 116, 433, "Input"],
Cell[532482, 13902, 21897, 506, 763, "Input"],
Cell[554382, 14410, 323, 9, 43, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[554742, 14424, 167, 2, 26, "Subsubtitle"],
Cell[554912, 14428, 394, 7, 27, "Input"],
Cell[555309, 14437, 23926, 542, 1783, "Input"],
Cell[579238, 14981, 21829, 505, 1528, "Input"],
Cell[CellGroupData[{
Cell[601092, 15490, 263, 7, 58, "Input"],
Cell[601358, 15499, 529, 13, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[601924, 15517, 287, 8, 58, "Input"],
Cell[602214, 15527, 564, 12, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[602815, 15544, 283, 8, 58, "Input"],
Cell[603101, 15554, 446, 11, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[603584, 15570, 284, 8, 58, "Input"],
Cell[603871, 15580, 487, 11, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[604395, 15596, 334, 9, 58, "Input"],
Cell[604732, 15607, 618, 14, 27, "Output"]
}, Open  ]],
Cell[605365, 15624, 494, 12, 27, "Input"],
Cell[605862, 15638, 583, 16, 58, "Input"],
Cell[CellGroupData[{
Cell[606470, 15658, 729, 20, 27, "Input"],
Cell[607202, 15680, 585, 11, 23, "Message"],
Cell[607790, 15693, 1061, 25, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[608888, 15723, 130, 2, 27, "Input"],
Cell[609021, 15727, 183, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[609241, 15734, 5499, 138, 448, "Input"],
Cell[614743, 15874, 3598, 56, 117, "Message"],
Cell[618344, 15932, 3597, 56, 116, "Message"],
Cell[621944, 15990, 3596, 56, 117, "Message"],
Cell[625543, 16048, 3597, 56, 116, "Message"],
Cell[629143, 16106, 3596, 56, 117, "Message"],
Cell[632742, 16164, 748, 14, 23, "Message"],
Cell[633493, 16180, 802, 14, 23, "Message"],
Cell[634298, 16196, 800, 14, 23, "Message"],
Cell[635101, 16212, 800, 14, 23, "Message"],
Cell[635904, 16228, 744, 14, 23, "Message"],
Cell[CellGroupData[{
Cell[636673, 16246, 591, 14, 20, "Print"],
Cell[637267, 16262, 3268, 65, 61, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[640584, 16333, 97, 1, 27, "Input"],
Cell[640684, 16336, 841, 18, 43, "Output"]
}, Open  ]],
Cell[641540, 16357, 1274, 29, 103, "Input"],
Cell[642817, 16388, 1186, 30, 118, "Input"],
Cell[644006, 16420, 1188, 30, 118, "Input"],
Cell[645197, 16452, 1196, 30, 118, "Input"],
Cell[646396, 16484, 1211, 30, 118, "Input"],
Cell[CellGroupData[{
Cell[647632, 16518, 121, 2, 27, "Input"],
Cell[647756, 16522, 356, 5, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[648149, 16532, 1976, 55, 73, "Input"],
Cell[650128, 16589, 3610, 56, 117, "Message"],
Cell[653741, 16647, 3629, 56, 116, "Message"],
Cell[657373, 16705, 3608, 56, 117, "Message"],
Cell[660984, 16763, 758, 14, 23, "Message"],
Cell[661745, 16779, 1286, 33, 43, "Output"],
Cell[663034, 16814, 3608, 56, 117, "Message"],
Cell[666645, 16872, 3706, 57, 116, "Message"],
Cell[670354, 16931, 1068, 24, 26, "Print"]
}, Open  ]],
Cell[671437, 16958, 1483, 25, 58, "Input"],
Cell[CellGroupData[{
Cell[672945, 16987, 1235, 27, 79, "Input"],
Cell[674183, 17016, 1029, 18, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[675249, 17039, 504, 13, 27, "Input"],
Cell[675756, 17054, 693, 10, 27, "Output"]
}, Open  ]],
Cell[676464, 17067, 7873, 225, 420, "Input"],
Cell[CellGroupData[{
Cell[684362, 17296, 2459, 56, 343, "Input"],
Cell[686824, 17354, 768, 13, 20, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[687629, 17372, 147, 2, 27, "Input"],
Cell[687779, 17376, 711, 11, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[688527, 17392, 94, 1, 27, "Input"],
Cell[688624, 17395, 649, 10, 27, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[689322, 17411, 210, 3, 26, "Subsubtitle"],
Cell[689535, 17416, 833, 16, 58, "Input"],
Cell[CellGroupData[{
Cell[690393, 17436, 1283, 27, 79, "Input"],
Cell[691679, 17465, 1124, 21, 43, "Output"]
}, Open  ]],
Cell[692818, 17489, 356, 7, 27, "Input"],
Cell[693177, 17498, 2828, 58, 169, "Input"],
Cell[CellGroupData[{
Cell[696030, 17560, 122, 2, 27, "Input"],
Cell[696155, 17564, 217, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[696409, 17573, 271, 6, 27, "Input"],
Cell[696683, 17581, 312, 7, 27, "Output"]
}, Open  ]],
Cell[697010, 17591, 240, 5, 27, "Input"],
Cell[697253, 17598, 3622, 105, 235, "Input"],
Cell[700878, 17705, 2841, 58, 169, "Input"],
Cell[CellGroupData[{
Cell[703744, 17767, 176, 4, 27, "Input"],
Cell[703923, 17773, 302, 8, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[704262, 17786, 278, 9, 49, "Input"],
Cell[704543, 17797, 478, 15, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[705058, 17817, 174, 4, 27, "Input"],
Cell[705235, 17823, 206, 3, 27, "Output"]
}, Open  ]],
Cell[705456, 17829, 309, 6, 27, "Input"],
Cell[705768, 17837, 483, 8, 27, "Input"],
Cell[CellGroupData[{
Cell[706276, 17849, 2464, 56, 343, "Input"],
Cell[708743, 17907, 436, 7, 20, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[709216, 17919, 147, 2, 27, "Input"],
Cell[709366, 17923, 214, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[709617, 17932, 94, 1, 27, "Input"],
Cell[709714, 17935, 218, 4, 27, "Output"]
}, Open  ]],
Cell[709947, 17942, 111, 2, 27, "Input"],
Cell[710061, 17946, 2903, 56, 169, "Input"],
Cell[712967, 18004, 170, 3, 27, "Input"],
Cell[713140, 18009, 271, 6, 27, "Input"],
Cell[713414, 18017, 465, 14, 46, "Input"],
Cell[713882, 18033, 482, 14, 27, "Input"],
Cell[714367, 18049, 735, 22, 55, "Input"],
Cell[715105, 18073, 111, 2, 27, "Input"],
Cell[715219, 18077, 3622, 105, 235, "Input"],
Cell[718844, 18184, 2763, 54, 169, "Input"],
Cell[721610, 18240, 263, 6, 27, "Input"],
Cell[721876, 18248, 348, 9, 58, "Input"],
Cell[722227, 18259, 2412, 55, 343, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
