(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    799618,      20116]
NotebookOptionsPosition[    779278,      19553]
NotebookOutlinePosition[    780627,      19601]
CellTagsIndexPosition[    780553,      19596]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Dynamic AdS/CMT - Superconductor - Spectral - Broken phase", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
   3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
   3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
   3.495174647742872*^9, 3.460515504326817*^9}, {3.503996600043788*^9, 
   3.503996603042028*^9}, {3.507011572545054*^9, 3.460340667971311*^9}, {
   3.5374843541262083`*^9, 3.537484358716886*^9}, 3.537484391202265*^9, {
   3.537484629914453*^9, 3.537484630281348*^9}, {3.5374893532274837`*^9, 
   3.537489358050692*^9}, {3.5376274940424433`*^9, 3.537627498480837*^9}}],

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "^", "2"}]], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"-", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "0", "0"},
       {
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}], "0"},
       {"0", "0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.507011580676421*^9, 3.507011659804162*^9}, {3.507013755598536*^9, 
   3.460392698323369*^9}, {3.4604018613321533`*^9, 3.4604018646719627`*^9}, {
   3.460401965632374*^9, 3.460401968163259*^9}, {3.4604023388162813`*^9, 
   3.4604023558966084`*^9}, {3.460402422665003*^9, 3.460402426690833*^9}, {
   3.460402628586185*^9, 3.4604026419139843`*^9}, {3.460402674350209*^9, 
   3.4604026844332027`*^9}, {3.460512773931822*^9, 3.460512787444798*^9}, {
   3.4605146484667263`*^9, 3.460514650350994*^9}, {3.460514717258254*^9, 
   3.460514724283691*^9}, 3.460514770989304*^9, 3.4605223140457373`*^9, {
   3.4605327188171663`*^9, 3.460532727004561*^9}, {3.460532863547011*^9, 
   3.460532865145266*^9}, {3.460532977769042*^9, 3.4605329860852757`*^9}, {
   3.507275497143169*^9, 3.4603659980232763`*^9}, {3.537484515197036*^9, 
   3.537484572210073*^9}, 3.537484644682625*^9, {3.5374846959240923`*^9, 
   3.537484701892157*^9}, {3.537484976337736*^9, 3.5374849917355137`*^9}, {
   3.537486594817341*^9, 3.537486596777007*^9}}],

Cell[BoxData["Gd"], "Input"],

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[BoxData[
 RowBox[{
  RowBox[{"R2", "=", 
   RowBox[{"Simplify", "[", "R2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041067188341103`*^9, 3.404106720182616*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"GT", "[", 
       RowBox[{"R2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "A", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"A", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"A", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"v", ",", "d"}], "}"}], "}"}], ",", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"ST", "[", 
    RowBox[{"A", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"z", ",", "d"}], "}"}], "}"}], ",", 
     RowBox[{"az", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451383976248069*^9, 3.4513840125908737`*^9}, {
  3.451384057147691*^9, 3.451384064689735*^9}, {3.451385762395092*^9, 
  3.451385762480318*^9}, {3.451385800913571*^9, 3.451385805770357*^9}, {
  3.537484677141605*^9, 3.53748468964509*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "F", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"F", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"F", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}]}], "}"}], ",", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i2", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i1", "]"}], "]"}]}], "]"}]}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4041040239360247`*^9, 3.404104073416904*^9}, {
  3.4041057167733383`*^9, 3.4041057183570337`*^9}, {3.4513840707957897`*^9, 
  3.451384164343499*^9}, {3.460366100458836*^9, 3.460366108909464*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"trFF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"trT", "[", 
      RowBox[{
       RowBox[{"outerT", "[", 
        RowBox[{"F", ",", "F"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fsqr", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"trT", "[", 
     RowBox[{"trFF", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.404103126230957*^9, 3.404103206051724*^9}, 
   3.404103788928409*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "Dp", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"Dp", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Dp", "=", 
       RowBox[{"ST", "[", 
        RowBox[{"Dp", ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], "}"}], ",", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"\[Phi]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
          RowBox[{"I", " ", 
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], 
           RowBox[{"\[Phi]", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConjDp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "d", "}"}], ",", 
      RowBox[{"Conjugate", "[", 
       RowBox[{"Dp", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DpDp", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{"trT", "[", 
       RowBox[{
        RowBox[{"outerT", "[", 
         RowBox[{"ConjDp", ",", "Dp"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Vterm", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"\[Phi]", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "]"}], 
       RowBox[{"\[Phi]", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513844331121693`*^9, 3.451384521665413*^9}, {
   3.451384560554626*^9, 3.451384642158163*^9}, {3.4513849100950413`*^9, 
   3.451384915054587*^9}, 3.451385051803838*^9, {3.4513851171366262`*^9, 
   3.45138511927711*^9}, {3.451385175930884*^9, 3.451385183167452*^9}, {
   3.451385425505906*^9, 3.45138544324051*^9}, {3.451385490350021*^9, 
   3.451385493946774*^9}, {3.451385568392873*^9, 3.451385601054823*^9}, {
   3.451385813165941*^9, 3.4513858527683163`*^9}, {3.45138608116168*^9, 
   3.451386103913107*^9}, {3.46036707784975*^9, 3.460255762501432*^9}, {
   3.46025580130457*^9, 3.460255801461816*^9}, {3.53748492894665*^9, 
   3.53748495518618*^9}, {3.537485329580826*^9, 3.537485331297533*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DpDp", "=", 
   RowBox[{"(", 
    RowBox[{"DpDp", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Re", "[", "xx_", "]"}], "\[Rule]", "xx"}], ",", 
       RowBox[{
        RowBox[{"Im", "[", "xx_", "]"}], "\[Rule]", "0"}]}], "}"}]}], ")"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.451385894732107*^9, 3.451385976334114*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sqrtdetg", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Det", "[", 
       RowBox[{"-", "Gd"}], "]"}], "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041041692972*^9, 3.404104211096949*^9}, 
   3.404105293940057*^9, {3.4513842180130997`*^9, 3.4513842223260803`*^9}, {
   3.4513846617079067`*^9, 3.451384675916638*^9}}],

Cell[BoxData[
 RowBox[{"L", "=", 
  RowBox[{"sqrtdetg", 
   RowBox[{"(", 
    RowBox[{"Ricci", "+", "6", "-", 
     RowBox[{
      FractionBox["1", "4"], "Fsqr"}], "-", "DpDp", "-", "Vterm"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.451384367735067*^9, 3.451384393946628*^9}, {
   3.4513849054437723`*^9, 3.4513849068431387`*^9}, {3.451385606138598*^9, 
   3.451385607193993*^9}, 3.460366276193363*^9, {3.4603670917067547`*^9, 
   3.460255829896731*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp1", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp3", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.53748653613297*^9, 3.5374865918283*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GHBT", "+=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
     "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460366441552243*^9, 3.460366544772176*^9}, {
  3.4603665879440317`*^9, 3.460366626391823*^9}, {3.537486655723679*^9, 
  3.537486732610427*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L2", "=", 
   RowBox[{"L", "-", "GHBT"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460366546941235*^9, 3.460366557341961*^9}, 
   3.460366686117609*^9, {3.4603672960654507`*^9, 3.4603672977104673`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"L2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.460366666517003*^9, 3.460366674775579*^9}, {3.537486746662644*^9, 
  3.5374867639666147`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EOM", "[", "fld_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{"D", "[", 
      RowBox[{"L2", ",", "fld"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"tmp2", "=", 
           RowBox[{"D", "[", 
            RowBox[{"fld", ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ")"}], "=!=", "0"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tmp", "-=", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"L2", ",", "tmp2"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "tmp"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.4513849546200113`*^9, 3.451385039242148*^9}, {
  3.4603662728020573`*^9, 3.460366273871294*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqp", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"p", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"\[Alpha]", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513848144544163`*^9, 3.4513848150159073`*^9}, {
  3.451384869337384*^9, 3.451384875673843*^9}, {3.451384929950244*^9, 
  3.451384930100154*^9}, {3.451385060851385*^9, 3.451385213396349*^9}, {
  3.451385293160893*^9, 3.451385302528058*^9}, {3.4513853749547167`*^9, 
  3.45138537639461*^9}, {3.451385514552088*^9, 3.451385527943191*^9}, {
  3.451385862306609*^9, 3.451385882826736*^9}, {3.451386138230373*^9, 
  3.451386140019012*^9}, {3.451386241895258*^9, 3.4513862693654633`*^9}, {
  3.4603675858592987`*^9, 3.4603675914720583`*^9}, {3.537486779881022*^9, 
  3.537486784922683*^9}, {3.537486894453556*^9, 3.5374869009568243`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqav", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"av", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"az", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513855403702793`*^9, 3.451385540823719*^9}, {
  3.4513861532442207`*^9, 3.45138616739637*^9}, {3.451386251199284*^9, 
  3.4513862656960487`*^9}, {3.460367593073217*^9, 3.460367597640524*^9}, {
  3.5374867866028214`*^9, 3.537486788378339*^9}, {3.537486891597521*^9, 
  3.537486937732339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqgvz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gvz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqgzz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gzz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqT", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"T", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqS", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451386275930722*^9, 3.451386303859261*^9}, {
  3.460366711720347*^9, 3.4603667226381903`*^9}, {3.460367599130735*^9, 
  3.460367611985876*^9}, {3.53748678993122*^9, 3.53748680663302*^9}, {
  3.537486911477583*^9, 3.5374869187572203`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"gvz", ",", "gzz", ",", "az"}], "]"}]], "Input",
 CellChangeTimes->{{3.53748694036823*^9, 3.537486945275868*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"gvz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gzz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"az", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}]}], "Input",
 CellChangeTimes->{{3.460366755240944*^9, 3.460366765921853*^9}, {
   3.460379717667384*^9, 3.460379720321673*^9}, {3.4603938524268913`*^9, 
   3.4603938546559877`*^9}, 3.4603939628549967`*^9, {3.5374868640225983`*^9, 
   3.537486876197587*^9}, {3.537486924492758*^9, 3.537486925572747*^9}, {
   3.537487030062772*^9, 3.537487030117689*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqp2", "=", 
   RowBox[{"Simplify", "[", "eqp", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]2", "=", 
   RowBox[{"Simplify", "[", "eq\[Alpha]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqav2", "=", 
   RowBox[{"Simplify", "[", "eqav", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz2", "=", 
   RowBox[{"Simplify", "[", "eqaz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgvz2", "=", 
   RowBox[{"Simplify", "[", "eqgvz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgzz2", "=", 
   RowBox[{"Simplify", "[", "eqgzz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqT2", "=", 
   RowBox[{"Simplify", "[", "eqT", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"eqS2", "=", 
  RowBox[{"Simplify", "[", "eqS", "]"}]}]}], "Input",
 CellChangeTimes->{{3.460366768598325*^9, 3.4603668525536737`*^9}, {
  3.5374869590367947`*^9, 3.537486972220312*^9}}],

Cell[BoxData[
 RowBox[{"Evsol", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqgvz2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqS2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqp2", "\[Equal]", "0"}], ",", 
        RowBox[{"eq\[Alpha]2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqaz", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["p", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["\[Alpha]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["av", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4603794747692738`*^9, 3.4603795051117373`*^9}, {
   3.460379770556391*^9, 3.460379778090231*^9}, {3.537487575145343*^9, 
   3.537487601737835*^9}, {3.5374876320607243`*^9, 3.537487632172414*^9}, 
   3.5374876986147537`*^9}],

Cell[BoxData[
 RowBox[{"Momsol", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqT2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqgzz", "\[Equal]", "0"}], ",", 
        RowBox[{"eqav", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["av", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.460379791348405*^9, 3.460379854266864*^9}, {
  3.537487577120059*^9, 3.537487629667873*^9}, {3.5374877038531513`*^9, 
  3.537487709515881*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqT2", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqav", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"eqgzz", ",", "z"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"Evsol", ",", "v"}], "]"}]}], "/.", "Evsol"}], "/.", "Momsol"}],
   "]"}]}], "Input",
 CellChangeTimes->{{3.460379877349128*^9, 3.460379983100644*^9}, {
  3.460380087445326*^9, 3.460380091873478*^9}, {3.537487726936469*^9, 
  3.5374877500015907`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"a", "[", 
    RowBox[{"v", ",", "z"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"h", "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.460380576942815*^9, 3.46038057950566*^9}, {
  3.4603806147948647`*^9, 3.460380638346624*^9}, {3.5374877590000763`*^9, 
  3.537487759103163*^9}, {3.537487795719556*^9, 3.537487805166259*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Const1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Const2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Const3", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["S", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["S", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.46031768644937*^9, 3.46031772334064*^9}, {
  3.537487772329159*^9, 3.5374878178010073`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Eq1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["p", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["p", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq3", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq4", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq5", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["T", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["T", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.537489066732723*^9, 3.5374891410817547`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"p", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"h", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"a", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"T", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"S", "[", "z", "]"}]}]}], "Input",
 CellChangeTimes->{{3.537627682228917*^9, 3.537627713970744*^9}, {
  3.537636882057424*^9, 3.537636897297038*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ell1", "=", 
   RowBox[{"Simplify", "[", "Eq1", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell2", "=", 
   RowBox[{"Simplify", "[", "Eq2", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ellc1", "=", 
   RowBox[{"Simplify", "[", "Eq3", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ellc2", "=", 
   RowBox[{"Simplify", "[", "Eq4", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell3", "=", 
   RowBox[{"Simplify", "[", "Eq5", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell4", "=", 
   RowBox[{"Simplify", "[", "Const1", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell5", "=", 
   RowBox[{"Simplify", "[", "Const2", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"ellc3", "=", 
  RowBox[{"Simplify", "[", "Const3", "]"}]}]}], "Input",
 CellChangeTimes->{{3.537627679175139*^9, 3.537627742317072*^9}, {
  3.537636876281947*^9, 3.53763687844884*^9}, {3.5376379765369062`*^9, 
  3.537638074206946*^9}, {3.537638144466118*^9, 3.537638162905325*^9}}],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ell1", ",", "ell2", ",", "ell3", ",", "ell4", ",", "ell5"}], 
        "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"h", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"a", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"T", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"S", "''"}], "[", "z", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.537638077410537*^9, {3.5376381314247913`*^9, 3.537638256008617*^9}, {
   3.537638739449127*^9, 3.537638740135255*^9}, {3.537638891437305*^9, 
   3.5376388944848833`*^9}}],

Cell[BoxData[
 RowBox[{"Expand", "[", "ellc1", "]"}]], "Input",
 CellChangeTimes->{{3.537638754409368*^9, 3.537638756597229*^9}}],

Cell[BoxData[
 RowBox[{"Expand", "[", "ellc2", "]"}]], "Input",
 CellChangeTimes->{{3.537638758349153*^9, 3.537638760740986*^9}}],

Cell[BoxData[
 RowBox[{"Expand", "[", "ellc3", "]"}]], "Input",
 CellChangeTimes->{{3.537638761869357*^9, 3.537638765020914*^9}}],

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ellc1", ",", "ellc2"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"p", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537638619736205*^9, 3.53763872186449*^9}, {
  3.53763882686869*^9, 3.537638830835917*^9}, {3.537638862507595*^9, 
  3.5376388755551147`*^9}}],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"ellc3", "/.", "sol2"}], "]"}]], "Input",
 CellChangeTimes->{{3.537638838836076*^9, 3.5376388709387693`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"ellc1", ",", "z"}], "]"}], "+", 
      RowBox[{"2", 
       FractionBox[
        RowBox[{
         RowBox[{"S", "'"}], "[", "z", "]"}], 
        RowBox[{"S", "[", "z", "]"}]], " ", "ellc1"}]}], ")"}], "/.", "sol"}],
    "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"S", "[", "z", "]"}], "^", "2"}], "ellc1"}], ",", "z"}], "]"}],
    "/.", "sol"}], "]"}]}], "Input",
 CellChangeTimes->{{3.537640004014365*^9, 3.5376400814389057`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"ellc2", ",", "z"}], "]"}], "-", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"S", "'"}], "[", "z", "]"}], 
        RowBox[{"S", "[", "z", "]"}]], " ", "ellc2"}], "+", 
      RowBox[{
       FractionBox["2", "z"], " ", "ellc2"}]}], ")"}], "/.", "sol"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"z", "^", "2"}], 
       RowBox[{"S", "[", "z", "]"}]], "ellc2"}], ",", "z"}], "]"}], "/.", 
   "sol"}], "]"}]}], "Input",
 CellChangeTimes->{{3.537640004014365*^9, 3.5376401691466208`*^9}, {
  3.537640206992764*^9, 3.537640234528932*^9}}],

Cell[BoxData[
 RowBox[{"Print", "[", 
  "\"\<\\n\\nSo, if c1 and c2 are zero, and they obey simple decoupled eqns, \
then c3 also zero!\\n\\n\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.5376403237255774`*^9, 3.537640353177024*^9}, {
  3.538462192473542*^9, 3.538462193016658*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Asymptotic expansion", "Subsubtitle",
 CellChangeTimes->{{3.538463067865754*^9, 3.5384630721521673`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "p2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "p3"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", "p4"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", "p5"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "6"}], " ", "p6"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "7"}], " ", "p7"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "8"}], " ", "p8"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "9"}], " ", "p9"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "10"}], " ", "p10"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "11"}], " ", "p11"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "12"}], " ", "p12"}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", "z_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", "h2"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "3"}], " ", "h3"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "4"}], " ", "h4"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "5"}], " ", "h5"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "6"}], " ", "h6"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "7"}], " ", "h7"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "8"}], " ", "h8"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "9"}], " ", "h9"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "10"}], " ", "h10"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "11"}], " ", "h11"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "12"}], " ", "h12"}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "z_", "]"}], ":=", 
    RowBox[{"a0", "+", 
     RowBox[{"z", " ", "a1"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", "a2"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", "a3"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", "a4"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", "a5"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "6"}], " ", "a6"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "7"}], " ", "a7"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "8"}], " ", "a8"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "9"}], " ", "a9"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "10"}], " ", "a10"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "11"}], " ", "a11"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "12"}], " ", "a12"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "z_", "]"}], ":=", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], "T2"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", "T3"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", "T4"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "5"}], " ", "T5"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "6"}], " ", "T6"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "7"}], " ", "T7"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "8"}], " ", "T8"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "9"}], " ", "T9"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "10"}], " ", "T10"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "11"}], " ", "T11"}], "+", 
     RowBox[{
      RowBox[{"z", "^", "12"}], " ", "T12"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], "S2"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "3"}], " ", "S3"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "4"}], " ", "S4"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "5"}], " ", "S5"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "6"}], " ", "S6"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "7"}], " ", "S7"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "8"}], " ", "S8"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "9"}], " ", "S9"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "10"}], " ", "S10"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "11"}], " ", "S11"}], "+", 
    RowBox[{
     RowBox[{"z", "^", "12"}], " ", "S12"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.53748941244459*^9, 3.537489445611642*^9}, {
   3.5374894786832*^9, 3.537489485162715*^9}, {3.537489733829163*^9, 
   3.537489756225297*^9}, {3.5374900951164503`*^9, 3.537490119568275*^9}, {
   3.53749015373587*^9, 3.537490153855693*^9}, {3.537490212456991*^9, 
   3.537490237348768*^9}, {3.537490394647192*^9, 3.537490453890482*^9}, {
   3.537490792048935*^9, 3.537490804720195*^9}, {3.537490860205984*^9, 
   3.537490863100896*^9}, {3.5374908962097483`*^9, 3.537490902905895*^9}, {
   3.537491099280459*^9, 3.5374911037619123`*^9}, {3.5374911421214113`*^9, 
   3.537491208593452*^9}, {3.537577393872981*^9, 3.537577398304707*^9}, {
   3.537639022648444*^9, 3.537639113606564*^9}, {3.5381377672688637`*^9, 
   3.5381378365486183`*^9}, 3.538137882235326*^9, {3.538462674627036*^9, 
   3.538462715657539*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "repl", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp1", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ellc1", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp2", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ellc2", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp3", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ellc3", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp4", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell1", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp5", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell2", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp6", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell3", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp7", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell4", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp8", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell5", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}]}], "Input",
 CellChangeTimes->{{3.5376392293063307`*^9, 3.5376392299215183`*^9}, {
  3.538137895519271*^9, 3.538137930215798*^9}, {3.538462288648322*^9, 
  3.538462297761071*^9}, {3.538462392692498*^9, 3.538462394764674*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538462300919333*^9, 3.538462302093458*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol2", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"T2", ",", "S2", ",", "a2"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", "sol2"}], ";"}]}], "Input",
 CellChangeTimes->{{3.538137931998144*^9, 3.5381379817888117`*^9}, {
  3.538462209912683*^9, 3.53846221643303*^9}, {3.538462371290099*^9, 
  3.538462373609942*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "2"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p3", ",", "h3", ",", "a3", ",", "S3"}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol3"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538137931998144*^9, 3.5381379817888117`*^9}, {
  3.538462209912683*^9, 3.53846221643303*^9}, {3.5384623133361*^9, 
  3.5384623208626213`*^9}, {3.538462364372213*^9, 3.538462367474139*^9}, {
  3.53846240258596*^9, 3.538462463009907*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "3"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p4", ",", "h4", ",", "a4", ",", "S4", ",", "T4"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol4"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538137931998144*^9, 3.5381379817888117`*^9}, {
  3.538462209912683*^9, 3.53846221643303*^9}, {3.5384623133361*^9, 
  3.5384623208626213`*^9}, {3.538462364372213*^9, 3.538462367474139*^9}, {
  3.53846240258596*^9, 3.538462491570972*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p5", ",", "h5", ",", "a5", ",", "S5", ",", "T5"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol5"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538137931998144*^9, 3.5381379817888117`*^9}, {
  3.538462209912683*^9, 3.53846221643303*^9}, {3.5384623133361*^9, 
  3.5384623208626213`*^9}, {3.538462364372213*^9, 3.538462367474139*^9}, {
  3.53846240258596*^9, 3.5384625169946136`*^9}, {3.538462592429839*^9, 
  3.538462602884987*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "5"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p6", ",", "h6", ",", "a6", ",", "S6", ",", "T6"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol6"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538462610229724*^9, 3.5384626262991323`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "6"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p7", ",", "h7", ",", "a7", ",", "S7", ",", "T7"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol7"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538462610229724*^9, 3.53846264220479*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "7"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol8", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p8", ",", "h8", ",", "a8", ",", "S8", ",", "T8"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol8"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538462610229724*^9, 3.53846264220479*^9}, {
  3.5384627311973467`*^9, 3.53846274069244*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "8"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol9", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p9", ",", "h9", ",", "a9", ",", "S9", ",", "T9"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol9"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538462747749477*^9, 3.5384627639226007`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "9"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol10", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p10", ",", "h10", ",", "a10", ",", "S10", ",", "T10"}], 
        "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol10"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538462772165017*^9, 3.53846278770794*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "10"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol11", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p11", ",", "h11", ",", "a11", ",", "S11", ",", "T11"}], 
        "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol11"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538462774004135*^9, 3.538462809307893*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "11"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol12", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"p12", ",", "h12", ",", "a12", ",", "S12", ",", "T12"}], 
        "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol12"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538462776243325*^9, 3.538462824259987*^9}}],

Cell[BoxData[
 RowBox[{"repl", "=", 
  RowBox[{"FullSimplify", "[", "repl", "]"}]}]], "Input",
 CellChangeTimes->{{3.538462876166841*^9, 3.5384628864493513`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{{3.538462838910104*^9, 3.538462866002865*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{3.538462864194768*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{3.53846286309058*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", "z", "]"}], "//.", "repl"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"S", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{3.5384628615876102`*^9}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "]"}]], "Input",
 CellChangeTimes->{{3.537640737015723*^9, 3.5376407595390577`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Horizon expansion", "Subsubtitle",
 CellChangeTimes->{{3.538463067865754*^9, 3.5384630721521673`*^9}, {
  3.5384631960168037`*^9, 3.538463196751625*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"T", ",", "S", ",", "a", ",", "p", ",", "h"}], "]"}]], "Input",
 CellChangeTimes->{{3.5384635355243692`*^9, 3.5384635391803713`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "repl", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp1", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ellc1", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", "pos"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp2", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ellc2", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", "pos"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp3", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ellc3", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", "pos"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp4", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell1", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", "pos"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp5", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell2", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", "pos"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp6", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell3", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp7", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell4", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp8", "=", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"ell5", "/.", "repl"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "z0", ",", 
         RowBox[{"pos", "-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}]}], "Input",
 CellChangeTimes->{{3.5376392293063307`*^9, 3.5376392299215183`*^9}, {
  3.538137895519271*^9, 3.538137930215798*^9}, {3.538462288648322*^9, 
  3.538462297761071*^9}, {3.538462392692498*^9, 3.538462394764674*^9}, {
  3.538463498120213*^9, 3.538463502943193*^9}, {3.538463596257093*^9, 
  3.538463601832757*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"t1", 
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}]}], "+", 
    RowBox[{"t2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"t3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"t4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "4"}]}], "+", 
    RowBox[{"t5", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "5"}]}], "+", 
    RowBox[{"t6", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "6"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", "z_", "]"}], ":=", 
   RowBox[{"s0", "+", 
    RowBox[{"s1", 
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}]}], "+", 
    RowBox[{"s2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"s3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"s4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "4"}]}], "+", 
    RowBox[{"s5", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "5"}]}], "+", 
    RowBox[{"s6", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "6"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{"a0", "+", 
    RowBox[{"a1", 
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}]}], "+", 
    RowBox[{"a2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"a3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"a4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "4"}]}], "+", 
    RowBox[{"a5", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "5"}]}], "+", 
    RowBox[{"a6", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "6"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", 
   RowBox[{"p0", "+", 
    RowBox[{"p1", 
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}]}], "+", 
    RowBox[{"p2", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"p3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"p4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "4"}]}], "+", 
    RowBox[{"p5", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "5"}]}], "+", 
    RowBox[{"p6", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z0", "-", "z"}], ")"}], "^", "6"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "[", "z_", "]"}], ":=", 
  RowBox[{"h0", "+", 
   RowBox[{"h1", 
    RowBox[{"(", 
     RowBox[{"z0", "-", "z"}], ")"}]}], "+", 
   RowBox[{"h2", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}], "^", "2"}]}], "+", 
   RowBox[{"h3", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}], "^", "3"}]}], "+", 
   RowBox[{"h4", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}], "^", "4"}]}], "+", 
   RowBox[{"h5", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}], "^", "5"}]}], "+", 
   RowBox[{"h6", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z0", "-", "z"}], ")"}], "^", "6"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.537692460831832*^9, 3.537692571971863*^9}, {
   3.537692934161448*^9, 3.537692935150085*^9}, {3.5384635465997868`*^9, 
   3.5384635932491283`*^9}, 3.538463667298936*^9, {3.538463699260297*^9, 
   3.5384636995001097`*^9}, {3.538463822292626*^9, 3.538463863510054*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538462300919333*^9, 3.538462302093458*^9}, {
  3.538463560317108*^9, 3.538463563740576*^9}, {3.5384636102038717`*^9, 
  3.538463611852014*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"a0", ",", "p1", ",", "h1", ",", "s1"}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol1"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538137931998144*^9, 3.5381379817888117`*^9}, {
  3.538462209912683*^9, 3.53846221643303*^9}, {3.538462371290099*^9, 
  3.538462373609942*^9}, {3.5384635209823008`*^9, 3.538463551212698*^9}, {
  3.538463617916279*^9, 3.5384637274578114`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"a2", ",", "p2", ",", "h2", ",", "s2", ",", "t2"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol2"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538463738305477*^9, 3.5384637769691477`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "2"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"a3", ",", "p3", ",", "h3", ",", "s3", ",", "t3"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol3"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538463738305477*^9, 3.538463797800817*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "3"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"a4", ",", "p4", ",", "h4", ",", "s4", ",", "t4"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol4"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538463738305477*^9, 3.538463797800817*^9}, {
  3.5384639094954557`*^9, 3.538463917350461*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"a5", ",", "p5", ",", "h5", ",", "s5", ",", "t5"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol5"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538463738305477*^9, 3.538463797800817*^9}, {
  3.5384639094954557`*^9, 3.5384639327501297`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "5"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"runeq", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmplist", "=", 
   RowBox[{"{", 
    RowBox[{
    "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", "tmp6", 
     ",", "tmp7", ",", "tmp8"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"tmplist", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"a6", ",", "p6", ",", "h6", ",", "s6", ",", "t6"}], "}"}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", "sol6"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538463738305477*^9, 3.538463797800817*^9}, {
  3.5384639094954557`*^9, 3.538463956934313*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{{3.538463967809574*^9, 3.5384639792942257`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{3.538463981029242*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{3.538463982933107*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", "z", "]"}], "//.", "repl"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"S", "[", "z", "]"}], "//.", "repl"}]], "Input",
 CellChangeTimes->{3.538463984821121*^9}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "]"}]], "Input",
 CellChangeTimes->{{3.5384640959611263`*^9, 3.538464099700382*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Radial evolution equations", "Subsubtitle",
 CellChangeTimes->{{3.538463067865754*^9, 3.5384630910323133`*^9}}],

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ellc1", "\[Equal]", "0"}], ",", 
       RowBox[{"ellc2", "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"T", "'"}], "[", "z", "]"}], ",", 
       RowBox[{
        RowBox[{"h", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.538046181988859*^9, 3.538046275572392*^9}, {
  3.538118511452941*^9, 3.5381185296755857`*^9}}],

Cell[BoxData[
 RowBox[{"Expand", "[", "tmp", "]"}]], "Input",
 CellChangeTimes->{{3.538138653550453*^9, 3.538138655138913*^9}}],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"ellc3", "/.", "tmp"}], "]"}]], "Input",
 CellChangeTimes->{{3.538046278386948*^9, 3.538046283644046*^9}}],

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ell1", "\[Equal]", "0"}], ",", 
       RowBox[{"ell4", "\[Equal]", "0"}], ",", 
       RowBox[{"ell5", "\[Equal]", "0"}], ",", 
       RowBox[{"ellc1", "\[Equal]", "0"}], ",", 
       RowBox[{"ellc2", "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"p", "''"}], "[", "z", "]"}], ",", 
       RowBox[{
        RowBox[{"a", "''"}], "[", "z", "]"}], ",", 
       RowBox[{
        RowBox[{"S", "''"}], "[", "z", "]"}], ",", 
       RowBox[{
        RowBox[{"T", "'"}], "[", "z", "]"}], ",", 
       RowBox[{
        RowBox[{"h", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.538046946386949*^9, 3.538046971865954*^9}, {
  3.538047767565443*^9, 3.538047777835328*^9}, {3.538118570663123*^9, 
  3.538118592110586*^9}}],

Cell[BoxData[
 RowBox[{"eqlist", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"p", "''"}], "[", "z", "]"}], ",", 
      RowBox[{
       RowBox[{"a", "''"}], "[", "z", "]"}], ",", 
      RowBox[{
       RowBox[{"S", "''"}], "[", "z", "]"}], ",", 
      RowBox[{
       RowBox[{"T", "'"}], "[", "z", "]"}], ",", 
      RowBox[{
       RowBox[{"h", "'"}], "[", "z", "]"}]}], "}"}], "==", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"a", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"S", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"T", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"h", "'"}], "[", "z", "]"}]}], "}"}], "/.", 
      RowBox[{"tmp", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.538046982617304*^9, 3.538047031616665*^9}, {
  3.538047095238578*^9, 3.538047109277329*^9}, {3.538047742727194*^9, 
  3.538047743310781*^9}, {3.538047780875566*^9, 3.53804778166721*^9}, {
  3.5381186282311773`*^9, 3.5381186428306227`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Summary - Must Run.", "Subsubtitle",
 CellChangeTimes->{{3.538463037602364*^9, 3.538463043377323*^9}, {
  3.538464312857139*^9, 3.538464319392853*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"replasym", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p2", "\[Rule]", "asymp2"}], ",", 
      RowBox[{"h2", "\[Rule]", "asymh2"}], ",", 
      RowBox[{"a0", "\[Rule]", "asyma0"}], ",", 
      RowBox[{"a1", "\[Rule]", "asyma1"}], ",", 
      RowBox[{"T3", "\[Rule]", "asymT3"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"replhoriz", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t1", "\[Rule]", "horizt1"}], ",", 
     RowBox[{"a1", "\[Rule]", "horiza1"}], ",", 
     RowBox[{"p0", "\[Rule]", "horizp0"}], ",", 
     RowBox[{"h0", "\[Rule]", "horizh0"}], ",", 
     RowBox[{"s0", "\[Rule]", "horizs0"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.537873163678542*^9, 3.537873275606132*^9}, {
  3.538464304756454*^9, 3.53846431129167*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"horizp", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"p0", "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "p0"}], "+", 
          RowBox[{"a1", " ", "h0", " ", 
           SuperscriptBox["z0", "2"]}]}], ")"}]}], 
       RowBox[{"t1", " ", 
        SuperscriptBox["z0", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["p0", "3"]}], "+", 
          RowBox[{"4", " ", "p0", " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["h0", "2"]}], "-", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "-", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
          RowBox[{"a1", " ", "h0", " ", 
           SuperscriptBox["z0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"28", "-", 
             RowBox[{"8", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["t1", "2"], " ", 
        SuperscriptBox["z0", "4"]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"36", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "6"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "24"}], " ", 
          SuperscriptBox["p0", "5"]}], "-", 
         RowBox[{"24", " ", 
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"3", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
         RowBox[{"3", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "16"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"p0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "296"}], "-", 
            RowBox[{"24", " ", 
             SuperscriptBox["h0", "4"]}], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"78", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"72", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               RowBox[{"t1", " ", "z0"}]}], ")"}]}], "-", 
            RowBox[{"36", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "108"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"11", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"2304", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1152", " ", 
          SuperscriptBox["p0", "7"]}], "+", 
         RowBox[{"1728", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "4"], " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"192", " ", 
          SuperscriptBox["p0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"85", "+", 
            RowBox[{"18", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"24", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
         RowBox[{"24", " ", 
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"2352", "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["h0", "4"]}], "-", 
            RowBox[{"1728", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"32", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}]}], ")"}]}]}], ")"}]}], 
         "-", 
         RowBox[{"6", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3664"}], "-", 
            RowBox[{"576", " ", 
             SuperscriptBox["h0", "2"]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"21", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"96", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"p0", " ", 
          RowBox[{"(", 
           RowBox[{"40960", "+", 
            RowBox[{"1152", " ", 
             SuperscriptBox["h0", "6"]}], "-", 
            RowBox[{"4608", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"12720", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"3672", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"27", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"192", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}]}], ")"}]}], "-", 
            RowBox[{"3456", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"384", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "148"}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"24", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "-", 
               RowBox[{"1728", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"288", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"32", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"23584", "+", 
            RowBox[{"864", " ", 
             SuperscriptBox["h0", "4"]}], "-", 
            RowBox[{"1152", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"5520", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"30", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"432", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"288", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"108", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"3664", "-", 
               RowBox[{"96", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"21", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"96", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"57600", " ", 
         SuperscriptBox["t1", "5"], " ", 
         SuperscriptBox["z0", "10"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"23040", " ", 
          SuperscriptBox["p0", "9"]}], "+", 
         RowBox[{"2304", " ", 
          SuperscriptBox["p0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"193", "+", 
            RowBox[{"40", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
         RowBox[{"96", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "6"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"308", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["p0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"80860", "+", 
            RowBox[{"4320", " ", 
             SuperscriptBox["h0", "4"]}], "-", 
            RowBox[{"51000", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"354", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"75", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"216", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "193"}], "+", 
               RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}]}], ")"}]}], 
         "-", 
         RowBox[{"12", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "4"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "44576"}], "+", 
            RowBox[{"14400", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"432", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"24", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"2472064", "+", 
            RowBox[{"46080", " ", 
             SuperscriptBox["h0", "6"]}], "+", 
            RowBox[{"1036800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"115200", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"23856", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"6216", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"2235", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"3456", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "193"}], "+", 
               RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"32", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"80860", "-", 
               RowBox[{"51000", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"7200", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"354", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"1200", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2352", "-", 
               RowBox[{"32", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"6", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "413408"}], "-", 
            RowBox[{"19536", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"6614", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"75", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"4800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "44576"}], "+", 
               RowBox[{"14400", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"432", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"100", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3664"}], "+", 
               RowBox[{"96", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"21", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "p0", " ", 
          RowBox[{"(", 
           RowBox[{"1177600", "+", 
            RowBox[{"11520", " ", 
             SuperscriptBox["h0", "8"]}], "-", 
            RowBox[{"253712", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"258312", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"6993", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"1152", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "193"}], "+", 
               RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"80860", "-", 
               RowBox[{"51000", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"7200", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"354", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"9600", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "148"}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"50", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "40960"}], "+", 
               RowBox[{"12720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3672", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2472064", "+", 
               RowBox[{"1036800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"115200", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"23856", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"6216", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"2235", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"1200", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "-", 
                  RowBox[{"32", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "96"}], " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "44576"}], "+", 
               RowBox[{"14400", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"432", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "511616"}], "-", 
               RowBox[{"240464", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"11520", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"1296", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"159", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"5760", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"28", "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"5760", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"108", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"80", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "11792"}], "-", 
                  RowBox[{"2760", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"15", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "413408"}], "-", 
               RowBox[{"19536", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"6614", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3664"}], "+", 
                  RowBox[{"96", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"21", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"4147200", " ", 
         SuperscriptBox["t1", "6"], " ", 
         SuperscriptBox["z0", "12"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1382400", " ", 
          SuperscriptBox["p0", "11"]}], "+", 
         RowBox[{"46080", " ", 
          SuperscriptBox["p0", "9"], " ", 
          RowBox[{"(", 
           RowBox[{"731", "+", 
            RowBox[{"150", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
         RowBox[{"9216", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "8"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"178", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"4608", " ", 
          SuperscriptBox["p0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"60521", "+", 
            RowBox[{"3000", " ", 
             SuperscriptBox["h0", "4"]}], "-", 
            RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"4500", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"383", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"50", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"40", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}]}], ")"}]}], 
         "-", 
         RowBox[{"1152", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "6"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "32684"}], "-", 
            RowBox[{"882", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"45", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"32", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"30", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"288", " ", 
          SuperscriptBox["p0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"3218720", "+", 
            RowBox[{"48000", " ", 
             SuperscriptBox["h0", "6"]}], "+", 
            RowBox[{"1020000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"96000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"64496", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"13756", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"125", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"960", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"60521", "-", 
               RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"383", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"50", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "80860"}], "-", 
               RowBox[{"354", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"36", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "4"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"7514816", "+", 
            RowBox[{"864000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"378208", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"36984", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"1785", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"1536", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"120", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "44576"}], "-", 
               RowBox[{"432", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "32684"}], "-", 
               RowBox[{"882", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"30", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"308", "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"36", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "18272128"}], "-", 
            RowBox[{"3170720", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"579960", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"16350", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"45", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"96000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1024", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"3000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3664"}], "+", 
               RowBox[{"96", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"21", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"60", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "413408"}], "-", 
               RowBox[{"19536", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"6614", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "32684"}], "-", 
               RowBox[{"882", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"30", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"308", "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"7514816", "+", 
               RowBox[{"864000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"378208", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"36984", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1785", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "44576"}], "-", 
                  RowBox[{"432", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"15", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"193580032", "+", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["h0", "8"]}], "-", 
            RowBox[{"41472000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"6178176", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"3456000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"4416240", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"677328", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"13725", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"30720", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"2304", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"60521", "-", 
               RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"383", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"50", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"72000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "-", 
               RowBox[{"32", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"120", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2472064", "-", 
               RowBox[{"23856", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"6216", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"2235", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3218720"}], "-", 
               RowBox[{"1020000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"96000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"64496", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13756", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"125", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"40", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "80860"}], "-", 
                  RowBox[{"354", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"75", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"3", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "133539840"}], "-", 
            RowBox[{"110648384", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"1382400", " ", 
             SuperscriptBox["t1", "5"], " ", 
             SuperscriptBox["z0", "5"]}], "-", 
            RowBox[{"1007184", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"319524", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"1125", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"864000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"3072", " ", 
             SuperscriptBox["h0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"108", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"24000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "11792"}], "-", 
               RowBox[{"2760", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"600", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "511616"}], "-", 
               RowBox[{"240464", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"1296", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"159", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"384", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "32684"}], "-", 
               RowBox[{"882", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"30", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"308", "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"7514816", "+", 
               RowBox[{"864000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"378208", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"36984", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1785", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "44576"}], "-", 
                  RowBox[{"432", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"15", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"18272128", "+", 
               RowBox[{"3170720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"579960", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"16350", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"96000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3664"}], "+", 
                  RowBox[{"96", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"21", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "413408"}], "-", 
                  RowBox[{"19536", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"6614", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"75", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"2", " ", "p0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"691200", " ", 
             SuperscriptBox["h0", "10"]}], "-", 
            RowBox[{"23040", " ", 
             SuperscriptBox["h0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"2304", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"60521", "-", 
               RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"383", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"50", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"144", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3218720"}], "-", 
               RowBox[{"1020000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"96000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"64496", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13756", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"125", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"40", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "80860"}], "-", 
                  RowBox[{"354", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"75", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"193580032", "-", 
               RowBox[{"41472000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"6178176", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3456000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"4416240", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"677328", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"13725", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"72000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "-", 
                  RowBox[{"32", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2472064", "-", 
                  RowBox[{"23856", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"6216", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"2235", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "51673600"}], "+", 
               RowBox[{"196512", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"1036800", " ", 
                SuperscriptBox["t1", "5"], " ", 
                SuperscriptBox["z0", "5"]}], "+", 
               RowBox[{"19930272", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1292418", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"4095", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"1296000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "8"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"288000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "148"}], "+", 
                  RowBox[{"39", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"2250", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "40960"}], "+", 
                  RowBox[{"12720", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3672", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"27", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}], "-", 
               RowBox[{"90", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1177600"}], "+", 
                  RowBox[{"253712", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"258312", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"6993", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"horizh", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"h0", "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "h0"}], "+", 
          RowBox[{"a1", " ", "p0", " ", 
           SuperscriptBox["z0", "2"]}]}], ")"}]}], 
       RowBox[{"t1", " ", 
        SuperscriptBox["z0", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["h0", "3"]}], "+", 
          RowBox[{"4", " ", "h0", " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["p0", "2"]}], "-", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "-", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
          RowBox[{"a1", " ", "p0", " ", 
           SuperscriptBox["z0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"28", "-", 
             RowBox[{"8", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["t1", "2"], " ", 
        SuperscriptBox["z0", "4"]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"36", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "6"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "24"}], " ", 
          SuperscriptBox["h0", "5"]}], "-", 
         RowBox[{"24", " ", 
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"3", " ", "t1", " ", "z0"}]}], ")"}]}], "-", 
         RowBox[{"3", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "16"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"h0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "296"}], "-", 
            RowBox[{"24", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"78", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"72", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               RowBox[{"t1", " ", "z0"}]}], ")"}]}], "-", 
            RowBox[{"36", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", "a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"108", "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"11", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"16", "-", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"3", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"2304", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1152", " ", 
          SuperscriptBox["h0", "7"]}], "-", 
         RowBox[{"1728", " ", "a1", " ", 
          SuperscriptBox["h0", "4"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"192", " ", 
          SuperscriptBox["h0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"85", "+", 
            RowBox[{"18", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"24", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
         RowBox[{"24", " ", 
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"2352", "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"1728", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"32", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}]}], ")"}]}]}], ")"}]}], 
         "+", 
         RowBox[{"6", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3664"}], "-", 
            RowBox[{"576", " ", 
             SuperscriptBox["p0", "2"]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"21", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"96", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"h0", " ", 
          RowBox[{"(", 
           RowBox[{"40960", "+", 
            RowBox[{"1152", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"4608", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"12720", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"3672", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"27", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"192", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}]}], ")"}]}], "-", 
            RowBox[{"3456", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"384", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "148"}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"24", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "-", 
               RowBox[{"1728", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"288", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"32", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "864"}], " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3664"}], "+", 
               RowBox[{"96", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"21", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"96", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "11792"}], "+", 
               RowBox[{"576", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"2760", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"216", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"28", "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"144", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"108", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"57600", " ", 
         SuperscriptBox["t1", "5"], " ", 
         SuperscriptBox["z0", "10"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"23040", " ", 
          SuperscriptBox["h0", "9"]}], "+", 
         RowBox[{"2304", " ", 
          SuperscriptBox["h0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"193", "+", 
            RowBox[{"40", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}], "-", 
         RowBox[{"96", " ", "a1", " ", 
          SuperscriptBox["h0", "6"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"308", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["h0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"80860", "+", 
            RowBox[{"4320", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"51000", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"354", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"75", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"216", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "193"}], "+", 
               RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}]}], ")"}]}], 
         "+", 
         RowBox[{"12", " ", "a1", " ", 
          SuperscriptBox["h0", "4"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "44576"}], "+", 
            RowBox[{"14400", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"432", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"24", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"2472064", "+", 
            RowBox[{"46080", " ", 
             SuperscriptBox["p0", "6"]}], "+", 
            RowBox[{"1036800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"115200", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"23856", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"6216", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"2235", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"3456", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "193"}], "+", 
               RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"32", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"80860", "-", 
               RowBox[{"51000", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"7200", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"354", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"1200", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2352", "-", 
               RowBox[{"32", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"6", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "413408"}], "-", 
            RowBox[{"19536", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"6614", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"75", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"4800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "44576"}], "+", 
               RowBox[{"14400", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"432", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"100", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3664"}], "+", 
               RowBox[{"96", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"21", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "h0", " ", 
          RowBox[{"(", 
           RowBox[{"1177600", "+", 
            RowBox[{"11520", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"253712", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"258312", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"6993", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"1152", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "193"}], "+", 
               RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"80860", "-", 
               RowBox[{"51000", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"7200", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"354", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"9600", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "148"}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"50", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "40960"}], "+", 
               RowBox[{"12720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3672", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2472064", "+", 
               RowBox[{"1036800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"115200", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"23856", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"6216", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"2235", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"1200", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "-", 
                  RowBox[{"32", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "44576"}], "+", 
               RowBox[{"14400", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"432", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"511616", "+", 
               RowBox[{"240464", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"11520", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"1296", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"159", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"5760", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"28", "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"5760", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"108", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"80", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "11792"}], "-", 
                  RowBox[{"2760", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"15", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"6", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "413408"}], "-", 
               RowBox[{"19536", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"6614", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3664"}], "+", 
                  RowBox[{"96", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"21", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"4147200", " ", 
         SuperscriptBox["t1", "6"], " ", 
         SuperscriptBox["z0", "12"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1382400", " ", 
          SuperscriptBox["h0", "11"]}], "+", 
         RowBox[{"46080", " ", 
          SuperscriptBox["h0", "9"], " ", 
          RowBox[{"(", 
           RowBox[{"731", "+", 
            RowBox[{"150", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "-", 
         RowBox[{"9216", " ", "a1", " ", 
          SuperscriptBox["h0", "8"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"178", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"4608", " ", 
          SuperscriptBox["h0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"60521", "+", 
            RowBox[{"3000", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"4500", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"383", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"50", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"40", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}]}], ")"}]}], 
         "+", 
         RowBox[{"1152", " ", "a1", " ", 
          SuperscriptBox["h0", "6"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "32684"}], "-", 
            RowBox[{"882", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"45", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"32", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"30", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"288", " ", 
          SuperscriptBox["h0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"3218720", "+", 
            RowBox[{"48000", " ", 
             SuperscriptBox["p0", "6"]}], "+", 
            RowBox[{"1020000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"96000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"64496", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"13756", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"125", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"960", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"60521", "-", 
               RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"383", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"50", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "80860"}], "-", 
               RowBox[{"354", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"36", " ", "a1", " ", 
          SuperscriptBox["h0", "4"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"7514816", "+", 
            RowBox[{"864000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"378208", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"36984", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"1785", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"1536", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"120", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "44576"}], "-", 
               RowBox[{"432", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "32684"}], "-", 
               RowBox[{"882", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"30", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"308", "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"36", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "18272128"}], "-", 
            RowBox[{"3170720", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"579960", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"16350", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"45", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"96000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1024", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"3000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3664"}], "+", 
               RowBox[{"96", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"21", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"60", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "413408"}], "-", 
               RowBox[{"19536", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"6614", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "32684"}], "-", 
               RowBox[{"882", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"30", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"308", "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"7514816", "+", 
               RowBox[{"864000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"378208", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"36984", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1785", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "44576"}], "-", 
                  RowBox[{"432", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"15", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"193580032", "+", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"41472000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"6178176", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"3456000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"4416240", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"677328", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"13725", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"30720", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"2304", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"60521", "-", 
               RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"383", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"50", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"72000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "-", 
               RowBox[{"32", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"120", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2472064", "-", 
               RowBox[{"23856", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"6216", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"2235", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3218720"}], "-", 
               RowBox[{"1020000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"96000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"64496", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13756", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"125", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"40", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "80860"}], "-", 
                  RowBox[{"354", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"75", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"3", " ", "a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "133539840"}], "-", 
            RowBox[{"110648384", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"1382400", " ", 
             SuperscriptBox["t1", "5"], " ", 
             SuperscriptBox["z0", "5"]}], "-", 
            RowBox[{"1007184", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"319524", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"1125", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"864000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"3072", " ", 
             SuperscriptBox["p0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"108", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"24000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "11792"}], "-", 
               RowBox[{"2760", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"600", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "511616"}], "-", 
               RowBox[{"240464", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"1296", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"159", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"384", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "32684"}], "-", 
               RowBox[{"882", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"30", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"308", "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"7514816", "+", 
               RowBox[{"864000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"378208", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"36984", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1785", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "44576"}], "-", 
                  RowBox[{"432", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"15", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"18272128", "+", 
               RowBox[{"3170720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"579960", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"16350", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"96000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3664"}], "+", 
                  RowBox[{"96", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"21", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "413408"}], "-", 
                  RowBox[{"19536", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"6614", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"75", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"2", " ", "h0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"691200", " ", 
             SuperscriptBox["p0", "10"]}], "-", 
            RowBox[{"23040", " ", 
             SuperscriptBox["p0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"2304", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"60521", "-", 
               RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"383", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"50", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"144", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3218720"}], "-", 
               RowBox[{"1020000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"96000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"64496", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13756", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"125", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"40", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "80860"}], "-", 
                  RowBox[{"354", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"75", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"193580032", "-", 
               RowBox[{"41472000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"6178176", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3456000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"4416240", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"677328", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"13725", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"72000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "-", 
                  RowBox[{"32", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2472064", "-", 
                  RowBox[{"23856", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"6216", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"2235", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "51673600"}], "+", 
               RowBox[{"196512", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"1036800", " ", 
                SuperscriptBox["t1", "5"], " ", 
                SuperscriptBox["z0", "5"]}], "+", 
               RowBox[{"19930272", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1292418", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"4095", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"1296000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "8"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"288000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "148"}], "+", 
                  RowBox[{"39", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"2250", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "40960"}], "+", 
                  RowBox[{"12720", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3672", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"27", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}], "-", 
               RowBox[{"90", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1177600"}], "+", 
                  RowBox[{"253712", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"258312", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"6993", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"horiza", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"a1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}]}], "+", 
      FractionBox[
       RowBox[{"a1", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "12"}], "+", 
          RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
          RowBox[{
           SuperscriptBox["a1", "2"], " ", 
           SuperscriptBox["z0", "4"]}]}], ")"}]}], 
       RowBox[{"4", " ", "t1", " ", 
        SuperscriptBox["z0", "2"]}]], "+", 
      FractionBox[
       RowBox[{"a1", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["h0", "4"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["p0", "4"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["h0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"28", "+", 
             RowBox[{"8", " ", 
              SuperscriptBox["p0", "2"]}], "-", 
             RowBox[{"3", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "12"}], "+", 
              RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
              RowBox[{
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}], "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["p0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "28"}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"48", " ", 
        SuperscriptBox["t1", "2"], " ", 
        SuperscriptBox["z0", "4"]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"192", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "6"]}]], "a1", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "64"}], " ", 
          SuperscriptBox["h0", "6"]}], "-", 
         RowBox[{"64", " ", 
          SuperscriptBox["p0", "6"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"52", "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"12", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "3"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "52"}], "+", 
            RowBox[{"12", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1712", "-", 
            RowBox[{"272", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"24", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "28"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1712", "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"672", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"272", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"72", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "52"}], "+", 
               RowBox[{"12", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"3840", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}]], "a1", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1280", " ", 
          SuperscriptBox["h0", "8"]}], "+", 
         RowBox[{"1280", " ", 
          SuperscriptBox["p0", "8"]}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"704", "+", 
            RowBox[{"160", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"160", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"35", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "4"]}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "704"}], "+", 
            RowBox[{"160", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"35", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"34544", "+", 
            RowBox[{"1920", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"3936", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"129", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"320", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "52"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"34544", "+", 
            RowBox[{"1920", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"1920", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"3936", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"129", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"320", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "52"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"24", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "704"}], "+", 
               RowBox[{"160", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "176768"}], "+", 
            RowBox[{"37808", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"2544", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"63", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"960", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "28"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"80", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1712", "-", 
               RowBox[{"272", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"176768", "+", 
            RowBox[{"2560", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"37808", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"2544", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"63", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"960", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "28"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "704"}], "+", 
               RowBox[{"160", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"80", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1712", "-", 
               RowBox[{"272", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"34544", "+", 
               RowBox[{"1920", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"3936", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"129", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"320", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "52"}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"691200", " ", 
         SuperscriptBox["t1", "5"], " ", 
         SuperscriptBox["z0", "10"]}]], "a1", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "230400"}], " ", 
          SuperscriptBox["h0", "10"]}], "-", 
         RowBox[{"230400", " ", 
          SuperscriptBox["p0", "10"]}], "-", 
         RowBox[{"1536", " ", 
          SuperscriptBox["h0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{"3308", "+", 
            RowBox[{"750", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"750", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"145", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"675", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "5"]}], "+", 
         RowBox[{"1536", " ", 
          SuperscriptBox["p0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3308"}], "+", 
            RowBox[{"750", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"145", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"96", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"436032", "+", 
            RowBox[{"24000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"42436", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"1185", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"300", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "704"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"96", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"436032", "+", 
            RowBox[{"24000", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"24000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"42436", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"1185", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"300", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "704"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"64", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3308"}], "+", 
               RowBox[{"750", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"145", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "39896512"}], "+", 
            RowBox[{"576000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"6689136", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"428964", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"9225", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"144000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "52"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"900", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"34544", "-", 
               RowBox[{"3936", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"129", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"27742208", "-", 
            RowBox[{"7540032", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"773616", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"38412", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"729", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "28"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1712", "-", 
               RowBox[{"272", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"180", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "176768"}], "+", 
               RowBox[{"37808", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"2544", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"63", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"39896512", "+", 
            RowBox[{"576000", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"576000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"6689136", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"428964", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"9225", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"144000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "52"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"2304", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3308"}], "+", 
               RowBox[{"750", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"145", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"900", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"34544", "-", 
               RowBox[{"3936", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"129", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"72", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"436032", "+", 
               RowBox[{"24000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"42436", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"1185", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "704"}], "+", 
                  RowBox[{"35", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"576000", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"3072", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3308"}], "+", 
               RowBox[{"750", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"145", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"436032", "+", 
               RowBox[{"24000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"42436", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"1185", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "704"}], "+", 
                  RowBox[{"35", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "39896512"}], "+", 
               RowBox[{"576000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"6689136", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"428964", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"9225", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"144000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "52"}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"34544", "-", 
                  RowBox[{"3936", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"129", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"27742208", "-", 
               RowBox[{"7540032", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"773616", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"38412", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"729", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"57600", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "28"}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"7200", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"1712", "-", 
                  RowBox[{"272", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"9", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "176768"}], "+", 
                  RowBox[{"37808", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"2544", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"63", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"horizT", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"t1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["t1", "z0"]}], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a1", "2"], " ", 
           SuperscriptBox["z0", "2"]}], "2"]}], ")"}]}], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
        RowBox[{"(", 
         RowBox[{"144", "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["h0", "4"]}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["p0", "2"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["p0", "4"]}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["h0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             SuperscriptBox["p0", "2"]}], ")"}]}], "-", 
          RowBox[{"120", " ", 
           SuperscriptBox["a1", "2"], " ", 
           SuperscriptBox["z0", "4"]}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["a1", "4"], " ", 
           SuperscriptBox["z0", "8"]}]}], ")"}]}], 
       RowBox[{"48", " ", "t1", " ", 
        SuperscriptBox["z0", "4"]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"48", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["h0", "6"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["p0", "6"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"t1", " ", "z0"}], "-", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "9"}], "+", 
            RowBox[{"t1", " ", "z0"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "400"}], "+", 
            RowBox[{"64", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"88", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"9", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"12", "-", 
            RowBox[{"4", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"13", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "400"}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"64", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"88", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"9", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"32", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               RowBox[{"t1", " ", "z0"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"3840", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "8"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1280", " ", 
          SuperscriptBox["h0", "8"]}], "+", 
         RowBox[{"1280", " ", 
          SuperscriptBox["p0", "8"]}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"67", "+", 
            RowBox[{"20", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"10", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"256", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "67"}], "+", 
            RowBox[{"10", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"604", "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"139", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"20", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"604", "+", 
            RowBox[{"60", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"139", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"20", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"6", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "67"}], "+", 
               RowBox[{"10", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"15", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "12"}], "+", 
                RowBox[{
                 SuperscriptBox["a1", "2"], " ", 
                 SuperscriptBox["z0", "4"]}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"32", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"12", "-", 
               RowBox[{"13", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"37120", "+", 
            RowBox[{"1280", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"18032", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"2824", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"99", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"400", "-", 
               RowBox[{"88", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"37120", "+", 
            RowBox[{"1280", " ", 
             SuperscriptBox["p0", "6"]}], "+", 
            RowBox[{"1280", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"18032", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"2824", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"99", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"192", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "67"}], "+", 
               RowBox[{"10", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"400", "-", 
               RowBox[{"88", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"64", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"604", "+", 
               RowBox[{"10", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"139", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"20", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "9"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"69120", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "10"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"23040", " ", 
          SuperscriptBox["h0", "10"]}], "+", 
         RowBox[{"23040", " ", 
          SuperscriptBox["p0", "10"]}], "+", 
         RowBox[{"768", " ", 
          SuperscriptBox["h0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{"534", "+", 
            RowBox[{"150", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"90", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"35", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"768", " ", 
          SuperscriptBox["p0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "534"}], "+", 
            RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"35", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"135", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"24", "-", 
            RowBox[{"8", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"38", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
         RowBox[{"1536", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"45", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"9", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "67"}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"344", "-", 
               RowBox[{"61", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"1536", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"150", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"45", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"9", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "67"}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "534"}], "+", 
               RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"344", "-", 
               RowBox[{"61", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "979712"}], "+", 
            RowBox[{"2880", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"377424", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"41376", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"1431", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"8640", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"864", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"604", "-", 
               RowBox[{"139", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5474560"}], "+", 
            RowBox[{"46080", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"4248192", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"902976", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"62424", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"1539", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"2160", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"400", "-", 
               RowBox[{"88", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"108", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "37120"}], "+", 
               RowBox[{"18032", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"2824", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"99", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"979712", "+", 
            RowBox[{"28800", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"2880", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"377424", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"41376", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"1431", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"8640", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"576", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "534"}], "+", 
               RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"864", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"604", "-", 
               RowBox[{"139", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"576", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"45", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"9", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "67"}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"5", " ", 
                RowBox[{"(", 
                 RowBox[{"344", "-", 
                  RowBox[{"61", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5474560", "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"46080", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"4248192", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"902976", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"62424", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"1539", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"1536", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "534"}], "+", 
               RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"2160", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"400", "-", 
               RowBox[{"88", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"108", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "37120"}], "+", 
               RowBox[{"18032", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"2824", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"99", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"2304", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"45", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"9", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "67"}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"5", " ", 
                RowBox[{"(", 
                 RowBox[{"344", "-", 
                  RowBox[{"61", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "979712"}], "+", 
               RowBox[{"2880", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"377424", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"41376", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1431", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"8640", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "9"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"864", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"604", "-", 
                  RowBox[{"139", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"horizS", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"s0", "+", 
     FractionBox[
      RowBox[{"s0", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"12", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "2"]}], "-", 
         RowBox[{"4", " ", "t1", " ", "z0"}], "-", 
         RowBox[{
          SuperscriptBox["a1", "2"], " ", 
          SuperscriptBox["z0", "4"]}]}], ")"}]}], 
      RowBox[{"4", " ", "t1", " ", 
       SuperscriptBox["z0", "2"]}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h0", "2"], "+", 
         SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{
          SuperscriptBox["a1", "2"], " ", 
          SuperscriptBox["z0", "4"]}]}], ")"}]}], 
      RowBox[{"4", " ", 
       SuperscriptBox["t1", "2"], " ", 
       SuperscriptBox["z0", "4"]}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h0", "2"], "+", 
         SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "20"}], "+", 
            RowBox[{"12", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
      RowBox[{"48", " ", 
       SuperscriptBox["t1", "3"], " ", 
       SuperscriptBox["z0", "6"]}]], "-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"1152", " ", 
        SuperscriptBox["t1", "4"], " ", 
        SuperscriptBox["z0", "8"]}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h0", "2"], "+", 
        SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
      RowBox[{"(", 
       RowBox[{"3200", "+", 
        RowBox[{"192", " ", 
         SuperscriptBox["h0", "4"]}], "+", 
        RowBox[{"192", " ", 
         SuperscriptBox["p0", "4"]}], "-", 
        RowBox[{"3840", " ", "t1", " ", "z0"}], "+", 
        RowBox[{"1152", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "2"]}], "+", 
        RowBox[{"1872", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["z0", "4"]}], "-", 
        RowBox[{"1536", " ", 
         SuperscriptBox["a1", "2"], " ", "t1", " ", 
         SuperscriptBox["z0", "5"]}], "+", 
        RowBox[{"288", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}], "+", 
        RowBox[{"432", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "-", 
        RowBox[{"144", " ", 
         SuperscriptBox["a1", "4"], " ", "t1", " ", 
         SuperscriptBox["z0", "9"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["z0", "12"]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["p0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "44"}], "+", 
           RowBox[{"16", " ", "t1", " ", "z0"}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           RowBox[{
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["h0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"32", " ", 
            SuperscriptBox["p0", "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "44"}], "+", 
              RowBox[{"16", " ", "t1", " ", "z0"}], "-", 
              RowBox[{"5", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              RowBox[{
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
     "+", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"23040", " ", 
        SuperscriptBox["t1", "5"], " ", 
        SuperscriptBox["z0", "10"]}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h0", "2"], "+", 
        SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
      RowBox[{"(", 
       RowBox[{"110080", "+", 
        RowBox[{"2304", " ", 
         SuperscriptBox["h0", "6"]}], "+", 
        RowBox[{"2304", " ", 
         SuperscriptBox["p0", "6"]}], "-", 
        RowBox[{"192000", " ", "t1", " ", "z0"}], "+", 
        RowBox[{"115200", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "2"]}], "-", 
        RowBox[{"23040", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "3"]}], "+", 
        RowBox[{"90880", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["z0", "4"]}], "-", 
        RowBox[{"112320", " ", 
         SuperscriptBox["a1", "2"], " ", "t1", " ", 
         SuperscriptBox["z0", "5"]}], "+", 
        RowBox[{"46080", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}], "-", 
        RowBox[{"5760", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "7"]}], "+", 
        RowBox[{"35184", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "-", 
        RowBox[{"25920", " ", 
         SuperscriptBox["a1", "4"], " ", "t1", " ", 
         SuperscriptBox["z0", "9"]}], "+", 
        RowBox[{"4320", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "10"]}], "+", 
        RowBox[{"2184", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["z0", "12"]}], "-", 
        RowBox[{"540", " ", 
         SuperscriptBox["a1", "6"], " ", "t1", " ", 
         SuperscriptBox["z0", "13"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["a1", "8"], " ", 
         SuperscriptBox["z0", "16"]}], "-", 
        RowBox[{"48", " ", 
         SuperscriptBox["p0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "816"}], "+", 
           RowBox[{"240", " ", "t1", " ", "z0"}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"7", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
        RowBox[{"48", " ", 
         SuperscriptBox["h0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"816", "+", 
           RowBox[{"144", " ", 
            SuperscriptBox["p0", "2"]}], "-", 
           RowBox[{"240", " ", "t1", " ", "z0"}], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
        RowBox[{"12", " ", 
         SuperscriptBox["p0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "12736"}], "+", 
           RowBox[{"208", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"676", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"45", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "+", 
           RowBox[{"480", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              RowBox[{
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"60", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "176"}], "+", 
              RowBox[{"24", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["h0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"12736", "+", 
           RowBox[{"576", " ", 
            SuperscriptBox["p0", "4"]}], "-", 
           RowBox[{"208", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"676", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "-", 
           RowBox[{"45", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "-", 
           RowBox[{"480", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              RowBox[{
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "816"}], "+", 
              RowBox[{"240", " ", "t1", " ", "z0"}], "+", 
              RowBox[{"12", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "-", 
              RowBox[{"7", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
           RowBox[{"60", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "176"}], "+", 
              RowBox[{"24", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
     "-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"345600", " ", 
        SuperscriptBox["t1", "6"], " ", 
        SuperscriptBox["z0", "12"]}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h0", "2"], "+", 
        SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
      RowBox[{"(", 
       RowBox[{"3033600", "+", 
        RowBox[{"23040", " ", 
         SuperscriptBox["h0", "8"]}], "+", 
        RowBox[{"23040", " ", 
         SuperscriptBox["p0", "8"]}], "-", 
        RowBox[{"6604800", " ", "t1", " ", "z0"}], "+", 
        RowBox[{"5760000", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "2"]}], "-", 
        RowBox[{"2304000", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "3"]}], "+", 
        RowBox[{"3436352", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["z0", "4"]}], "+", 
        RowBox[{"345600", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "4"]}], "-", 
        RowBox[{"5452800", " ", 
         SuperscriptBox["a1", "2"], " ", "t1", " ", 
         SuperscriptBox["z0", "5"]}], "+", 
        RowBox[{"3369600", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}], "-", 
        RowBox[{"921600", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "7"]}], "+", 
        RowBox[{"1799472", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "+", 
        RowBox[{"86400", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "-", 
        RowBox[{"2111040", " ", 
         SuperscriptBox["a1", "4"], " ", "t1", " ", 
         SuperscriptBox["z0", "9"]}], "+", 
        RowBox[{"777600", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "10"]}], "-", 
        RowBox[{"86400", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "11"]}], "+", 
        RowBox[{"228828", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["z0", "12"]}], "-", 
        RowBox[{"131040", " ", 
         SuperscriptBox["a1", "6"], " ", "t1", " ", 
         SuperscriptBox["z0", "13"]}], "+", 
        RowBox[{"16200", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "14"]}], "+", 
        RowBox[{"3735", " ", 
         SuperscriptBox["a1", "8"], " ", 
         SuperscriptBox["z0", "16"]}], "-", 
        RowBox[{"540", " ", 
         SuperscriptBox["a1", "8"], " ", "t1", " ", 
         SuperscriptBox["z0", "17"]}], "-", 
        RowBox[{"96", " ", 
         SuperscriptBox["p0", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5464"}], "+", 
           RowBox[{"1440", " ", "t1", " ", "z0"}], "-", 
           RowBox[{"38", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
        RowBox[{"96", " ", 
         SuperscriptBox["h0", "6"], " ", 
         RowBox[{"(", 
          RowBox[{"5464", "+", 
           RowBox[{"960", " ", 
            SuperscriptBox["p0", "2"]}], "-", 
           RowBox[{"1440", " ", "t1", " ", "z0"}], "+", 
           RowBox[{"38", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["p0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"432320", "+", 
           RowBox[{"43200", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"]}], "+", 
           RowBox[{"9576", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"2658", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"585", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "-", 
           RowBox[{"360", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{"816", "-", 
              RowBox[{"12", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["h0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"432320", "+", 
           RowBox[{"17280", " ", 
            SuperscriptBox["p0", "4"]}], "+", 
           RowBox[{"43200", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"]}], "+", 
           RowBox[{"9576", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"2658", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"585", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "-", 
           RowBox[{"36", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "5464"}], "+", 
              RowBox[{"1440", " ", "t1", " ", "z0"}], "-", 
              RowBox[{"38", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "-", 
              RowBox[{"5", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
           RowBox[{"360", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{"816", "-", 
              RowBox[{"12", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["p0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"6998016", "+", 
           RowBox[{"1009984", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"480048", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "-", 
           RowBox[{"90804", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "-", 
           RowBox[{"2205", " ", 
            SuperscriptBox["a1", "8"], " ", 
            SuperscriptBox["z0", "16"]}], "+", 
           RowBox[{"115200", " ", 
            SuperscriptBox["t1", "3"], " ", 
            SuperscriptBox["z0", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              RowBox[{
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"21600", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "176"}], "+", 
              RowBox[{"24", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
           RowBox[{"720", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "12736"}], "+", 
              RowBox[{"208", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"676", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"45", " ", 
               SuperscriptBox["a1", "6"], " ", 
               SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["h0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"6998016", "+", 
           RowBox[{"92160", " ", 
            SuperscriptBox["p0", "6"]}], "+", 
           RowBox[{"1009984", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"480048", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "-", 
           RowBox[{"90804", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "-", 
           RowBox[{"2205", " ", 
            SuperscriptBox["a1", "8"], " ", 
            SuperscriptBox["z0", "16"]}], "+", 
           RowBox[{"115200", " ", 
            SuperscriptBox["t1", "3"], " ", 
            SuperscriptBox["z0", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              RowBox[{
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"288", " ", 
            SuperscriptBox["p0", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "5464"}], "+", 
              RowBox[{"1440", " ", "t1", " ", "z0"}], "-", 
              RowBox[{"38", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "-", 
              RowBox[{"5", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
           RowBox[{"21600", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "176"}], "+", 
              RowBox[{"24", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
           RowBox[{"720", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "12736"}], "+", 
              RowBox[{"208", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"676", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"45", " ", 
               SuperscriptBox["a1", "6"], " ", 
               SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"432320", "+", 
              RowBox[{"43200", " ", 
               SuperscriptBox["t1", "2"], " ", 
               SuperscriptBox["z0", "2"]}], "+", 
              RowBox[{"9576", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"2658", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"585", " ", 
               SuperscriptBox["a1", "6"], " ", 
               SuperscriptBox["z0", "12"]}], "-", 
              RowBox[{"360", " ", "t1", " ", "z0", " ", 
               RowBox[{"(", 
                RowBox[{"816", "-", 
                 RowBox[{"12", " ", 
                  SuperscriptBox["a1", "2"], " ", 
                  SuperscriptBox["z0", "4"]}], "+", 
                 RowBox[{"7", " ", 
                  SuperscriptBox["a1", "4"], " ", 
                  SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5384640040309467`*^9, 3.5384640865225697`*^9}, {
  3.538464329491736*^9, 3.538464352894101*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"asymp", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"p2", " ", 
       SuperscriptBox["z", "2"]}], "+", 
      RowBox[{"a0", " ", "h2", " ", 
       SuperscriptBox["z", "3"]}], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "a1", " ", "h2"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["a0", "2"], " ", "p2"}]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a0", "3"]}], " ", "h2"}], "-", 
         RowBox[{"2", " ", "a0", " ", "a1", " ", "p2"}], "-", 
         RowBox[{"p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "5"]}], "+", 
      RowBox[{
       FractionBox["1", "60"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "30"}], " ", 
          SuperscriptBox["a0", "2"], " ", "a1", " ", "h2"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "4"], " ", "p2"}], "-", 
         RowBox[{"15", " ", 
          SuperscriptBox["a1", "2"], " ", "p2"}], "+", 
         RowBox[{"14", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}], "-", 
         RowBox[{"35", " ", "a0", " ", "h2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "+", 
      RowBox[{
       FractionBox["1", "180"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "5"], " ", "h2"}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{"a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "69"}], " ", 
             SuperscriptBox["a1", "2"], " ", "h2"}], "+", 
            RowBox[{"60", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"66", " ", "a1", " ", "h2", " ", "T3"}], "+", 
         RowBox[{"99", " ", 
          SuperscriptBox["a0", "2"], " ", "p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"280", " ", 
           SuperscriptBox["a0", "4"], " ", "a1", " ", "h2"}], "-", 
          RowBox[{"315", " ", 
           SuperscriptBox["a1", "3"], " ", "h2"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["a0", "6"], " ", "p2"}], "+", 
          RowBox[{"504", " ", "a1", " ", "h2", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["h2", "2"], "+", 
             SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"806", " ", 
              SuperscriptBox["a1", "2"], " ", "p2"}], "-", 
             RowBox[{"860", " ", "p2", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"896", " ", 
           SuperscriptBox["a0", "3"], " ", "h2", " ", "T3"}], "+", 
          RowBox[{"1649", " ", "a0", " ", "a1", " ", "p2", " ", "T3"}], "+", 
          RowBox[{"500", " ", "p2", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "8"]}], "2520"], "+", 
      RowBox[{
       FractionBox["1", "1260"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["a0", "7"], " ", "h2"}], "-", 
         RowBox[{"48", " ", 
          SuperscriptBox["a0", "5"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{
          SuperscriptBox["a0", "3"], " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"235", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"324", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", "a0", " ", "a1", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"33", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"61", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "386"}], " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "h2"}], "+", 
            RowBox[{"110", " ", 
             SuperscriptBox["a0", "4"], " ", "p2"}], "-", 
            RowBox[{"183", " ", 
             SuperscriptBox["a1", "2"], " ", "p2"}], "+", 
            RowBox[{"167", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "+", 
         RowBox[{"535", " ", "a0", " ", "h2", " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "9"]}], "+", 
      RowBox[{
       FractionBox["1", "90720"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1008"}], " ", 
          SuperscriptBox["a0", "6"], " ", "a1", " ", "h2"}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["a0", "8"], " ", "p2"}], "+", 
         RowBox[{"36", " ", 
          SuperscriptBox["a0", "2"], " ", "a1", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"469", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"1093", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a0", "4"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1906"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"3641", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"54", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"105", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"298", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"162", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3132", " ", 
             SuperscriptBox["a0", "4"], " ", "h2"}], "+", 
            RowBox[{"17768", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "p2"}], "+", 
            RowBox[{"9", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2756"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"2443", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"26388", " ", "a1", " ", "h2"}], "-", 
            RowBox[{"42517", " ", 
             SuperscriptBox["a0", "2"], " ", "p2"}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "10"]}], "+", 
      RowBox[{
       FractionBox["1", "453600"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"32", " ", 
             SuperscriptBox["a0", "8"], " ", "h2"}], "+", 
            RowBox[{"640", " ", 
             SuperscriptBox["a0", "6"], " ", "a1", " ", "p2"}], "+", 
            RowBox[{"38", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "680"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"2129", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["a0", "4"], " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3506"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"9625", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"8445", " ", 
                SuperscriptBox["a1", "4"]}], "-", 
               RowBox[{"27322", " ", 
                SuperscriptBox["a1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
               RowBox[{"11384", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["h2", "2"], "+", 
                   SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "43168"}], " ", 
             SuperscriptBox["a0", "4"], " ", "a1", " ", "h2"}], "+", 
            RowBox[{"5180", " ", 
             SuperscriptBox["a0", "6"], " ", "p2"}], "+", 
            RowBox[{"12", " ", "a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3795", " ", 
                SuperscriptBox["a1", "2"]}], "-", 
               RowBox[{"6062", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a0", "2"], " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "122040"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"132161", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "-", 
         RowBox[{"5", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"31441", " ", 
             SuperscriptBox["a0", "2"], " ", "h2"}], "+", 
            RowBox[{"54768", " ", "a1", " ", "p2"}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}], "-", 
         RowBox[{"64000", " ", "p2", " ", 
          SuperscriptBox["T3", "3"]}]}], ")"}], " ", 
       SuperscriptBox["z", "11"]}], "+", 
      RowBox[{
       FractionBox["1", "9979200"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6336", " ", 
          SuperscriptBox["a0", "8"], " ", "a1", " ", "h2"}], "-", 
         RowBox[{"256", " ", 
          SuperscriptBox["a0", "10"], " ", "p2"}], "+", 
         RowBox[{"198", " ", "a1", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"105", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"302", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"16", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["a0", "6"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5999"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"24481", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"44", " ", 
          SuperscriptBox["a0", "4"], " ", "a1", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "12114"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"52981", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["a0", "2"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"261441", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"1083379", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"493120", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"32384", " ", 
             SuperscriptBox["a0", "6"], " ", "h2"}], "+", 
            RowBox[{"372148", " ", 
             SuperscriptBox["a0", "4"], " ", "a1", " ", "p2"}], "+", 
            RowBox[{"44", " ", 
             SuperscriptBox["a0", "2"], " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "40939"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"57354", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "1957536"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"3601319", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "6405487"}], " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "h2"}], "+", 
            RowBox[{"1911860", " ", 
             SuperscriptBox["a0", "4"], " ", "p2"}], "+", 
            RowBox[{"4", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "739971"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"683452", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", 
          SuperscriptBox["T3", "2"]}], "-", 
         RowBox[{"3376120", " ", "a0", " ", "h2", " ", 
          SuperscriptBox["T3", "3"]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}]}], "//.", "replasym"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"asymh", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"h2", " ", 
       SuperscriptBox["z", "2"]}], "-", 
      RowBox[{"a0", " ", "p2", " ", 
       SuperscriptBox["z", "3"]}], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["a0", "2"], " ", "h2"}], "-", 
         RowBox[{"3", " ", "a1", " ", "p2"}]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "a0", " ", "a1", " ", "h2"}], "+", 
         RowBox[{
          SuperscriptBox["a0", "3"], " ", "p2"}], "-", 
         RowBox[{"h2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "5"]}], "+", 
      RowBox[{
       FractionBox["1", "60"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "4"], " ", "h2"}], "-", 
         RowBox[{"15", " ", 
          SuperscriptBox["a1", "2"], " ", "h2"}], "+", 
         RowBox[{"30", " ", 
          SuperscriptBox["a0", "2"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{"14", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
         RowBox[{"35", " ", "a0", " ", "p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "+", 
      RowBox[{
       FractionBox["1", "180"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"48", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "h2"}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "5"], " ", "p2"}], "+", 
         RowBox[{"a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"69", " ", 
             SuperscriptBox["a1", "2"], " ", "p2"}], "-", 
            RowBox[{"60", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"99", " ", 
          SuperscriptBox["a0", "2"], " ", "h2", " ", "T3"}], "+", 
         RowBox[{"66", " ", "a1", " ", "p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "32"}], " ", 
           SuperscriptBox["a0", "6"], " ", "h2"}], "-", 
          RowBox[{"280", " ", 
           SuperscriptBox["a0", "4"], " ", "a1", " ", "p2"}], "+", 
          RowBox[{"63", " ", "a1", " ", "p2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["a1", "2"]}], "-", 
             RowBox[{"8", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"806", " ", 
              SuperscriptBox["a1", "2"], " ", "h2"}], "-", 
             RowBox[{"860", " ", "h2", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"1649", " ", "a0", " ", "a1", " ", "h2", " ", "T3"}], "-", 
          RowBox[{"896", " ", 
           SuperscriptBox["a0", "3"], " ", "p2", " ", "T3"}], "+", 
          RowBox[{"500", " ", "h2", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "8"]}], "2520"], "+", 
      RowBox[{
       FractionBox["1", "1260"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "48"}], " ", 
          SuperscriptBox["a0", "5"], " ", "a1", " ", "h2"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a0", "7"], " ", "p2"}], "+", 
         RowBox[{"8", " ", "a0", " ", "a1", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"33", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"61", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a0", "3"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "235"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"324", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"110", " ", 
             SuperscriptBox["a0", "4"], " ", "h2"}], "-", 
            RowBox[{"183", " ", 
             SuperscriptBox["a1", "2"], " ", "h2"}], "+", 
            RowBox[{"386", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "p2"}], "+", 
            RowBox[{"167", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "-", 
         RowBox[{"535", " ", "a0", " ", "p2", " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "9"]}], "+", 
      RowBox[{
       FractionBox["1", "90720"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"64", " ", 
          SuperscriptBox["a0", "8"], " ", "h2"}], "+", 
         RowBox[{"1008", " ", 
          SuperscriptBox["a0", "6"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{"36", " ", 
          SuperscriptBox["a0", "2"], " ", "a1", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "469"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"1093", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a0", "4"], " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1906"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"3641", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"54", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"105", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"298", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"162", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "17768"}], " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "h2"}], "+", 
            RowBox[{"3132", " ", 
             SuperscriptBox["a0", "4"], " ", "p2"}], "+", 
            RowBox[{"9", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2756"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"2443", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"42517", " ", 
             SuperscriptBox["a0", "2"], " ", "h2"}], "+", 
            RowBox[{"26388", " ", "a1", " ", "p2"}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "10"]}], "+", 
      RowBox[{
       FractionBox["1", "453600"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"640", " ", 
             SuperscriptBox["a0", "6"], " ", "a1", " ", "h2"}], "-", 
            RowBox[{"32", " ", 
             SuperscriptBox["a0", "8"], " ", "p2"}], "+", 
            RowBox[{"38", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "680"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"2129", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["a0", "4"], " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3506"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"9625", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"3", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"8445", " ", 
                SuperscriptBox["a1", "4"]}], "-", 
               RowBox[{"27322", " ", 
                SuperscriptBox["a1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
               RowBox[{"11384", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["h2", "2"], "+", 
                   SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5180", " ", 
             SuperscriptBox["a0", "6"], " ", "h2"}], "+", 
            RowBox[{"43168", " ", 
             SuperscriptBox["a0", "4"], " ", "a1", " ", "p2"}], "+", 
            RowBox[{"12", " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3795"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"6062", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a0", "2"], " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "122040"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"132161", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "+", 
         RowBox[{"5", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "54768"}], " ", "a1", " ", "h2"}], "+", 
            RowBox[{"31441", " ", 
             SuperscriptBox["a0", "2"], " ", "p2"}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}], "-", 
         RowBox[{"64000", " ", "h2", " ", 
          SuperscriptBox["T3", "3"]}]}], ")"}], " ", 
       SuperscriptBox["z", "11"]}], "+", 
      RowBox[{
       FractionBox["1", "9979200"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "256"}], " ", 
          SuperscriptBox["a0", "10"], " ", "h2"}], "-", 
         RowBox[{"6336", " ", 
          SuperscriptBox["a0", "8"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{"44", " ", 
          SuperscriptBox["a0", "4"], " ", "a1", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12114", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"52981", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"198", " ", "a1", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"105", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"302", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"16", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["a0", "6"], " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5999"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"24481", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["a0", "2"], " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"261441", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"1083379", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"493120", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"372148", " ", 
             SuperscriptBox["a0", "4"], " ", "a1", " ", "h2"}], "-", 
            RowBox[{"32384", " ", 
             SuperscriptBox["a0", "6"], " ", "p2"}], "-", 
            RowBox[{"44", " ", 
             SuperscriptBox["a0", "2"], " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "40939"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"57354", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "1957536"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"3601319", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1911860", " ", 
             SuperscriptBox["a0", "4"], " ", "h2"}], "+", 
            RowBox[{"6405487", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "p2"}], "+", 
            RowBox[{"4", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "739971"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"683452", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", 
          SuperscriptBox["T3", "2"]}], "+", 
         RowBox[{"3376120", " ", "a0", " ", "p2", " ", 
          SuperscriptBox["T3", "3"]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}]}], "//.", "replasym"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"asyma", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "+", 
      RowBox[{"a1", " ", "z"}], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", "a0", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", "a1", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "5"]}], "-", 
      RowBox[{
       FractionBox["1", "45"], " ", 
       SuperscriptBox["a0", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "-", 
      RowBox[{
       FractionBox["5", "126"], " ", "a0", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a0", " ", "a1"}], "+", 
         RowBox[{"2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["a0", "5"]}], "+", 
          RowBox[{"a0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "85"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"127", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"200", " ", "a1", " ", "T3"}]}], ")"}], " ", 
        SuperscriptBox["z", "8"]}], "2520"], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"98", " ", 
           SuperscriptBox["a0", "4"], " ", "a1"}], "+", 
          RowBox[{"9", " ", "a1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "45"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"139", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"448", " ", 
           SuperscriptBox["a0", "3"], " ", "T3"}]}], ")"}], " ", 
        SuperscriptBox["z", "9"]}], "22680"], "-", 
      FractionBox[
       RowBox[{"a0", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["a0", "6"]}], "+", 
          RowBox[{
           SuperscriptBox["a0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "905"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"2224", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"4250", " ", "a0", " ", "a1", " ", "T3"}], "-", 
          RowBox[{"5480", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "10"]}], "113400"], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a0", "2"], " ", "a1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"162", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"5735", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"23903", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"a0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"1314", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"25115", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"36858", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
          "-", 
          RowBox[{"30410", " ", "a1", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "11"]}], "623700"], "+", 
      RowBox[{
       FractionBox["1", "14968800"], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"32", " ", 
          SuperscriptBox["a0", "9"]}], "+", 
         RowBox[{
          SuperscriptBox["a0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "11756"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"58132", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"9", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"10845", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"55822", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"33662", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
         RowBox[{"90872", " ", 
          SuperscriptBox["a0", "4"], " ", "a1", " ", "T3"}], "+", 
         RowBox[{"72", " ", "a1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4905", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"13168", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "-", 
         RowBox[{"247250", " ", 
          SuperscriptBox["a0", "3"], " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}]}], "//.", "replasym"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"asymT", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"T3", " ", 
       SuperscriptBox["z", "3"]}], "+", 
      RowBox[{
       FractionBox["1", "12"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["a1", "2"]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       SuperscriptBox["a0", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "+", 
      RowBox[{
       FractionBox["1", "9"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "a0", " ", "a1"}], "+", "T3"}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "-", 
      RowBox[{
       FractionBox["1", "630"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"14", " ", 
          SuperscriptBox["a0", "4"]}], "-", 
         RowBox[{"75", " ", 
          SuperscriptBox["a1", "2"]}], "+", 
         RowBox[{"38", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "8"]}], "-", 
      RowBox[{
       FractionBox["1", "180"], " ", 
       SuperscriptBox["a0", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", "a0", " ", "a1"}], "+", 
         RowBox[{"16", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "9"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "6"]}], "+", 
          RowBox[{
           SuperscriptBox["a0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1385"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"1628", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"2900", " ", "a0", " ", "a1", " ", "T3"}], "-", 
          RowBox[{"860", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "10"]}], "22680"], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "a0", " ", "a1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"24", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"195", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"482", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"387", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"1335", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"1096", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}]}], 
         ")"}], " ", 
        SuperscriptBox["z", "11"]}], "18900"], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"88", " ", 
           SuperscriptBox["a0", "8"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a0", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4485"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"9886", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"9", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2025", " ", 
              SuperscriptBox["a1", "4"]}], "-", 
             RowBox[{"7905", " ", 
              SuperscriptBox["a1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
             RowBox[{"2908", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["h2", "2"], "+", 
                 SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
          RowBox[{"63515", " ", 
           SuperscriptBox["a0", "3"], " ", "a1", " ", "T3"}], "-", 
          RowBox[{"67735", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "12"]}], "1247400"]}], "//.", "replasym"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymS", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["h2", "2"]}], "-", 
        SuperscriptBox["p2", "2"]}], ")"}], " ", 
      SuperscriptBox["z", "4"]}], "+", 
     RowBox[{
      FractionBox["1", "36"], " ", 
      SuperscriptBox["a0", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h2", "2"], "+", 
        SuperscriptBox["p2", "2"]}], ")"}], " ", 
      SuperscriptBox["z", "6"]}], "+", 
     RowBox[{
      FractionBox["1", "63"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h2", "2"], "+", 
        SuperscriptBox["p2", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a0", " ", "a1"}], "+", 
        RowBox[{"5", " ", "T3"}]}], ")"}], " ", 
      SuperscriptBox["z", "7"]}], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["a0", "4"]}], "-", 
         RowBox[{"45", " ", 
          SuperscriptBox["a1", "2"]}], "+", 
         RowBox[{"111", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "8"]}], "2520"], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a0", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"13", " ", "a0", " ", "a1"}], "+", 
         RowBox[{"74", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "9"]}], "3240"], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"18", " ", 
          SuperscriptBox["a0", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["a0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "785"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"2519", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"1670", " ", "a0", " ", "a1", " ", "T3"}], "-", 
         RowBox[{"5750", " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "10"]}], "113400"], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a0", " ", "a1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"26", " ", 
             SuperscriptBox["a0", "4"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "85"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"426", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
         "+", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"79", " ", 
             SuperscriptBox["a0", "4"]}], "-", 
            RowBox[{"545", " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"1342", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}]}], 
        ")"}], " ", 
       SuperscriptBox["z", "11"]}], "69300"], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"88", " ", 
          SuperscriptBox["a0", "8"]}], "+", 
         RowBox[{
          SuperscriptBox["a0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "15940"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"82193", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"27", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1575", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"9430", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"9886", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
         RowBox[{"82660", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "T3"}], "-", 
         RowBox[{"275950", " ", 
          SuperscriptBox["a0", "2"], " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}], "14968800"]}], "//.", "replasym"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.537640798221807*^9, 3.5376408063887777`*^9}, {
  3.538462913984427*^9, 3.53846295871097*^9}, {3.538463135071212*^9, 
  3.538463146908863*^9}, {3.538464374794805*^9, 3.538464392634185*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqlist", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["p", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{"a", "[", "z", "]"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], " ", 
           RowBox[{"S", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"z", " ", 
              SuperscriptBox[
               RowBox[{"h", "[", "z", "]"}], "2"], " ", 
              RowBox[{"S", "[", "z", "]"}], " ", 
              RowBox[{
               SuperscriptBox["p", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], "+", 
             RowBox[{"z", " ", 
              SuperscriptBox[
               RowBox[{"p", "[", "z", "]"}], "2"], " ", 
              RowBox[{"S", "[", "z", "]"}], " ", 
              RowBox[{
               SuperscriptBox["p", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], "-", 
             RowBox[{"4", " ", 
              RowBox[{"p", "[", "z", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"S", "[", "z", "]"}], "-", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["S", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
            ")"}]}], "-", 
          RowBox[{"4", " ", "z", " ", 
           RowBox[{"a", "[", "z", "]"}], " ", 
           RowBox[{"h", "[", "z", "]"}], " ", 
           RowBox[{"T", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              SuperscriptBox[
               RowBox[{"h", "[", "z", "]"}], "2"], " ", 
              SuperscriptBox[
               RowBox[{"S", "[", "z", "]"}], "2"], " ", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["p", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
             RowBox[{"2", " ", "z", " ", 
              RowBox[{"p", "[", "z", "]"}], " ", 
              RowBox[{"S", "[", "z", "]"}], " ", 
              RowBox[{
               SuperscriptBox["p", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"S", "[", "z", "]"}]}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["S", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
             "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"p", "[", "z", "]"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"S", "[", "z", "]"}], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["p", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                  ")"}]}], "-", 
                RowBox[{"4", " ", "z", " ", 
                 RowBox[{"S", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["S", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["S", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
               ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"T", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "z", " ", 
              SuperscriptBox[
               RowBox[{"p", "[", "z", "]"}], "4"], " ", 
              SuperscriptBox[
               RowBox[{"S", "[", "z", "]"}], "2"], " ", 
              RowBox[{
               SuperscriptBox["p", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["z", "3"], " ", 
              SuperscriptBox[
               RowBox[{"h", "[", "z", "]"}], "2"], " ", 
              SuperscriptBox[
               RowBox[{"S", "[", "z", "]"}], "2"], " ", 
              RowBox[{"T", "[", "z", "]"}], " ", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["p", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], "3"]}], "-", 
             RowBox[{"8", " ", 
              SuperscriptBox[
               RowBox[{"p", "[", "z", "]"}], "3"], " ", 
              RowBox[{"S", "[", "z", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"S", "[", "z", "]"}], "-", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["S", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
             "+", 
             RowBox[{"z", " ", 
              SuperscriptBox[
               RowBox[{"p", "[", "z", "]"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 SuperscriptBox[
                  RowBox[{"h", "[", "z", "]"}], "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"S", "[", "z", "]"}], "2"], " ", 
                 RowBox[{
                  SuperscriptBox["p", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], "+", 
                RowBox[{"4", " ", "z", " ", 
                 RowBox[{"h", "[", "z", "]"}], " ", 
                 RowBox[{"S", "[", "z", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["a", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"S", "[", "z", "]"}], "-", 
                   RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["S", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
                "+", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{"S", "[", "z", "]"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"12", "-", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"T", "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["p", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"T", "[", "z", "]"}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["S", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                  ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "/", 
       RowBox[{"(", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"p", "[", "z", "]"}], "2"], " ", 
         RowBox[{"S", "[", "z", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"T", "[", "z", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"S", "[", "z", "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], " ", 
           RowBox[{"S", "[", "z", "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"T", "[", "z", "]"}], " ", 
           RowBox[{
            SuperscriptBox["a", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}], " ", 
           RowBox[{
            SuperscriptBox["S", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"S", "[", "z", "]"}], " ", 
        RowBox[{"T", "[", "z", "]"}]}]]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "\[Equal]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"h", "[", "z", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], " ", 
         RowBox[{"S", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"a", "[", "z", "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"h", "[", "z", "]"}], "2"], "+", 
              SuperscriptBox[
               RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"a", "[", "z", "]"}], " ", 
            RowBox[{"h", "[", "z", "]"}], " ", 
            RowBox[{"T", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"T", "[", "z", "]"}], "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}], "2"]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", "z", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"T", "[", "z", "]"}], "2"]}]]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"a", "[", "z", "]"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"S", "[", "z", "]"}], "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"a", "[", "z", "]"}], " ", 
          RowBox[{"h", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"h", "[", "z", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"S", "[", "z", "]"}], "2"], " ", 
          RowBox[{"T", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["p", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "+", 
         RowBox[{
          RowBox[{"T", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "4"], " ", 
             SuperscriptBox[
              RowBox[{"S", "[", "z", "]"}], "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{"S", "[", "z", "]"}], "2"], " ", 
             RowBox[{"T", "[", "z", "]"}], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["p", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox[
                 RowBox[{"S", "[", "z", "]"}], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"4", " ", 
                   SuperscriptBox[
                    RowBox[{"h", "[", "z", "]"}], "2"]}], "-", 
                  RowBox[{
                   SuperscriptBox["z", "4"], " ", 
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                  RowBox[{"2", " ", 
                   RowBox[{"T", "[", "z", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "6"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["p", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                    ")"}]}]}], ")"}]}], "+", 
               RowBox[{"16", " ", "z", " ", 
                RowBox[{"S", "[", "z", "]"}], " ", 
                RowBox[{"T", "[", "z", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["S", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"T", "[", "z", "]"}], " ", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["S", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
              ")"}]}]}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", " ", "z", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", "z", "]"}], "2"], " ", 
         RowBox[{"S", "[", "z", "]"}], " ", 
         RowBox[{"T", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"S", "[", "z", "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"a", "[", "z", "]"}]}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"h", "[", "z", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{"T", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], 
       RowBox[{
        RowBox[{"p", "[", "z", "]"}], " ", 
        RowBox[{"T", "[", "z", "]"}]}]]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.53804704493528*^9, 3.538047048094969*^9}, 
   3.538047118025202*^9, 3.538118653167184*^9, {3.5384641317446833`*^9, 
   3.538464140783781*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerics", "Subsubtitle",
 CellChangeTimes->{{3.538463013798025*^9, 3.5384630213987093`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"inteq", ",", "zhoriz", ",", "eps"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"inteq", "[", 
    RowBox[{
    "z0in_Real", ",", "horizp0in_Real", ",", "horiza1in_Real", ",", 
     "horizt1in_Real", ",", "horizs0in_Real", ",", "asymp2in_Real", ",", 
     "asymh2in_Real", ",", "asyma0in_Real", ",", "asyma1in_Real", ",", 
     "asymT3in_Real", ",", "output_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"z0", "=", "z0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizp0", "=", "horizp0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizh0", "=", "0"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horiza1", "=", "horiza1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizt1", "=", "horizt1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizs0", "=", "horizs0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymp2", "=", "asymp2in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymh2", "=", "asymh2in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asyma0", "=", "asyma0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asyma1", "=", "asyma1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymT3", "=", "asymT3in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"eps", "=", "0.01"}], " ", ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"eps2", "=", "0.001"}], " ", ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zmid", " ", "=", " ", "0.4"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zhoriz", "=", 
      RowBox[{"1", "-", "eps2"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"nsol1", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"eqlist", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"p", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymp", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asymp", "'"}], "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"h", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymh", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"a", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asyma", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asyma", "'"}], "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"T", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymT", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"S", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymS", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asymS", "'"}], "[", "eps", "]"}]}]}], "}"}]}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "eps", ",", "zhoriz"}], "}"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zcut1", "=", 
      RowBox[{"nsol1", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "2"}], "]"}], "]"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"zcut1", "<", "zmid"}], ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Error 1 \>\"", ",", "zcut2"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"nsol2", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"eqlist", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"p", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizp", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horizp", "'"}], "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"h", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizh", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"a", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horiza", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horiza", "'"}], "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"T", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizT", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"S", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizS", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horizS", "'"}], "[", "zhoriz", "]"}]}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "eps", ",", "zhoriz"}], "}"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zcut2", "=", 
      RowBox[{"nsol2", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "1"}], "]"}], "]"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"zcut2", ">", "zmid"}], ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Error 2 \>\"", ",", "zcut2"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", 
      RowBox[{
      "horizp0", ",", "horizh0", ",", "horiza1", ",", "horizt1", ",", 
       "horizs0", ",", "asymp2", ",", "asymh2", ",", "asyma0", ",", "asyma1", 
       ",", "asymT3"}], "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Return", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"h", "'"}], "[", "eps", "]"}], ",", 
             RowBox[{
              RowBox[{"T", "'"}], "[", "eps", "]"}]}], "}"}], "/.", "nsol2"}],
           "]"}], ";"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"htab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"h", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Ttab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"T", "[", "z", "]"}], "-", "1"}], "/.", "nsol2"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Coefficient", "[", 
            RowBox[{"hfit", ",", "z"}], "]"}], ",", 
           RowBox[{"Coefficient", "[", 
            RowBox[{"Tfit", ",", "z"}], "]"}]}], "}"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "2"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"T", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"T", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"S", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"S", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"dlist", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"Join", "[", 
          RowBox[{"list", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"dlist", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"dlist", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"dlist", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}], "]"}], 
        ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ptab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"p", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"htab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"h", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"atab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"a", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Ttab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"T", "[", "z", "]"}], "-", "1"}], "/.", "nsol2"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Stab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"S", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"pfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"ptab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"afit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"atab", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "z"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}], ",", 
             RowBox[{"z", "^", "3"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Sfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Stab", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "z"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"pfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"ptab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "2"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "2"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "3"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"pf", "==", "pfit"}], ",", 
             RowBox[{"hf", "\[Equal]", "hfit"}], ",", 
             RowBox[{"af", "\[Equal]", "afit"}], ",", 
             RowBox[{"Tf", "\[Equal]", "Tfit"}], ",", 
             RowBox[{"Sf", "\[Equal]", "Sfit"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pfit2", ",", "hfit2", ",", "Tfit2"}], "}"}]}], "}"}], 
         "]"}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], 
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.5376407771099586`*^9, 3.53764077742128*^9}, {
   3.537640849432414*^9, 3.537641029700471*^9}, {3.537641083186082*^9, 
   3.5376410832815037`*^9}, {3.537641227496984*^9, 3.537641241071927*^9}, {
   3.537641278231781*^9, 3.53764129200132*^9}, {3.537811594660029*^9, 
   3.537811661635552*^9}, 3.537811712330718*^9, {3.537812313668707*^9, 
   3.537812329718534*^9}, {3.537812368025175*^9, 3.537812466952651*^9}, {
   3.537812574550178*^9, 3.53781262207281*^9}, {3.537855902100842*^9, 
   3.537855910975484*^9}, {3.537863637889791*^9, 3.537863642968212*^9}, {
   3.53786405512639*^9, 3.5378640577014513`*^9}, {3.5378642740193357`*^9, 
   3.5378642823266706`*^9}, {3.537864945886372*^9, 3.537864949610241*^9}, {
   3.537865324468916*^9, 3.5378653414829493`*^9}, {3.537865422417637*^9, 
   3.537865426010881*^9}, {3.537865668894218*^9, 3.5378656720161123`*^9}, {
   3.537866060689427*^9, 3.537866086110963*^9}, {3.537866821965849*^9, 
   3.537866824468356*^9}, {3.537866935754058*^9, 3.5378669532770844`*^9}, {
   3.537867277477654*^9, 3.537867283864683*^9}, {3.5378673736645327`*^9, 
   3.53786741047612*^9}, {3.537867724358015*^9, 3.537867770909184*^9}, {
   3.537867812374217*^9, 3.537867814824875*^9}, {3.537867862682262*^9, 
   3.537867863608501*^9}, {3.537867935345325*^9, 3.537867952471974*^9}, {
   3.537867984898217*^9, 3.5378679871300287`*^9}, {3.537870400150711*^9, 
   3.537870402077724*^9}, {3.537870448958918*^9, 3.5378704524785967`*^9}, {
   3.537870930220189*^9, 3.537870930900414*^9}, 3.537871139674671*^9, {
   3.537871192589308*^9, 3.53787120155658*^9}, {3.537871653378598*^9, 
   3.5378716648098917`*^9}, {3.537871703252593*^9, 3.537871787942024*^9}, {
   3.537871824557847*^9, 3.537871910740779*^9}, {3.537871941253039*^9, 
   3.5378719525649443`*^9}, {3.537871994498852*^9, 3.537872049059258*^9}, {
   3.537872138421897*^9, 3.537872144006673*^9}, {3.537872196836445*^9, 
   3.53787224947705*^9}, {3.5378722878468122`*^9, 3.537872372883222*^9}, {
   3.537872490150178*^9, 3.537872496093255*^9}, {3.537872547385435*^9, 
   3.537872561998753*^9}, {3.537872800792879*^9, 3.5378728967451353`*^9}, {
   3.537872969967389*^9, 3.537872993322166*^9}, {3.5378733845638*^9, 
   3.537873523491342*^9}, {3.537874990501849*^9, 3.5378750749448233`*^9}, {
   3.538046326178605*^9, 3.5380463263452587`*^9}, {3.538046359506956*^9, 
   3.5380464610359497`*^9}, {3.538046502103581*^9, 3.538046513481264*^9}, {
   3.53804657410702*^9, 3.538046614577108*^9}, {3.53804665505602*^9, 
   3.538046715360199*^9}, {3.538046757351519*^9, 3.53804676998315*^9}, {
   3.5380468595384607`*^9, 3.5380468659616413`*^9}, {3.538046897437215*^9, 
   3.538046897572302*^9}, {3.538047066640044*^9, 3.538047074544244*^9}, {
   3.538047229999874*^9, 3.5380472836305647`*^9}, {3.538047353035921*^9, 
   3.538047363818179*^9}, {3.538047476249525*^9, 3.538047522111104*^9}, {
   3.5380475966181917`*^9, 3.5380475967702713`*^9}, {3.538047801532692*^9, 
   3.538047822201064*^9}, {3.538047948516816*^9, 3.538047948684765*^9}, {
   3.538114366350466*^9, 3.5381144299925222`*^9}, {3.538114576757052*^9, 
   3.5381146749454412`*^9}, {3.538114791107875*^9, 3.5381148266944447`*^9}, {
   3.538114878968347*^9, 3.538115127215603*^9}, {3.53811552595366*^9, 
   3.538115590252236*^9}, {3.5381156363832006`*^9, 3.538115704042387*^9}, {
   3.53811589099817*^9, 3.53811590783984*^9}, {3.538115999280501*^9, 
   3.5381160364460382`*^9}, 3.538116068499432*^9, {3.5381163172614202`*^9, 
   3.5381163185592117`*^9}, 3.538116587083933*^9, {3.538116795975728*^9, 
   3.5381167961435547`*^9}, {3.538116915101754*^9, 3.538116916845715*^9}, {
   3.538117082639504*^9, 3.5381170838467207`*^9}, {3.538117120446578*^9, 
   3.538117121605109*^9}, {3.538117912630061*^9, 3.5381179255489893`*^9}, {
   3.538118168821506*^9, 3.538118170682723*^9}, {3.5381182778513527`*^9, 
   3.538118288943109*^9}, {3.5381183580154047`*^9, 3.5381183581193533`*^9}, {
   3.538118848337666*^9, 3.538118920486744*^9}, {3.538119184188271*^9, 
   3.53811918440349*^9}, {3.5381193489118156`*^9, 3.538119350612996*^9}, {
   3.538119892508926*^9, 3.538119895751055*^9}, {3.538119927591441*^9, 
   3.538119936248074*^9}, {3.538120029047421*^9, 3.538120037965654*^9}, {
   3.538120194027095*^9, 3.538120201471917*^9}, {3.53812028017563*^9, 
   3.538120301265314*^9}, {3.5381381252717533`*^9, 3.538138126469459*^9}, {
   3.538328246372367*^9, 3.5383282504354353`*^9}, {3.5383283005077343`*^9, 
   3.538328335488717*^9}, {3.538329001230315*^9, 3.538329010372521*^9}, {
   3.5383292041149054`*^9, 3.538329214953123*^9}, {3.5383314262207823`*^9, 
   3.538331427882743*^9}, {3.543859340083334*^9, 3.543859341979192*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\"\<inteq[z0,horizp0,horiza1,horizt1,horizs0,asymp2,asymh2,\
asyma0,asyma1,asymT3,output_]\>\""], "Input",
 CellChangeTimes->{{3.5383293550725*^9, 3.538329380846671*^9}}],

Cell[BoxData["\<\"inteq[z0,horizp0,horiza1,horizt1,horizs0,asymp2,asymh2,\
asyma0,asyma1,asymT3,output_]\"\>"], "Output",
 CellChangeTimes->{3.543856131612866*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{"q", 
    RowBox[{"(", 
     RowBox[{"1", "-", "z"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       FractionBox[
        SuperscriptBox["q", "2"], "4"]}], ")"}], " ", 
     RowBox[{"z", "^", "3"}]}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"q", "^", "2"}], "4"], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", "z_", "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.538329462610435*^9, 3.53832946748561*^9}, {
  3.538329521299446*^9, 3.5383295310616198`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"-", 
    RowBox[{
     RowBox[{"a", "'"}], "[", "1", "]"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"-", 
   RowBox[{
    RowBox[{"T", "'"}], "[", "1", "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.538329559252846*^9, 3.53832957654383*^9}, {
  3.5383316175594177`*^9, 3.53833162076753*^9}}],

Cell[BoxData["q"], "Output",
 CellChangeTimes->{3.543856133516841*^9}],

Cell[BoxData[
 RowBox[{"3", "-", 
  FractionBox[
   SuperscriptBox["q", "2"], "4"]}]], "Output",
 CellChangeTimes->{3.543856133518272*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"a", ",", "T", ",", "S"}], "]"}]], "Input",
 CellChangeTimes->{{3.538329687225774*^9, 3.538329690184968*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"inteq", "[", 
    RowBox[{"1.", ",", "0.0001", ",", "q", ",", 
     RowBox[{"3.", "-", 
      FractionBox[
       SuperscriptBox["q", "2"], "4"]}], ",", "1.", ",", "0.0001", ",", 
     "0.0001", ",", "q", ",", 
     RowBox[{"-", "q"}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"1.", "+", 
        FractionBox[
         SuperscriptBox["q", "2"], "4"]}], ")"}]}], ",", "2"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", "0.3"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5383294791064587`*^9, 3.538329480386127*^9}, {
  3.538329552120495*^9, 3.538329698586186*^9}, {3.538331199106153*^9, 
  3.538331232043847*^9}, {3.538331650792227*^9, 3.538331661359701*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9979287522230198`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5438561360683937`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"T", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"T", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5383316585937967`*^9, 3.538331734439353*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nc4lf0fB/A6eTIahHo4KquQtDyRBh9JkQaVRxQSQtmywq9hlb1HsmVG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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV12k4lVsYBmAiqoMQSUpJo5MhRdGpRxSRZKoQlSKJyEyklBBlToVkzDwr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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0.01, 0.9979287522230198}, {0., 0.9999989777188172}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.543856138407384*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", "0.3"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"solx", "=", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"inteq", "[", 
      RowBox[{
      "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", 
       ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", "0.001"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", "3."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x3", ",", "1."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x4", ",", "0.001"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x5", ",", "0.001"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x6", ",", "q"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x7", ",", 
       RowBox[{"-", "q"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x8", ",", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"1.", "+", 
          FractionBox[
           SuperscriptBox["q", "2"], "4"]}], ")"}]}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inteq", "[", 
   RowBox[{
   "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", ",",
     "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", "solx"}]}], "Input",
 CellChangeTimes->{{3.538332379828829*^9, 3.538332479861409*^9}, {
  3.538332516308981*^9, 3.5383325571714373`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9980189782062728`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856142247216*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9980189782062728`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856142358026*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9980189782062728`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856142453266*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(NDSolve \
:: ndsz\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5438561424888*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x1", "\[Rule]", 
    RowBox[{"-", "7.661529888781302`*^-23"}]}], ",", 
   RowBox[{"x2", "\[Rule]", "2.9775`"}], ",", 
   RowBox[{"x3", "\[Rule]", "1.`"}], ",", 
   RowBox[{"x4", "\[Rule]", "1.118827571180198`*^-22"}], ",", 
   RowBox[{"x5", "\[Rule]", 
    RowBox[{"-", "7.42518865319345`*^-20"}]}], ",", 
   RowBox[{"x6", "\[Rule]", "0.29999999999999977`"}], ",", 
   RowBox[{"x7", "\[Rule]", 
    RowBox[{"-", "0.2999999999999995`"}]}], ",", 
   RowBox[{"x8", "\[Rule]", 
    RowBox[{"-", "1.0163444666576351`"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.5438561483387012`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.1032052684663363`*^-21"}], ",", 
   RowBox[{"-", "1.1859749201921558`*^-20"}], ",", "1.942890293094024`*^-16", 
   ",", 
   RowBox[{"-", "2.549327415835023`*^-10"}], ",", "0.`", ",", 
   RowBox[{"-", "8.094808090726304`*^-21"}], ",", "8.881784197001252`*^-16", 
   ",", "9.32328259865278`*^-41"}], "}"}]], "Output",
 CellChangeTimes->{3.543856148422875*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", "0.3427"}], ";"}]], "Input",
 CellChangeTimes->{{3.538331888911525*^9, 3.538331890488124*^9}, {
  3.5383332721236134`*^9, 3.538333358209091*^9}, {3.538372556610911*^9, 
  3.538372684298564*^9}, {3.538372774294757*^9, 3.5383727935021143`*^9}, {
  3.538380435266081*^9, 3.5383804358499737`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"{", 
    RowBox[{"0.000001", ",", 
     RowBox[{"3.", "-", 
      FractionBox[
       SuperscriptBox["q", "2"], "4"]}], ",", "1.", ",", "0.000001", ",", 
     "0.000001", ",", "q", ",", 
     RowBox[{"-", "q"}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"1.", "+", 
        FractionBox[
         SuperscriptBox["q", "2"], "4"]}], ")"}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.5381366020899467`*^9, {3.538328422257468*^9, 3.5383284518318768`*^9}, 
   3.538328887038381*^9, {3.538331754993125*^9, 3.5383317597446136`*^9}, {
   3.538331893617297*^9, 3.538331896097275*^9}, {3.538331961393141*^9, 
   3.538331965384636*^9}, {3.538380438091875*^9, 3.538380445343212*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq0", "=", 
    RowBox[{"inteq", "[", 
     RowBox[{"1.", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "3", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "4", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "5", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "6", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "7", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DX", " ", "=", " ", "0.0001"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"vec0", "=", "vec"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "-=", "DX"}], " ", ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"eq1", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"1.", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "+=", 
       RowBox[{"2", "*", "DX"}]}], " ", ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"eq2", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"1.", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"mat", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"eq2", "-", "eq1"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "DX"}], ")"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "8"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<det = \>\"", ",", 
     RowBox[{"Det", "[", "mat", "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dvec", "=", 
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{"Transpose", "[", "mat", "]"}], "]"}], ".", "eq0"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vec", " ", "=", " ", 
    RowBox[{"vec", "-", "dvec"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<vec = \>\"", ",", "vec", ",", "\"\<  ->  eq = \>\"", ",", "eq0"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.538120490121634*^9, 3.538120518932563*^9}, {
   3.5381205558741503`*^9, 3.538120610837431*^9}, {3.5381206659362717`*^9, 
   3.538120712255209*^9}, {3.5383285846229553`*^9, 3.538328585388818*^9}, {
   3.538328684844769*^9, 3.5383286852597733`*^9}, 3.538328770081517*^9, {
   3.5383289405611877`*^9, 3.5383289561436033`*^9}, {3.538329024216524*^9, 
   3.538329027272518*^9}, {3.538329231307086*^9, 3.538329245530115*^9}, {
   3.53832928014611*^9, 3.5383292802257977`*^9}, {3.538331899292232*^9, 
   3.538331918317177*^9}, {3.5383320080930357`*^9, 3.53833201029294*^9}, {
   3.5383320534615726`*^9, 3.538332054173419*^9}, {3.538332091130785*^9, 
   3.538332091290278*^9}, {3.538332148467001*^9, 3.538332166530912*^9}, {
   3.538332763655594*^9, 3.538332763839275*^9}, 3.538332811566271*^9, {
   3.5383329603107758`*^9, 3.538333014609095*^9}, {3.538372704879333*^9, 
   3.538372748091798*^9}, {3.538380094711239*^9, 3.538380095245941*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9979135417502042`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856152448059*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9979135417502042`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856152544303*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9979135417502042`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856152637629*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9979135417502042`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5438561527316313`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(NDSolve \
:: ndsz\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856152732946*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"det = \"\>", "\[InvisibleSpace]", "0.00194899837671672`"}],
  SequenceForm["det = ", 0.00194899837671672],
  Editable->False]], "Print",
 CellChangeTimes->{3.54385615398006*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vec = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1.4004602773944761`*^-9", ",", "2.9706391774655456`", ",", 
     "0.999999999992098`", ",", 
     RowBox[{"-", "1.2508321261948216`*^-9"}], ",", "5.548145747764666`*^-7", 
     ",", "0.3426999999970824`", ",", 
     RowBox[{"-", "0.3426999999968354`"}], ",", 
     RowBox[{"-", "1.023174151021632`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"  ->  eq = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.1280293746446687`*^-7"}], ",", "9.642864257191148`*^-8", 
     ",", 
     RowBox[{"-", "2.4397150966137815`*^-14"}], ",", 
     RowBox[{"-", "0.0003983579374308155`"}], ",", 
     RowBox[{"-", "1.5443202272535927`*^-13"}], ",", 
     RowBox[{"-", "9.232221517183033`*^-8"}], ",", "1.6042722705833512`*^-13",
      ",", "2.6829428906473124`*^-14"}], "}"}]}],
  SequenceForm[
  "vec = ", {1.4004602773944761`*^-9, 2.9706391774655456`, 
   0.999999999992098, -1.2508321261948216`*^-9, 5.548145747764666*^-7, 
   0.3426999999970824, -0.3426999999968354, -1.023174151021632}, 
   "  ->  eq = ", {-3.1280293746446687`*^-7, 
   9.642864257191148*^-8, -2.4397150966137815`*^-14, -0.0003983579374308155, \
-1.5443202272535927`*^-13, -9.232221517183033*^-8, 1.6042722705833512`*^-13, 
   2.6829428906473124`*^-14}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856153982307*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "q", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"matlist", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"vec", "=", 
       RowBox[{"{", 
        RowBox[{"0.0000000000001", ",", 
         RowBox[{"3.", "-", 
          FractionBox[
           SuperscriptBox["q", "2"], "4"]}], ",", "1.", ",", 
         "0.0000000000001", ",", "0.0000000000001", ",", "q", ",", 
         RowBox[{"-", "q"}], ",", 
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"1.", "+", 
            FractionBox[
             SuperscriptBox["q", "2"], "4"]}], ")"}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"mat", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"eq0", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"1.", ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"DX", " ", "=", " ", "0.000001"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"vec0", "=", "vec"}], ";", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"vec0", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], "-=", "DX"}], " ", ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"eq1", "=", 
          RowBox[{"inteq", "[", 
           RowBox[{"1.", ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "3", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "4", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "5", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "6", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "7", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"vec0", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], "+=", 
          RowBox[{"2", "*", "DX"}]}], " ", ";", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{"eq2", "=", 
          RowBox[{"inteq", "[", 
           RowBox[{"1.", ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "3", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "4", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "5", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "6", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "7", "]"}], "]"}], ",", 
            RowBox[{"vec0", "[", 
             RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"mat", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"eq2", "-", "eq1"}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"2", "*", "DX"}], ")"}]}]}], "]"}], ";"}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "8"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"tmp", "=", 
       RowBox[{"Eigenvalues", "[", "mat", "]"}]}], ";", "\[IndentingNewLine]",
       "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<q = \>\"", ",", "q", ",", "\"\<\\n\\n    evals = \>\"", ",", 
        RowBox[{"Sort", "[", 
         RowBox[{"Abs", "[", "tmp", "]"}], "]"}], ",", "\"\<\\n\\n\>\""}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"matlist", ",", 
        RowBox[{"{", 
         RowBox[{"q", ",", 
          RowBox[{"Eigenvalues", "[", "mat", "]"}]}], "}"}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "0.1", ",", "3.3", ",", "0.1"}], "}"}]}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "q", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.538120490121634*^9, 3.538120518932563*^9}, {
   3.5381205558741503`*^9, 3.538120610837431*^9}, {3.5381206659362717`*^9, 
   3.538120712255209*^9}, {3.5383285846229553`*^9, 3.538328585388818*^9}, {
   3.538328684844769*^9, 3.5383286852597733`*^9}, 3.538328770081517*^9, {
   3.5383289405611877`*^9, 3.5383289561436033`*^9}, {3.538329024216524*^9, 
   3.538329027272518*^9}, {3.538329231307086*^9, 3.538329245530115*^9}, {
   3.53832928014611*^9, 3.5383292802257977`*^9}, {3.538331899292232*^9, 
   3.538331918317177*^9}, {3.5383320080930357`*^9, 3.53833201029294*^9}, {
   3.5383320534615726`*^9, 3.538332054173419*^9}, {3.538332091130785*^9, 
   3.538332091290278*^9}, {3.538332148467001*^9, 3.538332166530912*^9}, {
   3.538332763655594*^9, 3.538332763839275*^9}, 3.538332811566271*^9, {
   3.5383329603107758`*^9, 3.538333014609095*^9}, {3.538372704879333*^9, 
   3.538372748091798*^9}, {3.538380094711239*^9, 3.538380301811192*^9}, {
   3.538380346386833*^9, 3.53838035277041*^9}, {3.5383804228339043`*^9, 
   3.538380465316924*^9}, {3.5383805155001173`*^9, 3.538380517170929*^9}, {
   3.538394417410356*^9, 3.5383944338261538`*^9}, {3.538394492189281*^9, 
   3.538394500156169*^9}, {3.538394576260153*^9, 3.538394585499764*^9}, {
   3.538464511316242*^9, 3.538464545454879*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9979702351324741`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856177731641*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9979702342611357`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856177824052*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9979702461402241`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856177916011*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(NDSolve \
:: ndsz\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856177917738*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "0.1`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.10341380711205717`", ",", "0.3080738075119625`", ",", 
     "0.4810849406922952`", ",", "0.4872889089201043`", ",", 
     "0.4872889089201043`", ",", "0.48857341637709745`", ",", 
     "0.48857341637709745`", ",", "0.9973189986934783`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 0.1, "\n\n    evals = ", {0.10341380711205717`, 0.3080738075119625, 
   0.4810849406922952, 0.4872889089201043, 0.4872889089201043, 
   0.48857341637709745`, 0.48857341637709745`, 0.9973189986934783}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856178597858*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "0.2`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.105317413658435`", ",", "0.29715576110507846`", ",", 
     "0.4605677829384676`", ",", "0.4822094733769766`", ",", 
     "0.4822094733769766`", ",", "0.5091855830018495`", ",", 
     "0.5091855830018495`", ",", "0.994777635907323`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 0.2, "\n\n    evals = ", {0.105317413658435, 0.29715576110507846`, 
   0.4605677829384676, 0.4822094733769766, 0.4822094733769766, 
   0.5091855830018495, 0.5091855830018495, 0.994777635907323}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5438561801236153`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "0.30000000000000004`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.10750862282775006`", ",", "0.2819560679278822`", ",", 
     "0.4404861842818984`", ",", "0.480884261159518`", ",", 
     "0.480884261159518`", ",", "0.529916832131622`", ",", 
     "0.529916832131622`", ",", "0.9923721137347236`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 0.30000000000000004`, "\n\n    evals = ", {0.10750862282775006`, 
   0.2819560679278822, 0.4404861842818984, 0.480884261159518, 
   0.480884261159518, 0.529916832131622, 0.529916832131622, 
   0.9923721137347236}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856181627481*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "0.4`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.10997025252439806`", ",", "0.2637076404965985`", ",", 
     "0.4207816345758621`", ",", "0.42106844540762245`", ",", 
     "0.5506376738243415`", ",", "0.5506376738243415`", ",", 
     "0.5537766561545777`", ",", "0.9901022023306465`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 0.4, "\n\n    evals = ", {0.10997025252439806`, 0.2637076404965985, 
   0.4207816345758621, 0.42106844540762245`, 0.5506376738243415, 
   0.5506376738243415, 0.5537766561545777, 0.9901022023306465}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856183145768*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "0.5`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.11315256349533274`", ",", "0.24437360582698142`", ",", 
     "0.3832130749215883`", ",", "0.40294543535437005`", ",", 
     "0.571143409570515`", ",", "0.571143409570515`", ",", 
     "0.6159834254487233`", ",", "0.9879536113627342`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 0.5, "\n\n    evals = ", {0.11315256349533274`, 
   0.24437360582698142`, 0.3832130749215883, 0.40294543535437005`, 
   0.571143409570515, 0.571143409570515, 0.6159834254487233, 
   0.9879536113627342}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856184657051*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "0.6`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.11706779508913143`", ",", "0.2253141992976103`", ",", 
     "0.36290676116714904`", ",", "0.3862128337394636`", ",", 
     "0.5911865577167303`", ",", "0.5911865577167303`", ",", 
     "0.6586367331988184`", ",", "0.9859312816362473`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 0.6, "\n\n    evals = ", {0.11706779508913143`, 0.2253141992976103, 
   0.36290676116714904`, 0.3862128337394636, 0.5911865577167303, 
   0.5911865577167303, 0.6586367331988184, 0.9859312816362473}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856186169547*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "0.7000000000000001`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.12192316929666173`", ",", "0.2070599728234746`", ",", 
     "0.3481792393475016`", ",", "0.3708616414561163`", ",", 
     "0.610651499826944`", ",", "0.610651499826944`", ",", 
     "0.6926530464515942`", ",", "0.984022059656388`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 0.7000000000000001, "\n\n    evals = ", {0.12192316929666173`, 
   0.2070599728234746, 0.3481792393475016, 0.3708616414561163, 
   0.610651499826944, 0.610651499826944, 0.6926530464515942, 
   0.984022059656388}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856187670919*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "0.8`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.12913469893517285`", ",", "0.18833236231934117`", ",", 
     "0.3353496542947621`", ",", "0.3572285108532481`", ",", 
     "0.6293852329295395`", ",", "0.6293852329295395`", ",", 
     "0.7215515390099814`", ",", "0.9822138640751459`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 0.8, "\n\n    evals = ", {0.12913469893517285`, 
   0.18833236231934117`, 0.3353496542947621, 0.3572285108532481, 
   0.6293852329295395, 0.6293852329295395, 0.7215515390099814, 
   0.9822138640751459}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856189228915*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "0.9`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.14437219831525494`", ",", "0.16300883705969565`", ",", 
     "0.32279187854554825`", ",", "0.34501978011795326`", ",", 
     "0.6471486078319575`", ",", "0.6471486078319575`", ",", 
     "0.7470682325971778`", ",", "0.9805265573006016`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 0.9, "\n\n    evals = ", {0.14437219831525494`, 
   0.16300883705969565`, 0.32279187854554825`, 0.34501978011795326`, 
   0.6471486078319575, 0.6471486078319575, 0.7470682325971778, 
   0.9805265573006016}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856190744103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "1.`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.15124689629306376`", ",", "0.15124689629306376`", ",", 
     "0.3104252352075757`", ",", "0.3340294857749796`", ",", 
     "0.6640226040957465`", ",", "0.6640226040957465`", ",", 
     "0.7694882166154645`", ",", "0.9789231745946478`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 1., "\n\n    evals = ", {0.15124689629306376`, 0.15124689629306376`,
    0.3104252352075757, 0.3340294857749796, 0.6640226040957465, 
   0.6640226040957465, 0.7694882166154645, 0.9789231745946478}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856192263233*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "1.1`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.1496106835787866`", ",", "0.1496106835787866`", ",", 
     "0.2975683152908043`", ",", "0.32446124657899744`", ",", 
     "0.6799936277337348`", ",", "0.6799936277337348`", ",", 
     "0.7894409215534012`", ",", "0.9774177669884597`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 1.1, "\n\n    evals = ", {0.1496106835787866, 0.1496106835787866, 
   0.2975683152908043, 0.32446124657899744`, 0.6799936277337348, 
   0.6799936277337348, 0.7894409215534012, 0.9774177669884597}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856193800235*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "1.2000000000000002`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.14841544034817594`", ",", "0.14841544034817594`", ",", 
     "0.28370006006175325`", ",", "0.3163900437171912`", ",", 
     "0.6949587181675024`", ",", "0.6949587181675024`", ",", 
     "0.8074774338819561`", ",", "0.97599440044521`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 1.2000000000000002`, "\n\n    evals = ", {0.14841544034817594`, 
   0.14841544034817594`, 0.28370006006175325`, 0.3163900437171912, 
   0.6949587181675024, 0.6949587181675024, 0.8074774338819561, 
   0.97599440044521}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856195357759*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "1.3000000000000003`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.14750945713496236`", ",", "0.14750945713496236`", ",", 
     "0.26905105618464814`", ",", "0.30899314876515294`", ",", 
     "0.7089130869106323`", ",", "0.7089130869106323`", ",", 
     "0.8237197571526798`", ",", "0.9746617714569196`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 1.3000000000000003`, "\n\n    evals = ", {0.14750945713496236`, 
   0.14750945713496236`, 0.26905105618464814`, 0.30899314876515294`, 
   0.7089130869106323, 0.7089130869106323, 0.8237197571526798, 
   0.9746617714569196}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856196895854*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "1.4000000000000001`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.1469260374496001`", ",", "0.1469260374496001`", ",", 
     "0.2535151967598985`", ",", "0.30287434524037227`", ",", 
     "0.7219963394624999`", ",", "0.7219963394624999`", ",", 
     "0.83808709688851`", ",", "0.9734151203634679`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 1.4000000000000001`, "\n\n    evals = ", {0.1469260374496001, 
   0.1469260374496001, 0.2535151967598985, 0.30287434524037227`, 
   0.7219963394624999, 0.7219963394624999, 0.83808709688851, 
   0.9734151203634679}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5438561984452457`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "1.5000000000000002`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.1472872320193651`", ",", "0.1472872320193651`", ",", 
     "0.23631495654646648`", ",", "0.29764945584509017`", ",", 
     "0.7340681939455374`", ",", "0.7340681939455374`", ",", 
     "0.8511429632037512`", ",", "0.9722272181275834`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 1.5000000000000002`, "\n\n    evals = ", {0.1472872320193651, 
   0.1472872320193651, 0.23631495654646648`, 0.29764945584509017`, 
   0.7340681939455374, 0.7340681939455374, 0.8511429632037512, 
   0.9722272181275834}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856199954764*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "1.6`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.14831601437022718`", ",", "0.14831601437022718`", ",", 
     "0.21727107128865072`", ",", "0.29349413458263146`", ",", 
     "0.7452364972622278`", ",", "0.7452364972622278`", ",", 
     "0.862681383584513`", ",", "0.9711129440220516`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 1.6, "\n\n    evals = ", {0.14831601437022718`, 
   0.14831601437022718`, 0.21727107128865072`, 0.29349413458263146`, 
   0.7452364972622278, 0.7452364972622278, 0.862681383584513, 
   0.9711129440220516}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.54385620151472*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "1.7000000000000002`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.1503368626269379`", ",", "0.1503368626269379`", ",", 
     "0.19638165464829072`", ",", "0.2897975767827035`", ",", 
     "0.7555279550623869`", ",", "0.7555279550623869`", ",", 
     "0.8728265434433279`", ",", "0.9700863868220402`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 1.7000000000000002`, "\n\n    evals = ", {0.1503368626269379, 
   0.1503368626269379, 0.19638165464829072`, 0.2897975767827035, 
   0.7555279550623869, 0.7555279550623869, 0.8728265434433279, 
   0.9700863868220402}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5438562030497*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "1.8000000000000003`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.1535391233082065`", ",", "0.1535391233082065`", ",", 
     "0.1738203745065321`", ",", "0.2869961997726521`", ",", 
     "0.7649806575470911`", ",", "0.7649806575470911`", ",", 
     "0.8814480673681595`", ",", "0.9690849309731999`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 1.8000000000000003`, "\n\n    evals = ", {0.1535391233082065, 
   0.1535391233082065, 0.1738203745065321, 0.2869961997726521, 
   0.7649806575470911, 0.7649806575470911, 0.8814480673681595, 
   0.9690849309731999}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856204560557*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "1.9000000000000001`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.1516157791638879`", ",", "0.1574666954610976`", ",", 
     "0.1574666954610976`", ",", "0.28462461596506683`", ",", 
     "0.773569953917089`", ",", "0.773569953917089`", ",", 
     "0.8888154448784077`", ",", "0.9681211589945081`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 1.9000000000000001`, "\n\n    evals = ", {0.1516157791638879, 
   0.1574666954610976, 0.1574666954610976, 0.28462461596506683`, 
   0.773569953917089, 0.773569953917089, 0.8888154448784077, 
   0.9681211589945081}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856206097*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "2.`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.13306401363984743`", ",", "0.16002120437668724`", ",", 
     "0.16002120437668724`", ",", "0.2831572338015578`", ",", 
     "0.7814890665788191`", ",", "0.7814890665788191`", ",", 
     "0.894565279500848`", ",", "0.9672396450856637`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 2., "\n\n    evals = ", {0.13306401363984743`, 0.16002120437668724`,
    0.16002120437668724`, 0.2831572338015578, 0.7814890665788191, 
   0.7814890665788191, 0.894565279500848, 0.9672396450856637}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856207624876*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "2.1`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.11663220574095495`", ",", "0.16186767818305509`", ",", 
     "0.16186767818305509`", ",", "0.2826709701846873`", ",", 
     "0.7886792563749072`", ",", "0.7886792563749072`", ",", 
     "0.898961775876013`", ",", "0.9664269910724539`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 2.1, "\n\n    evals = ", {0.11663220574095495`, 
   0.16186767818305509`, 0.16186767818305509`, 0.2826709701846873, 
   0.7886792563749072, 0.7886792563749072, 0.898961775876013, 
   0.9664269910724539}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856209155808*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "2.2`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.1012895266137965`", ",", "0.16342256794144175`", ",", 
     "0.16342256794144175`", ",", "0.2823854599355533`", ",", 
     "0.7952240117387995`", ",", "0.7952240117387995`", ",", 
     "0.9016347987855954`", ",", "0.9656198316210337`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 2.2, "\n\n    evals = ", {0.1012895266137965, 0.16342256794144175`, 
   0.16342256794144175`, 0.2823854599355533, 0.7952240117387995, 
   0.7952240117387995, 0.9016347987855954, 0.9656198316210337}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5438562107380447`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "2.3000000000000003`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.08588582283368738`", ",", "0.16583930099225713`", ",", 
     "0.16583930099225713`", ",", "0.28032885514254496`", ",", 
     "0.8017985389524248`", ",", "0.8017985389524248`", ",", 
     "0.9041591985181741`", ",", "0.9647555006174715`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 2.3000000000000003`, "\n\n    evals = ", {0.08588582283368738, 
   0.16583930099225713`, 0.16583930099225713`, 0.28032885514254496`, 
   0.8017985389524248, 0.8017985389524248, 0.9041591985181741, 
   0.9647555006174715}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5438562123647013`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "2.4000000000000004`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.07023190732870528`", ",", "0.1678408370916536`", ",", 
     "0.1678408370916536`", ",", "0.2820634574117066`", ",", 
     "0.8067012893364426`", ",", "0.8067012893364426`", ",", 
     "0.9032673016964277`", ",", "0.9638629063853436`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 2.4000000000000004`, "\n\n    evals = ", {0.07023190732870528, 
   0.1678408370916536, 0.1678408370916536, 0.2820634574117066, 
   0.8067012893364426, 0.8067012893364426, 0.9032673016964277, 
   0.9638629063853436}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856213985928*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "2.5000000000000004`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.054748386311328896`", ",", "0.1700509636353463`", ",", 
     "0.1700509636353463`", ",", "0.28932639607200833`", ",", 
     "0.8109466317444378`", ",", "0.8109466317444378`", ",", 
     "0.8996316808570656`", ",", "0.9628332528728578`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 2.5000000000000004`, "\n\n    evals = ", {0.054748386311328896`, 
   0.1700509636353463, 0.1700509636353463, 0.28932639607200833`, 
   0.8109466317444378, 0.8109466317444378, 0.8996316808570656, 
   0.9628332528728578}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856215577384*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "2.6`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.03963692383014095`", ",", "0.17473287819010014`", ",", 
     "0.17473287819010014`", ",", "0.29312144363241055`", ",", 
     "0.8142039167124828`", ",", "0.8142039167124828`", ",", 
     "0.8939871944484704`", ",", "0.9615658066706478`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 2.6, "\n\n    evals = ", {0.03963692383014095, 0.17473287819010014`,
    0.17473287819010014`, 0.29312144363241055`, 0.8142039167124828, 
   0.8142039167124828, 0.8939871944484704, 0.9615658066706478}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856217135334*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "2.7`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.0256104714513132`", ",", "0.18077218507871373`", ",", 
     "0.18077218507871373`", ",", "0.2977740891247781`", ",", 
     "0.8163106318362363`", ",", "0.8163106318362363`", ",", 
     "0.8856886101263014`", ",", "0.9598093919294995`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 2.7, "\n\n    evals = ", {0.0256104714513132, 0.18077218507871373`, 
   0.18077218507871373`, 0.2977740891247781, 0.8163106318362363, 
   0.8163106318362363, 0.8856886101263014, 0.9598093919294995}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5438562186987553`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "2.8000000000000003`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.013566187274377289`", ",", "0.18924705249746132`", ",", 
     "0.18924705249746132`", ",", "0.30422188934211697`", ",", 
     "0.8169603516736751`", ",", "0.8169603516736751`", ",", 
     "0.8735367467076685`", ",", "0.9569921659962486`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 2.8000000000000003`, "\n\n    evals = ", {0.013566187274377289`, 
   0.18924705249746132`, 0.18924705249746132`, 0.30422188934211697`, 
   0.8169603516736751, 0.8169603516736751, 0.8735367467076685, 
   0.9569921659962486}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856220288604*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "2.9000000000000004`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.0044014885404513255`", ",", "0.2008114552349696`", ",", 
     "0.2008114552349696`", ",", "0.314190758076077`", ",", 
     "0.8152129737880991`", ",", "0.8152129737880991`", ",", 
     "0.8565643624935351`", ",", "0.9519982920095864`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 2.9000000000000004`, "\n\n    evals = ", {0.0044014885404513255`, 
   0.2008114552349696, 0.2008114552349696, 0.314190758076077, 
   0.8152129737880991, 0.8152129737880991, 0.8565643624935351, 
   0.9519982920095864}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856221879546*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.0000000000000004`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.0006361227088185689`", ",", "0.21680870905446936`", ",", 
     "0.21680870905446936`", ",", "0.32982543358827976`", ",", 
     "0.8094298059137022`", ",", "0.8094298059137022`", ",", 
     "0.8324416904853476`", ",", "0.9431133605000576`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.0000000000000004`, "\n\n    evals = ", {0.0006361227088185689, 
   0.21680870905446936`, 0.21680870905446936`, 0.32982543358827976`, 
   0.8094298059137022, 0.8094298059137022, 0.8324416904853476, 
   0.9431133605000576}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5438562234448757`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.1`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.00008739850443949857`", ",", "0.240906878900645`", ",", 
     "0.240906878900645`", ",", "0.36120918088546417`", ",", 
     "0.7951993056894957`", ",", "0.7951993056894957`", ",", 
     "0.7960022721491455`", ",", "0.9237343612581241`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.1, "\n\n    evals = ", {0.00008739850443949857, 0.240906878900645,
    0.240906878900645, 0.36120918088546417`, 0.7951993056894957, 
   0.7951993056894957, 0.7960022721491455, 0.9237343612581241}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856225080881*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.2`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.007866939227914196`", ",", "0.2806264812520988`", ",", 
     "0.2806264812520988`", ",", "0.44710140850950103`", ",", 
     "0.7298161649272592`", ",", "0.7571712568326389`", ",", 
     "0.7571712568326389`", ",", "0.866399486914286`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.2, "\n\n    evals = ", {0.007866939227914196, 0.2806264812520988, 
   0.2806264812520988, 0.44710140850950103`, 0.7298161649272592, 
   0.7571712568326389, 0.7571712568326389, 0.866399486914286}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856226712371*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.3000000000000003`", 
   "\[InvisibleSpace]", "\<\"\\n\\n    evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.02375486329202455`", ",", "0.3296499436181818`", ",", 
     "0.42046616112542234`", ",", "0.42046616112542234`", ",", 
     "0.5903543366537388`", ",", "0.5903543366537388`", ",", 
     "0.9824275281577733`", ",", "0.9824275281577733`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.3000000000000003`, "\n\n    evals = ", {0.02375486329202455, 
   0.3296499436181818, 0.42046616112542234`, 0.42046616112542234`, 
   0.5903543366537388, 0.5903543366537388, 0.9824275281577733, 
   0.9824275281577733}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856228330179*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", "2.979"}], ";"}]], "Input",
 CellChangeTimes->{{3.538331888911525*^9, 3.538331890488124*^9}, {
  3.5383332721236134`*^9, 3.538333358209091*^9}, {3.538372556610911*^9, 
  3.538372684298564*^9}, {3.538372774294757*^9, 3.5383727935021143`*^9}, {
  3.538380435266081*^9, 3.5383804358499737`*^9}, {3.538394561420013*^9, 
  3.538394565754445*^9}, {3.538394711436935*^9, 3.538394712492588*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"{", 
    RowBox[{"0.0000000000001", ",", 
     RowBox[{"3.", "-", 
      FractionBox[
       SuperscriptBox["q", "2"], "4"]}], ",", "1.", ",", "0.0000000000001", 
     ",", "0.0000000000001", ",", "q", ",", 
     RowBox[{"-", "q"}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"1.", "+", 
        FractionBox[
         SuperscriptBox["q", "2"], "4"]}], ")"}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.5381366020899467`*^9, {3.538328422257468*^9, 3.5383284518318768`*^9}, 
   3.538328887038381*^9, {3.538331754993125*^9, 3.5383317597446136`*^9}, {
   3.538331893617297*^9, 3.538331896097275*^9}, {3.538331961393141*^9, 
   3.538331965384636*^9}, {3.538380438091875*^9, 3.538380445343212*^9}, 
   3.5383946710003633`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq0", "=", 
    RowBox[{"inteq", "[", 
     RowBox[{"1.", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "3", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "4", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "5", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "6", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "7", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DX", " ", "=", " ", "0.000001"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"vec0", "=", "vec"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "-=", "DX"}], " ", ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"eq1", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"1.", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "+=", 
       RowBox[{"2", "*", "DX"}]}], " ", ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"eq2", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"1.", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"mat", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"eq2", "-", "eq1"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "DX"}], ")"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "8"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<det = \>\"", ",", 
     RowBox[{"Det", "[", "mat", "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dvec", "=", 
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{"Transpose", "[", "mat", "]"}], "]"}], ".", "eq0"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vec", " ", "=", " ", 
    RowBox[{"vec", "-", "dvec"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<vec = \>\"", ",", "vec", ",", "\"\<  ->  eq = \>\"", ",", "eq0"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.538120490121634*^9, 3.538120518932563*^9}, {
   3.5381205558741503`*^9, 3.538120610837431*^9}, {3.5381206659362717`*^9, 
   3.538120712255209*^9}, {3.5383285846229553`*^9, 3.538328585388818*^9}, {
   3.538328684844769*^9, 3.5383286852597733`*^9}, 3.538328770081517*^9, {
   3.5383289405611877`*^9, 3.5383289561436033`*^9}, {3.538329024216524*^9, 
   3.538329027272518*^9}, {3.538329231307086*^9, 3.538329245530115*^9}, {
   3.53832928014611*^9, 3.5383292802257977`*^9}, {3.538331899292232*^9, 
   3.538331918317177*^9}, {3.5383320080930357`*^9, 3.53833201029294*^9}, {
   3.5383320534615726`*^9, 3.538332054173419*^9}, {3.538332091130785*^9, 
   3.538332091290278*^9}, {3.538332148467001*^9, 3.538332166530912*^9}, {
   3.538332763655594*^9, 3.538332763839275*^9}, 3.538332811566271*^9, {
   3.5383329603107758`*^9, 3.538333014609095*^9}, {3.538372704879333*^9, 
   3.538372748091798*^9}, {3.538380094711239*^9, 3.538380095245941*^9}, {
   3.538394672675757*^9, 3.538394672818479*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9901326768401608`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856244603014*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9901326718337918`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856244708267*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9901326836871687`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856244813734*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(NDSolve \
:: ndsz\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5438562448151283`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"det = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.3332204179564278`*^-8"}]}],
  SequenceForm["det = ", -1.3332204179564278`*^-8],
  Editable->False]], "Print",
 CellChangeTimes->{3.5438562455181313`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vec = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "4.128857629684498`*^-8", ",", "0.7813897499999998`", ",", "1.`", ",", 
     RowBox[{"-", "3.447289872270587`*^-8"}], ",", "3.28466913832993`*^-8", 
     ",", "2.9790000000238455`", ",", 
     RowBox[{"-", "2.979000000045856`"}], ",", 
     RowBox[{"-", "3.210348767400071`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"  ->  eq = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4821411492108695`*^-14"}], ",", 
     "2.871997845974958`*^-13", ",", "4.440892098500626`*^-16", ",", 
     RowBox[{"-", "0.0005287223825316545`"}], ",", "0.`", ",", 
     "8.65883299151227`*^-13", ",", 
     RowBox[{"-", "4.440892098500626`*^-15"}], ",", 
     RowBox[{"-", "7.130465378317352`*^-24"}]}], "}"}]}],
  SequenceForm[
  "vec = ", {4.128857629684498*^-8, 0.7813897499999998, 
   1., -3.447289872270587*^-8, 3.28466913832993*^-8, 
   2.9790000000238455`, -2.979000000045856, -3.210348767400071}, 
   "  ->  eq = ", {-1.4821411492108695`*^-14, 2.871997845974958*^-13, 
   4.440892098500626*^-16, -0.0005287223825316545, 0., 
   8.65883299151227*^-13, -4.440892098500626*^-15, -7.130465378317352*^-24}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856245520369*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "mat", "]"}]], "Input",
 CellChangeTimes->{{3.538394632584487*^9, 3.538394636242876*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.945530522276003`", ",", 
   RowBox[{"-", "0.8382353996445999`"}], ",", 
   RowBox[{"0.4538384226102648`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.672302348862756`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.4538384226102648`", "\[VeryThinSpace]", "-", 
    RowBox[{"0.672302348862756`", " ", "\[ImaginaryI]"}]}], ",", 
   "0.32566486485697643`", ",", 
   RowBox[{
    RowBox[{"-", "0.18486090279021028`"}], "+", 
    RowBox[{"0.10572998499721999`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.18486090279021028`"}], "-", 
    RowBox[{"0.10572998499721999`", " ", "\[ImaginaryI]"}]}], ",", 
   "1.7309720369093746`*^-6"}], "}"}]], "Output",
 CellChangeTimes->{3.5438562489417877`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigensystem", "[", "mat", "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.5383947953079863`*^9, 3.538394802096307*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.945530522276003`", ",", 
   RowBox[{"-", "0.8382353996445999`"}], ",", 
   RowBox[{"0.4538384226102648`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.672302348862756`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.4538384226102648`", "\[VeryThinSpace]", "-", 
    RowBox[{"0.672302348862756`", " ", "\[ImaginaryI]"}]}], ",", 
   "0.32566486485697643`", ",", 
   RowBox[{
    RowBox[{"-", "0.18486090279021028`"}], "+", 
    RowBox[{"0.10572998499721999`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.18486090279021028`"}], "-", 
    RowBox[{"0.10572998499721999`", " ", "\[ImaginaryI]"}]}], ",", 
   "1.7309720369093746`*^-6"}], "}"}]], "Output",
 CellChangeTimes->{3.543856249877514*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigensystem", "[", "mat", "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.538394806318841*^9, 3.538394810078865*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.8940344494134517`"}], ",", 
   RowBox[{"-", "0.4044619181215`"}], ",", "3.3346699386897934`*^-7", ",", 
   RowBox[{"-", "7.75137404251833`*^-12"}], ",", 
   RowBox[{"-", "5.683965098262476`*^-13"}], ",", "0.19264724252179596`", ",", 
   RowBox[{"-", "1.3338732284597615`*^-7"}], ",", 
   RowBox[{"-", "2.873927593868073`*^-7"}]}], "}"}]], "Output",
 CellChangeTimes->{3.543856250628662*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"evec", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8940344494134517`"}], ",", 
     RowBox[{"-", "0.4044619181215`"}], ",", "3.3346699386897934`*^-7", ",", 
     RowBox[{"-", "7.75137404251833`*^-12"}], ",", 
     RowBox[{"-", "5.683965098262476`*^-13"}], ",", "0.19264724252179596`", 
     ",", 
     RowBox[{"-", "1.3338732284597615`*^-7"}], ",", 
     RowBox[{"-", "2.873927593868073`*^-7"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5383948180312023`*^9, 3.538394843959775*^9}, {
  3.538467289519421*^9, 3.5384672925812597`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", ".", "evec"}], "/", "evec"}]], "Input",
 CellChangeTimes->{{3.538394822310273*^9, 3.5383948269747343`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.7309720369500027`*^-6", ",", "1.730972037347831`*^-6", ",", 
   "1.7309903355366244`*^-6", ",", "0.00002354622360275657`", ",", 
   "0.00024415296718108736`", ",", "1.7309720368627073`*^-6", ",", 
   "1.7314591554086382`*^-6", ",", "1.7309841516047053`*^-6"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.543856252664888*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "\"\<inteq[z0,horizp0,horiza1,horizt1,horizs0,asymp2,asymh2,asyma0,asyma1,\
asymT3,output_]\>\"", ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"\"\<inteq[1.,vec[[1]],q,vec[[2]],vec[[3]],vec[[4]],vec[[5]],vec[[6]]\
,vec[[7]],vec[[8]],2]\>\"", ";"}]}], "Input",
 CellChangeTimes->{{3.5383948714318027`*^9, 3.538394893951269*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"evec", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.894"}], ",", 
     RowBox[{"-", "0.404"}], ",", "0.", ",", "0.", ",", "0.", ",", "0.193", 
     ",", "0.", ",", "0."}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5383949624752893`*^9, 3.538394977954464*^9}, {
  3.5384673050607977`*^9, 3.538467314180806*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", "3.0"}], ";"}]], "Input",
 CellChangeTimes->{{3.538331888911525*^9, 3.538331890488124*^9}, {
  3.5383332721236134`*^9, 3.538333358209091*^9}, {3.538372556610911*^9, 
  3.538372684298564*^9}, {3.538372774294757*^9, 3.5383727935021143`*^9}, {
  3.538380435266081*^9, 3.5383804358499737`*^9}, {3.538394561420013*^9, 
  3.538394565754445*^9}, {3.538394711436935*^9, 3.538394712492588*^9}, {
  3.538395089032036*^9, 3.538395092535534*^9}, {3.5383951245277033`*^9, 
  3.5383951282713623`*^9}, {3.538395211807301*^9, 3.538395211902952*^9}, {
  3.538395388596758*^9, 3.538395440076084*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0.0000000000001", ",", 
      RowBox[{"3.", "-", 
       FractionBox[
        SuperscriptBox["q", "2"], "4"]}], ",", "1.", ",", "0.0000000000001", 
      ",", "0.0000000000001", ",", "q", ",", 
      RowBox[{"-", "q"}], ",", 
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"1.", "+", 
         FractionBox[
          SuperscriptBox["q", "2"], "4"]}], ")"}]}]}], "}"}], "-", 
    RowBox[{"0.2", "*", "evec"}]}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.5381366020899467`*^9, {3.538328422257468*^9, 3.5383284518318768`*^9}, 
   3.538328887038381*^9, {3.538331754993125*^9, 3.5383317597446136`*^9}, {
   3.538331893617297*^9, 3.538331896097275*^9}, {3.538331961393141*^9, 
   3.538331965384636*^9}, {3.538380438091875*^9, 3.538380445343212*^9}, 
   3.5383946710003633`*^9, {3.538395044041169*^9, 3.538395050152924*^9}, 
   3.538395130768721*^9, 3.538395162688527*^9, {3.538395256440628*^9, 
   3.538395297883622*^9}, {3.538395364429879*^9, 3.53839537602993*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq0", "=", 
    RowBox[{"inteq", "[", 
     RowBox[{"1.", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "3", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "4", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "5", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "6", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "7", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DX", " ", "=", " ", "0.000001"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"vec0", "=", "vec"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "-=", "DX"}], " ", ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"eq1", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"1.", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "+=", 
       RowBox[{"2", "*", "DX"}]}], " ", ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"eq2", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"1.", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"mat", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"eq2", "-", "eq1"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "DX"}], ")"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "8"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<det = \>\"", ",", 
     RowBox[{"Det", "[", "mat", "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dvec", "=", 
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{"Transpose", "[", "mat", "]"}], "]"}], ".", "eq0"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vec", " ", "=", " ", 
    RowBox[{"vec", "-", "dvec"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<vec = \>\"", ",", "vec", ",", "\"\<  ->  eq = \>\"", ",", "eq0"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.538120490121634*^9, 3.538120518932563*^9}, {
   3.5381205558741503`*^9, 3.538120610837431*^9}, {3.5381206659362717`*^9, 
   3.538120712255209*^9}, {3.5383285846229553`*^9, 3.538328585388818*^9}, {
   3.538328684844769*^9, 3.5383286852597733`*^9}, 3.538328770081517*^9, {
   3.5383289405611877`*^9, 3.5383289561436033`*^9}, {3.538329024216524*^9, 
   3.538329027272518*^9}, {3.538329231307086*^9, 3.538329245530115*^9}, {
   3.53832928014611*^9, 3.5383292802257977`*^9}, {3.538331899292232*^9, 
   3.538331918317177*^9}, {3.5383320080930357`*^9, 3.53833201029294*^9}, {
   3.5383320534615726`*^9, 3.538332054173419*^9}, {3.538332091130785*^9, 
   3.538332091290278*^9}, {3.538332148467001*^9, 3.538332166530912*^9}, {
   3.538332763655594*^9, 3.538332763839275*^9}, 3.538332811566271*^9, {
   3.5383329603107758`*^9, 3.538333014609095*^9}, {3.538372704879333*^9, 
   3.538372748091798*^9}, {3.538380094711239*^9, 3.538380095245941*^9}, {
   3.538394672675757*^9, 3.538394672818479*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9897643809471938`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856263124529*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9897643850101298`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856263232237*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9897643956915677`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543856263337887*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(NDSolve \
:: ndsz\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5438562633399363`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"det = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "4.805331801628499`*^-6"}]}],
  SequenceForm["det = ", -4.805331801628499*^-6],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856264052997*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vec = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.4706553922797665`"}], ",", "0.7502359372083772`", ",", 
     "1.0394997387361868`", ",", "0.4258246400162299`", ",", 
     RowBox[{"-", "0.4502759237345561`"}], ",", "2.9461920446646213`", ",", 
     RowBox[{"-", "2.9065430485791444`"}], ",", 
     RowBox[{"-", "3.320312308886437`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"  ->  eq = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.006337245762672005`"}], ",", 
     RowBox[{"-", "0.03097675735925057`"}], ",", 
     RowBox[{"-", "0.15345467794602885`"}], ",", 
     RowBox[{"-", "0.04907029756919723`"}], ",", "0.053253431852161026`", ",", 
     RowBox[{"-", "0.0946258689582825`"}], ",", "0.398632105493431`", ",", 
     RowBox[{"-", "0.09932999692745463`"}]}], "}"}]}],
  SequenceForm[
  "vec = ", {-0.4706553922797665, 0.7502359372083772, 1.0394997387361868`, 
   0.4258246400162299, -0.4502759237345561, 
   2.9461920446646213`, -2.9065430485791444`, -3.320312308886437}, 
   "  ->  eq = ", {-0.006337245762672005, -0.03097675735925057, \
-0.15345467794602885`, -0.04907029756919723, 
   0.053253431852161026`, -0.0946258689582825, 
   0.398632105493431, -0.09932999692745463}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543856264054481*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.3829468917328384`"}], ",", "0.7375309427221062`", ",", 
     "0.9658412255786136`", ",", "0.3246514074125869`", ",", 
     RowBox[{"-", "0.28242066863611487`"}], ",", "3.00617950632583`", ",", 
     RowBox[{"-", "3.022120996980998`"}], ",", 
     RowBox[{"-", "3.255070720450515`"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538395488974235*^9, 3.538395494671344*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", "3.0"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nsol", "=", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"inteq", "[", 
      RowBox[{
      "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", 
       ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x3", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x4", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x5", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x6", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "6", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x7", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "7", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x8", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "8", "]"}], "]"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"inteq", "[", 
     RowBox[{
     "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", 
      ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", "nsol"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5383955289097357`*^9, 3.538395607280014*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x1", "\[Rule]", 
    RowBox[{"-", "0.3829522208868592`"}]}], ",", 
   RowBox[{"x2", "\[Rule]", "0.7375372169917298`"}], ",", 
   RowBox[{"x3", "\[Rule]", "0.9658402294292834`"}], ",", 
   RowBox[{"x4", "\[Rule]", "0.3246567152185265`"}], ",", 
   RowBox[{"x5", "\[Rule]", 
    RowBox[{"-", "0.2824245499524404`"}]}], ",", 
   RowBox[{"x6", "\[Rule]", "3.0061800930104337`"}], ",", 
   RowBox[{"x7", "\[Rule]", 
    RowBox[{"-", "3.0221220630599595`"}]}], ",", 
   RowBox[{"x8", "\[Rule]", 
    RowBox[{"-", "3.2550709023321325`"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.54385627951383*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.4350673427365734`*^-13"}], ",", 
   RowBox[{"-", "1.5101045414134262`*^-12"}], ",", "2.220446049250313`*^-16", 
   ",", "5.321187934725913`*^-12", ",", 
   RowBox[{"-", "1.7319479184152442`*^-14"}], ",", 
   RowBox[{"-", "2.03745076365891`*^-11"}], ",", 
   RowBox[{"-", "3.3306690738754696`*^-13"}], ",", 
   RowBox[{"-", "9.940945636111032`*^-13"}]}], "}"}]], "Print",
 CellChangeTimes->{3.5438562796133013`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"p", "[", "z", "]"}], "^", "2"}], "+", 
          RowBox[{
           RowBox[{"h", "[", "z", "]"}], "^", "2"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"p", "[", "z", "]"}], "^", "2"}], "+", 
          RowBox[{
           RowBox[{"h", "[", "z", "]"}], "^", "2"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.538395735376672*^9, 3.53839575583502*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVkXdczI8Dh1M5PyRaKkWaUrQU6at7p2iqrxZJQ6GtIYQGLTRcQ0VFOw3R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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVkXc41YsDxpVRPHKNhIwyS8pq2F6j7OSIjJSRkYtkNFAq2XSUVQjZI2VU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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0.01, 0.999}, {0., 0.38190904487572214`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.5438562812701073`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"p", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"p", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.538395645101112*^9, 3.5383956470443773`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk4ldvbB3BTOiRHTkohcShCRKkk31KJSKRBMmQoY8J+domKioyREqEU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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk0lV0bBnBTREiiRJkyJFQkSuUqeiWzNEqmUMYO5+EllZIGQ1EhUaYI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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0.01, 0.999}, {-0.3819058890797372, 0.005143927205763289}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.543856284543499*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"h", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"h", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.538395660340578*^9, 3.538395661228434*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k0VW8XB3AJlURkqCgZQ2RIorBNCZVMJSJTIWORIZLKFJrITCgRKlMZ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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk4VH8XAHAhRbKULFFkKUolRUhORZaKiLITypKtyF5Km9BuKUvWlCVZ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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0.01, 0.999}, {-0.1291880972905797, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.543856285629446*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"T", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"T", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5383956126740437`*^9, 3.538395637955501*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Xc4lvsfB3AlwpGVQlSISktJg355l3XIyOqIyCGRiIxSSJRSVhmpcFQe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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nc4l2sYB3AiyRElI9EgOTSEpkrfso59rFIyUiKHyEpFSZGyNyF7JyRR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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0.01, 0.999}, {0., 0.9999967671256771}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.543856286697406*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.53839567437263*^9, 3.538395675044032*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVxXk01AkAB/AZ12zbZpnaRWjWLPuiemPJRj2+P1coKeOllqltkHNK0SFH
CBXVWDS8jWSKxWxCr6QieVR2RxJCVBpjnMMv45ic7e4fn/cx8gtnH1ahUCi7
/vP/ty6zlqTRyXifE3y2oYVGJEzM8Mb0UmDpcVba30wjDu6peaeoToHhoauu
KmIaobvGrYaqPI8P9+rp9i9oBD/XL4YRmYr1z42Kn9TRiGiRYM4njI/frZde
PaygEaYDS/PDm67i3aI3syKTRlBVApS/rcvHFUG9OM+bRhQls5vK3pSiQBql
7duhQXjrfPYsV1Si0EJW9NhHg9D/2iTTSVKFZfs0ebxUnXjOCt/6fmsNRHxK
nZmfOuE5rX//Qt5T5I4d8jozokZYjmomMj0bwJM/8qoIVCNmJ8yr9OeewdF/
rZbHoCrhaUsv50Y24cQ9umXGUVWCYaLCMf1RjLL+EvenchUixbuy2bboJbjF
+CCIVCECxS5e+1e14ht6kVvHIpVwtLa71ub3GqszF0QqsVRi3G2NY6SwDRYP
ROhWpRJ7Siafdcy347ZvznhBIoUw5gfGyXa9gbD6i1YnlUI06j7ONkjrRPqc
VUTAd19g+On7tDWSLrSw72WsXL0MRx67z8LoLf446MuiMJfAtBJo0mN7EG7V
1jtisIiIlPCIgtZe/MS1FJUbLIAfbWq9V/M9jj+K9a/bNA//mtGufwI/YGDb
1jKx2RzUb116G1jSh17el1CGzWdc+qqf9vb4RzjnKsN2uCsxKaNq9RlIUMj6
QS1q5yxqBdpuUTUSLNWOdw/6zmBwzJg8HtKPO/YMJ87+abxQT2Y5rpYissxA
p/TXKWgq2gqKK6Vg+xqdZPEUuJtsEs87MICOHiduXegkakaC+I1LA3A67Tye
FP0JZ+mzW6avydBvI2BtXEfiuuSCR7LzIKS3B+MDGONgJq3ILh4YhJ3Rp5dT
DmNQE/N3bMgYwsUV3x4W2I3AXaZq7mAxjBsnvKsTOUNwb2gsN28dRriL1G0q
SYZSl9S8+JgRRLJH+3hJUvDybR9x9Udx0XStyKBIgsu5M06FTaNg2JvIM2z7
EMCZC3kSMQaRxYOuesde3CTldWHackxMKwwt+V2wNR04d6ZWDivjEO3gi+2w
sxKfWntwHN30XNeEK6+gVFtWy1oYh4TT8DCQ1YRVMZspvD8n8I5wEML8KVIb
fDZ2O5O4sJvF0YuoRIJPv0aBKwmhxS+KYFYloiZDJEE7Schy2Aeq5RUIZJzJ
Vu4hYRjuc9c7qAIOMTkUHQ4JW3udUubDO5i36OjYG0FiysS6fvGKCKE3d8W1
55PwOGUjPLLlJrg2b/blCknkx+UVUu8Ksb+VY+FfSCLbQ2unYKMQ25fDhhSl
JNY3bk94bFQApk+aJ/0+ie1ZoStpunno0X5h4ikmIY07KlCtz8LrEg+KXguJ
vRskTYyqTDShs+djKwmf3ext2/7KQNURWfqxThKXQxqr+szSkfm36ny6hIT8
uoryRvt5pB661LFvgMRzL+7m5tpkJCjp5YwhEqELQcOzxedw1IQZUC4nIdY1
46Z/jsXhmlK70yQJ+8b4lN7mKHC8ftaDgsQGF7N0Y+EJeI1WT2nMkBC4jsSE
njyGHYlES4uSxLn4Y5k+WcH4F6ryW9g=
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzXk4lAkAx/FxzlZLrpJr5yGz+5CWSIeN37t0KSz1RE2zdkkjmY1mOhy1
YYaiYtEokVCt6wljnzyVcbRUtpF1DJHQuI8ZryMGRdv+8X0+f35N/UMOHFem
UCjuX/rfe9esl/oj+Ljm0xVX20gloiZm2eMGsYiakY33NVAJX0/Ru+nHsbCV
L3sqi6nEOj1XkZIiDoSWudGPL6lEYoZ/JI0bj/UV3JKqaioRUShYYAQnIvvI
9x1PSqmExcDS4sjGG/DastuyNIVKKCkHKH75Jgt2SRtaM72pxAP+gfqHbQUQ
8F7oH5WoE976814l00IEbrEvqmCoE0Yr6Sk7peWgh85MXupXI15Yhzh0O4hg
QOX/bemvRnh9MHp0ObMGhkJz7/BRVcJuTDPazKsWST3iQ6UsVWJuwqbcaOE5
7njf1PYYUiG8HHVK/Lj10OQZb04+pULQ6MpMi/VikE6e7jUyZSLWW9jg+OA1
9Pru9gi4ygRLvOfgYY0mbGa1uUo+KREu25xut/g3I/WcRpHyBSVC7qrnws1p
QQO9GB0qSoRn/tRzyWIrxFoCeXY0hTBPZF0cdG9D+oklrXYlClG3riLNOKEd
jRxbTsCazzCZXJugJ30Dxddlyat0l+HCPtBra9qJm3KGNcVsCWb2Ak2dC2/x
7TZJ16jxJ3BiQzjZTV2YWLOjsMT4IxIjLLYd0uzGU+mVY9UbF3FMNPbmFasH
vHbXh2LLBajdu9rJyu/FZJhGMG37PK5+1UftPP0eXBqVvc9NgalBJa1eYynO
9ziohu2fQ6VA2zVMJEVklX7n0NFZDI2bk6eD+jAn9N3JPPwBL9X41i66/bAv
DtMvODIDzemW7DxhPwTUu2et2dMo49MvsX8ewBiV9Ks+OQXRaGBi3dIA9ojM
JngRk/hdZ27rh9uD2LT0fJPVNyTuSC978HcNoaeqOCaAJocZb0Va3sAQ7mQf
bZ5xHoeqOHHfhuRh/NHiHCRwGoXboIqNs+0I8uMZldHMYbjV1pXYNI3gh9BX
P83wBlGwJz7zUuQoqt3eDbF5/WBnOT71MxqD6WqTMuMHUlzLmN15v34MzOh7
y8mOvQhgLgRVccYRsL9F9sylC7mkrDpYWwbh1of2dolv4GgxEBNeKcOOIier
E1da4WQvPmfoK0fm/F/8qOv/QqG6rJr6UY5mV9oSy7oeGpGbKew/JyAP4k7A
pgbxtQyrjl0kTnkQ2oYcIaIYferZe0kkGErzgqyFCJsKkgbuJ/GdSbruE1kp
WLTwNIUnCXpad5BPYCmcI29S9JkkciscTcyfFGPRViI5xCHxroBNLF8vxMlc
94utWSRixuscQrbmwm97m09GDomz3asIlbIcHG5i2h67T2I2jz2SZpWD3cvB
w9MFJG5J0k0rTbNhxkjw0nlEYkXZiO/KdZl4q/2S7iUm4VglWE19lormfA+K
QSOJjE7u3vXlKahH+9v3TSQ2GofXOBUlo/y3waTQdhLjkSEdQ5ZJSPlHZTFJ
SqKQH+aW1xqH+F+vSnwGSJhz1t5qreQjSqFTQhsmoaP7mbGcF4NTdLOAEtmX
n4tfXNb8BRwXFTidJ0k0bTjzeqwhDMyDmwwwTeLGlMknu5wzODj2eEZ9lkRF
+l2tiLOh2BdNNDYqSGiLa9dEpJ7Af2wtW2Q=
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0.01, 0.999}, {0., 2.975958812300617}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.543856287532818*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"S", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"S", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5383956807250023`*^9, 3.538395683147913*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd13c81H8cB/DLbEjRUqQoNM1CxLuIZCZtqYzsVCpERgolv4ZKRiFnj5x9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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd13k4lFscB3BZ0iJbipBQKioKWSp+NZZESMtVlrrJmkqLCLfFWiG5QqKQ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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.966},
  PlotRange->{{0.01, 0.999}, {0.9660481530239607, 0.9999999996914339}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.543856288551393*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Interp", "[", 
    RowBox[{"val_", ",", "x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Return", "[", 
      RowBox[{
       RowBox[{"Interpolation", "[", 
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "]"}], "]"}], "[", "val", "]"}], 
      "]"}], ";"}], "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.543862196234021*^9, 3.543862204133967*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vec", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.3829468917328384`"}], ",", "0.7375309427221062`", ",", 
      "0.9658412255786136`", ",", "0.3246514074125869`", ",", 
      RowBox[{"-", "0.28242066863611487`"}], ",", "3.00617950632583`", ",", 
      RowBox[{"-", "3.022120996980998`"}], ",", 
      RowBox[{"-", "3.255070720450515`"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"veclist", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "veclist", "]"}], ">", "3"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vec", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Interp", "[", 
            RowBox[{"q", ",", 
             RowBox[{"veclist", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
             RowBox[{"veclist", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "2", ",", "ii"}], "]"}], "]"}]}], "]"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", "8"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<   Interp -> \>\"", ",", "vec"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"nsol", "=", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"inteq", "[", 
         RowBox[{
         "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", 
          "x5", ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x1", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x2", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x3", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x4", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x5", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x6", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "6", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x7", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "7", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x8", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "8", "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmp", "=", 
      RowBox[{
       RowBox[{"inteq", "[", 
        RowBox[{
        "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5",
          ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", 
       "nsol"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Norm", "[", "tmp", "]"}], "<", 
        RowBox[{"10", "^", 
         RowBox[{"-", "8"}]}]}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vec", "=", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5", ",", "x6", ",", 
            "x7", ",", "x8"}], "}"}], "/.", "nsol"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<q = \>\"", ",", "q", ",", "\"\< -> \>\"", ",", 
          RowBox[{"Norm", "[", "tmp", "]"}], ",", "\"\<\\n   \>\"", ",", 
          "vec", ",", "\"\<\\n\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"veclist", ",", 
          RowBox[{"{", 
           RowBox[{"q", ",", "vec"}], "}"}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Done\>\"", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"q", " ", "=", " ", "10."}], " ", ";"}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"q", ",", "3.0", ",", "3.2", ",", 
      RowBox[{"+", "0.01"}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5383955289097357`*^9, 3.538395607280014*^9}, {
   3.5383960750003557`*^9, 3.538396215074095*^9}, {3.538396289910667*^9, 
   3.5383963203716497`*^9}, {3.538396509259591*^9, 3.5383965728440866`*^9}, {
   3.5383966941917267`*^9, 3.538396697847146*^9}, 3.538396737895993*^9, {
   3.53839744436998*^9, 3.538397450144785*^9}, {3.543859011482007*^9, 
   3.543859019853387*^9}, {3.54385943160946*^9, 3.543859434520225*^9}, {
   3.5438594682683983`*^9, 3.543859468412384*^9}, {3.543859512900823*^9, 
   3.543859525812529*^9}, {3.5438619583810987`*^9, 3.5438620011365232`*^9}, {
   3.5438620782478237`*^9, 3.543862119990341*^9}, {3.543862209076723*^9, 
   3.543862240265071*^9}, {3.5438681200783167`*^9, 3.543868120302483*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "2.113849734391592`*^-11", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.3829522208868592`"}], ",", "0.7375372169917298`", ",", 
     "0.9658402294292834`", ",", "0.3246567152185265`", ",", 
     RowBox[{"-", "0.2824245499524404`"}], ",", "3.0061800930104337`", ",", 
     RowBox[{"-", "3.0221220630599595`"}], ",", 
     RowBox[{"-", "3.2550709023321325`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3., " -> ", 2.113849734391592*^-11, "\n   ", {-0.3829522208868592, 
   0.7375372169917298, 0.9658402294292834, 
   0.3246567152185265, -0.2824245499524404, 
   3.0061800930104337`, -3.0221220630599595`, -3.2550709023321325`}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868131300231*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9958422151488792`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543859539003598*^9, 3.543868098723528*^9, 
  3.543868132318534*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9958422151488792`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543859539003598*^9, 3.543868098723528*^9, 
  3.5438681324287367`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9958422151488792`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543859539003598*^9, 3.543868098723528*^9, 
  3.5438681325430927`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(NDSolve \
:: ndsz\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543859539003598*^9, 3.543868098723528*^9, 
  3.5438681325449047`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.01`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "1.477940061511083`*^-11", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.47716560223862864`"}], ",", "0.7155700278641293`", ",", 
     "0.947399462424566`", ",", "0.4076007294001283`", ",", 
     RowBox[{"-", "0.33925530250153124`"}], ",", "3.019192319336293`", ",", 
     RowBox[{"-", "3.043483274120927`"}], ",", 
     RowBox[{"-", "3.274551060727248`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.01, " -> ", 1.477940061511083*^-11, 
   "\n   ", {-0.47716560223862864`, 0.7155700278641293, 0.947399462424566, 
   0.4076007294001283, -0.33925530250153124`, 
   3.019192319336293, -3.043483274120927, -3.274551060727248}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868147729019*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.02`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "5.934126722003135`*^-12", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5588310621411724`"}], ",", "0.6932088424334473`", ",", 
     "0.9284753255962963`", ",", "0.48059287810706397`", ",", 
     RowBox[{"-", "0.382047397600752`"}], ",", "3.0320669379248195`", ",", 
     RowBox[{"-", "3.0647343439923036`"}], ",", 
     RowBox[{"-", "3.2942809021959683`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.02, " -> ", 5.934126722003135*^-12, "\n   ", {-0.5588310621411724,
    0.6932088424334473, 0.9284753255962963, 
   0.48059287810706397`, -0.382047397600752, 
   3.0320669379248195`, -3.0647343439923036`, -3.2942809021959683`}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868155904171*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.03`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "2.2535010931567217`*^-12", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6332732433395684`"}], ",", "0.6703988686016961`", ",", 
     "0.9089848329613974`", ",", "0.5478433705795582`", ",", 
     RowBox[{"-", "0.4150792941971084`"}], ",", "3.044817210631168`", ",", 
     RowBox[{"-", "3.085907968234219`"}], ",", 
     RowBox[{"-", "3.314333619534107`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.03, " -> ", 2.2535010931567217`*^-12, 
   "\n   ", {-0.6332732433395684, 0.6703988686016961, 0.9089848329613974, 
   0.5478433705795582, -0.4150792941971084, 
   3.044817210631168, -3.085907968234219, -3.314333619534107}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.5438681648953867`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Input value \[NoBreak]\\!\\({3.04`}\\)\[NoBreak] lies \
outside the range of data in the interpolating function. Extrapolation will \
be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\
\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellChangeTimes->{3.543859539003598*^9, 3.543868098723528*^9, 
  3.543868164922867*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Input value \[NoBreak]\\!\\({3.04`}\\)\[NoBreak] lies \
outside the range of data in the interpolating function. Extrapolation will \
be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\
\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellChangeTimes->{3.543859539003598*^9, 3.543868098723528*^9, 
  3.543868164925022*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Input value \[NoBreak]\\!\\({3.04`}\\)\[NoBreak] lies \
outside the range of data in the interpolating function. Extrapolation will \
be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\
\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellChangeTimes->{3.543859539003598*^9, 3.543868098723528*^9, 
  3.5438681649267883`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(InterpolatingFunction :: dmval\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543859539003598*^9, 3.543868098723528*^9, 
  3.54386816492857*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7058167885789086`"}], ",", "0.6470853142708839`", ",", 
     "0.8888449985367889`", ",", "0.6135624160578486`", ",", 
     RowBox[{"-", "0.442629451237613`"}], ",", "3.0574563993104955`", ",", 
     RowBox[{"-", "3.1070368424068078`"}], ",", 
     RowBox[{"-", "3.3347824055374815`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-0.7058167885789086, 0.6470853142708839, 
   0.8888449985367889, 0.6135624160578486, -0.442629451237613, 
   3.0574563993104955`, -3.1070368424068078`, -3.3347824055374815`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868164930275*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.04`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "1.0404464232497388`*^-11", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7031291230931236`"}], ",", "0.6470935691372721`", ",", 
     "0.8888758923306149`", ",", "0.6113329538135162`", ",", 
     RowBox[{"-", "0.4403536841805428`"}], ",", "3.0574518438921836`", ",", 
     RowBox[{"-", "3.1070127782481656`"}], ",", 
     RowBox[{"-", "3.3347383806660096`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.04, " -> ", 1.0404464232497388`*^-11, 
   "\n   ", {-0.7031291230931236, 0.6470935691372721, 0.8888758923306149, 
   0.6113329538135162, -0.4403536841805428, 
   3.0574518438921836`, -3.1070127782481656`, -3.3347383806660096`}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868170060197*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7710356786611322`"}], ",", "0.623246406808576`", ",", 
     "0.868096411514698`", ",", "0.6730423748048311`", ",", 
     RowBox[{"-", "0.4598732594409926`"}], ",", "3.0699795441447084`", ",", 
     RowBox[{"-", "3.128057405435631`"}], ",", 
     RowBox[{"-", "3.3555243535160173`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-0.7710356786611322, 0.623246406808576, 0.868096411514698,
    0.6730423748048311, -0.4598732594409926, 
   3.0699795441447084`, -3.128057405435631, -3.3555243535160173`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.5438681700629272`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.05`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "2.966486891113961`*^-11", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7701359741221`"}], ",", "0.6232167069964892`", ",", 
     "0.868047886578081`", ",", "0.6723140771695182`", ",", 
     RowBox[{"-", "0.45901634311921474`"}], ",", "3.069989300882435`", ",", 
     RowBox[{"-", "3.1280852934774632`"}], ",", 
     RowBox[{"-", "3.35554478132077`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.05, " -> ", 2.966486891113961*^-11, "\n   ", {-0.7701359741221, 
   0.6232167069964892, 0.868047886578081, 
   0.6723140771695182, -0.45901634311921474`, 
   3.069989300882435, -3.1280852934774632`, -3.35554478132077}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868174139101*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8360310691467717`"}], ",", "0.598692045135657`", ",", 
     "0.846400198577924`", ",", "0.7320391900081559`", ",", 
     RowBox[{"-", "0.47221304658128743`"}], ",", "3.082448044776494`", ",", 
     RowBox[{"-", "3.149162033365436`"}], ",", 
     RowBox[{"-", "3.376802417227486`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-0.8360310691467717, 0.598692045135657, 0.846400198577924,
    0.7320391900081559, -0.47221304658128743`, 
   3.082448044776494, -3.149162033365436, -3.376802417227486}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868174141748*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.06`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "3.198378716656182`*^-11", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8355984086695255`"}], ",", "0.5986593519096367`", ",", 
     "0.8463572030428985`", ",", "0.7316762082623693`", ",", 
     RowBox[{"-", "0.4717150686381041`"}], ",", "3.082457191095265`", ",", 
     RowBox[{"-", "3.149184275727464`"}], ",", 
     RowBox[{"-", "3.3768278685927484`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.06, " -> ", 3.198378716656182*^-11, "\n   ", {-0.8355984086695255,
    0.5986593519096367, 0.8463572030428985, 
   0.7316762082623693, -0.4717150686381041, 
   3.082457191095265, -3.149184275727464, -3.3768278685927484`}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868178234765*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9008210389784161`"}], ",", "0.5733125736070082`", ",", 
     "0.8236602290641744`", ",", "0.7903088147068639`", ",", 
     RowBox[{"-", "0.479097658362188`"}], ",", "3.0948831240240144`", ",", 
     RowBox[{"-", "3.170368486803516`"}], ",", 
     RowBox[{"-", "3.3986626895763017`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-0.9008210389784161, 0.5733125736070082, 
   0.8236602290641744, 0.7903088147068639, -0.479097658362188, 
   3.0948831240240144`, -3.170368486803516, -3.3986626895763017`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868178237514*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.07`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "3.02081616708772`*^-12", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9004021206382998`"}], ",", "0.5733183832396612`", ",", 
     "0.8236936378475181`", ",", "0.7898862127302508`", ",", 
     RowBox[{"-", "0.47864422814514657`"}], ",", "3.094881153663991`", ",", 
     RowBox[{"-", "3.170337811715476`"}], ",", 
     RowBox[{"-", "3.3986444026013563`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.07, " -> ", 3.02081616708772*^-12, "\n   ", {-0.9004021206382998, 
   0.5733183832396612, 0.8236936378475181, 
   0.7898862127302508, -0.47864422814514657`, 
   3.094881153663991, -3.170337811715476, -3.3986444026013563`}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868182385126*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9654328039313343`"}], ",", "0.547090680349505`", ",", 
     "0.7999469871143864`", ",", "0.8474109562113543`", ",", 
     RowBox[{"-", "0.4799981890482797`"}], ",", "3.107286827721931`", ",", 
     RowBox[{"-", "3.1915739881588117`"}], ",", 
     RowBox[{"-", "3.4210511434660087`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-0.9654328039313343, 0.547090680349505, 
   0.7999469871143864, 0.8474109562113543, -0.4799981890482797, 
   3.107286827721931, -3.1915739881588117`, -3.4210511434660087`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868182387766*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.08`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "7.601745035602465`*^-12", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9657154251847606`"}], ",", "0.546973480512456`", ",", 
     "0.7997701846475967`", ",", "0.8476514813389086`", ",", 
     RowBox[{"-", "0.47985949904345315`"}], ",", "3.1073205348765636`", ",", 
     RowBox[{"-", "3.19167622313553`"}], ",", 
     RowBox[{"-", "3.4204518483876614`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.08, " -> ", 7.601745035602465*^-12, "\n   ", {-0.9657154251847606,
    0.546973480512456, 0.7997701846475967, 
   0.8476514813389086, -0.47985949904345315`, 
   3.1073205348765636`, -3.19167622313553, -3.4204518483876614`}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.5438681855641623`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0327066374652338`"}], ",", "0.5194043232539188`", ",", 
     "0.7742998370987954`", ",", "0.905679404854078`", ",", 
     RowBox[{"-", "0.4754165587361341`"}], ",", "3.1198346810209325`", ",", 
     RowBox[{"-", "3.213329831681651`"}], ",", 
     RowBox[{"-", "3.4417076709927277`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-1.0327066374652338`, 0.5194043232539188, 
   0.7742998370987954, 0.905679404854078, -0.4754165587361341, 
   3.1198346810209325`, -3.213329831681651, -3.4417076709927277`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868185566695*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.09`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "1.257437858814017`*^-11", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0326442535516913`"}], ",", "0.5193482200357102`", ",", 
     "0.7742583486521682`", ",", "0.9055138905412342`", ",", 
     RowBox[{"-", "0.47505762474359925`"}], ",", "3.1198511514349128`", ",", 
     RowBox[{"-", "3.2133362927925737`"}], ",", 
     RowBox[{"-", "3.4437822140827707`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.09, " -> ", 1.257437858814017*^-11, 
   "\n   ", {-1.0326442535516913`, 0.5193482200357102, 0.7742583486521682, 
   0.9055138905412342, -0.47505762474359925`, 
   3.1198511514349128`, -3.2133362927925737`, -3.4437822140827707`}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868189658093*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1022945369818873`"}], ",", "0.49016617811710844`", ",", 
     "0.7468296350702621`", ",", "0.9640153167901299`", ",", 
     RowBox[{"-", "0.46393534865615993`"}], ",", "3.13254882004097`", ",", 
     RowBox[{"-", "3.2354548034915607`"}], ",", 
     RowBox[{"-", "3.4701675078177954`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-1.1022945369818873`, 0.49016617811710844`, 
   0.7468296350702621, 0.9640153167901299, -0.46393534865615993`, 
   3.13254882004097, -3.2354548034915607`, -3.4701675078177954`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868189660738*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.1`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "2.6461144530114004`*^-11", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.102730940207349`"}], ",", "0.4899828869052644`", ",", 
     "0.7466085381553761`", ",", "0.9641946646724482`", ",", 
     RowBox[{"-", "0.46347821227500763`"}], ",", "3.1326017296924715`", ",", 
     RowBox[{"-", "3.235560801411268`"}], ",", 
     RowBox[{"-", "3.468380937047331`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.1, " -> ", 2.6461144530114004`*^-11, "\n   ", {-1.102730940207349,
    0.4899828869052644, 0.7466085381553761, 
   0.9641946646724482, -0.46347821227500763`, 
   3.1326017296924715`, -3.235560801411268, -3.468380937047331}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868196774564*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1775178196199787`"}], ",", "0.45841776621696406`", ",", 
     "0.7162711614513685`", ",", "1.0244150280677604`", ",", 
     RowBox[{"-", "0.44436086866710256`"}], ",", "3.1457009960026707`", ",", 
     RowBox[{"-", "3.258592529716269`"}], ",", 
     RowBox[{"-", "3.4939934546419846`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-1.1775178196199787`, 0.45841776621696406`, 
   0.7162711614513685, 1.0244150280677604`, -0.44436086866710256`, 
   3.1457009960026707`, -3.258592529716269, -3.4939934546419846`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868196777239*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.11`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "1.4364728393316284`*^-11", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.178446792918264`"}], ",", "0.4580523014371517`", ",", 
     "0.7158430833744708`", ",", "1.0248295104199752`", ",", 
     RowBox[{"-", "0.44356197158427124`"}], ",", "3.14580793992385`", ",", 
     RowBox[{"-", "3.2587960283917026`"}], ",", 
     RowBox[{"-", "3.4936868755977355`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.11, " -> ", 1.4364728393316284`*^-11, 
   "\n   ", {-1.178446792918264, 0.4580523014371517, 0.7158430833744708, 
   1.0248295104199752`, -0.44356197158427124`, 
   3.14580793992385, -3.2587960283917026`, -3.4936868755977355`}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868199941394*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2622631194509795`"}], ",", "0.4227312839473997`", ",", 
     "0.6809843145266976`", ",", "1.0885541344712506`", ",", 
     RowBox[{"-", "0.41374961261798016`"}], ",", "3.15970545240366`", ",", 
     RowBox[{"-", "3.2834882531339713`"}], ",", 
     RowBox[{"-", "3.5191388880503816`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-1.2622631194509795`, 0.4227312839473997, 
   0.6809843145266976, 1.0885541344712506`, -0.41374961261798016`, 
   3.15970545240366, -3.2834882531339713`, -3.5191388880503816`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868199944104*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.12`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "1.8256595873845977`*^-11", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2646953236179115`"}], ",", "0.4218076189478686`", ",", 
     "0.6799123768988216`", ",", "1.0897015779845316`", ",", 
     RowBox[{"-", "0.4119116086711906`"}], ",", "3.1599803577085708`", ",", 
     RowBox[{"-", "3.2840022443359196`"}], ",", 
     RowBox[{"-", "3.5227640507163196`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.12, " -> ", 1.8256595873845977`*^-11, 
   "\n   ", {-1.2646953236179115`, 0.4218076189478686, 0.6799123768988216, 
   1.0897015779845316`, -0.4119116086711906, 
   3.1599803577085708`, -3.2840022443359196`, -3.5227640507163196`}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868203931548*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.366380044239752`"}], ",", "0.3794999947539179`", ",", 
     "0.6367668113178038`", ",", "1.1610940175668227`", ",", 
     RowBox[{"-", "0.36512982953557094`"}], ",", "3.1756295586261545`", ",", 
     RowBox[{"-", "3.312139719845957`"}], ",", 
     RowBox[{"-", "3.558676483385414`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-1.366380044239752, 0.3794999947539179, 
   0.6367668113178038, 1.1610940175668227`, -0.36512982953557094`, 
   3.1756295586261545`, -3.312139719845957, -3.558676483385414}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868203934249*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.13`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "1.7884725033040954`*^-12", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3763783389713515`"}], ",", "0.3757596815815864`", ",", 
     "0.6324343901268576`", ",", "1.1657445495739385`", ",", 
     RowBox[{"-", "0.3576657432589731`"}], ",", "3.176753264683709`", ",", 
     RowBox[{"-", "3.3142479967769587`"}], ",", 
     RowBox[{"-", "3.5593598788170286`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.13, " -> ", 1.7884725033040954`*^-12, 
   "\n   ", {-1.3763783389713515`, 0.3757596815815864, 0.6324343901268576, 
   1.1657445495739385`, -0.3576657432589731, 
   3.176753264683709, -3.3142479967769587`, -3.5593598788170286`}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.5438682078386183`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.5283976456436628`"}], ",", "0.3144193314824687`", ",", 
     "0.5670270944570005`", ",", "1.2598921073960296`", ",", 
     RowBox[{"-", "0.26996299507081795`"}], ",", "3.1977609424863416`", ",", 
     RowBox[{"-", "3.3526018332478644`"}], ",", 
     RowBox[{"-", "3.607221776313814`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-1.5283976456436628`, 0.3144193314824687, 
   0.5670270944570005, 1.2598921073960296`, -0.26996299507081795`, 
   3.1977609424863416`, -3.3526018332478644`, -3.607221776313814}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.5438682078414*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"FindRoot", "::", "lstol"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The line search decreased the step size to within \
tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find \
a sufficient decrease in the merit function. You may need more than \
\[NoBreak]\\!\\(MachinePrecision\\)\[NoBreak] digits of working precision to \
meet these tolerances. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindRoot/lstol\\\", ButtonNote -> \
\\\"FindRoot::lstol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543859539003598*^9, 3.543868098723528*^9, 
  3.543868217616829*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Done\"\>"], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868217714178*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.7356550502998997`"}], ",", "0.23229741079468888`", ",", 
     "0.4773084612876819`", ",", "1.3790779336586236`", ",", 
     RowBox[{"-", "0.1379419838299375`"}], ",", "3.2246376727535435`", ",", 
     RowBox[{"-", "3.402132301281676`"}], ",", 
     RowBox[{"-", "3.670097159620619`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-1.7356550502998997`, 0.23229741079468888`, 
   0.4773084612876819, 1.3790779336586236`, -0.1379419838299375, 
   3.2246376727535435`, -3.402132301281676, -3.670097159620619}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868217715893*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"FindRoot", "::", "lstol"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The line search decreased the step size to within \
tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find \
a sufficient decrease in the merit function. You may need more than \
\[NoBreak]\\!\\(MachinePrecision\\)\[NoBreak] digits of working precision to \
meet these tolerances. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindRoot/lstol\\\", ButtonNote -> \
\\\"FindRoot::lstol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543859539003598*^9, 3.543868098723528*^9, 
  3.5438682512256308`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Done\"\>"], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868251327076*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.0130523596051493`"}], ",", "0.12390476166240744`", ",", 
     "0.3568964620173196`", ",", "1.530235710569558`", ",", 
     "0.04925867074047602`", ",", "3.2590177371223925`", ",", 
     RowBox[{"-", "3.465907948411439`"}], ",", 
     RowBox[{"-", "3.7517334451513977`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-2.0130523596051493`, 0.12390476166240744`, 
   0.3568964620173196, 1.530235710569558, 0.04925867074047602, 
   3.2590177371223925`, -3.465907948411439, -3.7517334451513977`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543859537979561*^9, 3.543868097686903*^9, 
  3.543868251328809*^9}]
}, Open  ]],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.543859429996807*^9, 3.543860360083076*^9, 
  3.543868117364274*^9, 3.543868256739442*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["veclist"], "Input",
 CellChangeTimes->{{3.543858391140221*^9, 3.543858391787858*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.3829522208868592`"}], ",", "0.7375372169917298`", ",", 
       "0.9658402294292834`", ",", "0.3246567152185265`", ",", 
       RowBox[{"-", "0.2824245499524404`"}], ",", "3.0061800930104337`", ",", 
       RowBox[{"-", "3.0221220630599595`"}], ",", 
       RowBox[{"-", "3.2550709023321325`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.01`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.47716560223862864`"}], ",", "0.7155700278641293`", ",",
        "0.947399462424566`", ",", "0.4076007294001283`", ",", 
       RowBox[{"-", "0.33925530250153124`"}], ",", "3.019192319336293`", ",", 
       RowBox[{"-", "3.043483274120927`"}], ",", 
       RowBox[{"-", "3.274551060727248`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.02`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5588310621411724`"}], ",", "0.6932088424334473`", ",", 
       "0.9284753255962963`", ",", "0.48059287810706397`", ",", 
       RowBox[{"-", "0.382047397600752`"}], ",", "3.0320669379248195`", ",", 
       RowBox[{"-", "3.0647343439923036`"}], ",", 
       RowBox[{"-", "3.2942809021959683`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.03`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.6332732433395684`"}], ",", "0.6703988686016961`", ",", 
       "0.9089848329613974`", ",", "0.5478433705795582`", ",", 
       RowBox[{"-", "0.4150792941971084`"}], ",", "3.044817210631168`", ",", 
       RowBox[{"-", "3.085907968234219`"}], ",", 
       RowBox[{"-", "3.314333619534107`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.04`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7031291230931236`"}], ",", "0.6470935691372721`", ",", 
       "0.8888758923306149`", ",", "0.6113329538135162`", ",", 
       RowBox[{"-", "0.4403536841805428`"}], ",", "3.0574518438921836`", ",", 
       RowBox[{"-", "3.1070127782481656`"}], ",", 
       RowBox[{"-", "3.3347383806660096`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.05`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7701359741221`"}], ",", "0.6232167069964892`", ",", 
       "0.868047886578081`", ",", "0.6723140771695182`", ",", 
       RowBox[{"-", "0.45901634311921474`"}], ",", "3.069989300882435`", ",", 
       RowBox[{"-", "3.1280852934774632`"}], ",", 
       RowBox[{"-", "3.35554478132077`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.06`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8355984086695255`"}], ",", "0.5986593519096367`", ",", 
       "0.8463572030428985`", ",", "0.7316762082623693`", ",", 
       RowBox[{"-", "0.4717150686381041`"}], ",", "3.082457191095265`", ",", 
       RowBox[{"-", "3.149184275727464`"}], ",", 
       RowBox[{"-", "3.3768278685927484`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.07`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9004021206382998`"}], ",", "0.5733183832396612`", ",", 
       "0.8236936378475181`", ",", "0.7898862127302508`", ",", 
       RowBox[{"-", "0.47864422814514657`"}], ",", "3.094881153663991`", ",", 
       RowBox[{"-", "3.170337811715476`"}], ",", 
       RowBox[{"-", "3.3986444026013563`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.08`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9657154251847606`"}], ",", "0.546973480512456`", ",", 
       "0.7997701846475967`", ",", "0.8476514813389086`", ",", 
       RowBox[{"-", "0.47985949904345315`"}], ",", "3.1073205348765636`", ",", 
       RowBox[{"-", "3.19167622313553`"}], ",", 
       RowBox[{"-", "3.4204518483876614`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.09`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.0326442535516913`"}], ",", "0.5193482200357102`", ",", 
       "0.7742583486521682`", ",", "0.9055138905412342`", ",", 
       RowBox[{"-", "0.47505762474359925`"}], ",", "3.1198511514349128`", ",", 
       RowBox[{"-", "3.2133362927925737`"}], ",", 
       RowBox[{"-", "3.4437822140827707`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.102730940207349`"}], ",", "0.4899828869052644`", ",", 
       "0.7466085381553761`", ",", "0.9641946646724482`", ",", 
       RowBox[{"-", "0.46347821227500763`"}], ",", "3.1326017296924715`", ",", 
       RowBox[{"-", "3.235560801411268`"}], ",", 
       RowBox[{"-", "3.468380937047331`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.11`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.178446792918264`"}], ",", "0.4580523014371517`", ",", 
       "0.7158430833744708`", ",", "1.0248295104199752`", ",", 
       RowBox[{"-", "0.44356197158427124`"}], ",", "3.14580793992385`", ",", 
       RowBox[{"-", "3.2587960283917026`"}], ",", 
       RowBox[{"-", "3.4936868755977355`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.12`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.2646953236179115`"}], ",", "0.4218076189478686`", ",", 
       "0.6799123768988216`", ",", "1.0897015779845316`", ",", 
       RowBox[{"-", "0.4119116086711906`"}], ",", "3.1599803577085708`", ",", 
       RowBox[{"-", "3.2840022443359196`"}], ",", 
       RowBox[{"-", "3.5227640507163196`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.13`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.3763783389713515`"}], ",", "0.3757596815815864`", ",", 
       "0.6324343901268576`", ",", "1.1657445495739385`", ",", 
       RowBox[{"-", "0.3576657432589731`"}], ",", "3.176753264683709`", ",", 
       RowBox[{"-", "3.3142479967769587`"}], ",", 
       RowBox[{"-", "3.5593598788170286`"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.543858392209159*^9, 3.543868259269848*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"veclist", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3.`", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.3829522208868592`"}], ",", "0.7375372169917298`", 
          ",", "0.9658402294292834`", ",", "0.3246567152185265`", ",", 
          RowBox[{"-", "0.2824245499524404`"}], ",", "3.0061800930104337`", 
          ",", 
          RowBox[{"-", "3.0221220630599595`"}], ",", 
          RowBox[{"-", "3.2550709023321325`"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.01`", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.47716560223862864`"}], ",", "0.7155700278641293`", 
          ",", "0.947399462424566`", ",", "0.4076007294001283`", ",", 
          RowBox[{"-", "0.33925530250153124`"}], ",", "3.019192319336293`", 
          ",", 
          RowBox[{"-", "3.043483274120927`"}], ",", 
          RowBox[{"-", "3.274551060727248`"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.02`", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5588310621411724`"}], ",", "0.6932088424334473`", 
          ",", "0.9284753255962963`", ",", "0.48059287810706397`", ",", 
          RowBox[{"-", "0.382047397600752`"}], ",", "3.0320669379248195`", 
          ",", 
          RowBox[{"-", "3.0647343439923036`"}], ",", 
          RowBox[{"-", "3.2942809021959683`"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.03`", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.6332732433395684`"}], ",", "0.6703988686016961`", 
          ",", "0.9089848329613974`", ",", "0.5478433705795582`", ",", 
          RowBox[{"-", "0.4150792941971084`"}], ",", "3.044817210631168`", 
          ",", 
          RowBox[{"-", "3.085907968234219`"}], ",", 
          RowBox[{"-", "3.314333619534107`"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.04`", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.7031291230931236`"}], ",", "0.6470935691372721`", 
          ",", "0.8888758923306149`", ",", "0.6113329538135162`", ",", 
          RowBox[{"-", "0.4403536841805428`"}], ",", "3.0574518438921836`", 
          ",", 
          RowBox[{"-", "3.1070127782481656`"}], ",", 
          RowBox[{"-", "3.3347383806660096`"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.05`", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.7701359741221`"}], ",", "0.6232167069964892`", ",", 
          "0.868047886578081`", ",", "0.6723140771695182`", ",", 
          RowBox[{"-", "0.45901634311921474`"}], ",", "3.069989300882435`", 
          ",", 
          RowBox[{"-", "3.1280852934774632`"}], ",", 
          RowBox[{"-", "3.35554478132077`"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.06`", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.8355984086695255`"}], ",", "0.5986593519096367`", 
          ",", "0.8463572030428985`", ",", "0.7316762082623693`", ",", 
          RowBox[{"-", "0.4717150686381041`"}], ",", "3.082457191095265`", 
          ",", 
          RowBox[{"-", "3.149184275727464`"}], ",", 
          RowBox[{"-", "3.3768278685927484`"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.07`", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.9004021206382998`"}], ",", "0.5733183832396612`", 
          ",", "0.8236936378475181`", ",", "0.7898862127302508`", ",", 
          RowBox[{"-", "0.47864422814514657`"}], ",", "3.094881153663991`", 
          ",", 
          RowBox[{"-", "3.170337811715476`"}], ",", 
          RowBox[{"-", "3.3986444026013563`"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.08`", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.9657154251847606`"}], ",", "0.546973480512456`", 
          ",", "0.7997701846475967`", ",", "0.8476514813389086`", ",", 
          RowBox[{"-", "0.47985949904345315`"}], ",", "3.1073205348765636`", 
          ",", 
          RowBox[{"-", "3.19167622313553`"}], ",", 
          RowBox[{"-", "3.4204518483876614`"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.09`", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.0326442535516913`"}], ",", "0.5193482200357102`", 
          ",", "0.7742583486521682`", ",", "0.9055138905412342`", ",", 
          RowBox[{"-", "0.47505762474359925`"}], ",", "3.1198511514349128`", 
          ",", 
          RowBox[{"-", "3.2133362927925737`"}], ",", 
          RowBox[{"-", "3.4437822140827707`"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.1`", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.102730940207349`"}], ",", "0.4899828869052644`", 
          ",", "0.7466085381553761`", ",", "0.9641946646724482`", ",", 
          RowBox[{"-", "0.46347821227500763`"}], ",", "3.1326017296924715`", 
          ",", 
          RowBox[{"-", "3.235560801411268`"}], ",", 
          RowBox[{"-", "3.468380937047331`"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.11`", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.178446792918264`"}], ",", "0.4580523014371517`", 
          ",", "0.7158430833744708`", ",", "1.0248295104199752`", ",", 
          RowBox[{"-", "0.44356197158427124`"}], ",", "3.14580793992385`", 
          ",", 
          RowBox[{"-", "3.2587960283917026`"}], ",", 
          RowBox[{"-", "3.4936868755977355`"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.2646953236179115`"}], ",", "0.4218076189478686`", 
          ",", "0.6799123768988216`", ",", "1.0897015779845316`", ",", 
          RowBox[{"-", "0.4119116086711906`"}], ",", "3.1599803577085708`", 
          ",", 
          RowBox[{"-", "3.2840022443359196`"}], ",", 
          RowBox[{"-", "3.5227640507163196`"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.13`", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.3763783389713515`"}], ",", "0.3757596815815864`", 
          ",", "0.6324343901268576`", ",", "1.1657445495739385`", ",", 
          RowBox[{"-", "0.3576657432589731`"}], ",", "3.176753264683709`", 
          ",", 
          RowBox[{"-", "3.3142479967769587`"}], ",", 
          RowBox[{"-", "3.5593598788170286`"}]}], "}"}]}], "}"}]}], "}"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "veclist", "]"}], ">", "3"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vec", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Interp", "[", 
            RowBox[{"q", ",", 
             RowBox[{"veclist", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
             RowBox[{"veclist", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "2", ",", "ii"}], "]"}], "]"}]}], "]"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", "8"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<   Interp -> \>\"", ",", "vec"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"nsol", "=", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"inteq", "[", 
         RowBox[{
         "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", 
          "x5", ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x1", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x2", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x3", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x4", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x5", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x6", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "6", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x7", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "7", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x8", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "8", "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmp", "=", 
      RowBox[{
       RowBox[{"inteq", "[", 
        RowBox[{
        "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5",
          ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", 
       "nsol"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Norm", "[", "tmp", "]"}], "<", 
        RowBox[{"10", "^", 
         RowBox[{"-", "8"}]}]}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vec", "=", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5", ",", "x6", ",", 
            "x7", ",", "x8"}], "}"}], "/.", "nsol"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<q = \>\"", ",", "q", ",", "\"\< -> \>\"", ",", 
          RowBox[{"Norm", "[", "tmp", "]"}], ",", "\"\<\\n   \>\"", ",", 
          "vec", ",", "\"\<\\n\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"veclist", ",", 
          RowBox[{"{", 
           RowBox[{"q", ",", "vec"}], "}"}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Done\>\"", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"q", " ", "=", " ", "10."}], " ", ";"}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"q", ",", "3.131", ",", "3.2", ",", 
      RowBox[{"+", "0.001"}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5383955289097357`*^9, 3.538395607280014*^9}, {
   3.5383960750003557`*^9, 3.538396215074095*^9}, {3.538396289910667*^9, 
   3.5383963203716497`*^9}, {3.538396509259591*^9, 3.5383965728440866`*^9}, {
   3.5383966941917267`*^9, 3.538396697847146*^9}, 3.538396737895993*^9, {
   3.53839744436998*^9, 3.538397450144785*^9}, {3.543859011482007*^9, 
   3.543859019853387*^9}, {3.54385943160946*^9, 3.543859434520225*^9}, {
   3.5438594682683983`*^9, 3.543859468412384*^9}, {3.543859512900823*^9, 
   3.543859525812529*^9}, {3.5438619583810987`*^9, 3.5438620011365232`*^9}, {
   3.5438620782478237`*^9, 3.543862119990341*^9}, {3.543862209076723*^9, 
   3.543862240265071*^9}, {3.5438681200783167`*^9, 3.543868120302483*^9}, {
   3.5438683904790382`*^9, 3.543868402155263*^9}, {3.5438684509221992`*^9, 
   3.543868452741189*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Input value \[NoBreak]\\!\\({3.131`}\\)\[NoBreak] lies \
outside the range of data in the interpolating function. Extrapolation will \
be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\
\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellChangeTimes->{3.543868404473424*^9, 3.543868455136918*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Input value \[NoBreak]\\!\\({3.131`}\\)\[NoBreak] lies \
outside the range of data in the interpolating function. Extrapolation will \
be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\
\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellChangeTimes->{3.543868404473424*^9, 3.543868455139638*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Input value \[NoBreak]\\!\\({3.131`}\\)\[NoBreak] lies \
outside the range of data in the interpolating function. Extrapolation will \
be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\
\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellChangeTimes->{3.543868404473424*^9, 3.543868455141553*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(InterpolatingFunction :: dmval\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543868404473424*^9, 3.543868455143579*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3895192567192582`"}], ",", "0.3704043762492741`", ",", 
     "0.6268057829322038`", ",", "1.1742301932192467`", ",", 
     RowBox[{"-", "0.3505802409396428`"}], ",", "3.178636502129723`", ",", 
     RowBox[{"-", "3.31766788560841`"}], ",", 
     RowBox[{"-", "3.563577263073053`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-1.3895192567192582`, 0.3704043762492741, 
   0.6268057829322038, 1.1742301932192467`, -0.3505802409396428, 
   3.178636502129723, -3.31766788560841, -3.563577263073053}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.543868455145606*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.131`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "2.8489783450640076`*^-11", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3908836354580998`"}], ",", "0.36989612317194615`", ",", 
     "0.6262166234108176`", ",", "1.1748961521156738`", ",", 
     RowBox[{"-", "0.34960848856669274`"}], ",", "3.1787893612990503`", ",", 
     RowBox[{"-", "3.317958201556557`"}], ",", 
     RowBox[{"-", "3.5638105570494267`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.131, " -> ", 2.8489783450640076`*^-11, 
   "\n   ", {-1.3908836354580998`, 0.36989612317194615`, 0.6262166234108176, 
   1.1748961521156738`, -0.34960848856669274`, 
   3.1787893612990503`, -3.317958201556557, -3.5638105570494267`}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.543868460243985*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4061970191615134`"}], ",", "0.3637289363121709`", ",", 
     "0.6196448502853725`", ",", "1.1844260081723514`", ",", 
     RowBox[{"-", "0.34092816013124777`"}], ",", "3.180913113952683`", ",", 
     RowBox[{"-", "3.3218355031377436`"}], ",", 
     RowBox[{"-", "3.5684442988140206`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-1.4061970191615134`, 0.3637289363121709, 
   0.6196448502853725, 1.1844260081723514`, -0.34092816013124777`, 
   3.180913113952683, -3.3218355031377436`, -3.5684442988140206`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.54386846024679*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.1319999999999997`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "3.0099263438992265`*^-12", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4064629830625373`"}], ",", "0.3636254599823502`", ",", 
     "0.6195317435596671`", ",", "1.1845148237910068`", ",", 
     RowBox[{"-", "0.34068053451365315`"}], ",", "3.180948380287802`", ",", 
     RowBox[{"-", "3.32188954243115`"}], ",", 
     RowBox[{"-", "3.5685530842614135`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.1319999999999997`, " -> ", 3.0099263438992265`*^-12, 
   "\n   ", {-1.4064629830625373`, 0.3636254599823502, 0.6195317435596671, 
   1.1845148237910068`, -0.34068053451365315`, 
   3.180948380287802, -3.32188954243115, -3.5685530842614135`}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.543868463430099*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.423233212975386`"}], ",", "0.3569031323938556`", ",", 
     "0.6123297890186669`", ",", "1.1946469998204827`", ",", 
     RowBox[{"-", "0.3307838729938036`"}], ",", "3.1832447428834154`", ",", 
     RowBox[{"-", "3.326066138445599`"}], ",", 
     RowBox[{"-", "3.573624463815053`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-1.423233212975386, 0.3569031323938556, 
   0.6123297890186669, 1.1946469998204827`, -0.3307838729938036, 
   3.1832447428834154`, -3.326066138445599, -3.573624463815053}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.543868463432729*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"FindRoot", "::", "lstol"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The line search decreased the step size to within \
tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find \
a sufficient decrease in the merit function. You may need more than \
\[NoBreak]\\!\\(MachinePrecision\\)\[NoBreak] digits of working precision to \
meet these tolerances. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindRoot/lstol\\\", ButtonNote -> \
\\\"FindRoot::lstol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543868404473424*^9, 3.543868473115396*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Done\"\>"], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.543868473219139*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4413111563873764`"}], ",", "0.3496845807875162`", ",", 
     "0.604560798233074`", ",", "1.2053391154246513`", ",", 
     RowBox[{"-", "0.31982049590108813`"}], ",", "3.185692870319343`", ",", 
     RowBox[{"-", "3.3305121086447693`"}], ",", 
     RowBox[{"-", "3.579061699072412`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-1.4413111563873764`, 0.3496845807875162, 
   0.604560798233074, 1.2053391154246513`, -0.31982049590108813`, 
   3.185692870319343, -3.3305121086447693`, -3.579061699072412}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.54386847322089*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"FindRoot", "::", "lstol"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The line search decreased the step size to within \
tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find \
a sufficient decrease in the merit function. You may need more than \
\[NoBreak]\\!\\(MachinePrecision\\)\[NoBreak] digits of working precision to \
meet these tolerances. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindRoot/lstol\\\", ButtonNote -> \
\\\"FindRoot::lstol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543868404473424*^9, 3.543868491785343*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.134`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "1.8593548098903412`*^-9", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4437313773047735`"}], ",", "0.34880106140499667`", ",", 
     "0.6035113589189115`", ",", "1.2066983296260254`", ",", 
     RowBox[{"-", "0.31836577492790635`"}], ",", "3.18594408519273`", ",", 
     RowBox[{"-", "3.3310420359624566`"}], ",", 
     RowBox[{"-", "3.579514428081354`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.134, " -> ", 1.8593548098903412`*^-9, 
   "\n   ", {-1.4437313773047735`, 0.34880106140499667`, 0.6035113589189115, 
   1.2066983296260254`, -0.31836577492790635`, 
   3.18594408519273, -3.3310420359624566`, -3.579514428081354}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.543868491887884*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4668641967827065`"}], ",", "0.3397164470880969`", ",", 
     "0.5935512113627502`", ",", "1.220035641327483`", ",", 
     RowBox[{"-", "0.3040555926965118`"}], ",", "3.188935221012501`", ",", 
     RowBox[{"-", "3.3365763903677372`"}], ",", 
     RowBox[{"-", "3.5860336159179047`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-1.4668641967827065`, 0.3397164470880969, 
   0.5935512113627502, 1.220035641327483, -0.3040555926965118, 
   3.188935221012501, -3.3365763903677372`, -3.5860336159179047`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.543868491889752*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.135`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "3.634298799421547`*^-10", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.467905395934593`"}], ",", "0.3393158299095613`", ",", 
     "0.5931078079313106`", ",", "1.220433610712333`", ",", 
     RowBox[{"-", "0.303167987165149`"}], ",", "3.189068841303798`", ",", 
     RowBox[{"-", "3.336792529577479`"}], ",", 
     RowBox[{"-", "3.5868007517223104`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.135, " -> ", 3.634298799421547*^-10, "\n   ", {-1.467905395934593,
    0.3393158299095613, 0.5931078079313106, 
   1.220433610712333, -0.303167987165149, 
   3.189068841303798, -3.336792529577479, -3.5868007517223104`}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.543868501207309*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4974292768982342`"}], ",", "0.32782757953783187`", ",", 
     "0.5803966537002271`", ",", "1.2367115418622587`", ",", 
     RowBox[{"-", "0.28406927260243114`"}], ",", "3.1928035799838645`", ",", 
     RowBox[{"-", "3.3436787483976222`"}], ",", 
     RowBox[{"-", "3.5960025145392613`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-1.4974292768982342`, 0.32782757953783187`, 
   0.5803966537002271, 1.2367115418622587`, -0.28406927260243114`, 
   3.1928035799838645`, -3.3436787483976222`, -3.5960025145392613`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.543868501209877*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9978788308377979`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543868404473424*^9, 3.5438685012562733`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9978788308377979`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543868404473424*^9, 3.543868501354454*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NDSolve", "::", "ndsz"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"At \[NoBreak]\\!\\(z\\)\[NoBreak] == \
\[NoBreak]\\!\\(0.9978788308377979`\\)\[NoBreak], step size is effectively \
zero; singularity or stiff system suspected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/ndsz\\\", ButtonNote -> \
\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543868404473424*^9, 3.5438685014538107`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(NDSolve \
:: ndsz\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543868404473424*^9, 3.54386850145557*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"q = \"\>", "\[InvisibleSpace]", "3.1359999999999997`", 
   "\[InvisibleSpace]", "\<\" -> \"\>", "\[InvisibleSpace]", 
   "1.3523930789134378`*^-11", "\[InvisibleSpace]", "\<\"\\n   \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.5029133122556864`"}], ",", "0.3257810936679414`", ",", 
     "0.5780373621619871`", ",", "1.2393850565030275`", ",", 
     RowBox[{"-", "0.2801980722807847`"}], ",", "3.193428980447547`", ",", 
     RowBox[{"-", "3.3448559635582655`"}], ",", 
     RowBox[{"-", "3.5968481527392187`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\\n\"\>"}],
  SequenceForm[
  "q = ", 3.1359999999999997`, " -> ", 1.3523930789134378`*^-11, 
   "\n   ", {-1.5029133122556864`, 0.3257810936679414, 0.5780373621619871, 
   1.2393850565030275`, -0.2801980722807847, 
   3.193428980447547, -3.3448559635582655`, -3.5968481527392187`}, "\n\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.5438685085470943`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.5541106387821566`"}], ",", "0.30619624022387887`", ",", 
     "0.5559965298582616`", ",", "1.2661430264419986`", ",", 
     RowBox[{"-", "0.24564713891855167`"}], ",", "3.1996375880691854`", ",", 
     RowBox[{"-", "3.3563799197544535`"}], ",", 
     RowBox[{"-", "3.610824613298549`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-1.5541106387821566`, 0.30619624022387887`, 
   0.5559965298582616, 1.2661430264419986`, -0.24564713891855167`, 
   3.1996375880691854`, -3.3563799197544535`, -3.610824613298549}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.543868508548305*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"FindRoot", "::", "lstol"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The line search decreased the step size to within \
tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find \
a sufficient decrease in the merit function. You may need more than \
\[NoBreak]\\!\\(MachinePrecision\\)\[NoBreak] digits of working precision to \
meet these tolerances. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindRoot/lstol\\\", ButtonNote -> \
\\\"FindRoot::lstol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543868404473424*^9, 3.54386854861098*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(FindRoot \
:: lstol\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.543868404473424*^9, 3.5438685486131067`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Done\"\>"], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.5438685487148314`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Interp -> \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.626852888028144`"}], ",", "0.27856065712110123`", ",", 
     "0.5246818192674386`", ",", "1.3032978799731554`", ",", 
     RowBox[{"-", "0.19570629572216192`"}], ",", "3.208307749613926`", ",", 
     RowBox[{"-", "3.372511980015689`"}], ",", 
     RowBox[{"-", "3.6298981155667818`"}]}], "}"}]}],
  SequenceForm[
  "   Interp -> ", {-1.626852888028144, 0.27856065712110123`, 
   0.5246818192674386, 1.3032978799731554`, -0.19570629572216192`, 
   3.208307749613926, -3.372511980015689, -3.6298981155667818`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.543868548716538*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Error 2 \"\>", "\[InvisibleSpace]", "0.9939018653904353`"}],
  SequenceForm["Error 2 ", 0.9939018653904353],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.543868553808393*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Error 2 \"\>", "\[InvisibleSpace]", "0.981666651530488`"}],
  SequenceForm["Error 2 ", 0.981666651530488],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.5438685677285223`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Error 2 \"\>", "\[InvisibleSpace]", "0.9696006711869649`"}],
  SequenceForm["Error 2 ", 0.9696006711869649],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.543868569678494*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Error 1 \"\>", "\[InvisibleSpace]", "0.01`"}],
  SequenceForm["Error 1 ", 0.01],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.543868574705845*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Error 2 \"\>", "\[InvisibleSpace]", "0.9756459114007427`"}],
  SequenceForm["Error 2 ", 0.9756459114007427],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.543868578636104*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Error 2 \"\>", "\[InvisibleSpace]", "0.9979848892216345`"}],
  SequenceForm["Error 2 ", 0.9979848892216345],
  Editable->False]], "Print",
 CellChangeTimes->{3.543868404480262*^9, 3.5438685804617968`*^9}]
}, Open  ]],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.543868446793832*^9, 3.543868582861027*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["veclist"], "Input",
 CellChangeTimes->{{3.543868414431712*^9, 3.543868415661662*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.3829522208868592`"}], ",", "0.7375372169917298`", ",", 
       "0.9658402294292834`", ",", "0.3246567152185265`", ",", 
       RowBox[{"-", "0.2824245499524404`"}], ",", "3.0061800930104337`", ",", 
       RowBox[{"-", "3.0221220630599595`"}], ",", 
       RowBox[{"-", "3.2550709023321325`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.01`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.47716560223862864`"}], ",", "0.7155700278641293`", ",",
        "0.947399462424566`", ",", "0.4076007294001283`", ",", 
       RowBox[{"-", "0.33925530250153124`"}], ",", "3.019192319336293`", ",", 
       RowBox[{"-", "3.043483274120927`"}], ",", 
       RowBox[{"-", "3.274551060727248`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.02`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5588310621411724`"}], ",", "0.6932088424334473`", ",", 
       "0.9284753255962963`", ",", "0.48059287810706397`", ",", 
       RowBox[{"-", "0.382047397600752`"}], ",", "3.0320669379248195`", ",", 
       RowBox[{"-", "3.0647343439923036`"}], ",", 
       RowBox[{"-", "3.2942809021959683`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.03`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.6332732433395684`"}], ",", "0.6703988686016961`", ",", 
       "0.9089848329613974`", ",", "0.5478433705795582`", ",", 
       RowBox[{"-", "0.4150792941971084`"}], ",", "3.044817210631168`", ",", 
       RowBox[{"-", "3.085907968234219`"}], ",", 
       RowBox[{"-", "3.314333619534107`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.04`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7031291230931236`"}], ",", "0.6470935691372721`", ",", 
       "0.8888758923306149`", ",", "0.6113329538135162`", ",", 
       RowBox[{"-", "0.4403536841805428`"}], ",", "3.0574518438921836`", ",", 
       RowBox[{"-", "3.1070127782481656`"}], ",", 
       RowBox[{"-", "3.3347383806660096`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.05`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7701359741221`"}], ",", "0.6232167069964892`", ",", 
       "0.868047886578081`", ",", "0.6723140771695182`", ",", 
       RowBox[{"-", "0.45901634311921474`"}], ",", "3.069989300882435`", ",", 
       RowBox[{"-", "3.1280852934774632`"}], ",", 
       RowBox[{"-", "3.35554478132077`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.06`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8355984086695255`"}], ",", "0.5986593519096367`", ",", 
       "0.8463572030428985`", ",", "0.7316762082623693`", ",", 
       RowBox[{"-", "0.4717150686381041`"}], ",", "3.082457191095265`", ",", 
       RowBox[{"-", "3.149184275727464`"}], ",", 
       RowBox[{"-", "3.3768278685927484`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.07`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9004021206382998`"}], ",", "0.5733183832396612`", ",", 
       "0.8236936378475181`", ",", "0.7898862127302508`", ",", 
       RowBox[{"-", "0.47864422814514657`"}], ",", "3.094881153663991`", ",", 
       RowBox[{"-", "3.170337811715476`"}], ",", 
       RowBox[{"-", "3.3986444026013563`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.08`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9657154251847606`"}], ",", "0.546973480512456`", ",", 
       "0.7997701846475967`", ",", "0.8476514813389086`", ",", 
       RowBox[{"-", "0.47985949904345315`"}], ",", "3.1073205348765636`", ",", 
       RowBox[{"-", "3.19167622313553`"}], ",", 
       RowBox[{"-", "3.4204518483876614`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.09`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.0326442535516913`"}], ",", "0.5193482200357102`", ",", 
       "0.7742583486521682`", ",", "0.9055138905412342`", ",", 
       RowBox[{"-", "0.47505762474359925`"}], ",", "3.1198511514349128`", ",", 
       RowBox[{"-", "3.2133362927925737`"}], ",", 
       RowBox[{"-", "3.4437822140827707`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.102730940207349`"}], ",", "0.4899828869052644`", ",", 
       "0.7466085381553761`", ",", "0.9641946646724482`", ",", 
       RowBox[{"-", "0.46347821227500763`"}], ",", "3.1326017296924715`", ",", 
       RowBox[{"-", "3.235560801411268`"}], ",", 
       RowBox[{"-", "3.468380937047331`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.11`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.178446792918264`"}], ",", "0.4580523014371517`", ",", 
       "0.7158430833744708`", ",", "1.0248295104199752`", ",", 
       RowBox[{"-", "0.44356197158427124`"}], ",", "3.14580793992385`", ",", 
       RowBox[{"-", "3.2587960283917026`"}], ",", 
       RowBox[{"-", "3.4936868755977355`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.12`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.2646953236179115`"}], ",", "0.4218076189478686`", ",", 
       "0.6799123768988216`", ",", "1.0897015779845316`", ",", 
       RowBox[{"-", "0.4119116086711906`"}], ",", "3.1599803577085708`", ",", 
       RowBox[{"-", "3.2840022443359196`"}], ",", 
       RowBox[{"-", "3.5227640507163196`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.13`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.3763783389713515`"}], ",", "0.3757596815815864`", ",", 
       "0.6324343901268576`", ",", "1.1657445495739385`", ",", 
       RowBox[{"-", "0.3576657432589731`"}], ",", "3.176753264683709`", ",", 
       RowBox[{"-", "3.3142479967769587`"}], ",", 
       RowBox[{"-", "3.5593598788170286`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.131`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.3908836354580998`"}], ",", "0.36989612317194615`", ",",
        "0.6262166234108176`", ",", "1.1748961521156738`", ",", 
       RowBox[{"-", "0.34960848856669274`"}], ",", "3.1787893612990503`", ",", 
       RowBox[{"-", "3.317958201556557`"}], ",", 
       RowBox[{"-", "3.5638105570494267`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1319999999999997`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.4064629830625373`"}], ",", "0.3636254599823502`", ",", 
       "0.6195317435596671`", ",", "1.1845148237910068`", ",", 
       RowBox[{"-", "0.34068053451365315`"}], ",", "3.180948380287802`", ",", 
       RowBox[{"-", "3.32188954243115`"}], ",", 
       RowBox[{"-", "3.5685530842614135`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.134`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.4437313773047735`"}], ",", "0.34880106140499667`", ",",
        "0.6035113589189115`", ",", "1.2066983296260254`", ",", 
       RowBox[{"-", "0.31836577492790635`"}], ",", "3.18594408519273`", ",", 
       RowBox[{"-", "3.3310420359624566`"}], ",", 
       RowBox[{"-", "3.579514428081354`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.135`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.467905395934593`"}], ",", "0.3393158299095613`", ",", 
       "0.5931078079313106`", ",", "1.220433610712333`", ",", 
       RowBox[{"-", "0.303167987165149`"}], ",", "3.189068841303798`", ",", 
       RowBox[{"-", "3.336792529577479`"}], ",", 
       RowBox[{"-", "3.5868007517223104`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1359999999999997`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5029133122556864`"}], ",", "0.3257810936679414`", ",", 
       "0.5780373621619871`", ",", "1.2393850565030275`", ",", 
       RowBox[{"-", "0.2801980722807847`"}], ",", "3.193428980447547`", ",", 
       RowBox[{"-", "3.3448559635582655`"}], ",", 
       RowBox[{"-", "3.5968481527392187`"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.5438685846073008`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"inteq", "[", 
      RowBox[{
      "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", 
       ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", "nsol"}], 
    "]"}], ";"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerics - High precision", "Subsubtitle",
 CellChangeTimes->{{3.538463013798025*^9, 3.5384630213987093`*^9}, {
  3.538467402992407*^9, 3.5384674058714247`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"precision", "=", "25"}], ";"}]], "Input",
 CellChangeTimes->{{3.538467418163487*^9, 3.5384674209374638`*^9}, {
  3.538467503829393*^9, 3.538467504196958*^9}, {3.5384675867083883`*^9, 
  3.5384675867768393`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"inteq", ",", "zhoriz", ",", "eps"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"inteq", "[", 
    RowBox[{
    "z0in_Real", ",", "horizp0in_Real", ",", "horiza1in_Real", ",", 
     "horizt1in_Real", ",", "horizs0in_Real", ",", "asymp2in_Real", ",", 
     "asymh2in_Real", ",", "asyma0in_Real", ",", "asyma1in_Real", ",", 
     "asymT3in_Real", ",", "output_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"z0", "=", "z0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizp0", "=", "horizp0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizh0", "=", "0"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horiza1", "=", "horiza1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizt1", "=", "horizt1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizs0", "=", "horizs0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymp2", "=", "asymp2in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymh2", "=", "asymh2in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asyma0", "=", "asyma0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asyma1", "=", "asyma1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymT3", "=", "asymT3in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"eps", "=", "0.00001"}], " ", ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"eps2", "=", "0.00001"}], " ", ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zmid", " ", "=", " ", "0.4"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zhoriz", "=", 
      RowBox[{"1", "-", "eps2"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"nsol1", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"eqlist", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"p", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymp", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asymp", "'"}], "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"h", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymh", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"a", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asyma", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asyma", "'"}], "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"T", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymT", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"S", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymS", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asymS", "'"}], "[", "eps", "]"}]}]}], "}"}]}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "eps", ",", "zhoriz"}], "}"}], ",", 
         RowBox[{"WorkingPrecision", "\[Rule]", "precision"}], ",", 
         RowBox[{"MaxSteps", "\[Rule]", "100000"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zcut1", "=", 
      RowBox[{"nsol1", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "2"}], "]"}], "]"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"zcut1", "<", "zmid"}], ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Error  \>\"", ",", "zcut2"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"nsol2", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"eqlist", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"p", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizp", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horizp", "'"}], "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"h", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizh", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"a", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horiza", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horiza", "'"}], "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"T", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizT", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"S", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizS", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horizS", "'"}], "[", "zhoriz", "]"}]}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "eps", ",", "zhoriz"}], "}"}], ",", 
         RowBox[{"WorkingPrecision", "\[Rule]", "precision"}], ",", 
         RowBox[{"MaxSteps", "\[Rule]", "100000"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zcut2", "=", 
      RowBox[{"nsol2", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "1"}], "]"}], "]"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"zcut2", ">", "zmid"}], ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Error  \>\"", ",", "zcut2"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", 
      RowBox[{
      "horizp0", ",", "horizh0", ",", "horiza1", ",", "horizt1", ",", 
       "horizs0", ",", "asymp2", ",", "asymh2", ",", "asyma0", ",", "asyma1", 
       ",", "asymT3"}], "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Return", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"h", "'"}], "[", "eps", "]"}], ",", 
             RowBox[{
              RowBox[{"T", "'"}], "[", "eps", "]"}]}], "}"}], "/.", "nsol2"}],
           "]"}], ";"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"htab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"h", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Ttab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"T", "[", "z", "]"}], "-", "1"}], "/.", "nsol2"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Coefficient", "[", 
            RowBox[{"hfit", ",", "z"}], "]"}], ",", 
           RowBox[{"Coefficient", "[", 
            RowBox[{"Tfit", ",", "z"}], "]"}]}], "}"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "2"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"T", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"T", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"S", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"S", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"dlist", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"Join", "[", 
          RowBox[{"list", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"dlist", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"dlist", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"dlist", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}], "]"}], 
        ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ptab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"p", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"htab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"h", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"atab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"a", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Ttab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"T", "[", "z", "]"}], "-", "1"}], "/.", "nsol2"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Stab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"S", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"pfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"ptab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"afit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"atab", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "z"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}], ",", 
             RowBox[{"z", "^", "3"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Sfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Stab", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "z"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"pfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"ptab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "2"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "2"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "3"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"pf", "==", "pfit"}], ",", 
             RowBox[{"hf", "\[Equal]", "hfit"}], ",", 
             RowBox[{"af", "\[Equal]", "afit"}], ",", 
             RowBox[{"Tf", "\[Equal]", "Tfit"}], ",", 
             RowBox[{"Sf", "\[Equal]", "Sfit"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pfit2", ",", "hfit2", ",", "Tfit2"}], "}"}]}], "}"}], 
         "]"}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], 
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.5376407771099586`*^9, 3.53764077742128*^9}, {
   3.537640849432414*^9, 3.537641029700471*^9}, {3.537641083186082*^9, 
   3.5376410832815037`*^9}, {3.537641227496984*^9, 3.537641241071927*^9}, {
   3.537641278231781*^9, 3.53764129200132*^9}, {3.537811594660029*^9, 
   3.537811661635552*^9}, 3.537811712330718*^9, {3.537812313668707*^9, 
   3.537812329718534*^9}, {3.537812368025175*^9, 3.537812466952651*^9}, {
   3.537812574550178*^9, 3.53781262207281*^9}, {3.537855902100842*^9, 
   3.537855910975484*^9}, {3.537863637889791*^9, 3.537863642968212*^9}, {
   3.53786405512639*^9, 3.5378640577014513`*^9}, {3.5378642740193357`*^9, 
   3.5378642823266706`*^9}, {3.537864945886372*^9, 3.537864949610241*^9}, {
   3.537865324468916*^9, 3.5378653414829493`*^9}, {3.537865422417637*^9, 
   3.537865426010881*^9}, {3.537865668894218*^9, 3.5378656720161123`*^9}, {
   3.537866060689427*^9, 3.537866086110963*^9}, {3.537866821965849*^9, 
   3.537866824468356*^9}, {3.537866935754058*^9, 3.5378669532770844`*^9}, {
   3.537867277477654*^9, 3.537867283864683*^9}, {3.5378673736645327`*^9, 
   3.53786741047612*^9}, {3.537867724358015*^9, 3.537867770909184*^9}, {
   3.537867812374217*^9, 3.537867814824875*^9}, {3.537867862682262*^9, 
   3.537867863608501*^9}, {3.537867935345325*^9, 3.537867952471974*^9}, {
   3.537867984898217*^9, 3.5378679871300287`*^9}, {3.537870400150711*^9, 
   3.537870402077724*^9}, {3.537870448958918*^9, 3.5378704524785967`*^9}, {
   3.537870930220189*^9, 3.537870930900414*^9}, 3.537871139674671*^9, {
   3.537871192589308*^9, 3.53787120155658*^9}, {3.537871653378598*^9, 
   3.5378716648098917`*^9}, {3.537871703252593*^9, 3.537871787942024*^9}, {
   3.537871824557847*^9, 3.537871910740779*^9}, {3.537871941253039*^9, 
   3.5378719525649443`*^9}, {3.537871994498852*^9, 3.537872049059258*^9}, {
   3.537872138421897*^9, 3.537872144006673*^9}, {3.537872196836445*^9, 
   3.53787224947705*^9}, {3.5378722878468122`*^9, 3.537872372883222*^9}, {
   3.537872490150178*^9, 3.537872496093255*^9}, {3.537872547385435*^9, 
   3.537872561998753*^9}, {3.537872800792879*^9, 3.5378728967451353`*^9}, {
   3.537872969967389*^9, 3.537872993322166*^9}, {3.5378733845638*^9, 
   3.537873523491342*^9}, {3.537874990501849*^9, 3.5378750749448233`*^9}, {
   3.538046326178605*^9, 3.5380463263452587`*^9}, {3.538046359506956*^9, 
   3.5380464610359497`*^9}, {3.538046502103581*^9, 3.538046513481264*^9}, {
   3.53804657410702*^9, 3.538046614577108*^9}, {3.53804665505602*^9, 
   3.538046715360199*^9}, {3.538046757351519*^9, 3.53804676998315*^9}, {
   3.5380468595384607`*^9, 3.5380468659616413`*^9}, {3.538046897437215*^9, 
   3.538046897572302*^9}, {3.538047066640044*^9, 3.538047074544244*^9}, {
   3.538047229999874*^9, 3.5380472836305647`*^9}, {3.538047353035921*^9, 
   3.538047363818179*^9}, {3.538047476249525*^9, 3.538047522111104*^9}, {
   3.5380475966181917`*^9, 3.5380475967702713`*^9}, {3.538047801532692*^9, 
   3.538047822201064*^9}, {3.538047948516816*^9, 3.538047948684765*^9}, {
   3.538114366350466*^9, 3.5381144299925222`*^9}, {3.538114576757052*^9, 
   3.5381146749454412`*^9}, {3.538114791107875*^9, 3.5381148266944447`*^9}, {
   3.538114878968347*^9, 3.538115127215603*^9}, {3.53811552595366*^9, 
   3.538115590252236*^9}, {3.5381156363832006`*^9, 3.538115704042387*^9}, {
   3.53811589099817*^9, 3.53811590783984*^9}, {3.538115999280501*^9, 
   3.5381160364460382`*^9}, 3.538116068499432*^9, {3.5381163172614202`*^9, 
   3.5381163185592117`*^9}, 3.538116587083933*^9, {3.538116795975728*^9, 
   3.5381167961435547`*^9}, {3.538116915101754*^9, 3.538116916845715*^9}, {
   3.538117082639504*^9, 3.5381170838467207`*^9}, {3.538117120446578*^9, 
   3.538117121605109*^9}, {3.538117912630061*^9, 3.5381179255489893`*^9}, {
   3.538118168821506*^9, 3.538118170682723*^9}, {3.5381182778513527`*^9, 
   3.538118288943109*^9}, {3.5381183580154047`*^9, 3.5381183581193533`*^9}, {
   3.538118848337666*^9, 3.538118920486744*^9}, {3.538119184188271*^9, 
   3.53811918440349*^9}, {3.5381193489118156`*^9, 3.538119350612996*^9}, {
   3.538119892508926*^9, 3.538119895751055*^9}, {3.538119927591441*^9, 
   3.538119936248074*^9}, {3.538120029047421*^9, 3.538120037965654*^9}, {
   3.538120194027095*^9, 3.538120201471917*^9}, {3.53812028017563*^9, 
   3.538120301265314*^9}, {3.5381381252717533`*^9, 3.538138126469459*^9}, {
   3.538328246372367*^9, 3.5383282504354353`*^9}, {3.5383283005077343`*^9, 
   3.538328335488717*^9}, {3.538329001230315*^9, 3.538329010372521*^9}, {
   3.5383292041149054`*^9, 3.538329214953123*^9}, {3.5383314262207823`*^9, 
   3.538331427882743*^9}, {3.538467415297628*^9, 3.538467417025399*^9}, {
   3.538467483475766*^9, 3.538467496260305*^9}, {3.53846768282121*^9, 
   3.538467684491909*^9}, 3.538467751698575*^9, 3.538467834293067*^9, 
   3.538467910310305*^9, {3.538474665252652*^9, 3.5384747132015*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"inteq", "[", 
   RowBox[{
   "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", ",",
     "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x1", "\[Rule]", 
     RowBox[{"-", "0.3829783523505521`"}]}], ",", 
    RowBox[{"x2", "\[Rule]", "0.7375353380516665`"}], ",", 
    RowBox[{"x3", "\[Rule]", "0.965835601510695`"}], ",", 
    RowBox[{"x4", "\[Rule]", "0.324681251811493`"}], ",", 
    RowBox[{"x5", "\[Rule]", 
     RowBox[{"-", "0.28247228958217985`"}]}], ",", 
    RowBox[{"x6", "\[Rule]", "3.0061810011547174`"}], ",", 
    RowBox[{"x7", "\[Rule]", 
     RowBox[{"-", "3.0221253004173594`"}]}], ",", 
    RowBox[{"x8", "\[Rule]", 
     RowBox[{"-", "3.257338115215336`"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.53847464194142*^9, 3.538474642222443*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.3829468917328384`"}], ",", "0.7375309427221062`", ",", 
     "0.9658412255786136`", ",", "0.3246514074125869`", ",", 
     RowBox[{"-", "0.28242066863611487`"}], ",", "3.00617950632583`", ",", 
     RowBox[{"-", "3.022120996980998`"}], ",", 
     RowBox[{"-", "3.255070720450515`"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538395488974235*^9, 3.538395494671344*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", "3.0"}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nsol", "=", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"inteq", "[", 
      RowBox[{
      "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", 
       ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x3", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x4", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x5", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x6", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "6", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x7", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "7", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x8", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "8", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "25"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"inteq", "[", 
     RowBox[{
     "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", 
      ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", "nsol"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5383955289097357`*^9, 3.538395607280014*^9}, {
  3.5384675702538347`*^9, 3.538467573581067*^9}, {3.538467922768297*^9, 
  3.5384679239991417`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"p", "[", "z", "]"}], "^", "2"}], "+", 
          RowBox[{
           RowBox[{"h", "[", "z", "]"}], "^", "2"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"p", "[", "z", "]"}], "^", "2"}], "+", 
          RowBox[{
           RowBox[{"h", "[", "z", "]"}], "^", "2"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.538395735376672*^9, 3.53839575583502*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"p", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"p", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.538395645101112*^9, 3.5383956470443773`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"h", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"h", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.538395660340578*^9, 3.538395661228434*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"T", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"T", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5383956126740437`*^9, 3.538395637955501*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.53839567437263*^9, 3.538395675044032*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"S", "[", "z", "]"}], "/.", "nsol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "eps", ",", "zcut1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"S", "[", "z", "]"}], "/.", "nsol2"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "zcut2", ",", "zhoriz"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5383956807250023`*^9, 3.538395683147913*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vec", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.3829468917328384`"}], ",", "0.7375309427221062`", ",", 
      "0.9658412255786136`", ",", "0.3246514074125869`", ",", 
      RowBox[{"-", "0.28242066863611487`"}], ",", "3.00617950632583`", ",", 
      RowBox[{"-", "3.022120996980998`"}], ",", 
      RowBox[{"-", "3.255070720450515`"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"veclist", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"nsol", "=", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"inteq", "[", 
         RowBox[{
         "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", 
          "x5", ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x1", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x2", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x3", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x4", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x5", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x6", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "6", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x7", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "7", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x8", ",", 
          RowBox[{"vec", "[", 
           RowBox[{"[", "8", "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmp", "=", 
      RowBox[{
       RowBox[{"inteq", "[", 
        RowBox[{
        "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5",
          ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", 
       "nsol"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Norm", "[", "tmp", "]"}], "<", 
        RowBox[{"10", "^", 
         RowBox[{"-", "8"}]}]}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vec", "=", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5", ",", "x6", ",", 
            "x7", ",", "x8"}], "}"}], "/.", "nsol"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<q = \>\"", ",", "q", ",", "\"\< -> \>\"", ",", 
          RowBox[{"Norm", "[", "tmp", "]"}], ",", "\"\<\\n   \>\"", ",", 
          "vec", ",", "\"\<\\n\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"veclist", ",", 
          RowBox[{"{", 
           RowBox[{"q", ",", "nsol"}], "}"}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Done\>\"", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"q", " ", "=", " ", "10."}], " ", ";"}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"q", ",", "3.0", ",", "3.3", ",", 
      RowBox[{"+", "0.01"}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5383955289097357`*^9, 3.538395607280014*^9}, {
   3.5383960750003557`*^9, 3.538396215074095*^9}, {3.538396289910667*^9, 
   3.5383963203716497`*^9}, {3.538396509259591*^9, 3.5383965728440866`*^9}, {
   3.5383966941917267`*^9, 3.538396697847146*^9}, 3.538396737895993*^9, {
   3.53839744436998*^9, 3.538397450144785*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"inteq", "[", 
      RowBox[{
      "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", 
       ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", "nsol"}], 
    "]"}], ";"}]}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerics - High precision", "Subsubtitle",
 CellChangeTimes->{{3.538463013798025*^9, 3.5384630213987093`*^9}, {
  3.538467402992407*^9, 3.5384674058714247`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"precision", "=", "25"}], ";"}]], "Input",
 CellChangeTimes->{{3.538467418163487*^9, 3.5384674209374638`*^9}, {
  3.538467503829393*^9, 3.538467504196958*^9}, {3.5384675867083883`*^9, 
  3.5384675867768393`*^9}, {3.538475778689355*^9, 3.538475779473031*^9}, {
  3.5384759893975153`*^9, 3.538475989501337*^9}, {3.538483715861815*^9, 
  3.5384837159415283`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"inteq", ",", "zhoriz", ",", "eps"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"inteq", "[", 
    RowBox[{
    "z0in_Real", ",", "horizp0in_Real", ",", "horiza1in_Real", ",", 
     "horizt1in_Real", ",", "horizs0in_Real", ",", "asymp2in_Real", ",", 
     "asymh2in_Real", ",", "asyma0in_Real", ",", "asyma1in_Real", ",", 
     "asymT3in_Real", ",", "output_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"z0", "=", "z0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizp0", "=", "horizp0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizh0", "=", "0"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horiza1", "=", "horiza1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizt1", "=", "horizt1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizs0", "=", "horizs0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymp2", "=", "asymp2in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymh2", "=", "asymh2in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asyma0", "=", "asyma0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asyma1", "=", "asyma1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymT3", "=", "asymT3in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"eps", "=", 
      RowBox[{"SetPrecision", "[", 
       RowBox[{"0.0001", ",", "30"}], "]"}]}], " ", ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"eps2", "=", 
      RowBox[{"SetPrecision", "[", 
       RowBox[{"0.0001", ",", "30"}], "]"}]}], " ", ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"zmid", " ", "=", " ", 
      RowBox[{"SetPrecision", "[", 
       RowBox[{"0.4", ",", "30"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zhoriz", "=", 
      RowBox[{"1", "-", "eps2"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"nsol1", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"eqlist", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"p", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymp", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asymp", "'"}], "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"h", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymh", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"a", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asyma", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asyma", "'"}], "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"T", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymT", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"S", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymS", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asymS", "'"}], "[", "eps", "]"}]}]}], "}"}]}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "eps", ",", "zhoriz"}], "}"}], ",", 
         RowBox[{"WorkingPrecision", "\[Rule]", "precision"}], ",", 
         RowBox[{"MaxSteps", "\[Rule]", "100000"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zcut1", "=", 
      RowBox[{"nsol1", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "2"}], "]"}], "]"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"zcut1", "<", "zmid"}], ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Error  \>\"", ",", "zcut2"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"nsol2", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"eqlist", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"p", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizp", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horizp", "'"}], "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"h", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizh", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"a", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horiza", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horiza", "'"}], "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"T", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizT", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"S", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizS", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horizS", "'"}], "[", "zhoriz", "]"}]}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "eps", ",", "zhoriz"}], "}"}], ",", 
         RowBox[{"WorkingPrecision", "\[Rule]", "precision"}], ",", 
         RowBox[{"MaxSteps", "\[Rule]", "100000"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zcut2", "=", 
      RowBox[{"nsol2", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "1"}], "]"}], "]"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"zcut2", ">", "zmid"}], ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Error  \>\"", ",", "zcut2"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", 
      RowBox[{
      "horizp0", ",", "horizh0", ",", "horiza1", ",", "horizt1", ",", 
       "horizs0", ",", "asymp2", ",", "asymh2", ",", "asyma0", ",", "asyma1", 
       ",", "asymT3"}], "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Return", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"h", "'"}], "[", "eps", "]"}], ",", 
             RowBox[{
              RowBox[{"T", "'"}], "[", "eps", "]"}]}], "}"}], "/.", "nsol2"}],
           "]"}], ";"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"htab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"h", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Ttab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"T", "[", "z", "]"}], "-", "1"}], "/.", "nsol2"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Coefficient", "[", 
            RowBox[{"hfit", ",", "z"}], "]"}], ",", 
           RowBox[{"Coefficient", "[", 
            RowBox[{"Tfit", ",", "z"}], "]"}]}], "}"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "2"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"T", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"T", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"S", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"S", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"dlist", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"Join", "[", 
          RowBox[{"list", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"dlist", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"dlist", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"dlist", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}], "]"}], 
        ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ptab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"p", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"htab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"h", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"atab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"a", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Ttab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"T", "[", "z", "]"}], "-", "1"}], "/.", "nsol2"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Stab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"S", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"pfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"ptab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"afit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"atab", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "z"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}], ",", 
             RowBox[{"z", "^", "3"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Sfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Stab", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "z"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"pfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"ptab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "2"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "2"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "3"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"pf", "==", "pfit"}], ",", 
             RowBox[{"hf", "\[Equal]", "hfit"}], ",", 
             RowBox[{"af", "\[Equal]", "afit"}], ",", 
             RowBox[{"Tf", "\[Equal]", "Tfit"}], ",", 
             RowBox[{"Sf", "\[Equal]", "Sfit"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pfit2", ",", "hfit2", ",", "Tfit2"}], "}"}]}], "}"}], 
         "]"}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], 
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.5376407771099586`*^9, 3.53764077742128*^9}, {
   3.537640849432414*^9, 3.537641029700471*^9}, {3.537641083186082*^9, 
   3.5376410832815037`*^9}, {3.537641227496984*^9, 3.537641241071927*^9}, {
   3.537641278231781*^9, 3.53764129200132*^9}, {3.537811594660029*^9, 
   3.537811661635552*^9}, 3.537811712330718*^9, {3.537812313668707*^9, 
   3.537812329718534*^9}, {3.537812368025175*^9, 3.537812466952651*^9}, {
   3.537812574550178*^9, 3.53781262207281*^9}, {3.537855902100842*^9, 
   3.537855910975484*^9}, {3.537863637889791*^9, 3.537863642968212*^9}, {
   3.53786405512639*^9, 3.5378640577014513`*^9}, {3.5378642740193357`*^9, 
   3.5378642823266706`*^9}, {3.537864945886372*^9, 3.537864949610241*^9}, {
   3.537865324468916*^9, 3.5378653414829493`*^9}, {3.537865422417637*^9, 
   3.537865426010881*^9}, {3.537865668894218*^9, 3.5378656720161123`*^9}, {
   3.537866060689427*^9, 3.537866086110963*^9}, {3.537866821965849*^9, 
   3.537866824468356*^9}, {3.537866935754058*^9, 3.5378669532770844`*^9}, {
   3.537867277477654*^9, 3.537867283864683*^9}, {3.5378673736645327`*^9, 
   3.53786741047612*^9}, {3.537867724358015*^9, 3.537867770909184*^9}, {
   3.537867812374217*^9, 3.537867814824875*^9}, {3.537867862682262*^9, 
   3.537867863608501*^9}, {3.537867935345325*^9, 3.537867952471974*^9}, {
   3.537867984898217*^9, 3.5378679871300287`*^9}, {3.537870400150711*^9, 
   3.537870402077724*^9}, {3.537870448958918*^9, 3.5378704524785967`*^9}, {
   3.537870930220189*^9, 3.537870930900414*^9}, 3.537871139674671*^9, {
   3.537871192589308*^9, 3.53787120155658*^9}, {3.537871653378598*^9, 
   3.5378716648098917`*^9}, {3.537871703252593*^9, 3.537871787942024*^9}, {
   3.537871824557847*^9, 3.537871910740779*^9}, {3.537871941253039*^9, 
   3.5378719525649443`*^9}, {3.537871994498852*^9, 3.537872049059258*^9}, {
   3.537872138421897*^9, 3.537872144006673*^9}, {3.537872196836445*^9, 
   3.53787224947705*^9}, {3.5378722878468122`*^9, 3.537872372883222*^9}, {
   3.537872490150178*^9, 3.537872496093255*^9}, {3.537872547385435*^9, 
   3.537872561998753*^9}, {3.537872800792879*^9, 3.5378728967451353`*^9}, {
   3.537872969967389*^9, 3.537872993322166*^9}, {3.5378733845638*^9, 
   3.537873523491342*^9}, {3.537874990501849*^9, 3.5378750749448233`*^9}, {
   3.538046326178605*^9, 3.5380463263452587`*^9}, {3.538046359506956*^9, 
   3.5380464610359497`*^9}, {3.538046502103581*^9, 3.538046513481264*^9}, {
   3.53804657410702*^9, 3.538046614577108*^9}, {3.53804665505602*^9, 
   3.538046715360199*^9}, {3.538046757351519*^9, 3.53804676998315*^9}, {
   3.5380468595384607`*^9, 3.5380468659616413`*^9}, {3.538046897437215*^9, 
   3.538046897572302*^9}, {3.538047066640044*^9, 3.538047074544244*^9}, {
   3.538047229999874*^9, 3.5380472836305647`*^9}, {3.538047353035921*^9, 
   3.538047363818179*^9}, {3.538047476249525*^9, 3.538047522111104*^9}, {
   3.5380475966181917`*^9, 3.5380475967702713`*^9}, {3.538047801532692*^9, 
   3.538047822201064*^9}, {3.538047948516816*^9, 3.538047948684765*^9}, {
   3.538114366350466*^9, 3.5381144299925222`*^9}, {3.538114576757052*^9, 
   3.5381146749454412`*^9}, {3.538114791107875*^9, 3.5381148266944447`*^9}, {
   3.538114878968347*^9, 3.538115127215603*^9}, {3.53811552595366*^9, 
   3.538115590252236*^9}, {3.5381156363832006`*^9, 3.538115704042387*^9}, {
   3.53811589099817*^9, 3.53811590783984*^9}, {3.538115999280501*^9, 
   3.5381160364460382`*^9}, 3.538116068499432*^9, {3.5381163172614202`*^9, 
   3.5381163185592117`*^9}, 3.538116587083933*^9, {3.538116795975728*^9, 
   3.5381167961435547`*^9}, {3.538116915101754*^9, 3.538116916845715*^9}, {
   3.538117082639504*^9, 3.5381170838467207`*^9}, {3.538117120446578*^9, 
   3.538117121605109*^9}, {3.538117912630061*^9, 3.5381179255489893`*^9}, {
   3.538118168821506*^9, 3.538118170682723*^9}, {3.5381182778513527`*^9, 
   3.538118288943109*^9}, {3.5381183580154047`*^9, 3.5381183581193533`*^9}, {
   3.538118848337666*^9, 3.538118920486744*^9}, {3.538119184188271*^9, 
   3.53811918440349*^9}, {3.5381193489118156`*^9, 3.538119350612996*^9}, {
   3.538119892508926*^9, 3.538119895751055*^9}, {3.538119927591441*^9, 
   3.538119936248074*^9}, {3.538120029047421*^9, 3.538120037965654*^9}, {
   3.538120194027095*^9, 3.538120201471917*^9}, {3.53812028017563*^9, 
   3.538120301265314*^9}, {3.5381381252717533`*^9, 3.538138126469459*^9}, {
   3.538328246372367*^9, 3.5383282504354353`*^9}, {3.5383283005077343`*^9, 
   3.538328335488717*^9}, {3.538329001230315*^9, 3.538329010372521*^9}, {
   3.5383292041149054`*^9, 3.538329214953123*^9}, {3.5383314262207823`*^9, 
   3.538331427882743*^9}, {3.538467415297628*^9, 3.538467417025399*^9}, {
   3.538467483475766*^9, 3.538467496260305*^9}, {3.53846768282121*^9, 
   3.538467684491909*^9}, 3.538467751698575*^9, 3.538467834293067*^9, 
   3.538467910310305*^9, {3.538474665252652*^9, 3.5384747132015*^9}, {
   3.53847578605576*^9, 3.538475802638404*^9}, {3.538483710131217*^9, 
   3.5384837122828617`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.38294689173"}], ",", "0.737530942", ",", "0.965841225",
        ",", "0.324651407", ",", 
       RowBox[{"-", "0.2824206686"}], ",", "3.00617950", ",", 
       RowBox[{"-", "3.022120996"}], ",", 
       RowBox[{"-", "3.2550707204"}]}], "}"}], ",", "30"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.538395488974235*^9, 3.538395494671344*^9}, {
  3.538475270148683*^9, 3.538475278100976*^9}, {3.5384753323016653`*^9, 
  3.538475399427929*^9}, {3.5384755290732517`*^9, 3.538475544392206*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"q", "=", 
    RowBox[{"SetPrecision", "[", 
     RowBox[{"3.0", ",", "30"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"z0", "=", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{"1.0", ",", "30"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5384755568817177`*^9, 3.5384755586157703`*^9}, {
  3.5384757492560873`*^9, 3.538475756552244*^9}}],

Cell[BoxData[
 RowBox[{"eq0", "=", 
  RowBox[{"inteq", "[", 
   RowBox[{"z0", ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "3", "]"}], "]"}], ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "4", "]"}], "]"}], ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "5", "]"}], "]"}], ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "6", "]"}], "]"}], ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "7", "]"}], "]"}], ",", 
    RowBox[{"vec", "[", 
     RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.53847589349119*^9, 3.5384758939548798`*^9}}],

Cell[BoxData[
 RowBox[{"Precision", "[", "eq0", "]"}]], "Input",
 CellChangeTimes->{{3.538475941247263*^9, 3.538475945849679*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq0", "=", 
    RowBox[{"inteq", "[", 
     RowBox[{"z0", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "3", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "4", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "5", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "6", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "7", "]"}], "]"}], ",", 
      RowBox[{"vec", "[", 
       RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DX", " ", "=", 
    RowBox[{"SetPrecision", "[", 
     RowBox[{"0.001", ",", "30"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"vec0", "=", "vec"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "-=", "DX"}], " ", ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"eq1", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"z0", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vec0", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "+=", 
       RowBox[{"2", "*", "DX"}]}], " ", ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"eq2", "=", 
       RowBox[{"inteq", "[", 
        RowBox[{"z0", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "q", ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "5", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "6", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "7", "]"}], "]"}], ",", 
         RowBox[{"vec0", "[", 
          RowBox[{"[", "8", "]"}], "]"}], ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"mat", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"eq2", "-", "eq1"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "DX"}], ")"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "8"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<det = \>\"", ",", 
     RowBox[{"Det", "[", "mat", "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dvec", "=", 
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{"Transpose", "[", "mat", "]"}], "]"}], ".", "eq0"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vec", " ", "=", " ", 
    RowBox[{"vec", "-", "dvec"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<vec = \>\"", ",", "vec", ",", "\"\<  ->  eq = \>\"", ",", "eq0"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.538120490121634*^9, 3.538120518932563*^9}, {
   3.5381205558741503`*^9, 3.538120610837431*^9}, {3.5381206659362717`*^9, 
   3.538120712255209*^9}, {3.5383285846229553`*^9, 3.538328585388818*^9}, {
   3.538328684844769*^9, 3.5383286852597733`*^9}, 3.538328770081517*^9, {
   3.5383289405611877`*^9, 3.5383289561436033`*^9}, {3.538329024216524*^9, 
   3.538329027272518*^9}, {3.538329231307086*^9, 3.538329245530115*^9}, {
   3.53832928014611*^9, 3.5383292802257977`*^9}, {3.538331899292232*^9, 
   3.538331918317177*^9}, {3.5383320080930357`*^9, 3.53833201029294*^9}, {
   3.5383320534615726`*^9, 3.538332054173419*^9}, {3.538332091130785*^9, 
   3.538332091290278*^9}, {3.538332148467001*^9, 3.538332166530912*^9}, {
   3.538332763655594*^9, 3.538332763839275*^9}, 3.538332811566271*^9, {
   3.5383329603107758`*^9, 3.538333014609095*^9}, {3.538372704879333*^9, 
   3.538372748091798*^9}, {3.538380094711239*^9, 3.538380095245941*^9}, {
   3.538475565399063*^9, 3.538475570349143*^9}, {3.538475761638802*^9, 
   3.5384757666307983`*^9}, {3.538475930088382*^9, 3.538475933711309*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.3829468"}], ",", "0.737530", ",", "0.9658412", ",", 
       "0.32465140", ",", 
       RowBox[{"-", "0.28242066"}], ",", "3.006179", ",", 
       RowBox[{"-", "3.0221209"}], ",", 
       RowBox[{"-", "3.255070"}]}], "}"}], ",", "30"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.538395488974235*^9, 3.538395494671344*^9}, {
  3.538487155497856*^9, 3.5384871600489283`*^9}, {3.538487422110376*^9, 
  3.53848743906916*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{"3.0", ",", "30"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5384871726643677`*^9, 3.538487176504283*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nsol", "=", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"inteq", "[", 
      RowBox[{
       RowBox[{"SetPrecision", "[", 
        RowBox[{"1.", ",", "30"}], "]"}], ",", "x1", ",", "q", ",", "x2", ",",
        "x3", ",", "x4", ",", "x5", ",", "x6", ",", "x7", ",", "x8", ",", 
       "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x3", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x4", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x5", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x6", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "6", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x7", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "7", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x8", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "8", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "25"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"inteq", "[", 
     RowBox[{
     "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", 
      ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", "nsol"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5383955289097357`*^9, 3.538395607280014*^9}, {
  3.5384675702538347`*^9, 3.538467573581067*^9}, {3.538467922768297*^9, 
  3.5384679239991417`*^9}, {3.5384871845792227`*^9, 3.538487189060872*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"NR", "=", "20"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NN", "=", 
   RowBox[{"NR", "-", "1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.51763841954007*^9, 3.517638421220167*^9}, {
   3.53850182798134*^9, 3.538501830676206*^9}, {3.53873119805525*^9, 
   3.538731198141795*^9}, 3.538741113249531*^9, 3.538808539493106*^9, 
   3.538808990452856*^9, {3.5388105439971848`*^9, 3.538810586676996*^9}, {
   3.543736247015036*^9, 3.543736247074452*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ChebR", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"\[Pi]", " ", "ii"}], "NN"], "]"}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "NN", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "ChebR", "]"}]}], "Input",
 CellChangeTimes->{{3.5175504275379143`*^9, 3.517550473868642*^9}, {
   3.5175505088539352`*^9, 3.51755057150263*^9}, {3.5175531815270977`*^9, 
   3.517553182781066*^9}, {3.5175532841430807`*^9, 3.517553285717567*^9}, {
   3.5175533447190742`*^9, 3.517553345933249*^9}, {3.517553478839162*^9, 
   3.5175534801413918`*^9}, {3.517553697086974*^9, 3.5175537300535307`*^9}, {
   3.517636043667302*^9, 3.517636082342285*^9}, {3.517636156121964*^9, 
   3.517636163909718*^9}, 3.517636245951754*^9, {3.517637708503521*^9, 
   3.517637710805746*^9}, {3.5176384245898523`*^9, 3.5176384266140013`*^9}, {
   3.517639920088458*^9, 3.517639921413632*^9}, {3.517639981975692*^9, 
   3.517640027901559*^9}}],

Cell[BoxData[
 RowBox[{"aval", "=", 
  RowBox[{
   RowBox[{"asyma0", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"asymp2", "\[Rule]", "x4"}], ",", 
      RowBox[{"asymh2", "\[Rule]", "x5"}], ",", 
      RowBox[{"asyma0", "\[Rule]", "x6"}], ",", 
      RowBox[{"asyma1", "\[Rule]", "x7"}], ",", 
      RowBox[{"asymT3", "\[Rule]", "x8"}]}], "}"}]}], "/.", 
   "nsol"}]}]], "Input",
 CellChangeTimes->{{3.538503869006027*^9, 3.538503871118003*^9}, {
  3.538504557033042*^9, 3.538504557751896*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", "z"], 
         RowBox[{"p", "[", "z", "]"}]}], "/.", "nsol1"}], "/.", 
       RowBox[{"{", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", 
            RowBox[{"-", "2"}]}], "]"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{"horizp", "[", "z", "]"}], "z"], "/.", 
          RowBox[{"{", 
           RowBox[{"z", "\[Rule]", "1"}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"horizp0", "\[Rule]", "x1"}], ",", 
           RowBox[{"horizh0", "\[Rule]", "0"}], ",", 
           RowBox[{"horiza1", "\[Rule]", "q"}], ",", 
           RowBox[{"horizt1", "\[Rule]", "x2"}], ",", 
           RowBox[{"horizs0", "\[Rule]", "x3"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hlist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", "z"], 
         RowBox[{"h", "[", "z", "]"}]}], "/.", "nsol1"}], "/.", 
       RowBox[{"{", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", 
            RowBox[{"-", "2"}]}], "]"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{"horizh", "[", "z", "]"}], "z"], "/.", 
          RowBox[{"{", 
           RowBox[{"z", "\[Rule]", "1"}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"horizp0", "\[Rule]", "x1"}], ",", 
           RowBox[{"horizh0", "\[Rule]", "0"}], ",", 
           RowBox[{"horiza1", "\[Rule]", "q"}], ",", 
           RowBox[{"horizt1", "\[Rule]", "x2"}], ",", 
           RowBox[{"horizs0", "\[Rule]", "x3"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"alist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Expand", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"asyma", "[", "z", "]"}], "-", "asyma0"}], "z"], "]"}], "/.", 
          RowBox[{"{", 
           RowBox[{"z", "\[Rule]", "0"}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"asymp2", "\[Rule]", "x4"}], ",", 
           RowBox[{"asymh2", "\[Rule]", "x5"}], ",", 
           RowBox[{"asyma0", "\[Rule]", "x6"}], ",", 
           RowBox[{"asyma1", "\[Rule]", "x7"}], ",", 
           RowBox[{"asymT3", "\[Rule]", "x8"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           FractionBox["1", "z"], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "[", "z", "]"}], "-", "asyma0"}], ")"}]}], "/.", 
          "nsol1"}], "/.", 
         RowBox[{"{", 
          RowBox[{"z", "\[Rule]", 
           RowBox[{"ChebR", "[", 
            RowBox[{"[", 
             RowBox[{"2", ";;", 
              RowBox[{"-", "2"}]}], "]"}], "]"}]}], "}"}]}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"asymp2", "\[Rule]", "x4"}], ",", 
          RowBox[{"asymh2", "\[Rule]", "x5"}], ",", 
          RowBox[{"asyma0", "\[Rule]", "x6"}], ",", 
          RowBox[{"asyma1", "\[Rule]", "x7"}], ",", 
          RowBox[{"asymT3", "\[Rule]", "x8"}]}], "}"}]}], "/.", "nsol"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           FractionBox[
            RowBox[{
             RowBox[{"horiza", "[", "z", "]"}], "-", "asyma0"}], "z"], "/.", 
           RowBox[{"{", 
            RowBox[{"z", "\[Rule]", "1"}], "}"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"horizp0", "\[Rule]", "x1"}], ",", 
            RowBox[{"horizh0", "\[Rule]", "0"}], ",", 
            RowBox[{"horiza1", "\[Rule]", "q"}], ",", 
            RowBox[{"horizt1", "\[Rule]", "x2"}], ",", 
            RowBox[{"horizs0", "\[Rule]", "x3"}]}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"asymp2", "\[Rule]", "x4"}], ",", 
           RowBox[{"asymh2", "\[Rule]", "x5"}], ",", 
           RowBox[{"asyma0", "\[Rule]", "x6"}], ",", 
           RowBox[{"asyma1", "\[Rule]", "x7"}], ",", 
           RowBox[{"asymT3", "\[Rule]", "x8"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tlist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", 
          RowBox[{"z", "^", "2"}]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"T", "[", "z", "]"}], "-", "1"}], ")"}]}], "/.", "nsol1"}],
        "/.", 
       RowBox[{"{", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", 
            RowBox[{"-", "2"}]}], "]"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{
            RowBox[{"horizT", "[", "z", "]"}], "-", "1"}], 
           RowBox[{"z", "^", "2"}]], "/.", 
          RowBox[{"{", 
           RowBox[{"z", "\[Rule]", "1"}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"horizp0", "\[Rule]", "x1"}], ",", 
           RowBox[{"horizh0", "\[Rule]", "0"}], ",", 
           RowBox[{"horiza1", "\[Rule]", "q"}], ",", 
           RowBox[{"horizt1", "\[Rule]", "x2"}], ",", 
           RowBox[{"horizs0", "\[Rule]", "x3"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Slist", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        FractionBox["1", 
         RowBox[{"z", "^", "2"}]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"S", "[", "z", "]"}], "-", "1"}], ")"}]}], "/.", "nsol1"}], 
      "/.", 
      RowBox[{"{", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"ChebR", "[", 
         RowBox[{"[", 
          RowBox[{"2", ";;", 
           RowBox[{"-", "2"}]}], "]"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"horizS", "[", "z", "]"}], "-", "1"}], 
          RowBox[{"z", "^", "2"}]], "/.", 
         RowBox[{"{", 
          RowBox[{"z", "\[Rule]", "1"}], "}"}]}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"horizp0", "\[Rule]", "x1"}], ",", 
          RowBox[{"horizh0", "\[Rule]", "0"}], ",", 
          RowBox[{"horiza1", "\[Rule]", "q"}], ",", 
          RowBox[{"horizt1", "\[Rule]", "x2"}], ",", 
          RowBox[{"horizs0", "\[Rule]", "x3"}]}], "}"}]}], "/.", "nsol"}], 
      "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538502159684472*^9, 3.538502221978693*^9}, {
  3.538503165035289*^9, 3.538503299421774*^9}, {3.5385033330026503`*^9, 
  3.5385033914641247`*^9}, {3.5385034512324057`*^9, 3.538503487889101*^9}, {
  3.538503647371841*^9, 3.538503649375634*^9}, {3.538503718913886*^9, 
  3.538503801543604*^9}, {3.538503905800393*^9, 3.538503951275783*^9}, {
  3.538504241391078*^9, 3.53850425647017*^9}, {3.5385044634506683`*^9, 
  3.538504467631667*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"file", " ", "=", " ", 
    RowBox[{"OpenWrite", "[", 
     RowBox[{"\"\<~/Work/AdSCMTDyn3/Matlab/init.dat\>\"", ",", " ", 
      RowBox[{"BinaryFormat", " ", "\[Rule]", " ", "True"}]}], "]"}]}], ";"}],
   "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "file", "]"}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{"  ", 
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", "aval", ",", " ", "\"\<Real64\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\n", "  ", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"plist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"hlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"alist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"Tlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"Slist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", " ", "1", ",", " ", "NR"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.5385020074997997`*^9, 3.538502020253977*^9}, {
   3.538502054087071*^9, 3.5385021529179296`*^9}, {3.538504511144497*^9, 
   3.538504585717393*^9}, {3.538504623909217*^9, 3.5385046463399553`*^9}, {
   3.538726443406577*^9, 3.538726445469967*^9}, 3.54373434032411*^9}],

Cell[BoxData["aval"], "Input",
 CellChangeTimes->{{3.538727363712104*^9, 3.538727364132785*^9}, {
  3.538727421558289*^9, 3.5387274460290956`*^9}}],

Cell[BoxData["NR"], "Input",
 CellChangeTimes->{{3.538727377866576*^9, 3.538727377933123*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerics - Unbroken", "Subsubtitle",
 CellChangeTimes->{{3.538463013798025*^9, 3.5384630213987093`*^9}, {
  3.538467402992407*^9, 3.5384674058714247`*^9}, {3.538985525635343*^9, 
  3.538985527153359*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"NR", "=", "20"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NN", "=", 
   RowBox[{"NR", "-", "1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.51763841954007*^9, 3.517638421220167*^9}, {
   3.53850182798134*^9, 3.538501830676206*^9}, {3.53873119805525*^9, 
   3.538731198141795*^9}, 3.538741113249531*^9, 3.538808539493106*^9, 
   3.538808990452856*^9, {3.5388105439971848`*^9, 3.538810586676996*^9}, {
   3.543734747237671*^9, 3.5437347473106213`*^9}, 3.5437353134547043`*^9, 
   3.543749518444067*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ChebR", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"\[Pi]", " ", "ii"}], "NN"], "]"}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "NN", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "ChebR", "]"}]}], "Input",
 CellChangeTimes->{{3.5175504275379143`*^9, 3.517550473868642*^9}, {
   3.5175505088539352`*^9, 3.51755057150263*^9}, {3.5175531815270977`*^9, 
   3.517553182781066*^9}, {3.5175532841430807`*^9, 3.517553285717567*^9}, {
   3.5175533447190742`*^9, 3.517553345933249*^9}, {3.517553478839162*^9, 
   3.5175534801413918`*^9}, {3.517553697086974*^9, 3.5175537300535307`*^9}, {
   3.517636043667302*^9, 3.517636082342285*^9}, {3.517636156121964*^9, 
   3.517636163909718*^9}, 3.517636245951754*^9, {3.517637708503521*^9, 
   3.517637710805746*^9}, {3.5176384245898523`*^9, 3.5176384266140013`*^9}, {
   3.517639920088458*^9, 3.517639921413632*^9}, {3.517639981975692*^9, 
   3.517640027901559*^9}, {3.5389860399222803`*^9, 3.538986051129409*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"aval", ",", "p", ",", "h", ",", "a", ",", "T", ",", "S"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5389856150179768`*^9, 3.538985619269599*^9}, {
  3.5389867130184183`*^9, 3.538986714170092*^9}, {3.538986804615107*^9, 
  3.538986816726158*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", "\[Epsilon]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", "z_", "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{"3", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        FractionBox["1", "4"], 
        RowBox[{"q", "^", "2"}]}]}], ")"}], " ", 
     RowBox[{"z", "^", "3"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", "z_", "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.538985584177477*^9, 3.538985599024313*^9}, {
   3.53898566037003*^9, 3.538985663298764*^9}, {3.538985694375431*^9, 
   3.538985752536989*^9}, 3.538985795674563*^9}],

Cell[BoxData[
 RowBox[{"T", "[", "1", "]"}]], "Input",
 CellChangeTimes->{{3.538985754767921*^9, 3.5389857560546093`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", "eqlist", "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"\[Epsilon]", "\[Rule]", "0"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5389856530849533`*^9, 3.538985700420933*^9}, {
  3.538985764598106*^9, 3.5389857663737926`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "]"}]], "Input",
 CellChangeTimes->{{3.5389867601265717`*^9, 3.538986761510334*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plist", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", "z"], 
         RowBox[{"p", "[", "z", "]"}]}], "/.", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hlist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", "z"], 
          RowBox[{"h", "[", "z", "]"}]}], "/.", 
         RowBox[{"z", "\[Rule]", 
          RowBox[{"ChebR", "[", 
           RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"alist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", "z"], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "[", "z", "]"}], "-", "aval"}], ")"}]}], "/.", 
         RowBox[{"z", "\[Rule]", 
          RowBox[{"ChebR", "[", 
           RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tlist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", 
           RowBox[{"z", "^", "2"}]], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"T", "[", "z", "]"}], "-", "1"}], ")"}]}], "/.", 
         RowBox[{"z", "\[Rule]", 
          RowBox[{"ChebR", "[", 
           RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Slist", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", 
          RowBox[{"z", "^", "2"}]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"S", "[", "z", "]"}], "-", "1"}], ")"}]}], "/.", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.538502159684472*^9, 3.538502221978693*^9}, {
  3.538503165035289*^9, 3.538503299421774*^9}, {3.5385033330026503`*^9, 
  3.5385033914641247`*^9}, {3.5385034512324057`*^9, 3.538503487889101*^9}, {
  3.538503647371841*^9, 3.538503649375634*^9}, {3.538503718913886*^9, 
  3.538503801543604*^9}, {3.538503905800393*^9, 3.538503951275783*^9}, {
  3.538504241391078*^9, 3.53850425647017*^9}, {3.5385044634506683`*^9, 
  3.538504467631667*^9}, {3.538985892124278*^9, 3.538985994625936*^9}, {
  3.538986027757465*^9, 3.5389860283252296`*^9}, {3.538986835591592*^9, 
  3.538986835671126*^9}, {3.538999265602706*^9, 3.538999328993082*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", "z_", "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{"3", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        FractionBox["1", "4"], 
        RowBox[{"q", "^", "2"}]}]}], ")"}], " ", 
     RowBox[{"z", "^", "3"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", "z_", "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.538985584177477*^9, 3.538985599024313*^9}, {
   3.53898566037003*^9, 3.538985663298764*^9}, {3.538985694375431*^9, 
   3.538985752536989*^9}, 3.538985795674563*^9, 3.538986011486863*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"T", "'"}], "[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.543856049182849*^9, 3.5438560548742228`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], "+", 
  FractionBox[
   SuperscriptBox["q", "2"], "4"]}]], "Output",
 CellChangeTimes->{{3.543856051516691*^9, 3.54385605529211*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     FractionBox[
      SuperscriptBox["q", "2"], "4"]}], "\[Equal]", "0"}], ",", "q"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.54385607503798*^9, 3.543856082329897*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SqrtBox["3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", 
     RowBox[{"2", " ", 
      SqrtBox["3"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.543856082831293*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"2", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5438560862931547`*^9, 3.5438560893374767`*^9}}],

Cell[BoxData["3.4641016151377544`"], "Output",
 CellChangeTimes->{3.54385608983809*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"aval", "=", 
   RowBox[{"a", "[", "0", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538503869006027*^9, 3.538503871118003*^9}, {
  3.538504557033042*^9, 3.538504557751896*^9}, {3.538985779939569*^9, 
  3.538985810144496*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", "3.05"}], ";"}]], "Input",
 CellChangeTimes->{{3.5389867796132174`*^9, 3.538986782685376*^9}, {
  3.543749500757925*^9, 3.543749501435857*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"file", " ", "=", " ", 
    RowBox[{"OpenWrite", "[", 
     RowBox[{"\"\<~/Work/AdSCMTDyn3/matlab/init.dat\>\"", ",", " ", 
      RowBox[{"BinaryFormat", " ", "\[Rule]", " ", "True"}]}], "]"}]}], ";"}],
   "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "file", "]"}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{"  ", 
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", "aval", ",", " ", "\"\<Real64\>\""}], "]"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\n", "  ", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"plist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"hlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"alist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"Tlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"Slist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", " ", "1", ",", " ", "NR"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.5385020074997997`*^9, 3.538502020253977*^9}, {
   3.538502054087071*^9, 3.5385021529179296`*^9}, {3.538504511144497*^9, 
   3.538504585717393*^9}, {3.538504623909217*^9, 3.5385046463399553`*^9}, {
   3.538726443406577*^9, 3.538726445469967*^9}, {3.5389858674047813`*^9, 
   3.538985868491022*^9}, 3.543734330538042*^9}],

Cell[BoxData["aval"], "Input",
 CellChangeTimes->{{3.538727363712104*^9, 3.538727364132785*^9}, {
  3.538727421558289*^9, 3.5387274460290956`*^9}}],

Cell[BoxData["NR"], "Input",
 CellChangeTimes->{{3.538727377866576*^9, 3.538727377933123*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", "\[Epsilon]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", "z_", "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{"3", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"m", " ", 
     RowBox[{"z", "^", "3"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", "z_", "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.538985584177477*^9, 3.538985599024313*^9}, {
   3.53898566037003*^9, 3.538985663298764*^9}, {3.538985694375431*^9, 
   3.538985752536989*^9}, 3.538985795674563*^9, {3.5437500541453943`*^9, 
   3.543750078325849*^9}, {3.543750150584614*^9, 3.5437501564071293`*^9}, {
   3.543750187672286*^9, 3.5437502107664747`*^9}, {3.543750291367196*^9, 
   3.543750307126504*^9}}],

Cell[BoxData[
 RowBox[{"T", "[", "zh", "]"}]], "Input",
 CellChangeTimes->{{3.538985754767921*^9, 3.5389857560546093`*^9}, {
  3.543750221565905*^9, 3.5437502487476*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", "eqlist", "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"\[Epsilon]", "\[Rule]", "0"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5389856530849533`*^9, 3.538985700420933*^9}, {
  3.538985764598106*^9, 3.5389857663737926`*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"a", "[", "z", "]"}], "-", 
      RowBox[{"a", "[", "0", "]"}]}], "z"], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"q", "\[Rule]", "3.05"}], ",", 
      RowBox[{"m", "\[Rule]", "0"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.543750351519446*^9, 3.5437503743583717`*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "z", "]"}], "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"q", "\[Rule]", "3.05"}], ",", 
      RowBox[{"m", "\[Rule]", "4.5"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.543750413519299*^9, 3.543750517452866*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{
        RowBox[{"T", "[", "z", "]"}], "-", "1"}], 
       RowBox[{"z", "^", "2"}]], ")"}], "z"], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"q", "\[Rule]", "3.05"}], ",", 
      RowBox[{"m", "\[Rule]", "4.5"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "5"}], ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.543749538683271*^9, 3.543749603108762*^9}, {
  3.543750322598619*^9, 3.543750336989295*^9}, {3.543750527519599*^9, 
  3.543750550461568*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plist", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", "z"], 
         RowBox[{"p", "[", "z", "]"}]}], "/.", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hlist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", "z"], 
          RowBox[{"h", "[", "z", "]"}]}], "/.", 
         RowBox[{"z", "\[Rule]", 
          RowBox[{"ChebR", "[", 
           RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"alist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", "z"], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "[", "z", "]"}], "-", "aval"}], ")"}]}], "/.", 
         RowBox[{"z", "\[Rule]", 
          RowBox[{"ChebR", "[", 
           RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tlist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", 
           RowBox[{"z", "^", "2"}]], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"T", "[", "z", "]"}], "-", "1"}], ")"}]}], "/.", 
         RowBox[{"z", "\[Rule]", 
          RowBox[{"ChebR", "[", 
           RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Slist", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", 
          RowBox[{"z", "^", "2"}]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"S", "[", "z", "]"}], "-", "1"}], ")"}]}], "/.", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "2", ",", "NR"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.538502159684472*^9, 3.538502221978693*^9}, {
  3.538503165035289*^9, 3.538503299421774*^9}, {3.5385033330026503`*^9, 
  3.5385033914641247`*^9}, {3.5385034512324057`*^9, 3.538503487889101*^9}, {
  3.538503647371841*^9, 3.538503649375634*^9}, {3.538503718913886*^9, 
  3.538503801543604*^9}, {3.538503905800393*^9, 3.538503951275783*^9}, {
  3.538504241391078*^9, 3.53850425647017*^9}, {3.5385044634506683`*^9, 
  3.538504467631667*^9}, {3.538985892124278*^9, 3.538985994625936*^9}, {
  3.538986027757465*^9, 3.5389860283252296`*^9}, {3.538986835591592*^9, 
  3.538986835671126*^9}, {3.538999265602706*^9, 3.538999328993082*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", "z_", "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{"3", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"m", " ", 
     RowBox[{"z", "^", "3"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", "z_", "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.538985584177477*^9, 3.538985599024313*^9}, {
   3.53898566037003*^9, 3.538985663298764*^9}, {3.538985694375431*^9, 
   3.538985752536989*^9}, 3.538985795674563*^9, 3.538986011486863*^9, {
   3.54375228922278*^9, 3.543752289606523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"aval", "=", 
   RowBox[{"a", "[", "0", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538503869006027*^9, 3.538503871118003*^9}, {
  3.538504557033042*^9, 3.538504557751896*^9}, {3.538985779939569*^9, 
  3.538985810144496*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"q", "=", "3.05"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", "=", "4.5"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5389867796132174`*^9, 3.538986782685376*^9}, {
  3.543749500757925*^9, 3.543749501435857*^9}, {3.543752292948531*^9, 
  3.543752314067997*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"file", " ", "=", " ", 
    RowBox[{"OpenWrite", "[", 
     RowBox[{"\"\<~/Work/AdSCMTDyn3/matlab/init.dat\>\"", ",", " ", 
      RowBox[{"BinaryFormat", " ", "\[Rule]", " ", "True"}]}], "]"}]}], ";"}],
   "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "file", "]"}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{"  ", 
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", "aval", ",", " ", "\"\<Real64\>\""}], "]"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\n", "  ", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"plist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"hlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"alist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"Tlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file", ",", " ", 
        RowBox[{"Slist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", " ", "\"\<Real64\>\""}], "]"}],
       ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", " ", "1", ",", " ", "NR"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.5385020074997997`*^9, 3.538502020253977*^9}, {
   3.538502054087071*^9, 3.5385021529179296`*^9}, {3.538504511144497*^9, 
   3.538504585717393*^9}, {3.538504623909217*^9, 3.5385046463399553`*^9}, {
   3.538726443406577*^9, 3.538726445469967*^9}, {3.5389858674047813`*^9, 
   3.538985868491022*^9}, 3.543734330538042*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1188, 767},
WindowMargins->{{Automatic, 56}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "calcgeom"->{
  Cell[29737, 771, 306, 9, 73, "Input",
   CellTags->"calcgeom"],
  Cell[30046, 782, 293, 10, 73, "Input",
   CellTags->"calcgeom"],
  Cell[30342, 794, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[30609, 805, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[30876, 816, 3551, 100, 139, "Input",
   CellTags->"calcgeom"],
  Cell[34430, 918, 155, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[34792, 930, 5599, 153, 178, "Input",
   CellTags->"calcgeom"],
  Cell[40394, 1085, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[40539, 1091, 1615, 48, 88, "Input",
   CellTags->"calcgeom"],
  Cell[42157, 1141, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[42302, 1147, 633, 22, 27, "Input",
   CellTags->"calcgeom"],
  Cell[42938, 1171, 1648, 51, 113, "Input",
   CellTags->"calcgeom"],
  Cell[44589, 1224, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[44734, 1230, 145, 4, 27, "Input",
   CellTags->"calcgeom"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"calcgeom", 779583, 19564}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 664, 8, 46, "Subtitle"],
Cell[1246, 32, 68, 1, 27, "Input"],
Cell[CellGroupData[{
Cell[1339, 37, 111, 1, 26, "Subsubtitle"],
Cell[1453, 40, 95, 2, 27, "Input"],
Cell[1551, 44, 279, 8, 58, "Input"],
Cell[1833, 54, 266, 9, 58, "Input"],
Cell[2102, 65, 407, 13, 27, "Input"],
Cell[2512, 80, 37, 0, 27, "Input"],
Cell[2552, 82, 257, 8, 58, "Input"],
Cell[2812, 92, 2020, 62, 103, "Input"],
Cell[4835, 156, 26, 0, 27, "Input"],
Cell[4864, 158, 841, 25, 43, "Input"],
Cell[5708, 185, 1026, 31, 58, "Input"],
Cell[6737, 218, 227, 8, 86, "Text"],
Cell[6967, 228, 4015, 95, 238, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[11019, 328, 111, 3, 26, "Subsubtitle"],
Cell[11133, 333, 128, 4, 26, "Text"],
Cell[11264, 339, 6139, 139, 718, "Input"],
Cell[17406, 480, 68, 1, 26, "Text"],
Cell[17477, 483, 3727, 84, 523, "Input"],
Cell[21207, 569, 824, 18, 208, "Input"],
Cell[22034, 589, 4051, 89, 583, "Input"],
Cell[26088, 680, 99, 2, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[26224, 687, 34, 0, 26, "Subsubtitle"],
Cell[26261, 689, 3220, 66, 173, "Input"],
Cell[29484, 757, 28, 0, 27, "Input"],
Cell[29515, 759, 28, 0, 27, "Input"],
Cell[29546, 761, 119, 3, 27, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29702, 769, 32, 0, 26, "Subsubtitle"],
Cell[29737, 771, 306, 9, 73, "Input",
 CellTags->"calcgeom"],
Cell[30046, 782, 293, 10, 73, "Input",
 CellTags->"calcgeom"],
Cell[30342, 794, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[30609, 805, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[30876, 816, 3551, 100, 139, "Input",
 CellTags->"calcgeom"],
Cell[34430, 918, 155, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[34588, 924, 201, 4, 27, "Input"],
Cell[34792, 930, 5599, 153, 178, "Input",
 CellTags->"calcgeom"],
Cell[40394, 1085, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[40539, 1091, 1615, 48, 88, "Input",
 CellTags->"calcgeom"],
Cell[42157, 1141, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[42302, 1147, 633, 22, 27, "Input",
 CellTags->"calcgeom"],
Cell[42938, 1171, 1648, 51, 113, "Input",
 CellTags->"calcgeom"],
Cell[44589, 1224, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[44734, 1230, 145, 4, 27, "Input",
 CellTags->"calcgeom"]
}, Closed]],
Cell[CellGroupData[{
Cell[44916, 1239, 41, 0, 26, "Subsubtitle"],
Cell[44960, 1241, 173, 4, 27, "Input"],
Cell[45136, 1247, 645, 21, 27, "Input"],
Cell[45784, 1270, 1146, 34, 118, "Input"],
Cell[46933, 1306, 1792, 51, 118, "Input"],
Cell[48728, 1359, 710, 23, 58, "Input"],
Cell[49441, 1384, 3424, 95, 238, "Input"],
Cell[52868, 1481, 388, 12, 27, "Input"],
Cell[53259, 1495, 434, 10, 27, "Input"],
Cell[53696, 1507, 462, 11, 46, "Input"],
Cell[54161, 1520, 4135, 133, 141, "Input"],
Cell[58299, 1655, 6843, 214, 199, "Input"],
Cell[65145, 1871, 237, 5, 27, "Input"],
Cell[65385, 1878, 3999, 129, 141, "Input"],
Cell[69387, 2009, 1262, 33, 148, "Input"],
Cell[70652, 2044, 1027, 21, 58, "Input"],
Cell[71682, 2067, 677, 17, 58, "Input"],
Cell[72362, 2086, 1027, 30, 118, "Input"],
Cell[73392, 2118, 161, 3, 27, "Input"],
Cell[73556, 2123, 745, 18, 88, "Input"],
Cell[74304, 2143, 1146, 32, 238, "Input"],
Cell[75453, 2177, 2030, 59, 33, "Input"],
Cell[77486, 2238, 1339, 40, 33, "Input"],
Cell[78828, 2280, 1074, 32, 88, "Input"],
Cell[79905, 2314, 579, 15, 58, "Input"],
Cell[80487, 2331, 1861, 66, 105, "Input"],
Cell[82351, 2399, 2996, 109, 177, "Input"],
Cell[85350, 2510, 949, 30, 148, "Input"],
Cell[86302, 2542, 1224, 33, 238, "Input"],
Cell[87529, 2577, 929, 26, 27, "Input"],
Cell[88461, 2605, 129, 2, 27, "Input"],
Cell[88593, 2609, 129, 2, 27, "Input"],
Cell[88725, 2613, 129, 2, 27, "Input"],
Cell[88857, 2617, 641, 18, 27, "Input"],
Cell[89501, 2637, 160, 3, 27, "Input"],
Cell[89664, 2642, 699, 22, 83, "Input"],
Cell[90366, 2666, 835, 26, 106, "Input"],
Cell[91204, 2694, 281, 5, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[91522, 2704, 111, 1, 26, "Subsubtitle"],
Cell[91636, 2707, 5196, 153, 148, "Input"],
Cell[96835, 2862, 2758, 74, 328, "Input"],
Cell[99596, 2938, 155, 4, 27, "Input"],
Cell[99754, 2944, 970, 27, 148, "Input"],
Cell[100727, 2973, 1178, 31, 148, "Input"],
Cell[101908, 3006, 1196, 32, 148, "Input"],
Cell[103107, 3040, 1247, 33, 148, "Input"],
Cell[104357, 3075, 1005, 29, 148, "Input"],
Cell[105365, 3106, 1002, 29, 148, "Input"],
Cell[106370, 3137, 1052, 30, 148, "Input"],
Cell[107425, 3169, 1005, 29, 148, "Input"],
Cell[108433, 3200, 1011, 29, 148, "Input"],
Cell[109447, 3231, 1013, 29, 148, "Input"],
Cell[110463, 3262, 1013, 29, 148, "Input"],
Cell[111479, 3293, 162, 3, 27, "Input"],
Cell[111644, 3298, 148, 3, 27, "Input"],
Cell[111795, 3303, 124, 3, 27, "Input"],
Cell[111922, 3308, 123, 3, 27, "Input"],
Cell[112048, 3313, 82, 2, 27, "Input"],
Cell[112133, 3317, 126, 3, 27, "Input"],
Cell[112262, 3322, 179, 3, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[112478, 3330, 159, 2, 26, "Subsubtitle"],
Cell[112640, 3334, 181, 3, 27, "Input"],
Cell[112824, 3339, 2714, 71, 328, "Input"],
Cell[115541, 3412, 4166, 142, 148, "Input"],
Cell[119710, 3556, 255, 6, 27, "Input"],
Cell[119968, 3564, 1183, 31, 148, "Input"],
Cell[121154, 3597, 1005, 29, 148, "Input"],
Cell[122162, 3628, 1003, 29, 148, "Input"],
Cell[123168, 3659, 1054, 30, 148, "Input"],
Cell[124225, 3691, 1056, 30, 148, "Input"],
Cell[125284, 3723, 1054, 30, 148, "Input"],
Cell[126341, 3755, 150, 3, 27, "Input"],
Cell[126494, 3760, 124, 3, 27, "Input"],
Cell[126621, 3765, 124, 3, 27, "Input"],
Cell[126748, 3770, 82, 2, 27, "Input"],
Cell[126833, 3774, 124, 3, 27, "Input"],
Cell[126960, 3779, 179, 3, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[127176, 3787, 117, 1, 26, "Subsubtitle"],
Cell[127296, 3790, 563, 17, 27, "Input"],
Cell[127862, 3809, 127, 2, 27, "Input"],
Cell[127992, 3813, 157, 3, 27, "Input"],
Cell[128152, 3818, 958, 27, 27, "Input"],
Cell[129113, 3847, 1230, 35, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[130380, 3887, 157, 2, 26, "Subsubtitle"],
Cell[130540, 3891, 856, 22, 58, "Input"],
Cell[131399, 3915, 197438, 4848, 4197, "Input"],
Cell[328840, 8765, 53300, 1451, 1605, "Input"],
Cell[382143, 10218, 17271, 442, 328, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[399451, 10665, 99, 1, 26, "Subsubtitle"],
Cell[399553, 10668, 23141, 527, 1768, "Input"],
Cell[CellGroupData[{
Cell[422719, 11199, 184, 2, 27, "Input"],
Cell[422906, 11203, 163, 2, 27, "Output"]
}, Open  ]],
Cell[423084, 11208, 803, 26, 116, "Input"],
Cell[CellGroupData[{
Cell[423912, 11238, 416, 12, 58, "Input"],
Cell[424331, 11252, 70, 1, 27, "Output"],
Cell[424404, 11255, 138, 4, 49, "Output"]
}, Open  ]],
Cell[424557, 11262, 157, 3, 27, "Input"],
Cell[CellGroupData[{
Cell[424739, 11269, 745, 19, 52, "Input"],
Cell[425487, 11290, 542, 11, 23, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[426066, 11306, 771, 23, 88, "Input"],
Cell[426840, 11331, 9121, 156, 241, "Output"]
}, Open  ]],
Cell[435976, 11490, 69, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[436070, 11496, 1349, 38, 85, "Input"],
Cell[437422, 11536, 540, 11, 23, "Message"],
Cell[437965, 11549, 540, 11, 23, "Message"],
Cell[438508, 11562, 540, 11, 23, "Message"],
Cell[439051, 11575, 528, 11, 23, "Message"],
Cell[439582, 11588, 633, 15, 33, "Output"],
Cell[440218, 11605, 416, 9, 33, "Output"]
}, Open  ]],
Cell[440649, 11617, 337, 6, 27, "Input"],
Cell[440989, 11625, 758, 19, 52, "Input"],
Cell[CellGroupData[{
Cell[441772, 11648, 5289, 134, 448, "Input"],
Cell[447064, 11784, 540, 11, 23, "Message"],
Cell[447607, 11797, 540, 11, 23, "Message"],
Cell[448150, 11810, 540, 11, 23, "Message"],
Cell[448693, 11823, 542, 11, 23, "Message"],
Cell[449238, 11836, 530, 11, 23, "Message"],
Cell[CellGroupData[{
Cell[449793, 11851, 226, 5, 20, "Print"],
Cell[450022, 11858, 1428, 30, 46, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[451499, 11894, 6963, 158, 678, "Input"],
Cell[458465, 12054, 540, 11, 23, "Message"],
Cell[459008, 12067, 540, 11, 23, "Message"],
Cell[459551, 12080, 540, 11, 23, "Message"],
Cell[460094, 12093, 530, 11, 23, "Message"],
Cell[CellGroupData[{
Cell[460649, 12108, 801, 16, 81, "Print"],
Cell[461453, 12126, 793, 16, 81, "Print"],
Cell[462249, 12144, 824, 17, 81, "Print"],
Cell[463076, 12163, 798, 16, 81, "Print"],
Cell[463877, 12181, 801, 17, 81, "Print"],
Cell[464681, 12200, 798, 16, 81, "Print"],
Cell[465482, 12218, 823, 17, 81, "Print"],
Cell[466308, 12237, 802, 17, 81, "Print"],
Cell[467113, 12256, 808, 17, 81, "Print"],
Cell[467924, 12275, 796, 16, 81, "Print"],
Cell[468723, 12293, 795, 16, 81, "Print"],
Cell[469521, 12311, 832, 17, 81, "Print"],
Cell[470356, 12330, 839, 17, 81, "Print"],
Cell[471198, 12349, 828, 17, 81, "Print"],
Cell[472029, 12368, 833, 17, 81, "Print"],
Cell[472865, 12387, 805, 17, 81, "Print"],
Cell[473673, 12406, 828, 17, 81, "Print"],
Cell[474504, 12425, 827, 17, 81, "Print"],
Cell[475334, 12444, 823, 17, 81, "Print"],
Cell[476160, 12463, 797, 16, 81, "Print"],
Cell[476960, 12481, 803, 17, 81, "Print"],
Cell[477766, 12500, 800, 16, 81, "Print"],
Cell[478569, 12518, 840, 17, 81, "Print"],
Cell[479412, 12537, 829, 17, 81, "Print"],
Cell[480244, 12556, 835, 17, 81, "Print"],
Cell[481082, 12575, 803, 16, 81, "Print"],
Cell[481888, 12593, 800, 16, 81, "Print"],
Cell[482691, 12611, 841, 17, 81, "Print"],
Cell[483535, 12630, 832, 17, 81, "Print"],
Cell[484370, 12649, 844, 17, 81, "Print"],
Cell[485217, 12668, 799, 16, 81, "Print"],
Cell[486019, 12686, 797, 16, 81, "Print"],
Cell[486819, 12704, 835, 17, 81, "Print"]
}, Open  ]]
}, Open  ]],
Cell[487681, 12725, 431, 7, 27, "Input"],
Cell[488115, 12734, 807, 20, 52, "Input"],
Cell[CellGroupData[{
Cell[488947, 12758, 5341, 135, 448, "Input"],
Cell[494291, 12895, 540, 11, 23, "Message"],
Cell[494834, 12908, 540, 11, 23, "Message"],
Cell[495377, 12921, 540, 11, 23, "Message"],
Cell[495920, 12934, 532, 11, 23, "Message"],
Cell[CellGroupData[{
Cell[496477, 12949, 256, 6, 23, "Print"],
Cell[496736, 12957, 1310, 27, 46, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[498095, 12990, 132, 2, 27, "Input"],
Cell[498230, 12994, 750, 16, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[499017, 13015, 185, 4, 27, "Input"],
Cell[499205, 13021, 748, 16, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[499990, 13042, 227, 6, 27, "Input"],
Cell[500220, 13050, 449, 9, 33, "Output"]
}, Open  ]],
Cell[500684, 13062, 590, 13, 43, "Input"],
Cell[CellGroupData[{
Cell[501299, 13079, 148, 3, 27, "Input"],
Cell[501450, 13084, 368, 8, 33, "Output"]
}, Open  ]],
Cell[501833, 13095, 385, 7, 58, "Input"],
Cell[502221, 13104, 363, 9, 27, "Input"],
Cell[502587, 13115, 626, 10, 27, "Input"],
Cell[503216, 13127, 1062, 24, 52, "Input"],
Cell[CellGroupData[{
Cell[504303, 13155, 5341, 135, 448, "Input"],
Cell[509647, 13292, 540, 11, 23, "Message"],
Cell[510190, 13305, 540, 11, 23, "Message"],
Cell[510733, 13318, 540, 11, 23, "Message"],
Cell[511276, 13331, 532, 11, 23, "Message"],
Cell[CellGroupData[{
Cell[511833, 13346, 251, 6, 23, "Print"],
Cell[512087, 13354, 1374, 28, 36, "Print"]
}, Open  ]]
}, Open  ]],
Cell[513488, 13386, 475, 10, 43, "Input"],
Cell[513966, 13398, 69, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[514060, 13404, 1693, 50, 73, "Input"],
Cell[515756, 13456, 646, 15, 27, "Output"],
Cell[516405, 13473, 473, 10, 26, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[516915, 13488, 1266, 39, 88, "Input"],
Cell[518184, 13529, 6030, 106, 237, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[524251, 13640, 771, 23, 88, "Input"],
Cell[525025, 13665, 12665, 214, 227, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[537727, 13884, 769, 23, 88, "Input"],
Cell[538499, 13909, 15507, 262, 225, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[554043, 14176, 771, 23, 88, "Input"],
Cell[554817, 14201, 8800, 152, 241, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[563654, 14358, 768, 23, 88, "Input"],
Cell[564425, 14383, 3837, 70, 243, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[568299, 14458, 771, 23, 88, "Input"],
Cell[569073, 14483, 9902, 170, 235, "Output"]
}, Open  ]],
Cell[578990, 14656, 523, 14, 58, "Input"],
Cell[CellGroupData[{
Cell[579538, 14674, 5666, 137, 523, "Input"],
Cell[585207, 14813, 1017, 21, 70, "Print"],
Cell[586227, 14836, 587, 12, 23, "Message"],
Cell[586817, 14850, 589, 12, 23, "Message"],
Cell[587409, 14864, 589, 12, 23, "Message"],
Cell[588001, 14878, 579, 12, 23, "Message"],
Cell[CellGroupData[{
Cell[588605, 14894, 1016, 21, 70, "Print"],
Cell[589624, 14917, 1022, 21, 70, "Print"],
Cell[590649, 14940, 1017, 21, 70, "Print"]
}, Open  ]],
Cell[591681, 14964, 616, 13, 23, "Message"],
Cell[592300, 14979, 616, 13, 23, "Message"],
Cell[592919, 14994, 618, 13, 23, "Message"],
Cell[593540, 15009, 591, 12, 23, "Message"],
Cell[CellGroupData[{
Cell[594156, 15025, 769, 16, 20, "Print"],
Cell[594928, 15043, 1024, 21, 70, "Print"],
Cell[595955, 15066, 766, 16, 20, "Print"],
Cell[596724, 15084, 1008, 21, 70, "Print"],
Cell[597735, 15107, 761, 16, 20, "Print"],
Cell[598499, 15125, 1015, 21, 70, "Print"],
Cell[599517, 15148, 766, 16, 20, "Print"],
Cell[600286, 15166, 1016, 21, 70, "Print"],
Cell[601305, 15189, 766, 16, 20, "Print"],
Cell[602074, 15207, 1019, 21, 70, "Print"],
Cell[603096, 15230, 767, 16, 20, "Print"],
Cell[603866, 15248, 1025, 21, 70, "Print"],
Cell[604894, 15271, 773, 16, 20, "Print"],
Cell[605670, 15289, 1017, 21, 70, "Print"],
Cell[606690, 15312, 776, 16, 20, "Print"],
Cell[607469, 15330, 1021, 21, 70, "Print"],
Cell[608493, 15353, 771, 16, 20, "Print"],
Cell[609267, 15371, 1026, 21, 70, "Print"],
Cell[610296, 15394, 767, 16, 20, "Print"],
Cell[611066, 15412, 1025, 21, 70, "Print"],
Cell[612094, 15435, 771, 16, 20, "Print"]
}, Open  ]],
Cell[612880, 15454, 735, 14, 40, "Message"],
Cell[CellGroupData[{
Cell[613640, 15472, 127, 2, 20, "Print"],
Cell[613770, 15476, 770, 16, 20, "Print"]
}, Open  ]],
Cell[614555, 15495, 737, 14, 40, "Message"],
Cell[CellGroupData[{
Cell[615317, 15513, 127, 2, 20, "Print"],
Cell[615447, 15517, 756, 16, 20, "Print"]
}, Open  ]],
Cell[616218, 15536, 146, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[616401, 15543, 99, 1, 27, "Input"],
Cell[616503, 15546, 5977, 130, 223, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[622517, 15681, 11717, 269, 898, "Input"],
Cell[634237, 15952, 592, 12, 23, "Message"],
Cell[634832, 15966, 592, 12, 23, "Message"],
Cell[635427, 15980, 592, 12, 23, "Message"],
Cell[636022, 15994, 567, 11, 23, "Message"],
Cell[CellGroupData[{
Cell[636614, 16009, 737, 15, 20, "Print"],
Cell[637354, 16026, 1006, 20, 70, "Print"],
Cell[638363, 16048, 747, 15, 20, "Print"],
Cell[639113, 16065, 1025, 20, 70, "Print"],
Cell[640141, 16087, 739, 15, 20, "Print"]
}, Open  ]],
Cell[640895, 16105, 710, 13, 40, "Message"],
Cell[CellGroupData[{
Cell[641630, 16122, 102, 1, 20, "Print"],
Cell[641735, 16125, 742, 15, 20, "Print"]
}, Open  ]],
Cell[642492, 16143, 710, 13, 40, "Message"],
Cell[CellGroupData[{
Cell[643227, 16160, 999, 20, 70, "Print"],
Cell[644229, 16182, 742, 15, 20, "Print"],
Cell[644974, 16199, 986, 20, 70, "Print"],
Cell[645963, 16221, 754, 15, 20, "Print"]
}, Open  ]],
Cell[646732, 16239, 564, 11, 23, "Message"],
Cell[647299, 16252, 562, 11, 23, "Message"],
Cell[647864, 16265, 564, 11, 23, "Message"],
Cell[648431, 16278, 551, 11, 23, "Message"],
Cell[CellGroupData[{
Cell[649007, 16293, 1029, 20, 70, "Print"],
Cell[650039, 16315, 751, 15, 20, "Print"]
}, Open  ]],
Cell[650805, 16333, 709, 13, 40, "Message"],
Cell[651517, 16348, 556, 11, 23, "Message"],
Cell[CellGroupData[{
Cell[652098, 16363, 104, 1, 20, "Print"],
Cell[652205, 16366, 745, 15, 20, "Print"],
Cell[652953, 16383, 251, 5, 20, "Print"],
Cell[653207, 16390, 251, 5, 20, "Print"],
Cell[653461, 16397, 251, 5, 20, "Print"],
Cell[653715, 16404, 223, 5, 20, "Print"],
Cell[653941, 16411, 251, 5, 20, "Print"],
Cell[654195, 16418, 253, 5, 20, "Print"]
}, Open  ]],
Cell[654463, 16426, 99, 1, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[654599, 16432, 99, 1, 27, "Input"],
Cell[654701, 16435, 8080, 175, 298, "Output"]
}, Open  ]],
Cell[662796, 16613, 323, 9, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[663156, 16627, 167, 2, 26, "Subsubtitle"],
Cell[663326, 16631, 246, 5, 27, "Input"],
Cell[663575, 16638, 23611, 534, 1783, "Input"],
Cell[687189, 17174, 868, 20, 43, "Input"],
Cell[688060, 17196, 475, 10, 43, "Input"],
Cell[688538, 17208, 69, 2, 27, "Input"],
Cell[688610, 17212, 1853, 53, 73, "Input"],
Cell[690466, 17267, 1266, 39, 88, "Input"],
Cell[691735, 17308, 771, 23, 88, "Input"],
Cell[692509, 17333, 769, 23, 88, "Input"],
Cell[693281, 17358, 771, 23, 88, "Input"],
Cell[694055, 17383, 768, 23, 88, "Input"],
Cell[694826, 17408, 771, 23, 88, "Input"],
Cell[695600, 17433, 4339, 107, 448, "Input"],
Cell[699942, 17542, 323, 9, 43, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[700302, 17556, 167, 2, 26, "Subsubtitle"],
Cell[700472, 17560, 394, 7, 27, "Input"],
Cell[700869, 17569, 23926, 542, 1783, "Input"],
Cell[724798, 18113, 648, 15, 27, "Input"],
Cell[725449, 18130, 437, 12, 58, "Input"],
Cell[725889, 18144, 729, 20, 27, "Input"],
Cell[726621, 18166, 130, 2, 27, "Input"],
Cell[726754, 18170, 5499, 138, 448, "Input"],
Cell[732256, 18310, 579, 15, 27, "Input"],
Cell[732838, 18327, 203, 5, 27, "Input"],
Cell[733044, 18334, 1976, 55, 73, "Input"],
Cell[735023, 18391, 536, 12, 58, "Input"],
Cell[735562, 18405, 1235, 27, 79, "Input"],
Cell[736800, 18434, 504, 13, 27, "Input"],
Cell[737307, 18449, 7873, 225, 492, "Input"],
Cell[745183, 18676, 2359, 54, 343, "Input"],
Cell[747545, 18732, 147, 2, 27, "Input"],
Cell[747695, 18736, 94, 1, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[747826, 18742, 210, 3, 26, "Subsubtitle"],
Cell[748039, 18747, 588, 13, 58, "Input"],
Cell[748630, 18762, 1283, 27, 79, "Input"],
Cell[749916, 18791, 295, 6, 27, "Input"],
Cell[750214, 18799, 2828, 58, 169, "Input"],
Cell[753045, 18859, 122, 2, 27, "Input"],
Cell[753170, 18863, 271, 6, 27, "Input"],
Cell[753444, 18871, 179, 3, 27, "Input"],
Cell[753626, 18876, 3622, 105, 235, "Input"],
Cell[757251, 18983, 2841, 58, 169, "Input"],
Cell[CellGroupData[{
Cell[760117, 19045, 176, 4, 27, "Input"],
Cell[760296, 19051, 179, 5, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[760512, 19061, 278, 9, 49, "Input"],
Cell[760793, 19072, 331, 12, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[761161, 19089, 174, 4, 27, "Input"],
Cell[761338, 19095, 87, 1, 27, "Output"]
}, Open  ]],
Cell[761440, 19099, 263, 6, 27, "Input"],
Cell[761706, 19107, 187, 4, 27, "Input"],
Cell[761896, 19113, 2412, 55, 343, "Input"],
Cell[764311, 19170, 147, 2, 27, "Input"],
Cell[764461, 19174, 94, 1, 27, "Input"],
Cell[764558, 19177, 111, 2, 27, "Input"],
Cell[764672, 19181, 2903, 56, 169, "Input"],
Cell[767578, 19239, 170, 3, 27, "Input"],
Cell[767751, 19244, 271, 6, 27, "Input"],
Cell[768025, 19252, 465, 14, 46, "Input"],
Cell[768493, 19268, 482, 14, 27, "Input"],
Cell[768978, 19284, 735, 22, 55, "Input"],
Cell[769716, 19308, 111, 2, 27, "Input"],
Cell[769830, 19312, 3622, 105, 235, "Input"],
Cell[773455, 19419, 2763, 54, 169, "Input"],
Cell[776221, 19475, 263, 6, 27, "Input"],
Cell[776487, 19483, 348, 9, 58, "Input"],
Cell[776838, 19494, 2412, 55, 343, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
