(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   1828713,      33236]
NotebookOptionsPosition[   1812752,      32771]
NotebookOutlinePosition[   1813108,      32787]
CellTagsIndexPosition[   1813065,      32784]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Single analysis", "Subtitle",
 CellChangeTimes->{{3.54427213185037*^9, 3.544272144801621*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<~/Work/AdSCMTDyn2/C/test/\>\"", "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.544249620731719*^9, 3.5442496296828117`*^9}, {
  3.544435547687385*^9, 3.544435570714677*^9}, {3.544435689768095*^9, 
  3.544435690989039*^9}, {3.544435987954439*^9, 3.54443603731295*^9}, {
  3.5444360740980577`*^9, 3.5444360742327433`*^9}, {3.5444371183631287`*^9, 
  3.54443711885909*^9}, {3.5444373455772667`*^9, 3.5444373457442427`*^9}, {
  3.5444597878972054`*^9, 3.544459787955711*^9}, {3.544461980719421*^9, 
  3.544461981157084*^9}, {3.5444620570832787`*^9, 3.5444620572017527`*^9}, {
  3.544462221654078*^9, 3.5444622220776167`*^9}, {3.544506907679791*^9, 
  3.5445069079363213`*^9}, {3.544507074583951*^9, 3.544507074919623*^9}, {
  3.544507297824565*^9, 3.544507297968317*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"param", "=", 
    RowBox[{"Import", "[", 
     RowBox[{"\"\<param.dat\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<output.dat\>\"", ",", "\"\<Real64\>\""}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.544249633815199*^9, 3.544249656358367*^9}, {
  3.54426115396392*^9, 3.54426115789116*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Nz", "=", 
   RowBox[{"Round", "[", 
    RowBox[{"param", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aval", "=", 
   RowBox[{"param", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zarr", "=", 
   RowBox[{"param", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", "+", "1"}], ";;", 
      RowBox[{"2", "+", "Nz"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"param", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", "Nz"}], ")"}], "+", "1"}], ";;", 
         RowBox[{"-", "1"}]}], "]"}], "]"}], ",", "3"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"amplist", "=", 
   RowBox[{"tmp", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"sizelist", "=", 
  RowBox[{"Round", "[", 
   RowBox[{"tmp", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "3"}], "]"}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.544249909424734*^9, 3.544249937894285*^9}, {
   3.544250143442418*^9, 3.544250166410213*^9}, 3.544250631147397*^9, {
   3.544252414987821*^9, 3.544252415283758*^9}, {3.544261162213182*^9, 
   3.544261164237224*^9}, {3.54426135018777*^9, 3.544261398042145*^9}, {
   3.544261660073123*^9, 3.544261663392272*^9}, {3.544264643931826*^9, 
   3.5442646753100233`*^9}, {3.544266744571554*^9, 3.544266748617033*^9}}],

Cell[BoxData["20"], "Output",
 CellChangeTimes->{{3.5442499183976507`*^9, 3.5442499384698877`*^9}, {
   3.5442501398669977`*^9, 3.5442501672354403`*^9}, 3.5442502957700377`*^9, 
   3.544250637773466*^9, 3.5442507094771633`*^9, 3.544250781802022*^9, 
   3.544251159878372*^9, 3.54425216288627*^9, 3.5442523731134577`*^9, 
   3.544252962388048*^9, {3.5442530195220623`*^9, 3.544253048428296*^9}, 
   3.5442540501361837`*^9, 3.5442543166391277`*^9, 3.5442545356162653`*^9, 
   3.544254638651178*^9, {3.54425470498211*^9, 3.544254723602769*^9}, 
   3.544254993928398*^9, 3.544255236670167*^9, 3.544260668975321*^9, {
   3.544261146206197*^9, 3.544261164696176*^9}, 3.5442613390174923`*^9, {
   3.544261375455155*^9, 3.544261398900078*^9}, {3.544261655853136*^9, 
   3.544261663867547*^9}, 3.544264503699563*^9, 3.544264987815494*^9, 
   3.544266749070365*^9, 3.544271072117703*^9, 3.544271565194305*^9, {
   3.5442719343186083`*^9, 3.544271954324626*^9}, {3.544272156041306*^9, 
   3.54427216562106*^9}, 3.5442730865513678`*^9, 3.544273192624209*^9, 
   3.544273383935364*^9, 3.544273636992874*^9, 3.544273738762323*^9, 
   3.544273899943787*^9, 3.544274088041131*^9, 3.54427458341144*^9, 
   3.544274659207849*^9, 3.54427499626544*^9, 3.544275136073146*^9, 
   3.5442833900902576`*^9, 3.544283822236017*^9, 3.544283945690762*^9, 
   3.5442840458537283`*^9, 3.544284136780949*^9, 3.544284312141624*^9, 
   3.5442861420164013`*^9, 3.544286373668755*^9, 3.544286509901107*^9, 
   3.54428692833526*^9, 3.544287553673258*^9, 3.544289053722611*^9, {
   3.544328285142511*^9, 3.5443282906049232`*^9}, 3.544328985865107*^9, 
   3.544329115664673*^9, 3.544329167666418*^9, 3.5443294522583237`*^9, 
   3.544329628385735*^9, 3.544329821459814*^9, 3.5443302738481693`*^9, 
   3.544330340442791*^9, 3.544330658599676*^9, 3.544330824383046*^9, 
   3.544332707604916*^9, 3.5443335947552643`*^9, 3.5443341947127457`*^9, 
   3.544334963115041*^9, 3.544337896818049*^9, 3.544339189833343*^9, 
   3.544339502822447*^9, 3.544339597396871*^9, 3.5443400029290113`*^9, 
   3.544340171693494*^9, 3.5443403480367947`*^9, 3.544340497579769*^9, 
   3.5443405738619833`*^9, 3.544340830364406*^9, 3.544342389275715*^9, 
   3.54434249611801*^9, 3.544345743835802*^9, 3.544345829513599*^9, 
   3.5443462043128347`*^9, 3.5443543341064587`*^9, 3.544354860587192*^9, 
   3.544354898611081*^9, 3.544355039668067*^9, 3.5443554804628563`*^9, 
   3.544355521109187*^9, 3.544355712299831*^9, 3.5443559145950747`*^9, 
   3.544356034195569*^9, 3.544356186659388*^9, 3.544358396246011*^9, 
   3.544359040338685*^9, 3.544359106198886*^9, 3.544359179512034*^9, 
   3.544359421131474*^9, 3.544359604407295*^9, 3.5443602319883842`*^9, 
   3.5443605921471033`*^9, 3.5443607548161497`*^9, 3.544360989731618*^9, 
   3.5443612640692673`*^9, 3.544361376455058*^9, 3.544361473395659*^9, 
   3.544361571103256*^9, 3.544361775408793*^9, 3.544362014066955*^9, 
   3.544425090667138*^9, 3.544425242411268*^9, 3.544425553354845*^9, 
   3.5444257630933113`*^9, {3.544435550895249*^9, 3.544435581129787*^9}, 
   3.5444356943589983`*^9, {3.5444359963637133`*^9, 3.5444360426870127`*^9}, 
   3.5444360826316633`*^9, 3.54443712128195*^9, 3.5444374347932367`*^9, 
   3.54445979734308*^9, 3.544460257245895*^9, 3.544460822117494*^9, 
   3.5444615142497177`*^9, 3.544461663257284*^9, 3.544461986691393*^9, 
   3.544462063087672*^9, 3.5444622287349663`*^9, 3.54450672624396*^9, 
   3.544506947344378*^9, 3.544507045616804*^9, 3.544507085314295*^9, 
   3.544507307303802*^9, 3.5445077885390882`*^9, 3.5445078555699863`*^9, 
   3.544507986676168*^9, 3.544508153572237*^9, 3.5445085056442223`*^9, 
   3.5445090723836*^9, 3.544509597760906*^9, 3.544509737552763*^9, 
   3.544510176942404*^9, 3.5445102701754007`*^9, 3.544510386218804*^9, 
   3.544510522521138*^9, 3.544511337562368*^9, 3.544511638267045*^9, 
   3.544511793369622*^9, 3.544511862171623*^9, 3.544529243253129*^9, 
   3.544529557768116*^9, 3.544529869780107*^9, 3.544614271912402*^9, 
   3.5446146205745277`*^9, 3.544614790176054*^9, {3.544615343490964*^9, 
   3.544615357466679*^9}, 3.544615878603756*^9, 3.54462107961196*^9}],

Cell[BoxData["2.918602687158184`"], "Output",
 CellChangeTimes->{{3.5442499183976507`*^9, 3.5442499384698877`*^9}, {
   3.5442501398669977`*^9, 3.5442501672354403`*^9}, 3.5442502957700377`*^9, 
   3.544250637773466*^9, 3.5442507094771633`*^9, 3.544250781802022*^9, 
   3.544251159878372*^9, 3.54425216288627*^9, 3.5442523731134577`*^9, 
   3.544252962388048*^9, {3.5442530195220623`*^9, 3.544253048428296*^9}, 
   3.5442540501361837`*^9, 3.5442543166391277`*^9, 3.5442545356162653`*^9, 
   3.544254638651178*^9, {3.54425470498211*^9, 3.544254723602769*^9}, 
   3.544254993928398*^9, 3.544255236670167*^9, 3.544260668975321*^9, {
   3.544261146206197*^9, 3.544261164696176*^9}, 3.5442613390174923`*^9, {
   3.544261375455155*^9, 3.544261398900078*^9}, {3.544261655853136*^9, 
   3.544261663867547*^9}, 3.544264503699563*^9, 3.544264987815494*^9, 
   3.544266749070365*^9, 3.544271072117703*^9, 3.544271565194305*^9, {
   3.5442719343186083`*^9, 3.544271954324626*^9}, {3.544272156041306*^9, 
   3.54427216562106*^9}, 3.5442730865513678`*^9, 3.544273192624209*^9, 
   3.544273383935364*^9, 3.544273636992874*^9, 3.544273738762323*^9, 
   3.544273899943787*^9, 3.544274088041131*^9, 3.54427458341144*^9, 
   3.544274659207849*^9, 3.54427499626544*^9, 3.544275136073146*^9, 
   3.5442833900902576`*^9, 3.544283822236017*^9, 3.544283945690762*^9, 
   3.5442840458537283`*^9, 3.544284136780949*^9, 3.544284312141624*^9, 
   3.5442861420164013`*^9, 3.544286373668755*^9, 3.544286509901107*^9, 
   3.54428692833526*^9, 3.544287553673258*^9, 3.544289053722611*^9, {
   3.544328285142511*^9, 3.5443282906049232`*^9}, 3.544328985865107*^9, 
   3.544329115664673*^9, 3.544329167666418*^9, 3.5443294522583237`*^9, 
   3.544329628385735*^9, 3.544329821459814*^9, 3.5443302738481693`*^9, 
   3.544330340442791*^9, 3.544330658599676*^9, 3.544330824383046*^9, 
   3.544332707604916*^9, 3.5443335947552643`*^9, 3.5443341947127457`*^9, 
   3.544334963115041*^9, 3.544337896818049*^9, 3.544339189833343*^9, 
   3.544339502822447*^9, 3.544339597396871*^9, 3.5443400029290113`*^9, 
   3.544340171693494*^9, 3.5443403480367947`*^9, 3.544340497579769*^9, 
   3.5443405738619833`*^9, 3.544340830364406*^9, 3.544342389275715*^9, 
   3.54434249611801*^9, 3.544345743835802*^9, 3.544345829513599*^9, 
   3.5443462043128347`*^9, 3.5443543341064587`*^9, 3.544354860587192*^9, 
   3.544354898611081*^9, 3.544355039668067*^9, 3.5443554804628563`*^9, 
   3.544355521109187*^9, 3.544355712299831*^9, 3.5443559145950747`*^9, 
   3.544356034195569*^9, 3.544356186659388*^9, 3.544358396246011*^9, 
   3.544359040338685*^9, 3.544359106198886*^9, 3.544359179512034*^9, 
   3.544359421131474*^9, 3.544359604407295*^9, 3.5443602319883842`*^9, 
   3.5443605921471033`*^9, 3.5443607548161497`*^9, 3.544360989731618*^9, 
   3.5443612640692673`*^9, 3.544361376455058*^9, 3.544361473395659*^9, 
   3.544361571103256*^9, 3.544361775408793*^9, 3.544362014066955*^9, 
   3.544425090667138*^9, 3.544425242411268*^9, 3.544425553354845*^9, 
   3.5444257630933113`*^9, {3.544435550895249*^9, 3.544435581129787*^9}, 
   3.5444356943589983`*^9, {3.5444359963637133`*^9, 3.5444360426870127`*^9}, 
   3.5444360826316633`*^9, 3.54443712128195*^9, 3.5444374347932367`*^9, 
   3.54445979734308*^9, 3.544460257245895*^9, 3.544460822117494*^9, 
   3.5444615142497177`*^9, 3.544461663257284*^9, 3.544461986691393*^9, 
   3.544462063087672*^9, 3.5444622287349663`*^9, 3.54450672624396*^9, 
   3.544506947344378*^9, 3.544507045616804*^9, 3.544507085314295*^9, 
   3.544507307303802*^9, 3.5445077885390882`*^9, 3.5445078555699863`*^9, 
   3.544507986676168*^9, 3.544508153572237*^9, 3.5445085056442223`*^9, 
   3.5445090723836*^9, 3.544509597760906*^9, 3.544509737552763*^9, 
   3.544510176942404*^9, 3.5445102701754007`*^9, 3.544510386218804*^9, 
   3.544510522521138*^9, 3.544511337562368*^9, 3.544511638267045*^9, 
   3.544511793369622*^9, 3.544511862171623*^9, 3.544529243253129*^9, 
   3.544529557768116*^9, 3.544529869780107*^9, 3.544614271912402*^9, 
   3.5446146205745277`*^9, 3.544614790176054*^9, {3.544615343490964*^9, 
   3.544615357466679*^9}, 3.544615878603756*^9, 3.544621079614538*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.006819348298638839`", ",", "0.027091379149682626`", ",", 
   "0.06026312439675552`", ",", "0.10542974530180327`", ",", 
   "0.16135921418712956`", ",", "0.22652592093878648`", ",", 
   "0.2991522876735153`", ",", "0.37725725642960056`", ",", 
   "0.4587103272638339`", ",", "0.5412896727361662`", ",", 
   "0.6227427435703996`", ",", "0.7008477123264848`", ",", 
   "0.7734740790612135`", ",", "0.8386407858128706`", ",", 
   "0.8945702546981968`", ",", "0.9397368756032445`", ",", 
   "0.9729086208503173`", ",", "0.9931806517013612`", ",", "1.`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5442499183976507`*^9, 3.5442499384698877`*^9}, {
   3.5442501398669977`*^9, 3.5442501672354403`*^9}, 3.5442502957700377`*^9, 
   3.544250637773466*^9, 3.5442507094771633`*^9, 3.544250781802022*^9, 
   3.544251159878372*^9, 3.54425216288627*^9, 3.5442523731134577`*^9, 
   3.544252962388048*^9, {3.5442530195220623`*^9, 3.544253048428296*^9}, 
   3.5442540501361837`*^9, 3.5442543166391277`*^9, 3.5442545356162653`*^9, 
   3.544254638651178*^9, {3.54425470498211*^9, 3.544254723602769*^9}, 
   3.544254993928398*^9, 3.544255236670167*^9, 3.544260668975321*^9, {
   3.544261146206197*^9, 3.544261164696176*^9}, 3.5442613390174923`*^9, {
   3.544261375455155*^9, 3.544261398900078*^9}, {3.544261655853136*^9, 
   3.544261663867547*^9}, 3.544264503699563*^9, 3.544264987815494*^9, 
   3.544266749070365*^9, 3.544271072117703*^9, 3.544271565194305*^9, {
   3.5442719343186083`*^9, 3.544271954324626*^9}, {3.544272156041306*^9, 
   3.54427216562106*^9}, 3.5442730865513678`*^9, 3.544273192624209*^9, 
   3.544273383935364*^9, 3.544273636992874*^9, 3.544273738762323*^9, 
   3.544273899943787*^9, 3.544274088041131*^9, 3.54427458341144*^9, 
   3.544274659207849*^9, 3.54427499626544*^9, 3.544275136073146*^9, 
   3.5442833900902576`*^9, 3.544283822236017*^9, 3.544283945690762*^9, 
   3.5442840458537283`*^9, 3.544284136780949*^9, 3.544284312141624*^9, 
   3.5442861420164013`*^9, 3.544286373668755*^9, 3.544286509901107*^9, 
   3.54428692833526*^9, 3.544287553673258*^9, 3.544289053722611*^9, {
   3.544328285142511*^9, 3.5443282906049232`*^9}, 3.544328985865107*^9, 
   3.544329115664673*^9, 3.544329167666418*^9, 3.5443294522583237`*^9, 
   3.544329628385735*^9, 3.544329821459814*^9, 3.5443302738481693`*^9, 
   3.544330340442791*^9, 3.544330658599676*^9, 3.544330824383046*^9, 
   3.544332707604916*^9, 3.5443335947552643`*^9, 3.5443341947127457`*^9, 
   3.544334963115041*^9, 3.544337896818049*^9, 3.544339189833343*^9, 
   3.544339502822447*^9, 3.544339597396871*^9, 3.5443400029290113`*^9, 
   3.544340171693494*^9, 3.5443403480367947`*^9, 3.544340497579769*^9, 
   3.5443405738619833`*^9, 3.544340830364406*^9, 3.544342389275715*^9, 
   3.54434249611801*^9, 3.544345743835802*^9, 3.544345829513599*^9, 
   3.5443462043128347`*^9, 3.5443543341064587`*^9, 3.544354860587192*^9, 
   3.544354898611081*^9, 3.544355039668067*^9, 3.5443554804628563`*^9, 
   3.544355521109187*^9, 3.544355712299831*^9, 3.5443559145950747`*^9, 
   3.544356034195569*^9, 3.544356186659388*^9, 3.544358396246011*^9, 
   3.544359040338685*^9, 3.544359106198886*^9, 3.544359179512034*^9, 
   3.544359421131474*^9, 3.544359604407295*^9, 3.5443602319883842`*^9, 
   3.5443605921471033`*^9, 3.5443607548161497`*^9, 3.544360989731618*^9, 
   3.5443612640692673`*^9, 3.544361376455058*^9, 3.544361473395659*^9, 
   3.544361571103256*^9, 3.544361775408793*^9, 3.544362014066955*^9, 
   3.544425090667138*^9, 3.544425242411268*^9, 3.544425553354845*^9, 
   3.5444257630933113`*^9, {3.544435550895249*^9, 3.544435581129787*^9}, 
   3.5444356943589983`*^9, {3.5444359963637133`*^9, 3.5444360426870127`*^9}, 
   3.5444360826316633`*^9, 3.54443712128195*^9, 3.5444374347932367`*^9, 
   3.54445979734308*^9, 3.544460257245895*^9, 3.544460822117494*^9, 
   3.5444615142497177`*^9, 3.544461663257284*^9, 3.544461986691393*^9, 
   3.544462063087672*^9, 3.5444622287349663`*^9, 3.54450672624396*^9, 
   3.544506947344378*^9, 3.544507045616804*^9, 3.544507085314295*^9, 
   3.544507307303802*^9, 3.5445077885390882`*^9, 3.5445078555699863`*^9, 
   3.544507986676168*^9, 3.544508153572237*^9, 3.5445085056442223`*^9, 
   3.5445090723836*^9, 3.544509597760906*^9, 3.544509737552763*^9, 
   3.544510176942404*^9, 3.5445102701754007`*^9, 3.544510386218804*^9, 
   3.544510522521138*^9, 3.544511337562368*^9, 3.544511638267045*^9, 
   3.544511793369622*^9, 3.544511862171623*^9, 3.544529243253129*^9, 
   3.544529557768116*^9, 3.544529869780107*^9, 3.544614271912402*^9, 
   3.5446146205745277`*^9, 3.544614790176054*^9, {3.544615343490964*^9, 
   3.544615357466679*^9}, 3.544615878603756*^9, 3.5446210796165113`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"-", "0.35`"}], "}"}]], "Output",
 CellChangeTimes->{{3.5442499183976507`*^9, 3.5442499384698877`*^9}, {
   3.5442501398669977`*^9, 3.5442501672354403`*^9}, 3.5442502957700377`*^9, 
   3.544250637773466*^9, 3.5442507094771633`*^9, 3.544250781802022*^9, 
   3.544251159878372*^9, 3.54425216288627*^9, 3.5442523731134577`*^9, 
   3.544252962388048*^9, {3.5442530195220623`*^9, 3.544253048428296*^9}, 
   3.5442540501361837`*^9, 3.5442543166391277`*^9, 3.5442545356162653`*^9, 
   3.544254638651178*^9, {3.54425470498211*^9, 3.544254723602769*^9}, 
   3.544254993928398*^9, 3.544255236670167*^9, 3.544260668975321*^9, {
   3.544261146206197*^9, 3.544261164696176*^9}, 3.5442613390174923`*^9, {
   3.544261375455155*^9, 3.544261398900078*^9}, {3.544261655853136*^9, 
   3.544261663867547*^9}, 3.544264503699563*^9, 3.544264987815494*^9, 
   3.544266749070365*^9, 3.544271072117703*^9, 3.544271565194305*^9, {
   3.5442719343186083`*^9, 3.544271954324626*^9}, {3.544272156041306*^9, 
   3.54427216562106*^9}, 3.5442730865513678`*^9, 3.544273192624209*^9, 
   3.544273383935364*^9, 3.544273636992874*^9, 3.544273738762323*^9, 
   3.544273899943787*^9, 3.544274088041131*^9, 3.54427458341144*^9, 
   3.544274659207849*^9, 3.54427499626544*^9, 3.544275136073146*^9, 
   3.5442833900902576`*^9, 3.544283822236017*^9, 3.544283945690762*^9, 
   3.5442840458537283`*^9, 3.544284136780949*^9, 3.544284312141624*^9, 
   3.5442861420164013`*^9, 3.544286373668755*^9, 3.544286509901107*^9, 
   3.54428692833526*^9, 3.544287553673258*^9, 3.544289053722611*^9, {
   3.544328285142511*^9, 3.5443282906049232`*^9}, 3.544328985865107*^9, 
   3.544329115664673*^9, 3.544329167666418*^9, 3.5443294522583237`*^9, 
   3.544329628385735*^9, 3.544329821459814*^9, 3.5443302738481693`*^9, 
   3.544330340442791*^9, 3.544330658599676*^9, 3.544330824383046*^9, 
   3.544332707604916*^9, 3.5443335947552643`*^9, 3.5443341947127457`*^9, 
   3.544334963115041*^9, 3.544337896818049*^9, 3.544339189833343*^9, 
   3.544339502822447*^9, 3.544339597396871*^9, 3.5443400029290113`*^9, 
   3.544340171693494*^9, 3.5443403480367947`*^9, 3.544340497579769*^9, 
   3.5443405738619833`*^9, 3.544340830364406*^9, 3.544342389275715*^9, 
   3.54434249611801*^9, 3.544345743835802*^9, 3.544345829513599*^9, 
   3.5443462043128347`*^9, 3.5443543341064587`*^9, 3.544354860587192*^9, 
   3.544354898611081*^9, 3.544355039668067*^9, 3.5443554804628563`*^9, 
   3.544355521109187*^9, 3.544355712299831*^9, 3.5443559145950747`*^9, 
   3.544356034195569*^9, 3.544356186659388*^9, 3.544358396246011*^9, 
   3.544359040338685*^9, 3.544359106198886*^9, 3.544359179512034*^9, 
   3.544359421131474*^9, 3.544359604407295*^9, 3.5443602319883842`*^9, 
   3.5443605921471033`*^9, 3.5443607548161497`*^9, 3.544360989731618*^9, 
   3.5443612640692673`*^9, 3.544361376455058*^9, 3.544361473395659*^9, 
   3.544361571103256*^9, 3.544361775408793*^9, 3.544362014066955*^9, 
   3.544425090667138*^9, 3.544425242411268*^9, 3.544425553354845*^9, 
   3.5444257630933113`*^9, {3.544435550895249*^9, 3.544435581129787*^9}, 
   3.5444356943589983`*^9, {3.5444359963637133`*^9, 3.5444360426870127`*^9}, 
   3.5444360826316633`*^9, 3.54443712128195*^9, 3.5444374347932367`*^9, 
   3.54445979734308*^9, 3.544460257245895*^9, 3.544460822117494*^9, 
   3.5444615142497177`*^9, 3.544461663257284*^9, 3.544461986691393*^9, 
   3.544462063087672*^9, 3.5444622287349663`*^9, 3.54450672624396*^9, 
   3.544506947344378*^9, 3.544507045616804*^9, 3.544507085314295*^9, 
   3.544507307303802*^9, 3.5445077885390882`*^9, 3.5445078555699863`*^9, 
   3.544507986676168*^9, 3.544508153572237*^9, 3.5445085056442223`*^9, 
   3.5445090723836*^9, 3.544509597760906*^9, 3.544509737552763*^9, 
   3.544510176942404*^9, 3.5445102701754007`*^9, 3.544510386218804*^9, 
   3.544510522521138*^9, 3.544511337562368*^9, 3.544511638267045*^9, 
   3.544511793369622*^9, 3.544511862171623*^9, 3.544529243253129*^9, 
   3.544529557768116*^9, 3.544529869780107*^9, 3.544614271912402*^9, 
   3.5446146205745277`*^9, 3.544614790176054*^9, {3.544615343490964*^9, 
   3.544615357466679*^9}, 3.544615878603756*^9, 3.544621079618623*^9}],

Cell[BoxData[
 RowBox[{"{", "199", "}"}]], "Output",
 CellChangeTimes->{{3.5442499183976507`*^9, 3.5442499384698877`*^9}, {
   3.5442501398669977`*^9, 3.5442501672354403`*^9}, 3.5442502957700377`*^9, 
   3.544250637773466*^9, 3.5442507094771633`*^9, 3.544250781802022*^9, 
   3.544251159878372*^9, 3.54425216288627*^9, 3.5442523731134577`*^9, 
   3.544252962388048*^9, {3.5442530195220623`*^9, 3.544253048428296*^9}, 
   3.5442540501361837`*^9, 3.5442543166391277`*^9, 3.5442545356162653`*^9, 
   3.544254638651178*^9, {3.54425470498211*^9, 3.544254723602769*^9}, 
   3.544254993928398*^9, 3.544255236670167*^9, 3.544260668975321*^9, {
   3.544261146206197*^9, 3.544261164696176*^9}, 3.5442613390174923`*^9, {
   3.544261375455155*^9, 3.544261398900078*^9}, {3.544261655853136*^9, 
   3.544261663867547*^9}, 3.544264503699563*^9, 3.544264987815494*^9, 
   3.544266749070365*^9, 3.544271072117703*^9, 3.544271565194305*^9, {
   3.5442719343186083`*^9, 3.544271954324626*^9}, {3.544272156041306*^9, 
   3.54427216562106*^9}, 3.5442730865513678`*^9, 3.544273192624209*^9, 
   3.544273383935364*^9, 3.544273636992874*^9, 3.544273738762323*^9, 
   3.544273899943787*^9, 3.544274088041131*^9, 3.54427458341144*^9, 
   3.544274659207849*^9, 3.54427499626544*^9, 3.544275136073146*^9, 
   3.5442833900902576`*^9, 3.544283822236017*^9, 3.544283945690762*^9, 
   3.5442840458537283`*^9, 3.544284136780949*^9, 3.544284312141624*^9, 
   3.5442861420164013`*^9, 3.544286373668755*^9, 3.544286509901107*^9, 
   3.54428692833526*^9, 3.544287553673258*^9, 3.544289053722611*^9, {
   3.544328285142511*^9, 3.5443282906049232`*^9}, 3.544328985865107*^9, 
   3.544329115664673*^9, 3.544329167666418*^9, 3.5443294522583237`*^9, 
   3.544329628385735*^9, 3.544329821459814*^9, 3.5443302738481693`*^9, 
   3.544330340442791*^9, 3.544330658599676*^9, 3.544330824383046*^9, 
   3.544332707604916*^9, 3.5443335947552643`*^9, 3.5443341947127457`*^9, 
   3.544334963115041*^9, 3.544337896818049*^9, 3.544339189833343*^9, 
   3.544339502822447*^9, 3.544339597396871*^9, 3.5443400029290113`*^9, 
   3.544340171693494*^9, 3.5443403480367947`*^9, 3.544340497579769*^9, 
   3.5443405738619833`*^9, 3.544340830364406*^9, 3.544342389275715*^9, 
   3.54434249611801*^9, 3.544345743835802*^9, 3.544345829513599*^9, 
   3.5443462043128347`*^9, 3.5443543341064587`*^9, 3.544354860587192*^9, 
   3.544354898611081*^9, 3.544355039668067*^9, 3.5443554804628563`*^9, 
   3.544355521109187*^9, 3.544355712299831*^9, 3.5443559145950747`*^9, 
   3.544356034195569*^9, 3.544356186659388*^9, 3.544358396246011*^9, 
   3.544359040338685*^9, 3.544359106198886*^9, 3.544359179512034*^9, 
   3.544359421131474*^9, 3.544359604407295*^9, 3.5443602319883842`*^9, 
   3.5443605921471033`*^9, 3.5443607548161497`*^9, 3.544360989731618*^9, 
   3.5443612640692673`*^9, 3.544361376455058*^9, 3.544361473395659*^9, 
   3.544361571103256*^9, 3.544361775408793*^9, 3.544362014066955*^9, 
   3.544425090667138*^9, 3.544425242411268*^9, 3.544425553354845*^9, 
   3.5444257630933113`*^9, {3.544435550895249*^9, 3.544435581129787*^9}, 
   3.5444356943589983`*^9, {3.5444359963637133`*^9, 3.5444360426870127`*^9}, 
   3.5444360826316633`*^9, 3.54443712128195*^9, 3.5444374347932367`*^9, 
   3.54445979734308*^9, 3.544460257245895*^9, 3.544460822117494*^9, 
   3.5444615142497177`*^9, 3.544461663257284*^9, 3.544461986691393*^9, 
   3.544462063087672*^9, 3.5444622287349663`*^9, 3.54450672624396*^9, 
   3.544506947344378*^9, 3.544507045616804*^9, 3.544507085314295*^9, 
   3.544507307303802*^9, 3.5445077885390882`*^9, 3.5445078555699863`*^9, 
   3.544507986676168*^9, 3.544508153572237*^9, 3.5445085056442223`*^9, 
   3.5445090723836*^9, 3.544509597760906*^9, 3.544509737552763*^9, 
   3.544510176942404*^9, 3.5445102701754007`*^9, 3.544510386218804*^9, 
   3.544510522521138*^9, 3.544511337562368*^9, 3.544511638267045*^9, 
   3.544511793369622*^9, 3.544511862171623*^9, 3.544529243253129*^9, 
   3.544529557768116*^9, 3.544529869780107*^9, 3.544614271912402*^9, 
   3.5446146205745277`*^9, 3.544614790176054*^9, {3.544615343490964*^9, 
   3.544615357466679*^9}, 3.544615878603756*^9, 3.54462107962046*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"size", "=", 
  RowBox[{"Floor", "[", 
   RowBox[{
    RowBox[{"Length", "[", "data", "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"13", "Nz"}]}], ")"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5442724391246243`*^9, 3.544272461406993*^9}, {
  3.544286060300911*^9, 3.54428606037925*^9}}],

Cell[BoxData["199"], "Output",
 CellChangeTimes->{
  3.544272462432069*^9, 3.544273087505825*^9, 3.544273192681161*^9, 
   3.5442733839669333`*^9, 3.5442736370390673`*^9, 3.5442737387961817`*^9, 
   3.544273899979862*^9, 3.544274088078648*^9, 3.5442745834459667`*^9, 
   3.544274659246644*^9, 3.5442749963320217`*^9, 3.544275136111539*^9, 
   3.54428339012388*^9, 3.5442838222720013`*^9, 3.544283945732786*^9, 
   3.5442840459213533`*^9, 3.5442841368169727`*^9, 3.544284312186574*^9, 
   3.5442861420523233`*^9, 3.544286373704117*^9, 3.544286509938397*^9, 
   3.544286928373232*^9, 3.544287553711235*^9, 3.544289053761787*^9, 
   3.5443282921390247`*^9, 3.5443289858976107`*^9, 3.544329115702242*^9, 
   3.544329167707408*^9, 3.544329452323777*^9, 3.544329628439562*^9, 
   3.5443298215335417`*^9, 3.544330273883748*^9, 3.544330340478469*^9, 
   3.5443306586442547`*^9, 3.54433082446314*^9, 3.5443327076401033`*^9, 
   3.544333594791813*^9, 3.544334194748508*^9, 3.544334963153195*^9, 
   3.544337896856441*^9, 3.544339189888494*^9, 3.544339502855702*^9, 
   3.544339597453731*^9, 3.544340002966724*^9, 3.5443401717462273`*^9, 
   3.544340348084983*^9, 3.54434049762184*^9, 3.544340573908002*^9, 
   3.54434083040816*^9, 3.544342389313442*^9, 3.544342496156107*^9, 
   3.544345743870264*^9, 3.544345829550022*^9, 3.544346204365131*^9, 
   3.544354334723269*^9, 3.544354860655925*^9, 3.544354898675653*^9, 
   3.5443550404582376`*^9, 3.544355480499604*^9, 3.5443555211803923`*^9, 
   3.544355712387063*^9, 3.544355914631979*^9, 3.544356034234619*^9, 
   3.544356186696445*^9, 3.544358396284913*^9, 3.544359040376485*^9, 
   3.544359106236302*^9, 3.544359179545986*^9, 3.5443594211703367`*^9, 
   3.544359604445117*^9, 3.544360232032249*^9, 3.544360592201858*^9, 
   3.54436075555758*^9, 3.544360989767816*^9, 3.544361264119089*^9, 
   3.544361376490069*^9, 3.544361473430125*^9, 3.5443615711843157`*^9, 
   3.544361775454084*^9, 3.544362014107218*^9, 3.544425091296648*^9, 
   3.54442524244662*^9, 3.5444255534068727`*^9, 3.544425763131535*^9, {
   3.544435550973867*^9, 3.544435581211602*^9}, 3.544435695044117*^9, {
   3.544435996402478*^9, 3.544436042724716*^9}, 3.5444360826768827`*^9, 
   3.544437122032468*^9, 3.544437434829651*^9, 3.544459799379382*^9, 
   3.544460258080274*^9, 3.5444608233014708`*^9, 3.5444615142860823`*^9, 
   3.54446166329454*^9, 3.5444619867306023`*^9, 3.54446206312915*^9, 
   3.544462228785857*^9, 3.544506726286414*^9, 3.544506947400737*^9, 
   3.5445070456778603`*^9, 3.544507085352295*^9, 3.544507307339635*^9, 
   3.544507788581265*^9, 3.5445078556147747`*^9, 3.544507986721869*^9, 
   3.544508153625111*^9, 3.544508505683958*^9, 3.544509072422022*^9, 
   3.544509597814767*^9, 3.544509737593359*^9, 3.544510176980476*^9, 
   3.544510270212658*^9, 3.544510386302374*^9, 3.544510522572699*^9, 
   3.5445113376186037`*^9, 3.544511638305723*^9, 3.544511793409451*^9, 
   3.544511862213736*^9, 3.544529243292617*^9, 3.5445295578070498`*^9, 
   3.544529869816865*^9, 3.54461427195063*^9, 3.544614620685446*^9, 
   3.5446147902324953`*^9, {3.5446153435284557`*^9, 3.5446153575060873`*^9}, 
   3.544615878640396*^9, 3.544621079667835*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{"1", ";;", 
        RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"13", "*", "Nz"}]}], ")"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.544265027772296*^9, 3.5442650316110067`*^9}, {
  3.544286062011446*^9, 3.544286062156925*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "data2", "]"}]], "Input",
 CellChangeTimes->{{3.5442650343341837`*^9, 3.5442650371861267`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"199", ",", "261"}], "}"}]], "Output",
 CellChangeTimes->{
  3.544265037582234*^9, 3.5442667509390697`*^9, 3.5442668452397614`*^9, 
   3.544271074719507*^9, 3.54427156526289*^9, {3.544271934384033*^9, 
   3.544271955223679*^9}, 3.544272169079645*^9, 3.544273088988155*^9, 
   3.544273192725354*^9, 3.54427338403494*^9, 3.544273637093014*^9, 
   3.544273738862651*^9, 3.5442739000258017`*^9, 3.544274088124825*^9, 
   3.544274583524803*^9, 3.544274659309164*^9, 3.544274996403022*^9, 
   3.544275136176087*^9, 3.5442833901892233`*^9, 3.5442838223360157`*^9, 
   3.5442839458057547`*^9, 3.5442840460060997`*^9, 3.5442841368829823`*^9, 
   3.544284312300151*^9, 3.544286142119012*^9, 3.544286373768735*^9, 
   3.544286510001648*^9, 3.5442869284379787`*^9, 3.5442875537573643`*^9, 
   3.5442890538254423`*^9, 3.5443289859463243`*^9, 3.544329115750882*^9, 
   3.544329167767501*^9, 3.5443294523781223`*^9, 3.544329628504333*^9, 
   3.544329821578573*^9, 3.544330273952612*^9, 3.5443303405502996`*^9, 
   3.5443306587242928`*^9, 3.544330824509037*^9, 3.5443327076877947`*^9, 
   3.544333594873126*^9, 3.544334194830474*^9, 3.544334963214581*^9, 
   3.544337896917053*^9, 3.5443391899572763`*^9, 3.544339502922967*^9, 
   3.544339597547091*^9, 3.544340003032775*^9, 3.544340171812305*^9, 
   3.54434034813894*^9, 3.5443404976802073`*^9, 3.5443405739789877`*^9, 
   3.544340830467495*^9, 3.5443423893788137`*^9, 3.54434249620196*^9, 
   3.544345743951446*^9, 3.544345829601165*^9, 3.544346204429501*^9, 
   3.544354336026455*^9, 3.544354860700945*^9, 3.5443548987848997`*^9, 
   3.544355042144566*^9, 3.54435548056584*^9, 3.544355521242152*^9, 
   3.5443557124901943`*^9, 3.544355914697506*^9, 3.5443560342978077`*^9, 
   3.544356186760435*^9, 3.544358396345594*^9, 3.544359040420638*^9, 
   3.544359106299368*^9, 3.544359179611315*^9, 3.544359421231509*^9, 
   3.544359604489767*^9, 3.544360232101815*^9, 3.5443605922709618`*^9, 
   3.544360756925572*^9, 3.544360989816024*^9, 3.544361264183609*^9, 
   3.5443613765573263`*^9, 3.5443614734769077`*^9, 3.544361571251211*^9, 
   3.54436177551978*^9, 3.5443620141686974`*^9, 3.544425092532946*^9, 
   3.544425242512298*^9, 3.544425553469404*^9, 3.544425763195756*^9, {
   3.5444355510667543`*^9, 3.544435581323126*^9}, 3.544435696144884*^9, {
   3.54443599647108*^9, 3.544436042786799*^9}, 3.5444360827501707`*^9, 
   3.54443712333282*^9, 3.544437434878253*^9, 3.544459801079196*^9, 
   3.544460260498631*^9, 3.544460824902337*^9, 3.5444615143501673`*^9, 
   3.5444616634084883`*^9, 3.544461986839404*^9, 3.54446206322678*^9, 
   3.544462228848814*^9, 3.544506726360859*^9, 3.5445069474771233`*^9, 
   3.544507045773139*^9, 3.544507085423746*^9, 3.544507307418157*^9, 
   3.54450778863878*^9, 3.5445078556867847`*^9, 3.544507986792777*^9, 
   3.5445081536892967`*^9, 3.544508505766326*^9, 3.544509072486803*^9, 
   3.544509597893923*^9, 3.544509737669457*^9, 3.544510177045341*^9, 
   3.544510270274538*^9, 3.5445103863676233`*^9, 3.544510522675006*^9, 
   3.544511337695758*^9, 3.54451163838265*^9, 3.544511793469078*^9, 
   3.5445118622704287`*^9, 3.544529243370572*^9, 3.544529557911146*^9, 
   3.544529869898612*^9, 3.544614272011674*^9, 3.544614620762805*^9, 
   3.544614790329775*^9, {3.544615343617065*^9, 3.5446153575856867`*^9}, 
   3.544615878736828*^9, 3.544621079748065*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"varr", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "1"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fdat", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"1", "+", "1"}], ";;", 
        RowBox[{"1", "+", "Nz"}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hdat", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"1", "+", "Nz", "+", "1"}], ";;", 
        RowBox[{"1", "+", 
         RowBox[{"2", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"adat", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"2", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"1", "+", 
         RowBox[{"3", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tdat", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"3", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"1", "+", 
         RowBox[{"4", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sdat", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"4", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"1", "+", 
         RowBox[{"5", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]dat", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"fdat", "^", "2"}], "+", 
     RowBox[{"hdat", "^", "2"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5442721840563507`*^9, 3.544272253424959*^9}, {
  3.544272369283926*^9, 3.544272381483509*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eq1", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"5", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"1", "+", 
         RowBox[{"6", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"6", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"1", "+", 
         RowBox[{"7", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq3", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"7", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"1", "+", 
         RowBox[{"8", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq4", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"8", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"1", "+", 
         RowBox[{"9", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq5", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"9", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"1", "+", 
         RowBox[{"10", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"const1", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"10", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"1", "+", 
         RowBox[{"11", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"const2", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"11", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"1", "+", 
         RowBox[{"12", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"const3", "=", 
   RowBox[{"data2", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", 
      RowBox[{
       RowBox[{"1", "+", 
        RowBox[{"12", "Nz"}], "+", "1"}], ";;", 
       RowBox[{"1", "+", 
        RowBox[{"13", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544286081602502*^9, 3.544286129930849*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Export", "[", 
    RowBox[{
    "\"\<~/Work/AdSCMTDyn2/figs/psievolution_pos10.jpg\>\"", ",", "plt"}], 
    "]"}], "*)"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.544425566996078*^9, 3.544425652263814*^9}, {
  3.5444257709465*^9, 3.5444257838339148`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"solfit", "=", 
   RowBox[{"FindFit", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"varr", ",", 
         FractionBox[
          RowBox[{"\[Psi]dat", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}], 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "2", "]"}], "]"}]]}], "}"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"Round", "[", 
         RowBox[{"size", "/", "2"}], "]"}], ";;", "size"}], "]"}], "]"}], ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "k"}], " ", "t"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "k"}], "}"}], ",", "t"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"scalarfinal", "=", 
  RowBox[{"a", "/.", "solfit"}]}]}], "Input",
 CellChangeTimes->{{3.544435821406659*^9, 3.54443587962794*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"FindFit", "::", "cvmit"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Failed to converge to the requested accuracy or precision \
within \[NoBreak]\\!\\(100\\)\[NoBreak] iterations. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindFit/cvmit\\\", ButtonNote -> \
\\\"FindFit::cvmit\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5446153577007837`*^9, 3.54461587885334*^9, 
  3.544621079911343*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "2.279471960909712`"}], ",", 
   RowBox[{"b", "\[Rule]", "0.22403671694715738`"}], ",", 
   RowBox[{"k", "\[Rule]", "0.007688381275446024`"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.54443585973696*^9, 3.544435880255438*^9}, {
   3.544435996601735*^9, 3.544436042887537*^9}, 3.5444360828684587`*^9, 
   3.544437126940176*^9, 3.544437434994521*^9, 3.544459812001218*^9, 
   3.544460281445202*^9, 3.544460846628487*^9, 3.5444615144693937`*^9, 
   3.544461665161901*^9, 3.544506726501145*^9, 3.544506947644354*^9, 
   3.544507045924629*^9, 3.544507085529468*^9, 3.5445073075558434`*^9, 
   3.5445077887431517`*^9, 3.5445078558243437`*^9, 3.544507986943696*^9, 
   3.544508153803301*^9, 3.544508505915736*^9, 3.544509073697523*^9, 
   3.544509598040772*^9, 3.544509737795292*^9, 3.5445101771592216`*^9, 
   3.544510270378381*^9, 3.5445103864808283`*^9, 3.544510522802106*^9, 
   3.544511337846034*^9, 3.54451163850179*^9, 3.544511793606718*^9, 
   3.5445118624233227`*^9, 3.544529243507463*^9, 3.544529558038397*^9, 
   3.544614272119535*^9, 3.544614620869961*^9, 3.544614790463491*^9, {
   3.544615343742251*^9, 3.5446153577035513`*^9}, 3.5446158788561783`*^9, 
   3.544621079914289*^9}],

Cell[BoxData["2.279471960909712`"], "Output",
 CellChangeTimes->{{3.54443585973696*^9, 3.544435880255438*^9}, {
   3.544435996601735*^9, 3.544436042887537*^9}, 3.5444360828684587`*^9, 
   3.544437126940176*^9, 3.544437434994521*^9, 3.544459812001218*^9, 
   3.544460281445202*^9, 3.544460846628487*^9, 3.5444615144693937`*^9, 
   3.544461665161901*^9, 3.544506726501145*^9, 3.544506947644354*^9, 
   3.544507045924629*^9, 3.544507085529468*^9, 3.5445073075558434`*^9, 
   3.5445077887431517`*^9, 3.5445078558243437`*^9, 3.544507986943696*^9, 
   3.544508153803301*^9, 3.544508505915736*^9, 3.544509073697523*^9, 
   3.544509598040772*^9, 3.544509737795292*^9, 3.5445101771592216`*^9, 
   3.544510270378381*^9, 3.5445103864808283`*^9, 3.544510522802106*^9, 
   3.544511337846034*^9, 3.54451163850179*^9, 3.544511793606718*^9, 
   3.5445118624233227`*^9, 3.544529243507463*^9, 3.544529558038397*^9, 
   3.544614272119535*^9, 3.544614620869961*^9, 3.544614790463491*^9, {
   3.544615343742251*^9, 3.5446153577035513`*^9}, 3.5446158788561783`*^9, 
   3.5446210799161654`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rhofinal", "=", 
  FractionBox[
   RowBox[{"tdat", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "2"}], "]"}], "]"}], 
   RowBox[{"zarr", "[", 
    RowBox[{"[", "2", "]"}], "]"}]]}]], "Input",
 CellChangeTimes->{{3.544435946301601*^9, 3.54443595605868*^9}}],

Cell[BoxData[
 RowBox[{"-", "7.063470963781289`"}]], "Output",
 CellChangeTimes->{{3.5444359510918627`*^9, 3.5444359565083313`*^9}, {
   3.544435996654902*^9, 3.5444360429255333`*^9}, 3.544436082907256*^9, 
   3.5444371318029127`*^9, 3.544437435035562*^9, 3.5444598131184387`*^9, 
   3.544460282245331*^9, 3.544460847479504*^9, 3.54446151645332*^9, 
   3.544506726549015*^9, 3.54450694768563*^9, 3.544507045957708*^9, 
   3.5445070855683527`*^9, 3.5445073075956297`*^9, 3.544507788780106*^9, 
   3.544507855859048*^9, 3.544507986982942*^9, 3.544508153840042*^9, 
   3.544508505965538*^9, 3.5445090786788054`*^9, 3.544509598084156*^9, 
   3.544509737839829*^9, 3.544510177201167*^9, 3.54451027041691*^9, 
   3.544510386525158*^9, 3.5445105228465033`*^9, 3.544511337886484*^9, 
   3.544511638537146*^9, 3.544511793645789*^9, 3.544511862458578*^9, 
   3.544529245179874*^9, 3.544529558078176*^9, 3.544614272168734*^9, 
   3.544614620915337*^9, 3.544614790497048*^9, {3.544615343780663*^9, 
   3.544615357740835*^9}, 3.544615878895371*^9, 3.544621079952437*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmpfn", "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"zarr", ",", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"zarr", "^", "2"}], "*", 
          RowBox[{"tdat", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "All"}], "]"}], "]"}]}]}]}], "}"}], 
      "]"}], "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"tmpfn", "[", "z", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"solh", "=", 
    RowBox[{"FindRoot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpfn", "[", "z", "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"horiz", "=", 
   RowBox[{"z", "/.", "solh"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"temp", "=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     RowBox[{"tmpfn", "'"}], "[", "z", "]"}]}], "/.", "solh"}]}]}], "Input",
 CellChangeTimes->{{3.5444357756400423`*^9, 3.544435780915472*^9}, {
  3.544435885398581*^9, 3.5444358879043503`*^9}, {3.544512292346345*^9, 
  3.5445123412738733`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1nk0lVsfB3BSL6mbFCVDSFSSNFPpW+jSeCsqJJkl4bippG5SkYyFkI7M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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Print",
 CellChangeTimes->{{3.544435772334688*^9, 3.544435781548958*^9}, 
   3.54443588882135*^9, {3.5444359967023706`*^9, 3.5444360429617567`*^9}, 
   3.544436082937495*^9, 3.544437132802339*^9, 3.544437435068363*^9, 
   3.5444598172313004`*^9, 3.5444602843126373`*^9, 3.5444608481812677`*^9, 
   3.5444615203110867`*^9, 3.544506726656447*^9, 3.54450694808278*^9, 
   3.544507046013899*^9, 3.544507085603672*^9, 3.5445073076400833`*^9, 
   3.544507788810855*^9, 3.5445078559120703`*^9, 3.544507987031918*^9, 
   3.5445081538775587`*^9, 3.5445085060137577`*^9, 3.544509079266364*^9, 
   3.5445095981328897`*^9, 3.5445097378727083`*^9, 3.544510177237357*^9, 
   3.544510270450292*^9, 3.544510386573769*^9, 3.544510522879581*^9, 
   3.5445113379168863`*^9, 3.544511638572064*^9, 3.54451179367593*^9, 
   3.5445118625159893`*^9, {3.544512322459323*^9, 3.544512341780431*^9}, 
   3.5445292461576347`*^9, 3.5445295581067047`*^9, 3.5445298745895357`*^9, 
   3.544614272200219*^9, 3.544614621780265*^9, 3.544614790530937*^9, {
   3.5446153438121223`*^9, 3.5446153577915916`*^9}, 3.544615878926909*^9, 
   3.5446210800014277`*^9}],

Cell[BoxData["0.6846119669459837`"], "Output",
 CellChangeTimes->{
  3.544435781558155*^9, 3.544435888827332*^9, {3.544435996708294*^9, 
   3.54443604296778*^9}, 3.544436082943346*^9, 3.544437132808366*^9, 
   3.544437435073763*^9, 3.544459817237397*^9, 3.544460284317998*^9, 
   3.54446084818688*^9, 3.54446152031714*^9, 3.544506726661811*^9, 
   3.5445069480885887`*^9, 3.5445070460195627`*^9, 3.5445070856092176`*^9, 
   3.5445073076466293`*^9, 3.544507788816648*^9, 3.544507855917609*^9, 
   3.5445079870371532`*^9, 3.544508153883011*^9, 3.544508506019273*^9, 
   3.5445090792722*^9, 3.5445095981389933`*^9, 3.544509737878491*^9, 
   3.544510177243091*^9, 3.544510270455562*^9, 3.544510386579571*^9, 
   3.544510522885326*^9, 3.5445113379223547`*^9, 3.5445116385774727`*^9, 
   3.544511793681671*^9, 3.544511862521783*^9, {3.544512322467567*^9, 
   3.5445123417859364`*^9}, 3.5445292461631308`*^9, 3.544529558112021*^9, 
   3.544529874595289*^9, 3.544614272205933*^9, 3.54461462178557*^9, 
   3.544614790536401*^9, {3.5446153438179283`*^9, 3.5446153577973127`*^9}, 
   3.544615878932336*^9, 3.54462108000716*^9}],

Cell[BoxData["2.976250968360869`"], "Output",
 CellChangeTimes->{
  3.544435781558155*^9, 3.544435888827332*^9, {3.544435996708294*^9, 
   3.54443604296778*^9}, 3.544436082943346*^9, 3.544437132808366*^9, 
   3.544437435073763*^9, 3.544459817237397*^9, 3.544460284317998*^9, 
   3.54446084818688*^9, 3.54446152031714*^9, 3.544506726661811*^9, 
   3.5445069480885887`*^9, 3.5445070460195627`*^9, 3.5445070856092176`*^9, 
   3.5445073076466293`*^9, 3.544507788816648*^9, 3.544507855917609*^9, 
   3.5445079870371532`*^9, 3.544508153883011*^9, 3.544508506019273*^9, 
   3.5445090792722*^9, 3.5445095981389933`*^9, 3.544509737878491*^9, 
   3.544510177243091*^9, 3.544510270455562*^9, 3.544510386579571*^9, 
   3.544510522885326*^9, 3.5445113379223547`*^9, 3.5445116385774727`*^9, 
   3.544511793681671*^9, 3.544511862521783*^9, {3.544512322467567*^9, 
   3.5445123417859364`*^9}, 3.5445292461631308`*^9, 3.544529558112021*^9, 
   3.544529874595289*^9, 3.544614272205933*^9, 3.54461462178557*^9, 
   3.544614790536401*^9, {3.5446153438179283`*^9, 3.5446153577973127`*^9}, 
   3.544615878932336*^9, 3.544621080008836*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Nz", ",", "aval", ",", "scalarfinal", ",", "horiz", ",", "rhofinal"}], 
  "}"}]], "Input",
 CellChangeTimes->{{3.5444358916989822`*^9, 3.544435905131508*^9}, {
  3.544435963426516*^9, 3.5444359851457157`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "20", ",", "2.918602687158184`", ",", "2.279471960909712`", ",", 
   "0.6846119669459837`", ",", 
   RowBox[{"-", "7.063470963781289`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.54443590568613*^9, 3.544435965032382*^9, {3.544435996753491*^9, 
   3.544436043008608*^9}, 3.5444360829882727`*^9, 3.544437134338352*^9, 
   3.5444374351145897`*^9, 3.544459818280455*^9, 3.544460287084435*^9, 
   3.544461521050105*^9, 3.5445067267016983`*^9, 3.544506948921001*^9, 
   3.5445070472562103`*^9, 3.544507085634811*^9, 3.544507309478136*^9, 
   3.5445077888466587`*^9, 3.544507857497031*^9, 3.544507987083626*^9, 
   3.544508153924788*^9, 3.544508507266302*^9, 3.5445090803991003`*^9, {
   3.5445096004685383`*^9, 3.5445096299060163`*^9}, 3.5445097384423018`*^9, 
   3.544510177281455*^9, 3.5445102714507723`*^9, 3.5445103866255417`*^9, 
   3.544510522924905*^9, 3.544511337969082*^9, 3.544511638624167*^9, 
   3.54451179469022*^9, 3.544511862559991*^9, 3.544529247227478*^9, 
   3.544529559655128*^9, 3.544529875471262*^9, 3.5446142746702003`*^9, 
   3.544614622670866*^9, 3.54461479058279*^9, {3.544615343863316*^9, 
   3.54461535784379*^9}, 3.544615878974976*^9, 3.544621080105448*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plt", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"varr", ",", 
       FractionBox[
        RowBox[{"\[Psi]dat", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "2"}], "]"}], "]"}], 
        RowBox[{"zarr", "[", 
         RowBox[{"[", "2", "]"}], "]"}]]}], "}"}], "]"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<v\>\"", ",", "\"\<<|\[Psi]|>\>\""}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5446143422077417`*^9, 3.544614346168579*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwt1glUjfkfx/H43W6LqUYh3aTttqu7GZP1fmaGGplJGiPDX7ZCjSwhqez+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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"<|\[Psi]|>\"", TraditionalForm]},
  AxesOrigin->{0, 2.46},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.5445080469599733`*^9, 3.5445081544249*^9, 3.544508509243434*^9, 
   3.544509081234522*^9, {3.544509627345256*^9, 3.544509630611373*^9}, 
   3.544509740577174*^9, 3.544510177338125*^9, 3.54451027216726*^9, 
   3.544510386675276*^9, 3.544510522960178*^9, 3.544511338021315*^9, 
   3.544511638672862*^9, 3.544511795341259*^9, 3.544511862615662*^9, 
   3.5445292480157137`*^9, 3.544529560343958*^9, 3.544529876895832*^9, 
   3.544614275419753*^9, 3.544614346580743*^9, 3.5446146234044647`*^9, 
   3.544614790630975*^9, {3.5446153447798853`*^9, 3.544615357896206*^9}, 
   3.544615879031646*^9, 3.5446210801508417`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"zarr", ",", 
        RowBox[{
         RowBox[{"fdat", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "All"}], "]"}], "]"}], "+", 
         RowBox[{"I", " ", 
          RowBox[{"hdat", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "All"}], "]"}], "]"}]}]}]}], "}"}], "]"}], 
     "]"}], "'"}], "[", "0", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 FractionBox[
  RowBox[{
   RowBox[{"fdat", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "+", 
   RowBox[{"I", " ", 
    RowBox[{"hdat", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}]}], 
  RowBox[{"zarr", "[", 
   RowBox[{"[", "2", "]"}], "]"}]]}], "Input",
 CellChangeTimes->{{3.54450926479919*^9, 3.544509271566619*^9}, {
  3.5445093019475107`*^9, 3.544509354313236*^9}, {3.544509470809608*^9, 
  3.5445094750948153`*^9}}],

Cell[BoxData[
 RowBox[{"3.129340285697284`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.1256076881486111`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{{3.5445092625486097`*^9, 3.544509272210908*^9}, {
   3.544509310466881*^9, 3.544509355319621*^9}, 3.544509394098181*^9, 
   3.5445094756573257`*^9, {3.544509637588056*^9, 3.544509639844471*^9}, 
   3.544509760769018*^9, 3.54451017738101*^9, 3.544510273319355*^9, 
   3.544510386726942*^9, 3.544510523007707*^9, 3.544511338067932*^9, 
   3.544511638723814*^9, 3.544511797745221*^9, 3.5445118626600723`*^9, 
   3.544529254795278*^9, 3.5445295645875196`*^9, 3.5445296469945087`*^9, 
   3.5445298812722893`*^9, 3.5446142767828417`*^9, 3.544614626160755*^9, 
   3.544614793150619*^9, {3.54461534667255*^9, 3.544615357988585*^9}, 
   3.544615882583675*^9, 3.544621080199544*^9}],

Cell[BoxData[
 RowBox[{"3.1293320716202038`", "\[VeryThinSpace]", "+", 
  RowBox[{"1.5162383858552422`*^-23", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{{3.5445092625486097`*^9, 3.544509272210908*^9}, {
   3.544509310466881*^9, 3.544509355319621*^9}, 3.544509394098181*^9, 
   3.5445094756573257`*^9, {3.544509637588056*^9, 3.544509639844471*^9}, 
   3.544509760769018*^9, 3.54451017738101*^9, 3.544510273319355*^9, 
   3.544510386726942*^9, 3.544510523007707*^9, 3.544511338067932*^9, 
   3.544511638723814*^9, 3.544511797745221*^9, 3.5445118626600723`*^9, 
   3.544529254795278*^9, 3.5445295645875196`*^9, 3.5445296469945087`*^9, 
   3.5445298812722893`*^9, 3.5446142767828417`*^9, 3.544614626160755*^9, 
   3.544614793150619*^9, {3.54461534667255*^9, 3.544615357988585*^9}, 
   3.544615882583675*^9, 3.544621080202063*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Interpolation", "[", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"zarr", ",", 
         RowBox[{
          RowBox[{"fdat", "[", 
           RowBox[{"[", 
            RowBox[{"50", ",", "All"}], "]"}], "]"}], "+", 
          RowBox[{"I", " ", 
           RowBox[{"hdat", "[", 
            RowBox[{"[", 
             RowBox[{"50", ",", "All"}], "]"}], "]"}]}]}]}], "}"}], "]"}], 
      "]"}], "'"}], "[", "0", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 FractionBox[
  RowBox[{
   RowBox[{"fdat", "[", 
    RowBox[{"[", 
     RowBox[{"50", ",", "2"}], "]"}], "]"}], "+", 
   RowBox[{"I", " ", 
    RowBox[{"hdat", "[", 
     RowBox[{"[", 
      RowBox[{"50", ",", "2"}], "]"}], "]"}]}]}], 
  RowBox[{"zarr", "[", 
   RowBox[{"[", "2", "]"}], "]"}]]}], "Input",
 CellChangeTimes->{{3.544509369124902*^9, 3.5445093712278643`*^9}, {
  3.5445094606976233`*^9, 3.544509463575014*^9}, {3.544509519186413*^9, 
  3.544509519592963*^9}, {3.544509553540794*^9, 3.54450955913116*^9}}],

Cell[BoxData[
 RowBox[{"2.497923911773008`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.10554360910766106`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{{3.5445093716713247`*^9, 3.544509394870161*^9}, {
   3.544509463958256*^9, 3.544509476406386*^9}, 3.5445095201611*^9, 
   3.544509559558508*^9, 3.5445096421692953`*^9, 3.544509761630618*^9, 
   3.5445101774330797`*^9, 3.544510274069826*^9, 3.544510386774747*^9, 
   3.544510523060143*^9, 3.5445113381180277`*^9, 3.544511638772458*^9, 
   3.544511798483844*^9, 3.544511862712659*^9, 3.544529256730088*^9, 
   3.54452956541639*^9, 3.544529648094558*^9, 3.544529882285191*^9, 
   3.5446142778247128`*^9, 3.5446146270463343`*^9, 3.544614793967255*^9, {
   3.5446153473681993`*^9, 3.544615358051693*^9}, 3.544615883382606*^9, 
   3.544621080253055*^9}],

Cell[BoxData[
 RowBox[{"2.4978742035829886`", "\[VeryThinSpace]", "-", 
  RowBox[{"1.987363977108183`*^-18", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{{3.5445093716713247`*^9, 3.544509394870161*^9}, {
   3.544509463958256*^9, 3.544509476406386*^9}, 3.5445095201611*^9, 
   3.544509559558508*^9, 3.5445096421692953`*^9, 3.544509761630618*^9, 
   3.5445101774330797`*^9, 3.544510274069826*^9, 3.544510386774747*^9, 
   3.544510523060143*^9, 3.5445113381180277`*^9, 3.544511638772458*^9, 
   3.544511798483844*^9, 3.544511862712659*^9, 3.544529256730088*^9, 
   3.54452956541639*^9, 3.544529648094558*^9, 3.544529882285191*^9, 
   3.5446142778247128`*^9, 3.5446146270463343`*^9, 3.544614793967255*^9, {
   3.5446153473681993`*^9, 3.544615358051693*^9}, 3.544615883382606*^9, 
   3.5446210802554617`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Abs", "[", "tmp", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 FractionBox[
  RowBox[{"\[Psi]dat", "[", 
   RowBox[{"[", 
    RowBox[{"50", ",", "2"}], "]"}], "]"}], 
  RowBox[{"zarr", "[", 
   RowBox[{"[", "2", "]"}], "]"}]]}], "Input",
 CellChangeTimes->{{3.5445095049139137`*^9, 3.5445095280105667`*^9}, {
  3.5445095632826233`*^9, 3.544509563378501*^9}}],

Cell[BoxData["2.500152659825163`"], "Output",
 CellChangeTimes->{{3.544509511074872*^9, 3.544509528411601*^9}, 
   3.544509563749427*^9, 3.5445096440008698`*^9, 3.5445097622851763`*^9, 
   3.544510177480748*^9, 3.544510274743548*^9, 3.544510386829955*^9, 
   3.544510523090394*^9, 3.5445113382338142`*^9, 3.544511638824997*^9, 
   3.544511799235798*^9, 3.54451186275986*^9, 3.544529257564155*^9, 
   3.544529567219295*^9, 3.5445296532234077`*^9, 3.544529883055674*^9, 
   3.544614278665032*^9, 3.544614627845456*^9, 3.5446147947581873`*^9, 
   3.544615359188414*^9, 3.544615884247116*^9, 3.544621080299532*^9}],

Cell[BoxData["2.4978742035829886`"], "Output",
 CellChangeTimes->{{3.544509511074872*^9, 3.544509528411601*^9}, 
   3.544509563749427*^9, 3.5445096440008698`*^9, 3.5445097622851763`*^9, 
   3.544510177480748*^9, 3.544510274743548*^9, 3.544510386829955*^9, 
   3.544510523090394*^9, 3.5445113382338142`*^9, 3.544511638824997*^9, 
   3.544511799235798*^9, 3.54451186275986*^9, 3.544529257564155*^9, 
   3.544529567219295*^9, 3.5445296532234077`*^9, 3.544529883055674*^9, 
   3.544614278665032*^9, 3.544614627845456*^9, 3.5446147947581873`*^9, 
   3.544615359188414*^9, 3.544615884247116*^9, 3.544621080301766*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"varr", ",", 
       FractionBox[
        RowBox[{"fdat", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "2"}], "]"}], "]"}], 
        RowBox[{"zarr", "[", 
         RowBox[{"[", "2", "]"}], "]"}]]}], "}"}], "]"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<v\>\"", ",", "\"\<<Re|\[Psi]|>\>\""}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"varr", ",", 
      FractionBox[
       RowBox[{"hdat", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}], 
       RowBox[{"zarr", "[", 
        RowBox[{"[", "2", "]"}], "]"}]]}], "}"}], "]"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<v\>\"", ",", "\"\<<Im|\[Psi]|>\>\""}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5445080299320087`*^9, 3.5445080686919813`*^9}, {
  3.5446142948261833`*^9, 3.54461430814684*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwt1gtUjHkfB/CZeWam0htRqSSaakrTbWpQ6eX5LmGTlctaFfIuslgr221b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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"<Re|\[Psi]|>\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.544508041567182*^9, 3.544508072151737*^9}, 
   3.544508155945889*^9, 3.544508511507771*^9, 3.544509092005835*^9, 
   3.5445096527402897`*^9, {3.544509764670138*^9, 3.544509768801064*^9}, 
   3.544510177518141*^9, 3.544510275406824*^9, 3.544510386874527*^9, 
   3.544510523144216*^9, 3.544511338297545*^9, 3.544511638873157*^9, 
   3.544511799901569*^9, 3.544511862811706*^9, 3.544529258886714*^9, 
   3.544529587764257*^9, 3.544529654257516*^9, 3.544529890535037*^9, {
   3.544614279410988*^9, 3.544614308739121*^9}, 3.544614628515863*^9, 
   3.544614795391267*^9, 3.544615359956687*^9, 3.544615885240992*^9, 
   3.544621080335162*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxF1gs0lPkbB/CZ99WNSrkkIwzjMuM6F20pep/y11a2LdR2ZEur5aza6t/9
SqHtv0llu1Ak3XY3UrtbKcnx+6UiR7muXdJFUdgichvG5b/zxOs9Z47zned5
P7/vGZx5rYI3+IUwAoEg/9+X9udpvO5wytTe4v8tUc5MwlzACQavqSrtVc7n
ZJxXDe4zMxl8t4aff4b7tXxeE6q93g7uB989i/c38vOyx9rr/dD52Sy+2zKY
52R/Oq+V35+GfhufS/H+dn5/LZ7XOZj9PEbglprfT0Gve2jfwx09DT8vR693
qI/HOvT6+fmnfgIYmhfiPp+zj6MvhKH9QLyf4bMEz2P5/G5Aew3nG+jp8Hk3
eiN43wu9kfxcD71RfC5HbzgnoTeaz6vRG8P3d0RPl5+3KbWeHj+/i54eP49G
byzfxwe9cfzcEL3x/LwaPX1+fhG94fwZ7k/gcyL6w7kf75/I52A8bzjnoTec
HdAz4PsfQW84f0TPkN//Cr3hnIWeIQz9PVmgZwRXXxYdjV7wB4lCzwjmeuof
Wj4nl7xFzxhei41nub0oJAvQMwaD0hijoqwycg09YwhZ9SotP+pvYoDeJDDO
U0464/2MbENvErwIiM7o2VdDnqJnAkY1cVPnVb8ms9AzgVlxefrmijfkAnom
sGJp2M23kfVkJHqToWS5xm/yk0ayBr3JUBU0/6HM4D0pQs8UltzclRi/uJko
0TOFnC0XLzZ7tZB49EwhfmTZLBLYSnpCtJ4Iyvu7l0Zs+EhWoieCOruukqaI
NpKLnhmQWlOnkoPtxA49Mzji77O24WgHiUHPDGImLBb1xHWSZvSmQPieP5cV
xHYRP/SmQOsfbQ2iaDW5hZ45bPAb439zczcRoWcOa7yKuwNX9pAI9Mxh9i0d
qJqjIa/Rs4CIpRap7eJeMhc9C1gtetCzXd1L0tCzBKcfbVa4FPSR8ehZwkzx
tzvrjvWTTehZwi5IPfnd0gHyDvfFIFHNXOY9WkDN8fMUw+cZCXPHBwvoIrxf
DMHr6prUtwU0Es8Tg+jMc1HLGCG9gZ4YfPXdkl4uE9I36FlBsVH8nJvnhdQE
PSuwhd8/BNYL6Xz0rOCQ2fy4h1KG7kbPCqa7J9q8CmHoVfSsIP74qNyUswx9
iZ41ZNr4n2wrY+hE9Kzh4sfQumKGpV7oWcPWCY/1ZS4s3YqeNei9qznevoSl
v6JnDV6y52Nk21lahZ4ENNlXpTknWKqHngTWiH9/mH6VpZ7oSSBB4lvRfI+l
G9CTwAXDn9buLWXpefQkMDvx++zlz1hajp4NLN4unRLxmqUj0LMBc53wgfpa
lk5DzwZ0U5I1CTUsDUPPBpZUm+QdqWRpEno2EFn7g1tRIUufoGcLXRX6HgFZ
LB3A37ctbDTMbFFdYqkCPVuIrFy/f/VBlq5GzxYSnzV6N4ex9CR6tpDxpWdK
tTdL89Gzgzcz3IzczFnajZ4dpFwOBWELQx3Rs4OgqLEVC3MYugI9Ozh+Kjbe
9keGHkXv31yQH3ByIUPvoWcP6kVi4ZXxDG1Dzx7eFHvu3FoopLbo2cPesUcz
dPYL6TL07KHBKSY9bLqQHkTPHqZlpfvfahDQu+hJoTTVI6nvhIA2oScFVWVh
mL+ngFqiJ4WC+n6X0/cHiC96Ugja4V7WpzNAotGTgnzqHWOG6ycZ6MmALNKf
VLGxj9SjJ4O7rpmXf03uJaboySDTMmJxeq6G+KAnA9WHrQqTVz0kHD0ZzDp3
Sseiu5v8hp4DeEj6dNW63eQVeg4wziJD8GKSmhii5wAS9SJ9XfMu4o2eA3TO
HEVvm3eS7eg5wNj1CU0S0w6Sip4jGOU9yojVbyfV6DlCZ0naGoWwjYxDzxEi
zhyI9mtuJRx6jvB0f8xhxd8tZCN6jiDOD51uveMDuYieEzj0vt8UNqOJVKDn
BBfUQVfudfxDRqHnBHb919dnpDUQd/Sc4LyraUVJwFuyFj0neDw1bdV5to4k
o+cM+R1XqzMuvyLF6DlDmNR1ncfxF0SInjMkWG8o/OtJFVGh5wyPrZaHr2Qq
SAh6zvAoxPOKWlFCEtBzARqpF5ZwN48UoOcCS+8Jf9GYZRHNKa3nAqf35y+8
9C6ROKPnAsG+xpVFX6ZyQei5QOB/znXIWMr9hJ4rHD4VeCz5WgF3Hz1X8O7e
G/IytZTrQM8V7mxO/8Vyx1+cPXquUPr1jW8aoZoLQM8V3maPrjwkrOHw+8pU
DuptTYn3V77mGtCXg25xjurQ7TrugPb2L+Qw2vZwvZ9ePWeD/99yqNa/Lo0N
aORytdxeOXiN0GSmnn/HrcLPRw6aUwcKLWubOPz+viGHAh87w+vjW7gz2EcO
9z6/ZNVl38rNwMdDOTzbnZJp5vmRq8R+cvA/o7vr+cI2bhv2U0Cqy3IDTUA7
Z4TPOwowOzZtnts3Hdx17KeA6+WtegtWd3KLsZ8C7HIuH+gP6uKasZ8Cxm13
kRkvU3Ox2E8BPl1JWX7zujkHLXdDAfJ/ToSGq3q4R9hPARabphV+PVnDfXp8
VUCc782RWZ0aTgefEpTQuyv2QVBRL3cB+ykh4+l/F4hS+jjAfkoYraH7b3/X
z73AfkrYvOVng1GOA9weBJXQF3rf9+mbAU6k5fYpwX3MfbeoLwSQif2U0PBn
n4PzBQF8hf2UEBZutbOqTQDt2E8JW655RW6eLYRj2E8JIH1wtiFGCHLspwJT
5woH+xIhFGE/FZw7kr/PYiID32M/FUTLTRmykAHdJ9p+Kkie4i3q+YGBy9hP
Be1uS+bk3mFgLvZTwcQ4Zx29RgbqsJ8K0u783PfIkIUo7KeC9AGf2lZ3FsRa
77EKGElH1J5AFnKwnwokZUzeqh0s/B8RJZ48
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"<Im|\[Psi]|>\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.544508041567182*^9, 3.544508072151737*^9}, 
   3.544508155945889*^9, 3.544508511507771*^9, 3.544509092005835*^9, 
   3.5445096527402897`*^9, {3.544509764670138*^9, 3.544509768801064*^9}, 
   3.544510177518141*^9, 3.544510275406824*^9, 3.544510386874527*^9, 
   3.544510523144216*^9, 3.544511338297545*^9, 3.544511638873157*^9, 
   3.544511799901569*^9, 3.544511862811706*^9, 3.544529258886714*^9, 
   3.544529587764257*^9, 3.544529654257516*^9, 3.544529890535037*^9, {
   3.544614279410988*^9, 3.544614308739121*^9}, 3.544614628515863*^9, 
   3.544614795391267*^9, 3.544615359956687*^9, 3.544615885240992*^9, 
   3.544621080341777*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]cmplx", "=", 
    RowBox[{
     RowBox[{"fdat", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2"}], "]"}], "]"}], "+", 
     RowBox[{"I", " ", 
      RowBox[{"hdat", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dv", "=", 
   RowBox[{
    RowBox[{"varr", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "-", 
    RowBox[{"varr", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544615184292057*^9, 3.54461519663649*^9}, {
  3.544615236578779*^9, 3.544615246786457*^9}, {3.544615399247149*^9, 
  3.544615399646955*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"varr", "[", 
        RowBox[{"[", 
         RowBox[{"1", ";;", 
          RowBox[{"-", "2"}]}], "]"}], "]"}], "+", 
       FractionBox["dv", "2"]}], ",", 
      RowBox[{
       FractionBox["1", "2"], 
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"Arg", "[", "\[Psi]cmplx", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", 
            RowBox[{"-", "1"}]}], "]"}], "]"}], "-", 
         RowBox[{
          RowBox[{"Arg", "[", "\[Psi]cmplx", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ";;", 
            RowBox[{"-", "2"}]}], "]"}], "]"}]}], "dv"]}]}], "}"}], "]"}], 
   ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<v\>\"", ",", "\"\<<Re|\[Psi]|>\>\""}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.4"}], ",", "0.1"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5446151274395857`*^9, 3.544615277224341*^9}, {
   3.5446153869131393`*^9, 3.54461540857563*^9}, {3.5446154616617603`*^9, 
   3.544615517504529*^9}, {3.5446156147923317`*^9, 3.544615640183606*^9}, 
   3.5446159108720016`*^9, {3.5446210916350594`*^9, 3.544621106577927*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxF1gtQU2cWwHGwUrQSFZCnxhLCM7ySIFIlMUdYl2EFBCytQLNWBSpYHhUR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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"<Re|\[Psi]|>\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{0.15000000000000002`, 19.850000000000296`}, {-0.4, 0.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellChangeTimes->{
  3.5446151467144117`*^9, {3.544615269938472*^9, 3.544615277898435*^9}, {
   3.544615362762454*^9, 3.544615408916299*^9}, {3.5446154623418703`*^9, 
   3.5446155177811813`*^9}, 3.5446156405877953`*^9, {3.544615889846788*^9, 
   3.544615911636756*^9}, {3.5446210816514273`*^9, 3.544621106985072*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Mu]list", "=", 
    RowBox[{"aval", "-", 
     RowBox[{
      FractionBox["1", "2"], 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"Arg", "[", "\[Psi]cmplx", "]"}], "[", 
         RowBox[{"[", 
          RowBox[{"2", ";;", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"Arg", "[", "\[Psi]cmplx", "]"}], "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "2"}]}], "]"}], "]"}]}], "dv"]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Mu]i", "=", 
   RowBox[{"\[Mu]list", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"\[Mu]f", "=", 
  RowBox[{"\[Mu]list", "[", 
   RowBox[{"[", 
    RowBox[{"-", "1"}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.544621150972155*^9, 3.544621184029148*^9}, 
   3.544621389912468*^9}],

Cell[BoxData["2.918602687158184`"], "Output",
 CellChangeTimes->{{3.544621173451578*^9, 3.544621184521015*^9}, 
   3.544621390473339*^9, 3.544621440137938*^9}],

Cell[BoxData["3.0717152968205874`"], "Output",
 CellChangeTimes->{{3.544621173451578*^9, 3.544621184521015*^9}, 
   3.544621390473339*^9, 3.54462144014016*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"varr", "[", 
        RowBox[{"[", 
         RowBox[{"1", ";;", 
          RowBox[{"-", "2"}]}], "]"}], "]"}], "+", 
       FractionBox["dv", "2"]}], ",", "\[Mu]list"}], "}"}], "]"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<v\>\"", ",", "\"\<\[Mu]\>\""}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5446151274395857`*^9, 3.544615277224341*^9}, {
  3.5446153869131393`*^9, 3.54461540857563*^9}, {3.5446154616617603`*^9, 
  3.544615517504529*^9}, {3.5446156147923317`*^9, 3.544615640183606*^9}, {
  3.544615776703061*^9, 3.544615840634398*^9}, {3.544621111530614*^9, 
  3.5446211139165087`*^9}, {3.544621161279852*^9, 3.5446211657262363`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd1gtQVQUex3FQFPCFIIIgCJfL+3kf7spVk59SPhZd07IkUcPAok0JTc0n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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"\[Mu]\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{0.15000000000000002`, 19.850000000000296`}, {0, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellChangeTimes->{{3.5446158044435577`*^9, 3.5446158411334667`*^9}, 
   3.544615898527347*^9, 3.544621082835435*^9, 3.544621114645507*^9, 
   3.5446211661359873`*^9, 3.544621391357606*^9, 3.5446214416235456`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"varr", ",", 
       FractionBox[
        RowBox[{"adat", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "2"}], "]"}], "]"}], 
        RowBox[{"zarr", "[", 
         RowBox[{"[", "2", "]"}], "]"}]]}], "}"}], "]"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<v\>\"", ",", "\"\<<a>\>\""}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"varr", ",", 
       FractionBox[
        RowBox[{"tdat", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "2"}], "]"}], "]"}], 
        RowBox[{"zarr", "[", 
         RowBox[{"[", "2", "]"}], "]"}]]}], "}"}], "]"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<v\>\"", ",", "\"\<<\[Rho]>\>\""}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"varr", ",", 
      FractionBox[
       RowBox[{"sdat", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}], 
       RowBox[{
        RowBox[{"zarr", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]]}], "}"}], "]"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<v\>\"", ",", "\"\<<P>\>\""}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.544267085486063*^9, 3.544267142082458*^9}, {
   3.544267255753426*^9, 3.544267279936776*^9}, {3.5442674915298367`*^9, 
   3.544267572829974*^9}, {3.544268545882472*^9, 3.5442685694641027`*^9}, {
   3.544269667167377*^9, 3.544269686606105*^9}, 3.544271078850075*^9, {
   3.5442722618201933`*^9, 3.5442722918907967`*^9}, {3.5443458651060867`*^9, 
   3.5443458898718224`*^9}, {3.54435573466862*^9, 3.5443557458271303`*^9}, {
   3.544425563775131*^9, 3.544425564148943*^9}, {3.544508023172616*^9, 
   3.544508023781629*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwt1glYjYkex/Gj0mqrTvt26lSn/WyKkPfnusZgyDQudyzllsxNrgYxlupa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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"<a>\"", TraditionalForm]},
  AxesOrigin->{0, -5.2513000000000005`},
  PlotRange->{{0., 
   19.90000000000031}, {-5.2513000000000005`, -5.250398223057648}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.544333605417013*^9, 3.544334194932695*^9, 3.54433496565362*^9, 
   3.54433789704928*^9, 3.5443391900455008`*^9, 3.54433950300373*^9, 
   3.5443395976552887`*^9, 3.544340003132448*^9, 3.5443401718937283`*^9, 
   3.544340348238991*^9, 3.544340497781275*^9, 3.544340574080007*^9, 
   3.544340830565646*^9, 3.5443423894630632`*^9, 3.54434249628757*^9, 
   3.544345744084556*^9, 3.544345829681706*^9, {3.544345867494666*^9, 
   3.544345890499711*^9}, 3.544346204496914*^9, 3.544354338478221*^9, 
   3.5443548988943768`*^9, 3.544355046484371*^9, 3.5443555213460417`*^9, {
   3.544355714539798*^9, 3.544355746349559*^9}, 3.544355916082425*^9, 
   3.5443560363184967`*^9, 3.544356189165947*^9, 3.544358396445879*^9, 
   3.5443590405055637`*^9, 3.544359106384474*^9, 3.544359179696825*^9, 
   3.544359422000256*^9, 3.5443596055929527`*^9, 3.544360232201666*^9, 
   3.5443605923758173`*^9, 3.544360761603354*^9, 3.544360992687561*^9, 
   3.544361264268943*^9, 3.544361376654171*^9, 3.544361473577532*^9, 
   3.5443615713525143`*^9, 3.544362014705804*^9, 3.544425094553258*^9, 
   3.544425242609898*^9, {3.544425553577655*^9, 3.544425564791789*^9}, 
   3.544425765197873*^9, {3.54443555127886*^9, 3.5444355814732857`*^9}, 
   3.544435699234106*^9, 3.544459820254578*^9, 3.5444602877729893`*^9, 
   3.544461521865593*^9, 3.544506726750579*^9, 3.544506949772532*^9, 
   3.544507048145782*^9, 3.5445070856684027`*^9, 3.544507310176951*^9, 
   3.544507788879345*^9, 3.544507858146755*^9, 3.544507987133094*^9, 
   3.544508515227724*^9, 3.544509096065795*^9, 3.544509770615479*^9, 
   3.544511864209529*^9, 3.544529282814007*^9, 3.5445296550426083`*^9, 
   3.544614281798962*^9, 3.5446146633641043`*^9, 3.544614798242095*^9, 
   3.544621122899363*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwt1gk8lfkex3ERmlQ4hKNj3/ezCCk938nlVto3YZJRNJX2Ukamkmh1laUU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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"<\[Rho]>\"", TraditionalForm]},
  AxesOrigin->{0, -7.08},
  PlotRange->{{0., 19.90000000000031}, {-7.08, -7.0319157736918285`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.544333605417013*^9, 3.544334194932695*^9, 3.54433496565362*^9, 
   3.54433789704928*^9, 3.5443391900455008`*^9, 3.54433950300373*^9, 
   3.5443395976552887`*^9, 3.544340003132448*^9, 3.5443401718937283`*^9, 
   3.544340348238991*^9, 3.544340497781275*^9, 3.544340574080007*^9, 
   3.544340830565646*^9, 3.5443423894630632`*^9, 3.54434249628757*^9, 
   3.544345744084556*^9, 3.544345829681706*^9, {3.544345867494666*^9, 
   3.544345890499711*^9}, 3.544346204496914*^9, 3.544354338478221*^9, 
   3.5443548988943768`*^9, 3.544355046484371*^9, 3.5443555213460417`*^9, {
   3.544355714539798*^9, 3.544355746349559*^9}, 3.544355916082425*^9, 
   3.5443560363184967`*^9, 3.544356189165947*^9, 3.544358396445879*^9, 
   3.5443590405055637`*^9, 3.544359106384474*^9, 3.544359179696825*^9, 
   3.544359422000256*^9, 3.5443596055929527`*^9, 3.544360232201666*^9, 
   3.5443605923758173`*^9, 3.544360761603354*^9, 3.544360992687561*^9, 
   3.544361264268943*^9, 3.544361376654171*^9, 3.544361473577532*^9, 
   3.5443615713525143`*^9, 3.544362014705804*^9, 3.544425094553258*^9, 
   3.544425242609898*^9, {3.544425553577655*^9, 3.544425564791789*^9}, 
   3.544425765197873*^9, {3.54443555127886*^9, 3.5444355814732857`*^9}, 
   3.544435699234106*^9, 3.544459820254578*^9, 3.5444602877729893`*^9, 
   3.544461521865593*^9, 3.544506726750579*^9, 3.544506949772532*^9, 
   3.544507048145782*^9, 3.5445070856684027`*^9, 3.544507310176951*^9, 
   3.544507788879345*^9, 3.544507858146755*^9, 3.544507987133094*^9, 
   3.544508515227724*^9, 3.544509096065795*^9, 3.544509770615479*^9, 
   3.544511864209529*^9, 3.544529282814007*^9, 3.5445296550426083`*^9, 
   3.544614281798962*^9, 3.5446146633641043`*^9, 3.544614798242095*^9, 
   3.544621122905505*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwl1gdQVNcawHFQioJKEWRBwaUssCxlCyUQ9H5iolGxIxCNQSwRLIEQweRZ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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"<P>\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{0., 19.90000000000031}, {-1.0312012932777554`, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.544333605417013*^9, 3.544334194932695*^9, 3.54433496565362*^9, 
   3.54433789704928*^9, 3.5443391900455008`*^9, 3.54433950300373*^9, 
   3.5443395976552887`*^9, 3.544340003132448*^9, 3.5443401718937283`*^9, 
   3.544340348238991*^9, 3.544340497781275*^9, 3.544340574080007*^9, 
   3.544340830565646*^9, 3.5443423894630632`*^9, 3.54434249628757*^9, 
   3.544345744084556*^9, 3.544345829681706*^9, {3.544345867494666*^9, 
   3.544345890499711*^9}, 3.544346204496914*^9, 3.544354338478221*^9, 
   3.5443548988943768`*^9, 3.544355046484371*^9, 3.5443555213460417`*^9, {
   3.544355714539798*^9, 3.544355746349559*^9}, 3.544355916082425*^9, 
   3.5443560363184967`*^9, 3.544356189165947*^9, 3.544358396445879*^9, 
   3.5443590405055637`*^9, 3.544359106384474*^9, 3.544359179696825*^9, 
   3.544359422000256*^9, 3.5443596055929527`*^9, 3.544360232201666*^9, 
   3.5443605923758173`*^9, 3.544360761603354*^9, 3.544360992687561*^9, 
   3.544361264268943*^9, 3.544361376654171*^9, 3.544361473577532*^9, 
   3.5443615713525143`*^9, 3.544362014705804*^9, 3.544425094553258*^9, 
   3.544425242609898*^9, {3.544425553577655*^9, 3.544425564791789*^9}, 
   3.544425765197873*^9, {3.54443555127886*^9, 3.5444355814732857`*^9}, 
   3.544435699234106*^9, 3.544459820254578*^9, 3.5444602877729893`*^9, 
   3.544461521865593*^9, 3.544506726750579*^9, 3.544506949772532*^9, 
   3.544507048145782*^9, 3.5445070856684027`*^9, 3.544507310176951*^9, 
   3.544507788879345*^9, 3.544507858146755*^9, 3.544507987133094*^9, 
   3.544508515227724*^9, 3.544509096065795*^9, 3.544509770615479*^9, 
   3.544511864209529*^9, 3.544529282814007*^9, 3.5445296550426083`*^9, 
   3.544614281798962*^9, 3.5446146633641043`*^9, 3.544614798242095*^9, 
   3.5446211229111433`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load", "Section",
 CellChangeTimes->{{3.544508687636112*^9, 3.5445087090959663`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"veclist", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.868`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.07409605574209051`", ",", "2.120168551991567`", ",", 
         "0.9979641465626632`", ",", 
         RowBox[{"-", "0.13206619699953426`"}], ",", "0.1096803066408052`", 
         ",", "1.8798507183251827`", ",", 
         RowBox[{"-", "1.8883455741980362`"}], ",", 
         RowBox[{"-", "1.8849422184581242`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8630000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.10094946961325645`", ",", "2.11843896557585`", ",", 
         "0.996221622879231`", ",", 
         RowBox[{"-", "0.1804917165177124`"}], ",", "0.1492701497125977`", 
         ",", "1.884992279481818`", ",", 
         RowBox[{"-", "1.9007800178918746`"}], ",", 
         RowBox[{"-", "1.8930351877297216`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.858`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.12197000170131408`", ",", "2.1167233983193694`", ",", 
         "0.9944850339762491`", ",", 
         RowBox[{"-", "0.21876327909130314`"}], ",", "0.1801886009746716`", 
         ",", "1.8900978504268293`", ",", 
         RowBox[{"-", "1.9131742069140136`"}], ",", 
         RowBox[{"-", "1.9016726924990976`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8530000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.13991378424453033`", ",", "2.1149837348926606`", ",", 
         "0.9927440162648846`", ",", 
         RowBox[{"-", "0.2517293820681301`"}], ",", "0.20648020601257608`", 
         ",", "1.8952275889273653`", ",", 
         RowBox[{"-", "1.9256311591239745`"}], ",", 
         RowBox[{"-", "1.909808191488722`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.848`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.1558346013771002`", ",", "2.113225412671581`", ",", 
         "0.9910000469003952`", ",", 
         RowBox[{"-", "0.28124731545350495`"}], ",", "0.22972733575964316`", 
         ",", "1.900372935353736`", ",", 
         RowBox[{"-", "1.9381362448249575`"}], ",", 
         RowBox[{"-", "1.9180104248625407`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8430000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17016875000194848`", ",", "2.1115098780778703`", ",", 
         "0.9892697750637398`", ",", 
         RowBox[{"-", "0.3080592423512553`"}], ",", "0.2506153749130479`", 
         ",", "1.9054371593492085`", ",", 
         RowBox[{"-", "1.9505236948034614`"}], ",", 
         RowBox[{"-", "1.9261627936566683`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.84`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17826167507411272`", ",", "2.1104559051192573`", ",", 
         "0.9882259326796118`", ",", 
         RowBox[{"-", "0.32330581600520547`"}], ",", "0.26236779856342607`", 
         ",", "1.9085078859494449`", ",", 
         RowBox[{"-", "1.9580215612745053`"}], ",", 
         RowBox[{"-", "1.931121256897245`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.82`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.22488694197749054`", ",", "2.103380714521802`", ",", 
         "0.9812728968525489`", ",", 
         RowBox[{"-", "0.41286781222427793`"}], ",", "0.3296044742182707`", 
         ",", "1.9289306281682954`", ",", 
         RowBox[{"-", "2.008120303091178`"}], ",", 
         RowBox[{"-", "1.9650601848404534`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.263403558765456`", ",", "2.096205608174961`", ",", 
         "0.9743256730333851`", ",", 
         RowBox[{"-", "0.48939211154605033`"}], ",", "0.3843975474769295`", 
         ",", "1.9492937907951573`", ",", 
         RowBox[{"-", "2.05845848599753`"}], ",", 
         RowBox[{"-", "1.9995561358962997`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.78`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.29697518455095745`", ",", "2.0889423128476263`", ",", 
         "0.9673869185290676`", ",", 
         RowBox[{"-", "0.558279652709024`"}], ",", "0.4315291947985173`", ",",
          "1.9695814694547868`", ",", 
         RowBox[{"-", "2.1090091196394116`"}], ",", 
         RowBox[{"-", "2.0352685093571585`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.76`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.3271598204456268`", ",", "2.081567124294121`", ",", 
         "0.9604497669481518`", ",", 
         RowBox[{"-", "0.6221486306454592`"}], ",", "0.47328486423405836`", 
         ",", "1.9898325723528631`", ",", 
         RowBox[{"-", "2.1598388644472086`"}], ",", 
         RowBox[{"-", "2.071552595488018`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7200000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.3805021914087528`", ",", "2.066514870321669`", ",", 
         "0.9465874464830879`", ",", 
         RowBox[{"-", "0.7400039977668367`"}], ",", "0.5455047926770815`", 
         ",", "2.0301803808864767`", ",", 
         RowBox[{"-", "2.2622601874863317`"}], ",", 
         RowBox[{"-", "2.1473061767619304`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7000000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.4046128853375105`", ",", "2.0588198731087877`", ",", 
         "0.9396565452523309`", ",", 
         RowBox[{"-", "0.795537154126863`"}], ",", "0.5773661902403812`", ",",
          "2.0503081121045224`", ",", 
         RowBox[{"-", "2.3139052814335432`"}], ",", 
         RowBox[{"-", "2.186433658947585`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6800000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.42738986570203724`", ",", "2.0510415737040817`", ",", 
         "0.932732941463491`", ",", 
         RowBox[{"-", "0.8493817405747806`"}], ",", "0.607017515193857`", ",",
          "2.070362854344421`", ",", 
         RowBox[{"-", "2.3657698062065`"}], ",", 
         RowBox[{"-", "2.226488748803607`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6600000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.4490644897242795`", ",", "2.0431503052332096`", ",", 
         "0.9258082749841597`", ",", 
         RowBox[{"-", "0.9019290716600774`"}], ",", "0.6347851658005186`", 
         ",", "2.090391510684943`", ",", 
         RowBox[{"-", "2.4179342410329308`"}], ",", 
         RowBox[{"-", "2.2678968345073445`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.62`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.48966127102623513`", ",", "2.0270829673417428`", ",", 
         "0.9119680934315914`", ",", 
         RowBox[{"-", "1.0038852676290009`"}], ",", "0.6855185237246182`", 
         ",", "2.13029486109991`", ",", 
         RowBox[{"-", "2.5230393049728153`"}], ",", 
         RowBox[{"-", "2.3528071117321376`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5088314372895092`", ",", "2.018878236095998`", ",", 
         "0.9050440626366997`", ",", 
         RowBox[{"-", "1.0536960221886291`"}], ",", "0.7088332820279133`", 
         ",", "2.1502152257033487`", ",", 
         RowBox[{"-", "2.5760592963152127`"}], ",", 
         RowBox[{"-", "2.3967672740185004`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.58`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5273545275263245`", ",", "2.010575258529651`", ",", 
         "0.8981208966176263`", ",", 
         RowBox[{"-", "1.1028793495786011`"}], ",", "0.7309985511711032`", 
         ",", "2.170093522850811`", ",", 
         RowBox[{"-", "2.6293577550798335`"}], ",", 
         RowBox[{"-", "2.442127737440482`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.56`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5453077255774209`", ",", "2.0021626572013895`", ",", 
         "0.8911951179108348`", ",", 
         RowBox[{"-", "1.1515364877849836`"}], ",", "0.7520675842519604`", 
         ",", "2.189947276035549`", ",", 
         RowBox[{"-", "2.682965705949222`"}], ",", 
         RowBox[{"-", "2.4880947291761606`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.52`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5797281594432059`", ",", "1.9850115064241494`", ",", 
         "0.8773345210374353`", ",", 
         RowBox[{"-", "1.2476078725156199`"}], ",", "0.7913395670399445`", 
         ",", "2.229582003315571`", ",", 
         RowBox[{"-", "2.791119378501514`"}], ",", 
         RowBox[{"-", "2.5830794221371645`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5962865178030728`", ",", "1.9762766204423838`", ",", 
         "0.8703996350381962`", ",", 
         RowBox[{"-", "1.2951477748864133`"}], ",", "0.8097010177996378`", 
         ",", "2.2493599143445286`", ",", 
         RowBox[{"-", "2.845665400722957`"}], ",", 
         RowBox[{"-", "2.6321062777511957`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.48`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6124714214301092`", ",", "1.9674207398689028`", ",", 
         "0.8634571985828617`", ",", 
         RowBox[{"-", "1.3424501191023754`"}], ",", "0.8272732318349333`", 
         ",", "2.2691341396915985`", ",", 
         RowBox[{"-", "2.9005642737031407`"}], ",", 
         RowBox[{"-", "2.6822204172706203`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.44`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6438209671286115`", ",", "1.9493940340092228`", ",", 
         "0.849559994780463`", ",", 
         RowBox[{"-", "1.4364446858730455`"}], ",", "0.8603685854903844`", 
         ",", "2.308605812587862`", ",", 
         RowBox[{"-", "3.011326105997462`"}], ",", 
         RowBox[{"-", "2.7860539537726856`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.4200000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6590456785721874`", ",", "1.9402159607617797`", ",", 
         "0.8426022906426062`", ",", 
         RowBox[{"-", "1.4832140488394734`"}], ",", "0.8759550669907962`", 
         ",", "2.328315490980453`", ",", 
         RowBox[{"-", "3.067216233533839`"}], ",", 
         RowBox[{"-", "2.839376372487654`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.3800000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6887287617582241`", ",", "1.9215013977136444`", ",", 
         "0.8286586577921988`", ",", 
         RowBox[{"-", "1.5764938761555642`"}], ",", "0.9053719458902377`", 
         ",", "2.367726088123225`", ",", 
         RowBox[{"-", "3.1801001723213007`"}], ",", 
         RowBox[{"-", "2.9494204405805933`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.36`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7032264406191593`", ",", "1.911966636481573`", ",", 
         "0.8216720594144495`", ",", 
         RowBox[{"-", "1.6230575588931981`"}], ",", "0.9192800184979449`", 
         ",", "2.3874262771487995`", ",", 
         RowBox[{"-", "3.2371024942745943`"}], ",", 
         RowBox[{"-", "3.0061441868231955`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.34`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7175184633466903`", ",", "1.9023140363077047`", ",", 
         "0.8146750132812847`", ",", 
         RowBox[{"-", "1.6695961776918746`"}], ",", "0.9326989945280368`", 
         ",", "2.4071224483050213`", ",", 
         RowBox[{"-", "3.2944823760345705`"}], ",", 
         RowBox[{"-", "3.0640137430428847`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.32`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7316236278236997`", ",", "1.892538357642916`", ",", 
         "0.8076656225360733`", ",", 
         RowBox[{"-", "1.716138544533985`"}], ",", "0.9456473034737107`", ",",
          "2.4268225920081994`", ",", 
         RowBox[{"-", "3.352257372105316`"}], ",", 
         RowBox[{"-", "3.1230544109686846`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.28`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.759327630044047`", ",", "1.8726252884090915`", ",", 
         "0.7936093988176277`", ",", 
         RowBox[{"-", "1.8092946252978641`"}], ",", "0.9702715256209089`", 
         ",", "2.4662250249723754`", ",", 
         RowBox[{"-", "3.468998672177377`"}], ",", 
         RowBox[{"-", "3.244691808425779`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.23`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.793157516173759`", ",", "1.8470221833116771`", ",", 
         "0.7759543195536678`", ",", 
         RowBox[{"-", "1.926084168284337`"}], ",", "0.9988649230120109`", ",",
          "2.5155298343116375`", ",", 
         RowBox[{"-", "3.6172923759074913`"}], ",", 
         RowBox[{"-", "3.403639782925374`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.18`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.8262833012364006`", ",", "1.8205837200802935`", ",", 
         "0.7581849149437223`", ",", 
         RowBox[{"-", "2.043517834789346`"}], ",", "1.0252809707518953`", ",",
          "2.564951928019079`", ",", 
         RowBox[{"-", "3.768399956744153`"}], ",", 
         RowBox[{"-", "3.5705963723620657`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.03`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.9230488688213225`", ",", "1.73588609398436`", ",", 
         "0.7039940643249193`", ",", 
         RowBox[{"-", "2.4019805149276023`"}], ",", "1.0942543883857436`", 
         ",", "2.7143508760863733`", ",", 
         RowBox[{"-", "4.240489973931262`"}], ",", 
         RowBox[{"-", "4.123436603974003`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.98`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.9549279981238569`", ",", "1.7056750601798654`", ",", 
         "0.6855521428817635`", ",", 
         RowBox[{"-", "2.5242985092271657`"}], ",", "1.114555308899134`", ",",
          "2.7647280495543316`", ",", 
         RowBox[{"-", "4.404914229188696`"}], ",", 
         RowBox[{"-", "4.326628213569345`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9299999999999999`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.986857615616634`", ",", "1.6743550719995128`", ",", 
         "0.6668700888623107`", ",", 
         RowBox[{"-", "2.6484410797834674`"}], ",", "1.1338173625182217`", 
         ",", "2.815515897460275`", ",", 
         RowBox[{"-", "4.573359485184544`"}], ",", 
         RowBox[{"-", "4.540306961248853`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.88`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0189782070091018`", ",", "1.6418495888986004`", ",", 
         "0.6479144619747503`", ",", 
         RowBox[{"-", "2.7746598884801315`"}], ",", "1.1522566054543582`", 
         ",", "2.8667820124242054`", ",", 
         RowBox[{"-", "4.746155719065648`"}], ",", 
         RowBox[{"-", "4.76514244154874`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8300000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0514363539949725`", ",", "1.6080712188475348`", ",", 
         "0.6286476155983801`", ",", 
         RowBox[{"-", "2.903241545154152`"}], ",", "1.1701212378997488`", ",",
          "2.9185998862859255`", ",", 
         RowBox[{"-", "4.923682903219094`"}], ",", 
         RowBox[{"-", "5.002008900278566`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.78`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0844010454097461`", ",", "1.572887661093316`", ",", 
         "0.6090193365955197`", ",", 
         RowBox[{"-", "3.034504887082299`"}], ",", "1.1875031258439983`", ",",
          "2.971090532668834`", ",", 
         RowBox[{"-", "5.106421449956452`"}], ",", 
         RowBox[{"-", "5.251811873544956`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.73`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1180479966266779`", ",", "1.5361730163991627`", ",", 
         "0.588978613592471`", ",", 
         RowBox[{"-", "3.1688120759508878`"}], ",", "1.2046503944973106`", 
         ",", "3.024353579034675`", ",", 
         RowBox[{"-", "5.294886464737035`"}], ",", 
         RowBox[{"-", "5.515627155864887`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.6799999999999999`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1525837188902464`", ",", "1.4977570080308695`", ",", 
         "0.568461058774028`", ",", 
         RowBox[{"-", "3.306576091782493`"}], ",", "1.2217108459212238`", ",",
          "3.078528825897698`", ",", 
         RowBox[{"-", "5.489706657652221`"}], ",", 
         RowBox[{"-", "5.794792774146105`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.63`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1882418065099052`", ",", "1.4574526479500487`", ",", 
         "0.5473946051470174`", ",", 
         RowBox[{"-", "3.44828153950453`"}], ",", "1.2389675741800101`", ",", 
         "3.1337571079417206`", ",", 
         RowBox[{"-", "5.69160646740515`"}], ",", 
         RowBox[{"-", "6.091006264154231`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.58`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.225305531795742`", ",", "1.415017305618747`", ",", 
         "0.5256894636474833`", ",", 
         RowBox[{"-", "3.5945070249561994`"}], ",", "1.2566285813178981`", 
         ",", "3.190224734457376`", ",", 
         RowBox[{"-", "5.901477288136015`"}], ",", 
         RowBox[{"-", "6.406073534076588`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.53`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.2641202878210855`", ",", "1.3701532912838383`", ",", 
         "0.5032367592682069`", ",", 
         RowBox[{"-", "3.745944023702552`"}], ",", "1.2749492456089138`", ",",
          "3.2481515787097424`", ",", 
         RowBox[{"-", "6.12039536605819`"}], ",", 
         RowBox[{"-", "6.742346946394514`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.48`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3051173605423914`", ",", "1.3224924070876931`", ",", 
         "0.47990281899507703`", ",", 
         RowBox[{"-", "3.903453166116109`"}], ",", "1.2942804705700126`", ",",
          "3.3078010338537096`", ",", 
         RowBox[{"-", "6.3496994746537645`"}], ",", 
         RowBox[{"-", "7.102722008787847`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.42999999999999994`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3488591460162878`", ",", "1.271548393431121`", ",", 
         "0.4555152710323542`", ",", 
         RowBox[{"-", "4.0681096407769`"}], ",", "1.3149514902873514`", ",", 
         "3.3695179164521227`", ",", 
         RowBox[{"-", "6.591085402958407`"}], ",", 
         RowBox[{"-", "7.490873737285019`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.38`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3960957591064582`", ",", "1.216685753047732`", ",", 
         "0.42985107157498326`", ",", 
         RowBox[{"-", "4.241312742141526`"}], ",", "1.337427292084789`", ",", 
         "3.4337399590177204`", ",", 
         RowBox[{"-", "6.84675801294185`"}], ",", 
         RowBox[{"-", "7.911597762080053`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.32999999999999996`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.447873230106782`", ",", "1.1570340351583543`", ",", 
         "0.4026093032641672`", ",", 
         RowBox[{"-", "4.4249325467136185`"}], ",", "1.3622900283129145`", 
         ",", "3.501054633931335`", ",", 
         RowBox[{"-", "7.119675995248774`"}], ",", 
         RowBox[{"-", "8.371305919012228`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.28`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.5057236960045268`", ",", "1.0913518674675085`", ",", 
         "0.373367196787542`", ",", 
         RowBox[{"-", "4.621576053138501`"}], ",", "1.390318997704208`", ",", 
         "3.572281474924267`", ",", 
         RowBox[{"-", "7.413971974028285`"}], ",", 
         RowBox[{"-", "8.878975020794677`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.22999999999999998`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.57203980735116`", ",", "1.0177678673734798`", ",", 
         "0.34149736181382523`", ",", 
         RowBox[{"-", "4.835076798074535`"}], ",", "1.4226214179605465`", ",",
          "3.6486273990264926`", ",", 
         RowBox[{"-", "7.735734242987447`"}], ",", 
         RowBox[{"-", "9.44782848881641`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.07999999999999985`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.8892842980600542`", ",", "0.7021647764329307`", ",", 
         "0.21477094825370602`", ",", 
         RowBox[{"-", "5.668698911077289`"}], ",", "1.571068461292025`", ",", 
         "3.937321470523456`", ",", 
         RowBox[{"-", "9.011955267383346`"}], ",", 
         RowBox[{"-", "11.838448294690265`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.030000000000000027`", ",", 
       RowBox[{"{", 
        RowBox[{
        "2.14505629502275`", ",", "0.5002442116584971`", ",", 
         "0.14210334806045316`", ",", 
         RowBox[{"-", "6.127329861034945`"}], ",", "1.6695931030439755`", ",",
          "4.090153831975672`", ",", 
         RowBox[{"-", "9.72589898707181`"}], ",", 
         RowBox[{"-", "13.263510038735388`"}]}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.543993657871076*^9, 3.543993663845245*^9}, {
  3.543993852715075*^9, 3.54399385931518*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"hort1", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"veclist", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", "2", ",", "2"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymscalre", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"veclist", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", "2", ",", "4"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymscalim", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"veclist", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", "2", ",", "5"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymscal", "=", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"asymscalre", "^", "2"}], "+", 
      RowBox[{"asymscalim", "^", "2"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asym\[Mu]", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"veclist", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", "2", ",", "6"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymq", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"veclist", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", "2", ",", "7"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"asym\[Rho]", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"veclist", "[", 
      RowBox[{"[", 
       RowBox[{"ii", ",", "2", ",", "8"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", 
       RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.54385840855757*^9, 3.543858478411048*^9}, {
  3.5438629561121693`*^9, 3.543862967887542*^9}, {3.5438667569267807`*^9, 
  3.543866769631545*^9}, {3.543993923118877*^9, 3.543993930541388*^9}, {
  3.544418567406822*^9, 3.544418572688039*^9}, {3.54442344203242*^9, 
  3.54442345380746*^9}, {3.544503790725836*^9, 3.544503795868767*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Compare to equilibrium", "Section",
 CellChangeTimes->{{3.544508687636112*^9, 3.54450872500736*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Tfn", "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"zarr", ",", 
        RowBox[{"tdat", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "All"}], "]"}], "]"}]}], "}"}], "]"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"afn", "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"zarr", ",", 
        RowBox[{"adat", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "All"}], "]"}], "]"}]}], "}"}], "]"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ffn", "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"zarr", ",", 
        RowBox[{"fdat", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "All"}], "]"}], "]"}]}], "}"}], "]"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hfn", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"zarr", ",", 
       RowBox[{"hdat", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "All"}], "]"}], "]"}]}], "}"}], "]"}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544508753288253*^9, 3.544508755631455*^9}, {
  3.544511950827201*^9, 3.5445119569475594`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Psi]val", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ffn", "'"}], "[", "0", "]"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{
      RowBox[{"hfn", "'"}], "[", "0", "]"}], "^", "2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544511928510941*^9, 3.544511929970373*^9}, {
  3.544511961713673*^9, 3.544511969978005*^9}}],

Cell[BoxData["2.4735795505396854`"], "Output",
 CellChangeTimes->{{3.544511970381317*^9, 3.544511977603178*^9}, 
   3.544529290127761*^9, 3.5445296620380774`*^9, 3.544621192940136*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Tfn", "'"}], "[", "0", "]"}], 
    RowBox[{"\[Mu]val", "^", "3"}]], ",", 
   FractionBox["\[Psi]val", 
    RowBox[{"\[Mu]val", "^", "2"}]]}], "}"}]], "Input",
 CellChangeTimes->{{3.54462128203598*^9, 3.544621282403606*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.24409844445701032`"}], ",", "0.2621585105513494`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.544621282842791*^9, {3.54462131837129*^9, 3.544621332540056*^9}, {
   3.544621397618311*^9, 3.544621400673298*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Mu]val", "=", "aval"}], ";"}]], "Input",
 CellChangeTimes->{{3.5446212026800413`*^9, 3.544621205652492*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Mu]val", "=", "\[Mu]f"}], ";"}]], "Input",
 CellChangeTimes->{{3.5446212374916983`*^9, 3.544621249192658*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"plt1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["asym\[Rho]", 
         RowBox[{"asym\[Mu]", "^", "3"}]], ",", 
        FractionBox["asymscal", 
         RowBox[{"asym\[Mu]", "^", "2"}]]}], "}"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "15"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plt2", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"Tfn", "'"}], "[", "0", "]"}], 
        RowBox[{"\[Mu]val", "^", "3"}]], ",", 
       FractionBox["\[Psi]val", 
        RowBox[{"\[Mu]val", "^", "2"}]]}], "}"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.54450396954886*^9, 3.54450397015753*^9}, {
   3.54450400691886*^9, 3.5445040473402243`*^9}, {3.544504078545775*^9, 
   3.5445040983215113`*^9}, {3.544504174830225*^9, 3.544504182656066*^9}, {
   3.5445118943893013`*^9, 3.544511917356346*^9}, 3.54451198268474*^9, {
   3.5446212086401176`*^9, 3.544621209471713*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAA8+LmEOAo0r9d0lOzZ9+oP7byChS8
FtK/cOhE2ADgsD843G2wRAbSvyDKQ1M2T7Q/e3fEcHv00b/ViBqEXzS3P+4z
ISPU4tG/vVN5oPa9uT8DnSxuudHRv0ercNFVALw/09iXYW3H0b/6PPgsiUO9
P1lDQNTchdG/+HqS25kswj8v6ttCDEfRv+V6qlCc9sQ/uGpOMloM0b/HwUKD
VEjHPzfwYiLo09C/82DQqFxFyT8GsK5IdWzQv2SL5QX2jMw/RhZPHjk80L9E
FeRLLe7NPx3ky3uPDtC/Q9lBhfEszz+UUe4pncfPv/CVmv9OJ9A/HIJfG8Am
z78ZOV9ytSTRP8Ck0Y4N3M6/XltzGz2U0T8cXlrWYZbOvxiPJF5M+9E/GNX5
OsFSzr91r22bo1rSP2rANXvn1M2/fdSiamMF0z8TiDXVYZrNv7dukc8VUtM/
xHKkgYdizb/1hY3ZoJnTPx/0GKLD+8y/M70VQUsb1D+rM0tEW8vMv6O3K7sV
VtQ/LOVJMwVxzL9c8FSjD8HUP1HaKbHaRsy/vvHvGdDx1D+0SEdWkR7Mv23/
Pzu5H9U/Pm+6Bgr4y79WtfBt+krVP3oaeZcGsMu/TguWh1ea1T9/7axykF7L
v9WvMxiw8dU/kQzM+oEVy78r8zphsz3WPwMx6j1WZMq/NgfkU5ft1j+jq5WQ
wjTKv7SFyK2rGtc/g0hf2e8Jyr8yIwz4Y0LXP/YRkwhh48m/vL/bTnll1z/D
q/vyz8DJv/rRq16YhNc/pBc2CA==
      "]]}, {}}, 
   PointBox[{-0.24409844445701032`, 0.2621585105513494}]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-0.28, 0},
  PlotRange->{{-0.2837448277528402, -0.20119666447075532`}, {
    0, 0.3674679684184238}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.544503970608225*^9, {3.5445040075503197`*^9, 3.544504047763155*^9}, {
   3.544504079379222*^9, 3.544504102201434*^9}, 3.544504183209312*^9, 
   3.544504304914796*^9, {3.544504386728879*^9, 3.5445044114587173`*^9}, {
   3.5445056482574787`*^9, 3.54450567606145*^9}, 3.544505828709778*^9, {
   3.5445059353320827`*^9, 3.544505947980145*^9}, 3.544511983284769*^9, 
   3.5445120477540092`*^9, 3.544529664111886*^9, {3.54462119383974*^9, 
   3.544621210278523*^9}, {3.544621242684434*^9, 3.5446212707234297`*^9}, 
   3.544621403666896*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"plt1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"asym\[Mu]", ",", 
        FractionBox["asymscal", 
         RowBox[{"asym\[Mu]", "^", "2"}]]}], "}"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "15"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plt2", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Mu]val", "*", "horiz"}], ",", 
       FractionBox["\[Psi]val", 
        RowBox[{"\[Mu]val", "^", "2"}]]}], "}"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.54450396954886*^9, 3.54450397015753*^9}, {
  3.54450400691886*^9, 3.5445040473402243`*^9}, {3.544504078545775*^9, 
  3.5445040983215113`*^9}, {3.544504174830225*^9, 3.544504182656066*^9}, {
  3.5445043966711407`*^9, 3.544504407578034*^9}, {3.54450595783915*^9, 
  3.5445059624872*^9}, {3.544506347956093*^9, 3.544506403466036*^9}, {
  3.544512000253228*^9, 3.544512029971548*^9}, {3.544621212591342*^9, 
  3.544621213567589*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAArBnJWN4T/j9d0lOzZ9+oP/FjGart
KP4/cOhE2ADgsD+MK10+1z3+PyDKQ1M2T7Q/LrgOKtpS/j/ViBqEXzS3P93D
eHPtZ/4/vVN5oPa9uT/Qzr+sq3z+P0ercNFVALw/tfmkkD+J/j/6PPgsiUO9
P+DEw1zm3P4/+HqS25kswj9ULZyvTjD/P+V6qlCc9sQ/3Nrh22eD/z/HwUKD
VEjHP25W7K1a1v8/82DQqFxFyT8eGyc2zz0AQGSL5QX2jMw/DLOB8AdnAEBE
FeRLLe7NP5kZcmYakABAQ9lBhfEszz+r0jEvH7kAQPCVmv9OJ9A/exY6CNgK
AUAZOV9ytSTRP6AOTgqkMwFAXltzGz2U0T/MPi/+WVwBQBiPJF5M+9E/tkvU
EwOFAUB1r22bo1rSP6Hs3xYv1gFAfdSiamMF0z9LWChpsP4BQLdukc8VUtM/
ObPBzC8nAkD1hY3ZoJnTP+xcA1MGeAJAM70VQUsb1D/1P0TfY6ACQKO3K7sV
VtQ/iwATYBrxAkBc8FSjD8HUP5S4r/JyGQNAvvHvGdDx1D8JgAdqyUEDQG3/
Pzu5H9U/DvSO9iFqA0BWtfBt+krVP0Oqli/UugNATguWh1ea1T+k2BMbzh8E
QNWvMxiw8dU/lDs1hAWFBEAr8zphsz3WP4VHlZf9tgVANgfkU5ft1j+XW1m9
KR4GQLSFyK2rGtc/Ba7nMi2GBkAyIwz4Y0LXP/b7YGgr7wZAvL/bTnll1z+x
qK3lSlkHQPrRq16YhNc//+wRTA==
      "]]}, {}}, 
   PointBox[{2.1029330512544084`, 0.2621585105513494}]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{2., 0},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.544504307386313*^9, {3.5445043892765837`*^9, 3.5445044122605333`*^9}, {
   3.544505649293027*^9, 3.544505676843574*^9}, 3.544505829684805*^9, {
   3.5445059538041286`*^9, 3.54450596290441*^9}, {3.544506351217532*^9, 
   3.544506404051579*^9}, {3.544512041310709*^9, 3.544512068296822*^9}, 
   3.544529669022197*^9, {3.544621195505952*^9, 3.544621214161161*^9}, {
   3.5446213734037457`*^9, 3.544621409030641*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"plt1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"asym\[Mu]", ",", 
        FractionBox["asym\[Rho]", 
         RowBox[{"asym\[Mu]", "^", "3"}]]}], "}"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "15"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plt2", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Mu]val", "*", "horiz"}], ",", 
       FractionBox[
        RowBox[{
         RowBox[{"Tfn", "'"}], "[", "0", "]"}], 
        RowBox[{"\[Mu]val", "^", "3"}]]}], "}"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5445044250704536`*^9, 3.5445044350603247`*^9}, 
   3.544505982962347*^9, {3.544512122233067*^9, 3.544512135182517*^9}, {
   3.544621216703223*^9, 3.544621217711388*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAArBnJWN4T/j/z4uYQ4CjSv/FjGart
KP4/tvIKFLwW0r+MK10+1z3+PzjcbbBEBtK/LrgOKtpS/j97d8Rwe/TRv93D
eHPtZ/4/7jMhI9Ti0b/Qzr+sq3z+PwOdLG650dG/tfmkkD+J/j/T2JdhbcfR
v+DEw1zm3P4/WUNA1NyF0b9ULZyvTjD/Py/q20IMR9G/3Nrh22eD/z+4ak4y
WgzRv25W7K1a1v8/N/BiIujT0L8eGyc2zz0AQAawrkh1bNC/DLOB8AdnAEBG
Fk8eOTzQv5kZcmYakABAHeTLe48O0L+r0jEvH7kAQJRR7imdx8+/exY6CNgK
AUAcgl8bwCbPv6AOTgqkMwFAwKTRjg3czr/MPi/+WVwBQBxeWtZhls6/tkvU
EwOFAUAY1fk6wVLOv6Hs3xYv1gFAasA1e+fUzb9LWChpsP4BQBOINdVhms2/
ObPBzC8nAkDEcqSBh2LNv+xcA1MGeAJAH/QYosP7zL/1P0TfY6ACQKszS0Rb
y8y/iwATYBrxAkAs5UkzBXHMv5S4r/JyGQNAUdopsdpGzL8JgAdqyUEDQLRI
R1aRHsy/DvSO9iFqA0A+b7oGCvjLv0Oqli/UugNAehp5lwawy7+k2BMbzh8E
QH/trHKQXsu/lDs1hAWFBECRDMz6gRXLv4VHlZf9tgVAAzHqPVZkyr+XW1m9
KR4GQKOrlZDCNMq/Ba7nMi2GBkCDSF/Z7wnKv/b7YGgr7wZA9hGTCGHjyb+x
qK3lSlkHQMOr+/LPwMm/Gd0fZQ==
      "]]}, {}}, 
   PointBox[{2.1029330512544084`, -0.24409844445701032`}]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{2., -0.29},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.544504435550949*^9, {3.54450565462031*^9, 3.544505678848748*^9}, 
   3.5445058305435753`*^9, 3.544505984263548*^9, 3.544512137830452*^9, 
   3.544529670908182*^9, 3.544621218334384*^9, 3.54462141328498*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"plt1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"asym\[Mu]", ",", 
        FractionBox["hort1", "asym\[Mu]"]}], "}"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "15"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plt2", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Mu]val", "*", "horiz"}], ",", 
       FractionBox["temp", "\[Mu]val"]}], "}"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.544504681904351*^9, 3.544504699711619*^9}, {
   3.544504757935499*^9, 3.544504758847192*^9}, {3.54450479222648*^9, 
   3.544504796569023*^9}, 3.5445059872023363`*^9, {3.544512159872115*^9, 
   3.5445121903497257`*^9}, {3.544512352250084*^9, 3.544512354568919*^9}, {
   3.5446212213993273`*^9, 3.5446212221990643`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAArBnJWN4T/j9Sjc+uoAvyP/FjGart
KP4/8bUFy0T78T+MK10+1z3+P0UlDtMd6/E/LrgOKtpS/j9Y6Hzh8NrxP93D
eHPtZ/4/ch6za8bK8T/Qzr+sq3z+P5Ti4lL7uvE/tfmkkD+J/j8tiU2parHx
P+DEw1zm3P4/V4qy6G9y8T9ULZyvTjD/P5nLUbOzNPE/3Nrh22eD/z8sNOvx
OfjwP25W7K1a1v8/e0S0E9W88D8eGyc2zz0AQHN9yYtOSfA/DLOB8AdnAEA+
fpodARHwP5kZcmYakABA9vbutoyz7z+r0jEvH7kAQIEDRwPeRu8/exY6CNgK
AUAk0i3dGXPuP6AOTgqkMwFAEQ5gKKAL7j/MPi/+WVwBQMX1D33Tpe0/tkvU
EwOFAUCVfAdvjEHtP6Hs3xYv1gFAmQJSNGR97D9LWChpsP4BQLolw31zHew/
ObPBzC8nAkB1Dl0Nwr7rP+xcA1MGeAJAVyVvxFkF6z/1P0TfY6ACQBi8JWGA
quo/iwATYBrxAkCL6HcMIPjpP5S4r/JyGQNAIcpi7oyg6T8JgAdqyUEDQB/y
ceAESuk/DvSO9iFqA0Bt/DZcd/ToP0Oqli/UugNA25G/DUFM6D+k2BMbzh8E
QJ0KfzD1fuc/lDs1hAWFBECi7EfTnrbmP4VHlZf9tgVAGRc2EPZ25D+XW1m9
KR4GQIBvLcr7veM/Ba7nMi2GBkDlLjtJsAfjP/b7YGgr7wZATVhey65T4j+x
qK3lSlkHQErd6zGToeE/HFASPg==
      "]]}, {}}, 
   PointBox[{2.1029330512544084`, 0.9689214919890103}]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{2., 0},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.544504674651637*^9, 3.54450470080588*^9}, 
   3.5445047592612963`*^9, 3.544504797147745*^9, {3.5445056628689117`*^9, 
   3.544505681485663*^9}, 3.544505832499673*^9, 3.544505987691502*^9, {
   3.544512172331985*^9, 3.544512191190284*^9}, 3.544512355106113*^9, 
   3.544529673046802*^9, 3.544621222642624*^9, 3.54462141729357*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"plt1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"asym\[Mu]", ",", 
        FractionBox["asymq", 
         RowBox[{"asym\[Mu]", "^", "2"}]]}], "}"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "15"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Mu]val", "*", "horiz"}], ",", 
        FractionBox[
         RowBox[{
          RowBox[{"afn", "'"}], "[", "0", "]"}], 
         RowBox[{"\[Mu]val", "^", "2"}]]}], "}"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.544512390912447*^9, 3.54451243596096*^9}, {
  3.544621224823292*^9, 3.54462122581495*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAArBnJWN4T/j8BnWc6fBnhv/FjGart
KP4/6ck6NU4e4b+MK10+1z3+P7oanVUVI+G/LrgOKtpS/j9lDJH8xifhv93D
eHPtZ/4/ddFbx2Qs4b/Qzr+sq3z+P5grrWkBMeG/tfmkkD+J/j+eLeDLtzPh
v+DEw1zm3P4/QKqhmENF4b9ULZyvTjD/P/5O/EHmVeG/3Nrh22eD/z8wjqb/
sWXhv25W7K1a1v8/d61bXKt04b8eGyc2zz0AQFgeo+dhkOG/DLOB8AdnAECq
nc5ALZ3hv5kZcmYakABAPQ8lPl2p4b+r0jEvH7kAQCovfXvutOG/exY6CNgK
AUCj4Hdkb8rhv6AOTgqkMwFAT8P+p2HU4b/MPi/+WVwBQDR/iMXb3eG/tkvU
EwOFAUBihMJI3+bhv6Hs3xYv1gFALlJdXp334b9LWChpsP4BQIr0IEhm/+G/
ObPBzC8nAkCdq++oygbiv+xcA1MGeAJAZGpwipUU4r/1P0TfY6ACQF/QNZQC
G+K/iwATYBrxAkCag/+48ibiv5S4r/JyGQNAA4BDM4As4r8JgAdqyUEDQD3s
VpvMMeK/DvSO9iFqA0BfwD0J2Tbiv0Oqli/UugNA4cX6K0dA4r+k2BMbzh8E
QDVzI6blSuK/lDs1hAWFBEBbPbVGVFTiv4VHlZf9tgVApJ8Jo+pq4r+XW1m9
KR4GQHe3vivgcOK/Ba7nMi2GBkD/KZx0K3biv/b7YGgr7wZAv/PEGeN64r+x
qK3lSlkHQHtJ/XUef+K/2z8i5Q==
      "]]}, {}}, 
   PointBox[{2.1029330512544084`, -0.5567120249920076}]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{2., -0.582},
  PlotRange->{{1.8798507183251827`, 
   2.9185998862859255`}, {-0.582, -0.5343609944074218}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.544512399806099*^9, 3.544512436719859*^9}, 
   3.544529674800106*^9, 3.544621226216007*^9, 3.544621422219082*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Functions", "Section",
 CellChangeTimes->{{3.544508687636112*^9, 3.5445086932253113`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"skip", "=", 
    RowBox[{"Round", "[", 
     RowBox[{"size", "/", "50"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"\[Psi]dat", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"fdat", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"hdat", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"aplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"adat", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"tdat", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"splt", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"varr", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], ",", 
         RowBox[{"zarr", "[", 
          RowBox[{"[", "jj", "]"}], "]"}], ",", 
         RowBox[{"sdat", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5442504582349873`*^9, 3.544250584036578*^9}, 
   3.544250626644371*^9, {3.544250822560841*^9, 3.544250823367763*^9}, {
   3.5442509165343533`*^9, 3.544251133374446*^9}, {3.544251467199772*^9, 
   3.544251471241907*^9}, {3.544252339447783*^9, 3.544252348921164*^9}, {
   3.544252422297391*^9, 3.544252437776615*^9}, {3.544262042155575*^9, 
   3.544262059275323*^9}, 3.544262159662603*^9, {3.5442724024879303`*^9, 
   3.544272416568007*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eq1plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"eq1", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq2plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"eq2", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq3plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"eq3", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq4plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"eq4", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq5plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"eq5", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"const1plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"const1", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"const2plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"const2", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"const3plt", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"varr", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], ",", 
         RowBox[{"zarr", "[", 
          RowBox[{"[", "jj", "]"}], "]"}], ",", 
         RowBox[{"const3", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5442504582349873`*^9, 3.544250584036578*^9}, 
   3.544250626644371*^9, {3.544250822560841*^9, 3.544250823367763*^9}, {
   3.5442509165343533`*^9, 3.544251133374446*^9}, {3.544251467199772*^9, 
   3.544251471241907*^9}, {3.544252339447783*^9, 3.544252348921164*^9}, {
   3.544252422297391*^9, 3.544252437776615*^9}, {3.544262042155575*^9, 
   3.544262059275323*^9}, 3.544262159662603*^9, {3.5442724024879303`*^9, 
   3.544272416568007*^9}, {3.544286163741596*^9, 3.544286224774358*^9}, {
   3.544461804009173*^9, 3.5444618115893793`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]divzplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{"\[Psi]dat", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fdivzplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{"fdat", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hdivzplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{
            RowBox[{"hdat", "[", 
             RowBox[{"[", 
              RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "-", 
            RowBox[{"hdat", "[", 
             RowBox[{"[", 
              RowBox[{"ii", ",", "1"}], "]"}], "]"}]}], 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tdivzplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{"tdat", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sdivzplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{"sdat", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gttplt", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"varr", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], ",", 
         RowBox[{"zarr", "[", 
          RowBox[{"[", "jj", "]"}], "]"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{
           RowBox[{"tdat", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{"zarr", "[", 
             RowBox[{"[", "jj", "]"}], "]"}], "^", "2"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBmIQrRSY1iSf8crxmF8dmJ7WsaILRM+QYOwG0bGqN/tA
dOKfOf0gWsv82WMQ/ZFB4wlY3d/d30H0ur2pP0D0Io1XTApAumrXWmYQbfd1
TbwikD7EypYAoj/tiCgA0Wu4rAtB9JWSy5tVgHRSx+ltIDq84tshEK3hnncY
RN+tNjyrCTJX8hqYPhQx30ALSP9brWwIojftK70PogNfvnsMom94S78F0fdc
Bd6D6DX9VofcgbSqL9dhEF3Yv+Q4iO4oKjsFok9e+3MORAdoMZ4H0SGpPSbe
IHUnfUxBdFGVykpfIL1DNWIViAYA8UeUcA==
  "]],

Cell[BoxData[
 RowBox[{
  RowBox[{"niceplot", "[", 
   RowBox[{"x_", ",", "rng_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpplt1", "=", 
     RowBox[{"ListPlot3D", "[", 
      RowBox[{"x", ",", 
       RowBox[{"PlotRange", "\[Rule]", "rng"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<v\>\"", ",", "\"\<z\>\""}], "}"}]}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpplt2", "=", 
     RowBox[{"ListPointPlot3D", "[", 
      RowBox[{"x", ",", 
       RowBox[{"PlotRange", "\[Rule]", "rng"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<v\>\"", ",", "\"\<z\>\""}], "}"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{"tmpplt1", ",", "tmpplt2"}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.544250849419471*^9, 3.544250878676875*^9}, {
  3.544250911535594*^9, 3.544250912334264*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"gttplt", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5442747337418118`*^9, 3.5442747484038467`*^9}, {
  3.5442748165352716`*^9, 3.544274817414777*^9}, {3.5443562022437887`*^9, 
  3.544356203011685*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJzt3XlUjWsf//FySEoaRHHMMhUiIZXaSuahwZSpEHXKmBAyF5lDhgyJbJTx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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNnHd4VEUXxnezNwSlFyFA6EVAQJAm0lEEgtKLNJWuIk3pSEcFgiBdpYuU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          "]], Polygon3DBox[CompressedData["
1:eJwlk0swVmEYx893vuc0ssSyFhayzIwNW5ZaNcOSGSttNGyz1LaWyciUoZRL
uXZDuRSF3LoSEmm6kEvSlX6P/+L3fb95L+d93ud/Tmrx6ZOlYRAE2WDwnJ9s
Bk7AC/w1FOHl8AYPoyBYjwdBDI/jNfynsS8LLuGrsMLaXfiIX4Y85grhCr4H
I+yfg30/MJIfPBPfYqwAPwXbeBPcYFkvNOPvoY9nT8Ey/t20tgJ2TGf4WWVQ
hzeYvBKu4gNwLsY6GMR7IB8vgV78DhzHc+Aufs/kvuY+3g1HYlpzG39g2nsG
HvrdYBifhSf4kOmsTniEfzL1JpF6P+Nf4SieAWumMZ/zsS/4umkuF77hL03Z
eCav8L/QFVdP/+HTcCxUhjP4rCm7szBnqtFr9R704++8x6F6uoRbpGxTIMIf
m2r3Ow3jP0y9Pg+7+DPPkL3JMIG3wiRDy3DTlIH3vxwy8QWoCnXmoilTz9b3
tJgy8qwuwDW83rTXn+FZrpiy93fsA95oWuvvyHU/21SL92AKb/eamTtM/R34
oUh3S4cEvNM055l24WOwFtOdxvGnpix9bBTfMGXh7+gm/tbUW7/TvOkb8G/B
3/la/JapF15DG/7bexJXZn/wn6Ze+tgv/CIkBfqmqvH/6S2OMw==
          "]]}]}, 
      {GrayLevel[0.82], EdgeForm[None], 
       GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwt0UtQTmEcx/FTzoplWjJjZTRpqhHlkluk20hUrqncXyqXMN1L5E6KZMvW
lmW2LGvLMluWtj7/Oe/iO9/f/M7/POd5nrOpd6CtvzBJkhqswUCaJB8U/fwU
s8onvA2PPN/Oh7C2IEnq+Bz+yGe5BotmqrkqPx/v1WODmcM8gnXWHOaD+Gfm
AL/BL/0sH8Oo+VbekV8n1mvN90d5Hn/Nz/EYNsqjPIEKeTzNvhHfGuISFFln
C+/BkrybT+G7NU/yJ5zXV3Invug7eC+W9bXcFPvWN/J7FGMBZWl2h1t5P1bl
fdyCDvPN3IBy+UiazcV8KR/Ha31b7D2/h/I020fk6Nrx0cwJnkKdc03yddzx
v3J8Dd3yVe7DjHwjzc4Z593Fz+Oc3n3GV2J/Zi7zS3zVv+BL2Km/GGvjm3yb
7+O3fI9v4bN8ky9gs9zL71CIt7iLFf0gn8FP+z/N03G/vvUg/i1y8sO4A/yQ
X3EP1nu3mx/HP9bPxH2gQN/F/wFZeklp
          "]], Polygon3DBox[CompressedData["
1:eJwtkTlMlFEURv+ZucYESqDUxAaIGJDCyIyRVVCRJaJsggwiOwoqixAQFEEW
lR2FVkposYRWSmmllFZKKTk3H8WZOXn33eXd/0pLX1VvOAiCG2BQyM9//v9C
Af4E/oSC4BfU46VQhF+H+3gN7OI/oBq/Z4pdgrt4MyTTIARxPN9U+zfk4Xcg
IaSeRXiJKdfPivE6U2/vUYs/NvVahEd4lcnH4CGeAxvUmoabPgvE8TLIwiug
i7s1UI6Xmdzf9AC/BXvc3YaYCXevGcUrTb28htfKNb3Fc27jjfAvpJ014E2m
t/vZU9MMPksUMvEX8Il4P/Tg7VCOx6AN7zbFmqELn4TaCHuDD3inKeY5HfgK
nBA7gmW81VQrDZ7jb2Af34HXeIsp5t/oGf7KFNuEPvwL/KTWFnzGe00xn/kl
/g1SIAzrcM30tlTIwGdhidx3MIPPm2r52Rw+Dtn4Zb+Dj0Aifkr9Yfy96a1+
Z8JU02snwVX/FqZczxnFp3xnEe3oI74ABxG94Su+dj6r72jVZzPtyu8smnp6
72N469/GNLvXnMaHTLFDGMQHTO477ccvXgiC9POdfIczsFVfoA==
          
          "]]}]}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt00lQDmAYB/Cv76tEWUd2pdJypRtXjjm4cMSRGWbSVUdduWmRJFuLvbKX
JbTSIqQsUXYRpWjx+2Y6/Oa5PM/MM8/7f5N27du6NyIQCLQQrkFCRBJFNLOI
YTZziCWOucxjPgtYyCLyDRdQSBFHKeYYJRynlEyy9ZepJznFac5wlnIqqKSK
c5znAhe5xGWuUE0NtVzlGte5wU1ucZs66rnDXe5xnwYe8JBHNNJEMy200sZj
ntBOB5108ZRunvGcF/Twkl76eMVr3vCWft7xngEG+cBHPvGZL3zlG98Z4gc/
GeYXvxlhlD+MMc5f/jHBJFNMzzxsBEFCRBJFNDEc0ZNOGqmsJYVkklhDIgms
ZhUrWcFylrGUJYTC+wpUH03UUsZhctnDdjaznkTiGBfEQTqpp4oC8shhJ1vY
SAbxBBkS4l4aqeEEhzjAbraxiXUkEMuYkwzQQR2V4QxzkP3sIIsNpLN45q/8
B+8mdO0=
       "]], 
      Line3DBox[{1065, 19, 38, 57, 76, 95, 1187, 1074, 1073, 1072, 1071, 1070,
        1069, 1068, 1067, 1066, 1065}], Line3DBox[CompressedData["
1:eJwt0kswFXAUB+C/R2OGbZaZacVSM0gScqmUG65XUuH2vCriJvJ+dUkPN723
tcyWpbZZ1lbL2tYyS1/D4pvfWZzFmd+co/HB2EBGCOEDZdkhPDmYv7DFd37x
j1yLRygmQgcJJlnlExt8Y4c/ZGSGcJhCKojSS5IUH1nnKz/4zS55WSEUcIw6
OulnijSf2WSbn/wl0/35FJFzKIT38h1vecNr1nhFmlVe8oLnPGOFpyyzROp/
JyyywDxzzDLDNFNMMsE4jxljlEeM8JAkwwzxgEEGuM897tJPgjvc5hY3ucF1
4vTRSw/XuMoVurlMF5fopIN22mglRgvNNHGRKI1c4DwNnOMsZ6injgi1nKaG
aqo4RSUnqeAE5RynlJLs/d/aA/KjRQk=
       "]]}},
    VertexNormals->CompressedData["
1:eJx823c81f/7P3CjUPasNzIK2RJSxvMZSsgKZRayk6wGiYayKRpGSEZkFCGj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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxN3GlcTV0bx/G4yUwRZSZzIRKlUmkw04RkKkTdZcw83IQic5EhkshBxh7i
GDvRQRlOqWRIyawklczJc63d+V9Hb3z8Xq7vZ++1ztpr7/ZT57hNr66lpdW1
hpbWP/RvpPR3yTbIPTlvb/Fy21HTZWcq/nyyRc8fqDr16No+23k1O8eY/tXt
4vPfq56etg30D3UZ/03Tl9w1iJr3+7KtwmbiYqdMTde+9aF3wFGl7TlF/cqB
fpruP1uny/3Ke7an8hZ7D/qvmPtms5qxzp0ybbVeGIW2eFXE/fP9Q9G/Oj62
nZr5eXrE1kLu9i+Wb1szIde2rv/ijj8OvOPu3cj+oo3bC9te3wamzHV/zb12
5Oleaz6+so3XN/BOe5/P/cr0/3qOm/XW9pbtiu/3OuZwn/7a6sKIpPe2P09Z
JrR7kcU9qGFIn07Zhba1d90oLh+v4r797Yp7rjFFtr2q1S2McFZyryifp+ve
uNg2zOOD9ZK7cu4lW8LtdQ0/2WpteNAqOEfG3XOp/R3DlE+2QTu+rNrpto67
lvRXQv9u1YsZ/jKxbx/xl8mOS3SqHNHh6Kb784DpXx2O1jM3jxKO6HAcbH1w
pnBEh+PeAyGPhCM6HH1zTb46kSM6HP+8ab29OTmiw7H0y4Ql28kRHY7DblQ7
+oUc0eH4Nu1RtQByRIfjnmOxK26RIzocLeeOGXKOHNHheMfXZfvv/CzucNz8
/L+gSHJEh2M7h0kzOpAjOhy/jzjQOOCOnDscS0yb6Hd4IuMOxyQ34zPuQ9Zx
1zgu7+FnUplYXfp/PjtuOnxYckSH4/noJMkRHY6W9oXDhSM6HHXLNkwWjuhw
1IksPSwc0eE4Nu+2v3BEh6Od1zVnA3JEh2OrmH6l28gRHY55cVP1SskRHY4h
s+rNn0aO6HBc1zP15WVyRIfjkS/188LJER2OjiXZddPJkcdN7aiT/9/sDuSI
DseZu6rZhY9ScofjXKsSF91UOXc4xjdroNUsW8YdjlrrHBuYWK3jzo5B2/t3
Cq+v8J8h/t6yY1mfKkd0OO4NDZYc0eEYH2E0VDiiw9HC4rWzcESH49E8r7nC
ER2OP940eOpIjuhwNDrwREufHNHh2Ljhf85byBEdjheTb7sUkSM6HDOL2++c
QI7ocCz4lPboNDmiw/F1rNxlDjmiw3HrU1fjg+TI46Z2nPlolddxTxV3OIaZ
zyv4NVLJHY5LdmQUxt+Wc4djTEhvx18ZMu7sGJlXntFjHXeNY/XMHu2bKjLu
ib8idlyjiJUc0eGYtHOQ5IgOR/dRkwYJR3Q4Wne2HSgc0eHYK/KrtXBEh2Nd
r/3OwhEdjql7ut9qSo7ocHyYZpm/kRzR4aic9vLbO3JEh6Ofnueq0eSIDse+
Bg06HCZHdDga1Ej46UKO6HB0c261bAk58ripHQ12dHW0J0d0OEY4fZm5ghzR
2XFWQFzILTl3OCZ9K/rf+HQZd76v1krX32i4jrvmvmp879j7For90rxZyo5p
LlWO6HBM+6krOaLDcdut547CER2Oefb29sIRHY7hnW8GCEd0OK7/4uUh7qvo
cKzsauYs5kd0OF4Z2reBWOegw7FhsOHhX+SIDkd/Q+8BS8kRHY5BiuNPX5Aj
OhwjuiQua9Qphzsctb+tm7uR1jk8bmrHEc4L+nSZqOIOR7uC+VtMXJXceX40
yKm9Ik3OHY69WhicLH4t487X44+JAdor1nFnx6RVI7NbNLF9IPmWs6NpziHJ
ER2Ol3plRJv+1eFovODwQOGIDsfTQ+K6C0d0OOpOK9MWjuhwzEk6+8OBHNHh
OLbl7C3iekSHY/uEs0s2kSM6HBO/+B4qJEd0OJZdcdcX91V0OCq/rv4QT47o
cGzVojRxOV2P6HBMN5e/uUjXI4+b2lF5ssjoC12P6HBMqJ5+wIfmR3Q4hvq0
73ItRc4djvn3LZYseSjjzo5GS1RPLNZx19xXm1TqPW2oqCn9/zs7PvaqckSH
o+mcMMkRHY5Oyhgb4YgOxz01slsKR3Q4ZvlY3LDz03Q4Vr5s1Ew4osOxTn3T
pk3IER2Oe4ecPRVCjuhwnN3MMCuPHNHhmPjY5qwTOaLD0dvM99gWckSHY4K/
wwgdckSHo6prn5S25MjjpnZ8NmDKXc9xKu5wdNw518NzhJI7HFMi1uipkuXc
4ajTNjfR+I6MOxztWvVRpNZax50d7bQ7NXLrqOgvrWN/sWP31wclR3Q4Hlg6
SnJEh+MIlxgr4YjO69WEV/WEIzocg2Mz1gtHdDjqP7sYYE+O6HB0rdziq0uO
6HBMTi7+sZoc0eHo3s55yyNyRIfjj7aXMizIER2Ow97uylpCjuhwXOa1+umD
Djnc4XhsvLN+yvMs7nCM3/vAbJ6Hijsco4xdYs2GK7nzffXzq9m61+Xc+XdH
ekpoSbKMO1+PUdV2ZRaFcGfHmPdTZAOMFbOk9U8lO9b2rXJEh+NnVT3JER2O
A9wiLYQjOhx7hxX9cszUdDg2mZw6Sjiiw/HTZ+37A8kRHY5O4ReKGpEjOhyX
dfPNW0mO6HBMi7c99YAc0eHomno4qSc5osMx//mM737kiA5HlfKHfyw5osOx
RYaveSg58ripHR8vDD9zZ6yKOxyDDXLfTx+m5A7HoOoH13RRyLmzY6fnYVEK
GXde55xq8s34aQh3zfyo86u0ei/FXel+q2UHx2EFMZIjOl+P31L2m/7V4djp
ZERf4YgOx2F9OhQJR3S+rwbW0BeO6HAMUK43E47ocFympQxtSI7ovF71aFtz
BTmiw9FiTLn/PXJEh+OlYv/STuSIDkcD8ySfCeSIDke/iQ0DV5AjOhw3189Y
606OPG5qx7k9anRzIEd0OC6ZNm2CYqiSOxwvHty/+sA1OXc4pv/JvdPtqow7
Oy5IX+ZxN4Q7O7abn2tZ0FsxQfKtzo7eAVWO6LzOcVwnOaLDscJgj6lwRIfj
gRpnnglHdDj6Ti3Pt/XTdDh6ev84aEeO6HCsWH20bwNyRIfjy3FPxywlR3Q4
7pg2bN1tckSH44Lr85+1Jkd0OJ7tHtLKmRzR4TjVad5BT3JEh+OgyZ/fdyRH
Hjf8fjw2x+jeGBV3OBqU6ST1IEd0OBo83BEy9KqcOxxdth4173pJxp3vq3rZ
HfwTQ7hrHL1vtgvvo/jwR/z9w46RHw9IjuhwHF3kIDmiw/HDpSMmwhEdjp9X
xNwXjuhwfNDo+knhiA5Hi1tOTYUjOhynThhUWo8c0eFot/bM7UXkiA7H1ydL
3twgR3Q43io/NrgZOaLD8a2h8qQDOaLDMXrsH5/+5IgOx7GLr77+kZfFHY5d
Zxj/O5kc0eHoM+7y8KNDlNzhaDHSSbfBFTl3OIa5ndg8+YKMO++v9vjt53c2
hDs7ps/crduyr2K59HukJjuGzalyRIfju0PVJEd0OG5veKW7cESHY7mJKlE4
osOx3PbsUuGIDsdhq3tstiVHdDiGXSs/X5cc0eFo7pE7cgE5osPx7sfmcxLJ
ER2ONjdsKhuSIzocY0xGnrcgR3Q4uuzavLwFOaLD0brOi03p5MjjpnYsOd16
RfloFXc4PrYzKuhIjuhwLJmke+/xJTl3vq9mPcw6fE7Gne+rjwvWHz4Swp0d
e+09OGV/P0U9af1Tix2HlEZLjuhwHOWhiDL9q8PxaPOMbsIRnffJfxvEC0d0
OBrmmwwWjuhwlGm9rCEc0eEo6xq+qg45osPxyxvd/HnkiA7H1Ss26l4mR3Q4
Hp4+9kUtckSHo+/Ib5U9yBEdjnuaRveqMMzhDsfK+0EPjpIjjxscZ+QHbyJH
dDiWrMz9emiwkjscXY41bn74opw7X48JP6++i5dx598dQ7sX3N0bwl2zzjmz
Zb+hhWKfNG/WZsfFgVWO6HA0urlCckSH489HbzoLR3Q4Olx3Pigc0eGoHT5Z
TziiwzEu+dEKG3JEh+MR+bAhtckRnefH6NuBc8gRHY6OnjUunidHdDiGzSi9
q0WO6LzOGXV5ZAdyRIfjxE4P03PJER2OL0PNFSvJkcdN7bjg5lWd9uSIDsca
Jrkb25AjOhwfN4ye4SeXc4ejnY+PfvPTMu7s2H5uQOzWEO6a67HZCfuz/RXG
0rxZlx3zyvZLjuhwNI7vLzmiw/HfGqUdhCM6HNNfD94uHNHheKra6nwbP02H
44172aUDyBEdjitnl9WtRY7ocGxXHPxrJjmiw/HwaAvn/5EjOu/LrR67/4fb
a+5w7JldZ44BOaLDsYb1fFUiOaLz80fDnAOjyZHHTe1YQ6vtwnPuKu5w7Lrw
R9rOQUrucKx9fXx++wty7vz88VrPzr1PyLjzfdXrWp/6a0K4s2N+hF03FyvF
FWnerMeOroFVjuhw3F/yZZ/pXx2OSpOSdsIRHY4xRW/WCEd0OO7p2fqEcESH
Ywt//6nCER2O84L+JNckR3Q4dlj2KNCfHNHhWJrQMfUkOaLD8eg/bW3KyBEd
jilDF9g1IEd0OGpXWqRHkyM6HB8H9W/QjRx53LBPHqnzciA5osPRr2RYndrk
iA7H/LM5rmkJcu5wbNf8UIuex2Tceb1qGftCa2EId43jXpN3FdaK4dK82YAd
M0qiJEd0OOqt/Z/kiA7HvcdfthaO6HAM1O0wXziiw7HOnMYLhCM6HEdZdFBZ
kyM6HA+cMw2sQY7ocDRTnXzoS47ocNS+tbbtMXJEh2Nc7fLYQnJEh2P20OUJ
1cgRHY43eidf+Y8c0eEY6HXy+6/cLO5wdGzg73/PTcUdjhMTzbYsdFJyh6Od
3cXKeefk3Hmdo9y3tYlMxp3Xq8nHcrb7hnBnx5Jxjj0u2ChyTMW82YgdHWdX
OaLDcdiYmZIjOhyrH7zdQjiiw7HCqWKqcESHY8P/eVoJR3Q47vN8YyYc0eE4
y7Jm03/IER2ObvoOhtPJER2Oo8xHj4olR3Q4PswdlvKSHNHhuH96SPKXd/nc
4Rh2/OG6CeSIzvfVYetn3CdHHje1o9lgy0Hu5IgOx5MRGao8RyV3OHpHHBpU
76ycOxyDVqbovjko487Xo8PWrRmeIdw1++RFCYXWdop+0v1Whx0/Fu6THNHh
uH1fZ8kRHY6NbxzSF47ocFzSbLObcESHY0j51GrCER2ORZ6fdluRIzoc34a3
OFONHNHheChwwKSp5IgOx6fne0+KJkd0OIYGPZE/JUd0OH7wGri2gBzR4ejt
4bHUghzR4dh5n9Wt/eTI46Z2tD7TJOGRq4o7HIvskwKdyBEdjjo3XpkeiJdz
5/mx1r5PJ6Jl3Nmx/zKP98NDuLPjY5XLuPYDFZWSry473plR5YgOxwWT8vea
/tXhOGXlQj3hiA7HMbkvBgpHdDje8lh6a4CfpsPxiFXb75bkiA7HEpWdvRY5
osNxyfgjG7zIER2Okz2LXSLJER2OWlZ7lmWQIzoc/e5YVcslR3Q4hqb/p9Aj
R3Q4LhulP34WOfK4qR2jbrX4dzw5ovP1+LDJxOMOSu78u2Ne54cmZ+Tc4Tj3
zYALM/fJuPM6J99p+rsBIdw1zzuCd3SpZa+4Jc2bGkfTl3slR3Q4euRGSo7o
cLx2xVFXOKLDcWdM+97CER2Oy3z7bRKO6HC8/aKvh3BEh+O6LjMzKl8WcYfj
qi+Nz0wkR3Q49jyV2S+CHNHhWFK5pvMdckSH43rVQ690ckSHY9dLf66VtM/h
Dsc9eQdOWJMjj5va8XUta+UzFxV3ONaf36BXI3JE5/MAi9t/TDol587nOuo9
CDfZI+PO8+PqS3XLTEK4s+Pc37uNiuwVW6XfI43ZsWxilSM6HPNquEuO6HCc
2E2noXBEh6P+J+d2whEdjouTrjgLR3Q4ngs5dL4/OaLDsenc7d6/yREdjk0C
bdM8yREdjmPe3tXdRo7ocCzWH5J0nRzR4ZgYUyBLJkd0OK6s23LdPXJEh6Ny
sfu9euTI46Z21BrTLG8yOaLz78dpP0vm2yu5836OzdWBbifl3Hmd07pu2OcI
GXe+Ht09flU3DOHOjmFlRop0B8VYaf3ThB3HP4qUHNHheL1+fckRHY4fL+bU
FY7ofD5nUWgj4YgOx6mlK/SEIzoctYZd0ROO6HDcnvn00y9yRIfj57wdJWPJ
EZ33c0xWf9xAjuhwDF7WbcIlckSH47WkCSUXyBGd9+W+F844Ro7o/LzD7Vnb
nGdZ3Pk5crPwmBfOKu68L9e73qEnA5Xc4ajl2ffHm+Ny7nyuo9XottfCZdx5
H+CcjXF3vRDu7Kjjqn/znKOijTRv6rHjaNcqR3Q4/lukjDT9q8PRw/VoLeGI
DseOze9XOmRqOhw7x61/Yu2n6XAMMz+3wIIc0eGo6vYw6Cc5osMx7MF0vdHk
iA7HuWf23QsmR3Q4Rn9b9CueHNHhuPfMGcfj5IgOx9EFkf7B5IgOR6PjHY8f
J0ceN7Xj++j9P33IEZ335dIaNbIjR3Re59Q9PGF5nJw77+dEfLfeuFXGna/H
KUUl07RDuGv2cwJH5e90UryV5s2m7Khzd4/kiA5Hz+T/JEd0OI5WLaghHNHh
aPyja7FwRIdj2E7tA8IRHY6h3+tmm5MjOhwbTUrX+0GO6HBsYXlygCs5osNx
5s9nCavIER2O+sGXjh8jR3Q4Gm5dFb+fHNH596N3i3Pe5IgOx6dJL8KWkSOP
m9rRe1k3i4JRKu5w9G5waeVROyV3Pr/qmPem8TE5dz4vN2vG9QmbZNz5eoyt
7XzqezB3zfOOVSkvFw1SnJbmTY3jEscqR3R+brW6n+SIDsf69RyqCUd0OLq9
3JErHNH5/OrORz7CER2Olk7TLYQjOhxr19E/8Y0c0eGY+ds1YBQ5osPRZfXF
w8vIER2ORkVTZsSQIzoc9Qa+7BlOjui8zul+uscAckSH48Ti3eeGkSOPm9rR
b9Cp8lnkiA7HmMtpPo3IEZ2vx94TTE8ckXPn+2qo2ZSeoTLuvM65UKz8URjM
XbNPPuTLFY/BikXSvNmMHTdd2y05osPxUftPe0z/6rzO+Ve30vObpsMxNa7W
feGIDsdrg3ONhCM6HCe4z97XjxzR4fiiv7bDV3JEh+O071OihpMjOhw7HXu4
dyE5osNx7w2n7nvIER2Odc2eXwkmR3Q4FsZVv9ecHNHh+N31zc8W5MjjpnZs
l/7zQ9lIFXc41t4Z5LvYVsmd3+/Yv9nXQSbnzs87+vTupRUi48731Sc/mw3M
DebOjgaKwDKLIQobad7UZ8fm/aoc0eFovvqo5IgOx85Tcn8KR3Q+9zgs8Kpw
RIej1ox7JVZ+ms7vd3wYUdmXHNHhOLH65afl5IgOR9fNQ+4PIUd0OL71rR4+
lxzR4WgfaFK2jRzR4Tj2ou/gJeSIDsfqPn6Tv7bL4Q5Hu6GLOn7IyeLO86Pu
sHmLyRGd39PRrncuz0bJnfdznO5FPomVc+fzOVfrFd9bLePOjpkjreelBXPX
rFcH+59sOVShLc2bBuxocnqX5IgOx+OxXpIjOhxvK458E47ocOx+Ju2EcETn
c8gDtl4QjuhwzGp/xVs4osNxfmDUvM/kiA7HyI2VFU7kiA7HdxHhIQHkiA7H
Uw8Dz68nR3Q4Dtg3+34AOaLDcd35i08yyBEdjkGfUwyvkCOPm9qx/q3Rfr9G
qLjz+Zy6vj2dyBGd98kLeslmHZJz5/vqsVELI1bKuLPj6aiGG68Hc9eclyve
UfBnqEIlzZvNNc+tOlU5osNxR7i+5IgOxwNHZpULR3Q4XnVqs084osPxysdm
K4QjOhx3dAi/YUaO6HDUbudeq4wc0dlxxFMjB3JE5/nR0HvxDHJEh2PT5oMX
rCJHdDhO/d/64V7kiA5HZdfzFmfIER2O2y8Zl20kRx43nHt0MM9YSY7ofK7j
zor3xwcoufN+zrWDqX9i5NzZcea2UI/lMu48P6Z+mLDtXDB3dow3C/d7M0yx
S5o3NY63o3ZKjuhwzKmTttv0rw5HszY9S4UjOhyPj3XaKBzR4ehmpD1QOKLD
cffri4bCER2Odz+NjCwhR3Q4tv0a7WpHjuhwzC7MnTiFHNHhaDk6u81ickSH
49fxp+LcyBEdjoNefzDfRI7o/H6HobbleHLkcVM7Br+9naFFjuj83Gq4+bOG
5IjO56ys1yVsOSDnzs+typc20l0i487XY90WewJkwdzZMeXuwdD7wxWTpXmz
BTs2bVLliA7HmV3WSY7ocAyILPgoHNHhWCd7xFLhiA5HW+slNYUjOhwN561c
3Ycc0fm51XrTrp/IER2OLrdWBw4gR3Q4dj7dxmIiOaLDMah97MXZ5IgOx/qh
WR+dyBEdjj5R5h9mkCM6HFs5PWzejRx53NSOYTdH3l49XMWd9wGsMjfMs1Zy
5/2cRUNOGUTLufM6Z2pzPeUCGXd2dHhg1X13MHfN8w6t6/7yEYrO0rzZkh2f
hEZIjuhwbPDVWnJE5+fIqphC4YgOxxzr/n7CER2Ol5evTLX003Q4Dj+u89yU
HNHhOD3SK+EjOaLze6x/2my1JEd0OMraN63rQY7ocKzRbZDDDHJE5/dYHxa1
6E+O6LwvZ+0yyZ4c0eHo8v5C7LenWdz5PICT57tq5IjOzx/vPrbJtFJy5/Or
oWHLDkbJufM+gG/KrMB5Mu78vMPCOOBJaDB3djx2e2TooZGK4uli3mzFjtUr
d0iO6HCMCvi8y/SvDsdxI9zfCUd0ODbPr+0hHNHhuLRUb4twRIdjm9Y+VsIR
HY6jW54cUESO6HCMyqqMNSdHdN6Xq7j6wJUc0eF45Gq9a5PIER2OnsUnenYn
R3Q+13Go2YbW5IgOR53ElIyb5Mjjpnb8/u2a0ephKu5w/K7/u7wPOaLzuY65
xxt33Sfnzo7d/6nfaraMO1+PU3XfBS4L5q65HqdZvNk6SnFBmjdbs+ORwCpH
dDgW7omTHNHhuLhf9dfCER2OpSeTnYQjOp9D9p7oIhzR4Tj1Wvau3uSIzuuc
xu+VheSIDkfLWsfOm5EjOhwrjC+GjyBHdDjavRppNIYc0XmdY1xp0pYc0eHo
uHjB2u9tc7jD0XTQWeUOcuRxUztG1LHK/zNUxR2OzwYtbRhhqeQOx67/NZ10
KlLOnR21O3654S/jzuucqbPHVpsZzF3z/LFl7fLlzoqV0rypccx+u11yROf7
6kYvyREdjnHzT+cLR3Q4VjrMNROO6HCUlc1tIhzR4dgn9nJpL3JEh+PM9veG
FZAjOhyb3lyu7E2O6Lxe3T9nxGByRIdjhHPNbSPIER2OYYMad2pMjuhwPL1o
7uRMckTn9eqi8vAp5MjjpnYMaqs/aCU5osMxxev+w8/9ldz5vbnfev+Y7pFz
5/fKN/lG+vnKuPN99eyb6xsnBXNnx3bzxseZuSgGSfNmG3ZcPr7KER2OMb2b
So7ocHw71SNXOKLDMbO8XgfhiM7nya2GZ/f303Q4Fur8Hi4c0eE4u3a3tHfk
iA7H+Q0apfckR3Q4LpzdpJo9OaLDcXvC3QIHckSHY9Sww/VqkiM6fx/g/MvG
p8kRHY7ezVeYmJAjj5va0SVlpFXFEBV33s8pW9zKnRzReZ0zcPrG87vk3Plc
Rx25qp6PjDvvr4YuL6jjHMydHbVmjD15wkXRUJo327Kj8n645IjO73ecubPT
9K/O69XKyifCEZ3Pr5rF6gpHdDjaN2gVKRzR+bmVlvERE3JEh2PZm6Hub8kR
HY77Z1bPMSZHdDg+qB+QYE2O6HB8Wb7Z3ooc0Xl/9UTqp29v87nD0SaoZnIo
OaLzc+Tp8jsVT7K4wzH/W2nvZeSIDscRtloBZy2U3Hl+LLft3n+nnDufB3iQ
OPiMt4w7O67/brPRLpi75r56eY/M0FXxQbrftmPH+XZVjuj8/ZxnqyRHdDi6
6sRmC0d0OPZc0U1LOKLDcdaR8xOEIzocO9a6+aeneL9D3eH4sm+d7NfkiA7H
6jb1XnUV73eoOxzji8ZMNRfvd6g7HL/tnbbdlBzReX6cHH2rkBzR+X3knQaj
ppEjOhy1Kq6a3SFHHjfsyzk5HP82WMUdji5D/FrpkiM6HGPGtB5zZYecO99X
9SZ5OU+ScWfHrH8f/eodzJ0dO1o7Gex1VThLvhrHfWfDJEd0OFrdNJMc0eGo
M8kxUzii83OrkbHF9pmaDkev313bCEd0OP6cXzFOOKLD8V+7fI9X5IgOxwaR
PQo6kSM6HAcYXatvSo7ocLx4btmzbuSIzucer2VG5JIjOhw3ml5PGkCO6HAM
fjLxv93kyOOmdrQzOJ66gBzR+b7a23TCHHMldz732PDiVOvtcu7s6P00r8hT
xl3z/RzXiikdgrmz4+jNcQW6bopz0rypcZzUscoRHY6q/woiTP/qcJT/eJUm
HNHhaHW8Wa5wRIfjsNRN+RZ+mg7H/fUbne1Bjuhw1Aud/uQFOaLD8bbr8WJD
ckSHY36Nn+e7kyM6HKvFXu7YnhzR4Wjxbqh3Ojmiw/FZ4ghjA3JEh2PE+eeX
fMiRx03t2D3C5mbpIBV3Xudo9fC930/Jne+rZzoXXA2Tc+dzHYnWuhvGyrjz
OqfbPYsbesHc2fH9zUlFG9wU+tK+a3t2TNq5TXJEh2NF3WjJER2OUS3X3BOO
6HB8Mjr4rnBEh+OFS88PCUd0ODb9t1o94YjO1+PiuPH55IjO53MW/O9zW3JE
5+916Cyc3IUc0fl5h2NWgAE5osPx1/mv3ZLJER2Ob9Prh5W1yeEOx6xPT4p6
kyOPG96bi4g9NJsc0fl8juWZQcbkiM7nOmw7frPeJufOz5ELzht0dJdx5+ux
ommn1trB3DX75F3mtqzurlgurX80jhu1qxzR4Rjn5CY5osPRPrBVqnBEh2MD
y7xLwhGd3+/ILvYRjuhwXN3Gclp38d6cusPRce/Qp3nkiA7H4pGrvrQS782p
Oxz7/dO3mqF4b07d4WjtFRzXiBzR4VjjRM0358kRHY5Gr0NT75EjOu8DnDzw
svJxFnf+XodB6tNCJxV3OHYsf+8a2lfJHY7puwP/XN4i5877cpNTFlx2lnHn
349XreOnfVvLXbPOWTGlbJm74rk0bxqy47NFWyVHdDim2mtLjuhwHNw84aZw
RIfjRTujY8IRHY61E+93Fo7o/J6OedllY3JEh+PRBvfH5ZIjOhxPtO3+pTk5
osMx8IBNTCtyRIfj5gHGL7TJER2O/d+d23WMHNHhuMSq9bsj5IjO3weIjo+/
S448bnjescvl6AxyROfvA4w/m/HaTMmd1znpQy+Yb5Zz532AHVtujRwh4873
1Qvzf0a9X8udHYe8CuxX7q5wkOZNjePpt1skR3Q4zqm4tMP0rw7HS3FDbghH
dDhmHJ++SziiwzG797z35n6aDscDT2o3Fo7ocDzv8+5hDjmiw/HpqzZlzcgR
HY5+PVda6pMjOhxnh1TXrXR9zR2Ox23crPeRIzocry50eRFEjuhwjHrhO3IP
OfK4qR0rAj+WvHBUcef3yu/4nLYjR3R+/jhi8IuzG+Xc+XlH5ZjtuUNk3Nmx
c++at5+s5c6OtYOvf5s1WnFUmjc1jqVjqhzR4bjTb5bkiA7HzNAnicIRnc+T
n90cLBzR4Rg7506ccESHYxcndz8jckSHY1RAH9en5IgOx/46oR+akCM6HOc8
XqzSJUd0OMb039nvCzmiw3HB2G4ZW8gRHY7jMm6cGk+O6HC82MvuhA858rjh
3KPcfddEckTn7678eH5tXx8ld94nL6nTtfsGOXc+D3Bulf6/TjLuPD8m6svy
7qzlzo4lns1d3o9W1JPmzQ7seF+5uep9ZHWH48eYdpIjOhybdPW7IhzR4eh/
8migcESH43DP7/7CER2O2Y27JnYT7yOrOxxPdVh69zE5osMxwuD7Sx3xPrK6
w/H05t+T64v3kdUdjuee7RpbRI7ocBxvsNsriBzR4dgr0n2qGTmiwzEsSreg
FznyuKkdh2zuVZjtoOIOR+vAAP+vpkrucNyj6rzh8Ho5d17nRH3fXzZQxp1/
PxbeT/54ZS13dtzjWfpx6hjFHGne1DjW7FPliA7HDiszt5v+1eHYY2SZXDii
w7H9iThv4YgOx5V37xgLR3Q4vk2tbCwc0eHYqfZih0fkiA5H67nPHjYgR3Q4
lp0d/06bHNHhqKww/fcVOaLD8Ur/7Y8DyREdjheCpzxrQI7ocIx5fuNRxaMs
7nDsuHVzoAs5ovN5uR/tWruQIzock7JCDrRYJ+fO3+voG1S5yEbGndc5g9NS
355cy50do2bdscsbo8iU5s2O7Hg3ZpPkiA7HM+3WSY7ocEzLXpogHNHheDd5
/yjhiM7ncyIDivr5aTocE06M9O1KjuhwHPLM5vJDckSHY2iy56265IjOzzsq
ZgZUI0d0OJ62ebzgKTmiw/Hy69aDp5MjOu/LKUf1f9c6hzscaxh3jkkhRx43
PH/0a7Yv1V7FHY7HkptOiuut5M7fs5p/9dS2YDl3/v14oWuzH5Yy7nw91ipv
lr1/LXfNfo5tg1eeYxXm0rypcazZsMoRHY62SywkR3Q4tsn7HS8c0eGY9Hql
tXBE5/fm3FNOCkd0OE4+n3+5CzmiwzGlaLRJFjmiw3HDmjnnapEjOhz1Jk0o
+BX9jjsciybOW/SAHNHhOKP5iiMe5IgOx3YBcwKSyBEdjrV3bjCJIEceN7Xj
4X7fTe3JER2OQf6WH6uRIzr/fsy93f6ftXLuvM5Jrb5nsbmMOzuebFb7wta1
3Nnx3q9G/2SPVeyT5k2N44NlG6u+86DucNywuzDc9K8OR79Vq04JR3Q4Jjxw
NxKO6HD0KPo5Uziiw3Hbo2oNhSM6HCd/8onNIEd0OHZbsSi6hvjOg7rDscWm
iGlfyREdjl8d6gSmkCM6HL+nfaoYSo7o/P5j3o/gSHJEh+MRRXG0FznyuMGx
sdvyywNV3Pn7AP0c2ozvpeTO+znHpl5euFrOnR1lrUzL+8i483o1+kL2llVr
uWv2c/rum+7mofgjPV/uxI6N3m2QHNF5nzwgSnJEh+OcuN9xwhEdji2XNDMQ
juhwbNPxY3fhiA7H12sDvTuTIzocddo9a/qAHNH5uVUHh3XVyBEdjqlXvzwq
IUd03s8JbeSjIEd0OE4s/uRoTY7ocMzwv7gwkBzR4Vh2OvWRETnyuKkdR6/1
tDAlR3Q+1/Fy++H/mSi5w3FcycTrb1fJufP8aNnbYVYvGXd2TDWcPXbuWu6a
54/jihzTPBTTpHlT45jpVuWIDscvWqMkR3Q4rmy79IhwROdzHfPu1hSO6HDs
sz6+qK+fpsNxSpbP2U7kiA7Hnvkm69PIER2OC+4kB1RuKeQOx60zeg35QI7o
cNxYd7TzBXJEh+P8Rqo1PckRHY7f+zUaNpwc0eHoH/i08Et2FnfeB5hdZ2ec
nYo7HMuXJSfUJkd0fr/jeu7/xq6Uc+f1qlev56+6y7iz45+smXpT1nLXXI9O
pstHjFPclubNzuzYKTFUckTn78xP/BNm+leHY99OZYeEIzocZ7ot+DwwU9Ph
qN91+EnhiA7HWg6F/whHdDjuubnh231yRIdj3ymjnH+RIzocH219mfCGHNHh
eCX4mdkpckSHY/RHvYvtyBGdr0eLIdodyRGdv/OwMSE3iRx53NSOx1xbHWhH
juhwbJVTOdmrp5I77wP0DY2/uULOnb+/Oth+7LhuMu78+9HTp1Oq61rumt+P
XY78Th2n+D9gY3qi
     "]]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  ImageSize->{347.8564352687994, 340.1770232658382},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0.09999999999999999, 11.099999999999808`}, {
    0.006819348298638839, 1.}, {0, 1}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], Automatic},
  ViewPoint->{0.0008529516969092324, -0.09591273069063277, 
   3.3824251685092612`},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.5442747349038982`*^9, 3.544274761707982*^9}, {
   3.544274796394656*^9, 3.544274818686857*^9}, 3.544275009705653*^9, 
   3.54427513687197*^9, 3.544283391151561*^9, 3.544283822910383*^9, 
   3.5442839464702053`*^9, 3.544284046708351*^9, 3.5442841375562963`*^9, 
   3.544284312983466*^9, 3.544286142862187*^9, 3.544286229195373*^9, 
   3.544286937994831*^9, 3.544287566263874*^9, 3.544289067264792*^9, 
   3.544328986698638*^9, 3.5443291165289507`*^9, 3.544329168586055*^9, 
   3.544329453547079*^9, 3.544329629290855*^9, 3.544329822405718*^9, 
   3.544330274555923*^9, 3.544330672449998*^9, 3.544330825300686*^9, 
   3.5443327085490313`*^9, 3.54433367482051*^9, 3.5443341960484543`*^9, 
   3.544334983476705*^9, 3.544337454202512*^9, 3.544337897629608*^9, 
   3.544339190515134*^9, 3.544339503507886*^9, 3.544339605442033*^9, 
   3.544340003606677*^9, 3.544340172370802*^9, 3.5443403596328173`*^9, 
   3.544340501926424*^9, 3.544340574538741*^9, 3.5443408310411453`*^9, 
   3.544342389934187*^9, 3.5443424968178883`*^9, 3.544345744622154*^9, 
   3.5443458301834784`*^9, 3.544345904254219*^9, 3.544345947087578*^9, 
   3.544346205185917*^9, 3.544354348042281*^9, 3.544354905268385*^9, 
   3.5443550621898212`*^9, 3.54435552335815*^9, 3.5443557556869593`*^9, 
   3.544355924661501*^9, 3.54435604392352*^9, 3.5443562040448217`*^9, 
   3.544358397167761*^9, 3.5443590411029167`*^9, 3.544359119459366*^9, 
   3.544359191050878*^9, 3.544359444812525*^9, 3.544359616481637*^9, 
   3.54436023275397*^9, 3.544360592994361*^9, 3.544360782313662*^9, 
   3.544361000654539*^9, 3.544361377188442*^9, 3.544361474086874*^9, 
   3.54436157181676*^9, 3.544425104625369*^9, 3.54442524317337*^9, 
   3.5444255542617073`*^9, {3.544435552332521*^9, 3.544435582333788*^9}, 
   3.544459831342054*^9, 3.544460857213937*^9, 3.544461526005041*^9, 
   3.544461674710897*^9, 3.544462000291012*^9, 3.544506730594523*^9, 
   3.544506963185316*^9, 3.544507053179656*^9, 3.544507086428853*^9, 
   3.5445073164834433`*^9, 3.544507789460925*^9, 3.544507868742927*^9, 
   3.544507998718896*^9, 3.544509106434339*^9, 3.544509855890416*^9, 
   3.5446148083792*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"\[Psi]plt", ",", "All"}], "]"}]], "Input"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxd3XlYjO37x/GUCJEURcpWCWWNmJHJFrKElGyhHkJNRUiSJUWUytJESkiy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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3HfcFmIXB/B6nicaFKXSXrSjtEhU2qVJSTSEpEIKITOizIyUyojIaiez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         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0ktEHwAcB/B/7/d7sSiKjaIoiqIoio3eq9Z7k6LoeSuKot2KoqjborGo
W9FY1G1jUdRtsSjWbVEUxT7R4eN3/P5eWT0jjcNBgUBgmacaTAihhBFOBJFE
EU0MscQRTwKJJJFMCi/IppR6ehlnjs9s84Pf/HvKE/6SXMppop9JFlhnl1/8
4YZIzaaTTyWtDDLNEl/5zhEX3BFruEwKeUMno8yywib7nPCXBxIt4xXFVPOR
D3TTRScdtNNGK+9poZkm3tFIA/XUUUsNJbwmiUd5V5xywBarfGKMLt5SRBZx
3JvrkmP22GCZGYZoo4oCMoji1v7OOeQbX1hkigGaqSCPNMK4dqczfrLDGvNM
0EcDZeSQ+vxP/wEf9D9c
       "]]}},
    VertexNormals->CompressedData["
1:eJxM3Gc4ln/YB3AzlBnZ/UsIISMlld9VyUiSUfZKomUmZG+hMkJW2SsqRMi4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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxd3XlYjO37x/GUCJEURcpWCWWNmJHJFrKElGyhHkJNRUiSJUWUytJESkiy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     "]]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  ImageSize->{365.02047557839126`, 214.283903262527},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{0.672604923673349, -3.19440736940895, 0.8907099274826485},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.5442514959862547`*^9, 3.544251523510511*^9}, 
   3.544252165714499*^9, 3.54425237358981*^9, 3.544252966280998*^9, {
   3.544253020071795*^9, 3.5442530488897667`*^9}, 3.544254057057411*^9, 
   3.5442543170965157`*^9, 3.544254536072023*^9, 3.544254639020831*^9, {
   3.544254705470038*^9, 3.544254724493225*^9}, 3.5442549943698*^9, 
   3.5442552374371367`*^9, 3.5442553747025433`*^9, 3.544260669814514*^9, 
   3.544261146477269*^9, 3.5442611798045197`*^9, 3.544261433916452*^9, 
   3.544261692673863*^9, 3.544261724274478*^9, {3.544262795878004*^9, 
   3.544262821704664*^9}, 3.544267036138501*^9, 3.544268579935521*^9, 
   3.544270075641686*^9, 3.544271089020953*^9, 3.544271576926825*^9, 
   3.5442731004630547`*^9, 3.5442732940161552`*^9, 3.544273394750771*^9, 
   3.544273637797572*^9, 3.54427373958605*^9, 3.544273900746242*^9, 
   3.5442740965620203`*^9, 3.544274584475129*^9, 3.544274660315448*^9, 
   3.544274728029367*^9, {3.544274862192422*^9, 3.544274865343837*^9}, 
   3.544275011781597*^9, 3.5442751374178963`*^9, 3.544283392028126*^9, 
   3.544283823338153*^9, 3.5442839470113907`*^9, 3.544284047246871*^9, 
   3.5442841380949087`*^9, 3.5442843135229063`*^9, 3.544286143409461*^9, 
   3.544286946593918*^9, 3.544287572901492*^9, 3.544289074805408*^9, 
   3.544328987264872*^9, 3.544329117097651*^9, 3.544329169201785*^9, 
   3.544329454617476*^9, 3.544329629835413*^9, 3.544329823060204*^9, 
   3.544330275108399*^9, 3.544330674239108*^9, 3.5443308259599743`*^9, 
   3.544332709164928*^9, 3.5443336812598457`*^9, 3.544334197107978*^9, 
   3.54433498748729*^9, 3.544337456029071*^9, 3.544337898136623*^9, 
   3.5443391909184933`*^9, 3.544339503913072*^9, 3.5443396077751303`*^9, 
   3.544340003981452*^9, 3.544340172742816*^9, 3.544340362061707*^9, 
   3.5443405028219976`*^9, 3.5443405749144163`*^9, 3.544340831422904*^9, 
   3.54434239030733*^9, 3.5443424972554703`*^9, 3.544345745000968*^9, 
   3.544345830607912*^9, 3.5443459058656883`*^9, 3.544345948732147*^9, 
   3.544346205770697*^9, 3.544354349691719*^9, 3.544354908032811*^9, 
   3.544355063629759*^9, 3.54435552581995*^9, 3.544355759198216*^9, 
   3.544355927166753*^9, 3.5443560458220243`*^9, 3.544356207080329*^9, 
   3.544358397808394*^9, 3.5443590415403*^9, 3.5443591216542253`*^9, 
   3.5443592014970827`*^9, 3.5443594499824743`*^9, 3.544359618281905*^9, 
   3.544360233212381*^9, 3.544360593499476*^9, 3.544360784311252*^9, 
   3.544361002270225*^9, 3.544361377599197*^9, 3.5443614745022717`*^9, 
   3.544361572176259*^9, 3.544425106749989*^9, 3.5444252436149063`*^9, 
   3.544425554878963*^9, {3.5444355528321047`*^9, 3.544435583105088*^9}, 
   3.544459842042541*^9, 3.544460858646184*^9, 3.544461527251004*^9, 
   3.5444616758224697`*^9, 3.544462007049428*^9, 3.544506734029459*^9, 
   3.5445067869326487`*^9, 3.544506965598073*^9, 3.5445070553208933`*^9, 
   3.544507087103599*^9, 3.544507318072435*^9, 3.5445077899318943`*^9, 
   3.544507869728805*^9, 3.544508000318716*^9, 3.5445091100323553`*^9, 
   3.544509857622081*^9, 3.5446148102656393`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"\[Psi]divzplt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.5442508822543163`*^9, 3.54425088476548*^9}, {
   3.5442512535572777`*^9, 3.5442512541889133`*^9}, 3.54425150109731*^9, {
   3.544252197080502*^9, 3.544252197175276*^9}, {3.544359202785078*^9, 
   3.544359203443362*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxF3HdcjW0cx/Fkz6w07MhoSRJCKbshJFrIKOsxsiJ5Utkyc6KURwlZJSsa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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3Hm4FdL3BvBu95aUBkmDSpMpGqTRkBJKmSpECJUQ0oAmU2VKSTSThIoG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         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0iswAwAYAOBt3ub9fs7bRNNMREMQ0Dwa7rhDREPEKYimIaKZaBoimomm
ofncCd/97X+3zS2PLwUDgcABfzFEFtnkkEse+RRQSJgiiimhlDLKqaCSbvoZ
YZoVtjjkjBseeOPrL6/izfQyyATzrLPLCZfc8cwHQc1WESXOKDOsss0R5yR5
JM03YQNGiDHEJAtssEeCK1K8kCFkIdX0EKWbLjrpoJ02WmkhQjNNNNJAPXXU
UkMWn3K/cs81p+yzySJTDNNHC0X8mOGdJ2654Jgd1phljAF6qCZExs5eSHFF
gj02WGCSIWJECPPtNmkeSXLOEdusMsMocaJU/f/RL/LyOvE=
       "]]}},
    VertexNormals->CompressedData["
1:eJwc3Hc41t8bB/DH3inZlFKRZDXszhGVlCSjIUSE7EIoVCIRFTIqIyXZQkVG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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxF3HdcjW0cx/Fkz6w07MhoSRJCKbshJFrIKOsxsiJ5Utkyc6KURwlZJSsa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     "]]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  ImageSize->{370.6942540322205, 187.20350638943182`},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{0.5938058989868863, -3.2850989664226566`, 0.5527380348204352},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{
  3.544250885490486*^9, 3.544251014765848*^9, {3.544251136616836*^9, 
   3.544251161696109*^9}, {3.5442512313358*^9, 3.544251255023039*^9}, 
   3.544251415036179*^9, {3.544251486168771*^9, 3.544251525447385*^9}, 
   3.544252167712742*^9, 3.5442521977887163`*^9, 3.5442523738383827`*^9, 
   3.544252968072139*^9, {3.544253020419325*^9, 3.544253049139974*^9}, 
   3.544254059670431*^9, 3.544254317346848*^9, 3.544254536319419*^9, 
   3.5442546392024717`*^9, {3.544254705739455*^9, 3.544254725164307*^9}, 
   3.544254994619301*^9, 3.544255237978533*^9, 3.544255375378627*^9, 
   3.544260670403819*^9, 3.544261146516342*^9, 3.544261180947994*^9, {
   3.544261708646901*^9, 3.54426172617603*^9}, {3.544262797713924*^9, 
   3.544262823373682*^9}, 3.544267040932373*^9, 3.544268581378614*^9, 
   3.5442700770755177`*^9, 3.544271090481888*^9, 3.54427157789919*^9, 
   3.544273101874111*^9, 3.544273295260221*^9, 3.544273397067271*^9, 
   3.54427363832113*^9, 3.544273740107409*^9, 3.5442739012667313`*^9, 
   3.544274099911936*^9, 3.544274585319471*^9, 3.5442746611106253`*^9, 
   3.544274867165924*^9, 3.5442750134442663`*^9, 3.544275137970661*^9, 
   3.544283392775975*^9, 3.544283823616767*^9, 3.544283947641543*^9, 
   3.5442840478261414`*^9, 3.544284138692355*^9, 3.544284314055092*^9, 
   3.544286144040111*^9, 3.5442869494636497`*^9, 3.544287574578597*^9, 
   3.544289079198045*^9, 3.54432898786488*^9, 3.5443291176912117`*^9, 
   3.5443291698059263`*^9, 3.544329455592228*^9, 3.544329630376987*^9, 
   3.544329823692108*^9, 3.544330275663011*^9, 3.544330676152021*^9, 
   3.544330826483594*^9, 3.544332709691124*^9, 3.544333684656567*^9, 
   3.544334198098323*^9, 3.5443349906242237`*^9, 3.5443374590786343`*^9, 
   3.54433789855399*^9, 3.544339191268055*^9, 3.544339504331133*^9, 
   3.544339609190928*^9, 3.544340004389662*^9, 3.5443401731089497`*^9, 
   3.5443403636716747`*^9, 3.544340503880253*^9, 3.544340575315477*^9, 
   3.544340831797379*^9, 3.544342390675349*^9, 3.5443424977117167`*^9, 
   3.544345745462242*^9, 3.54434583104078*^9, 3.544345907059032*^9, 
   3.544345950095298*^9, 3.5443462064418163`*^9, 3.544354351283319*^9, 
   3.544354911093808*^9, 3.544355065025456*^9, 3.54435552704462*^9, 
   3.544355760874234*^9, 3.544356047945353*^9, 3.544356208440456*^9, 
   3.544358398399585*^9, 3.544359042097515*^9, 3.544359122893396*^9, 
   3.5443592046735773`*^9, 3.544359453478216*^9, 3.544359619601915*^9, 
   3.5443602337102137`*^9, 3.544360593972095*^9, 3.544360786087401*^9, 
   3.544361003540637*^9, 3.544361378005061*^9, 3.544361474908483*^9, 
   3.544361572538596*^9, 3.544425108288588*^9, 3.544425244043283*^9, 
   3.5444255554642*^9, {3.544435553392953*^9, 3.544435583801646*^9}, 
   3.544459852230083*^9, 3.544460860402935*^9, 3.5444615283904753`*^9, 
   3.5444616769109983`*^9, 3.544506736073835*^9, 3.544506967341838*^9, 
   3.544507057048663*^9, 3.5445070878342857`*^9, 3.544507319380156*^9, 
   3.5445077904306183`*^9, 3.544507871784472*^9, 3.544508001637761*^9, 
   3.544509111874144*^9, 3.5445098591637707`*^9, 3.544614812370142*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"fplt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544339657524955*^9, 3.54433965771593*^9}, {
  3.544340888655362*^9, 3.544340891214654*^9}, {3.5445068028831787`*^9, 
  3.544506807113859*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxd3Hc81f///3Fpo6SSpmQ1NChN5SWkHYkGKWlJqISG9kAaZKSkIhQNW8nB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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3HfcFmIXB/B6nicaFKXSXrSjtEhU2qVJSTSEpEIKITOizIyUyojIaiez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         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0ktEHwAcB/B/7/d7sSiKjaIoiqIoio3eq9Z7k6LoeSuKot2KoqjborGo
W9FY1G1jUdRtsSjWbVEUxT7R4eN3/P5eWT0jjcNBgUBgmacaTAihhBFOBJFE
EU0MscQRTwKJJJFMCi/IppR6ehlnjs9s84Pf/HvKE/6SXMppop9JFlhnl1/8
4YZIzaaTTyWtDDLNEl/5zhEX3BFruEwKeUMno8yywib7nPCXBxIt4xXFVPOR
D3TTRScdtNNGK+9poZkm3tFIA/XUUUsNJbwmiUd5V5xywBarfGKMLt5SRBZx
3JvrkmP22GCZGYZoo4oCMoji1v7OOeQbX1hkigGaqSCPNMK4dqczfrLDGvNM
0EcDZeSQ+vxP/wEf9D9c
       "]]}},
    VertexNormals->CompressedData["
1:eJxEl3k4lO8bt4kSERIlSZZCC6lUhCtSyL4XsmRfikglSdmXUqFCi+y7ZF/K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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxd3Hc81f///3Fpo6SSpmQ1NChN5SWkHYkGKWlJqISG9kAaZKSkIhQNW8nB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     "]]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  ImageSize->{330.43523189522335`, 326.86385304902666`},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{0.019774300312546088`, -0.8323163833590604, 3.279764993873686},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{
  3.544339658450369*^9, 3.544340004766433*^9, 3.544340173481666*^9, 
   3.544340364951004*^9, 3.544340504941743*^9, 3.5443405756898537`*^9, 
   3.544340832175116*^9, 3.544340912964335*^9, 3.544342391020712*^9, 
   3.544342498119472*^9, 3.544345745814103*^9, 3.544345831394568*^9, 
   3.544345908379651*^9, 3.544345951277034*^9, 3.544346206975778*^9, 
   3.544354352818809*^9, 3.5443549126102467`*^9, 3.5443550661469717`*^9, 
   3.544355529257812*^9, 3.544355763118495*^9, 3.5443560489328127`*^9, 
   3.544356210625682*^9, 3.544358399043982*^9, 3.544359042505455*^9, 
   3.544359124449387*^9, 3.544359206927547*^9, 3.544359457668832*^9, 
   3.544359620856065*^9, 3.544360234122253*^9, 3.544360594387269*^9, 
   3.5443607872536917`*^9, 3.544361004676944*^9, 3.544361378389567*^9, 
   3.544361475319371*^9, 3.544361572873961*^9, 3.544425111062114*^9, 
   3.544425244444026*^9, 3.544425555984549*^9, {3.544435553832533*^9, 
   3.544435584503126*^9}, 3.5444598538582478`*^9, 3.544460861704802*^9, 
   3.544461529526877*^9, 3.544506737795617*^9, {3.544506803943222*^9, 
   3.544506808224781*^9}, 3.544506968758998*^9, 3.544507058635797*^9, 
   3.544507089135068*^9, 3.544507320733417*^9, 3.544507790873756*^9, 
   3.544507872950613*^9, 3.544508002839674*^9, 3.544509114342991*^9, 
   3.544509861083877*^9, 3.5446148142407923`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"hplt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544250892870241*^9, 3.5442508937173033`*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxd3Xk4Ff///3EiLZI20V5KpaS00qlGkkp7Ulpooz2lIkUqFUIke0okbbKT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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3HfcFmIXB/B6nicaFKXSXrSjtEhU2qVJSTSEpEIKITOizIyUyojIaiez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         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0ktEHwAcB/B/7/d7sSiKjaIoiqIoio3eq9Z7k6LoeSuKot2KoqjborGo
W9FY1G1jUdRtsSjWbVEUxT7R4eN3/P5eWT0jjcNBgUBgmacaTAihhBFOBJFE
EU0MscQRTwKJJJFMCi/IppR6ehlnjs9s84Pf/HvKE/6SXMppop9JFlhnl1/8
4YZIzaaTTyWtDDLNEl/5zhEX3BFruEwKeUMno8yywib7nPCXBxIt4xXFVPOR
D3TTRScdtNNGK+9poZkm3tFIA/XUUUsNJbwmiUd5V5xywBarfGKMLt5SRBZx
3JvrkmP22GCZGYZoo4oCMoji1v7OOeQbX1hkigGaqSCPNMK4dqczfrLDGvNM
0EcDZeSQ+vxP/wEf9D9c
       "]]}},
    VertexNormals->CompressedData["
1:eJxEl3k0VW/Y981ECplKSCkUmUpCLhQNEhlTyBCREkmIEJIkU9EgIYQMGTLH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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxd3Xk4Ff///3EiLZI20V5KpaS00qlGkkp7Ulpooz2lIkUqFUIke0okbbKT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     "]]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  ImageSize->{364.344600574104, 348.7105016565423},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{0.002821425366290321, -1.1838179216317628`, 3.1699475024016284`},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{
  3.544250894360345*^9, 3.5442510169010973`*^9, {3.544251137969285*^9, 
   3.544251162754264*^9}, 3.544251232419545*^9, 3.5442514158330936`*^9, 
   3.544252168813089*^9, 3.54425237410351*^9, 3.5442529696297407`*^9, {
   3.544253020790812*^9, 3.544253049403585*^9}, 3.544254061557665*^9, 
   3.544254317609988*^9, 3.544254536583486*^9, 3.54425463939837*^9, {
   3.544254706052606*^9, 3.5442547259897623`*^9}, 3.544254994883862*^9, 
   3.544255238610774*^9, 3.5442553765365763`*^9, 3.5442606710177794`*^9, 
   3.544261146548931*^9, 3.544261182260668*^9, {3.5442627989880238`*^9, 
   3.5442628251752033`*^9}, 3.544267046058889*^9, 3.544268583544063*^9, 
   3.544270078768429*^9, 3.544271091712109*^9, 3.544271580134375*^9, 
   3.5442731031711617`*^9, 3.544273296320285*^9, 3.544273400031485*^9, 
   3.5442736388878603`*^9, 3.544273740676733*^9, 3.544273901844364*^9, 
   3.544274103563558*^9, 3.544274586116365*^9, 3.544274661931723*^9, 
   3.544274868835383*^9, 3.544275014867456*^9, 3.544275138523182*^9, 
   3.544283393565597*^9, 3.5442838239079742`*^9, 3.544283948188205*^9, 
   3.544284048367676*^9, 3.544284139246423*^9, 3.5442843146035767`*^9, 
   3.5442861445852537`*^9, 3.544286951919986*^9, 3.5442875761777077`*^9, 
   3.544289083906253*^9, 3.544328988439666*^9, 3.544329118255785*^9, 
   3.544329170423094*^9, 3.544329456531*^9, 3.544329630923012*^9, 
   3.5443298243704367`*^9, 3.544330276042954*^9, 3.544330677267413*^9, 
   3.544330827057087*^9, 3.5443327102633677`*^9, 3.544333688439837*^9, 
   3.544334199111331*^9, 3.544334993746728*^9, 3.544337463322453*^9, 
   3.544337898989915*^9, 3.544339191617723*^9, 3.544339504692093*^9, 
   3.544339610461125*^9, 3.544340005142353*^9, 3.544340173855321*^9, 
   3.544340366216486*^9, 3.544340506100498*^9, 3.5443405761052628`*^9, 
   3.544340832549776*^9, 3.544342391391651*^9, 3.544342498558778*^9, 
   3.544345746192576*^9, 3.544345831775882*^9, 3.544345910473559*^9, 
   3.544345952827985*^9, 3.544346207556534*^9, 3.544354354167534*^9, 
   3.5443549155607643`*^9, 3.544355067343445*^9, 3.544355529977846*^9, 
   3.544355764580991*^9, 3.5443560507293262`*^9, 3.544356213592568*^9, 
   3.544358399657477*^9, 3.5443590429723873`*^9, 3.5443591258913507`*^9, 
   3.544359208800267*^9, 3.544359459964986*^9, 3.544359622591017*^9, 
   3.544360234565557*^9, 3.54436059482926*^9, 3.54436078887431*^9, 
   3.5443610059779263`*^9, 3.54436137880925*^9, 3.544361475731797*^9, 
   3.544361573239026*^9, 3.5444251122432747`*^9, 3.544425244877183*^9, 
   3.544425556546536*^9, {3.5444355543283663`*^9, 3.54443558523621*^9}, 
   3.544459855792101*^9, 3.544506742841915*^9, 3.544506970991856*^9, 
   3.5445070606584263`*^9, 3.544507090852147*^9, 3.5445073223896227`*^9, 
   3.544507791313607*^9, 3.544507874605384*^9, 3.544508004431829*^9, 
   3.544509116762927*^9, 3.544509863064274*^9, 3.5446148160932493`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"hdivzplt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544255382144828*^9, 3.5442553829921017`*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxN3Hc41e8fx3F7tvsqJUKphPbQPKis0qCoFEJGZTWVhvZCQ5oilWgiJRkd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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3Hm4FdL3BvBu95aUBkmDSpMpGqTRkBJKmSpECJUQ0oAmU2VKSTSThIoG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         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0iswAwAYAOBt3ub9fs7bRNNMREMQ0Dwa7rhDREPEKYimIaKZaBoimomm
ofncCd/97X+3zS2PLwUDgcABfzFEFtnkkEse+RRQSJgiiimhlDLKqaCSbvoZ
YZoVtjjkjBseeOPrL6/izfQyyATzrLPLCZfc8cwHQc1WESXOKDOsss0R5yR5
JM03YQNGiDHEJAtssEeCK1K8kCFkIdX0EKWbLjrpoJ02WmkhQjNNNNJAPXXU
UkMWn3K/cs81p+yzySJTDNNHC0X8mOGdJ2654Jgd1phljAF6qCZExs5eSHFF
gj02WGCSIWJECPPtNmkeSXLOEdusMsMocaJU/f/RL/LyOvE=
       "]]}},
    VertexNormals->CompressedData["
1:eJwcmXc41e//x2UUQqlkpYiIkCTjU7yM0FKiiGiQikJGWlZaREokKxllhOw9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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxN3Hc41e8fx3F7tvsqJUKphPbQPKis0qCoFEJGZTWVhvZCQ5oilWgiJRkd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     "]]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  ImageSize->{360.47293043323384`, 144.84771571324063`},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{0.229411914348826, -3.3721364311094115`, -0.1614498793418453},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{
  3.5442553839063463`*^9, 3.5442606715766563`*^9, 3.5442611465818043`*^9, 
   3.544261183423279*^9, 3.544262800910062*^9, 3.54426705801509*^9, 
   3.544268585574317*^9, 3.544270080060141*^9, 3.544271093040822*^9, 
   3.544271583899548*^9, 3.54427310473739*^9, 3.5442732973823566`*^9, 
   3.544273401740966*^9, 3.544273639405999*^9, 3.5442737411978893`*^9, 
   3.544273902366194*^9, 3.544274104989562*^9, 3.544274586899646*^9, 
   3.544274662728796*^9, 3.544275016816815*^9, 3.544275139059814*^9, 
   3.5442833943122463`*^9, 3.544283824185089*^9, 3.544283948759873*^9, 
   3.54428404894622*^9, 3.5442841398579493`*^9, 3.544284315145729*^9, 
   3.544286145134997*^9, 3.5442869543776827`*^9, 3.544287577988236*^9, 
   3.544289087052046*^9, 3.544328989003525*^9, 3.544329118787434*^9, 
   3.544329171033443*^9, 3.544329457412127*^9, 3.544329631459735*^9, 
   3.544329824957552*^9, 3.544330276393269*^9, 3.544330678501398*^9, 
   3.544330827584484*^9, 3.544332710792992*^9, 3.544333692414578*^9, 
   3.544334200101639*^9, 3.544334995553912*^9, 3.5443374651887817`*^9, 
   3.544337899469119*^9, 3.5443391919427423`*^9, 3.544339505024831*^9, 
   3.544339611837678*^9, 3.544340005607238*^9, 3.544340174229927*^9, 
   3.544340367348254*^9, 3.5443405074052143`*^9, 3.544340576529541*^9, 
   3.5443408329192123`*^9, 3.5443423917710857`*^9, 3.544342499017952*^9, 
   3.544345746569511*^9, 3.544345832154139*^9, 3.544345911869038*^9, 
   3.544345953766182*^9, 3.544346208089397*^9, 3.544354355324951*^9, 
   3.5443549183579903`*^9, 3.544355069351836*^9, 3.5443555318404703`*^9, 
   3.544355767053*^9, 3.544355945511084*^9, 3.544356051490323*^9, 
   3.5443562160206423`*^9, 3.5443584002832117`*^9, 3.544359043525572*^9, 
   3.544359127338282*^9, 3.544359211754878*^9, 3.544359463365481*^9, 
   3.544359624551063*^9, 3.544360234999838*^9, 3.544360595252625*^9, 
   3.5443607900566072`*^9, 3.5443610072824593`*^9, 3.544361379221106*^9, 
   3.544361476126321*^9, 3.544361573593698*^9, 3.544425113280883*^9, 
   3.544425245306778*^9, 3.54442555707133*^9, {3.544435554844185*^9, 
   3.544435585994169*^9}, 3.5444598576474743`*^9, 3.544506758491386*^9, 
   3.544507062413381*^9, 3.544507324056579*^9, 3.544507791776373*^9, 
   3.544507897772999*^9, 3.5445080060475883`*^9, 3.544509118349774*^9, 
   3.5446148190219316`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"tplt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544250900254099*^9, 3.544250901741186*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxd3HdYzf//x/GkqUkhfColI4UWPjlyyMxMSEsZFTLag1BG2ZKt7A/ZKTsr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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3HfcFmIXB/B6nicaFKXSXrSjtEhU2qVJSTSEpEIKITOizIyUyojIaiez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         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0ktEHwAcB/B/7/d7sSiKjaIoiqIoio3eq9Z7k6LoeSuKot2KoqjborGo
W9FY1G1jUdRtsSjWbVEUxT7R4eN3/P5eWT0jjcNBgUBgmacaTAihhBFOBJFE
EU0MscQRTwKJJJFMCi/IppR6ehlnjs9s84Pf/HvKE/6SXMppop9JFlhnl1/8
4YZIzaaTTyWtDDLNEl/5zhEX3BFruEwKeUMno8yywib7nPCXBxIt4xXFVPOR
D3TTRScdtNNGK+9poZkm3tFIA/XUUUsNJbwmiUd5V5xywBarfGKMLt5SRBZx
3JvrkmP22GCZGYZoo4oCMoji1v7OOeQbX1hkigGaqSCPNMK4dqczfrLDGvNM
0EcDZeSQ+vxP/wEf9D9c
       "]]}},
    VertexNormals->CompressedData["
1:eJxE22c4l//7BnBb2XtvmrJDJfdbNIzsna0iI3tFhKwkIxF9yUhZ0VJZue0t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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxd3HdYzf//x/GkqUkhfColI4UWPjlyyMxMSEsZFTLag1BG2ZKt7A/ZKTsr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     "]]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  ImageSize->{361.8238628587614, 212.8671913630746},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{0.2824823418532701, -3.2421095434124587`, 0.9267844598691315},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{
  3.544250902389866*^9, {3.544251138804072*^9, 3.544251164659958*^9}, 
   3.5442512345928593`*^9, 3.544251416569935*^9, 3.544252169830223*^9, 
   3.5442523744667273`*^9, 3.544252973768124*^9, {3.544253021215787*^9, 
   3.544253049709963*^9}, 3.544254064268363*^9, 3.544254317922491*^9, 
   3.544254536937154*^9, 3.544254639594426*^9, {3.5442547064653788`*^9, 
   3.5442547267062283`*^9}, 3.544254995145302*^9, 3.544255239294875*^9, 
   3.544260672183213*^9, 3.544261146617317*^9, 3.544261184628994*^9, 
   3.5442628040514593`*^9, 3.544267060019792*^9, 3.544268587188221*^9, 
   3.54427008164015*^9, 3.544271094553742*^9, 3.544271585462008*^9, 
   3.5442731062231817`*^9, 3.5442732984982777`*^9, 3.54427340414112*^9, 
   3.544273639986621*^9, 3.544273741763832*^9, 3.544273902940949*^9, 
   3.544274107048799*^9, 3.5442745876895323`*^9, {3.544274654811767*^9, 
   3.544274668392151*^9}, 3.544275018405836*^9, 3.5442751396112137`*^9, 
   3.54428339512755*^9, 3.54428382449909*^9, 3.54428394930548*^9, 
   3.5442840494889297`*^9, 3.5442841404746113`*^9, 3.544284315687778*^9, 
   3.544286145682036*^9, 3.544286956962899*^9, 3.544287579785377*^9, 
   3.544289091503565*^9, 3.544328989573295*^9, 3.5443291193302517`*^9, 
   3.54432917165342*^9, 3.5443294582794943`*^9, 3.544329632011142*^9, 
   3.544329825595449*^9, 3.5443302767934*^9, 3.544330679687043*^9, 
   3.544330828165495*^9, 3.544332711357388*^9, 3.544333695786351*^9, 
   3.5443342011153097`*^9, 3.544337468542152*^9, 3.544337899906135*^9, 
   3.544339192311429*^9, 3.544339505432078*^9, 3.5443396133338346`*^9, 
   3.544340005980608*^9, 3.544340174605174*^9, 3.5443403684908743`*^9, 
   3.544340508917931*^9, 3.544340576904903*^9, 3.5443408332948*^9, 
   3.5443423921451406`*^9, 3.544342499456164*^9, 3.544345746948821*^9, 
   3.544345832536077*^9, 3.5443459132661057`*^9, 3.544345955131563*^9, 
   3.5443462086713867`*^9, 3.544354356654848*^9, 3.544354920839918*^9, 
   3.5443550718349447`*^9, 3.54435553260191*^9, 3.5443557701923933`*^9, 
   3.544355947950095*^9, 3.544356053852716*^9, 3.544356217614853*^9, 
   3.5443584008987093`*^9, 3.544359043962493*^9, 3.544359128572749*^9, 
   3.544359213704948*^9, 3.544359465310891*^9, 3.544359625998126*^9, 
   3.54436023543987*^9, 3.544360595693438*^9, 3.544360791375615*^9, 
   3.544361008715876*^9, 3.544361379680485*^9, 3.5443614765371017`*^9, 
   3.5443615739578733`*^9, 3.5444251143648987`*^9, 3.544425245738842*^9, 
   3.544425557636011*^9, {3.544435555306757*^9, 3.544435586691971*^9}, 
   3.544459859781831*^9, 3.544506762043703*^9, 3.5445070643501997`*^9, 
   3.5445077922149563`*^9, 3.544509120106524*^9, 3.544614821074708*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"splt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544251241052889*^9, 3.54425124118081*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxd3HlUTe3/xnFzKioic6YyZU5kyMmYlAwZylRKIiJSPYUkZCpEhIwV8Rgq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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3HfcFmIXB/B6nicaFKXSXrSjtEhU2qVJSTSEpEIKITOizIyUyojIaiez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         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0ktEHwAcB/B/7/d7sSiKjaIoiqIoio3eq9Z7k6LoeSuKot2KoqjborGo
W9FY1G1jUdRtsSjWbVEUxT7R4eN3/P5eWT0jjcNBgUBgmacaTAihhBFOBJFE
EU0MscQRTwKJJJFMCi/IppR6ehlnjs9s84Pf/HvKE/6SXMppop9JFlhnl1/8
4YZIzaaTTyWtDDLNEl/5zhEX3BFruEwKeUMno8yywib7nPCXBxIt4xXFVPOR
D3TTRScdtNNGK+9poZkm3tFIA/XUUUsNJbwmiUd5V5xywBarfGKMLt5SRBZx
3JvrkmP22GCZGYZoo4oCMoji1v7OOeQbX1hkigGaqSCPNMK4dqczfrLDGvNM
0EcDZeSQ+vxP/wEf9D9c
       "]]}},
    VertexNormals->CompressedData["
1:eJxM3Hc01g/4N3BRSWWkMjIqRMNoKCE+ZmhRX7MQRUSRyJ7Zo4yMsrJXlBEV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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxd3HlUTe3/xnFzKioic6YyZU5kyMmYlAwZylRKIiJSPYUkZCpEhIwV8Rgq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     "]]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  ImageSize->{335.7288653563766, 213.4788271659144},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{0.5305726028583464, -3.1701522317206745`, 1.0576518996402327`},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{
  3.544251241807056*^9, 3.544251418507152*^9, 3.544252173470729*^9, 
   3.544252374733139*^9, 3.544252977080389*^9, {3.544253021589993*^9, 
   3.5442530499752827`*^9}, 3.544254067672799*^9, 3.544254318187825*^9, 
   3.544254537199329*^9, 3.544254639791909*^9, {3.544254706777789*^9, 
   3.544254727477206*^9}, 3.544254995495749*^9, 3.544255239986038*^9, 
   3.54426067273923*^9, 3.54426114664774*^9, 3.544261186638049*^9, 
   3.544262806217388*^9, 3.544267062138295*^9, 3.544268591067162*^9, 
   3.544270086233696*^9, 3.544271096223564*^9, 3.544271590638645*^9, 
   3.544273108074847*^9, 3.544273301360729*^9, 3.544273407098158*^9, 
   3.5442736405349617`*^9, 3.544273742311098*^9, 3.544273903488346*^9, 
   3.54427411617064*^9, 3.544274588513159*^9, 3.544274664355611*^9, 
   3.54427502359035*^9, 3.5442751401904078`*^9, 3.5442833959090242`*^9, 
   3.544283824826091*^9, 3.544283949904858*^9, 3.5442840500585117`*^9, 
   3.54428414113004*^9, 3.544284316307778*^9, 3.54428614629872*^9, 
   3.544286960306058*^9, 3.5442875813880167`*^9, 3.544289097517332*^9, 
   3.5443289901733637`*^9, 3.544329119917458*^9, 3.54432917228866*^9, 
   3.544329459164875*^9, 3.544329632578443*^9, 3.544329826212875*^9, 
   3.544330277212042*^9, 3.544330680992461*^9, 3.544330828714582*^9, 
   3.544332711913856*^9, 3.54433370268979*^9, 3.5443338725875893`*^9, 
   3.544334202154387*^9, 3.5443374721753073`*^9, 3.544337900416233*^9, 
   3.544339192665133*^9, 3.544339505786106*^9, 3.544339617913742*^9, 
   3.5443400063594503`*^9, 3.544340174979594*^9, 3.544340372300374*^9, 
   3.54434051007056*^9, 3.5443405772791433`*^9, 3.5443408336705723`*^9, 
   3.5443423925205317`*^9, 3.54434249989384*^9, 3.544345747394948*^9, 
   3.544345832916628*^9, 3.544345915286632*^9, 3.544345956347776*^9, 
   3.544346209254253*^9, 3.5443543591733294`*^9, 3.5443549256180897`*^9, 
   3.5443550735730762`*^9, 3.544355535071527*^9, 3.544355773958399*^9, 
   3.544355949415791*^9, 3.5443560552059917`*^9, 3.5443562205231333`*^9, 
   3.5443584015324373`*^9, 3.544359044402725*^9, 3.544359130793222*^9, 
   3.544359217899343*^9, 3.544359469822542*^9, 3.544359628473279*^9, 
   3.5443602358880463`*^9, 3.544360596140696*^9, 3.544360793012444*^9, 
   3.544361010104166*^9, 3.5443613801304407`*^9, 3.5443614769475317`*^9, 
   3.544361574321719*^9, 3.544425116423376*^9, 3.544425246171599*^9, 
   3.544425558178752*^9, {3.544435555781748*^9, 3.544435587441695*^9}, 
   3.544459863000051*^9, 3.544506765568421*^9, 3.544507792654023*^9, 
   3.54450913010271*^9, 3.5446148230407047`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"sdivzplt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544333833428791*^9, 3.544333833483712*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxF3HdYzf8bx/EoI6MkVDQoJVv2qE6KMlJGi2waXwnZQkaEUpGtYVdGCUlo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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3Hm4FdL3BvBu95aUBkmDSpMpGqTRkBJKmSpECJUQ0oAmU2VKSTSThIoG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         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0iswAwAYAOBt3ub9fs7bRNNMREMQ0Dwa7rhDREPEKYimIaKZaBoimomm
ofncCd/97X+3zS2PLwUDgcABfzFEFtnkkEse+RRQSJgiiimhlDLKqaCSbvoZ
YZoVtjjkjBseeOPrL6/izfQyyATzrLPLCZfc8cwHQc1WESXOKDOsss0R5yR5
JM03YQNGiDHEJAtssEeCK1K8kCFkIdX0EKWbLjrpoJ02WmkhQjNNNNJAPXXU
UkMWn3K/cs81p+yzySJTDNNHC0X8mOGdJ2654Jgd1phljAF6qCZExs5eSHFF
gj02WGCSIWJECPPtNmkeSXLOEdusMsMocaJU/f/RL/LyOvE=
       "]]}},
    VertexNormals->CompressedData["
1:eJwc3Hc4lf8bB3ARIUVpEUpCGZWQlHoQolRkplIiZWWGlEK+ZUUkKxWSPTJC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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxF3HdYzf8bx/EoI6MkVDQoJVv2qE6KMlJGi2waXwnZQkaEUpGtYVdGCUlo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     "]]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  ImageSize->{360.05739729897124`, 252.09013458908802`},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{0.19828200865189197`, -3.128959380052091, 1.2729090474299714`},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.544333873862608*^9, 3.5443339153038816`*^9}, 
   3.5443339539091797`*^9, 3.544334203140313*^9, 3.54433747601226*^9, 
   3.5443379008524857`*^9, 3.5443391929892607`*^9, 3.544339506167728*^9, 
   3.5443396233112707`*^9, 3.544340006779378*^9, 3.544340175364697*^9, 
   3.544340376192408*^9, 3.544340515603476*^9, 3.544340577672208*^9, 
   3.544340834098804*^9, 3.5443423929119873`*^9, 3.544342500348096*^9, 
   3.54434574782966*^9, 3.5443458332949057`*^9, 3.5443459182140217`*^9, 
   3.544345957608095*^9, 3.544346209801395*^9, 3.544354362107565*^9, 
   3.544354929478023*^9, 3.54435507588898*^9, 3.544355536288426*^9, 
   3.544355776256564*^9, 3.544355952210774*^9, 3.544356057583912*^9, 
   3.544356222248522*^9, 3.544358402123502*^9, 3.544359044834548*^9, 
   3.544359131964843*^9, 3.544359219436865*^9, 3.544359471344376*^9, 
   3.54435963236095*^9, 3.544360236331092*^9, 3.544360596638871*^9, 
   3.5443607941527643`*^9, 3.5443610117122297`*^9, 3.544361380616787*^9, 
   3.5443614773600283`*^9, 3.544361574688529*^9, 3.54442511872467*^9, 
   3.544425246600058*^9, 3.5444255587303057`*^9, {3.544435556267869*^9, 
   3.5444355881034822`*^9}, 3.544459865248474*^9, 3.544506766643281*^9, 
   3.544509131746461*^9, 3.544614825014319*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"tdivzplt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544252180568473*^9, 3.544252182903781*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxF3HdYjW8cx3FCJZKGQpntEoqQUakoThqSkUhoC/VDhaZNmZVVaCNUzolU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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3Hm4FdL3BvBu95aUBkmDSpMpGqTRkBJKmSpECJUQ0oAmU2VKSTSThIoG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         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0iswAwAYAOBt3ub9fs7bRNNMREMQ0Dwa7rhDREPEKYimIaKZaBoimomm
ofncCd/97X+3zS2PLwUDgcABfzFEFtnkkEse+RRQSJgiiimhlDLKqaCSbvoZ
YZoVtjjkjBseeOPrL6/izfQyyATzrLPLCZfc8cwHQc1WESXOKDOsss0R5yR5
JM03YQNGiDHEJAtssEeCK1K8kCFkIdX0EKWbLjrpoJ02WmkhQjNNNNJAPXXU
UkMWn3K/cs81p+yzySJTDNNHC0X8mOGdJ2654Jgd1phljAF6qCZExs5eSHFF
gj02WGCSIWJECPPtNmkeSXLOEdusMsMocaJU/f/RL/LyOvE=
       "]]}},
    VertexNormals->CompressedData["
1:eJwc3Gc4lm0YB3B7Zo9EhEqhUBJS92VTtijJDEUipGklGSW0ZCahkkJaKLqp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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxF3HdYjW8cx3FCJZKGQpntEoqQUakoThqSkUhoC/VDhaZNmZVVaCNUzolU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     "]]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  ImageSize->{380.3118854238893, 226.94454228540866`},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{0.8174402596835338, -3.140760079485808, 0.9578191608842488},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{
  3.544252201827361*^9, 3.544252374982627*^9, 3.544252978671488*^9, {
   3.544253021937874*^9, 3.544253050225494*^9}, 3.544254070679557*^9, 
   3.544254318436736*^9, 3.5442545374480143`*^9, 3.5442546400177193`*^9, {
   3.544254707048318*^9, 3.544254728146749*^9}, 3.544254995745715*^9, 
   3.5442552405088053`*^9, 3.5442606733106956`*^9, 3.544261146691764*^9, 
   3.544262808077896*^9, 3.5442670649268093`*^9, 3.5442685927889557`*^9, 
   3.544270088062289*^9, 3.544271097576663*^9, 3.544271599847621*^9, 
   3.544273109831921*^9, 3.544273302412108*^9, 3.5442734115799303`*^9, 
   3.544273641118146*^9, 3.544273742858245*^9, 3.5442739040379343`*^9, 
   3.5442741177942257`*^9, 3.544274589273553*^9, 3.544274665119751*^9, 
   3.544275025034213*^9, 3.544275140758149*^9, 3.5442833966832314`*^9, 
   3.54428382510795*^9, 3.544283950424633*^9, 3.544284050574772*^9, 
   3.544284141646426*^9, 3.544284316829523*^9, 3.544286146818302*^9, 
   3.5442864049285517`*^9, 3.5442869618914967`*^9, 3.5442875837642403`*^9, 
   3.54428910248307*^9, 3.544328990714386*^9, 3.544329120444792*^9, 
   3.544329172882655*^9, 3.544329460018941*^9, 3.544329633104166*^9, 
   3.544329826838632*^9, 3.544330277562647*^9, 3.544330682267869*^9, 
   3.5443308293123903`*^9, 3.544332712461726*^9, 3.5443337060927553`*^9, 
   3.544334204106429*^9, 3.544337486049356*^9, 3.544337901253998*^9, 
   3.544339193337216*^9, 3.5443395066019707`*^9, 3.5443400071260853`*^9, 
   3.544340175713749*^9, 3.544340578026293*^9, 3.544340834447873*^9, 
   3.5443423932650433`*^9, 3.544342500751975*^9, 3.544345748185623*^9, 
   3.544345833646891*^9, 3.544345968660159*^9, 3.5443462103317413`*^9, 
   3.544354379491185*^9, 3.544354932031361*^9, 3.544355081193922*^9, 
   3.544355779144011*^9, 3.544355953694519*^9, 3.544356060457427*^9, 
   3.544356225974435*^9, 3.544358402727995*^9, 3.544359045242484*^9, 
   3.544359133133091*^9, 3.544359482406472*^9, 3.544359633638956*^9, 
   3.544360236747505*^9, 3.5443605970526133`*^9, 3.544360796651392*^9, 
   3.544361012929975*^9, 3.544361381003031*^9, 3.54436147774511*^9, 
   3.544361575027706*^9, 3.5444251212627153`*^9, 3.544425247001759*^9, 
   3.544425559248814*^9, {3.544435556733973*^9, 3.5444355888535357`*^9}, 
   3.544459867509466*^9, 3.5444608696663723`*^9, 3.5444615377967863`*^9, 
   3.544509140185198*^9, 3.5446148269678297`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"eq1plt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.5442747337418118`*^9, 3.5442747484038467`*^9}, {
  3.5442748165352716`*^9, 3.544274817414777*^9}, {3.544286238287201*^9, 
  3.544286253613558*^9}, {3.544333492240798*^9, 3.54433353232554*^9}, {
  3.544459882803976*^9, 3.544459895043614*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxN3GVYVNkfwHGUNRDFbga7AQE7/iKCXViMyrp2dwdrt7KY2Ind7dqguGJh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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3Hm4FdL3BvBu95aUBkmDSpMpGqTRkBJKmSpECJUQ0oAmU2VKSTSThIoG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         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0iswAwAYAOBt3ub9fs7bRNNMREMQ0Dwa7rhDREPEKYimIaKZaBoimomm
ofncCd/97X+3zS2PLwUDgcABfzFEFtnkkEse+RRQSJgiiimhlDLKqaCSbvoZ
YZoVtjjkjBseeOPrL6/izfQyyATzrLPLCZfc8cwHQc1WESXOKDOsss0R5yR5
JM03YQNGiDHEJAtssEeCK1K8kCFkIdX0EKWbLjrpoJ02WmkhQjNNNNJAPXXU
UkMWn3K/cs81p+yzySJTDNNHC0X8mOGdJ2654Jgd1phljAF6qCZExs5eSHFF
gj02WGCSIWJECPPtNmkeSXLOEdusMsMocaJU/f/RL/LyOvE=
       "]]}},
    VertexNormals->CompressedData["
1:eJws23c4lf8bB3CSPUolihTytclMdM5jFUWEQoSQ7NkgFBGlUoiSZCQNm4zI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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxN3GVYVNkfwHGUNRDFbga7AQE7/iKCXViMyrp2dwdrt7KY2Ind7dqguGJh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