(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    474612,       8203]
NotebookOptionsPosition[    472476,       8128]
NotebookOutlinePosition[    472831,       8144]
CellTagsIndexPosition[    472788,       8141]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<~/Work/AdSCMTDyn2/C/test/\>\"", "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.544249620731719*^9, 3.5442496296828117`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"param", "=", 
    RowBox[{"Import", "[", 
     RowBox[{"\"\<param.dat\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<output.dat\>\"", ",", "\"\<Real64\>\""}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.544249633815199*^9, 3.544249656358367*^9}, {
  3.54426115396392*^9, 3.54426115789116*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Nz", "=", 
   RowBox[{"Round", "[", 
    RowBox[{"param", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aval", "=", 
   RowBox[{"param", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zarr", "=", 
   RowBox[{"param", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", "+", "1"}], ";;", 
      RowBox[{"2", "+", "Nz"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"amplist", "=", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"param", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "+", "Nz"}], ")"}], "+", "1"}], ";;", 
       RowBox[{"-", "1"}]}], "]"}], "]"}], ",", "2"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.544249909424734*^9, 3.544249937894285*^9}, {
   3.544250143442418*^9, 3.544250166410213*^9}, 3.544250631147397*^9, {
   3.544252414987821*^9, 3.544252415283758*^9}, {3.544261162213182*^9, 
   3.544261164237224*^9}, {3.54426135018777*^9, 3.544261398042145*^9}, {
   3.544261660073123*^9, 3.544261663392272*^9}}],

Cell[BoxData["20"], "Output",
 CellChangeTimes->{{3.5442499183976507`*^9, 3.5442499384698877`*^9}, {
   3.5442501398669977`*^9, 3.5442501672354403`*^9}, 3.5442502957700377`*^9, 
   3.544250637773466*^9, 3.5442507094771633`*^9, 3.544250781802022*^9, 
   3.544251159878372*^9, 3.54425216288627*^9, 3.5442523731134577`*^9, 
   3.544252962388048*^9, {3.5442530195220623`*^9, 3.544253048428296*^9}, 
   3.5442540501361837`*^9, 3.5442543166391277`*^9, 3.5442545356162653`*^9, 
   3.544254638651178*^9, {3.54425470498211*^9, 3.544254723602769*^9}, 
   3.544254993928398*^9, 3.544255236670167*^9, 3.544260668975321*^9, {
   3.544261146206197*^9, 3.544261164696176*^9}, 3.5442613390174923`*^9, {
   3.544261375455155*^9, 3.544261398900078*^9}, {3.544261655853136*^9, 
   3.544261663867547*^9}}],

Cell[BoxData["3.`"], "Output",
 CellChangeTimes->{{3.5442499183976507`*^9, 3.5442499384698877`*^9}, {
   3.5442501398669977`*^9, 3.5442501672354403`*^9}, 3.5442502957700377`*^9, 
   3.544250637773466*^9, 3.5442507094771633`*^9, 3.544250781802022*^9, 
   3.544251159878372*^9, 3.54425216288627*^9, 3.5442523731134577`*^9, 
   3.544252962388048*^9, {3.5442530195220623`*^9, 3.544253048428296*^9}, 
   3.5442540501361837`*^9, 3.5442543166391277`*^9, 3.5442545356162653`*^9, 
   3.544254638651178*^9, {3.54425470498211*^9, 3.544254723602769*^9}, 
   3.544254993928398*^9, 3.544255236670167*^9, 3.544260668975321*^9, {
   3.544261146206197*^9, 3.544261164696176*^9}, 3.5442613390174923`*^9, {
   3.544261375455155*^9, 3.544261398900078*^9}, {3.544261655853136*^9, 
   3.544261663869484*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.006819348298638839`", ",", "0.027091379149682626`", ",", 
   "0.06026312439675552`", ",", "0.10542974530180327`", ",", 
   "0.16135921418712956`", ",", "0.22652592093878648`", ",", 
   "0.2991522876735153`", ",", "0.37725725642960056`", ",", 
   "0.4587103272638339`", ",", "0.5412896727361662`", ",", 
   "0.6227427435703996`", ",", "0.7008477123264848`", ",", 
   "0.7734740790612135`", ",", "0.8386407858128706`", ",", 
   "0.8945702546981968`", ",", "0.9397368756032445`", ",", 
   "0.9729086208503173`", ",", "0.9931806517013612`", ",", "1.`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5442499183976507`*^9, 3.5442499384698877`*^9}, {
   3.5442501398669977`*^9, 3.5442501672354403`*^9}, 3.5442502957700377`*^9, 
   3.544250637773466*^9, 3.5442507094771633`*^9, 3.544250781802022*^9, 
   3.544251159878372*^9, 3.54425216288627*^9, 3.5442523731134577`*^9, 
   3.544252962388048*^9, {3.5442530195220623`*^9, 3.544253048428296*^9}, 
   3.5442540501361837`*^9, 3.5442543166391277`*^9, 3.5442545356162653`*^9, 
   3.544254638651178*^9, {3.54425470498211*^9, 3.544254723602769*^9}, 
   3.544254993928398*^9, 3.544255236670167*^9, 3.544260668975321*^9, {
   3.544261146206197*^9, 3.544261164696176*^9}, 3.5442613390174923`*^9, {
   3.544261375455155*^9, 3.544261398900078*^9}, {3.544261655853136*^9, 
   3.544261663871406*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "0.5`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "0.5`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5442499183976507`*^9, 3.5442499384698877`*^9}, {
   3.5442501398669977`*^9, 3.5442501672354403`*^9}, 3.5442502957700377`*^9, 
   3.544250637773466*^9, 3.5442507094771633`*^9, 3.544250781802022*^9, 
   3.544251159878372*^9, 3.54425216288627*^9, 3.5442523731134577`*^9, 
   3.544252962388048*^9, {3.5442530195220623`*^9, 3.544253048428296*^9}, 
   3.5442540501361837`*^9, 3.5442543166391277`*^9, 3.5442545356162653`*^9, 
   3.544254638651178*^9, {3.54425470498211*^9, 3.544254723602769*^9}, 
   3.544254993928398*^9, 3.544255236670167*^9, 3.544260668975321*^9, {
   3.544261146206197*^9, 3.544261164696176*^9}, 3.5442613390174923`*^9, {
   3.544261375455155*^9, 3.544261398900078*^9}, {3.544261655853136*^9, 
   3.544261663872987*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"size", "=", 
  RowBox[{
   RowBox[{"Length", "[", 
    RowBox[{"data", "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "1"}]}], "]"}], "]"}], "]"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"5", "*", "Nz"}]}], ")"}], "*", 
     RowBox[{"Length", "[", "amplist", "]"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5442499435581417`*^9, 3.544250004171796*^9}, {
   3.544250175346136*^9, 3.544250176217843*^9}, 3.544261168739861*^9, {
   3.544261404754171*^9, 3.544261411097924*^9}, {3.544261717855486*^9, 
   3.544261749529873*^9}}],

Cell[BoxData["160"], "Output",
 CellChangeTimes->{{3.544249974461907*^9, 3.5442500046665707`*^9}, 
   3.54425017732519*^9, 3.54425029645328*^9, 3.544250638774948*^9, 
   3.5442507095128307`*^9, 3.544250781839054*^9, 3.54425115995759*^9, 
   3.544252162919509*^9, 3.5442523731492147`*^9, 3.544252962430768*^9, {
   3.5442530195610733`*^9, 3.544253048464693*^9}, 3.544254050869532*^9, 
   3.544254316676869*^9, 3.544254535655818*^9, 3.544254638688253*^9, {
   3.544254705017316*^9, 3.544254723635785*^9}, 3.5442549939644213`*^9, 
   3.544255236708527*^9, 3.544260669034575*^9, {3.544261146242807*^9, 
   3.544261169417835*^9}, {3.5442613932548237`*^9, 3.544261411994728*^9}, 
   3.544261664889497*^9, 3.5442617183408117`*^9, 3.544261750370063*^9, 
   3.544261956674143*^9, 3.544262303082328*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "data2", "]"}]], "Input",
 CellChangeTimes->{{3.544261963518175*^9, 3.544261965830481*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"160", ",", "2", ",", "101"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5442619662412157`*^9, {3.544262303769734*^9, 3.544262313977166*^9}, {
   3.544262709065152*^9, 3.5442627111301413`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"varr", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.544262692876134*^9, 3.544262697518527*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.005`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.01`", ",", "0.015`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.544262694966546*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"IntegerQ", "[", "size", "]"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"data2", "=", 
      RowBox[{"Partition", "[", 
       RowBox[{
        RowBox[{"Partition", "[", 
         RowBox[{
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{"1", ";;", 
             RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"5", "*", "Nz"}]}], ")"}]}], "]"}], ",", "size"}], 
       "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"Dimensions", "[", "data2", "]"}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"varr", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{"ii", ",", "All", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"Length", "[", "amplist", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"fdat", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{"ii", ",", "All", ",", 
           RowBox[{
            RowBox[{"1", "+", "1"}], ";;", 
            RowBox[{"1", "+", "Nz"}]}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"Length", "[", "amplist", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"hdat", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{"ii", ",", "All", ",", 
           RowBox[{
            RowBox[{"1", "+", "Nz", "+", "1"}], ";;", 
            RowBox[{"1", "+", 
             RowBox[{"2", "Nz"}]}]}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"Length", "[", "amplist", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"adat", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{"ii", ",", "All", ",", 
           RowBox[{
            RowBox[{"1", "+", 
             RowBox[{"2", "Nz"}], "+", "1"}], ";;", 
            RowBox[{"1", "+", 
             RowBox[{"3", "Nz"}]}]}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"Length", "[", "amplist", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tdat", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{"ii", ",", "All", ",", 
           RowBox[{
            RowBox[{"1", "+", 
             RowBox[{"3", "Nz"}], "+", "1"}], ";;", 
            RowBox[{"1", "+", 
             RowBox[{"4", "Nz"}]}]}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"Length", "[", "amplist", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"sdat", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{"ii", ",", "All", ",", 
           RowBox[{
            RowBox[{"1", "+", 
             RowBox[{"4", "Nz"}], "+", "1"}], ";;", 
            RowBox[{"1", "+", 
             RowBox[{"5", "Nz"}]}]}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"Length", "[", "amplist", "]"}]}], "}"}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
     "Print", "[", "\"\<\\n\\n **** Error in file ****\\n\\n\>\"", "]"}], " ",
      ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5442500386976643`*^9, 3.544250077898643*^9}, {
   3.544250185657486*^9, 3.544250216953031*^9}, {3.544250317468423*^9, 
   3.544250412748089*^9}, {3.544250445153186*^9, 3.5442504842393503`*^9}, {
   3.5442511791336403`*^9, 3.544251216144599*^9}, {3.544251449693739*^9, 
   3.544251461019125*^9}, {3.544252307998601*^9, 3.544252334629327*^9}, {
   3.54425240920741*^9, 3.544252409502377*^9}, 3.544261173717906*^9, {
   3.544261763114086*^9, 3.544261775289917*^9}, {3.54426180812893*^9, 
   3.544261827836389*^9}, {3.544261865252552*^9, 3.544261952532193*^9}, {
   3.544261995436275*^9, 3.544262000583989*^9}, {3.544262152324059*^9, 
   3.544262153093948*^9}, {3.544262293136701*^9, 3.544262298921192*^9}, {
   3.544262651974408*^9, 3.544262679266416*^9}, {3.544262749568824*^9, 
   3.544262782071157*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "160", ",", "101"}], "}"}]], "Print",
 CellChangeTimes->{{3.544262755655448*^9, 3.544262788407639*^9}}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"run", "=", "2"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varr2", "=", 
    RowBox[{"varr", "[", 
     RowBox[{"[", "run", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fdat2", "=", 
    RowBox[{"fdat", "[", 
     RowBox[{"[", "run", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hdat2", "=", 
    RowBox[{"hdat", "[", 
     RowBox[{"[", "run", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"adat2", "=", 
    RowBox[{"adat", "[", 
     RowBox[{"[", "run", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tdat2", "=", 
    RowBox[{"tdat", "[", 
     RowBox[{"[", "run", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sdat2", "=", 
    RowBox[{"sdat", "[", 
     RowBox[{"[", "run", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]dat", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"fdat2", "^", "2"}], "+", 
     RowBox[{"hdat2", "^", "2"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5442620947460938`*^9, 3.544262158203375*^9}, 
   3.54426281461913*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Max", "[", "varr", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "zarr"}], "Input",
 CellChangeTimes->{
  3.5442504176755533`*^9, {3.544250455469203*^9, 3.544250455845202*^9}, {
   3.544250643906291*^9, 3.544250644042083*^9}, {3.544250803488653*^9, 
   3.544250805311425*^9}, {3.544252323529562*^9, 3.544252337049081*^9}, {
   3.544252412083267*^9, 3.5442524139710007`*^9}}],

Cell[BoxData["0.7950000000000006`"], "Output",
 CellChangeTimes->{
  3.544250417940825*^9, {3.544250456231255*^9, 3.544250485839365*^9}, {
   3.544250641865546*^9, 3.5442506444317837`*^9}, 3.544250709613789*^9, {
   3.544250781902851*^9, 3.544250805849416*^9}, 3.544251160022889*^9, 
   3.544251227998724*^9, 3.544252162986083*^9, 3.544252373209071*^9, 
   3.5442529624964027`*^9, {3.544253019623247*^9, 3.544253048529676*^9}, 
   3.544254052392815*^9, 3.544254316739036*^9, 3.54425453571663*^9, 
   3.5442546387679*^9, {3.5442547050826387`*^9, 3.544254723700255*^9}, 
   3.544254994028261*^9, 3.544255236772163*^9, 3.544260669134309*^9, 
   3.544261146307695*^9, 3.544261176516281*^9, 3.5442614303616753`*^9, 
   3.544261666640457*^9, 3.544261719914565*^9, {3.544262009709968*^9, 
   3.544262019361945*^9}, {3.544262143237941*^9, 3.544262162006369*^9}, 
   3.5442626832091703`*^9, {3.544262791561202*^9, 3.544262816034412*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.006819348298638839`", ",", "0.027091379149682626`", ",", 
   "0.06026312439675552`", ",", "0.10542974530180327`", ",", 
   "0.16135921418712956`", ",", "0.22652592093878648`", ",", 
   "0.2991522876735153`", ",", "0.37725725642960056`", ",", 
   "0.4587103272638339`", ",", "0.5412896727361662`", ",", 
   "0.6227427435703996`", ",", "0.7008477123264848`", ",", 
   "0.7734740790612135`", ",", "0.8386407858128706`", ",", 
   "0.8945702546981968`", ",", "0.9397368756032445`", ",", 
   "0.9729086208503173`", ",", "0.9931806517013612`", ",", "1.`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.544250417940825*^9, {3.544250456231255*^9, 3.544250485839365*^9}, {
   3.544250641865546*^9, 3.5442506444317837`*^9}, 3.544250709613789*^9, {
   3.544250781902851*^9, 3.544250805849416*^9}, 3.544251160022889*^9, 
   3.544251227998724*^9, 3.544252162986083*^9, 3.544252373209071*^9, 
   3.5442529624964027`*^9, {3.544253019623247*^9, 3.544253048529676*^9}, 
   3.544254052392815*^9, 3.544254316739036*^9, 3.54425453571663*^9, 
   3.5442546387679*^9, {3.5442547050826387`*^9, 3.544254723700255*^9}, 
   3.544254994028261*^9, 3.544255236772163*^9, 3.544260669134309*^9, 
   3.544261146307695*^9, 3.544261176516281*^9, 3.5442614303616753`*^9, 
   3.544261666640457*^9, 3.544261719914565*^9, {3.544262009709968*^9, 
   3.544262019361945*^9}, {3.544262143237941*^9, 3.544262162006369*^9}, 
   3.5442626832091703`*^9, {3.544262791561202*^9, 3.544262816036416*^9}}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"skip", "=", 
    RowBox[{"Round", "[", 
     RowBox[{"size", "/", "50"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr2", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"\[Psi]dat", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr2", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"fdat2", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr2", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"hdat2", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"aplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr2", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"adat2", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr2", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"tdat2", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"splt", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"varr2", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], ",", 
         RowBox[{"zarr", "[", 
          RowBox[{"[", "jj", "]"}], "]"}], ",", 
         RowBox[{"sdat2", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5442504582349873`*^9, 3.544250584036578*^9}, 
   3.544250626644371*^9, {3.544250822560841*^9, 3.544250823367763*^9}, {
   3.5442509165343533`*^9, 3.544251133374446*^9}, {3.544251467199772*^9, 
   3.544251471241907*^9}, {3.544252339447783*^9, 3.544252348921164*^9}, {
   3.544252422297391*^9, 3.544252437776615*^9}, {3.544262042155575*^9, 
   3.544262059275323*^9}, 3.544262159662603*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]divzplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr2", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{
            RowBox[{"\[Psi]dat", "[", 
             RowBox[{"[", 
              RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "-", 
            RowBox[{"\[Psi]dat", "[", 
             RowBox[{"[", 
              RowBox[{"ii", ",", "1"}], "]"}], "]"}]}], 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hdivzplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr2", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{
            RowBox[{"hdat2", "[", 
             RowBox[{"[", 
              RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "-", 
            RowBox[{"hdat2", "[", 
             RowBox[{"[", 
              RowBox[{"ii", ",", "1"}], "]"}], "]"}]}], 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], "]"}
     ]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tdivzplt", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"varr2", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], ",", 
         RowBox[{"zarr", "[", 
          RowBox[{"[", "jj", "]"}], "]"}], ",", 
         FractionBox[
          RowBox[{
           RowBox[{"tdat2", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "+", 
           RowBox[{"0.5", "*", 
            RowBox[{
             RowBox[{"\[Psi]dat", "[", 
              RowBox[{"[", 
               RowBox[{"ii", ",", "1"}], "]"}], "]"}], "^", "2"}]}]}], 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544251411197404*^9, 3.544251411947116*^9}, {
  3.544251477266673*^9, 3.544251480034252*^9}, {3.544251510785811*^9, 
  3.544251516905808*^9}, {3.544252191194234*^9, 3.544252193250115*^9}, {
  3.5442523498747063`*^9, 3.5442523551794043`*^9}, {3.54425243931746*^9, 
  3.5442524454290133`*^9}, {3.544255229404937*^9, 3.544255232188203*^9}, {
  3.5442553627725763`*^9, 3.5442553698450527`*^9}, {3.5442620466080112`*^9, 
  3.5442620703603983`*^9}, {3.54426216770219*^9, 3.544262171446186*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"niceplot", "[", 
   RowBox[{"x_", ",", "rng_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpplt1", "=", 
     RowBox[{"ListPlot3D", "[", 
      RowBox[{"x", ",", 
       RowBox[{"PlotRange", "\[Rule]", "rng"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<v\>\"", ",", "\"\<z\>\""}], "}"}]}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpplt2", "=", 
     RowBox[{"ListPointPlot3D", "[", 
      RowBox[{"x", ",", 
       RowBox[{"PlotRange", "\[Rule]", "rng"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<v\>\"", ",", "\"\<z\>\""}], "}"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{"tmpplt1", ",", "tmpplt2"}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.544250849419471*^9, 3.544250878676875*^9}, {
  3.544250911535594*^9, 3.544250912334264*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"\[Psi]plt", ",", "All"}], "]"}]], "Input"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJyF3WlYTV3cx/FuFSpKChWlQYNkpkJokIQbpcRdiWggEUIoQihSKBkapJJK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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3HnYDVTXBnDPoDJnSEjIPIWMaUQipYlIkgyVUohSkSaVBhpQSEiaBw00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         
         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0k1IE3AYB+C/09VmrjZLMEhI0Npys00361BQYJA3C4WCukiCQX7dFAwK
8qbQQKFuBQYFdStQKNBbQUFC3QwMEvJmkKCQ4DM6PNf39341D4xeH6kKIZTJ
R0Lo5gb3eMAcL3nPV36xQ111CCcpcpVbjPGIJ7xmmW/85h/JmhBaOM85uihR
pJMOCuQ5Szs5srRxhgxpTnOKVlLsqb/Jd1Z4w1OmGec2PZRoJsGuOTZY5QOv
mOchw9zkCgWaiLNtWT/5whIvKHOfu/RzmRzHifLHbn/wiXc8Z5ZJBrnGRTI0
ULmHqKDFYLQQ5QAHiRGnlkPUkeAwR0iSop6jHCPNBXq5wwQzPOMtH1ljq5In
vJEsl+hjiCkes8Ain1nnLzHNnoj8/5996Q47dw==
       "]]}},
    VertexNormals->CompressedData["
1:eJxs2Hc41l/8P3AjI1JmZe/IiEIR942iskVEUmZIISI7ZFWUmWSEkhVZ5Z7v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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJyF3WlYTV3cx/FuFSpKChWlQYNkpkJokIQbpcRdiWggEUIoQihSKBkapJJK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     "]]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  ImageSize->{339.5861060602891, 259.8565406240248},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{1.0696157649655993`, -2.5485317268618037`, 1.9521547460475162`},
  
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.5442514959862547`*^9, 3.544251523510511*^9}, 
   3.544252165714499*^9, 3.54425237358981*^9, 3.544252966280998*^9, {
   3.544253020071795*^9, 3.5442530488897667`*^9}, 3.544254057057411*^9, 
   3.5442543170965157`*^9, 3.544254536072023*^9, 3.544254639020831*^9, {
   3.544254705470038*^9, 3.544254724493225*^9}, 3.5442549943698*^9, 
   3.5442552374371367`*^9, 3.5442553747025433`*^9, 3.544260669814514*^9, 
   3.544261146477269*^9, 3.5442611798045197`*^9, 3.544261433916452*^9, 
   3.544261692673863*^9, 3.544261724274478*^9, {3.544262795878004*^9, 
   3.544262821704664*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"\[Psi]divzplt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.5442508822543163`*^9, 3.54425088476548*^9}, {
   3.5442512535572777`*^9, 3.5442512541889133`*^9}, 3.54425150109731*^9, {
   3.544252197080502*^9, 3.544252197175276*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxl3Hc8l1/8/3ERkRIq7WEUSZKyV6GMpKSJSoqWzBZSZoVkFKISWmiY2aMo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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3HfYFuIXB/De9zVC0UAUkZJKSiihJaISaRkpNIW0KGlIKRpIKTMqM6NS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         
         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0ik0BFAUBuA3Yzf2JeIoiGiIaAgCmqXhHM5BRENEQ0QzIpoR0RDREO3L
2H1zhC/ccu+7/33VQ+PdY5EQwiJl0RBqaaaTASaZZ5U4CU65JkksLYRKGmij
lxFmWGKDXY644I5oeggRAr/qH7754pMP3knyxisvPPPEIw/cc8kxe2yyzCyj
9NFOI1Xkpfp68w1nHLDNGgtMMUgXLdRRTpQ7IV1wxC4bLDHDCL200UAlMZJW
vOaUBHFWmWeSATpppjaVP6lbGBfS/uMJGWSSRTY55BIjj3wKKKSIYkoopYYm
OuhngjlW2GKfE654S/U1vIJ6WulhmGkWWWeHQ865JRL9/zd/SNdHBw==
       "]]}},
    VertexNormals->CompressedData["
1:eJxk13c4l/8XMHCyyUxGsrIrM3z2jVDJnpE9CiV7Ze9IRDJKVFZGZtk+H3sm
lL1CGaGy93p+3+j9uZ7n8Y/rel3nejv3Oed97hu3hYPWnVMEBASniAkIiP73
21PMlNMlqaZM25S78pFpsDTB359lmV8Yfe1Urcoygv/rZ1mmrUw8ScP3fdmj
Ppgao1gQiJcKHAri/+r1/8XTsX4lciF+K11ETncPGnED8ZeU+8PzblVIy4dX
cwe2ugDXiDpyKOVqkiYSW5XVuO8E3HzYpjY98ZN05pr2Hdn8B8BvY69nui18
kT7/wOx6HJ0jcLEM5TMkvn3S/28+1M4PfbiS+qUJjqZmDOlvg/jm4orL15oG
pEM+GglJuKkBX761onxBYVDav+EaoTmtJHAzdIE0OWxQmrX6lVixlHjZPw82
4JG62TogzcVaLvVu/Qbw/FZz36e8A9Ivi3Tv1SlrA/8cN1nS4NsvnVmtlu4f
pw88K9e8wn+uT1otM9va4Msd4FozNA4y7///5zoFsShvB22Vjf3tYxzIM13v
fJjyn5WyiHdvS9ZzivD9nQ/yYcStlLFcWHEl9ioD/qxSuOOc31AZVyWRdpx+
AXDbqs+lRuJD0hEwwtUibAXwgnxIpDV9XvrT266+Is0w/DzsGAdS39yUPssg
9OkJZS5wloQi0cTiI2krHR13cb4s4ExNj7jgDmQw+1Z9qd2MTOBqtUf8zgrE
MAO9SGnHskTg4yEKTw7fU8A+M+s0kqjgn1eN89WZX8M0sHcJ9nle1yOAT1Gx
Xbu3RArLfR6HODSiwud5Luq+cwsVrFQY+YvwzT1Q5/NucuhNOSrYLyVxCcu6
IOAKPXa7ZH6UsOHZAhXT9ifA2Th+cI19pIBlnzkgSpB5BpxgyrG/P4ka9q51
5CCI8AXwoJ8TdIR95LCmU+u0H7VTgaMue7OTC14pZ1Z7nKrwvgfkOUTy1l8T
AS+nC+yqvJW3CfzNxYTvySni5edVr0n1DWwA3zb2SkRBLOXxl6vsYbAj4Ksq
s3wELxhh3aFXhu+U9AKft1d+v7jGDzNJIKf5k/MbeFhN1jJZvgyMqDV/wRSN
/7ufrpcq9yzKwG7fTjbzLG0CHnl39kWQ0zVYosDIS8LTM8AFs7bZbqFuwsxv
7xCdF5gEbkXX2tm+rwLzJIK2k2IHgEfNyIafZdKCZanA5YwiuoG78Fen3riv
DOu6ejViODYf+Mczvvq3bNVhRM3vB+wX80E9p0VLsD59arDuAtpds/Bm4A/U
7Lv2N1VhrV4PBGsSe4APwVWIuM+owkyiLkbW0/UDp7vrTZVjrgIbVyi63Eg3
BFzSmXnxClILJubhTHdeaA64qrEsSQrkVr7lGa1HdeEM7J/DKvpzxAq9y+1Z
J0+VnZMHXlfJR2v68355/I/fd3IUzwK/3C+r/nLfujx3rYkvWBIFXIP6CzTe
KQk7EPk248cgATxnOPF0yVVXWBkjd18XExo4h5He4Bd1PxjXdndAfyg98NvQ
fe2+7ABYHftlFIGTIPDCuBsk4jfCYUlnhOqVhAWA0xGovXl97wmsKvarjW8H
N/DM7yVjbXZPYYiwqNNXv7EAJ5MuYL+eGQO7FdO1T0VEDVwwiZf4Dk0sjKLd
S4KDZQ308fSrj+evUMbCapy0pW2UlkE9xyUOzz2ujIFxwZST45LIyv95eWTr
EkYuBhZ/jT/36AoD8GmqXzYDj5/CXvEhmpQ4mIHzYq1MNtqjYQhMoUSO7Tng
l8Mx3Zfr4mBxXtz9appCwDfOmembBZeVm9GG01j81AH5h9o+U0ofrSu3x7pF
Vzj6A9e7XsA9alBSnvRVT+p2nRtwpawZuYtBr8vvv/t09HAtEPg3OdFs7oRY
2EUVCwfcpjbwped7z83uFcFWjG59OVjxAJ4R6WcgtYCDmZxi5qV74A7cGfNC
T3qkHvasfTzRfFMJuOo9M/rTnO2wAI2Pn2ssbYBbqdK+8HH4DOslyFa4WmkB
PKr2nW2RUg/MdPVwI174NnBOS0tN84ReGJ/hxowpUhM4NmfXcEL2M6zbn9Td
++4K6GOS+095u/wvMLKJyxe3icRBPQWeVGz1GHyBFfdCbKZ1N4CXVt9yHh3r
gV3VSp62Y9MG/hDNeHDRqAc2HWsZrauoD5w4Xlrkx1I3TMYYG1pdZQjczGpv
6rp7H2zvLrwL5XkPuIdVlXfjl81yqXmd4qbBeJC/QFsknW3zQfmoguT817NN
wB29NovOPP5Tbjg+V3xLLgn44Xsm5QsEi+WXCmXkaLtqgJdsYKBV+nTYU524
qZf8H4CXHzpNu9Kvw4TcHJ8SRGKBx0hifTqyDmHKF+3OW2zFAXepMIPr7hPA
R+QaNClnc4C3aYiSbw2Sw7MVQjXDnmTj+8iudWGdjxrefZPx+6nhNOAqfDzT
grx0cBYxi6Qgw5fAx8ryi0w5GOHeCZPLZS7PgH/WFTX7lUsDv9mkIfrniRNw
a42sxRvh9HC/1ZeTKEIn/H3pgBc7SNHD4yIl03P7w/H3Rbh3VreSDh5PUd9J
IRoHXNbDcdUNQQdn22JG65gmAe/lefutLo8Wvvfa8aXxUDJwm8onH9blGeGf
Goy0tD1ygfek7nxb4ZSumPlw39Xxaz/IMzdFn7o4TLbCpU74l5T7IfC59GA/
JYxEReWzGoEi5g3g5kz+WMsL/BU7nA++qgpv4e/1NA2puNgQzJyhu9TOGR8/
oLMjqcAnDC/FYJZqxfHx13VvWJOOScEvqOffP9D8DbxmR42g/M5VuGbxtbkQ
Ary7vMDK8vpch/OMnU3tSpsDXiFzzig6URkuyrGgRMT/Hfjwx7Pnb8erwdUr
mT6XWwwDV25NzIi30IL/ibBy1a/sAT5yyzNq+ZkynPFexiunCRf8HL7dYk99
rQHXtM32UpItAvVsNCC5e0FTA974/nwaqr8VePbgt8UXZerwZCXGei67r8Df
mNxAvW1Ug9vYMbG32wzi97C5WYMd6f9cN/PwLW4EPw9y1YototpwQ8qzPPlq
88BFMR3DFKGuFYTvzrehhhnh/xw7J3Cn+9vDilI2sa91rjDgYtN36wu1XSqm
b35dSEiUBg5vpTOQP7KqsC54KNilLwV8I2fBPbJADQ4LGfl+mhYDvGv/IHYk
wwb+IKev7WErPfACpT9Iv0MfOP+wFjkiCX/+14LPeUhuPzjGgGCHeIICeBNu
hu8hPBRe/YG5faSJDzjCM92weisc3jwcFe9SzgV8PW1kP6MkEm6EOEx1sWQG
/i3L/McmFAsXtffI1LSiAz7xhf317TuP4dGBNlff2i+BPk4pqxStXIiGS5Jm
VA18+A3q2ZaFe/XpeRQ8/rZy0MVJkop/rtNbKzKGewLfCFPWm1ikA+693CV3
8XsknCoiWzAm8CzwHtOkHh/faPiCRCYrtSwP8A6Z95GKPY/hNtXcuWUtBMCp
G/0/2EuWVFDnZOAsTmuD/A08rkbt/ymreBdEcJ82zxV41E9BQ0FEcYXb1NXs
pTkX4Iw/2Iz7KdMrkjHkWmNdzsDPpb9bf9F0r0L9vTz6ZTf+nCAT0kPJqGx4
XV7mwHkivNdivlU9FSyDm5kSVD4w1AT+Pa4kiGe+Ar45UGHyQsYK+CFjfvC7
D81wF3cLaYPoe8Aju83tnmY3wH/yPvK5wooGPireLNG+2wp//NAx7nyKDvCx
RJXtHPd2+JTvviMr9w3gmLTfaqe5OuDVsd+/6l8UA/7mR7GxDXsHPJQ3xbxo
XQjUc6XLZ04/rR1OfNEr01lSHvjixXWN9z/b4GdiiFOyqlWBt0Gpf7pWO+Co
lxHemjYmwIcEiWOu32+F84TTy7yIxgAnldfnk9duhfNTkfGO++Ljz/KyBPvN
/ql4sGH9rTYjBuS5l/RMR9J5rULGx35r/X4x8BkCu+RXRr8rGIaG2BRbi4CT
ZLjoWL4dqdB+4ooN0ykHXiIidSWfvBJuKCHjaVf8FDjf9x0T8bNT8Dv54R7v
SwqBE599uhe7vwLXr2R/piWVD5zAJiImxn0DnnR5qMosIwT43cIxnca3hIgH
EV55GbrpwCcpf/TUXz2CN7iohG2ZxgOnPEPbFD1EhIiwL0m2NI8FXnpw6Eg+
QoYokuBzhpbCgAcMSd1lITqFkLK8l/3pqjjwujlS3WtpJIjIzpJ2paI7oJ4p
9Sol9mgSxJQ6r5omVwBwmx8ts8ZpxAiByUdGD/fD8fEbeq3nPckQ8vqJWtPb
z4BvThr8luYhREhhzLyn0U+BZ1Lt2YUNkyNemHvIb/1+A/zTRxl7VSahyldU
D8riez6BPPVno9XvRopWViPv5Xey/AIuP3nlQaSeQOU9moyEnp014KkFNu50
kmcr9WYuyY+VfcHfu5UkNoexnxUUQX2ntI2n8fMQ2WQwR8WM6O9EukuazQD/
QPM+QeLuZcQjkp/bKM9Z4KssQvsq/GKIx6nkNYiIUeBnZIl+ssuiEdtfV1cD
Fqfw+UjAHHkewhGprtjIF+Efgd9JX/D8eVcGMUbc4TpC0QlcT7Tc/nSYPCI/
ueWwp7ARP4fNwZcKzkKIc81h3z5z4eek181AmuCCHIKg5cHsVZ23+H3Y8/qp
/RdZhKPXs3SNuUrgXH9QAtK3ZBF0nmlnnp9tAh5d/thNN0sOMWpBUkZ3qw+4
tM4nHSlPBCImd5Ow1r4YuFs4Y5lEpjzC7FCHZuLsKPAl0vNKh96WlQYvSLUV
kaSIf45QEp4zdrKtvEXMLYCkFAO+kn+jeHXKrNJNiz9ki48GuHL97e876tqV
E8nWgV/2uICL8sjnPs0RqrRlf9xiDl0A/kUa5kkda4DALd2V6H8tALyMV/Ft
5h9zRPKNFqa3DgTA916Gai5sOCJEN0xvsSK4gd8MpFST4nFB8C340kjS7OH3
eQ7W6rDEGeHSIGO9/YoSxHcbNzg8r/VAbFAszu387z79cz8kAeJ7uA9C2znK
+TBuH5xz5Qo2aDnbDcHgPzCXzJgDvNOHLZZy5SGCjYYH7uo1AuppyMTrKuLx
EEG4aCYjOrsG/DM1xbd2rCciiYVa2PX7IXBVFc84RUYfBEHh3lUvJ7LKf175
cvLuJT0PRGu92UbIVRrgvy3keBzpPBBYqrLIragVcI5B0tU4yfVXlSyfLnsM
7cuC5/qq2yLpaZ1Z2cHXcU2B1RK4FJXW0cfMpMq0G+QpYpG3gUftT2GknGIq
MzMmM8TPGQMX/1Op9jrFAEE2ESh01RJ/zqsHH7mIHz9FRDAx1RqUywHntXNX
v3Q6FdH8UTvtrR/+fN5Nj5Sr3zIRuO3rERP9CHz9Hfw8TG7mIa6ULcgttGgC
txRpfIHoykUwkZ/9/eucEPDKHZHP1JeKEW9+lO5GrsoAJ+YPUNLSLkVMFjr9
5HSXBi5STOpzNbgIoRiUr19ByYTP53QQqUZLCeL6t+yxqFtnQJ2DOiiV4PYl
iCVmMacrkDDwcILrfh1zxQjjbnvKmTJp4KcKshek1D4gbB1ELoc0XQP+0+nL
R8PeIgQb7ULv4aAQcLF8ZfRAfRHiQdab9NQpfDx5Rf3X0ud9lUrCv/z1+j1B
npz9MLv49uFK4ze7YfkJCcDrZmc1MJO9leuasoRHtfHAtQ1Ymq/1tVZuyTcQ
t0Y+B+52j7SQaie3MvuyKteFYvw5K8YsLyZ3mhCcrluNsvfx5+RuvO1pLu5D
XInCnnP3cQfenBM9SLU/iLD2XLoSIhAG/LTK1c5Iip8ICWux0NmYGOCBpBMq
zBsTiMCi+5rRBqbAY51Zh1FVc4jegrgzbTH486kUTLWwAb8Qv9/88Eb0PwC+
/T2yF1c/g/jkniQ57cgBfHkbM+m0O49w0Xt4KpdYGdSTrsT9RUnAPOLtnASN
XZQVcPZlU3XNlp8I3xuR195vOAAXdk2++ev0L0RSSVwHkawncG/jjo7mrGlE
DLkZ3IjMFTgKrU77MPU3Il019iElIhQ41q8rtueAqiouQAHNalQM8kwUXE2+
EExfhVVJvOAR0gW85/kTr1sXqKp8FYO4SS0+A99kivTfCt+vfNjp3K2/0Qtc
EGHITqaWgEDVaHwU8SwCrme1xy7EvoGIJJjvRhZ/As7l8S2QBUaM3OO2cBtJ
qge+qKUbL7B0Fkmr8ZXrcKkV+MYUyaPw06zIhOsVfO/PZALf1UK+xuayIGfv
Sk0YNJYA//GZr8BbnxPpcwepOuBfAFwTKWSq6MyDPNN7+7LnQ/w5au8NXulf
50AaFumJUKuFAv/tXTGuLsKN7JdnpymjDAL1jNmpPzszzoXEticerr9NBu4o
lLljYsGFrKUuTpoOzASusSXM+eYtNxJ691QEpV0K/Frbm1m5QlZk8hTF9jnz
eOAkj1HtVk94kEb75d/4bWuAH1nepmaWvlq1/fvou5v0HMjTVih4oL/uWpW2
ZawAeyUR8p+/jlLdKSiXq/ra7UnIe3AK+DnCxEvP0cgqwntTRgJWJMCT9/TF
0NNnq9w5wwZOpe2D82sZsi7c7eVH5lRdFGvbPwA+zxmMCKtHIxNJpRSDTHbx
/R2tvov6poTU8lEr1GzGO0Hl9bAp8pvIuNC2dLbYJeCsT1blkEWayPNwwdgm
jl/AdR1y/sSG6yFtlw4iJEt/Am+f55Pf+6OJZI/UsCNgqADObdqRGVeqi7w0
dik073QdcCKiMC9UpS4ymP+Fkh5FOainQOr6z0JtXaSRNFwqo+kL8P5p43cC
5TrIR3UL+++KRvH38fYp5KU7Bsj9D8lRphVLwF2jy1scVFWQUZX1PDWoNuAf
DZgT9nL0kTluMzCE2Crw5kYJ9ek89yrB56xSLYXsoP4xJF2l86G+VezKAY0P
X8gB1/NxMe8rcKwab01qoLnFBZxgbatBOsCmqpSVXCYgTga4isQIV4uYQNVC
suwaE8d54ISOVZL5LQZI4ehfU+jHEvj421XcCSROSF1ik/InqmLAnYYoDRZd
ApA0jPZ2tBv4eJKOL9sNpwKQo924UrI71MC3mqNCVjRDkUn3RygWLbmBH/BJ
r9kVRSKvKC4mEvHjn/fZxBPtoPwI5Dslm6ND+9PATbIWNL1Zw5DRH3wiv0U3
4fcVdWxSmNxjpM4ZJ753HL9APTldR7UaQp4gneHJlxbEz1T987X0p4cxDSHI
9Ddnd3W6d0G8WV6dhxb6CTKXzi6mapQVxKNK7h2wLYUgsyHn+512Z4H/fH6v
TgYXhcRcfFwrcY0fuMst/41Fgrwq1b1S3X0BLZA/XfF01feyD1U4M5ZeWzEn
4KuacbbU0e+q5mE/e8KOrIFn/niG3WfJqKpo9ssYlXcAHgx39KCjDKlKjmgt
SN+yAm6mcoOEMSYSGZit/0h+6Q7w2OfbQzPIdOTMZbKgciVL4D9XYwc0Xxcj
+7lbLeNi8P6YTjCbOLIUSVAYl+7obgq8c1zoFvurUuRQ2wrfq1kk8LSSl53l
WrXI+XbceuCBJvDlpRl37hks8hnDxesL9gLAPdb71tK6q5DKPp2SBK94gVum
kps86qlDupQ/YGD4KQnq2fEh6svBCyySD1ZvEvzhEvAwiZxz46mVyFuHc2p3
9OWA26SY9fKS1yDtXhawXH+pBHywfPh7iF41MuJgl0paThW48W6cuwBvPXKq
uahInPk2cKkHb2YpWr5V1YfXvR7ChII8px8TLdzh+lGVfZEoLUvvDfAPr50q
f2O+VRF9vxMY4foauK/srsmmZ2+VnbXOA77SFOA7LG/zPSirqwaZ1xlKvZKB
i28QE0cPViPXLjEMx/YlAb+T25MxVtmHVOBfvZPYHw/8s9ntX6TR08j8zG8h
IgIvgFcezCicWZ1Dbumqm3wpfIjPMy/3193JOWQJuQSqhS8EuI2wTr9k9Aoy
IPicd1B4MPAe8sc71A2/kH7tr7ujKh3x85BnaGNXtYz8adcRdfWyIXAy0qqN
B/ZryKOpugvaDrqgnoU/oHulF38jyXjYzfYPbYBj/8zlJ79eQU4V7OgqrgXi
688MaWY3zSPv/r4/Ms5sDfxTvdzvSJE/SM1bJeGX/QKAP++5o3nu+yqyPDVR
UggVBbxVIVOSrpWuGttUwXGmuRzkycp7EVPaw1g9HdIxI/ThC/DdPqJTUxF0
1fdVWjiDKPD+E1MybB1PUn2laNaOiLkHeF+aa8gMxXKVHd/A1nTjZ3wdMJcH
R0S3kVfY7ov/jvgKfOl+Bb1QLwmqYNHpIsavGPha5o74zPYZ1PX9e9t6W63A
9wgKAyg+MaLOpOdZdljVAL/rH3n6ohUXKprr3jOMRh3wqpSgZpluNtT23Sfp
k9mJwMP/9O6Ww3lQ5oNTos9D3wEfGD8jIvKbHZVVwbPqFWMBnKaNxn02nxu1
w9GnmBYUDOppP4fubzDkRqUkkUV5C74GfttVMqohggdVVzHExrb1Hrh7gP0D
QyJ2VOMf3Qu3F3OBq7hu7Dx7x416PQx3OGKvAn4rQ8GPxJQTJWxlfKp85i1w
k8m0MK5AueqK6g1Vfqd5kGfooLqZ1HvF6o/1c6+JDU6h/rnS2bFhFTW5aqeg
j+Wz2YTAJdlS+h9OSVdLUPYeGOcTAD+dpVLOxnih+nz/x8Yvw4fg/I6u2E8F
3cwobge+ZqJ4fPy8bPy0MkoCdS3t1bgJbAPE36BS94s0UUR9y1f9kLu5B5xr
55ycto8iyhkxKYsWHQZeOjm1yWCngUqoYCtVllgC3lBGb8hho4Gy5A31u0A4
jZ8r+ZQb559oot6sM9IpZeH7/qaNuKw6TR1FdCUt+vBnFfAn67OD3AOaqLMu
aoToqQ+gnh/06SpsgjVR0d5jf5ooe4Dz6NePChFqoj71zraEXR4G/iBF/eWr
y1qoFipqu7dMP4GvV3lKTP9UR3Go/wyavfMVuNkY74FsizpKJPVccpQRPn7P
s0E2+qFTtbqcPrvc6XOgnnlo3udTCW7VsouxTCxXJIArl94ok9J2qtbTOAzj
DxEHPvO/BUF5xbqaWJFHw/exGHAyHiFZOgvtaq4/B0UsL0SAF/G+GLJi10Et
fpaszBvGn88pa7QnZmiFKuMju3CD9wxwNjuUGVe3M8o0ruFgLVkQuOFkm9Vh
vweqk5sxxyGYB/grwe0UkweeqAWy+onwW0TApya9Nr4PBKLYHu1zqLaeBb5Y
r9ij1xiAgkhgXUHWJMChZb08CpQvKi/DVVGKrAX0MSzz0HdXIhBFXDA4GWX4
A9TTu4kszOhHAMo2QkJq+sURcJq6b0omdwJQocv6uzYD5NX/XG/xNequQRAq
K1WC3a2LAfjIqrfVpefeKIzxtW07S1rgwVp+Mq/Qwag3oq9/O3hzArc7bVjv
XPymmlAgP+NOkBLIn4ZMJPhtXEb1qCuhv901c+AXO7LGGJPeVBOppo1zvzED
jqhD9+1sP68me59FuvbqDnDfkvUHzAku1SwP/O8yktwA/oZWYv+U5X0Uds2Y
/dVlU+D6Y2Onbt2MRiHnmySTCHSAq234ylzyTENZBA1aUNDcBq7Z2jU+zpSF
qrhDYYz5AAHfCZn86m6ahWoM8pg5Y6WI3yfx6wUxfEUo+od/BnQV8N562Pek
hbcQdfk1qfmzMS7gxQMXOyRF3qMyTcR1BMZYgZ9f7vB1/VCIyqyq/VFzCl//
s6Zy/R/YilEsThk0yVtw4PfLUwRbjHNQzxjlPVYY+YGvCYZv2Sjko/T34b/C
1jDAI8Vq5zbD3qMaJZfCPTnkgJfrGcnfzi9GSWUfiWeGqQIX3W+P7AzpqhY8
jFHInPHA14Ff/kF649dqbew1JnGLp8C35b5VLNt2VcOZiVB5V6KBf1/vfVpT
21adHpXywn8xBviZ8vlKj+riavIWnjTrqTB8X0qKTdgvPUcdfcXSEfQ/Ak5L
mSoI9TeiXGRLiaQPIoHT03vzvD/sRDm/5O+Sm3ICHm8fff4VQQ9KRir1ov7V
h8DFap3G8+4Oo/KEcMmZ7j7AvdaE3lJ1DaM6bB/676GMgYc+tM15dHEUlT55
/e7FxxbAy35Ue/zqHUQVuJ7yfD/JB3zLymUTuziK8nhTShh4ShbUM442TEM5
fgKVadT1A5lqCvycyyo2/e4I6hyvWFOHvx1w51p3mk+F/Sj1vtoMbm4D4D8d
F2LUykZR0IWfStYc7sAfs9Ni56qHUB8YE+wYXMyBl2o1Y6GS3eqH5LzcmHuZ
IM96ReKHFqYENZXLXwlWr1cDT7Y9zBrP3a12ZeW+lyxbBfyH7LppQ8hqtWqy
tGVpewXwCfqbaeK9U9VCuKzUiV9lwNfoTZ2cLpejpi79/DVT9hE49VH7kfb3
eZSmduMXr5RS4AkXTrVW5G+hCNy8Hu1tFOP3rapV3GHXHopucit9RSweuIaq
84j5OBk6amIn6tLT98Blmcvi/G8SoM9Nfizp+xAEPGDUtR2+R4F2uvHjM1NE
HHCuN2qTYSvEaI9A5KHXtCvw9d6k67AAMrSmTtBvRrH7oJ4PXtaWf1WlQBtz
apkuMMQBz9puWGWEkaLbH/QxW/wMBc5We+ulThQJ2s+ZK9eXJhV4VYdOy/YB
MdpGpgdnuRsF/AqyJzJ4lhjtt04Xy6/1FriGXxMHqQF/TeklKL7K8CvIc6N/
Ug+nd6mG+LLWI9qSWeDvChLmQk35ayh6pmOKBmaA55t8aJpw4Ky585USykid
Bu5xWDvWHEBbw7P4bHSe/gdwPmPquvo3X1GuDiu3+VBTwLO3YpRVuBnQcXPn
Wn+qfQNuAol8jSblQfendKAck/Bu89HNjkmdDy2W/P38jBo+/55fkwJNg2Lo
YabHOSWKvcAFqdUqJSXF0dxCTOlvQtqAb06JQh1FougGSrveesEM/PnxTXO4
QQm002TiirYw3pePgjGFjZJojkH65fipXFDPoFLROEYPCfSf7xtc3IE5wPkT
p4QsJ8TRzkm86W2nm4CPti9dPn1THF0Xe7UoZKQM+Gkf8U6bFTH0gjbDmmXo
J+DTR7U5AVViaGF6kgKYfhX+Pi4jsLA5zZpxjXOaEecP8d8t8y/vKg3q1rzY
c8yco2dA//PxkGfSixuaNaOef4qJLOmB1zkFn/8YplRTKHC2zekeHfAKSh81
r2hkzZVJ/TY2YxrgBG3NIiQ3Gqpr3ojCXztQAf9gf1eLxQCJznsa/UuDmxy4
dVczn8ILJfSn5XtFFo+Jge+WC30Uc9VFf71OWKXhQgK8EmsWMV+ij8ZuDt8u
kdsAz6VgpUX5Nu82WvOFDtFl7+/A/f0FDhapDNBYjEi5NCl+3pJTKB/vrBmh
lSNiM1rkeoCn4YSX76eZof2pL7KmRzSCegZsc/OOaxmhCylqrJa8ZoDXcJa6
E3kYokNZhbd1ub4Bn18g0TNg0EfnnVeaLU1ZwO9VgaQH+pPGaMHOvhy9gnXg
pKNGhc97DNAl7nqlDFabwEP+95056+Jdg3kw9XnztQCoA8WzzyL3SwJqSuUM
85keo4B/HmCe2kn0rtm7l3hRyh8JPHTQuYmlz6Wm952+rRQxAngAj0XfntGd
moxTLSTNF2D4Pi4KH+yjLtakZ6yatc9JAh9GOiMpeC3Qdt+tLwtbSgBPHdXg
4zdwRktWfNdoUhMFzu8U7Jlb44seEV0/I6okAtz3iqEk5Y0AtOboWGtMNw9w
jtPLXUF7AeiLIm/S26+zAPeoE4kdCwpBN4Rjw2dL8HPIekQ/Uyobip6rbvjK
zLwD+pjpQNe0rRuKpiW+5hyKmgf1/HG2T8576xH6dmqKNGEMZc0/H/W8tEWi
EoRmg7/0L3GkBd6XoaBfnheM1hZ7a3vtMjPwwQLXODfBYDS1qbVQdPA54AFT
97YSrR+heyNnMW+I+IHr2j18u8WbUfOrkZi3sloT5C+3V69x2j675nfcUPPe
WSs0Pk+P+lc3MmpCmVIUWLQtgQcP2acUe6bUJCR4mMRAFsCfVJXNJ1rH1HD9
MpZxnDADPjkk62trdxv9euro59YS/hztyYkStYZINDWBUQrPTyXgbxVUlt1o
X6DpPxez3hrQA97OVP/YWC8NLW4UFRv0Tgt47biIOK1ZLtphPrlMbhD/XKrs
C+64jHdoaxdLjCoxfk7+BHsOCc4Xoqv8en6U8+DntmBWrcZoJAftnEV0a/Az
ET7/fYXe6aV8tFZMGrXbJ3pQT+5YId4O63z0RA2l22NDMeCRrz+RDoe+R+tU
eLjP8CGBi/JdzNNNzEM/oJfjdGyTBf5EDW3TPZ6LPvhxN0NKSh74BCU5ba5h
EXqC8vynZ+nq+HkQzBd+rtxZI3rNxczN8yHIc3pXnMLl3JcaQecYalWqJ8B9
XGouukV01hxU1UhP7j4GfmH7833L9aaahzsTI1meEfh9uCReo0BTUbMD2/R1
iX4E/ECZjWRM7FUNYVoF6wAnPt4jO+zJr6VstH17d3m8QQB+T/JL99Qr16Hh
TQUo/ml/4C7BzPaSqDb0rUajdg8aL+BCOUo8YjJf0MGPvQWVPnsA9/siGxjd
242mXt2acZi0we+TW4gF8q5+dI5vblOqBX5uPZoMHmIIvqLp7AIuXKa8jj9f
/WDNhK4PfV2xruXZMgzU84xNgIGnaz/az8oxpO6rOXDMeMOveZ0e9JBzy/py
ig7wnoLyjELePvSN/B7qXA1H4B96K8lJh7rQ8KnkgRkjI+DjG9sjhwP9aOPg
G893a92AB8JY96RJ1mqMutyNbwe8BXm++OA5LLm4WcNp+DrJFlsCPJykOo1U
eq2m0d3n3CUyvM8gylQ/BP2qCVAi9yUiKQbOcJeMU2ZoskZ1t1j3yKsQ+BXF
bb/HTPU1rcydqXXO74GfEWLNmsnrQW9/FlleJc0BLlwOi4nnnEdDGHTINHEe
8AHiXdM58t9oz1cT+1PqscAvRwvviXivofVTDHuLfr7E31NcH5IucRNNciuj
Q4g2DrjpMFzy6Pk2ui5d1yWUCD9v1iHvPZ9F7aAJ9cl/THY7AccIK+0pF+2g
NfSH9C5+NAH1rOo1psAW7qNTor4T5t0KBJ5Yyi2DEdhE52uX2bH9CgEuoUsR
x/V9F51AdnVIheUZcP9qhXHjgXW0Wul398ej0cBVDFouFg3tofmgJKt7ya+A
e7Zay+0/ZMHyshoIXSdqBXn2MynHPrdix6JDRDjv7gwCZ5YtdOevZ8HWn74a
dooO729t1YR/RzNgCTnztQqb+4Gv1JuPHgkQY81VenSLD4eBZ4vUBCrQf6q5
IvWOp0a6Eb/HimPNmr6toCVRRBG5p3qA/1b7pvy8ggIz7lDTts2A951075G9
u3SYFKu1wpJH+HMezDG8a3/FjGl//mXXGFUPXDMnyelyIBvG1n8pecahAvgN
WD7BDwIOzBtnwcPv8fn47zQ63hdJSE7M0g0TU2P+ROBtT+69DLblxDwh4vaB
GoJAPVldwtmtxjgwQi5/JNM70oD73hmk6ltgx1QWYhifmxQAF3AjJqBYOI9J
/Hg3rf/pB+CVlnTW4hfOYwIu/tj2sC0DbpjpzxGwxoXRujc0ZXVUDzy4Xcs9
kB/Ccpmv2lqv/wJ5PvQivcxEeRXrdIGuUMXoALi8VY+r2iMI68o+0XQF2gdO
VjfnN94pjX2gpoMaECPE/PNF1QMsw5ogVuUXIfUz6mUQL/JOBEHlfwbrixWl
qI5Yw987K6anz97SY8IZ2O7CX+FdLvC+xvR7Mcy1/I71vYV14JQPJ8g6kZIY
tS6nwisZY8DJq2awtqooDEdvX7AC9wzwuyLs4UTf5TCkXbfdU3KngJvAiB50
sslg7NSOaoda6oCftrgzngu/isGKfOCm76sBrn7xaXfokjyG7orsLlF4Fahn
fMlzXp+LMpiX0SZGaFMc8CKjaPiH2asYEwZE3QzXCHBVQV8VAmYMJi4eo9l7
+An/Hty0P/Qek8M0tMmVfpb4Dnzhwa+gUj5ZTBkvReSWTC/w7ce95bKzd7Ci
v5rkHnDwgvpfffGx2WHMHFuSSUhoEncG+M6CtCbC2wL74UleNIMaH/AihUkT
0xoDbEzHgGrjEiNwMrEETRpDDazbjuKbV+aswDMaimRjbFDY0Of0Mfe4zwH/
vYusUdQRxQy7ZVtMHjIBh4gSCmd+q2LieuWuL5MzA2+75dWjaKWPER4Pm+N4
TA/85Rd1pmoaI8ydmzVIN8Fd/P818G9KgZ8tMc2B4/yT3cQgXi4xwO9NmjlG
jdX4iGVuFf//1F70RL2KFSZ2C/1M4wq+79cSozpYaa0xI170sjp3O/DfJ7Zn
9xzWLDFDhJcg7vQV4AWSDB3XtSwx768++6T0agn43mA/iUixBQZynNQWSCXA
/nOdG99p3QQtMLywOCM/hk0Qv8vgIPOL3gLD9FnSiVmDCMT/bmd3XOyJwOZL
3wwVvYgCz/VnXd2KrC0UKyXIeM96TxY4zaMWu3vGj7B/JitvFdUrAk9tb9R4
fOCD3frBrcc3DAGvsM0hEI1wxap2JfG0IvDn2BwlIX88N8c6BXZfktPFAK9b
E9mFpq9j6AOzOhW+IIB71wu0GO44YbjzeQxZJPF5XkCGSa32PsQMuMjqZX4Q
AO7CocCQahOA6WzoZJCZEAYubYC01OQIxFDS2a/zdOLn7bP+RhZzZRhmZdff
0TwHP1cvUflnoliDMQODdOOMyfh9xfOx4EpXfSjGQ1PRxtFoHtRZS4zYaI8x
HNM4HbFpnkkH6sxX57pMtRiE8f4QN73WxAicamx7sDIoDDNrRAtLGeYGzpLo
fJYbF4i5elC9rDrNAXzRN3TUhvcRJvybDq2mzyXgt95scCcVZmLfzM/c3ODV
A/lfarVzvZmdg83JIoikbLQCjpmYqSAhzsJyKkYdXdu2BO4cthueIvQWWzvV
oic3YoG/dxrEMbULCVjSZL473I7mwCMyTq9YXQ3F7pS2SNE8MsX3l27o3jKt
IQZR/3BhoM4QeBh3HKo9JxJzKPyhnqsa71iHwvOXaF9gIk77xskd6QDPfJlq
sVr+BgNrP2AlnJQHzvf5k2v7zXQM7M/2VTXMNeA6563dBrQyMT2qL10WBkXx
74Uz6JmJ/XSMWu1pwdcXeIAbNhTgYn68w4SabtBZ1HOCesoG9I+Hb6Vh8k11
S6V/8AF/5lE9cPAmC+P2qTKWwUgO368B4tt22W8xBzBxVsZXksDJuUa5Q3Uy
MUdh6a+8bG4At3djbOkzT8eEvBvEXUKjgffdfXiK07EFq7NqedPHxAPkWTtS
qdXl2IFt3vFGCBuH4vdkeNvn+Y4WbCMRVcmDJyHAnxjsxrAv1WM1/xz+krwb
DNzBpCVdy6UCWxtHHD+0EghcP7LyPJl6NrbPeOktEhEAPF5W5VpdwDWMG7YX
oxvrAzxUbDoiM/AdxthHRobQ2BN4v8r1JIO0csyE6CW6KlN8/sYeX5bXLGox
WNzk5gUnR+B7sJCJnN4GTMW8ji8HrzHwgS3USJ5REybavc2ctPo28O9fAs9e
m2vAcJj+UG5gkgBuvlNcKbzeitnLa1my3xQE9ew9FT2gqNqIQTnyJFWs3wQu
nfWC27evBSNLk7Xg7WkMfMW7JUCdrAHT8/RP1ZEo3nXDDrWTdZsxXabnOVy4
7wJf/7L5zn2oAdPk6PFFswPv4ZqmBxHIWaztQ4bl4peJIM9CrtO2u2cXsL2U
xJuzpzOBd25q5zImzmIdrA1N+WQygF+/TWq6vTSFNRF/4GvGng5cMVH06ruV
IeyzP4NOHQVv8fcl5MiyVr8Dm7y/dk5y9zXwaV1pXPBCPFbq3I3SUcFXwCVw
bSuEEh2YvETDFAXOFOCqI+Ix9/J6MSJLdD9pjB8BL3kfV6M8M465R/7G6/RM
LN5ZSaCfBFOY5oyOvevPw4C/UuQSKNz9jgkOnvwWLu8EnKJQNp0+4QeGguvX
lksSfs+gmiNu5odOYVYj3r86cFID9aSJvDb20OkHRmqUkZM84QH+nh6tKIj1
fMcUoS2Q21hP4PwUjMqHXN8xLtdGFIvZA4Dn+t1yRSdNYTwcRAWDw4OAX2fu
q7n+fhrTSpLxMVP4CfD6OnnRU0wkODeidR/oaxnIUwEKUehJJ8exv7XXbBpr
BO5omywQ6ECCs7xVaJlwDu/1A4WOJpcJcSpvb1rcomgAvnIKhqPR28Z+7iE9
315YBzyAY+JiMPsiNniKUJlTBAc8m1v4Stt+M1am7l2NSHwV8AVIRV5pfAyD
jedZxjrjPZ1kTllK7TdGr6zTyMK/CD9XxZHX0ClbGB0vo+WEuffACUSqqhq/
HWE4XIRhxIrZwPWSwz8UjB9gKkTIrOIHEoBTItV/lTMTQVwztz6bmj8GLjyv
MVZCQQDtNTdyGfTj7xGzG8cfKy5C6AfsPpWRTCTwrNrqC6oxBFC6zDNNoZ0E
/Hvz907zxswRZlpUmf89YSpw80HFXPblQ8z1hLBlCsW3wH1J4qcJmE5BWIIn
39QIc4GnnirvvyXAg0NHZlBSc/bj+5WR6jFwgx8Xu/4xrmN1Cr8/f3YGhz3k
welm/prTksc7K0HDsxIvTtzLgvjglyqTwD0pvEpelzLh2LxFFGyEvgG/8na2
mjiCEieUJ15Tfn0UeKQ1e9iwxR9sKA32TAP5EPBbKUptIYSHGCVBS4vySLzz
0Gm9CN+nhBZU1bocF5uAMxCF0BtQMEG3yYlfqsV1AWckehFn9ooJuuoi8nhS
Hz+38suzch8q2aHWn5rr0r6V+PuuSV/BQX0OKji1kXP/+TPgPUzxWFokOyQb
+OR+E9wb1POn/pMbeiUckNV4dq6GSjHwNdr4BxrhLNAbEr7zASr5wG2XiSJL
os9Dl2JWQt+h6oH3XBm0aF1mggxUiDZ0mz8C3ykzE6nm5oC2M+Vbyjda8N8/
Aatud3NkcXSev4c6ylZBnuOuX2n8VORxPzeERrToj4CXKbNQsq7I4qgcSLtz
pg7w/3fcVg6ke43CXVK5LUsK28d/z2vWfopQlMTFxndLjrLt4utPLhq1VS6I
YzzoPGucugU8MZBJrJuBDDdclyspuriN/45SLKOrqKaHmFAPYs/3LwC3DmVi
crrEDcmQPxQXIsR7ZodDCQuFGJRaF+ln7Yn3aBIH2WybKxArEU5doBY/b13u
P2z1L0hDSz+IViMudQK3100OpkRLQa/ZP1xRvIbfJwRNnH27u3Doy+Kg/GWa
QlDPJ5KXUgtmpSE1g3RuLu8G4PrLqhevkUlDCiJvxCi8+4DfO5OXJ8UnBWkc
mkg5pH7Fvwc9a7q7X0hCX5MvUUcEjQOPObL5wiUvCZF1qdvsj/YDv1TBanSl
0RCnOad/yFBHCx0c/fezJDN/LxUrT2iG27d+EiRZzwrt//OQ8/msSCNcX7PD
cnwzC4hnjXWccZW8heO+bZeqY8UMHZ54lc/ljE11Tdw6vfFVqqyz0NGJa/sN
ZYsvK+K6fWcKXBPOQP/yCfxiraBoDsOx/jJ83rmP93neZ+MeR7QQZl148J0e
JfDZ97Fxd8xloaXd2ytit08DT1I3xE12KUJxwTmU8wL4ebioIsx9K1cNaqx2
/RjSiJ/PQVvuhGvMahCZ+Xyh0oc/wEOsfqaSOWhCD4Tf7O4N4feJaGjXtkek
NrQn15qI8U7H/nsuYSZ1bhRKAyI65/9k4dUYqDM3I4vs3Vda0LumNqEE8mUQ
f715Smr0vBpkFLFOcT5kGcR7IeMXdVGaUKg69bnUtG3ghrF3zdq/qUHfxotc
Vr7hPfCSromGgDuu9JMpKWuHEPT95PzWy/NMwXYPcRWmqY4NLpLQ0ImPPjRd
oQh1x8HZuPLOvr8CTZ74auB8eGGuM25ByvTSZpwEtHDiw1SEj3SV7XDfdmgp
L0uIQ+snLnn2LNmfcHNc6yUuh+teEtDeib/hLb4tb6qIw+XlZkBPLoC+FH07
1+9wjhyynJ+r83AXAH5qsCDOuVsDUtMto8nT5QdzYn8zXLPEzRByELB1Utk7
B+aNQqqy5AKNFdRpwePzoPEstHviJs4N33kMrKHXiW7Uw4FU0PaJd4h8TfZm
s4W+P+elv35lB7N54hK0GkxMybbQQrcGgedRJfafb704uv1M0hYaeeoRw9e+
Ddz+gHY1VM0G+j7iRhY2TILbOnHoTmgDTMUa4kHeyaRaOY3793clCjRSBQLv
QiYvlxWnsXTAeRJyd96V20KvI0Jr/BAsuH/nZyo89Vj+E4NLX6r0vEGrAE0d
ntyjgn0G9K04XAnujkAchzoUceLxAg6bIlKxOGufIz6aJVVo8MR/BBf9rxRP
cF3BNYJRiiqQ+Mn5zjIs2Q+4wnBdKUsvlC/fhEL/PZeem3DyvUDc0pVOfS5F
Zejjie8SdFttPrHHiZXrOVnirkIrJ95L6qkQoC+HU7IlXzealAN9/FQi2Exr
Zwklovt/WNthQF8+IFHP0gLcoYrIV98DMEgwbzcpGj3vUXpBCsNR/mulfNDA
v34F5J9mEQ+ErElCXh4O80NlJx5gYuTJ9c4f4pv0kjc7QwI1nLiTS4mWXXgg
FKY4SPTFvgH74cRze2QfUigEQqPXnl7z4mDA/TvnTsgT78y3AdDiWqUjMZwL
V33iM3uf6M/0+kPUDtXzxvF8uPoTb4vov/m7yA+K/OQrEUAkhGs+8UoX/7HG
e4HQZ06G0Ifz4rh/dbM56hNx6czG0dEMWc5/N4bMN0/65bW4tSz6Hjd1ffLO
+cK7UPTasTM/2kA8FcvB2caGBQt8vQPRnsTf/uDM2AvLxA1d3DJNfmUFrWwf
+x+yo4D6p29wWTdRZqNnLaHivWMvuCuZ2aWegFt5ccq9EGEFkZ/MgxsFkX+a
ehAOzR33TdtZF8o7yfMppuzu2lM73NlBcr/qc7dBfwu6LAM4OF2gTDPuYWyA
LvTzxCvo9WbHRx5BIxVNDxkdtCGnE/dTP7UjphILXY6tcVb7fAPqO/m7X89w
LVjNPIeciN+y9IXDIOUTd7/dY78mngB92/0NW4q4CDGeODxXEKnR/RxaVYnn
iMwhxKmfeERYgE2/VQL06CWWvumqEI7qxKO9ldbvP46HcFRuQ9lEMJzYie/H
paFPxTyHIonWH+y3QziDE6fYX2660BEHPbK2Kr42KYfzPPGkxOSj8ZsJkPXg
6dp7eko42hOffXgbKr9Tj+O9FlzNqu0GIT6e7IcsoVXb/EYcne6pqCdF/tBG
6kmdm/oNwnPqcfWtpxYtfPyg9uJjv5BWl/JnH4vzGI2mXev0gZJaT+p/Q5wn
BFeOq1kb6hjh8ocejZ3kf5P0FMHvQlyZOePmEpsrtLt07EKJG7kGE+m4M9fR
ZDZoFwi7c+zPGZkG1k89xZ2bjgn2UXCG9k7yN+F8rD414g1tki6YHHHag/vS
qfGkQd/pBTR33rrtd6o15Hhw7Fn1aD//jAwo/XXY6I/vlpDWyflD/eaCnh+y
oN+XWoMD6HWgla1jD/PeM+miy4fSSseFWUyVoM7VYxcV+OblzJcLZc1E47QK
CCCtjWNfun7Xlfx+HrQatzaGbJXFya0fO7mU4oC5di6kNLv9lURKHXfpJH6C
4712OE0OFH3W5DqCQBcnenIvVOUqOXdPZ0PhKtalXx31cesnPj98FUMwngux
UPGrk/Oa40pPznfKUufJshzEeSzxNH7jj4LYxw7+Opbm+VKi1giO9uIT+wbp
eMhY6dizTVPnSD2HcL6wCz4J3YkQ3btjRxeKVItEf8HVH7y3iUx6AhF9Ovzr
klCCqJ/+VxxGkWa93vQ59CX/2BEvpq+8n23BxUR1Wg4pREHUPsf50J+WEtC2
/9/r8czWOvZ/52g3nzyX4nNaMo73ODsNiq2dwHCI7mQ/eM/niU3sG0Ctcc6V
/cgQKPGkjzwKOxUExAWQNu753K0vgVDKyskcWjR1yQ2VQsaWJnZuHI4Q+/dj
P8+kaDl7rxry+rFxju6MPbTVc+zmeRtdH+/UQQsmhGQyKGOouebY690m0cV5
WMiCiK7nTywPbq/t2KkU93sT/eogQt97dubkxrid6mPX22dVjAirhsYnw/lf
5Zjh3p6c/6Zv4sPEIhaq9X23UvrKEbd7Mv8+25+oQikqod9cb67rltng2oeO
vQtbnOOpjoN+NdtfZhFxx7m3HDsN79011IU/OKLO6++1mNMh3o6Vv/6SrxwT
Er2Ciwy+irqXUgg9f//rr183zvErFP6De8wj+6csPws6hT2Ot/c5bcxLMI8r
ssu5+to+CyKT3Pzri2dUWqwtZ3Bqb00N7ixnQStfto/nkzzS8CfdJM6p6s3Y
QUcG1LK8d9x3QneGLsd+3K6+K4+TWRpEKnrcd/eNM1XnqlpwHdUIrdHQ19Ch
13H+3UJzAZlJMTjDKGKVVu0UKPZkb59pvmPRolwB0d+7s5vAFgttDR/7YPzz
9/dnmqGXHD7VCirREPTo2NGzu9LjsE7oHOVnXuZqL6gBfuz8rdAlhOMXyMmY
KCn9qgfU0n2cT8AY8ozi+S9QM41Yzq+mASx69NizpBtLvDd7oAueRofp+vdw
iMmTeX66/sqKtgd6si2jsMvpg5s6OPaNBO9OZkQX9Aw+wipG6Y+zYTt5L7iT
nM067ISUHmCUDz1DcebCx57iRPlUHNkJDQyRXbuYHITzPMmTUrhurO3lqdoN
ttUF8s1yKEc756+zvGFXZPxIWhteT1O+9KcBGmr3++tKjvpplROEtfkU1KrG
SlhoZLHwr3Pmtv28akxQ+4s9vVvKAwfZ9Nb8dWGx8T2N+V1ciIEgnTKmBkp8
/PWvt1+reTycuY7rMOzybU+uhPLFZ47zcZdzsyv9hYNVxga5Z5b973tp9a/r
GPAJqAxM4q6a17x/5/gBsvc67rv6DxYMV34PLncriq1buwSa7zuuD5b0neo5
/UqI+UWJD2NfDuTw+WS/VZoWhtD0QVf57ypHiL2G/tgex5/vKKBNxgxDDb6w
mTCXBGgl4HjPiJ5ZeyZJMAU5sFCzkPBFQNe8j/9unEt9swtmCmqjonvpQSUB
cRkee0wyRwxb+SQU8qLHOrYyEMeSduyfC87Fp7dNQLbjD8rmmZ7gSKn3//qV
+1M6mlXjUGt8+iUZtgTc7cfH/k0i2tdmeRTyIrgAf/YiHpewcuzUTfIBiLRR
yKdL80NowUvcC8LjPL15FJx9SZhqH3VL8+V+7YTSoHOH/3mwqhcr1pql9j1n
Xa1gfS+kMJZ78J/3cx+eGldiqh1qWF2SIOqFkN3Uf+NbdWbvX/Q7U7uN6svq
2/kCWTUF/fV8yXmqNhhdLT0fGzFtXg9ENLP11wVVn7P2mlPUPm0nEGyDuiBB
KpO/+Vi13ufOuXmqlj7hl1hhYwf06F3eX88vzTjXK7GF+8IJC+I8aoEoh8eP
6/81/8pY3iwOdqHURp6mEVJI2frrra/OPoHFt+EiU4m36vnqoXucx32UFuzI
Fozph8SWfL1XrD5ClGeP+/jR2Wu1S2YWSk6hYfV3yYd0pY/3xuYa92qS8m9I
7lXD9ND5NIj42fFc/bBaM9H5n/fBp9NKO9wh+cRjryumCgg/twwRQh2vTF7E
4Iral/66sljMb4rcRUjhmWzGI65UHJxs/a/jLLxoFHcXoWvED/hoG3JwmVVr
f/391pW1oK9zkPpEOZ3bbDZOjeX4uQykvWm3WuYhnpHuvF3jEhxtxMbxexNB
XeRzIFj7Gcp3kUidhEYzEZt/30cP4QfsUZdq94RsbY/0Z6Gxebb1/7y2annx
t4JQ7WlSW1nC4Blo7M3hxn/e11w60yHHX9tf93FHVH8auk6B3v7PTwV48jyu
ulCrvVawf2XiO0Rg4b/7n1989ipPdJS99poa/fUY7ikojSRg/+/7kaUYdVGa
qfZefxSpxq1v0MfTtH/7frVa/BrlHnXtcvMvrSyWEcjo7fm/+dstBRl/ISCo
zdtSeJ3/exD6UYP966yTLJSsScO4W+gbuC7+Dmir+XiehR4bLQci+iEHVUrG
L08/QS/9j+f5lZMZp27RMhScOXaJI7cCqnT689d9FZ54PaTegEQ1FPIeoEug
z7Dpv040Wu+44LQNxUVSSTz+GgLlZI0cvzeFuujD321CVp4X9byfv8Hx/pz4
63dJZHmZGTah1AJ5EuZ3pbgJx6m/jpSqbXWPXoVY3E89RVv/z40X/nr0I4We
+0yrkD1zncZT4XpcjvziX3+64zLgO70M3dbggG2t1eCmNn7/9bkfP4szxFG1
F7ZkNIxMVyHp+pIv/7lrnaHJ5ldMrcIFiZRimW3obKZ8239ednB5084TVdv+
O3Y9VX8LItn40PP3vvgN+Qcbw2sTLdz66Jg2IYaBlpH/vKTwqZtblWSt649W
Dyb/daicjWrm795jyBlS7harpZGhLP6WsgrJy8n9+Xv+WY1rhdVCtQx+Qvcb
/ZchfqmEv3NifV+WZu7ahdqi6NXMPNtf0C2J6r/zYNzS/p2Hlq32NYP4Z9uM
BUi1jOXv3iBhfplwqZ+0VqJLFGm6+h3qp/H8+7zxWX+ye0qncVfCnrZ43RmC
Lu4cv8cnFCkCYwW+Qfz+whJf73yBSBWO9+G2+FP5mzpbUOfCNU+HvibI/enx
Hlip6e45DDiAQkjdWby/JUEL8e3H77XIwgMR+n2Ima1HY62mBDeY3/XXReQD
rR1pdiBvJkf7itMNOHOnob/OIY596Zu7Dj3WGe28uv8J9/3x8ZxsPcZoNXYs
Q4O41o9Jkp9xVyKP+xW7X8Z3iWMZCoI0cpSkvuC0ko/nLTi8SKDJXKX2Z7Z9
l7kXkUw4o4z0f34g25ffvalW2yaypaeAoZAZYCik/c+TNZZUvTJUaofWW8lp
1MhlNK9oS/znzYIttn3PlWrb2WR+owjIZH5XTRn+56fDEhcJjxRrycRErTdu
k8gkzCaF/ecLZRFEfdxXa09h2OpzbYhkbsk65v/n2vwWQ23e6FqpTflufhih
jPsiwef/PHWLRmCeQ6r2FvW3PJGCA8gydu7Hf15J/zLDg0e4lo3kfbZk2TYk
mhK/+rcOTOHpmqy8tR/+zxhOTFmx9rtdiETvT5D4H8e7ilP0efZP+bH6R37B
UztFUyNIe8BZgWVxyv99u62Xsyf+fGy3SRtSv+9c1+wjE/943+zmtXe9Xt20
S2yGlG+SF/wVc7Sf2+W8mXOKp3mn3f9iaLmX8YH1dPUDu/T0/e+kynbv45wE
SQ/N901j/894aJfROc1uRcCFfTLyvyDtRmmODzNMr+/jON6xVrH6zj7NXRBx
E9m5Ed8tr+7jYTqUI7zrzj5TFog5S5fYtN4R/rJPTvzWjh/+T/Y9jH4A6Ucs
TbNY6ha6n1e22SHlrKC9T66E1T+g+A2HiIVbrUP2X9CbmXMkX9g+4L5yKkj8
0yL/6arlQftn/DvN+HmZkH1vyOqVIPGUosicAJeA/bZLTU2ZpgnaK+TrfQOJ
e9r/nHt4ivd+vkd8U945Cdi/XXDSAWRvUcgd/w/pbvvNTiS6Ls7htWdas7QR
3A586WdgFua4PyQuin/bN0772ZnGW0Diy41zr3OGWu6fcf+9xnY7Nvvy4xnX
weXwlWnCj+wN9z/hvtP0NpHJ/tRRobfgdkiAreA7Xs399m/i1fjfMNrznnsA
ztf3T+91rDCW2z/5XqOj8u3Pdl6O4eDyPL1NrUB2Cuv+spLdN54Hv7Fr460H
h0+QzaR43dZ3+2YWdccpCN6z43kFyRf86Zteany7tq+47xa/3u6ddsnHIeXz
/NqHr3urHu5b5LrBxiTs9D71eki8BL79tuir1qd9mxJOzxLad3ef+6vnkHg/
L+FaWvdn3w3Bc93uG5/sOz7hGFjc/vmNjfd2MO43ygr7P0n1xb7vcSvA4g/m
P1Z8fpFpf4+FTdXiH2/37c+aCRYHAMvsQfU=
     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxl3Hc8l1/8/3ERkRIq7WEUSZKyV6GMpKSJSoqWzBZSZoVkFKISWmiY2aMo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     "]]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.544250885490486*^9, 3.544251014765848*^9, {3.544251136616836*^9, 
   3.544251161696109*^9}, {3.5442512313358*^9, 3.544251255023039*^9}, 
   3.544251415036179*^9, {3.544251486168771*^9, 3.544251525447385*^9}, 
   3.544252167712742*^9, 3.5442521977887163`*^9, 3.5442523738383827`*^9, 
   3.544252968072139*^9, {3.544253020419325*^9, 3.544253049139974*^9}, 
   3.544254059670431*^9, 3.544254317346848*^9, 3.544254536319419*^9, 
   3.5442546392024717`*^9, {3.544254705739455*^9, 3.544254725164307*^9}, 
   3.544254994619301*^9, 3.544255237978533*^9, 3.544255375378627*^9, 
   3.544260670403819*^9, 3.544261146516342*^9, 3.544261180947994*^9, {
   3.544261708646901*^9, 3.54426172617603*^9}, {3.544262797713924*^9, 
   3.544262823373682*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"hplt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544250892870241*^9, 3.5442508937173033`*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJyF3GlYTe/7x/2SSGiSSlGKkkqlSfNOkhBJIVOKIhWaVUqDMoQKTUgqIhpo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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3HnYDVTXBnDPoDJnSEjIPIWMaUQipYlIkgyVUohSkSaVBhpQSEiaBw00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         
         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0k1IE3AYB+C/09VmrjZLMEhI0Npys00361BQYJA3C4WCukiCQX7dFAwK
8qbQQKFuBQYFdStQKNBbQUFC3QwMEvJmkKCQ4DM6PNf39341D4xeH6kKIZTJ
R0Lo5gb3eMAcL3nPV36xQ111CCcpcpVbjPGIJ7xmmW/85h/JmhBaOM85uihR
pJMOCuQ5Szs5srRxhgxpTnOKVlLsqb/Jd1Z4w1OmGec2PZRoJsGuOTZY5QOv
mOchw9zkCgWaiLNtWT/5whIvKHOfu/RzmRzHifLHbn/wiXc8Z5ZJBrnGRTI0
ULmHqKDFYLQQ5QAHiRGnlkPUkeAwR0iSop6jHCPNBXq5wwQzPOMtH1ljq5In
vJEsl+hjiCkes8Ain1nnLzHNnoj8/5996Q47dw==
       "]]}},
    VertexNormals->CompressedData["
1:eJxk13c8l9//P3CrrIxIGcmepcyyyiw0ZGYkmUmhbJLsVYlSCRkhlBnxmtd5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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJyF3GlYTe/7x/2SSGiSSlGKkkqlSfNOkhBJIVOKIhWaVUqDMoQKTUgqIhpo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     "]]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.544250894360345*^9, 3.5442510169010973`*^9, {3.544251137969285*^9, 
   3.544251162754264*^9}, 3.544251232419545*^9, 3.5442514158330936`*^9, 
   3.544252168813089*^9, 3.54425237410351*^9, 3.5442529696297407`*^9, {
   3.544253020790812*^9, 3.544253049403585*^9}, 3.544254061557665*^9, 
   3.544254317609988*^9, 3.544254536583486*^9, 3.54425463939837*^9, {
   3.544254706052606*^9, 3.5442547259897623`*^9}, 3.544254994883862*^9, 
   3.544255238610774*^9, 3.5442553765365763`*^9, 3.5442606710177794`*^9, 
   3.544261146548931*^9, 3.544261182260668*^9, {3.5442627989880238`*^9, 
   3.5442628251752033`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"hdivzplt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544255382144828*^9, 3.5442553829921017`*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxl3Hdczl/cx/G0JDshmyhKhAZpR0pRiWwhpQiVdoqM7KwGZcuISntqIQ0z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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3HfYFuIXB/De9zVC0UAUkZJKSiihJaISaRkpNIW0KGlIKRpIKTMqM6NS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         
         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0ik0BFAUBuA3Yzf2JeIoiGiIaAgCmqXhHM5BRENEQ0QzIpoR0RDREO3L
2H1zhC/ccu+7/33VQ+PdY5EQwiJl0RBqaaaTASaZZ5U4CU65JkksLYRKGmij
lxFmWGKDXY644I5oeggRAr/qH7754pMP3knyxisvPPPEIw/cc8kxe2yyzCyj
9NFOI1Xkpfp68w1nHLDNGgtMMUgXLdRRTpQ7IV1wxC4bLDHDCL200UAlMZJW
vOaUBHFWmWeSATpppjaVP6lbGBfS/uMJGWSSRTY55BIjj3wKKKSIYkoopYYm
OuhngjlW2GKfE654S/U1vIJ6WulhmGkWWWeHQ865JRL9/zd/SNdHBw==
       "]]}},
    VertexNormals->CompressedData["
1:eJxk13c81t//P3AjIyMyskPZo4wQcdkZEWWHzGSPomVk7xUps4xsShnXfl2y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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxl3Hdczl/cx/G0JDshmyhKhAZpR0pRiWwhpQiVdoqM7KwGZcuISntqIQ0z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     "]]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.5442553839063463`*^9, 3.5442606715766563`*^9, 
  3.5442611465818043`*^9, 3.544261183423279*^9, 3.544262800910062*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"tplt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544250900254099*^9, 3.544250901741186*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJyF3Hd8jXf/x3F71d5UbWKmZoTgMkqIGCE2aZXbLGKP2LNKbKFGREStGqVm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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3HnYDVTXBnDPoDJnSEjIPIWMaUQipYlIkgyVUohSkSaVBhpQSEiaBw00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         
         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0k1IE3AYB+C/09VmrjZLMEhI0Npys00361BQYJA3C4WCukiCQX7dFAwK
8qbQQKFuBQYFdStQKNBbQUFC3QwMEvJmkKCQ4DM6PNf39341D4xeH6kKIZTJ
R0Lo5gb3eMAcL3nPV36xQ111CCcpcpVbjPGIJ7xmmW/85h/JmhBaOM85uihR
pJMOCuQ5Szs5srRxhgxpTnOKVlLsqb/Jd1Z4w1OmGec2PZRoJsGuOTZY5QOv
mOchw9zkCgWaiLNtWT/5whIvKHOfu/RzmRzHifLHbn/wiXc8Z5ZJBrnGRTI0
ULmHqKDFYLQQ5QAHiRGnlkPUkeAwR0iSop6jHCPNBXq5wwQzPOMtH1ljq5In
vJEsl+hjiCkes8Ain1nnLzHNnoj8/5996Q47dw==
       "]]}},
    VertexNormals->CompressedData["
1:eJx8vHk0lm/Uv00RkSFJNFGkKJkyu8/LLPMUMmSMMgtFKmNpVomiwaw0UUqi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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJyF3Hd8jXf/x3F71d5UbWKmZoTgMkqIGCE2aZXbLGKP2LNKbKFGREStGqVm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     "]]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.544250902389866*^9, {3.544251138804072*^9, 3.544251164659958*^9}, 
   3.5442512345928593`*^9, 3.544251416569935*^9, 3.544252169830223*^9, 
   3.5442523744667273`*^9, 3.544252973768124*^9, {3.544253021215787*^9, 
   3.544253049709963*^9}, 3.544254064268363*^9, 3.544254317922491*^9, 
   3.544254536937154*^9, 3.544254639594426*^9, {3.5442547064653788`*^9, 
   3.5442547267062283`*^9}, 3.544254995145302*^9, 3.544255239294875*^9, 
   3.544260672183213*^9, 3.544261146617317*^9, 3.544261184628994*^9, 
   3.5442628040514593`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"splt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544251241052889*^9, 3.54425124118081*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJyF3HdcjX/cx3FJqSgNIpRonfamdRxNlGgKpSgqK6nsUJEZKhllZKayZVan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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3HnYDVTXBnDPoDJnSEjIPIWMaUQipYlIkgyVUohSkSaVBhpQSEiaBw00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         
         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0k1IE3AYB+C/09VmrjZLMEhI0Npys00361BQYJA3C4WCukiCQX7dFAwK
8qbQQKFuBQYFdStQKNBbQUFC3QwMEvJmkKCQ4DM6PNf39341D4xeH6kKIZTJ
R0Lo5gb3eMAcL3nPV36xQ111CCcpcpVbjPGIJ7xmmW/85h/JmhBaOM85uihR
pJMOCuQ5Szs5srRxhgxpTnOKVlLsqb/Jd1Z4w1OmGec2PZRoJsGuOTZY5QOv
mOchw9zkCgWaiLNtWT/5whIvKHOfu/RzmRzHifLHbn/wiXc8Z5ZJBrnGRTI0
ULmHqKDFYLQQ5QAHiRGnlkPUkeAwR0iSop6jHCPNBXq5wwQzPOMtH1ljq5In
vJEsl+hjiCkes8Ain1nnLzHNnoj8/5996Q47dw==
       "]]}},
    VertexNormals->CompressedData["
1:eJxkvHc81t//+G9WyCiyZe+957kum+w9IjOEbJWMQogyQ0YpI0WlVJJ1RAiJ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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJyF3HdcjX/cx3FJqSgNIpRonfamdRxNlGgKpSgqK6nsUJEZKhllZKayZVan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     "]]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.544251241807056*^9, 3.544251418507152*^9, 3.544252173470729*^9, 
   3.544252374733139*^9, 3.544252977080389*^9, {3.544253021589993*^9, 
   3.5442530499752827`*^9}, 3.544254067672799*^9, 3.544254318187825*^9, 
   3.544254537199329*^9, 3.544254639791909*^9, {3.544254706777789*^9, 
   3.544254727477206*^9}, 3.544254995495749*^9, 3.544255239986038*^9, 
   3.54426067273923*^9, 3.54426114664774*^9, 3.544261186638049*^9, 
   3.544262806217388*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"tdivzplt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544252180568473*^9, 3.544252182903781*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxl3Gd0TWnfx/EgSnRGDyEkEi0EiTtait57F2b0XoYx+mhRwqjRu4So0QkR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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3HfYFuIXB/De9zVC0UAUkZJKSiihJaISaRkpNIW0KGlIKRpIKTMqM6NS
GUmlIVFktCNFZKTIKCJ+97mez3P9nj/Odd/3Od/zPed8z/MOXaVcx54te+QX
KlTotoMLFSpIZ9lkxyc7PdnRyUoVyvjDjuKLe753xA/gO0TuockOSnZMsmPd
D/RukqxWssbeB+Io5X6AnNLJDlYjL9mRaubxHQSXxVTSW9Svrv9DvQ+Tfwps
ZfUCXyZZYfWKwJb1Loy/CN8J6lSWexTOSuqUlX8M/irJyierkKy4WqclqwYT
8VNZ1RxfKTVOTFYu2eHJjnDG+6RkxfhO02tVuoa+Z8stqueqtDpGTpajqtxj
7a6wHovKP1z/xeCrm/O4ZCXMVEFONf5qcFlMxE+2j4bJLsBXXv4J6hXBU9pM
NeQEvmKykvgqOk/Wcxm1jtPbIfZxHg1Dz7rJ6iU7U70znDXc68LVcdazk4Z6
qO5dj2Yn07g2nrK4zpdTnX4nqHmis5ycijiy9SqLnwUTdeqr1YAe9e0gMDXt
urx7NbWr462gv1rOCnLLyT9P7cp4T1PrNDzVcNeSG77WZoveLk/WQs8X5XBe
muyyZOe6n+fd3D12eWGO7nFvhLMu3uZ6C/wpuCrBRv4V3ufCnIHvQrl15dfT
Y32an0P3RvqOvFbiLekYc1xspou9W4jXt4v68i7C04g+Dfgv10Nz/bbR8+n6
LKtW8Ddmtfhq0v0knK3ofm2yXsl6m6VpskvE2thLE/6zxc6Brc0XsSv1cqPz
SrrFvRt/5DaTH7vrYJbY5/V8bczW0Pt6uEb4grcTLTo6490ZriPOq+l4lfPq
HF3ibJuTH/guNGkJ2x3mctwt+NvKb8Hf0tnF/Rp6NdbPrclu42tHq6jTNdkN
zlbyW/O14buBL/La5+ymvb11o28bmCbqXwIbuJtoPwhfN/hGtLwKVzN5jc14
jbyb4GKGvma63lwd5F8J19cuOrp3hOnH35eukXOzutepfRWOm9UdqOfOcvvl
7LKRXVyFLzC30zD6viVZD77+/N3524q1g83u4A73ATTqWSjzddEefz981+C4
BaZdDl9P+K5qBue9yUaa/Q7+/mZvX+j/X3t9aDHY3GP1MlA/4XuA/za8fel1
k7yBtOumZj+YG9QeIPce+YPk3WSf94j31kv0eCftbpZ/vzqhxWizRHwITW5X
d5T7KLiI35Wzm7gPxRm93Zfsv2T/Jiuel8nrZ44xMP1xjXHvge8uPPfpb4ie
7uS7Q05vet+dbJizl70Nc3+ALgNxPeA+PNkIexomZyhdBqs1lL8HfB81H7S3
p73vFo+fiQ0KZb4fR3wqTOzmcbPfKX8c3xP8Y/mj9ni4cc7BYqPpPwnmIVoN
gRsvNgrvEL7APJnsKRxPwIz0niQ+FDZ4J9P6KWe8p3iPkTeRdhOcE3O0iPPh
nPwx9BhrB0uSLU62VnyK/UyUd7f3FPgp8uP+iN0N1/fMZK/Sc7r5nqH96/CP
ynks2Suwj7tPh30mZzdxfzbZDPo8of7rsONgn9HDJH1Ml/MEPR+iz7N2MU7f
D+vruWTPw433fgjnq/SbwBe42XyzxGd5T3ZG/AU6TtDTJD1NwPGCOuP1NUX+
7JxdRu/T8GT5puX0/WKyl5LNSfYababxB+ZluMC8Qbf36f0OnV7Qz1vJ3lV/
lryHcUXecrmRs8gsL9tpYJfKnwU/VU+vq/0MHZbABsdiPM/CvMk3k3+J+2Ja
zdXrXP0+L/cZ+dPNtQjmOZwz1XyVLdVnfE+Iz+LjdAjOefJXqxt6vk2Ht73n
sWnyQv/3zDvbPetbzr+AXi/Z9RwaBX4ZbNSYD7ucdq+pO1885vtMj8vkh+4f
2M/nzg9osgh+Nc5s/E3xwK016xraLOGLPhbqe4pac/SxwCxv4liRbKX3CvXW
4J3LvxL/Oj1vTfZrst/41vOvN9u78GvFQ/MPk33E3uaLcxWNQscNyTaqu9Je
V8p9S3yZOqvkfyR3mfh36q5R4y35gf9YrS/ouSvZJ7RawBdab+L/VCz8O+E/
l/+BnPl4V/B9oZ+NuGKH39J1tft29h3fRjWX4wmOzXr+Cn/o8KVZvvTezFbK
C61/oE/cv/cO+5F/K97QLX7Hia+je+HXyvlInS3Jdsj7Ud0tYj/RZKOctebZ
aA879P61/jfy/cS/Si8fw2zD9zktfqZ3Xl6Gb7387+x2tT635PBss7dtdvcJ
zk3qx+9T+wtlfqdaICeLiTpR769k+9TZZ7bv7OtP8c36+yXZbu9f6LNbT78n
+yNntq+9d8mNHf+Nf5/czfJ/4P9bX9Ff/IHcZnk/w0T8n0KZr8Ov6LCfTj+6
/wi7VV+/iocW/+nzKxw7+H7Sx69y/sH1g7wd3j/B78Txe86839jBf3oPzAF5
Gd6CvIzvyLzMfHvht7HQaQ+ti+Rl9AntD8vL+IrmZWbfR/f8vAzndjmxr724
9tAwMNmd/SznL5xF9BX9/SqWp78CsV/ocHh6H5GXuce5n+9vfQXHgXn///4Y
Z7wPysvo8xuev+V9a7btZi1q3uAuhv+3HI7ifBGL783xszJ+lh6MPzBvJ3sx
2TQzhNYl8zK6Fk7nIXmZvZQQKyFeiL84X+ADu4dOZWl1FN5TcO2lc9wP9Y54
RZjorTC+yD/BnEVwxrsUrY92HpVzz/cOvcolO8kZ7xOdJ9nLkbD5OI+xj4bJ
Tk9W3Y5K8R8htxh/gdhB4seIl4eJXs9Qt4J9lIcP7LHsYL7S7llfaVqcTJ8S
ziPtIOJlYErgr+BeQd4hMMe5F/bOalEUZ0l55fEUo3cNc0T+8XYWezon2bli
NcwZ/ko5+zjKuzKdjoY7U/3j8B3CV46/Eq5z5WQ5ThAvmrPXs1g5HLXMXp6O
ofOp8DX5a8JlMRGvmuw0mlbV54XJGunjPH2cpF5N+kats1kFvFXxHCsncusk
q6LWMXJr0z72UZ0eca/mfQ4dKuqtWg72ePi4n+5dQ89n4D9bjdLyy+gl5rnU
bBfBh68Z/2XO68XPom1TnE2SXcyfjce7sfeZOOuaOTt73Ryt46wnpwndAlPK
rivJq4y/Mc3ryjvVu7HcBmasn1Ovslr1+C8xY23YBjStba6m7k1hI34+TFhD
eteXX1W/Vey0CZ5a6pxrh82ctfGcj6s2f0XvC+xySLJbknXP2cd59nUVjWPP
V/LVEb/M+0q4q+0l8G3dr4YPbHP6XSwe2l5Or2z+Rfx1xAJ/jVlDo/bJruVr
xx+4Fjm61/Ou72yZrJV3SzxNcV2Crxn968NerofmcE3Va6z3a+Bb0fdauF58
rfmvx30dzHXeDWHasAv4Osi5lf8KsfD14Q+tbqZXaH8TX3e9XQ3fge6XuXeU
1x2mnbmawHQ0b0+ztDNncN7C2srvRKOOzk60DnyPnNxbvCPeGaaFexczn0+L
Hmq3g+liX9kazfla8ffSZ+QMTXZXsoeSdU12A85W3nHvTcNradsarg+9rnPP
7qpbshvtoJuzjVgvfG1wdKPtnfSJPd2T7F71W+k9/CPEeuh5qLwhObm35eys
g3dHZ1/Wia8Hne9yH0qTfjCBjc/IYD3eBT/Ee7D6neTEbprR5FK+2/mj70eT
PWb+0OFuNYep2wW+v3hPmDto0d99gHc3Gg7AGdjhcF3x9ebr4xzhPkBuV3k9
9TGCjn3kd9ZTzDnO7PeaJ2YZmGyQfYceD8Le6T4O/ja8fb1HJhtP0yFmGYCv
L/y93jeKj5MT+FFwwfMQnojtir9McUD6tfeAjA7R+2j40d79vOM+0fzD7GKC
+wSxYTS/T39jvPuz0XzD8TzM7pY/VH8TcNwB/0he5vMw3Iz3J3uAbwT/ffxR
dyxcYB6n/Ss0foY2w9V+xDv8zyablWxpsnfxvyJ/nPh4/IPUeEyN0P85/Qdm
sp6eMk/4n8fxHEzkPGEvz8NEbBLNn3BOytEuzidxRs4LObiR/C/QM85p7pPk
jdb3AHq9KD5NP4/ju88M99PoYdiH4V/kf4lOj/C9JG+K3LCpdvEK7MtmeZI+
98NP9b5P/CXYR9k99j3VDoJzOt539P14jm+6d2j+Jm3n0u05vrnub/HHe0Gy
heqHzeeLz8gb+GaqN0Ne5M/jm84/O9kcsz0r9027mGn+yHmb/uF7NUeXJ72f
h3uBP3yz9Pai/iarNwVuHs5JepopZzKO2e6z5L+oj2V879J5ihnmmfFDWn+W
bHWy15I9DbuQ7i/zvy4W+E/lxH0RjVbinCv/aXtdiOMlmn1AtzfdV7ivkPsh
npV45qi/gm+u+ZfQbon3YjbTvmLGj+gwD+9HbBX/dDkzzLrQTNPNtZh+UWep
vPlyl/C9yvdxsk+c82E3Jvsp2U6+iC+wr1n2M9s5x/lezsxzvD/V10K6f5ts
O0zEl+P9BOYTOVn8N3KW22PkfZdsbbI1/O+LhT5b9f8l3VbS/4tkm/Myn5VF
etoMt5Jeq3Gu9V5Dq7X02oLzS5yb5X7EH/EP1Fohd3EO3yI1PoKNXj/Xf8yx
no7xmf/KPlbBfeWe3dPX7GOxDXLX29173tto+AnedTAb4JaJf0b3T/Bug18q
ZznOjeZZJxa72ZvsT7MEbpMdf8sfOv1Ct9DmZ77N7r+w3TBr6LRdb9m+tvN/
ps5GtXbTM3J/92dw8Wdca+TE5yV+f4jfPUbR89dkvyX73jzZz9T3Zovzhxy9
1nn/Tp+vaBT3P2Ai/iP+32B+k5PdUeB2sPXwv+p/N66v5YQ2+fkZbfbS8xt1
A7cHz0+02AP3jfdO+uy0m010LsjP1Ar/LrENuDba2WEJUyQ/U2sPzr38f5px
i95/0WfwFs7P9HZwOvfRMbQ9ID+D3a3+AXr4DceB+Rn7FfZvucER93/oG/iD
8jP6bBf/DvZvmIP18Dt88EZO4P+S8wPO/eb9C9+/dNjPdtjRHprHfIH5Tyz8
h+RntNkjfgg7lH+nHf2n94P1/x//Dv3sV+sweZG/Ey7+MnCed9xLJjuSL/b0
lzlC26OSHZ2f4Tk+WVm7CEwRezraDkrRPe6H070ofGCLwpaCKQqzzyyRe0x+
Zv9H4T6GvxRs8IbWx6aztPlL+6wcbDeRE/HQ4Ih0FktW3LsYzeOd1fBYuaHz
cbRunuzyZHWTlcFfWu5++Yfwl3EvI78Q7hLpPFU/VeicJ348TQ+Vc7x7xWSn
2EcRmLLs9GQ13E8QD50q0TV4S6gT78p0q6KHUvyVxELLI+hZFN8JtCphhnJw
J7LD7e1YnKfylcMV/qq0Ola8KjuNvxjsSfqoordyfEeocYKa1eSdZof/5Ow1
8OVZcb4KyU42w3Hyq/MXhy0pfjJdy9rBOcnOtYPo5yw1ov/6eiiOK6v1yfZW
0d5Kqnc6zsitJ/84sePt8oJkF+ZnPmen0iI0OS9ZnWRn0KGsvZ0nXkdOFT2G
Tmfq+US+LK6K/Br4TnSeqa9TcVV1ryfWKNlFuGrS4RzaxKy16JDVvyZfedia
Zg39z2dxb8Af74a4QsPa9CmTg6tG86hzNlx1eafzVVC3WbJL7a++/NNoXAM+
tL4i2ZU0qMFXUf1zaNacJqH3ZXyX06au+hfgjH5L6/VsPCfjbZSj9RnedXA2
t4sTxLJaB/aWZPGPS64xS0vztNBD9HIx/EUwLeDOEqvpbOzelE5NkrWifwO+
xvyt+Vvx1xRryN/ajLXwxQwd9RNzX2IPbejckLXO8V1IuyucDeU2o3/s5sZk
NyW7Ltn19tpSXw1gz4U/Wy+16XshjsBciyP07qDfiF2V///PdyPvTjS83Eyd
3C8Sv5pdzNcSvjNrIactzNXu19CwS7Ku8lrK6UL3xnBNaVgbtrWZ25vlEvjA
tmNN+drA38Ba42gPk8W2xxP4bvbQRk43GnWgQTPYa+3kSviu+mop50b+6+wq
8nYn+yVZQUGG7zacV+GJ/d6cbHCyO8UC0zcnltX9Ku/uNL0arh/NO3p34uvs
frt7PzlZjj7Jbs3PfLY6w/WnTS/ztqNzD3vqb+7O7uG7g25d+e5wbyevJ772
7t3gB+Rnvsbb6qcnTDu+W9QeAB+88TUeX/vxORuYbBC+/vofTf/e5rvOHL1h
B9O1j7kjfg8d+tDmJrjQciTdYif3eg+y62529mCycXLjPUR8EK5e6l8rvy++
bmYbqPd++r8ZR3fnLe53uWd9d9E3Zh9Dn/tw3iE+FGY0/lHwo+WM5OsHF/hh
Yvfh6cHX09nLPfp+wJz3qxs5d8MMg7kfLvzDxYbTpBf9Q/sRtByMsw/cCLoO
Fu8jN2KPJnsMR8SetYuY/SHzDJEf/rFwg8z+hPkn0WQU3yT3IfLG47vLfQz8
k2Ybi3M8zBD88Zl5HG403veTfZDsDTxP0S34J+TsYKj3ZBreBzvZfZj4xGQP
e0/UT+CnsPvl3A3zMHuEhlOTPS3vATlTxR6h8eN0GQn7DB2nJ5shlt3HCOc9
7i8ne8WeHpT7LAsN3pT/OL6xajzIP4NuY+j4FJ3H4ZjJP0neWHPMEJsEH9jn
kj3v/RyuWfR5Fc9MuxgP+5TYLO8XcnSf4D2NphPhZuN8SM4Evin8MfcKs0/M
4ZhBg0V2EPg5yV7EP43/NbNOFX8N5qWcnT3i/bDYI+o+I/dR8Zflv84/R93Z
Yo/BPis3ON6x04jfrcZwHG/geVvd6HlxsiW0XeQ9A2doMNd9rr3Mpdtz9Az9
l7q/q7e3YObifhX/UvclMPPo+7z3C2ovhp8l5127flL+a7R4T2yZui+YbZrY
HLH55n3bfYH3y3RegDNyluOZB/8a3+u45qi1QG7wxPfS+B57P+z78O+osdBM
oe/qZJ8m+0w8dhLfc1bIeZ8v8Gtotdp9MU0DuzLZWvos4fsi2WaYN/nehVmH
Yy38y2aI3j6UE5wf02gV/0e0eMt7Hs719HibL3AbaLhMfIP7Rv4NeOfLW6e3
td4fib+lnw/p+R6Od+Wsx/GxGb6Ejf4/p+Fy8U9y5lzgvdD5KXuH75tk39rN
+7g+oOnP+ZnfFz+nc3ZnH3hvT/YdjdfY2XZ9RO+b+L8z7yZcy80Tc/0g/j3M
CrOtFFsntsW8X7pv9V5Fw604I+dHPJvh1/NtwLVOra1ygyf++yB+z4vf+3fo
P7u7wH1F26/puAnmJ7ZRXvh3mnOT2E5523J2sI32u+j8BczHan0KG7h/zPU3
rl34f6XFblyfyduM72faxk7+krNLLPz76PGX+3dy4r8PfqHdZp+Bfep/7/zB
fW+yP/Mzn6EvYXfT+we979bnl/w7aLvFDFv1vwffv3TbAR8c+2F/g98Pt4Ne
4f+dfc0X5x80/A/nv2Jb5ezk/889zvgfQPwh/3c97FcrYnkFGWz2M7FK39+a
I+L5BRkt474L96HpflhBRq+IBaaAHZXs6GRFkhUtyOi9S/7P5thjln12Fthv
+PbwR27sJ/5cc5c/nz68IKPh33YR9Q4oyOh5YEFGh1/F4h0W98DE3MUKMrrt
t4sj+OOMWOGCjE4HO4PvIDwH4S9ekNH2X3zFcR6ht8PlBv5g2BLpLIn/kILM
jOEvWfD/HUVOYbHAhMZH0jP0LUvz8JfAW5zm+XD1ktVPVhVPYPc6/7Tbknjz
7KlSssreR+KK3kvrv1xBZrbD7fNE9xPcs75y/NFPKXspRbsDnMfgPglnOfij
YYvxn+QeZ3l5B8L8kaNTMfHi+iiir9K0jv4r0Ks4bAX3kvwnsxJiZeQGx3H2
VRi+Io2in2PNUgausPexckvirWjHJWl8KM7jaH8UzhP1foZ9nJesjr1HzvHJ
TpGTxZ9JwzjPcq+obm1nBffTk9XAV4rmleWdJPcMXMFdzWynwR6ldhXzl6Jn
zWS1kp3Kn42fSoua+M/iq8pfW29nq1GGbuXha6pRGWdpeVXdq8qrhaOCd/jr
46tG54vxRQ/n0rYSTSNenW7n0PgcuFNgqtMv8prbyykwleSeYi8VzRYcFyS7
kO6VYc/DVRb3Rfo7S7/V9XSmWPjr0q4Kq8NXBW8dOsSMjVlNvLW8myRrhDO4
D1XneO8zxKNOPTrWknc236nqNjXj2eJN3VsnuyFZm2SXwDS1l9hJA1aN73z3
rO9884d2zeh7abLL6BbxhjmY2uqc42xG24a0Px22ob11TNYJ7lL8TehzTU69
89hl8sI6yA/9rqbtVe4X0aUObAvvy8XbwkdPNfTVVt3wX5HsyoLMZ6Uujsvx
NlLnGvjIuy7Z9XptQNuWZmlH8yZy4n0tX3vv9t4N5LWyu/Pdm9HzWrO0VKMV
TAOY6/RwCb7A15NTH7Y1/euZrQUd2pj7AvE2ZupA9yvoEfEbk91Eo+biHWjb
nSZX0+lmvV2rv9jZbcn66qWNepeqF1zxPSc+6xXkd8cXP1PiZ1r8vtGDnrfo
oZMddTJT3Du7d3Lv4t0zWS/a99Jbe/GWMO3w93DvIa8VXFf3lt7d9dIWZ3a3
g5INplfM38ecvdUN7A206ArTGy783XJ208b7RtpfAXcrzq54WvHdZi/XqdVb
TpbjFjO2tZcOcoYlu1tvncT6qnErXMw7BMdQ5118d3l3ktcv2e120I+OPeTd
Kae7WGd5PfXRCzZbJ3A3y+uMt4u+R6oXOvRPdod7F++7adBL7AbxPvzDWW/Y
Pt4jYAfQrqdehvHdgO92dbrIHUGv+LcH8ffL4++SB34gnnuS3av329xH2k1g
BrGb+CL2eLInko1N9mBB5rM1hB7jkj2kt9jBeO8htO2Lo59zlP7uUf+hnB2O
Mk8/c4QOj5h5In0mqBV5o+FHwUyAG0OT22nUn+9+7/vgHsY5Tt9D+IbzD1Nr
grwxcucmW5nsLf0NlzdAjYH6f9ScI+AeFX8AZqD7WBrfCx+4x9wHig9yDnYf
r+9n6XovjrAZ9vWY9z20GkOTyH0uR8MnxUbKm5TseXM/BPu8+0jxUc7R7hPh
X2AT5DwJM4k+d9Ag8NPoNlHONPM8p8fIfUpvY9wnJ3uRnpH7kvuLMJPtaLI6
cZ/iPtl9qnfo/DKdXkk2nV5T7SWLeUSdR52RM1N/k+zlAXnTzDIP7hX8z8A9
rcZ0ewpblGyxuWP+N3N6Cuzryd7AEZi5tJ1kXzPkzBUfq5eo9ZZ+svgZep8r
9jzeB+XNg4/YO3qLXmfRP2Z+1ftJ875N/8kwEZtPqxfF57sv4I/3HDmz8cyD
nYxjtn3NMc/Lchfo4UmzTJEzB0/Uic/GQjO8IvYanqnur7u/TqvXaRH395N9
QPdX8Ey3p9XJ1uhnofgM8UX8C8Tm2s2Kgsz3gfhavNV7pfiHZn/L/HH/SPxD
/plqLxGbJ7aUFkucS3O0i/NdnJGzKgc3k3+VXcT5sftSebPgZqj9sbnm0+cN
moW279F0IcwnbIG88H9Kx4Vin8pbnrOP5bhX0/Ids0Q/y2Beg1um9mxcn8G/
xx/xL+wxOL9WN/rZnOxLGq+0j804VuNZbM9rk22h4Yfytrhv5d8Ct5TGK+E+
xLOWP+LrzLNK7lY1v1NvHdxauYvEvzLDxzDr8bzrvsF9g9k30GIZfWL2be7f
mHUjzAb9fIV/G/zX/FvFAr9JTvx+EL9TDMS5De/79hO4+DdTP9tDxL5V933x
z8223fxx7nP/0k5+ocWaHP9umn+B63O83+KLeX5MtkP+bnk/iYX/V3Nldxfc
35sz/L+xrbA/0P179x9z3utwRO7vdPvRXtbx/ya2G98WvayHjdgfcv+g59d0
Wk7zb/j36OEfud/w7bWjDWbd6Nzk3Om+yT3282eyv2gf/7Yt/4DMzrL7+xz/
XvrulfMt+1PuLvv4XC/bzLEd/z747XYUve/X/9/m+Z7/B74d4vvd4/yX/cS3
yyzxb/PC95/393a6j+8ned/z/c0feTvN/jO+/wH3+E0T
         
         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0ik0BFAUBuA3Yzf2JeIoiGiIaAgCmqXhHM5BRENEQ0QzIpoR0RDREO3L
2H1zhC/ccu+7/33VQ+PdY5EQwiJl0RBqaaaTASaZZ5U4CU65JkksLYRKGmij
lxFmWGKDXY644I5oeggRAr/qH7754pMP3knyxisvPPPEIw/cc8kxe2yyzCyj
9NFOI1Xkpfp68w1nHLDNGgtMMUgXLdRRTpQ7IV1wxC4bLDHDCL200UAlMZJW
vOaUBHFWmWeSATpppjaVP6lbGBfS/uMJGWSSRTY55BIjj3wKKKSIYkoopYYm
OuhngjlW2GKfE654S/U1vIJ6WulhmGkWWWeHQ865JRL9/zd/SNdHBw==
       "]]}},
    VertexNormals->CompressedData["
1:eJw1nHk4Vd0Xxw1RQiFEJCqUIUlm9kUJJVPeIvN1dQ3XUCkZKlKG0mgqZCwa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     "]], 
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxl3Gd0TWnfx/EgSnRGDyEkEi0EiTtait57F2b0XoYx+mhRwqjRu4So0QkR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     "]]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"v\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.544252201827361*^9, 3.544252374982627*^9, 3.544252978671488*^9, {
   3.544253021937874*^9, 3.544253050225494*^9}, 3.544254070679557*^9, 
   3.544254318436736*^9, 3.5442545374480143`*^9, 3.5442546400177193`*^9, {
   3.544254707048318*^9, 3.544254728146749*^9}, 3.544254995745715*^9, 
   3.5442552405088053`*^9, 3.5442606733106956`*^9, 3.544261146691764*^9, 
   3.544262808077896*^9}]
}, Open  ]]
},
WindowSize->{740, 838},
WindowMargins->{{87, Automatic}, {Automatic, 17}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 186, 4, 27, "Input"],
Cell[746, 26, 479, 13, 58, "Input"],
Cell[CellGroupData[{
Cell[1250, 43, 1214, 34, 118, "Input"],
Cell[2467, 79, 785, 11, 27, "Output"],
Cell[3255, 92, 786, 11, 27, "Output"],
Cell[4044, 105, 1384, 23, 58, "Output"],
Cell[5431, 130, 979, 19, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6447, 154, 632, 17, 27, "Input"],
Cell[7082, 173, 793, 11, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7912, 189, 133, 2, 27, "Input"],
Cell[8048, 193, 232, 5, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8317, 203, 146, 3, 27, "Input"],
Cell[8466, 208, 229, 7, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8732, 220, 4909, 122, 358, "Input"],
Cell[13644, 344, 152, 3, 20, "Print"]
}, Open  ]],
Cell[13811, 350, 1435, 48, 238, "Input"],
Cell[CellGroupData[{
Cell[15271, 402, 422, 8, 58, "Input"],
Cell[15696, 412, 928, 13, 27, "Output"],
Cell[16627, 427, 1510, 25, 58, "Output"]
}, Open  ]],
Cell[18152, 455, 4931, 137, 313, "Input"],
Cell[23086, 594, 3494, 92, 238, "Input"],
Cell[26583, 688, 1148, 27, 148, "Input"],
Cell[CellGroupData[{
Cell[27756, 719, 94, 2, 27, "Input"],
Cell[27853, 723, 63513, 1053, 275, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[91403, 1781, 290, 5, 27, "Input"],
Cell[91696, 1788, 64135, 1061, 288, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155868, 2854, 157, 3, 27, "Input"],
Cell[156028, 2859, 67644, 1119, 291, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[223709, 3983, 161, 3, 27, "Input"],
Cell[223873, 3988, 61190, 1013, 291, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[285100, 5006, 155, 3, 27, "Input"],
Cell[285258, 5011, 63794, 1056, 303, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[349089, 6072, 154, 3, 27, "Input"],
Cell[349246, 6077, 66039, 1094, 280, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[415322, 7176, 159, 3, 27, "Input"],
Cell[415484, 7181, 56976, 944, 298, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
