(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     52835,       1250]
NotebookOptionsPosition[     51321,       1196]
NotebookOutlinePosition[     51677,       1212]
CellTagsIndexPosition[     51634,       1209]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"Charge", " ", "2"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.543993703343824*^9, 3.543993707816916*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"veclist", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.868`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.07409605574209051`", ",", "2.120168551991567`", ",", 
         "0.9979641465626632`", ",", 
         RowBox[{"-", "0.13206619699953426`"}], ",", "0.1096803066408052`", 
         ",", "1.8798507183251827`", ",", 
         RowBox[{"-", "1.8883455741980362`"}], ",", 
         RowBox[{"-", "1.8849422184581242`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8630000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.10094946961325645`", ",", "2.11843896557585`", ",", 
         "0.996221622879231`", ",", 
         RowBox[{"-", "0.1804917165177124`"}], ",", "0.1492701497125977`", 
         ",", "1.884992279481818`", ",", 
         RowBox[{"-", "1.9007800178918746`"}], ",", 
         RowBox[{"-", "1.8930351877297216`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.858`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.12197000170131408`", ",", "2.1167233983193694`", ",", 
         "0.9944850339762491`", ",", 
         RowBox[{"-", "0.21876327909130314`"}], ",", "0.1801886009746716`", 
         ",", "1.8900978504268293`", ",", 
         RowBox[{"-", "1.9131742069140136`"}], ",", 
         RowBox[{"-", "1.9016726924990976`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8530000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.13991378424453033`", ",", "2.1149837348926606`", ",", 
         "0.9927440162648846`", ",", 
         RowBox[{"-", "0.2517293820681301`"}], ",", "0.20648020601257608`", 
         ",", "1.8952275889273653`", ",", 
         RowBox[{"-", "1.9256311591239745`"}], ",", 
         RowBox[{"-", "1.909808191488722`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.848`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.1558346013771002`", ",", "2.113225412671581`", ",", 
         "0.9910000469003952`", ",", 
         RowBox[{"-", "0.28124731545350495`"}], ",", "0.22972733575964316`", 
         ",", "1.900372935353736`", ",", 
         RowBox[{"-", "1.9381362448249575`"}], ",", 
         RowBox[{"-", "1.9180104248625407`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8430000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17016875000194848`", ",", "2.1115098780778703`", ",", 
         "0.9892697750637398`", ",", 
         RowBox[{"-", "0.3080592423512553`"}], ",", "0.2506153749130479`", 
         ",", "1.9054371593492085`", ",", 
         RowBox[{"-", "1.9505236948034614`"}], ",", 
         RowBox[{"-", "1.9261627936566683`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.84`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17826167507411272`", ",", "2.1104559051192573`", ",", 
         "0.9882259326796118`", ",", 
         RowBox[{"-", "0.32330581600520547`"}], ",", "0.26236779856342607`", 
         ",", "1.9085078859494449`", ",", 
         RowBox[{"-", "1.9580215612745053`"}], ",", 
         RowBox[{"-", "1.931121256897245`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.82`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.22488694197749054`", ",", "2.103380714521802`", ",", 
         "0.9812728968525489`", ",", 
         RowBox[{"-", "0.41286781222427793`"}], ",", "0.3296044742182707`", 
         ",", "1.9289306281682954`", ",", 
         RowBox[{"-", "2.008120303091178`"}], ",", 
         RowBox[{"-", "1.9650601848404534`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.263403558765456`", ",", "2.096205608174961`", ",", 
         "0.9743256730333851`", ",", 
         RowBox[{"-", "0.48939211154605033`"}], ",", "0.3843975474769295`", 
         ",", "1.9492937907951573`", ",", 
         RowBox[{"-", "2.05845848599753`"}], ",", 
         RowBox[{"-", "1.9995561358962997`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.78`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.29697518455095745`", ",", "2.0889423128476263`", ",", 
         "0.9673869185290676`", ",", 
         RowBox[{"-", "0.558279652709024`"}], ",", "0.4315291947985173`", ",",
          "1.9695814694547868`", ",", 
         RowBox[{"-", "2.1090091196394116`"}], ",", 
         RowBox[{"-", "2.0352685093571585`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.76`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.3271598204456268`", ",", "2.081567124294121`", ",", 
         "0.9604497669481518`", ",", 
         RowBox[{"-", "0.6221486306454592`"}], ",", "0.47328486423405836`", 
         ",", "1.9898325723528631`", ",", 
         RowBox[{"-", "2.1598388644472086`"}], ",", 
         RowBox[{"-", "2.071552595488018`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7200000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.3805021914087528`", ",", "2.066514870321669`", ",", 
         "0.9465874464830879`", ",", 
         RowBox[{"-", "0.7400039977668367`"}], ",", "0.5455047926770815`", 
         ",", "2.0301803808864767`", ",", 
         RowBox[{"-", "2.2622601874863317`"}], ",", 
         RowBox[{"-", "2.1473061767619304`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7000000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.4046128853375105`", ",", "2.0588198731087877`", ",", 
         "0.9396565452523309`", ",", 
         RowBox[{"-", "0.795537154126863`"}], ",", "0.5773661902403812`", ",",
          "2.0503081121045224`", ",", 
         RowBox[{"-", "2.3139052814335432`"}], ",", 
         RowBox[{"-", "2.186433658947585`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6800000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.42738986570203724`", ",", "2.0510415737040817`", ",", 
         "0.932732941463491`", ",", 
         RowBox[{"-", "0.8493817405747806`"}], ",", "0.607017515193857`", ",",
          "2.070362854344421`", ",", 
         RowBox[{"-", "2.3657698062065`"}], ",", 
         RowBox[{"-", "2.226488748803607`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6600000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.4490644897242795`", ",", "2.0431503052332096`", ",", 
         "0.9258082749841597`", ",", 
         RowBox[{"-", "0.9019290716600774`"}], ",", "0.6347851658005186`", 
         ",", "2.090391510684943`", ",", 
         RowBox[{"-", "2.4179342410329308`"}], ",", 
         RowBox[{"-", "2.2678968345073445`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.62`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.48966127102623513`", ",", "2.0270829673417428`", ",", 
         "0.9119680934315914`", ",", 
         RowBox[{"-", "1.0038852676290009`"}], ",", "0.6855185237246182`", 
         ",", "2.13029486109991`", ",", 
         RowBox[{"-", "2.5230393049728153`"}], ",", 
         RowBox[{"-", "2.3528071117321376`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5088314372895092`", ",", "2.018878236095998`", ",", 
         "0.9050440626366997`", ",", 
         RowBox[{"-", "1.0536960221886291`"}], ",", "0.7088332820279133`", 
         ",", "2.1502152257033487`", ",", 
         RowBox[{"-", "2.5760592963152127`"}], ",", 
         RowBox[{"-", "2.3967672740185004`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.58`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5273545275263245`", ",", "2.010575258529651`", ",", 
         "0.8981208966176263`", ",", 
         RowBox[{"-", "1.1028793495786011`"}], ",", "0.7309985511711032`", 
         ",", "2.170093522850811`", ",", 
         RowBox[{"-", "2.6293577550798335`"}], ",", 
         RowBox[{"-", "2.442127737440482`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.56`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5453077255774209`", ",", "2.0021626572013895`", ",", 
         "0.8911951179108348`", ",", 
         RowBox[{"-", "1.1515364877849836`"}], ",", "0.7520675842519604`", 
         ",", "2.189947276035549`", ",", 
         RowBox[{"-", "2.682965705949222`"}], ",", 
         RowBox[{"-", "2.4880947291761606`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.52`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5797281594432059`", ",", "1.9850115064241494`", ",", 
         "0.8773345210374353`", ",", 
         RowBox[{"-", "1.2476078725156199`"}], ",", "0.7913395670399445`", 
         ",", "2.229582003315571`", ",", 
         RowBox[{"-", "2.791119378501514`"}], ",", 
         RowBox[{"-", "2.5830794221371645`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5962865178030728`", ",", "1.9762766204423838`", ",", 
         "0.8703996350381962`", ",", 
         RowBox[{"-", "1.2951477748864133`"}], ",", "0.8097010177996378`", 
         ",", "2.2493599143445286`", ",", 
         RowBox[{"-", "2.845665400722957`"}], ",", 
         RowBox[{"-", "2.6321062777511957`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.48`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6124714214301092`", ",", "1.9674207398689028`", ",", 
         "0.8634571985828617`", ",", 
         RowBox[{"-", "1.3424501191023754`"}], ",", "0.8272732318349333`", 
         ",", "2.2691341396915985`", ",", 
         RowBox[{"-", "2.9005642737031407`"}], ",", 
         RowBox[{"-", "2.6822204172706203`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.44`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6438209671286115`", ",", "1.9493940340092228`", ",", 
         "0.849559994780463`", ",", 
         RowBox[{"-", "1.4364446858730455`"}], ",", "0.8603685854903844`", 
         ",", "2.308605812587862`", ",", 
         RowBox[{"-", "3.011326105997462`"}], ",", 
         RowBox[{"-", "2.7860539537726856`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.4200000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6590456785721874`", ",", "1.9402159607617797`", ",", 
         "0.8426022906426062`", ",", 
         RowBox[{"-", "1.4832140488394734`"}], ",", "0.8759550669907962`", 
         ",", "2.328315490980453`", ",", 
         RowBox[{"-", "3.067216233533839`"}], ",", 
         RowBox[{"-", "2.839376372487654`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.3800000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6887287617582241`", ",", "1.9215013977136444`", ",", 
         "0.8286586577921988`", ",", 
         RowBox[{"-", "1.5764938761555642`"}], ",", "0.9053719458902377`", 
         ",", "2.367726088123225`", ",", 
         RowBox[{"-", "3.1801001723213007`"}], ",", 
         RowBox[{"-", "2.9494204405805933`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.36`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7032264406191593`", ",", "1.911966636481573`", ",", 
         "0.8216720594144495`", ",", 
         RowBox[{"-", "1.6230575588931981`"}], ",", "0.9192800184979449`", 
         ",", "2.3874262771487995`", ",", 
         RowBox[{"-", "3.2371024942745943`"}], ",", 
         RowBox[{"-", "3.0061441868231955`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.34`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7175184633466903`", ",", "1.9023140363077047`", ",", 
         "0.8146750132812847`", ",", 
         RowBox[{"-", "1.6695961776918746`"}], ",", "0.9326989945280368`", 
         ",", "2.4071224483050213`", ",", 
         RowBox[{"-", "3.2944823760345705`"}], ",", 
         RowBox[{"-", "3.0640137430428847`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.32`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7316236278236997`", ",", "1.892538357642916`", ",", 
         "0.8076656225360733`", ",", 
         RowBox[{"-", "1.716138544533985`"}], ",", "0.9456473034737107`", ",",
          "2.4268225920081994`", ",", 
         RowBox[{"-", "3.352257372105316`"}], ",", 
         RowBox[{"-", "3.1230544109686846`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.28`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.759327630044047`", ",", "1.8726252884090915`", ",", 
         "0.7936093988176277`", ",", 
         RowBox[{"-", "1.8092946252978641`"}], ",", "0.9702715256209089`", 
         ",", "2.4662250249723754`", ",", 
         RowBox[{"-", "3.468998672177377`"}], ",", 
         RowBox[{"-", "3.244691808425779`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.23`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.793157516173759`", ",", "1.8470221833116771`", ",", 
         "0.7759543195536678`", ",", 
         RowBox[{"-", "1.926084168284337`"}], ",", "0.9988649230120109`", ",",
          "2.5155298343116375`", ",", 
         RowBox[{"-", "3.6172923759074913`"}], ",", 
         RowBox[{"-", "3.403639782925374`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.18`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.8262833012364006`", ",", "1.8205837200802935`", ",", 
         "0.7581849149437223`", ",", 
         RowBox[{"-", "2.043517834789346`"}], ",", "1.0252809707518953`", ",",
          "2.564951928019079`", ",", 
         RowBox[{"-", "3.768399956744153`"}], ",", 
         RowBox[{"-", "3.5705963723620657`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.03`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.9230488688213225`", ",", "1.73588609398436`", ",", 
         "0.7039940643249193`", ",", 
         RowBox[{"-", "2.4019805149276023`"}], ",", "1.0942543883857436`", 
         ",", "2.7143508760863733`", ",", 
         RowBox[{"-", "4.240489973931262`"}], ",", 
         RowBox[{"-", "4.123436603974003`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.98`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.9549279981238569`", ",", "1.7056750601798654`", ",", 
         "0.6855521428817635`", ",", 
         RowBox[{"-", "2.5242985092271657`"}], ",", "1.114555308899134`", ",",
          "2.7647280495543316`", ",", 
         RowBox[{"-", "4.404914229188696`"}], ",", 
         RowBox[{"-", "4.326628213569345`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9299999999999999`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.986857615616634`", ",", "1.6743550719995128`", ",", 
         "0.6668700888623107`", ",", 
         RowBox[{"-", "2.6484410797834674`"}], ",", "1.1338173625182217`", 
         ",", "2.815515897460275`", ",", 
         RowBox[{"-", "4.573359485184544`"}], ",", 
         RowBox[{"-", "4.540306961248853`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.88`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0189782070091018`", ",", "1.6418495888986004`", ",", 
         "0.6479144619747503`", ",", 
         RowBox[{"-", "2.7746598884801315`"}], ",", "1.1522566054543582`", 
         ",", "2.8667820124242054`", ",", 
         RowBox[{"-", "4.746155719065648`"}], ",", 
         RowBox[{"-", "4.76514244154874`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8300000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0514363539949725`", ",", "1.6080712188475348`", ",", 
         "0.6286476155983801`", ",", 
         RowBox[{"-", "2.903241545154152`"}], ",", "1.1701212378997488`", ",",
          "2.9185998862859255`", ",", 
         RowBox[{"-", "4.923682903219094`"}], ",", 
         RowBox[{"-", "5.002008900278566`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.78`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0844010454097461`", ",", "1.572887661093316`", ",", 
         "0.6090193365955197`", ",", 
         RowBox[{"-", "3.034504887082299`"}], ",", "1.1875031258439983`", ",",
          "2.971090532668834`", ",", 
         RowBox[{"-", "5.106421449956452`"}], ",", 
         RowBox[{"-", "5.251811873544956`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.73`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1180479966266779`", ",", "1.5361730163991627`", ",", 
         "0.588978613592471`", ",", 
         RowBox[{"-", "3.1688120759508878`"}], ",", "1.2046503944973106`", 
         ",", "3.024353579034675`", ",", 
         RowBox[{"-", "5.294886464737035`"}], ",", 
         RowBox[{"-", "5.515627155864887`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.6799999999999999`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1525837188902464`", ",", "1.4977570080308695`", ",", 
         "0.568461058774028`", ",", 
         RowBox[{"-", "3.306576091782493`"}], ",", "1.2217108459212238`", ",",
          "3.078528825897698`", ",", 
         RowBox[{"-", "5.489706657652221`"}], ",", 
         RowBox[{"-", "5.794792774146105`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.63`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1882418065099052`", ",", "1.4574526479500487`", ",", 
         "0.5473946051470174`", ",", 
         RowBox[{"-", "3.44828153950453`"}], ",", "1.2389675741800101`", ",", 
         "3.1337571079417206`", ",", 
         RowBox[{"-", "5.69160646740515`"}], ",", 
         RowBox[{"-", "6.091006264154231`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.58`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.225305531795742`", ",", "1.415017305618747`", ",", 
         "0.5256894636474833`", ",", 
         RowBox[{"-", "3.5945070249561994`"}], ",", "1.2566285813178981`", 
         ",", "3.190224734457376`", ",", 
         RowBox[{"-", "5.901477288136015`"}], ",", 
         RowBox[{"-", "6.406073534076588`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.53`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.2641202878210855`", ",", "1.3701532912838383`", ",", 
         "0.5032367592682069`", ",", 
         RowBox[{"-", "3.745944023702552`"}], ",", "1.2749492456089138`", ",",
          "3.2481515787097424`", ",", 
         RowBox[{"-", "6.12039536605819`"}], ",", 
         RowBox[{"-", "6.742346946394514`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.48`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3051173605423914`", ",", "1.3224924070876931`", ",", 
         "0.47990281899507703`", ",", 
         RowBox[{"-", "3.903453166116109`"}], ",", "1.2942804705700126`", ",",
          "3.3078010338537096`", ",", 
         RowBox[{"-", "6.3496994746537645`"}], ",", 
         RowBox[{"-", "7.102722008787847`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.42999999999999994`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3488591460162878`", ",", "1.271548393431121`", ",", 
         "0.4555152710323542`", ",", 
         RowBox[{"-", "4.0681096407769`"}], ",", "1.3149514902873514`", ",", 
         "3.3695179164521227`", ",", 
         RowBox[{"-", "6.591085402958407`"}], ",", 
         RowBox[{"-", "7.490873737285019`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.38`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3960957591064582`", ",", "1.216685753047732`", ",", 
         "0.42985107157498326`", ",", 
         RowBox[{"-", "4.241312742141526`"}], ",", "1.337427292084789`", ",", 
         "3.4337399590177204`", ",", 
         RowBox[{"-", "6.84675801294185`"}], ",", 
         RowBox[{"-", "7.911597762080053`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.32999999999999996`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.447873230106782`", ",", "1.1570340351583543`", ",", 
         "0.4026093032641672`", ",", 
         RowBox[{"-", "4.4249325467136185`"}], ",", "1.3622900283129145`", 
         ",", "3.501054633931335`", ",", 
         RowBox[{"-", "7.119675995248774`"}], ",", 
         RowBox[{"-", "8.371305919012228`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.28`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.5057236960045268`", ",", "1.0913518674675085`", ",", 
         "0.373367196787542`", ",", 
         RowBox[{"-", "4.621576053138501`"}], ",", "1.390318997704208`", ",", 
         "3.572281474924267`", ",", 
         RowBox[{"-", "7.413971974028285`"}], ",", 
         RowBox[{"-", "8.878975020794677`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.22999999999999998`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.57203980735116`", ",", "1.0177678673734798`", ",", 
         "0.34149736181382523`", ",", 
         RowBox[{"-", "4.835076798074535`"}], ",", "1.4226214179605465`", ",",
          "3.6486273990264926`", ",", 
         RowBox[{"-", "7.735734242987447`"}], ",", 
         RowBox[{"-", "9.44782848881641`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.07999999999999985`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.8892842980600542`", ",", "0.7021647764329307`", ",", 
         "0.21477094825370602`", ",", 
         RowBox[{"-", "5.668698911077289`"}], ",", "1.571068461292025`", ",", 
         "3.937321470523456`", ",", 
         RowBox[{"-", "9.011955267383346`"}], ",", 
         RowBox[{"-", "11.838448294690265`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.030000000000000027`", ",", 
       RowBox[{"{", 
        RowBox[{
        "2.14505629502275`", ",", "0.5002442116584971`", ",", 
         "0.14210334806045316`", ",", 
         RowBox[{"-", "6.127329861034945`"}], ",", "1.6695931030439755`", ",",
          "4.090153831975672`", ",", 
         RowBox[{"-", "9.72589898707181`"}], ",", 
         RowBox[{"-", "13.263510038735388`"}]}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.543993657871076*^9, 3.543993663845245*^9}, {
  3.543993852715075*^9, 3.54399385931518*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"hort1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"veclist", "[", 
      RowBox[{"[", 
       RowBox[{"ii", ",", "2", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", 
       RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"asymscalre", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"veclist", "[", 
      RowBox[{"[", 
       RowBox[{"ii", ",", "2", ",", "4"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", 
       RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"asymscalim", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"veclist", "[", 
      RowBox[{"[", 
       RowBox[{"ii", ",", "2", ",", "5"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", 
       RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"asym\[Mu]", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"veclist", "[", 
      RowBox[{"[", 
       RowBox[{"ii", ",", "2", ",", "6"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", 
       RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"asymq", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"veclist", "[", 
     RowBox[{"[", 
      RowBox[{"ii", ",", "2", ",", "7"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", 
      RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.54385840855757*^9, 3.543858478411048*^9}, {
  3.5438629561121693`*^9, 3.543862967887542*^9}, {3.5438667569267807`*^9, 
  3.543866769631545*^9}, {3.543993923118877*^9, 3.543993930541388*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.120168551991567`", ",", "2.11843896557585`", ",", "2.1167233983193694`", 
   ",", "2.1149837348926606`", ",", "2.113225412671581`", ",", 
   "2.1115098780778703`", ",", "2.1104559051192573`", ",", 
   "2.103380714521802`", ",", "2.096205608174961`", ",", 
   "2.0889423128476263`", ",", "2.081567124294121`", ",", 
   "2.066514870321669`", ",", "2.0588198731087877`", ",", 
   "2.0510415737040817`", ",", "2.0431503052332096`", ",", 
   "2.0270829673417428`", ",", "2.018878236095998`", ",", 
   "2.010575258529651`", ",", "2.0021626572013895`", ",", 
   "1.9850115064241494`", ",", "1.9762766204423838`", ",", 
   "1.9674207398689028`", ",", "1.9493940340092228`", ",", 
   "1.9402159607617797`", ",", "1.9215013977136444`", ",", 
   "1.911966636481573`", ",", "1.9023140363077047`", ",", 
   "1.892538357642916`", ",", "1.8726252884090915`", ",", 
   "1.8470221833116771`", ",", "1.8205837200802935`", ",", 
   "1.73588609398436`", ",", "1.7056750601798654`", ",", 
   "1.6743550719995128`", ",", "1.6418495888986004`", ",", 
   "1.6080712188475348`", ",", "1.572887661093316`", ",", 
   "1.5361730163991627`", ",", "1.4977570080308695`", ",", 
   "1.4574526479500487`", ",", "1.415017305618747`", ",", 
   "1.3701532912838383`", ",", "1.3224924070876931`", ",", 
   "1.271548393431121`", ",", "1.216685753047732`", ",", 
   "1.1570340351583543`", ",", "1.0913518674675085`", ",", 
   "1.0177678673734798`", ",", "0.7021647764329307`", ",", 
   "0.5002442116584971`"}], "}"}]], "Output",
 CellChangeTimes->{{3.543858425326831*^9, 3.543858478824554*^9}, 
   3.543862968531602*^9, 3.543866114231476*^9, 3.543866770979773*^9, 
   3.543868288704941*^9, 3.5438685946738243`*^9, {3.543993665654764*^9, 
   3.543993695129717*^9}, {3.5439939186663103`*^9, 3.543993931040856*^9}, 
   3.544074479639037*^9, 3.544362071213828*^9, 3.544424619160495*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.13206619699953426`"}], ",", 
   RowBox[{"-", "0.1804917165177124`"}], ",", 
   RowBox[{"-", "0.21876327909130314`"}], ",", 
   RowBox[{"-", "0.2517293820681301`"}], ",", 
   RowBox[{"-", "0.28124731545350495`"}], ",", 
   RowBox[{"-", "0.3080592423512553`"}], ",", 
   RowBox[{"-", "0.32330581600520547`"}], ",", 
   RowBox[{"-", "0.41286781222427793`"}], ",", 
   RowBox[{"-", "0.48939211154605033`"}], ",", 
   RowBox[{"-", "0.558279652709024`"}], ",", 
   RowBox[{"-", "0.6221486306454592`"}], ",", 
   RowBox[{"-", "0.7400039977668367`"}], ",", 
   RowBox[{"-", "0.795537154126863`"}], ",", 
   RowBox[{"-", "0.8493817405747806`"}], ",", 
   RowBox[{"-", "0.9019290716600774`"}], ",", 
   RowBox[{"-", "1.0038852676290009`"}], ",", 
   RowBox[{"-", "1.0536960221886291`"}], ",", 
   RowBox[{"-", "1.1028793495786011`"}], ",", 
   RowBox[{"-", "1.1515364877849836`"}], ",", 
   RowBox[{"-", "1.2476078725156199`"}], ",", 
   RowBox[{"-", "1.2951477748864133`"}], ",", 
   RowBox[{"-", "1.3424501191023754`"}], ",", 
   RowBox[{"-", "1.4364446858730455`"}], ",", 
   RowBox[{"-", "1.4832140488394734`"}], ",", 
   RowBox[{"-", "1.5764938761555642`"}], ",", 
   RowBox[{"-", "1.6230575588931981`"}], ",", 
   RowBox[{"-", "1.6695961776918746`"}], ",", 
   RowBox[{"-", "1.716138544533985`"}], ",", 
   RowBox[{"-", "1.8092946252978641`"}], ",", 
   RowBox[{"-", "1.926084168284337`"}], ",", 
   RowBox[{"-", "2.043517834789346`"}], ",", 
   RowBox[{"-", "2.4019805149276023`"}], ",", 
   RowBox[{"-", "2.5242985092271657`"}], ",", 
   RowBox[{"-", "2.6484410797834674`"}], ",", 
   RowBox[{"-", "2.7746598884801315`"}], ",", 
   RowBox[{"-", "2.903241545154152`"}], ",", 
   RowBox[{"-", "3.034504887082299`"}], ",", 
   RowBox[{"-", "3.1688120759508878`"}], ",", 
   RowBox[{"-", "3.306576091782493`"}], ",", 
   RowBox[{"-", "3.44828153950453`"}], ",", 
   RowBox[{"-", "3.5945070249561994`"}], ",", 
   RowBox[{"-", "3.745944023702552`"}], ",", 
   RowBox[{"-", "3.903453166116109`"}], ",", 
   RowBox[{"-", "4.0681096407769`"}], ",", 
   RowBox[{"-", "4.241312742141526`"}], ",", 
   RowBox[{"-", "4.4249325467136185`"}], ",", 
   RowBox[{"-", "4.621576053138501`"}], ",", 
   RowBox[{"-", "4.835076798074535`"}], ",", 
   RowBox[{"-", "5.668698911077289`"}], ",", 
   RowBox[{"-", "6.127329861034945`"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.543858425326831*^9, 3.543858478824554*^9}, 
   3.543862968531602*^9, 3.543866114231476*^9, 3.543866770979773*^9, 
   3.543868288704941*^9, 3.5438685946738243`*^9, {3.543993665654764*^9, 
   3.543993695129717*^9}, {3.5439939186663103`*^9, 3.543993931040856*^9}, 
   3.544074479639037*^9, 3.544362071213828*^9, 3.544424619162871*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.1096803066408052`", ",", "0.1492701497125977`", ",", 
   "0.1801886009746716`", ",", "0.20648020601257608`", ",", 
   "0.22972733575964316`", ",", "0.2506153749130479`", ",", 
   "0.26236779856342607`", ",", "0.3296044742182707`", ",", 
   "0.3843975474769295`", ",", "0.4315291947985173`", ",", 
   "0.47328486423405836`", ",", "0.5455047926770815`", ",", 
   "0.5773661902403812`", ",", "0.607017515193857`", ",", 
   "0.6347851658005186`", ",", "0.6855185237246182`", ",", 
   "0.7088332820279133`", ",", "0.7309985511711032`", ",", 
   "0.7520675842519604`", ",", "0.7913395670399445`", ",", 
   "0.8097010177996378`", ",", "0.8272732318349333`", ",", 
   "0.8603685854903844`", ",", "0.8759550669907962`", ",", 
   "0.9053719458902377`", ",", "0.9192800184979449`", ",", 
   "0.9326989945280368`", ",", "0.9456473034737107`", ",", 
   "0.9702715256209089`", ",", "0.9988649230120109`", ",", 
   "1.0252809707518953`", ",", "1.0942543883857436`", ",", 
   "1.114555308899134`", ",", "1.1338173625182217`", ",", 
   "1.1522566054543582`", ",", "1.1701212378997488`", ",", 
   "1.1875031258439983`", ",", "1.2046503944973106`", ",", 
   "1.2217108459212238`", ",", "1.2389675741800101`", ",", 
   "1.2566285813178981`", ",", "1.2749492456089138`", ",", 
   "1.2942804705700126`", ",", "1.3149514902873514`", ",", 
   "1.337427292084789`", ",", "1.3622900283129145`", ",", 
   "1.390318997704208`", ",", "1.4226214179605465`", ",", 
   "1.571068461292025`", ",", "1.6695931030439755`"}], "}"}]], "Output",
 CellChangeTimes->{{3.543858425326831*^9, 3.543858478824554*^9}, 
   3.543862968531602*^9, 3.543866114231476*^9, 3.543866770979773*^9, 
   3.543868288704941*^9, 3.5438685946738243`*^9, {3.543993665654764*^9, 
   3.543993695129717*^9}, {3.5439939186663103`*^9, 3.543993931040856*^9}, 
   3.544074479639037*^9, 3.544362071213828*^9, 3.544424619164657*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.8798507183251827`", ",", "1.884992279481818`", ",", 
   "1.8900978504268293`", ",", "1.8952275889273653`", ",", 
   "1.900372935353736`", ",", "1.9054371593492085`", ",", 
   "1.9085078859494449`", ",", "1.9289306281682954`", ",", 
   "1.9492937907951573`", ",", "1.9695814694547868`", ",", 
   "1.9898325723528631`", ",", "2.0301803808864767`", ",", 
   "2.0503081121045224`", ",", "2.070362854344421`", ",", 
   "2.090391510684943`", ",", "2.13029486109991`", ",", "2.1502152257033487`",
    ",", "2.170093522850811`", ",", "2.189947276035549`", ",", 
   "2.229582003315571`", ",", "2.2493599143445286`", ",", 
   "2.2691341396915985`", ",", "2.308605812587862`", ",", 
   "2.328315490980453`", ",", "2.367726088123225`", ",", 
   "2.3874262771487995`", ",", "2.4071224483050213`", ",", 
   "2.4268225920081994`", ",", "2.4662250249723754`", ",", 
   "2.5155298343116375`", ",", "2.564951928019079`", ",", 
   "2.7143508760863733`", ",", "2.7647280495543316`", ",", 
   "2.815515897460275`", ",", "2.8667820124242054`", ",", 
   "2.9185998862859255`", ",", "2.971090532668834`", ",", 
   "3.024353579034675`", ",", "3.078528825897698`", ",", 
   "3.1337571079417206`", ",", "3.190224734457376`", ",", 
   "3.2481515787097424`", ",", "3.3078010338537096`", ",", 
   "3.3695179164521227`", ",", "3.4337399590177204`", ",", 
   "3.501054633931335`", ",", "3.572281474924267`", ",", 
   "3.6486273990264926`", ",", "3.937321470523456`", ",", 
   "4.090153831975672`"}], "}"}]], "Output",
 CellChangeTimes->{{3.543858425326831*^9, 3.543858478824554*^9}, 
   3.543862968531602*^9, 3.543866114231476*^9, 3.543866770979773*^9, 
   3.543868288704941*^9, 3.5438685946738243`*^9, {3.543993665654764*^9, 
   3.543993695129717*^9}, {3.5439939186663103`*^9, 3.543993931040856*^9}, 
   3.544074479639037*^9, 3.544362071213828*^9, 3.544424619166395*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.8883455741980362`"}], ",", 
   RowBox[{"-", "1.9007800178918746`"}], ",", 
   RowBox[{"-", "1.9131742069140136`"}], ",", 
   RowBox[{"-", "1.9256311591239745`"}], ",", 
   RowBox[{"-", "1.9381362448249575`"}], ",", 
   RowBox[{"-", "1.9505236948034614`"}], ",", 
   RowBox[{"-", "1.9580215612745053`"}], ",", 
   RowBox[{"-", "2.008120303091178`"}], ",", 
   RowBox[{"-", "2.05845848599753`"}], ",", 
   RowBox[{"-", "2.1090091196394116`"}], ",", 
   RowBox[{"-", "2.1598388644472086`"}], ",", 
   RowBox[{"-", "2.2622601874863317`"}], ",", 
   RowBox[{"-", "2.3139052814335432`"}], ",", 
   RowBox[{"-", "2.3657698062065`"}], ",", 
   RowBox[{"-", "2.4179342410329308`"}], ",", 
   RowBox[{"-", "2.5230393049728153`"}], ",", 
   RowBox[{"-", "2.5760592963152127`"}], ",", 
   RowBox[{"-", "2.6293577550798335`"}], ",", 
   RowBox[{"-", "2.682965705949222`"}], ",", 
   RowBox[{"-", "2.791119378501514`"}], ",", 
   RowBox[{"-", "2.845665400722957`"}], ",", 
   RowBox[{"-", "2.9005642737031407`"}], ",", 
   RowBox[{"-", "3.011326105997462`"}], ",", 
   RowBox[{"-", "3.067216233533839`"}], ",", 
   RowBox[{"-", "3.1801001723213007`"}], ",", 
   RowBox[{"-", "3.2371024942745943`"}], ",", 
   RowBox[{"-", "3.2944823760345705`"}], ",", 
   RowBox[{"-", "3.352257372105316`"}], ",", 
   RowBox[{"-", "3.468998672177377`"}], ",", 
   RowBox[{"-", "3.6172923759074913`"}], ",", 
   RowBox[{"-", "3.768399956744153`"}], ",", 
   RowBox[{"-", "4.240489973931262`"}], ",", 
   RowBox[{"-", "4.404914229188696`"}], ",", 
   RowBox[{"-", "4.573359485184544`"}], ",", 
   RowBox[{"-", "4.746155719065648`"}], ",", 
   RowBox[{"-", "4.923682903219094`"}], ",", 
   RowBox[{"-", "5.106421449956452`"}], ",", 
   RowBox[{"-", "5.294886464737035`"}], ",", 
   RowBox[{"-", "5.489706657652221`"}], ",", 
   RowBox[{"-", "5.69160646740515`"}], ",", 
   RowBox[{"-", "5.901477288136015`"}], ",", 
   RowBox[{"-", "6.12039536605819`"}], ",", 
   RowBox[{"-", "6.3496994746537645`"}], ",", 
   RowBox[{"-", "6.591085402958407`"}], ",", 
   RowBox[{"-", "6.84675801294185`"}], ",", 
   RowBox[{"-", "7.119675995248774`"}], ",", 
   RowBox[{"-", "7.413971974028285`"}], ",", 
   RowBox[{"-", "7.735734242987447`"}], ",", 
   RowBox[{"-", "9.011955267383346`"}], ",", 
   RowBox[{"-", "9.72589898707181`"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.543858425326831*^9, 3.543858478824554*^9}, 
   3.543862968531602*^9, 3.543866114231476*^9, 3.543866770979773*^9, 
   3.543868288704941*^9, 3.5438685946738243`*^9, {3.543993665654764*^9, 
   3.543993695129717*^9}, {3.5439939186663103`*^9, 3.543993931040856*^9}, 
   3.544074479639037*^9, 3.544362071213828*^9, 3.544424619168269*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"beta", "=", 
   FractionBox[
    RowBox[{"2", "\[Pi]"}], "hort1"]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"asymscal", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"asymscalre", "^", "2"}], "+", 
    RowBox[{"asymscalim", "^", "2"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.543858483929041*^9, 3.543858516153016*^9}, {
  3.5438585545131702`*^9, 3.543858554792109*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.9635310368496484`", ",", "2.9659505934699624`", ",", 
   "2.9683544445005396`", ",", "2.970796041369306`", ",", 
   "2.9732679105142226`", ",", "2.9756835960906023`", ",", 
   "2.9771696683824045`", ",", "2.98718404319308`", ",", "2.997408881397839`",
    ",", "3.0078309336433553`", ",", "3.01848796219352`", ",", 
   "3.0404742774493365`", ",", "3.051838283303565`", ",", 
   "3.0634119696718085`", ",", "3.0752437992869104`", ",", 
   "3.099619210662685`", ",", "3.1122160786326987`", ",", 
   "3.125068450197944`", ",", "3.1381992290087877`", ",", 
   "3.1653143001162127`", ",", "3.179304578208851`", ",", 
   "3.1936154681373647`", ",", "3.223147910357183`", ",", "3.23839481493217`",
    ",", "3.2699353300787712`", ",", "3.286242127499667`", ",", 
   "3.302916967050788`", ",", "3.319977786344607`", ",", 
   "3.3552816711759417`", ",", "3.4017920109188666`", ",", 
   "3.451192734439303`", ",", "3.6195838707123125`", ",", 
   "3.6836941888081642`", ",", "3.752600277118171`", ",", 
   "3.826894588678203`", ",", "3.9072804945060775`", ",", 
   "3.9946815418541317`", ",", "4.09015471571527`", ",", "4.195063200165034`",
    ",", "4.311073375877479`", ",", "4.440359338525636`", ",", 
   "4.585753540972208`", ",", "4.751018057650712`", ",", 
   "4.9413654561940525`", ",", "5.164180883552344`", ",", 
   "5.430423925532714`", ",", "5.757249787604957`", ",", "6.173495458639696`",
    ",", "8.94830603594047`", ",", "12.560235902277553`"}], "}"}]], "Output",
 CellChangeTimes->{{3.543858494521798*^9, 3.543858516688918*^9}, 
   3.5438585551406517`*^9, 3.543862970880424*^9, 3.54386611539991*^9, 
   3.543868289447895*^9, 3.5438685955931473`*^9, {3.543993666847354*^9, 
   3.5439936958142567`*^9}, 3.5439939318822203`*^9, 3.544074480387786*^9, 
   3.544362071914113*^9, 3.544424619809346*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.17167192564522846`", ",", "0.23421963480189184`", ",", 
   "0.2834171910805497`", ",", "0.325579110618907`", ",", 
   "0.36314556481530536`", ",", "0.39712537433515505`", ",", 
   "0.416369442185435`", ",", "0.5282981542609858`", ",", 
   "0.6223070892652437`", ",", "0.7056157712185614`", ",", 
   "0.7817080537688422`", ",", "0.9193374764168848`", ",", 
   "0.9829705393494559`", ",", "1.0439921479465104`", ",", 
   "1.1029180645115941`", ",", "1.2156155958740125`", ",", 
   "1.269929103882025`", ",", "1.3231408623200973`", ",", 
   "1.3753697444624682`", ",", "1.4774111526335238`", ",", 
   "1.5274238105447344`", ",", "1.5768808840202857`", ",", 
   "1.67439763451566`", ",", "1.722562391921301`", ",", "1.8179745053110814`",
    ",", "1.865312732999464`", ",", "1.9124536101450744`", ",", 
   "1.9594336749689498`", ",", "2.0530401541524865`", ",", 
   "2.169684621722557`", ",", "2.2862996763521806`", ",", 
   "2.6394891665989704`", ",", "2.75940509898089`", ",", "2.880934217338604`",
    ",", "3.0044022336487797`", ",", "3.1301749441354088`", ",", 
   "3.258586132606536`", ",", "3.3900667464896177`", ",", 
   "3.525056431007756`", ",", "3.6641078348702063`", ",", "3.80783352365154`",
    ",", "3.956967552001356`", ",", "4.1124334105929075`", ",", 
   "4.27534951450649`", ",", "4.447184000945466`", ",", "4.629887921343914`", 
   ",", "4.826173653145987`", ",", "5.040021760083857`", ",", 
   "5.882380764156238`", ",", "6.350725340908905`"}], "}"}]], "Output",
 CellChangeTimes->{{3.543858494521798*^9, 3.543858516688918*^9}, 
   3.5438585551406517`*^9, 3.543862970880424*^9, 3.54386611539991*^9, 
   3.543868289447895*^9, 3.5438685955931473`*^9, {3.543993666847354*^9, 
   3.5439936958142567`*^9}, 3.5439939318822203`*^9, 3.544074480387786*^9, 
   3.544362071914113*^9, 3.544424619811595*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            FractionBox["1", "beta"], ")"}], "/", "asym\[Mu]"}], "0.18"], ",", 
         FractionBox[
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"2", "*", "2", "*", "asymscal"}], "]"}], "/", 
           "asym\[Mu]"}], "0.18"]}], "}"}], "]"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pt", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "0", "]"}], ",", 
       RowBox[{"PointSize", "\[Rule]", "0.02"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               FractionBox["1", "beta"], ")"}], "/", "asym\[Mu]"}], "0.18"], 
            ")"}], "[", 
           RowBox[{"[", 
            RowBox[{"-", "15"}], "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"(", 
            FractionBox[
             RowBox[{
              RowBox[{"Sqrt", "[", 
               RowBox[{"2", "*", "2", "*", "asymscal"}], "]"}], "/", 
              "asym\[Mu]"}], "0.18"], ")"}], "[", 
           RowBox[{"[", 
            RowBox[{"-", "15"}], "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "pt"}], "]"}]}], "Input",
 CellChangeTimes->{{3.543858532006173*^9, 3.543858575862948*^9}, {
  3.543866120565777*^9, 3.543866123276545*^9}, {3.543866190612694*^9, 
  3.5438662444440804`*^9}, {3.543866281152939*^9, 3.543866298519455*^9}, {
  3.543866333204043*^9, 3.543866334699563*^9}, {3.543866865401429*^9, 
  3.543866906245216*^9}, {3.543866960686947*^9, 3.5438670029088*^9}, {
  3.5438670353849993`*^9, 3.543867051007909*^9}, {3.543993961332581*^9, 
  3.543994031028166*^9}, {3.544074486469983*^9, 3.5440745151095743`*^9}, {
  3.544362075936994*^9, 3.544362077152089*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAAE4fhmUvp7z8lowt6fpcDQHKINMld
zO8/k7Q2TWDSBkBXc1aOza/vP1nzvSRiCQlAhgKLwjKT7z9ZT1qAAcMKQNB3
DVucdu8/SPz85t8vDEBtIS6XrlrvP+fYKFzeZQ1AQVeXZ8RJ7z+x0ROXqA0O
QN2UYx5l2u4/aEmD+0O/EEAFqlgkOW3uP5WqER+A/BFAhVctY0cC7j9aiLD8
hfQSQJt6AEc/me0/jb++SX2/E0Cm1i8G9MzsP/O31qiJ/RRAjqKse2Np7D/h
kg0G2X0VQMe4O6u4B+w/K+/5jSDvFUBTNNT/n6frP82HEhAfVBZAL4OH72Hs
6j/C5krOpgAXQKWLluTjkOo/O2PZjgFLF0AESMYz4TbqP247jBTmjhdA0mud
ATfe6T9oiG1qCM0XQMLZdhzGMOk/TIQnfME6GEC2yECs8dvoP2FfNAhqaxhA
T9PniDeI6D8FTbXFdpgYQOUSjuRH5Oc/b/9CPE3pGECRuNbY85PnP2GWlz+e
DRlAguTAtjv25j+iMeB0LU8ZQLYOoNzMqOY/fd2N7NVsGUCa1zQlSlzmP5Ay
n2ykiBlAhoD586QQ5j85zkiEu6IZQJqds4Ppe+U/tkf3wVXSGUCmyYjtY8bk
PwH1UwdVBhpA0exq00AV5D+MDhowQTMaQPmPVztCGOI/pXTrOBGaGkD4U3Xc
s3ThP1UFyyMrtBpAiWd5uoTT4D8enTSOFcsaQGCpe75bNOA/tGB17ULfGkBz
NP/DwC3fP4dzblEc8RpA/snfIjD13T9btaGm1QAbQGPASZVCvtw/g5kM8L0O
G0AdJvsx/4fbP2HvqoUBGxtA5OxMsndR2j82KyTo3CUbQAqukTWEGdk/UVFn
IXQvG0CzTtFS1d7XP9j2ZG7oNxtAf1myfeef1j/9hMTIXz8bQK1zUTPLWtU/
GqSnE+5FG0BLtVgnFg3UPxyvrF+sSxtAs4rgAJGz0j+6xCKsrlAbQIu8o4K/
SdE/EJHVqgVVG0BSTlUq9pHPPz7AcDi+WBtASs0Yq/cuxD9p/jNNoWAbQOQY
544fr7s/WgijUi9iG0CiAXk4
      "]]}, {}}, 
   {Hue[0], PointSize[0.02], 
    PointBox[{0.4871675409347695, 6.735459587446605}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 1.1}, {0, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.543994002011612*^9, 3.5439940314384747`*^9}, 
   3.544074481229835*^9, 3.544074515592431*^9, {3.5443620726317043`*^9, 
   3.544362077628162*^9}, 3.5444246204930696`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"interp", "[", 
   RowBox[{"val_", ",", "x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Return", "[", 
     RowBox[{
      RowBox[{"Interpolation", "[", 
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "]"}], "]"}], "[", "val", "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.5438621269477*^9, 3.543862159746049*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"interp", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0.1", ",", "0.2", ",", "0.3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.543862161698955*^9, 3.543862178014318*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Input value \[NoBreak]\\!\\({1}\\)\[NoBreak] lies outside \
the range of data in the interpolating function. Extrapolation will be used. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellChangeTimes->{
  3.5438621785072393`*^9, {3.543993680074757*^9, 3.5439936981244707`*^9}, 
   3.5443620876957808`*^9}],

Cell[BoxData["9.999999999999874`"], "Output",
 CellChangeTimes->{
  3.543862178507917*^9, {3.543993680077116*^9, 3.5439936981264133`*^9}, 
   3.544362087699677*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], "*", "1.4"}], "]"}], "/", 
  "0.12"}]], "Input",
 CellChangeTimes->{{3.5438634347790413`*^9, 3.543863479519741*^9}}],

Cell[BoxData["11.725740284976364`"], "Output",
 CellChangeTimes->{{3.543863443035822*^9, 3.5438634801226377`*^9}, {
   3.543993680703133*^9, 3.543993698701878*^9}, 3.54436208819565*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            FractionBox["1", "beta"], ")"}], "/", "asym\[Mu]"}], "0.18"], ",", 
         RowBox[{"asymscal", "/", 
          RowBox[{"asym\[Mu]", "^", "2"}]}]}], "}"}], "]"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.4"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pt", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "0", "]"}], ",", 
       RowBox[{"PointSize", "\[Rule]", "0.02"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               FractionBox["1", "beta"], ")"}], "/", "asym\[Mu]"}], "0.18"], 
            ")"}], "[", 
           RowBox[{"[", 
            RowBox[{"-", "15"}], "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"asymscal", "/", 
             RowBox[{"asym\[Mu]", "^", "2"}]}], ")"}], "[", 
           RowBox[{"[", 
            RowBox[{"-", "15"}], "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"plt2", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"plt1", ",", "pt", ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<T/Tc\>\"", ",", "\"\<<O>\>\""}], "}"}]}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.544074521765726*^9, 3.544074584299871*^9}, {
   3.544074962403953*^9, 3.544074962954164*^9}, 3.544075002012076*^9, {
   3.544076292022277*^9, 3.544076319164209*^9}, {3.544076682928835*^9, 
   3.544076683094802*^9}, {3.544362083536097*^9, 3.544362084984263*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAAE4fhmUvp7z9d0lOzZ9+oP3KINMld
zO8/cOhE2ADgsD9Xc1aOza/vPyDKQ1M2T7Q/hgKLwjKT7z/ViBqEXzS3P9B3
DVucdu8/vVN5oPa9uT9tIS6XrlrvP0ercNFVALw/QVeXZ8RJ7z/6PPgsiUO9
P92UYx5l2u4/+HqS25kswj8FqlgkOW3uP+V6qlCc9sQ/hVctY0cC7j/HwUKD
VEjHP5t6AEc/me0/82DQqFxFyT+m1i8G9MzsP2SL5QX2jMw/jqKse2Np7D9E
FeRLLe7NP8e4O6u4B+w/Q9lBhfEszz9TNNT/n6frP/CVmv9OJ9A/L4OH72Hs
6j8ZOV9ytSTRP6WLluTjkOo/XltzGz2U0T8ESMYz4TbqPxiPJF5M+9E/0mud
ATfe6T91r22bo1rSP8LZdhzGMOk/fdSiamMF0z+2yECs8dvoP7dukc8VUtM/
T9PniDeI6D/1hY3ZoJnTP+USjuRH5Oc/M70VQUsb1D+RuNbY85PnP6O3K7sV
VtQ/guTAtjv25j9c8FSjD8HUP7YOoNzMqOY/vvHvGdDx1D+a1zQlSlzmP23/
Pzu5H9U/hoD586QQ5j9WtfBt+krVP5qds4Ppe+U/TguWh1ea1T+myYjtY8bk
P9WvMxiw8dU/0exq00AV5D8r8zphsz3WP/mPVztCGOI/NgfkU5ft1j/4U3Xc
s3ThP7SFyK2rGtc/iWd5uoTT4D8yIwz4Y0LXP2Cpe75bNOA/vL/bTnll1z9z
NP/DwC3fP/rRq16YhNc//snfIjD13T+A0InuE6DXP2PASZVCvtw/SpA/B3C4
1z8dJvsx/4fbP7TYSaL1zdc/5OxMsndR2j9cSpVDC+HXPwqukTWEGdk/JKk+
b+3x1z+zTtFS1d7XP6HFaWjUANg/f1myfeef1j930rldAQ7YP61zUTPLWtU/
es6OBZYZ2D9LtVgnFg3UP6vVOoy9I9g/s4rgAJGz0j96jMFumizYP4u8o4K/
SdE/0+hyh0k02D9STlUq9pHPP5C8lRDhOtg/Ss0Yq/cuxD/sj/IE3UjYP+QY
544fr7s/lsECNp9L2D8dX6S+
      "]]}, {}}, 
   {Hue[0], PointSize[0.02], 
    PointBox[{0.4871675409347695, 0.3674679684184238}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"T/Tc\"", TraditionalForm], 
    FormBox["\"<O>\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{0, 1.1}, {0, 0.4}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.544074535286518*^9, 3.544074584675619*^9}, 
   3.544074958724061*^9, 3.544075002877095*^9, {3.544076289725088*^9, 
   3.544076319833272*^9}, 3.544076683699746*^9, 3.544362088849399*^9, 
   3.544424633526391*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<~/Work/AdSCMTDyn2/figs/phasediagram.jpg\>\"", ",", "plt2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.544074966367969*^9, 3.544074984199542*^9}}],

Cell[BoxData["\<\"~/Work/AdSCMTDyn2/figs/phasediagram.jpg\"\>"], "Output",
 CellChangeTimes->{3.544074985389431*^9, 3.544075026780746*^9, 
  3.544076320802635*^9, 3.5440766847326307`*^9, 3.544424637841056*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"asym\[Mu]", "[", 
  RowBox[{"[", 
   RowBox[{"-", "15"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.544074601169548*^9, 3.5440746027409687`*^9}, {
  3.54436209478967*^9, 3.544362094900549*^9}}],

Cell[BoxData["2.9185998862859255`"], "Output",
 CellChangeTimes->{{3.54407459412599*^9, 3.5440746031472807`*^9}, 
   3.544075027388351*^9, 3.544362095313538*^9, 3.544424639730958*^9}]
}, Open  ]]
},
WindowSize->{1047, 880},
WindowMargins->{{Automatic, 240}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 245, 4, 88, "Input"],
Cell[805, 26, 21943, 507, 1528, "Input"],
Cell[CellGroupData[{
Cell[22773, 537, 1991, 56, 148, "Input"],
Cell[24767, 595, 1888, 32, 73, "Output"],
Cell[26658, 629, 2743, 57, 73, "Output"],
Cell[29404, 688, 1905, 32, 73, "Output"],
Cell[31312, 722, 1884, 32, 73, "Output"],
Cell[33199, 756, 2721, 57, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35957, 818, 440, 12, 79, "Input"],
Cell[36400, 832, 1845, 30, 73, "Output"],
Cell[38248, 864, 1857, 30, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40142, 899, 2433, 65, 165, "Input"],
Cell[42578, 966, 1721, 33, 249, "Output"]
}, Open  ]],
Cell[44314, 1002, 492, 13, 58, "Input"],
Cell[CellGroupData[{
Cell[44831, 1019, 302, 7, 27, "Input"],
Cell[45136, 1028, 646, 14, 23, "Message"],
Cell[45785, 1044, 164, 3, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45986, 1052, 213, 6, 27, "Input"],
Cell[46202, 1060, 185, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46424, 1067, 2120, 60, 165, "Input"],
Cell[48547, 1129, 1865, 37, 242, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50449, 1171, 200, 4, 27, "Input"],
Cell[50652, 1177, 209, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50898, 1184, 221, 5, 27, "Input"],
Cell[51122, 1191, 183, 2, 27, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
