(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   1089831,      18637]
NotebookOptionsPosition[   1085410,      18510]
NotebookOutlinePosition[   1085765,      18526]
CellTagsIndexPosition[   1085722,      18523]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"indata", "=", 
    RowBox[{
    "Import", "[", "\"\<~/Work/AdSCMTDyn2/matlab/data/outputscanN14.dat\>\"", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"amp", "=", 
    RowBox[{"indata", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"amp2", "=", 
    RowBox[{"indata", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"aval", "=", 
    RowBox[{"indata", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "3"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vdat", "=", 
    RowBox[{"indata", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"1", ";;", 
        RowBox[{"-", "1"}]}], ",", "1"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mdat", "=", 
    RowBox[{"indata", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"1", ";;", 
        RowBox[{"-", "1"}]}], ",", "2"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pdat", "=", 
    RowBox[{"indata", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"1", ";;", 
        RowBox[{"-", "1"}]}], ",", "3"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fdat", "=", 
    RowBox[{"indata", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"1", ";;", 
        RowBox[{"-", "1"}]}], ",", "4"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hdat", "=", 
    RowBox[{"indata", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"1", ";;", 
        RowBox[{"-", "1"}]}], ",", "5"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"adat", "=", 
    RowBox[{"indata", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"1", ";;", 
        RowBox[{"-", "1"}]}], ",", "6"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tdat", "=", 
    RowBox[{"indata", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"1", ";;", 
        RowBox[{"-", "1"}]}], ",", "7"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"t2dat", "=", 
    RowBox[{"indata", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"1", ";;", 
        RowBox[{"-", "1"}]}], ",", "8"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]dat", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"fdat", "^", "2"}], "+", 
     RowBox[{"hdat", "^", "2"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7SCkzz43/ZXjhSRRIRA9UWqnBIjWXbJUBURXtEtp
g+jOwGM6IPrULRdDEJ2ma2IEord4CZiD6HOXllmDaKHlde4gepMhkxeIvqH+
wA9EPxE+5Q+iv+3QUZkPpPMCasH0rSfvjED0FL1CExCts4A7ZDGQFqvcBKZn
rZvBvApIl9RwsYPoB9c2eYHob+94vUF00Y/j90H0tisMD0H0sY1cz0F0uNEZ
MH3m2Dum1UD60/psZhA9p51bCETHiErIgOgDZ67Hg2i2aMMEED1BYnbKWiCt
niWdCqL7VKamnQDSIao7M0D0h3S9VhD9SdO2DUQDAMupoOM=
  "]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"vdat", ",", "\[Psi]dat"}], "}"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "7"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.543984427230012*^9, 3.543984494046557*^9}, {
  3.543984539074538*^9, 3.5439845497222557`*^9}, {3.5439845825203047`*^9, 
  3.5439845935600357`*^9}, {3.543984774176401*^9, 3.543984774304092*^9}, {
  3.543988524906003*^9, 3.5439885318169603`*^9}, {3.543988565977377*^9, 
  3.543988657582243*^9}, {3.54401767826269*^9, 3.5440176786543713`*^9}, {
  3.544073146648007*^9, 3.544073202904222*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJzs3Pk3ld//+H9j9nUd8zzPVISKMhRnl1QalDJUyixFSKWREpoMhQyFDI1S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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 5}, {0, 7}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.5439844452398767`*^9, 3.5439844964342003`*^9}, {
   3.543984531084688*^9, 3.543984606374505*^9}, {3.543984701484603*^9, 
   3.543984713350335*^9}, {3.543984760366481*^9, 3.543984774911005*^9}, {
   3.543984820334683*^9, 3.543984821669436*^9}, {3.543988518358531*^9, 
   3.543988658791604*^9}, 3.543997095122283*^9, {3.5440107822108517`*^9, 
   3.5440108096316*^9}, 3.544011358077922*^9, {3.544012519789358*^9, 
   3.544012553553142*^9}, 3.544012607909761*^9, {3.544012808287197*^9, 
   3.544012828958556*^9}, {3.544012945921157*^9, 3.54401302602746*^9}, 
   3.544013571357505*^9, 3.5440136363877783`*^9, 3.544013734762656*^9, 
   3.5440138903832483`*^9, 3.544014555274973*^9, 3.544015589636981*^9, 
   3.544016209717175*^9, 3.5440170916571503`*^9, {3.544017659751309*^9, 
   3.544017706944229*^9}, 3.5440730313771887`*^9, {3.544073147979141*^9, 
   3.544073203506404*^9}, 3.544073267112796*^9, 3.5440733946714983`*^9, 
   3.54407463497089*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"vdat", ",", "tdat"}], "}"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "20"}], "}"}], ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.544012567203906*^9, 3.5440125735625362`*^9}, {
  3.5440128890265293`*^9, 3.5440128891453733`*^9}, {3.544017712621891*^9, 
  3.544017718069895*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJzs3Oe3V+XdRnsVAQFBUEREyqYJSLVhRM2WmKjYHhNRsESNLTY01liwEnuM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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 20}, {-29.172809499999996`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.544012567763653*^9, 3.544012574109741*^9}, 
   3.5440128093698673`*^9, 3.544012889542613*^9, {3.544012946938705*^9, 
   3.54401302681211*^9}, 3.544013639125208*^9, 3.5440137360137987`*^9, 
   3.5440138921863537`*^9, 3.544014556434561*^9, 3.54401559358225*^9, 
   3.5440162104167356`*^9, 3.544017092830237*^9, {3.544017708263206*^9, 
   3.544017718633671*^9}, 3.544073034279873*^9, 3.544073267989416*^9, 
   3.544074635912394*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"vdat", ",", "hdat"}], "}"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "20"}], "}"}], ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.544012897498166*^9, 3.544012897617156*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJzs3fVfFOsb8PFdWEq6OxdUxMACBXUuAwwU7EARExMbEwuxsDtRMCg7sFBQ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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 20}, {-0.034872, 2.67784}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5440128980095253`*^9, 3.5440129485585527`*^9, {3.544012994198103*^9, 
   3.544013028898479*^9}, 3.544013640444996*^9, 3.544013736998891*^9, 
   3.544013893488813*^9, 3.5440145574363003`*^9, 3.544015594379298*^9, 
   3.544016211335248*^9, 3.5440730503950043`*^9, 3.544073269541218*^9, 
   3.544074636528664*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"vdat", ",", "adat"}], "}"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "20"}], "}"}], ",", "All"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5440155990723333`*^9, 3.544015603694993*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJzs3fdfT///+PH23vPZniIZGRkZ55GR7aWMzCIrI21ESkbIaHieg4SMhlFI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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 20}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.544015600311255*^9, 3.544015604215869*^9}, 
   3.544016212704008*^9, 3.5440170986436872`*^9, 3.544073061040416*^9, 
   3.544073270925365*^9, 3.544074637133007*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"vdat", ",", "tdat"}], "}"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "20"}], "}"}], ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.544015614495882*^9, 3.544015614630917*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJzs3Oe3V+XdRnsVAQFBUEREyqYJSLVhRM2WmKjYHhNRsESNLTY01liwEnuM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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 20}, {-29.172809499999996`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.544015615018466*^9, 3.5440171024947033`*^9, 
  3.544073065570938*^9, 3.54407327206678*^9, 3.544074637732126*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"vdat", ",", "t2dat"}], "}"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "20"}], "}"}], ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{3.544073068984537*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJzs3flfDe//+HHti/a9zlwzUxGVIpHdXMkaEbKllBKKrGWNIlmylaUQIlGI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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 20}, {-24.130938, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.544073069626845*^9, 3.5440732731514874`*^9, 
  3.5440746384983997`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"Length", "[", "\[Psi]dat", "]"}], ")"}], "/", "14"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.544073214046671*^9, 3.544073249331571*^9}, {
  3.5440732950980043`*^9, 3.544073295257751*^9}}],

Cell[BoxData["700.`"], "Output",
 CellChangeTimes->{{3.544073217103012*^9, 3.544073295672365*^9}, 
   3.54407463923073*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]datpart", "=", 
    RowBox[{"Partition", "[", 
     RowBox[{"\[Psi]dat", ",", "700"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vdatpart", "=", 
    RowBox[{"Partition", "[", 
     RowBox[{"vdat", ",", "700"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mdatpart", "=", 
   RowBox[{"Partition", "[", 
    RowBox[{"mdat", ",", "700"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544073289337779*^9, 3.544073331639543*^9}, {
  3.5440734188190117`*^9, 3.54407342067479*^9}, {3.5440735471045237`*^9, 
  3.544073550496176*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"aval", "=", 
  RowBox[{"pdat", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5440746254475822`*^9, 3.5440746612551327`*^9}}],

Cell[BoxData["3.190226`"], "Output",
 CellChangeTimes->{{3.544074661662459*^9, 3.54407467630158*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Odatpart", "=", 
   RowBox[{"\[Psi]datpart", "/", 
    RowBox[{"aval", "^", "2"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5440748366591473`*^9, 3.544074841089488*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"data", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"\"\<amp = \>\"", ",", 
        RowBox[{"mdatpart", "[", 
         RowBox[{"[", 
          RowBox[{"ii", ",", "1"}], "]"}], "]"}], ",", "\"\<\\n\>\"", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ListPlot", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"vdatpart", "[", 
              RowBox[{"[", "ii", "]"}], "]"}], ",", 
             RowBox[{"Odatpart", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}], "}"}], "]"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0.6"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"AxesLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<t\>\"", ",", "\"\<<O>\>\""}], "}"}]}]}], "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<amp = \>\"", ",", 
        RowBox[{"mdatpart", "[", 
         RowBox[{"[", 
          RowBox[{"ii", ",", "1"}], "]"}], "]"}], ",", "\"\<\\n\>\"", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ListPlot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Transpose", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"vdatpart", "[", 
               RowBox[{"[", "ii", "]"}], "]"}], ",", 
              RowBox[{"Odatpart", "[", 
               RowBox[{"[", "ii", "]"}], "]"}]}], "}"}], "]"}], "[", 
           RowBox[{"[", 
            RowBox[{"100", ";;", "500"}], "]"}], "]"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "6"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"AxesLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<t\>\"", ",", "\"\<<O>\>\""}], "}"}]}]}], "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"tmp", "=", 
        RowBox[{"FindFit", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Transpose", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"vdatpart", "[", 
               RowBox[{"[", "ii", "]"}], "]"}], ",", 
              RowBox[{"Odatpart", "[", 
               RowBox[{"[", "ii", "]"}], "]"}]}], "}"}], "]"}], "[", 
           RowBox[{"[", 
            RowBox[{"100", ";;", "500"}], "]"}], "]"}], ",", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Exp", "[", 
             RowBox[{
              RowBox[{"-", "k"}], " ", "t"}], "]"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"a", ",", "b", ",", "k"}], "}"}], ",", "t"}], "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"data", ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"mdatpart", "[", 
             RowBox[{"[", 
              RowBox[{"ii", ",", "1"}], "]"}], "]"}], "]"}], ",", "a"}], 
          "}"}], "/.", "tmp"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "14"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "data"}], "Input",
 CellChangeTimes->{{3.543984427230012*^9, 3.543984494046557*^9}, {
  3.543984539074538*^9, 3.5439845497222557`*^9}, {3.5439845825203047`*^9, 
  3.5439845935600357`*^9}, {3.543984774176401*^9, 3.543984774304092*^9}, {
  3.543988524906003*^9, 3.5439885318169603`*^9}, {3.543988565977377*^9, 
  3.543988657582243*^9}, {3.54401767826269*^9, 3.5440176786543713`*^9}, {
  3.544073146648007*^9, 3.544073202904222*^9}, {3.5440733114114523`*^9, 
  3.544073380998488*^9}, {3.5440734290680523`*^9, 3.544073662989415*^9}, {
  3.544073696594204*^9, 3.544073738346875*^9}, {3.544073794347787*^9, 
  3.544073840779657*^9}, {3.544073875353582*^9, 3.544073973732415*^9}, {
  3.544074005904337*^9, 3.544074013256131*^9}, {3.5440741186997147`*^9, 
  3.544074121227902*^9}, {3.5440746877893143`*^9, 3.544074735776223*^9}, {
  3.544074799249421*^9, 3.5440748010810003`*^9}, {3.5440748450168037`*^9, 
  3.544074856614697*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.25`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd2nk41O33B3D7vi9jHWbxyFaRFqHuIyk9IZWt1VKULRHahJIWURGVoigJ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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 0.6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.25, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJxd2nk41O33B3D7vi9jHWbxyFaRFqHuIyk9IZWt1VKULRHahJIWURGVoigJ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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 0.6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857048565*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.25`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw103c81fsfB/Bjr4Pj7EFSbmZD4yapzxsN3YSG0bKKsqKBikuSlJCRhlE0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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.25, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJw103c81fsfB/Bjr4Pj7EFSbmZD4yapzxsN3YSG0bKKsqKBikuSlJCRhlE0
hESLhhXS0JJ8z1Eiue1bN0o2/c69P+/3P9/H6/F5fNf7/XzreQWt8Jal0Wgp
MjTav9ev9JVrP+f0ErNv3laZO1uI75xGm8DWXqL8l/olg40tpOt1hXk3p49s
im6fGOrQQsL2F0wOcewj39IuVWRatJBR06MTBuL7yG2/wtGi31rIrtUstYj6
PpKdcDDjFqOF0P6rfuLasdKWGpKQuLwvPTEW/cRomtEe1Q8SIvvct00xpJ/M
SdnF2dQkIQd3OTfFl/STZbd9PHsqJYQx3uaexud+UnAoYLS8QEKO3Z1akao/
QP54lLP4TrqEsH4UneW4D5Ap/TNZrL0SknHi3xogpibL9hRtkRA92J+k0zxA
0m9NikxbKyFZAXJhORqDJMvWMrDBVkImsrr89ZcMktKpFUdX/C4hhTdfeeTH
DJKYYq6dqb6EmHk8cDKtGiQrqlavdGVKSFHCovkl/YNE/f7WJxRNQmb8V0Pk
3LgjzWe/icmtF7qG1wOHSMlA98+6djH5XTGbYZE/RGrJ8zkznohJZdFBharO
IRL6MbKuu1JMbFaGDlrpDBMX12zu6EUxaRjw+lbvMkweOlsmuJ4Uk0WTOiS2
qcOkzu/7StphMXn86N8aJutPH/boiRKTVdtv1jgqjZDenhtms7aKydNTvxc+
txohuryvC2q9xMR50cRTLhEjpP39u1WZq8Sk7YvmkdayEZJ64g96zSIx2Zg2
fMC9e4TMjJgeO32OmLyu3rW102SU7Fmj/6jLREx8/qtR8k9edfTQODH5v5dR
Eji6M3QlUzzmZZTMo+cF9CuIx7z8IkznvzX/HqDGvPwiy2wr3hv/Q415+UWc
uIaVNzqpMS+/SOGymfLpEmrMCw1o5zfoVD+ixvpDg3tXbbbOrqVI9KdrW2Is
aPB4hbvT6HWK1Fua+Na70GBp43xfVjFFlJNzNyiF0GB2q6Ay9CxF7P7iuS1J
pUHhtDRzw0xqzBcNgnI/hBukUmP9pEFPwbXwHQepMW80eDrB4IVGNEXsy6Ln
OirJgFeSUn7vToqkqPTPStWXgZCIE6+Mt1KEWrdlWrOVDCTcNZp0wZci/Etv
jbnuMjDN+LegMC9qrP8yUJC1SZK0lhrzKQP2WYLJ3auosXnIwNLlribZ9hQR
xdgr6zTLgO6+iIlpthRxE9+Rde+WgYDU1GvPrCly2mjuSI6GLNgMzaS5zqPI
u4jLfZ0mskCr3P7jN3NqzLMs1DjMPWIxgxqbnyxsLL926sgUasy3LFgSkJ9p
TJGPDiLqU44stL99M8KdRBGTMylPTapkIet9h/u8CRQJ6lVqCGyVBbVuo0/n
xlHkypLIOyX9sjD6PEjfUUSNzVsODi0Xz7DgU2P7IAdnEjWrN3Bw/nJgImfs
8JBJkWvaH3PLAuWgzs7JKZhBkf4gt6z+eDloi/JfslyDInPrmo9a5MvB5+RY
WiCdIlHcpSkR9XJwoGRAv06VGtsfOdiosyNsuQp6kYf8XMsAnjJ6kYfC68FM
thJ6kYdS67gHCxXRizyMOoeOv6CAXuRB/e9ZhjYK6EUe8roUJHQF9CIP6bMr
khQV0Is8HHchw1MU0Is83Iwt5sUqoBcFyH6k/VNJEb0oQIr51rBSRfSiABc8
zx5PUEIvCtBOz1JOUEYvCrB7T1TtFRX0ogBJzcvDfqmiFwUotu4xCKajFwXw
PpHtI6+BXhTA9unsWbc00Ysi+DnGpyRroRdFGD6mlr6fhV4UYdvO1wYZHPSi
CPYdnWkNPPSiCM359XSuEL0oQv+invvh2uhFEUyS6u8PjkMviiCXaNiarIde
FEHg77x3nj56UYI/Z+5rGZ2EXpQg6UCUR7MRelGCccbX/StM0YsS/HKZ5VU2
Fb0ogVuY1UD1dPSiBAXK+4QvZqEXJXAQJF75ZY5elKDPavTwDEv0ogwvHx19
so2gF2UoNozLr7BGL8qQF9D0SXMRelGGx+Kkj/5L0IsyqBsZnXtih16UIXLc
76rmjuhFGaqdzEvzVqIXZWjgXrERuKAXZTCzsck5vAa9qMA66wuyym7oRQX0
Lrdcj/ZELypgZ05PH9qIXlRA98KRaSGb0YsKWEcfd//qj15UYFZCZPyGIPSi
Ak1sfXvxNvSiAodrjHcuDEUvKmBqKn+uZBd6UYWTkru57D/RiyqM+q+32b4H
vahCb+S+5oYY9KIKIZE7nIVx6EUVbu0vH/SMRy+qkHPfZlpOInpRhdrYnWpU
MnpRBcXhOza/0tCLKtzoPvNl3DH0ogb+Oz68mJ6BXtQg2WRLsEU2elGDWG7m
8Kwc9KIGl1wVPPTPoBc12G8wvkw+D72ogYv4cokkH72owRdt7rvMC+hFDZYE
BIsdi9ELHRaqiLh9l9ALHT6GxYUmXkUvdLgdGqvILkMvdMhvuPH64A30Qofr
7zi+326hFzps33LinU0leqGDu8rx8rhq9CJ9X3HVyZs16IUOeX/7eb+sQy/q
oN93dfRjPXpRh1vjJg68u4de1CGh0+Vq4wP0og7NSVFLCx6iF3V4Ef5hX9Bj
9KIOT8ud4yY+RS/q8PJJSt6dRvSiDm3/fNqysgm9qIMTqb399Dl60YCj13sz
5lDoRQMuDWa2JYvRiwY0fojdTEnQiwb4G3bLKb9ALxpQKk7PM3iJXjRgbft8
/qxW9KIB5u97nae9Qi8a4Nvz2EPQhl40wMf0xKmuNvSiCayGc59L29GLJkzu
u+Pt+xq9aEK8S9tktQ70oglnl/7TkNmBXjRhb9F5tugNetGEMvXLkoNv0Ism
ODYGbfrwBr1owgVL/cKZneiFAYklMeu3dmJ/GPD9Wtnik9Jcs2PNdSsdBvie
Ph1bLs1eJ9OvdZowADq/uz6QZvn7jZdjLBgQrJNRdU+a87rVSvSXMMBlMYN/
vRN9McBaVHv3WCf2kwG1bsvt/DrRGwMcCr9/miLNBq23dfJjGNAp+532Xvq9
D+SHhUtSGWB65q7RYWn2mzKb/zmHASfotBITaaa7buMcKmFArwYxKu/A/jPg
uF1W7fwO9MmABW5VSaWvcR4M+FY0db2eNCdaGezT+MyQ7n+gV7S0/1P9vaJL
+hmQYVF0Xiydz7Mj2ZGOSlogfrVMSU+at1e1hHdztOBjypZ4z1foWQsyPuR5
H2vF+UnPn/RvvvMSfWuBZalV/gepn57ziZ93OGqBjMs8VVlpPvrs/geOuxZc
GZ++it1CkdlDcu/KArVgkUVsm47U3wt90ukSoQVFBrwZ48U4by3oLNodL6Rw
H7QgOlT4Rb0Z568FzjvlWgel/tdo9Di2lmkBw+RlV8czigzPnmofUa8Fx4on
/V4j3ZeTnn5LdZq1wNxctyFTuk/k0Dnbqk4t+NI+fCD4Ce6PFvhw3bPhMXph
QlBqXpTaI/TChEPb/cObGtALE7xO3zBOf4BemHCWtV5r1X30woSKz24OmvfQ
CxPiLnYfuFePXpiQOMCl/XkHvTCBJpiWMrUOvTChVnnpoo4a9MIEh2jaraTb
6IUJPU51wXOr0QsTDpcPPXpfiV6YEHrE/HFyBXphAr+d1TunHL0wIVItanPn
TfTChPm8Ywvjb6AXJhjbbzabfh29MKHsq/OnF6XohQU6Cddn7L2GXliQXvEh
wfgqemFBZkpg+fPL6IUFXqmKEyIvoRcWRJ0/H2lUgl5Y0GrQdpG6iF5YUDik
1B5ThF5YUDy61XvGBfTCAsV1dQfeFqAXFhT8XGt2PB+9sGCvq1/psvPohQUt
82ojFPLQCwseMnPuVZ9FLyyYu+GtWcQZ9MKCTbvV7s89jV5YkGB/5tRIDnph
wSuX5wp1p9ALG/pe3P0efxK9sOHyiQmqztnohQ31a5tT9LPQCxt2NUX69Gag
FzZQ4S/jHp5AL2y4Y2FkefY4emGD7Dp1jz3H0Iv0POwK1+MoemFD4RFlD5t0
9MKGC7m+7sZH0AsbhFcfruKkoRc2uNNeZcmlohc2BJu6jf5MRi9smHq7M+vL
YfTChvi3dknvk9ALG2r7D3e8TUQvbBAxB2PfJ6AXNpTaHU34cgi9cMCm2lW1
Nx69cECr7sYnuXj0wgEH3dCNnIPohQOe9V0yJgfQCwcGdap3L4hDLxy4bXbp
qud+9MKBNv+1jJhY9MKBmkc/VPL3oRcOmMo03mmMQS8cYCoGeo/sRS8c4Ohy
z07ei144MP6NnrVnNHrhQO9J+3vH96AXDmzL+ajZHIVepP+z+1AbMwq9cECk
F053ikQvHLA321eT8Sd64ULFKUnLXxHohQvtE1ewp0WgFy4snJQqiQpHL1xY
GT7ldtNu9MIFfrNloeFu9MKFZbef3YrehV64wOtK+N62E71w4WLu+G+WO9EL
F8pnxyWcDEMvXPhjmmqXbBh64YKfk7PQLxS9cKFyiE9vDkEvXPhY91suhKAX
LihkCrJKdqAXLrica80YvwO9cOEfdsv8I9vRCxcOBtA/qmxHL1wYZQ82R29D
LzyYsjvt/tBW9MKDy4HzZXZuRS88mNavd+tnMHrhwfvOnh87gtELD3595Gf0
BqEXHiiv73bfFYReeND10ur9yBb0woPEGI2rMVvQCw+Mq/Kt1LagFx6cnz4n
OS0QvfBg/v43uTqB6IUHgW8GduQHoBfp8547Lp4ZgF54cGHHDFLjj1548KiJ
znTwRy88EIWvKmjzQy88KG3T7gjwQy98GHJr+DHsi1744CBsXJjoi174MHJt
85xxvuiFD82MtQUlm9ELHwoKG1dbbUYvfLDU6Ip7vgm98EFXdCjIexN64cPN
2Wxxnw964YN1fsPqeB/0wodI2wfbtH3QCx9+rp5dWOyNXvjgZhV8ErzRCx9+
VD4zatqIXviwUmZWyYaN6IUPssorfvRsQC98GLQtXhy7Ab3wIfBW9THOBvTC
B0IV6p7zQi8CaB+ysp7phV4EkKu3JKzWE70IwCdBx9bRE70IYOKzENM2D/Qi
gNh1lL6vB3oRwEuZ22Y97uhFAPdzH5ZGuqMXAei+XPVVyR29SO+n91kku6EX
AeR4TtnJc0MvAjDz3O6XvR69CMBp6YxlE9ajFwG09Y0szluHXgRgf6mv0HAd
ehFAudrbSYVr0YsAsp8yZxivRS8C+Hthi1nBGvQiBIFziPmkNehFCEzjwOmn
V6MXIaRtWF6lvRq9CKE1SMw96opehDDquyBH3RW9CMErUqYvxgW9CEHFtNGl
3xm9CEESYlPs74xehLA5pebDKyf0IoR3b4/wljmhFyEEESWT8lXoRQiBh/fM
MlyFXoTwZu4U/bSV6EUIRfbde4ZXoBchvPXRttu4Ar1Iz3verG9Yjl6EkEDL
bp+yHL0IQfRmU16KI3oRQUB1Wdt3B/QiAo1i9aHlDuhFBFEeQ59K7NGLCB5X
bqtWs0cvIliUpdfmvQy9iMAiLvdslR16EcGenhfhHDv0IoKc8S7b/ZaiFxGw
HUXhlX+gFxHMGR89WfMP9CICB+4JmvsS9CIClRrVRRdt0YsIpjetoAYWoxcR
tIRUxC5YjF5EcKn+1+LERehFBPN1uxKaF6IXERjm+mgLF6IXbRCq1bi4LUAv
2uCnLonIsUEv2uBkSP/aYY1etMG6K7hD1xq9aMMu8V7b9VboRRumkK9NxwG9
aEPK0gkFTQS9aEMF74usGkEv2tBaWZ9vNR+9aEOyceCd0HkU+R8XKIsD
        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857056156*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "0.3356468672561849`"}], ",", 
   RowBox[{"b", "\[Rule]", "12.285208131064747`"}], ",", 
   RowBox[{"k", "\[Rule]", "3.8300713690373382`"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857063129*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.3`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd2nk4lOv/B3A7ZV9m7MwiklJ921Tq/lAUKksibaQiiiwppChLIkVJm6JU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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 0.6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.3, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJxd2nk4lOv/B3A7ZV9m7MwiklJ921Tq/lAUKksibaQiiiwppChLIkVJm6JU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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 0.6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857065139*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.3`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw11XlYjekbB/D2fTn7GtKCNMJgJI3nzhIpWqTskbTRHhUhWhVtkmWiKGoa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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.3, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJw11XlYjekbB/D2fTn7GtKCNMJgJI3nzhIpWqTskbTRHhUhWhVtkmWiKGoa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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857072596*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "0.32108430881614236`"}], ",", 
   RowBox[{"b", "\[Rule]", "8.015880752569187`"}], ",", 
   RowBox[{"k", "\[Rule]", "3.3367280334537144`"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857079324*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.35`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd2mk4lO/bB3A72dexm00qtIdKuU6tlixtJKG0ooQilUi0CFlSRNZU2pBo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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 0.6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.35, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJxd2mk4lO/bB3A72dexm00qtIdKuU6tlixtJKG0ooQilUi0CFlSRNZU2pBo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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 0.6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857081081*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.35`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw92HlYjOsbB/Bp32v2NZKSNkuoKHruZCmiiBISWVtUthIpaSFFy4mSVooO
EZH1yFKcLEd4Z8kSnSwlkQjt/eac39zn/ue9vtczzzXv3PfneeeaMQ4IW7hW
mUajZSjRaP9cP+t6LWsr+kmWbeNStKwGEjjlicvGlz/JhFqZHieigXx988fk
Ts4vkkV5npX4NJDIpN/HbPP8RXYpf4z0n9JABq0Pj+zZ/4uk1E00+UvYQKJ8
WTrRd3+RJ4Xnv9n2ywjt3+om8bLBiLONMrL3RHtXvEM3mTFz1lfXmzKiTAU2
qm/rJo61VAanWEaSo7yf7a/oJvN47yyN42WEPsLlT/22brLd7OrkyLUykn1v
3B+Zpj2kbY2bZISrjLC+l5dw/HtIoY3V61FWMpJ75J/qIfYm10+l6suIMSQd
HCbuIc9HcIb7fpOSvBCVyCL9XhK8QU+QJpUSE9bXYFO3XjJ/dZOVzXUpOXX1
1cqy+F7StIwb4VwkJTYr7y+2rpavP7z85lailJSnznKq6O4lL+rf9FUES8nE
f6uPDP7pE2iwUEquPTcyv7yxj3yt9LF6M1lK7NTz6Q5lfeS62Z4FRiOk5EZ5
slp1cx9hbZfR6jWkxMUrotd5WD9pkI70/tIhIQ96Ajru+vSTXxPuWuxqkJBZ
Zk0y18x+Mu1XonTHbQn569E/1U9qTtRPbjklIYu2XL3tqTFAEmpbp9zJkpD6
QrtTlPMAOefid0knVkK8Z5kU+kQPEL3l23xrAiWksd0g6+WlAcI3yG9pXSQh
a37r3+ffOUDSRZvWRIOEvLkZtanZapAcGgq9vctaQtb9W4NkUmOt+me+hPzf
yyDpPa56/b6aROFlkDjBy/Hs72KFlyESNAbGPmoSK7wMkXAz2YjOx2KFlyEy
plu7Y88NscLLEAk4XhUaVy5WeKGB6trf9rUfFSv6Q4OhHDhekyImcR8vhsY7
0GBSYPAntWgxuTvVKvCuDw2OatiMuxAiJprpxas1ttGgqzZ/2kM/MXF/y1vh
lkkDYpVyyd1DrPBFgwQvbzV7Z7GinzQ4XF3alzxRrPBGg+ZXN4fPMBOT+Zfi
HD01lCA4vLpnjUBMMrS6bTNNlcCeX8j6pCsmkuWh48XOSnD6LKNHQhMT/rl3
llx/JRjufcbD9Ael6L8S1Ol4m0g+UgqfStB2bZ6o5TWlmIcSZHt9XuUrpogo
fr7mMLESmIQ1DLN8QJEV0lpl/04lICNzm5bcosgxC8eBIn1lIA9EG99eosj7
6PO/mq2UoVe5xPv+GUrhWRn+Nma90yylFPNTBv3CuqiiPErhWxlU42+lHsyi
SKuHSPKxSBnyTd8FPUuliNXxjHqramWozK1aEZRIkbCfGg82vlQG1z872Yti
KFLpFlNb0a0MvBipS1okpZi3CugElGwUbKIU50EFZAz7tM4gSjF/FXj+fI0f
dy1FLhq2Fl/aqAJTlnyLSvSnSHfYirzu/SrQEbR3jNNSijjWiA87lKnAqq64
yU6LKRLLnZsRfVcFxFmNsQmelOL8qECM85qtBu6UwosqGIdfUWucTSm8qMLU
xjhRuwul8KIK0/1hliNQCi+qkHrhrVPdVErhRRWs7Z0sMqdQCi+qcN23qOew
HaXwogoXsqeHSyZSCi+q8O3Z04dzbSiFF1XgHHq8oXsspfCiBtdeey18YU0p
vKhBQJlhXIclpfCiBo7FPnl2FpTCixoUw12Vs6PRixrc2OK/a5EZelGDY66D
Weaj0IsaDHjcW2Nuil7UgGvXvMrLBL2oQdCR5o8nRqIXdYi9/eXhyJHoRR3C
FpGztcboRR3+OD77dYoxelGHJo/uxAhj9KIOFRbPJPHG6EUdjLjVkyqN0Ys6
HK2rzqaNRC/qsDJ3q9LGkehFHY5fsQ/9NRK9aEDbowySb4JeNCCJ5++1whS9
aEADlWQzZRR60YDilY+DrM3Qiwac8yyfYD8avWjA945jgiXm6EUDnmgnfDlg
gV40wDIj1LLBEr1owpBtk72tNXrRhKZV39NKxqAXTXB9637HdBx60YSyxGTl
qvHoRROOJImHvCagF00wSfdbqDQJvWjCvMbifddt0YsmWH4kDnvs0YsmnDBx
sls0Bb1ogbVn5LzxjuhFC6Zez7LnTkMvWjB4rfedKkEvWvB4ScXePkAvWpC7
3G18z3T0ogUOT54sHJiBXrTgu83mERqz0YsW1N5y1eW6oRct0C6SFJjPRS/a
UPP4aafTPPSiDXkyjUVLPNCLNrQ230jfsgC9aEO3e/DOdC/0og35xS9Kzy5G
L9rQ0eKT9cgHvWjDoVVLC9p80Ys2MEcf+KqxHL1oQ3LIPspkBXrRgeALbZJp
K9GLDpAyzaTFAehFBy7sSrYIWoNedEBDbeemnevQiw78PGZjkbwBveiAD/fZ
5cwg9CJfH/Ivyw5BLzrgaOtYkx2KXnTh9wFt7cxw9KILwszIr0mb0YsupA3p
RW7bil504SfzZZtfBHrRhfoHd0zJdvSiC5a5lw8JdqAXXegVp9e070QvuhAf
SPSu7EIv8v2tTVk7Y9GLHpSH5anax6EXPej/9cq5bQ960YN9Dz7szkpAL/LX
n76+2C4JveiBZlvkovq96EUPBJIOU/9k9KIHuyo/lb3fj170YPH9eUcCUtGL
HhiIpf7SA+hFH1SOXvpK0tCLPlTOdPtcmI5e9KFrodXynxnoRR9sy0LHTf8N
veiDg/XS9IT/vo/0YcHqDzl/HEIv+vDy/LnEtsPoRR+yqrI19HPQi3z/1PXu
o4+gFwMosvnzoF0uejGA6Yx5uxyPohcDGHsjRmiXh14MQJD2Y4NZPnoxgPsp
qdt0C9CLAeTMK3ZuLUAvBuB7quTx1UL0YgD7SvcujCtCL3RY1xwc4VSM/aFD
n7ZuZqc839669LLzMDocF+3TO3qMIgEFhy42W9HB2Deof8pxiqjWPTkf70CH
D53v3Orl+USnToWpGx1u916oW1qCvuhQv9/31KsS7Ccd3q29emBRKXqjw6W/
f4yrkefRL28NK4unw0BNxSrzExS5r9ovdMukwwIXk454eQ4aa89vK6LDtldG
OVJ51l2ymZNSQQe9dSG9Riex/3Q4bevhvPIk+qRDvyC6J/skzoMOOtodt+7J
8wHn0Qn6bXRw0F1d2y7P44ID4iq66ZDqkLRCu4wiT7PyYzw1GGATnnDNSJ63
VDfs7OQwIIfxRWVMGXpmQE9BeINNGc6PAaO6tnwdW4a+GSBpPDfbVJ67Th5o
2+rJAHW7F/ZMeT78tK6F488Al5Swsd3y97fvU3l/aSMDNjtWMmXy/NyUNPtE
M+DK/sA9Z0/ivBlwP6NYJfYkngcG1Iq07riexPkzYGJUxxUdeV6q3+X58hID
Hs74AXXyfvXbj5sffZcBu9/eMImR54JVQXOHiRlwb53HzTHyTFJKXaubGbCj
q2KtrBTPDwPOGzl+2FGKXphQNV7lIb8UvTCh/WDxqXMl6IUJhZe9nriUoBcm
HB3r+eHJf16Y4K5+Ts33Py9MeFISbvHqGHphgp7VUfelx9ALE8pdAu5RxeiF
CQes8zJci9ELE6xYjZOvFqEXJki3JI4eVYRemFC3w2n7gUL0wgTd5bMCOgvQ
CxN4EX7hCwrQCxPqEyyenclHL0y4M/zu7+r56IUJL152mS3PQy9MGLufPvPs
UfTCgsuy7UP9ueiFBX1XlZtdc9ELC7Sfn6vMOIJeWKDeYTCxIQe9sIA+aVOO
KAe9sOBeot+c5dnohQXt7udrcg+jFxZM/TSVKTuEXlgwxz/GiHEIvbDA+Neq
Gtcs9MICmrpKSsxv6IUFMweKH1VmohcWxLzLevIuA72woOPp7EBOBnphgffM
vMQZ6eiFBdcFrbqb09ALCx4ZufXlH0QvbFgSYnSj7r/nLxvOdMWFf0tFL2x4
wTPsFKaiFzZoDiYtn56CXtgQtfbciMD96IUN8Ng9/GAyemHD8NNXgi/sQy9s
SL8Wflm2F72w4XT9Dl5fEnphA7OqTjg8Cb2wQX9+eyEkohc2hA/8DApIQC9s
GL099ml8PHphw01iNLN0D3phw9nHMzzuxaEXNhjcflf/YTd6YUOalV6Fxm70
wgYr3nGaeSx64UDu/MJy1xj0woGQ6rHKgbvQCwceeRpsSY5GLxxYsWTx3d93
ohcO+IfGBj3YgV448ML4oNanKPTCgTTJMb5uFHrhwIIH66eM2Y5eOFBS8Dp8
fiR64cCHg+PGhUegFw54z9pgmLkNvXCAl+Jpf3EreuHAzD1vxNIt6IUD483i
XvRsRi/y/dL52sM2oxcOBNy42Qib0AsHxk5YNm5tOHrhwrQ05fTkMPTChdKq
7JCzoeiFC6wPvDZqI3rhQrvRHM3eEPTCBVn5jjkjQtALFy5qrI+bHYxeuDBc
Xb82NAi9cOH+3tOlhwPRCxeaFn5zvLkBvXBB6H1a1LoevXDB03X5UsZ69MKF
9MlVdo7r0AsXstUPnlu7Fr1wIWblrT/T16AXLgSt9Gm9vhq9cKH7tfR9SwB6
4UJy9BZgB6AXLrxR9jR1XoVeePBbT9+a0JXohQfTTwRPz/NHLzzYzH36+4MV
6IUHCbNdhD1+6IUHe68WbjD3Qy88OLTZTGnJcvTCg5XHan/sXYZeeLDCxt7k
ylL0woPVnX5fWn3RCw8GLhSrCn3RCw+u648pm7sEvfCg6tq9xbt80AsPtrRH
elR4oxceRBS8lf29GL3w4MXjNWfYi9ELD0wKbx+YvQi98OBUl//gDi/0woc7
6TnBZxeiFz40aA+Lal6AXvjg29w6gbsAvfAhbVn0nDme6IUPmsXWJTEe6IUP
ZEL2QOV89MIHrVFxVS3z0Asf9OaYrjKch174EHrRRbTAHb3wobH6iCxxLnrh
g8Vlv5Zrc9ALH2RbH/Z2uKEXPuhPHv7Y1A298GFZ/4Gfvq7ohQ+fLTvTDs5G
L3yY8K0itmYWeuHDtGWVEd0z0Yv8fqv2jR8zE70IwHJZ5ZlVM9CLAFQtvCcd
dkEvAug6XRD7YDp6EcAcW2XpoDN6EcCd8vXfJjijFwHEzTVLWwfoRQBhI7fF
5hL0IoCS6nvH/nJCLwJoOqPSSHNCLwIIvvclY+I09CKA8XuP0ddNRS8CaGTf
8s1xRC8CmNve2HDfAb0I4K9MteC+KehFADm6C/ZYT0EvAni6u2Sd32T0IgD9
huz4A/boRQgOTt9Db9ihFyEsnR9q8dkWvQjh4Nbjww1t0YsQSD4nb84k9CKE
H/mf8rdPRC9CKB+YbHFiAnoRglLAUifKBr0IwX9CSMbQf7/HhcBo8w2zGo9e
hFD16IrEexx6EUKWOS02bix6ka+rll08PQa9CKGlN9lKYo1ehADiPe8GrNCL
/PPY3rMys0IvQthx/InSfEv0IoSvXh1Pt1qgFyGkQlpLrjl6EUFVRqns1mj0
IgJRjGT7ezP0IoKKMt/TWmboRQTLbkW8sB6FXkTwYnPTUQ9T9CICnzD+iU0m
6EUE3ZsLz2SORC8iCDO0Hfrn/5n/exFB8GhW7rMR6EUEz99GxXQaoRcRZLyM
4RkYoRcRvG5PnGU9HL2IgH6DG+k6DL2IQKWs5dtqQ/QiAr9C92sxIvQigqv3
zeNyhOhFBDNnRc09L0AvhnDh9taA+3z0YghG7yfHNPHQiyE8PVmd+5OLXgzB
McR8ni4XvRhC0Lby8BEc9GIIF1UvWk5ioxdDEMeWFMxioRdDiGyRLVvCRC+G
UDDV3jiQgV4M4Yf4Ysd2OkX+B4MMbY4=
       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.35, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJw92HlYjOsbB/Bp32v2NZKSNkuoKHruZCmiiBISWVtUthIpaSFFy4mSVooO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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857087878*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "0.3025169473595168`"}], ",", 
   RowBox[{"b", "\[Rule]", "4.568022331699926`"}], ",", 
   RowBox[{"k", "\[Rule]", "2.767485860043866`"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.5440748570944853`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.4`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd2nlcjO33B/D2fZmapn1qlhIiPCIi18laJFFk+5YlSw9ZImskFEVos5Yn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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 0.6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.4, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJxd2nlcjO33B/D2fZmapn1qlhIiPCIi18laJFFk+5YlSw9ZImskFEVos5Yn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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 0.6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857096262*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.4`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw91nlcjGsbB/CZpprW2ZealmPJcqRwRIncVxzESSKK9BZa6Cjr4XCKREUo
2qzZE1IqlJBsJZS3ZqZpoyJb1oq0L+/jnec6zz99fh8t476/z++6Bq9Yu8Bf
g8FgxDEZjJ9fvxi4Lf14up0I03N7fJKrSeCk8unBz9tJ/f7tq0O2VpOWhny7
VnEHuXZ/10p792ryd9Qlq02uHSSewNM7v1WT/tGHhnTt7SBNyd8ih3CrydYl
Qv3Qog6iKvQR7/pURRj/fzrJcrstXe3FVWR36ue2XfadZHd9yez4lCqioQys
097USSZru94KCK8i0VvdFXszO0nvjFkbd3lXEd6g6cWcj51kIzOwqG1yFTn8
aEx+vEUXGX5olEuRcRURfk9PEft0kYcvXzb3dVSSY0d/Pl1kWHUg83xlJRkM
UbFmFV3kds+zxns5lSQ5iPX3aU43eXzJ1GtRUiUZKmxZbTG7m1y+nxbgv6mS
pN18sezirm4SzLfq+L6okoxb9mTR6IJuMmXLzkEatpUkff/MqZmd3SQy9FNg
nFElGf//p4fsuWrrfbZbRW7V/DLyRnAP6Zn76otNnYpM1D7Bs7/YQ0LGLro+
+56K3EmP1ipo7CGbfe2VL8+pyHS3zd2OZr0khjUAXbtV5GnXiuYij17Swfv2
a0KQiswc/rLKKb6X9CsiF12ZryLPSn8+vaS2WOOPObYqsnDjzfuu7D7ieDAs
J8BMRcpOTUxTOvYRcXbAMJamirjPHHrKI7SPMH7NTvvlUwWp+8xNfJ7bR3jn
cvRuKyqIX0LvHp/WPnIv6+hO1a0K0nB36/pGy34yb1VH/ppzFSTg/08/CVyc
/ilyfwVRe+knWvbxJ2WbK2gv/cQqf1Tp6GUVtJcBcnbFyIjbcypoLwOkYG3m
1kcTKmgvAySupbTOeXAF7WWASHfYMV0MK2gvDFgiT5A+6VLS58MAkbtD/J13
ShL+4fqaXfYMsDovnjaqQkmKplgGFnkwwO1R+ATOAyXROXjGl72JAaYtlSGr
spTE+bXUe3Y8A27ZG4+1O6WkfTHgxsIsVUiskj5PBuTwaop+266kvTEgytzP
cOkaJXHJDZ/symZCQ8Ph+u/eShKn2zkh3oIJaw6t+9AzT0lUXmvGVjgy4anB
vvZ1jkpilPVmlMSHCXkzLd8vGK+kz58JPm4Xak4OU9I+qX8P6rFaaKSk74MJ
hxoa5q/XVxKTXS46ZhVMOD2xUNDWryDelYUaPq1MSEoNGPH8m4Kc/XVy32mO
Bvg5XfAf9l5B3oZmdzRaakCeaa6s/LmC9qwB3pqujNpyBX1/GjAh0X2v4yMF
7VsD9sQc4WrlK0jTPBPVh9MawFRkPBlyVUEsz8WVWRZQv388N/bIRQVZ285+
GvxcA/Z+/Vbhd0pBrs7eXpjZqQFHiv/0jjqkoO+bBS2TxJO6YxT0+8CCkV+M
W+9GKuj7Z8GXdeaHK7YpyHXTpjO5wSz4wf5haLtZQTrXeid37mVB9iqvw2/X
KMjkhxWH7C+y4D6Dxa9fqSBhkj/iQotY8LVJ0mu+XEG/PyxoTnU9keqpoL1o
gq3Y1n7jQgXtRROqVV7KnS4K2osm5HvLbCqcFLQXTXgv6iH+0xW0F03YMcYM
bKYqaC+aED3C7g6ZpKC9aMIfWwxXRtkoaC+aMK+qV1N7rIL2ogkZeium3bFU
0F60wN/8flzaCAXtRQtWBR1dVjpUQXvRgtLXkQ6DByloL1rA7evzuGCqoL1o
QZ2bs99/jBW0Fy0wv9HvMU2ioL1oQX5+S72bUEF70QIdSTEvjodetGDdSmZx
pyF60YbaV2vGReujF20o+BT6DnTRizY0eBYVmLPRizZEOWR2DNZCL9pg96zD
x4mFXrRhSEri0TgmetGGVesmJfUMyGkv2sAMvrg2sl9Oe9EGt4/nV1r3yWkv
bND23K1o65HTXtjA3nw1rapbTnthw6rmAl5ll5z2wga7y8dvfu2U017YcMZu
/6NBVFZ7YUO2zYpxqzvktBc2vIj6e15pu5z2wgaL+btZv1NZ7UUHXKxUH8p/
yGkvOsCc9WPSBiqrvehAtWLP9+FUVnvRgYV17xO/tslpLzoQkjrMpZjKai86
MO2Ru1M2ldVedGDwuNviy1RWe9GBg5mLy65RWe2Fyptf25dQWe1FF464JP7R
QmW1F1249vC10RDq76u96MLE3h7HZVRWe9GFdU5bWWlUVnvRhcO7V87tp7La
iy44ZZXbeFH/X7UXXfAY/N6xkMpqL7rwhHu50IY6L7UXXZiQEFuWQWW1Fz24
PN5lwIo6X7UXPXi1rX5fDpXVXvRA4+Ya7+nU/ai96IEfd5FdFZXVXvSg5+iY
a+uo+1R70YOMKVlfOdR9q73ogWSk/obsHvSiB+Gh3TMW96IXPXC/IBBr/OtF
H27FVI/M7EMv+iBcmnDMux+96EPzpk97eAPoRR8s/sn6T+EAetGH0OiSQVsZ
2C/6UGqv6zqGif2iDw+cdb69ZWK/6AOr3t/qhAb2iwF47baUu7GwXwzAYU5t
np4m9osBWPLf3r6nif1iAHqWt4s3aWG/GEB0v9OPX7WxXwxgWNriLS+0sV8M
IEMpSIphY78YwK0ZI12n6GC/GIA0O/1zkw72iyEku0wdnqCL/WIIdgnBb+z1
sF8MgbWJmdmgh/1iCMr6cUHh+tgvhmDWWKP4xQD7xRAuWzta3DbAfjGEAIsn
7xYYYr8Ywj/vQ3rfGWK/GMIez/mz/uZgv3DAtrZtNouL/cKBmtUjN+zjYr9w
IKp00ikuD/uFA1+OvZl/gIf9woGe5EtFenzsFw4cW1mYFs7HfuGABe9d+nc+
ziMORC+1SVguwHnEAWd3cH4qwHnEhWUnQzZYC3EecSE3KjgjRojziAvWxnns
JiHOIy5YXX+R4yDCecSF+kU2/rEi9MKFCyvCbtaI0AsXDAbNgEFi9MIF50fh
WcvF6IUHXXszxpwU4/nw4PXL3lUqKt//y/OGoxkPnhhV+bKpPl9xMul6oyUP
ZpQ/vGRDZc3H5dm77Hnwqi/2rReVU1v1My1m82CsLLYpTIK+eBCVMqz+hATP
kwchByxScyXojQfBeboHn1J5xPN7Zhd38eBXszunaqj8RLNXNjueB8stfXNe
U/lPa1ujj6d5MIu1cH8TlQ0WbxDvy+RBj75j0s+sPn8ejD/Rdffn96t98sDt
5taZtRK8Dx5MFv7ZVkLlGMcREZyPPNB6wvqaR+Uxq1eEZ3by4HbSueenqSxP
PLHdlc2H9VUT0yKovLGgOqRVzIdpNhFxvhL0zIfE4twSBwneHx+CG9lKoQR9
82Fn2Os9b6nzbLsQ8/EvVz709cimXaXyIfnj92IfPtRN3+kVQmXbHtbb3GA+
BC5UGQCVayxIo0coH6wfT3djiPG++XDle+nufBG+D3xwt37L3PTv/fNhcfGY
qpFU9uS0uT7P5cOl5oNONZSfXtsxLqFFfHC7fvxBJJVPLv/zD7MK6u+1Ttnx
0x/Zd96poJEPJ7bMmaEU4PvDh0G8hvC/BOhFAMnWnu4CAXoRwI3fUyLT+ehF
AKlvakdM56MXAdSH2Gyp5KEXAeSEjy4J4KEXAaT4lO/7zkUvArhICgy3cdGL
AJ5PsSz5+b6qvQjAkSHT2c1BLwLI92xqYnPQiwCcstm7Ig3RiwAqT81ZxTBE
LwKw9TVL32KAXgTgMPZExxd99CKAxnmRL5bpoxcB+E9pNpLroRcB9JcY9k/V
Qy8CGFnH3Jymi16EkJ14N06oi16EoBq6qmerDnoRQqq0wL2ejV6EYM3lNAIb
vQjB18bX6Yw2ehHCm6MRRwa00IsQdo5YsG2pFnoRgo95c22OJnoRwo5UNxlH
E70I4eDNWc/8WOiF+jy/z2+9qYFehOA8M6zZQAO9CIGl07LEm4lehLC4cn7Y
FQZ6EYJ+39THvdS8UnsRwobiQbdmD+B8FsIDc1eTpH7cX0TQ6zPYqqEP57UI
jhgbfRlBZbUXETSvadNZS81TtRcRXGv3982h5q3aiwikTf5ru6n5rPYigoHB
UyVTu3HfEcHQmoi8Hf/OdxGwS6/Cg07cf0QwYpp/hgaV1V5EwG11MZxG7Q9q
LyKYVBvduIPaN9ReROCYbONRQO0nai8igGNx7d1tuA+I4J+8zoKJ/+5LIghx
KL2+/jvuByLYsepG2eVvctqLCKwv+C592yqnvYiAc+e0oTmV1V7EkFSyvWFR
i5z2IoboAAfTmGbcr8RwIlr7wcOvuE+IYewhQVnXF9y3xNBTt7bTmspqL2LI
clgv8/ssp72I4fgxc90jn+S0FzHMZc3+UvJRTnsRg0uB49iBD7h/iGGOw+Ko
cR9wPxMDs3L8M98m3F/FEBJek5f0Xk57EYPn35y+R+/ktBfq8/kcO9LxVk57
oX7eO/KXkW/RixicAyfPWPwGvYihZQhfZ89r9CIB/TerAm40ohcJFEckid+9
Qi8SsLlQd0n0Cr1IIJuXYj79JXqRQIVnjNX6BvQiAZdkw8iT9ehFAscmBWmV
1qEXCdw8mmrW9QK9SKDx8PgHw16gFwk8nLX39wXP0YsE3JSjUrbXohcJmOmf
jE+rQS8SKOv9wKmsRi8SSKi85c2sRi8SKAwaXja6Cr1IYOoLywiPSvQiAS9p
ou5OFXqRwLJ664z0CvQihcgin5pKJXqRgoq9P4ahRC9SOPjEgTNKgV6kEHXF
Ps1Njl6k4CaxLQ0tRy9S8D47Ne98GXqRwotRbsH//S96oXKLVUf7M/QihU31
EzvNn6EXKbxMlfFnlaIXKUzbzs1YU4JepKDFIAsOPUUvUpjt3DrizhP0IgXd
7krhm8foRQrDWn481HuMXqQgTii2HVeMXqSwmqEY7fEIvRiBqvb18G1F6MUI
5p+/dfBsIXoxguZrbvnFD9GLEXyOWH3p8wP0YgR/tZV48B+gF+r3EefiCffR
ixEE6GW9WXIPvRjBhni9ndvuohcjeGchKD1dgF6MYOM39qjCO+jFCDzuzGt4
l49ejMAz6b2bbj56MYLY9ODxlrfRixFUzprAn3sLvRjBGf8lS9bcRC/U51td
vuxAHnoxguRJ9bysG+jFCBKKFwnLc9GLMRSH2I1qyUEvxiAPy4zn5qAXYxg+
P8jP+jp6MYZ2jfgXztfQizEsbfnmuvoqejGG6kH3RdHZ6MUYTjTf3ZaahV6M
YZLr2XkPM9GLMTwt3Xy54Qp6MYZ7Nozingz0YgzPo/hjpRnoxRjmvUnY8ls6
ejGGm4EJCufL6MUY3nyy1V+Zhl6M4Xyt86Idl9CLMXxctnHb0YvoxRiC2nit
2RfQiwweX//g+DQVvcjAK+xS3avz6EUGB+LGF3amoBcZZJV5WnNT0IsM6l8/
aLQ4h15kYNCru9H+LHqRAU8L2lzOoBcZ9Iz94ep7Gr3IYO6VOtXmU+hFBlt+
OzNh70n0IoMf3nMik0+gFxmk7C5ddCUZvchgQt5557vH0YsMHvl9NSs/hl5k
4PClQfTyKHqRgeeOmoDmI+hFBoHNn7z6D6MXGWiWPjU1OIxeTGCkiBdnfAi9
mAD/gnXE8CT0YgIpjw+X/ZaIXkzgY+cnh6kJ6MUEhrJ1ypzi0YsJtLcfE7jF
oRcTUEWf3+J1EL2YQHheSLXfAfRiAtp/x30IikUvJjBi7Px5f8WgFxMIPR5d
+c9+9GICpsOasnfsQy8msGSvhTBqL3qhvj9iud3eaPRiAnePhxnG7kEvJhCU
f0A3bjd6MYFcv00eCVHoxRR6zGKPJkaiF1PIuKBplRSBXkzBPcx6WtIu9GIK
sVMXzknciV5M4cdQXWV8OHoxhaCytrkHd6AXU5DO3eMUE4ZeTMF2aqBW9Hb0
Ygoy/ZnrIrahF1OARp/k7aFy8j+VmIn+
       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.4, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJw91nlcjGsbB/CZpprW2ZealmPJcqRwRIncVxzESSKK9BZa6Cjr4XCKREUo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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.5440748571033363`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "0.2787494669020157`"}], ",", 
   RowBox[{"b", "\[Rule]", "2.3822830081988204`"}], ",", 
   RowBox[{"k", "\[Rule]", "2.1534152771886648`"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857110013*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.45`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd2nc8lt//B3B7773dw0dDoqko562kVEIDpax20hCF0JCGUKShEJVIShRl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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 0.6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.45, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJxd2nc8lt//B3B7773dw0dDoqko562kVEIDpax20hCF0JCGUKShEJVIShRl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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 0.6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857111823*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.45`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw112lATevXAPDmeTjzWBQhkoxJ0bOQCCljxijTn1JuIg0yD1EhY2gg0+1G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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.45, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJw112lATevXAPDmeTjzWBQhkoxJ0bOQCCljxijTn1JuIg0yD1EhY2gg0+1G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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857118566*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "0.24801339851858062`"}], ",", 
   RowBox[{"b", "\[Rule]", "1.2341362220515122`"}], ",", 
   RowBox[{"k", "\[Rule]", "1.550132486872732`"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857124967*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.5`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd2nc81e/7B3Bb9jz2OEOlqChpcl+UokmLEJI0VUhTU2lJRX2aKmloaGpJ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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 0.6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.5, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJxd2nc81e/7B3Bb9jz2OEOlqChpcl+UokmLEJI0VUhTU2lJRX2aKmloaGpJ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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 0.6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857126725*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.5`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw103lYTfv3B/DTPJ3qzGO5XCEyFMlYnyWiTJkuqZQSCaFCIWOEpCguNzLl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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.5, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJw103lYTfv3B/DTPJ3qzGO5XCEyFMlYnyWiTJkuqZQSCaFCIWOEpCguNzLl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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857133608*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "0.20767547521617014`"}], ",", 
   RowBox[{"b", "\[Rule]", "0.7388976983676568`"}], ",", 
   RowBox[{"k", "\[Rule]", "1.0516136090969086`"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857140264*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.55`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd2ndcze/7B/D23nXa44zMkFJSxn3lY2VGFEL4lJWMyEgKyYg+RIiGtFHS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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 0.6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.55, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJxd2ndcze/7B/D23nXa44zMkFJSxn3lY2VGFEL4lJWMyEgKyYg+RIiGtFHS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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 0.6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857142063*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.55`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwt1Hlczfn3B/Dqtq936d7ukiGVIrQoKfE+WZoaSyGFyK5JwqBsKSRLGEqa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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.55, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJwt1Hlczfn3B/Dqtq936d7ukiGVIrQoKfE+WZoaSyGFyK5JwqBsKSRLGEqa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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.5440748571489267`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "0.15312358510505822`"}], ",", 
   RowBox[{"b", "\[Rule]", "0.5559984484682567`"}], ",", 
   RowBox[{"k", "\[Rule]", "0.6964553665076159`"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857155529*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.6`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd2nk4lP33B3D7ln0MY59FK5VWT1Gfo6K0aqO0KC3aKOIpkSVSkbJrz1JI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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 0.6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.6, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJxd2nk4lP33B3D7ln0MY59FK5VWT1Gfo6K0aqO0KC3aKOIpkSVSkbJrz1JI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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 0.6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857157233*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.6`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwt1Hk81Pv3B/Cx72PMmMWgRWghVMrN9j7tVxvVlVS3RZaolNItN620r2i5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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.6, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJwt1Hk81Pv3B/Cx72PMmMWgRWghVMrN9j7tVxvVlVS3RZaolNItN620r2i5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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 6}}, PlotRangeClipping -> T\
rue, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857163808*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "0.07430111330932769`"}], ",", 
   RowBox[{"b", "\[Rule]", "0.5111406866745988`"}], ",", 
   RowBox[{"k", "\[Rule]", "0.4485314844432623`"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.5440748571702423`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.65`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd2nc4lf//B3B7ZO9jnyENRXup3i8tLaOpUhkpIZtQUqKSUcioNKSSUMje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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 0.6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.65, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJxd2nc4lf//B3B7ZO9jnyENRXup3i8tLaOpUhkpIZtQUqKSUcioNKSSUMje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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 0.6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857172028*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.65`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwt1nk4lfn7B/DjcOzLcfaFiRKVommhqD63Vi0iLSqVqMZgUEnxTRppD6ks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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.65, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJwt1nk4lfn7B/DjcOzLcfaFiRKVommhqD63Vi0iLSqVqMZgUEnxTRppD6ks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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.5440748571791*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "0.015683160939957638`"}], ",", 
   RowBox[{"b", "\[Rule]", "0.5713573207951063`"}], ",", 
   RowBox[{"k", "\[Rule]", "0.39778168399921465`"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857185678*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd2nc4lf//B3AzZI9jHeMMJWmXNu+XhuzISoMolUpFUUoaQimy2mRFCtmy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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 0.6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.7, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJxd2nc4lf//B3AzZI9jHeMMJWmXNu+XhuzISoMolUpFUUoaQimy2mRFCtmy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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 0.6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857187468*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwt03c81e3/B/DjGMd2nOUMKlGSSu7SEtdbQ6Kkga/qpmiXxh1KSUMlddtF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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.7, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJwt03c81e3/B/DjGMd2nOUMKlGSSu7SEtdbQ6Kkga/qpmiXxh1KSUMlddtF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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857194284*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "0.0005356889931389284`"}], ",", 
   RowBox[{"b", "\[Rule]", "0.6558292367081711`"}], ",", 
   RowBox[{"k", "\[Rule]", "0.4549918768901585`"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.5440748572008047`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.75`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd2nc41f3/B3B7xzGOYx3OkIbG3ZKk3i+raEhkpYhKpRQikpIopVQkaRCZ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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 0.6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.75, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJxd2nc41f3/B3B7xzGOYx3OkIbG3ZKk3i+raEhkpYhKpRQikpIopVQkaRCZ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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 0.6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857202592*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.75`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwt03c41u37B/Db3tx70iIlpR2pp+uUEd+nNJFUolIpFZFISVaUQpIS2St7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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.75, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJwt03c41u37B/Db3tx70iIlpR2pp+uUEd+nNJFUolIpFZFISVaUQpIS2St7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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857209298*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", 
    RowBox[{"-", "0.0013956877924734643`"}]}], ",", 
   RowBox[{"b", "\[Rule]", "0.75469118286818`"}], ",", 
   RowBox[{"k", "\[Rule]", "0.539436423635021`"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857215805*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.8`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd2nc4lf//B3B7772dIdVHJYkKeb9QoihpGZUVDVREMiojKTSMVEgUUla2
hMhKJXuXSmZpIDKK3/l+e30/f/zuP7ie17nPue/zej7e73NxHar9CXNHFiYm
plLGj//8/v+Hh8Gu03N6V4iu8gom0dFOEl/hYVWkd4d8vvbj6/RIJ1FRa9xq
NZ5Cmj+vjphjZC6WQyNdeplk6U5quCDj/FNHfz9XMc4l5S9KO1RG/3d+ASk3
ohYbMXLs7f8cT0jGncpR+9H/Pb+MCC3vPXmGkT8cki1m9awgdhT3hUuMLHXb
34Zu/JzsfLlNMJqRdzQMchjIV5ODZt9exTLyReZtWfbjNWRm8M6LO4xs77h2
wrumjiwtlr5359/r1RND/Xf+cYzc3LAAT1xfkXuSD37cZORMtZELTXoN5P2e
lW8iGXnA0XTFD/FGImJ9rDuckQVMu0c5PZvIw5oYw4uMvHw4rEzSpplsdV/r
ev7f+2shqvNPp7wYWf2/RyvZ0nOq6uS/99tGyK/O8iOMvPF8T9p2znbidnZi
rx0jW0pf8Ts43k4CbFiYrBjZI4+YHe/tIFSm18HmjHzddIJ+rqaTuM3GvNrG
yOcWh2ouZ3eRBc+klM3/vr9uwgpZBBi5QN3E9WFQD6lv0IvQZuT7gyBY4NpL
FDdbz61j5GfnJ/ur970lm9zmZDQYuVc6tbBN7x3xOaeQp87I03kWoQMqfUT6
3aVV6v/O4z2ZFpg7s5aR/yr5QKJHvvlo/jufD0RM7HD0BkZmT20t4f/8gYxe
oEdsZGTRyYxkcZuPpDTPfrM+I1Ph4lX5to8k3s5hcAsjr7pic2aJcT/R8Rl6
a8rIS4YsjVXK+0nql38qdv87z0+M+1p9bT8j6/nzyWunfSLztusWnBh5fTfH
N5AfIEsPsXh7M7Kh8odOo8gBoq8gdymJkXefelJpxjlIfn7ZWsXymeGjIjLd
wm+QnOnKbpv8/L/5D5KVyyUe6n7tJE7/PYYIhUNiKnHif30MEb9wEfUXC53E
mU+L6mE2TFhX6eaJSXcRb0tRXr+aYaK7mUklbkcXCUkd+xmkNUK+hSZojz/t
Ijcma/rCskdIUbG+ybbQbhJuUpEdoTRKuHdN7djC2ov9jZLB3w2jnTffkQdD
7kFJAp/JzvHJYcPpDySBuO5+EPSZtHmXhsweHyAZ4Ya62TOfia11xijT01FS
0q24rMj1CzEYT90Rk/eDvFCeFX7W/4VIfD9f8+vXFPY9Rvp5P9wub/pNGl7/
5xgj3UHK62bjWeBv/19JmmvjdKYPJ7S4J4b0FH4lRk/zkkor+OD9M2+3fpVv
ZNlTIQ81TmH4yrfL+nPiN+I2OqItcloU5i1XbJ4Q/05OjaXUiR8Xh4lcZYmZ
0O9kT4bpUa8iCfjr5QeRgUSDChVJ+DufHyR++cUejTIJYGk9+o7D8we5ELtF
MspbHC57720Jzf5BTM3tdUxCREGIYlAn8PkHmYBsCUUFYbhZq1oaqTROKI+U
O7tn+eCvr3FSzOQV1VbOCX/nOU4KKN+ufPzCAn+9jZNDYXlnjgT9IfEurF6J
AhNk1OixTEL5NKGL/nBWMp4gh/uXHHkfPk4ePXlrmxY0Qax7FRxWXv1C1Gzr
96wonyBOabzhBtZDOP8JojOfJZwx3o8+J8ncbc2DKa8+YB+TJI5Sv858po9o
ctwR0kqbJO1ENFrT6R0py7jMXt4/ScKvHzzM7PGW/He7lf9JRhbqHr3r7SUv
Z+2/1+z7SYoGPoiYn+pFzz+J6Xic5ntqL/b3kxRHuhxa2dODvqdIRjF74ckb
PaTxruajVr0psnzPlhvnzHrIXkP63X1+UyS/acxLmKeHvBsTjO4tnCK13nsL
miu7yaGo35dsxqfI4dJNvB1e3eRv39NEsuhyrd2KblwP00TneExe7fsu8rf/
acLD8rjHIrKLHN3QZODaO012+fz458imLvLjfen6cfFfRFKPQ193upN4XXy4
0tPsF+GuNcuUS+skCytiaLOhv4jE6ECHrlUnrp9fxHvRoq6T73/7ywxZEr/U
VayiA9fTDFHcd0xN1qOD/PUyQ5zXVz/jXd5B/nqZId/XrTRiet9O/nqZIdYZ
eiqCMe3kr5dZIrXDh2q0vR33o1liKB9n9YSxD//1MkveXAxgdn7ehvvTLGmQ
+zPvcK4NvcwRiwbq8APtNvQyR7JeHT22fq4VvcyR2Lb798RKWtHLHAnOm9+o
7duKXubI6bDEprSNrehlnqxSWZFiwdyKXuZJ290dMYa1LehlnojRo4ZcwlvQ
yzy5I1ipWbOrBb38JsaLbwyM5VrQy2/y8VxzwsRgM3r5TXJ23ZYqedyMXn6T
M+ONnrf9mtHLH+LymHhdNm5GL39ISs7w1iDJZvTyhwy45jv6DzWhlz/EcuRc
i3dhE3r5Qxgf3yVHQprQywJRMyqrNrRsQi8LZEb57mv+FU3oZYFs1og6dnyx
Eb0skO9RznreaY3oZZE4qAYXr97ViF4WSXtme+qlxTfoZZHsl3BWPZ35Br0s
ElmL5ZJf979BL0zwPWLYq5//Dc6HCa7lPDA3qWggAaP5x4O0mCByg7MmxaOB
1OioHK3ZxwSKpUVz5ssbCNf1JAdOTyaQGvrK/vb9a2LySfKgcSQTHC4MVcq5
+Rp9MYFCfsP9F2avcZ5MUPqQO0ua9zV6Y4L9RpcM4mpfke2FAdpmnMxg+yFU
dHPQKxLBPaMRqcQMHJbGuwX1XpH2/cdXt+kxw6JIAIwvviRSjwf+kbBhBsH9
zn/6n73E+TPD3mqTje/8X6JPZpgMDDHv0n+JfTBDpvmf2gb2l0Q2aDuXfBsz
aBzkzSmorycHO6pZbMaZoUlE4NHlq/Xk3nLtP4kCLGB27U/Gpt31ZNAv51e/
CguIqbZV98nUo2cWKGrQe7Kz/wX2xwIbnTUTbz16gb5ZYOxOM2SeekFGdsi2
jyaywLPVIiWhG18QlfsRjSrlLHC8b/v0P1wvyIlpzpeuvSyg+U/QvcutdSTX
+Fx19gwLSKRuK068W4d9s8LL+RUXXFzqcD2wAit3SNzwhjrsnxW8VFcs5eeq
I/lyI0mFrqzQ98kqpLujlsycOBg/E8oKn99ZDG5JrSXaVW0xWmmsYJtlRfac
riXnJbZF+NWwws6YJtXfhrW4fljBxTMiaYNULXphg6hxJkmezzXohQ2U+940
Hi2tQS9ssKyDWrL7Wg16YQMHk9CJF/Y16IUNOooNJRkrEr2wgZxlDKsObw16
YYOhNSdGND5Uoxc22H9l0Ty9oBq9sIFW0pBtbFg1emGHXuqWLCb7avTCyPFu
dt3rq9ELOwin6EYrCVWjF3Y43fKm7N1wFXphB/HOF+fYKqrQCzuwUp2Yo29V
oRd2SP+kwhbuVoVe2GFN68mi0a1V6IUdXj1Ykp+uVIVeOEA743lLw8Jz9MIB
8dtzz5p1P0cvHCB06JujWv5z9MIBW19f73W59hy9cECUTG8Pi/Nz9MIByw6f
/TVu+By9cMA1I6vzmvTn6IUDOPZdK2tarEQvHGC3/M+18reV6IUTTC6LUxae
VKIXTij8tfb2lZuV6IUTzpy1S3PxrEQvnNCYnZJ/a1cleuGELSsCXYXXVKIX
TsiwEmNtF6pEL5zwc+eYY//3CvTCCZfDfKvXNVagFy4Ar8On2rIq0AsXxLo7
shddrUAvXLAndoC773gFeuGC95soOsY7KtALF6hXZ5dPq1agFy6I9qYuDApV
oBcu6H5fK6sy8Ay9cMFdm6Rg7gfP0AsXvJb1tTx07Bl64QZBJu+0DaueoRdu
6LDQJaET5eiFG7LYfa+bFZWjF24Ils/6EO5Xjl64oZtVbXSjfjl64YbEH0er
bbjK0Qs3WCZrk8k3ZeiFG56yJk5P3ihDL9zQl6FufOhAGXrhAe1Twps3LilD
LzzQr9z3KfBrKXrhAc8io5LVhaXohQeeMlXJbD5fil544HEi8+Izo1L0wgOV
QRocd0VK0QsPBMocn/nw9il64YEvA5IDQQ+eohceyC8Stgxxf4peeGGsZeLU
6Man6IUXjH+LsqRzP0UvvHCqXMOkrr0EvfBC0P6sAN17JeiFF5SUGoqFT5Sg
F144eKzwt7ZOCXrhhZ4vE61l3CXohRcuDsrW3ex8gl74wGIZl09NyhP0wgd5
Qa4fjTyeoBc+aHJa8VDe4Al64YM93ikOm0SeoBc+8ON0SS77WIxe+EDFu/r6
xZxi9MIH3vk+Z+MDitELH7jMc2UwmxejFz6o/Xhidx6tGL3wQ+YaFc3cySL0
wg/eYbvbZquL0As/tD+svhEeU4Re+MH1qnvd4SNF6IUfdj196B6qVYRe+CHV
4sbmKb4i9MIPZZpW8/ffF6IXflihx3stNrcQvfDD+rOv6K3BhehFALIeJMuZ
WRaiFwGw3LztgtDKQvQiAPluwR+EmQvRiwAM/1Oss6u9AL0IgEffGf/2hwXo
RQBiFbKFY84VoBcBmBJxyL6xqwC9CIDuzPOo1mUF6EUA5ufAznQhH70IgiiZ
1mNpy0cvglCXntw68TAfvQiCZ1g/Rd4/H70IwqW8iLiAvfnoRRCe/foep7gy
H70IAntvi/4kaz56EQQHjuFUpt489CIIXQY7pg1y89CLEHgkDFFKL+fhfIRA
9TFL8DG7PFL5n3+/yAuBvXXBCZMNecQ+4UZ+v4oQyD7YuNNBOI+wvWjKCdIS
gi8Cxp4Zo7kkdZw3W8lYCGb4cw8vfZ6LvoRA0IcstMXm4jyFYM2PojV5p3LR
mxBEVw2mVprkkqW9FfJpQUKwtadpPbNyLqln+y1jHCkEqRvT6ScWc8ixVeuk
PicKwY49A4O83TmEz8JdPCxbCC6m9I625+bg/IWg5t2HmobwHPQpBKca+lwm
nXKwDyH4VrZhyEAvh1zRW3pB4LMQRJRnX6uQzSGqzvYB2TNCkD3+o/ro9GPS
HH3nnBnj785Kk+3LdZofk1PlXb7j4sKwm+6lsCHjMXoWBq9kzrO2IY+xP2Ew
Ys5hzbF/jL6F4bvKp4jluo/JzwdXPnuYCYP0K0P2V9KPSUzzi2FxG2FYI5qz
c/mXbLJunnWw0FUYmGztJ3juZ5NuJdK/z08Yukw3H9K2zsa+hcEwxOhZsWg2
rgdhGFjsKbrwOgv7FwaTI7ZDscFZxErgp1lvoTDkdd5JXNTNIr/XqW73qxEG
sbdbb6XPZJIEu2Pb5NuEocBD9l1ybiYhYSlG5f3C4L9/k8KwSyauH2HYMks7
5rk0E72IQFT860Xj/gz0IgL63zx5jtzJQC8iIGY2tbTZIgO9iIBMmtqOALEM
9CICvL9zI880paMXEZh2l24sDk9HLyKQpG7ft9E4Hb2IQFPex0Q+jnT0IgKv
16kFL6l6hF5EQOlqw/NA/0foRQTefh3XWab7CL2IgHPVoRfivx+iFxHoTFqa
ZFLyEL2IgGb455f1Zx6iFxG4/2LwTMS6h+hFBHRv/kxOnE5DLyIQnmhRM1uQ
hl5EYC5Osj3WMw29iMJm1jLdEI009CIKl/Q6WJ5NPUAvonDQy4mLFD5AL6IQ
25KcKuD1AL2IwsDyLI+l6x+gF1GQFL42cXU2Fb2Iwpd0awe9p6noRRQ6wsZa
Dc6mohdRGJYvTbpBUtGLKOw6NtulyZKKXkRB6pTttWU1KehFFDRKBVe5XEpB
L6IwIzYZyWaSgl5E4WRlsdY3wRT0Igpqz/m3/NOWjF5EYXGb1J7yW8noRRQe
dX8/8PBAMnoRA9+FKy+HacnoRQy6Obd0BIzcRy9iUOgWtdQj6z56EYO6IEGe
Co/76EWM4aNO9aj2ffQiBgJ211KOs9xHL2KwPGvkfmP9PfQiBk62feeuRNxD
L2JwpCA0NcvyHnoRY+wHHVdW0u6hFzEYCU+4K/QlCb2IQewbgdvm+UnohfH6
vgZFs2eT0IsY1Mx5vmY3SkIvYiB1iL7gKZKEXsTA3yq+w+RdInoRgyXBHnFh
aYnoRQwuTL1xWO2RiF7E4b3dXk4CiehFHFgW2nUK+BLRizhMyZgNrsq7i17E
4fZOY7vXpnfRiziMiPFL6YwmoBdxECjfyBEanIBexOExM4t1Ni0BvYjDJBcc
yq64g17E4Uk8y8VwmzvoRRzSnR4NGy7Goxdx+F18MKz/bjx6EYedgfOJFnrx
6EUcHHfKb8j5FIdexOHGiCrbl4tx6IVx/xyxa1lV4tCLOKypCdNnaopFL+Jg
yOKm+MkzFr1IQPHluOr7crHoRQJS9+qzGFffRi8SUN+cxNvmchu9SICzXuS4
vsRt9CIBVmosq65W3EIvEiDxVgmqnG+hFwl43n7PoUfyFnqRgJPF773bq2+i
Fwn41aDHm+d+E71IQOUbOx536k30IgE81qZrZZpj0IsEcMb1ZCYExKAXCdBR
rYljU49BLxIgJublvG3wBnqRgOvXaHzut26gFwko6+r67WVyA71IwMfRS0E2
zDfQiwQw+xfWKBZFoxdJ0NzAtfWpazR6kYQdQ3Wxa5dEoxdJEFr2rT/sXRR6
kQTn3lsBRTFR6EUSSnwPTZeZRaEXSfh1y6HlLm8UepGEe9671bbVRaIXSTBP
ZfvYGRSJXiTh7qB8+Uq9SPQiCSaCJausFiPQiyTcvGMuYlEegV4koTBA7qDS
uQj0Igl6kS2CJboR6EUSyoULTssxRaAXSahLNhQxfX4dvUhClyZHon7wdfQi
CXTecsE/RtfRixS4mSXkBPBfRy9S0OCbXR+dcg29SEH/fjfzu2rX0IsUbO/+
Ubf62VX0IgWWzlxzBtuvohcpWLPX7lNV3xX0IgXhG52pNSevoBcpuBapMruG
7Qp6kYK+sK82XLfD0YsUcBVceLBPNRy9SIGytvPDxdow9CIFzu3bE8Rtw9CL
FIjBk9jIuVD0IgUOvlZ8VjGh6EUKPITUaZfUQ9GLFJgpmwfzt1xGL1KQHmrx
qsPtMnqRgkBHrZxZkcvoRRq0qEvkHAouoRdp8KtSNeG3vIRepGGIg7qVeSEE
vUjDspuHm1Ymh6AXaciI4o6M3RaCXqRhXkrEQ//nRfQiDQd+RSRREy6iF2mI
0o9mX2p8Eb1Iw+2yJ8pHpoLRizSMWHCsr70XjF6kQYRq9nLrzmD0Ig2H+/NV
J5iC0Ys0aPblfCrKuYBepGFuLNk+1eECepEGrsvtHQkSF9CLNISmKR5KfxmE
XqRhCh6WtJ8PQi8ysHrGicakGYReZMCGuT9X72sgepEBT+rwmF9KIHqRgeZN
+bb1BwPRiwzQI2cfc0sHohcZmFEA5T1tAehFBj7FXIKr1wPQiwwoqZZFVpgG
oBcZ6J555D/CG4BeZCB+3mqG5ZU/epGBSoNtzKxh/uhFBiJvLmv/vs0fvcjA
pjgd0Zf8/uhFBkbOHg1iTjqPXmSAurv2oM6y8+hFBvZZ2FJVcs6hFxk4Iipe
VqN9Dr3IwNLo28FKL86iF1lwTj15W2nvWfQiCxeWJRu+GPRDL7KwlzfwF4+X
H3qRhZe7D/4a5vZDL7LQIT/obpXgi15kIT1abp39Wl/0IgtOqp+7pl75oBdZ
SKxeuMrk6INeZIH2/s/yW4ve6EUWqkZ/yd6O80YvsrDh9OatbBu80Yss1F+R
nf3ZeQa9yEKzY4zTljNn0IssOKZX3GCVOYNeZMEiTUZEuswLvciCUcgl1+t2
XuhFFnqyLRM2c3qhFzlYduLFbs+s0+hFDgSznKT7955GL3LgsFlW+BLTafQi
B0H+xsoX0j3Rixy4LAwU5OzzRC9y4BhUc0OO3RO9yIGR6p+AJ3ke6EUOhHj2
S1xx8EAvcvDg/jhvtJgHepFj7D+vtz6vPYVe5OD8t5+NfD6n0IscyInw+/qv
OoVe5OCN7xd9ngF39CIHYdvpLc9i3dGLHORG7T0QbO6OXuSghamxdh+vO3qR
g+U3et+q17ihF8b1+PNCKf5u6EUeulM+2M9ou6EXefDqPuYzOHMSvciDWqfv
j8bCk+hFHvzsBhdzPE+iF3ngKHHWT9I4iV7kQSMpduT72An0Ig/fXi9Z6nTy
BHphPH/eLaJh6jh6kYfmsVLNXr/j6EUetixm7W1iP45e5MGoQufjs+uu6EUe
EphYn6+Ud0Uv8lDo6nPvYLoLepGHk6vkB7Zqu6AXeTiu3yna9doZvchD0qpt
Kcy2zuhFHhS5Xyf9+HkMvSjAWFaKuU3YMfSiALyZjwv204+hFwVwTHNTWCw9
il4YeSP1qbLFUfSiAFcdFePLfh5BLwrQ8WSIuSLyCHpRACGrZou9a46gFwWo
danj9Gs9jF4UoEFdJbXN8zB6UQCrq6bTKdKH0YsCaG3klpkrd0IvCvBV79hk
lKMTelEAhYU0lrP8TuhFAfTPmt5vLHRELwrAcsok/oCdI3pRAJ+g9Nd0fkf0
ogChawWWLC85hF4UgP3VS8GHRw6hF0WY0oTKFVKH0Isi+N58K8ZW74BeFKFt
sa6K5uuAXhRBg+Nqk/YqB/SiCCE/Bg/e6bdHL4pgqGWnLnbLHr0owuiMMlfC
dnv0ogjavz3DHTns0YsiiE9TZUWe2aEXRRieWfFe0tsOvSjCNX2PiD/qduhF
EWqVPN4J/LBFL4pQNee3Zj7DFr0oQkxQFCe/sy16UYRM04BsmX9s0YsinDs4
OjfdaoNeFIFfWf281l4b9EIBb47PajI9B3E+FOgwUZXttTlIbLUyexMFKLCn
vijQe/gA+e/XWcQpYBvorPLt5AHy36+vyFPgVs7M1nW/95PWmeB9kUoUeHeT
I5P18n70RQGf5l7WT5L7cZ4USNRKOnA5zRq9USB/7GvBhJY1iXb9INCmR4Fw
0fvar95YkUMs564oGVPgjkSM6YFDVkTjpiyfpxnj+qb64bbzloRjxZPQmn2M
x43eNHFGW+L8KZDQtnr2yCpL9Mm4np2UA+WlBfZBgT8tO9kaDluQukRRfU5P
CihvL1jfyWFBbmnkVOzzo4Dbi0KZkdR95MjL7SQtiALMV5Iq+o32kQ02Y2Uz
oRRoee1/Q3VsL3qmQLqKL8ur63uxPwqo+m5R/a65F31TIIm7ZNytbw+ZazX0
1EqjQJdGiItnyB7y6sjAZGg2BVx/1rwsUttD4v8EuPcWUqC6UiNz9u1u4hKp
OK5Szpg/32gre+hu7JsC++svruNdvxvXAwWydlytheFd2D8FzulncM/f3EVW
cvqkufZSYF23kEmK8S6yECe5tLyfAqEtB8Te/DYnjasLUgQ+U2A0pXD+w2Nz
klhjrmQzToEUtaaNwk7muH4oYPTP5YTzcubohQosEaG8Nm070QsVou6VNA6H
70QvVNitbxFy3nAneqGC5dJZ8R7mneiFCgrCH8u8y8zQCxUmsnMNUnzM0AsV
qKr0uqb1ZuiFCvtPVA6u/L4DvVDBKNHmQvWJHeiFCrnzpTmbJrajFyroWOs+
/uK5Hb1QwbG3n8Nz3hS9UMHDKU4gIsgUvVAhsbaFJ4TfFL1QYUOZdvbnWybo
hQq0zLE2irIJeqHC4Yb11T4F29AL4/VeHZx8t3kbeqFCrZvSolz3VvRChaW9
iS37XbeiFyrMRfmlDbFsRS9UeL5Z7tn3WGP0QgUT584tY+rG6IUKUj9Z24be
GKEXKhSpf/1j5GyEXqggetnBvJvLCL1QQfdOc7Jw2hb0QoWOb6OF34y2oBcq
KN2xVnH9YoheqNBmWxB8+ZoheqHCqp1juafXGqIXKtzuG3er6t2MXqgg9PZ6
WFfQZvRCBZ8q60u+KzejFypcld9Cf9e5Cb3QQJFjaHLfhU3ohQZ2WiW0MLVN
6IUGEuneVzZ+MEAvNEi5mVR27LoBeqFB4CbRXEE9A/RCg8Vt9xemJvXRCw0S
+Jt/7Higj15o0FlqKS25Xx+90MDrUK+/oYg+eqGBULHlsex6PfRCg3ytUPHA
AD30QoOpbt3jgdp66IUGcwGnA/mmAb3QoLJL3682B9ALDfKsM5e/dwX0QoOM
pIxnUyqAXmjAouFULNBO0AsN6tjGxAJ3E/RCA+klwvU+HbrohQYGISGtHyx0
0QsNxKuLauzfb0QvNBCdpgj7O21EL4zzf4+Sru866IUGUr6HTa/76qAXGlDc
DyRkcOqgFxqMW9/7LhOjjV5oDL8u4teVtdELDRzV8/cYP9FCLzQQblwfz7ld
C73QoPVi9/SeTxvQCw3c1h5Y98RnA3qhQdlY7A55sQ3ohQYvFju/zGauRy80
MC3jmWg1Xo9eGB52O2iUDq9DL3RYad0nmxCyDr3Q4USg7vPOpevQCx123pBu
4n6piV7o4Oqu37rquCZ6oUNMfa+mnpgmeqGDoaB9VVKJBnqhg/VTsdOf7TXQ
Cx2oN1SenuDVQC904PJIsW4uWIte6HDA6coY1X4teqHD+jSLi0ZCa9ELHeaF
fZpul6ujFzrsOWUS13FcHb3QIaLi6c63FHX0QoeUu148TK1r0Asd1vmOhL2/
uAa90KH5fMmqldpr0AsddvU3DbGOq6EXOlx3HzhVmqaGXuhQyELPPWerhl7o
EM4SLkCVUUMvdDicS7E+3L4avdDBgdm8Y/T6avRCh4nHgV2c21ejFzqoGjwO
k+ZdjV7oELZ8pTxbtCp6ocNb0XejF8RV0QsdxMTPn+uJWYVe6KCcuzK5W3YV
eqHDluT3ancSV6IXOhRsj/ZhXb4SvdDhgf/b4/I5K9ALHU7tGX3UorMCvdCh
Mrmgj/5aBb3QgW2E2UvUWoX8H+WcyZg=
       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 0.6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.8, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJxd2nc4lf//B3B7772dIdVHJYkKeb9QoihpGZUVDVREMiojKTSMVEgUUla2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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 0.6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857217586*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.8`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwt1Hdczf37B/BzTnuffU7n1E1EuUPGLSP1vhIpQrIqbiK7cKMkQkPa0tTS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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.8, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJwt1Hdczf37B/BzTnuffU7n1E1EuUPGLSP1vhIpQrIqbiK7cKMkQkPa0tTS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        "]]}, {}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesLabel -> {"t", "<O>"}, 
     AxesOrigin -> {0, 0}, PlotRange -> {{0, 7}, {0, 6}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {Automatic, Automatic}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.5440748572243443`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", 
    RowBox[{"-", "0.001168908009871701`"}]}], ",", 
   RowBox[{"b", "\[Rule]", "0.8664473430028901`"}], ",", 
   RowBox[{"k", "\[Rule]", "0.6277988350933149`"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.544073460970943*^9, {3.544073526059865*^9, 3.544073569697809*^9}, 
   3.544073604809957*^9, {3.544073727204237*^9, 3.544073738907506*^9}, {
   3.544073815769908*^9, 3.544073841300477*^9}, 3.544073911616857*^9, 
   3.5440739743201723`*^9, 3.5440740137316523`*^9, 3.544074121801118*^9, 
   3.544074651484997*^9, {3.544074713535055*^9, 3.5440747364426603`*^9}, 
   3.5440748016791897`*^9, {3.544074847587064*^9, 3.544074857281123*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"amp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.85`"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd2nk4VH/7B3D7vu/7bKQiioSUz235hoq0ESVLlBYl0WpNVLaQLZG1qEgS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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t\"", TraditionalForm], 
      FormBox["\"<O>\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{{0, 7}, {0, 0.6}},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}],
  SequenceForm["amp = ", -0.85, "\n", 
   Graphics[{{{}, {
       Hue[0.67, 0.6, 0.6], 
       Point[CompressedData["
1:eJxd2nk4VH/7B3D7vu/7bKQiioSUz235hoq0ESVLlBYl0WpNVLaQLZG1qEgS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