/*
 Code *with* scalar source.

  q = 2!!
 
 Adjust mu dynamically
 
 
*/



#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#include <complex.h>


#define PI 3.1415926535897932384626433832795028841971693993751


#define Nmax  100 

#define power(x,n) pow(x,n)

double totv = 20. ;

int N ;


double amp, amp2 ;



double dv, scalvev, Tvev ;

double x[Nmax], Dmat[Nmax][Nmax], D2mat[Nmax][Nmax] ;

double aval ;

double Var[1+5*Nmax], NewVar[1+5*Nmax], OldVar[1+5*Nmax], Eqn[1+5*Nmax], Lich[1+5*Nmax][1+5*Nmax], InitVar[1+5*Nmax], EqnConst[1+8*Nmax] ;

double Lmat[(1+5*Nmax)*(1+5*Nmax)] ;

void calcm(double, double *, double *, double *) ;
void setupCheb(void), readin(void), writeout(double, FILE *), calcstep(double), calcLich(double), calcEqn(double,double *), calcEqnConst(double) ;
void linsolve(double *, double *) ;


int main(void)
{
    FILE *outfile, *paramfile ;
    
    int ii, tt, iter, numsteps, skip, numwrites ;
    double v, buf ;
    
    double _Complex psi ;
    
    
    outfile = fopen("output.dat","w") ; paramfile = fopen("param.dat","w") ;
    
    if(outfile==NULL || paramfile==NULL) {
        printf("\n\nProblem opening output files\n\n") ; 
        exit(1) ;
    }

    readin() ;

    setupCheb() ;
    
    buf = (double) N ;     fwrite(&buf,sizeof(double),1,paramfile) ;
    buf = (double) aval ;  fwrite(&buf,sizeof(double),1,paramfile) ;
    for(ii=0;ii<N;ii++)    fwrite(&x[ii],sizeof(double),1,paramfile) ;
    
    
    dv = 0.2/((double) N) ;
    
    numsteps = ceil(totv/dv) ;
    
    skip = ceil(((double) numsteps)/200.) ;
    
    
    amp2 = -0. ;
    
    for(iter=0;iter<1;iter++) {
        
        amp2 = amp2 - 0.4 ;    
        
    printf("amp = %7.3e,  amp2 = %7.3e\n",amp,amp2) ;

    buf = (double) amp ;   fwrite(&buf,sizeof(double),1,paramfile) ;
    buf = (double) amp2 ;  fwrite(&buf,sizeof(double),1,paramfile) ;
    fflush(paramfile) ;
    
        
    for(ii=0;ii<5*N;ii++) { Var[ii] = InitVar[ii] ;  OldVar[ii] = InitVar[ii] ; NewVar[ii] = InitVar[ii] ; }
    Var[5*N] = aval ; OldVar[5*N] = aval ; NewVar[5*N] = aval ;
        
        
    
    v = 0. ;
    numwrites=0;
    
    psi = 0. ; for(ii=0;ii<N;ii++) psi += Dmat[0][ii]*(Var[ii]    + _Complex_I*Var[N+ii]) ; 
    printf(" Initial :   v = 0.   < O > = %7.3f   < rho > = %7.3e   mu = %7.3e  arg = %7.3e\n",sqrt(pow(Var[1],2)+pow(Var[N+1],2))/x[1],Var[3*N+1]/x[1],Var[5*N],carg(psi)) ;
    
    for(tt=1;tt<numsteps;tt++) {
            
        calcstep(v) ;
        
        calcEqnConst(v) ;
        
        v+=dv ;
                        
        if(tt%skip==0) {
                        
            psi = 0. ; for(ii=0;ii<N;ii++) psi += Dmat[0][ii]*(Var[ii]    + _Complex_I*Var[N+ii]) ; 
                        
            printf(" ii = %d :   v = %7.3f   < O > = %7.3f   < rho > = %7.3e  mu = %7.3e   arg = %7.3e\n",tt,v,sqrt(pow(Var[1],2)+pow(Var[N+1],2))/x[1],Var[3*N+1]/x[1],Var[5*N],carg(psi)) ;
            
            writeout(v,outfile) ; numwrites+=1 ;
            
        }
        
        for(ii=0;ii<1+5*N;ii++) {
            
            OldVar[ii] = Var[ii] ;
            
            Var[ii] = NewVar[ii] ;
            
        }    
        
    }
        
    buf = (double) numwrites ;   fwrite(&buf,sizeof(double),1,paramfile) ;    
    
    }
    
    
    fclose(outfile) ; fclose(paramfile) ;

    
}



void readin(void)
{
    int ii, pos, chk ;
    FILE *infile ;
        
    infile = fopen("init.dat","r") ;
    
    if(infile==NULL) {
        printf("\n\nProblem opening file\n\n") ; 
        exit(1) ;
    }
    
    chk = fread(&N,sizeof(int),1,infile) ;
    chk += fread(&aval,sizeof(double),1,infile) ;
    
    printf("N = %d  ;  aval = %e\n",N,aval) ;
        
    for(ii=0;ii<N;ii++) chk += fread(&InitVar[ii],sizeof(double),1,infile) ;
    for(ii=0;ii<N;ii++) chk += fread(&InitVar[N+ii],sizeof(double),1,infile) ;
    for(ii=0;ii<N;ii++) chk += fread(&InitVar[2*N+ii],sizeof(double),1,infile) ;
    for(ii=0;ii<N;ii++) chk += fread(&InitVar[3*N+ii],sizeof(double),1,infile) ;
    for(ii=0;ii<N;ii++) chk += fread(&InitVar[4*N+ii],sizeof(double),1,infile) ;
    
    fclose(infile) ;
    
    if(chk!=2+5*N) {
        printf("\n\nProblem reading file - EOF encountered  chk = %d\n\n",chk) ; 
        exit(1) ;
    }
        
}



void writeout(double time, FILE *outfile)
{
    int ii, chk ;
    
    chk = 0 ;
    
    chk += fwrite(&time,sizeof(double),1,outfile) ;
    
    chk += fwrite(&Var[5*N],sizeof(double),1,outfile) ;
        
    for(ii=0;ii<N;ii++) chk += fwrite(&Var[ii],sizeof(double),1,outfile) ;
    for(ii=0;ii<N;ii++) chk += fwrite(&Var[N+ii],sizeof(double),1,outfile) ;
    for(ii=0;ii<N;ii++) chk += fwrite(&Var[2*N+ii],sizeof(double),1,outfile) ;
    for(ii=0;ii<N;ii++) chk += fwrite(&Var[3*N+ii],sizeof(double),1,outfile) ;
    for(ii=0;ii<N;ii++) chk += fwrite(&Var[4*N+ii],sizeof(double),1,outfile) ;

        
    for(ii=0;ii<N;ii++)    chk += fwrite(&EqnConst[ii],sizeof(double),1,outfile) ;
    for(ii=0;ii<N;ii++)    chk += fwrite(&EqnConst[N+ii],sizeof(double),1,outfile) ;
    for(ii=0;ii<N;ii++)     chk += fwrite(&EqnConst[2*N+ii],sizeof(double),1,outfile) ;
    for(ii=0;ii<N;ii++)     chk += fwrite(&EqnConst[3*N+ii],sizeof(double),1,outfile) ;
    for(ii=0;ii<N;ii++)     chk += fwrite(&EqnConst[4*N+ii],sizeof(double),1,outfile) ;
    for(ii=0;ii<N;ii++)     chk += fwrite(&EqnConst[5*N+ii],sizeof(double),1,outfile) ;
    for(ii=0;ii<N;ii++)     chk += fwrite(&EqnConst[6*N+ii],sizeof(double),1,outfile) ;
    for(ii=0;ii<N;ii++)     chk += fwrite(&EqnConst[7*N+ii],sizeof(double),1,outfile) ;
    
    
    fflush(outfile) ;
    
    if(chk!=2+13*N) {
        printf("\n\nProblem writing data to outfile\n\n") ; 
        exit(1) ;
    }
    
}




void calcm(double v, double *p, double *pv, double *pvv) 
{
    double w, v0 ;
    
    w  = 100. ;
    
    v0 = 1. ;
   
    *p = amp2*exp(-(w*power(v - v0,2))) ;
    *pv = -2*amp2*(v - v0)*w*exp(-(w*power(v - v0,2))) ;
    *pvv = 2*amp2*w*exp(-(w*power(v - v0,2)))*(-1 - 4*v*v0*w + 2*w*power(v,2) + 2*w*power(v0,2)) ;
    
     
}



void calcstep(double time)
{
    int ii, iter ;
    double err ;
    
    double step[5*Nmax] ;
    
    
    for(ii=0;ii<1+5*N;ii++) {
    
        NewVar[ii] = Var[ii] ;
    
    }
    
    for(iter=0;iter<20;iter++) {
        
        calcEqn(time,Eqn) ;
        
        calcLich(time) ;
        
        linsolve(step,Eqn) ;
        
        for(ii=0;ii<1+5*N;ii++) NewVar[ii] -= step[ii] ;
        
        for(err=0.,ii=0;ii<1+5*N;ii++) { if(fabs(Eqn[ii])>err) err = fabs(Eqn[ii]) ; }
        
        // printf(" iter = %d  ->  err = %7.3e\n",iter,err) ;
        
        if(err<1e-5) break ;
        
    } 
    
    if(iter>15) { printf("   *** WARNING: Precision issue;   iter = %d,  err = %7.3e\n",iter,err) ; }
    
    
}


void calcLich(double time)
{
    int ii, jj, kk ;
    double EqnM[1+5*Nmax], EqnP[1+5*Nmax] ;
    
    double store[1+5*Nmax] ;
    
    double delta = 1.e-6 ;
    
    
    
    for(ii=0;ii<1+5*N;ii++) store[ii] = NewVar[ii] ;
    
    calcEqn(time,Eqn) ;
    
    
    for(ii=0;ii<1+5*N;ii++) {
        
        NewVar[ii] = store[ii] + delta ;
        
        calcEqn(time,EqnP) ;
        
        NewVar[ii] = store[ii] - delta ;
        
        calcEqn(time,EqnM) ;
        
        NewVar[ii] = store[ii] ;

        for(jj=0;jj<1+5*N;jj++) {
            
            Lich[jj][ii] = ( EqnP[jj] - EqnM[jj] )/( 2*delta ) ;
            
        }
        
    }
    
    
}




void calcEqn(double time, double *eqnVec)
{
    int ii, jj, pos ;
    
    double v, z, p, pv, pvv ;
    
    double f0[Nmax], f0z[Nmax], f0zz[Nmax], h0[Nmax], h0z[Nmax], h0zz[Nmax], a0[Nmax], a0z[Nmax], a0zz[Nmax], t0[Nmax], t0z[Nmax], t0zz[Nmax], s0[Nmax], s0z[Nmax], s0zz[Nmax] ;
    
    double f1[Nmax], f1z[Nmax], f1zz[Nmax], h1[Nmax], h1z[Nmax], h1zz[Nmax], a1[Nmax], a1z[Nmax], a1zz[Nmax], t1[Nmax], t1z[Nmax], t1zz[Nmax], s1[Nmax], s1z[Nmax], s1zz[Nmax] ;
    
    double f, h, a, t, s, fz, hz, az, tz, sz, fzz, hzz, azz, tzz, szz, fv, hv, av, tv, sv, fvz, hvz, avz, tvz, svz ;    
    
    double m0, m1, m ;
    
    v = time + 0.5*dv ;
    
    calcm(v, &p, &pv, &pvv) ; 
    
    
    m0 = Var[5*N] ; m1 = NewVar[5*N] ;
    
    m = 0.5*( m0 + m1 ) ;
    
    
    for(ii=0;ii<N;ii++) {
        
        f0[ii] = Var[ii] ; h0[ii] = Var[N+ii] ; a0[ii] = Var[2*N+ii] ; t0[ii] = Var[3*N+ii] ; s0[ii] = Var[4*N+ii] ; 
        
        f1[ii] = NewVar[ii] ; h1[ii] = NewVar[N+ii] ; a1[ii] = NewVar[2*N+ii] ; t1[ii] = NewVar[3*N+ii] ; s1[ii] = NewVar[4*N+ii] ; 
        
    }
    
    
    for(ii=0;ii<N;ii++) {
        
        f0z[ii] = 0. ; h0z[ii] = 0. ; a0z[ii] = 0. ; t0z[ii] = 0. ; s0z[ii] = 0. ;
        f1z[ii] = 0. ; h1z[ii] = 0. ; a1z[ii] = 0. ; t1z[ii] = 0. ; s1z[ii] = 0. ;
        
        f0zz[ii] = 0. ; h0zz[ii] = 0. ; a0zz[ii] = 0. ; t0zz[ii] = 0. ; s0zz[ii] = 0. ;
        f1zz[ii] = 0. ; h1zz[ii] = 0. ; a1zz[ii] = 0. ; t1zz[ii] = 0. ; s1zz[ii] = 0. ;
        
        
        for(jj=0;jj<N;jj++) {
            
            f0z[ii] += Dmat[ii][jj]*f0[jj] ;
            h0z[ii] += Dmat[ii][jj]*h0[jj] ;
            a0z[ii] += Dmat[ii][jj]*a0[jj] ;
            t0z[ii] += Dmat[ii][jj]*t0[jj] ;
            s0z[ii] += Dmat[ii][jj]*s0[jj] ;
            
            f1z[ii] += Dmat[ii][jj]*f1[jj] ;
            h1z[ii] += Dmat[ii][jj]*h1[jj] ;
            a1z[ii] += Dmat[ii][jj]*a1[jj] ;
            t1z[ii] += Dmat[ii][jj]*t1[jj] ;
            s1z[ii] += Dmat[ii][jj]*s1[jj] ;
            
            f0zz[ii] += D2mat[ii][jj]*f0[jj] ;
            h0zz[ii] += D2mat[ii][jj]*h0[jj] ;
            a0zz[ii] += D2mat[ii][jj]*a0[jj] ;
            t0zz[ii] += D2mat[ii][jj]*t0[jj] ;
            s0zz[ii] += D2mat[ii][jj]*s0[jj] ;
            
            f1zz[ii] += D2mat[ii][jj]*f1[jj] ;
            h1zz[ii] += D2mat[ii][jj]*h1[jj] ;
            a1zz[ii] += D2mat[ii][jj]*a1[jj] ;
            t1zz[ii] += D2mat[ii][jj]*t1[jj] ;
            s1zz[ii] += D2mat[ii][jj]*s1[jj] ;
            
        }
        
    }
    
    
    
    double boundtvz, boundfvz, boundhz ;
    
    boundfvz = ( f1z[0] - f0z[0] )/dv ;
    boundtvz = ( t1z[0] - t0z[0] )/dv ;
    boundhz  = 0.5*( h1z[0] + h0z[0] ) ;
    
    
    
    for(pos=0,ii=0;ii<N;ii++) {
        
        z = x[ii] ;
        
        f = 0.5*( f1[ii] + f0[ii] ) ;
        h = 0.5*( h1[ii] + h0[ii] ) ;
        a = 0.5*( a1[ii] + a0[ii] ) ;
        t = 0.5*( t1[ii] + t0[ii] ) ;
        s = 0.5*( s1[ii] + s0[ii] ) ;
        
        fz = 0.5*( f1z[ii] + f0z[ii] ) ;
        hz = 0.5*( h1z[ii] + h0z[ii] ) ;
        az = 0.5*( a1z[ii] + a0z[ii] ) ;
        tz = 0.5*( t1z[ii] + t0z[ii] ) ;
        sz = 0.5*( s1z[ii] + s0z[ii] ) ;
        
        fzz = 0.5*( f1zz[ii] + f0zz[ii] ) ;
        hzz = 0.5*( h1zz[ii] + h0zz[ii] ) ;
        azz = 0.5*( a1zz[ii] + a0zz[ii] ) ;
        tzz = 0.5*( t1zz[ii] + t0zz[ii] ) ;
        szz = 0.5*( s1zz[ii] + s0zz[ii] ) ;
        
        fv = ( f1[ii] - f0[ii] )/dv ;
        hv = ( h1[ii] - h0[ii] )/dv ;
        av = ( a1[ii] - a0[ii] )/dv ;
        tv = ( t1[ii] - t0[ii] )/dv ;
        sv = ( s1[ii] - s0[ii] )/dv ;
        
        fvz = ( f1z[ii] - f0z[ii] )/dv ;
        hvz = ( h1z[ii] - h0z[ii] )/dv ;
        avz = ( a1z[ii] - a0z[ii] )/dv ;
        tvz = ( t1z[ii] - t0z[ii] )/dv ;
        svz = ( s1z[ii] - s0z[ii] )/dv ;
        
        if(ii==0) {
            
            eqnVec[pos++] = f  ;
            
            eqnVec[pos++] = h ;
            
            eqnVec[pos++] = a ;
            
            eqnVec[pos++] = s ;
            
            eqnVec[pos++] = t ;
            
        } else {
            
            eqnVec[pos++] = fvz - (pow(z,-2)*(2*(f + p) - 2*fv*z - 2*pv*z + 2*(fv + pv)*z - 2*az*h*pow(z,2) + (f + p + fz*z)*(2*t + tz*z - pow(p,2))*pow(z,2) + ((-2*(f + p) + fzz*pow(z,2))*(2 + (2*t - pow(p,2))*pow(z,2)))/2. - 4*(a + m)*(4*hz + z*(4*h*sz*z + (2*h + hz*z)*(4*s - pow(p,2))))*pow(z,2)*pow(4 + (4*s - pow(p,2))*pow(z,2),-1) + pow(z,2)*((p*pv - 2*sv)*z*(f + p + fz*z) - (fv + pv)*z*(4*s + 2*sz*z - pow(p,2)) + 2*(f + p + fz*z)*(2*s + sz*z - pow(p,2)/2.)*(1 + (t - pow(p,2)/2.)*pow(z,2)))*pow(1 + (s - pow(p,2)/4.)*pow(z,2),-1)))/2. ; 
            
            eqnVec[pos++] = hvz - (pow(z,-2)*(2*h + 2*az*(f + p)*pow(z,2) + (h + hz*z)*(2*t + tz*z - pow(p,2))*pow(z,2) + ((-2*h + hzz*pow(z,2))*(2 + (2*t - pow(p,2))*pow(z,2)))/2. + 4*(a + m)*(4*fz + z*(4*(f + p)*sz*z + (2*(f + p) + fz*z)*(4*s - pow(p,2))))*pow(z,2)*pow(4 + (4*s - pow(p,2))*pow(z,2),-1) + pow(z,2)*((p*pv - 2*sv)*z*(h + hz*z) + hv*z*(-4*s - 2*sz*z + pow(p,2)) + 2*(h + hz*z)*(2*s + sz*z - pow(p,2)/2.)*(1 + (t - pow(p,2)/2.)*pow(z,2)))*pow(1 + (s - pow(p,2)/4.)*pow(z,2),-1)))/2. ;             
            
            eqnVec[pos++] = avz + 2*(4*az*sv*pow(z,2) + 4*(a + m)*pow(f,2)*(4 + (4*s - pow(p,2))*pow(z,2)) + 4*(a + m)*pow(h,2)*(4 + (4*s - pow(p,2))*pow(z,2)) - f*(-4 + (-4*s + pow(p,2))*pow(z,2))*(-2*hv + 8*(a + m)*p - hz*pow(p,2)*pow(z,2) + 2*hz*(1 + t*pow(z,2))) + h*(4 + (4*s - pow(p,2))*pow(z,2))*(2*fv + 2*pv + fz*(-2 + (-2*t + pow(p,2))*pow(z,2))) + p*(-4*(a + m)*pow(p,3)*pow(z,2) + 16*(a + m)*p*(1 + s*pow(z,2)) + 2*pow(p,2)*pow(z,2)*(hv - hz*(3 + (2*s + t)*pow(z,2))) + 2*(-(az*pv*pow(z,2)) + 4*(1 + s*pow(z,2))*(-hv + hz*(1 + t*pow(z,2)))) + hz*pow(p,4)*pow(z,4)))*pow(4 + (4*s - pow(p,2))*pow(z,2),-1) ; 

            
            if(ii==1) {
                
                // eqnVec[pos++] = tv + 2*m*p*(h + 2*z*m*p) + p*fv - z*p*pvv ; 
                
                // eqnVec[pos++] = tvz + 2*m*p*(hz + 2*m*p) + p*fvz - p*pvv ; 
                
                eqnVec[pos++] = boundtvz + 2*m*p*(boundhz + 2*m*p) + p*boundfvz - p*pvv ; 
                
            } else {
                
                eqnVec[pos++] = tzz - pow(az,2) - (4*t + 2*tz*z - 2*pow(p,2))*pow(z,-2) - (-2*t + pow(p,2))*pow(z,-2) + 4*tz*pow(z,-1) - 4*h*(a + m)*(f + p + fz*z)*pow(z,-1) - 2*(fv + pv)*(f + p + fz*z)*pow(z,-1) - 2*hv*(h + hz*z)*pow(z,-1) + 4*(a + m)*(f + p)*(h + hz*z)*pow(z,-1) + (pow(z,-4)*(2 + (2*t - pow(p,2))*pow(z,2))*(-6 + pow(z,2)*(2*h*hz*z + pow(h,2) + pow(hz,2)*pow(z,2) + pow(f + p + fz*z,2))))/2. + (pow(z,-4)*(2 + (2*t - pow(p,2))*pow(z,2))*(6 + pow(z,2)*(2*h*hz*z + pow(h,2) + pow(hz,2)*pow(z,2) + pow(f + p + fz*z,2))))/2. - 16*p*pv*z*(4*s + 2*sz*z - pow(p,2))*pow(4 + (4*s - pow(p,2))*pow(z,2),-2) - 16*sv*pow(z,-1)*(4 + (-4*s - 4*sz*z + pow(p,2))*pow(z,2))*pow(4 + (4*s - pow(p,2))*pow(z,2),-2) - 4*(2 + (2*t - pow(p,2))*pow(z,2))*pow(-4*s - 2*sz*z + pow(p,2),2)*pow(4 + (4*s - pow(p,2))*pow(z,2),-2) - 8*(4*s + 2*sz*z - pow(p,2))*pow(z,-2)*(-2 + (-2*t + pow(p,2))*pow(z,2))*pow(4 + (4*s - pow(p,2))*pow(z,2),-1) - 2*(-4*s + 2*z*(2*sz + szz*z) + pow(p,2))*pow(z,-2)*(-2 + (-2*t + pow(p,2))*pow(z,2))*pow(4 + (4*s - pow(p,2))*pow(z,2),-1) + 8*p*pv*pow(4*z + 4*s*pow(z,3) - pow(p,2)*pow(z,3),-1) ;
                
            }
                
            eqnVec[pos++] = svz + (pow(z,-4)*(1 + (s - pow(p,2)/4.)*pow(z,2))*(12 + 4*pow(h,2)*pow(z,2) + 4*(2*t + tz*z - pow(p,2))*pow(z,2) + 4*pow(f + p,2)*pow(z,2) - pow(az,2)*pow(z,4) + 2*(1 + (t - pow(p,2)/2.)*pow(z,2))*(-6 + pow(z,2)*pow(f + p + fz*z,2) + pow(z,2)*pow(h + hz*z,2)) - 8*(4*s + 2*sz*z - pow(p,2))*(2*t + tz*z - pow(p,2))*pow(z,4)*pow(4 + (4*s - pow(p,2))*pow(z,2),-1) - 4*(2*s + sz*z - pow(p,2)/2.)*((p*pv - 2*sv)*z + (2*s + sz*z - pow(p,2)/2.)*(1 + (t - pow(p,2)/2.)*pow(z,2)))*pow(z,4)*pow(1 + (s - pow(p,2)/4.)*pow(z,2),-2) - 16*(4*s + 2*sz*z - pow(p,2))*pow(z,2)*(2 + (2*t - pow(p,2))*pow(z,2))*pow(-4 + (-4*s + pow(p,2))*pow(z,2),-1)))/8. ; 
                 
            
        }
        
    }
    
    
    /* Finally:  equation for m */
     
    eqnVec[pos++] = h1z[0] ;
    
}




void calcEqnConst(double time)
{
    int ii, jj ;
    
    double v, m, z, p, pv, pvv ;
    
    double f0[Nmax], f0z[Nmax], f0zz[Nmax], h0[Nmax], h0z[Nmax], h0zz[Nmax], a0[Nmax], a0z[Nmax], a0zz[Nmax], t0[Nmax], t0z[Nmax], t0zz[Nmax], s0[Nmax], s0z[Nmax], s0zz[Nmax] ;

    double f1[Nmax], f1z[Nmax], f1zz[Nmax], h1[Nmax], h1z[Nmax], h1zz[Nmax], a1[Nmax], a1z[Nmax], a1zz[Nmax], t1[Nmax], t1z[Nmax], t1zz[Nmax], s1[Nmax], s1z[Nmax], s1zz[Nmax] ;

    double f2[Nmax], f2z[Nmax], f2zz[Nmax], h2[Nmax], h2z[Nmax], h2zz[Nmax], a2[Nmax], a2z[Nmax], a2zz[Nmax], t2[Nmax], t2z[Nmax], t2zz[Nmax], s2[Nmax], s2z[Nmax], s2zz[Nmax] ;
    
    double f, h, a, t, s, fz, hz, az, tz, sz, fzz, hzz, azz, tzz, szz, fv, hv, av, tv, sv, fvz, hvz, avz, tvz, svz, fvv, hvv, avv, tvv, svv ;    
    
    
    v = time ;
    
    calcm(v, &p, &pv, &pvv) ; 
    
    
    m = 0.5*( Var[5*N] + NewVar[5*N] ) ;
    
    
    for(ii=0;ii<N;ii++) {
        
        f0[ii] = OldVar[ii] ; h0[ii] = OldVar[N+ii] ; a0[ii] = OldVar[2*N+ii] ; t0[ii] = OldVar[3*N+ii] ; s0[ii] = OldVar[4*N+ii] ; 
        
        f1[ii] = Var[ii] ; h1[ii] = Var[N+ii] ; a1[ii] = Var[2*N+ii] ; t1[ii] = Var[3*N+ii] ; s1[ii] = Var[4*N+ii] ; 
        
        f2[ii] = NewVar[ii] ; h2[ii] = NewVar[N+ii] ; a2[ii] = NewVar[2*N+ii] ; t2[ii] = NewVar[3*N+ii] ; s2[ii] = NewVar[4*N+ii] ; 
        
    }
    
    
    for(ii=0;ii<N;ii++) {
        
        f0z[ii] = 0. ; h0z[ii] = 0. ; a0z[ii] = 0. ; t0z[ii] = 0. ; s0z[ii] = 0. ;
        f1z[ii] = 0. ; h1z[ii] = 0. ; a1z[ii] = 0. ; t1z[ii] = 0. ; s1z[ii] = 0. ;
        f2z[ii] = 0. ; h2z[ii] = 0. ; a2z[ii] = 0. ; t2z[ii] = 0. ; s2z[ii] = 0. ;
        
        f0zz[ii] = 0. ; h0zz[ii] = 0. ; a0zz[ii] = 0. ; t0zz[ii] = 0. ; s0zz[ii] = 0. ;
        f1zz[ii] = 0. ; h1zz[ii] = 0. ; a1zz[ii] = 0. ; t1zz[ii] = 0. ; s1zz[ii] = 0. ;
        f2zz[ii] = 0. ; h2zz[ii] = 0. ; a2zz[ii] = 0. ; t2zz[ii] = 0. ; s2zz[ii] = 0. ;

        
        for(jj=0;jj<N;jj++) {
            
            f0z[ii] += Dmat[ii][jj]*f0[jj] ;
            h0z[ii] += Dmat[ii][jj]*h0[jj] ;
            a0z[ii] += Dmat[ii][jj]*a0[jj] ;
            t0z[ii] += Dmat[ii][jj]*t0[jj] ;
            s0z[ii] += Dmat[ii][jj]*s0[jj] ;
            
            f1z[ii] += Dmat[ii][jj]*f1[jj] ;
            h1z[ii] += Dmat[ii][jj]*h1[jj] ;
            a1z[ii] += Dmat[ii][jj]*a1[jj] ;
            t1z[ii] += Dmat[ii][jj]*t1[jj] ;
            s1z[ii] += Dmat[ii][jj]*s1[jj] ;
            
            f2z[ii] += Dmat[ii][jj]*f2[jj] ;
            h2z[ii] += Dmat[ii][jj]*h2[jj] ;
            a2z[ii] += Dmat[ii][jj]*a2[jj] ;
            t2z[ii] += Dmat[ii][jj]*t2[jj] ;
            s2z[ii] += Dmat[ii][jj]*s2[jj] ;
            
            f0zz[ii] += D2mat[ii][jj]*f0[jj] ;
            h0zz[ii] += D2mat[ii][jj]*h0[jj] ;
            a0zz[ii] += D2mat[ii][jj]*a0[jj] ;
            t0zz[ii] += D2mat[ii][jj]*t0[jj] ;
            s0zz[ii] += D2mat[ii][jj]*s0[jj] ;
            
            f1zz[ii] += D2mat[ii][jj]*f1[jj] ;
            h1zz[ii] += D2mat[ii][jj]*h1[jj] ;
            a1zz[ii] += D2mat[ii][jj]*a1[jj] ;
            t1zz[ii] += D2mat[ii][jj]*t1[jj] ;
            s1zz[ii] += D2mat[ii][jj]*s1[jj] ;
            
            f2zz[ii] += D2mat[ii][jj]*f2[jj] ;
            h2zz[ii] += D2mat[ii][jj]*h2[jj] ;
            a2zz[ii] += D2mat[ii][jj]*a2[jj] ;
            t2zz[ii] += D2mat[ii][jj]*t2[jj] ;
            s2zz[ii] += D2mat[ii][jj]*s2[jj] ;

        }

    }

    
    for(ii=0;ii<N;ii++) {
    
        z = x[ii] ;
        
        f = f1[ii] ;
        h = h1[ii] ;
        a = a1[ii] ;
        t = t1[ii] ;
        s = s1[ii] ;
        
        fz = f1z[ii] ;
        hz = h1z[ii] ;
        az = a1z[ii] ;
        tz = t1z[ii] ;
        sz = s1z[ii] ;

        fzz = f1zz[ii] ;
        hzz = h1zz[ii] ;
        azz = a1zz[ii] ;
        tzz = t1zz[ii] ;
        szz = s1zz[ii] ;

        fv = ( f2[ii] - f0[ii] )/(2*dv) ;
        hv = ( h2[ii] - h0[ii] )/(2*dv) ;
        av = ( a2[ii] - a0[ii] )/(2*dv) ;
        tv = ( t2[ii] - t0[ii] )/(2*dv) ;
        sv = ( s2[ii] - s0[ii] )/(2*dv) ;
        
        fvz = ( f2z[ii] - f0z[ii] )/(2*dv) ;
        hvz = ( h2z[ii] - h0z[ii] )/(2*dv) ;
        avz = ( a2z[ii] - a0z[ii] )/(2*dv) ;
        tvz = ( t2z[ii] - t0z[ii] )/(2*dv) ;
        svz = ( s2z[ii] - s0z[ii] )/(2*dv) ;
        
        fvv = ( f2[ii] + f0[ii] - 2*f1[ii] )/(dv*dv) ;
        hvv = ( h2[ii] + h0[ii] - 2*h1[ii] )/(dv*dv) ;
        avv = ( a2[ii] + a0[ii] - 2*a1[ii] )/(dv*dv) ;
        tvv = ( t2[ii] + t0[ii] - 2*t1[ii] )/(dv*dv) ;
        svv = ( s2[ii] + s0[ii] - 2*s1[ii] )/(dv*dv) ;

        
        if(ii==0) {
            
            EqnConst[ii] = 0. ; 
            
            EqnConst[N+ii] = 0. ; 
            
            EqnConst[2*N+ii] = 0. ; 
            
            EqnConst[3*N+ii] = 0. ; 
            
            EqnConst[4*N+ii] = 0. ; 
            
            EqnConst[5*N+ii] = 0. ; 
            
            EqnConst[6*N+ii] = 0. ; 
            
            EqnConst[7*N+ii] = 0. ; 

            
        } else {
            
            EqnConst[ii] = (pow(1 + (s - pow(p,2)/4.)*pow(z,2),-2)*(8*pow(z,3)*(-2*(3*sv + 2*svz*z)*pow(p,2)*pow(z,2) + 3*pv*pow(p,3)*pow(z,2) - 4*p*pv*(1 + 3*s*pow(z,2) + sz*pow(z,3)) + 8*(2*svz*z*(1 + s*pow(z,2)) + sv*(1 + 3*s*pow(z,2) + sz*pow(z,3)))) + 8*pow(z,2)*(4 + 4*s*pow(z,2) - pow(p,2)*pow(z,2))*(s*(8 - 4*tz*pow(z,3)) - 2*z*(szz*z*(1 + t*pow(z,2)) + sz*(1 + 3*t*pow(z,2) + tz*pow(z,3))) + pow(p,2)*(-2 + 3*sz*pow(z,3) + tz*pow(z,3) + szz*pow(z,4))) - 4*(2 + 2*t*pow(z,2) - pow(p,2)*pow(z,2))*pow(z,4)*pow(-4*s - 2*sz*z + pow(p,2),2) - (12 + 2*t*pow(z,2) - pow(p,2)*pow(z,2) - 2*tz*pow(z,3) + tzz*pow(z,4))*pow(4 + 4*s*pow(z,2) - pow(p,2)*pow(z,2),2)))/16. ; 
            
            EqnConst[N+ii] = 0. ;
            
            EqnConst[2*N+ii] = 0. ;
            
            
            EqnConst[3*N+ii] = 0. ;
                
            EqnConst[4*N+ii] = 0. ; 
            
            EqnConst[5*N+ii] = szz + 8*pow(z,-2)*(4*s + 8*sz*z - pow(p,2) + (1 + (s - pow(p,2)/4.)*pow(z,2))*(pow(f + p + fz*z,2) + pow(h + hz*z,2)))*pow(1 + (s - pow(p,2)/4.)*pow(z,2),2)*pow(4 + 4*s*pow(z,2) - pow(p,2)*pow(z,2),-2) ; 
            
            EqnConst[6*N+ii] = azz + 4*(-4*fz*h + 4*f*hz + 4*hz*p + 4*s*z*(az + (-(fz*h) + hz*(f + p))*z) + z*(-az + fz*h*z - f*hz*z)*pow(p,2) + 2*az*sz*pow(z,2) - hz*pow(p,3)*pow(z,2))*pow(4 + 4*s*pow(z,2) - pow(p,2)*pow(z,2),-1) ;  
            
            EqnConst[7*N+ii] = svv + (pow(z,-2)*pow(4 + 4*s*pow(z,2) - pow(p,2)*pow(z,2),-1)*(1024*s - 128*t - 128*fv*p*z + 128*fz*p*z - 512*sv*z + 512*sz*z + 128*tv*z + 128*tz*z - 128*fv*fz*pow(z,2) - 128*hv*hz*pow(z,2) - 512*a*hv*p*pow(z,2) + 256*a*hz*p*pow(z,2) - 512*hv*m*p*pow(z,2) + 256*hz*m*p*pow(z,2) + 256*fv*pv*pow(z,2) - 128*fz*pv*pow(z,2) - 128*p*pvv*pow(z,2) + 1280*s*t*pow(z,2) - 32*pow(az,2)*pow(z,2) + 128*pow(fv,2)*pow(z,2) + 64*pow(fz,2)*pow(z,2) + 128*pow(hv,2)*pow(z,2) + 64*pow(hz,2)*pow(z,2) + 1024*a*m*pow(p,2)*pow(z,2) - 512*s*pow(p,2)*pow(z,2) + 64*t*pow(p,2)*pow(z,2) + 512*pow(a,2)*pow(p,2)*pow(z,2) + 512*pow(m,2)*pow(p,2)*pow(z,2) - 64*pow(p,4)*pow(z,2) + 512*pow(s,2)*pow(z,2) - 128*pow(t,2)*pow(z,2) - 256*fv*p*s*pow(z,3) + 256*fz*p*s*pow(z,3) - 256*p*pv*s*pow(z,3) - 128*fv*p*t*pow(z,3) + 256*fz*p*t*pow(z,3) - 256*sv*t*pow(z,3) + 768*sz*t*pow(z,3) + 128*t*tz*pow(z,3) + 128*sv*pow(p,2)*pow(z,3) - 384*sz*pow(p,2)*pow(z,3) - 64*tz*pow(p,2)*pow(z,3) + 128*fv*pow(p,3)*pow(z,3) - 192*fz*pow(p,3)*pow(z,3) + 64*pv*pow(p,3)*pow(z,3) - 256*fv*fz*s*pow(z,4) - 256*hv*hz*s*pow(z,4) - 1024*a*hv*p*s*pow(z,4) + 512*a*hz*p*s*pow(z,4) - 1024*hv*m*p*s*pow(z,4) + 512*hz*m*p*s*pow(z,4) + 512*fv*pv*s*pow(z,4) - 256*fz*pv*s*pow(z,4) - 128*p*pvv*s*pow(z,4) + 256*sv*sz*pow(z,4) - 128*fv*fz*t*pow(z,4) - 128*hv*hz*t*pow(z,4) + 256*a*hz*p*t*pow(z,4) + 256*hz*m*p*t*pow(z,4) - 128*fz*pv*t*pow(z,4) - 128*sz*tv*pow(z,4) - 64*p*pv*tz*pow(z,4) + 128*sv*tz*pow(z,4) - 128*sz*tz*pow(z,4) - 64*s*pow(az,2)*pow(z,4) - 32*t*pow(az,2)*pow(z,4) + 256*s*pow(fv,2)*pow(z,4) + 128*s*pow(fz,2)*pow(z,4) + 128*t*pow(fz,2)*pow(z,4) + 256*s*pow(hv,2)*pow(z,4) + 128*s*pow(hz,2)*pow(z,4) + 128*t*pow(hz,2)*pow(z,4) + 128*fv*fz*pow(p,2)*pow(z,4) + 128*hv*hz*pow(p,2)*pow(z,4) - 128*fv*pv*pow(p,2)*pow(z,4) + 128*fz*pv*pow(p,2)*pow(z,4) + 2048*a*m*s*pow(p,2)*pow(z,4) + 64*s*t*pow(p,2)*pow(z,4) + 1024*s*pow(a,2)*pow(p,2)*pow(z,4) + 32*pow(az,2)*pow(p,2)*pow(z,4) - 64*pow(fv,2)*pow(p,2)*pow(z,4) - 96*pow(fz,2)*pow(p,2)*pow(z,4) - 64*pow(hv,2)*pow(p,2)*pow(z,4) - 96*pow(hz,2)*pow(p,2)*pow(z,4) + 1024*s*pow(m,2)*pow(p,2)*pow(z,4) + 256*a*hv*pow(p,3)*pow(z,4) - 256*a*hz*pow(p,3)*pow(z,4) + 256*hv*m*pow(p,3)*pow(z,4) - 256*hz*m*pow(p,3)*pow(z,4) + 32*pvv*pow(p,3)*pow(z,4) - 512*a*m*pow(p,4)*pow(z,4) - 192*s*pow(p,4)*pow(z,4) - 104*t*pow(p,4)*pow(z,4) - 256*pow(a,2)*pow(p,4)*pow(z,4) - 256*pow(m,2)*pow(p,4)*pow(z,4) + 64*pow(p,6)*pow(z,4) + 128*s*pow(pv,2)*pow(z,4) - 32*pow(p,2)*pow(pv,2)*pow(z,4) + 384*t*pow(s,2)*pow(z,4) - 128*pow(sz,2)*pow(z,4) + 256*s*pow(t,2)*pow(z,4) - 256*fv*p*s*t*pow(z,5) + 512*fz*p*s*t*pow(z,5) - 384*p*pv*s*t*pow(z,5) + 256*s*sv*t*pow(z,5) - 256*s*sz*t*pow(z,5) - 128*s*sv*pow(p,2)*pow(z,5) + 128*s*sz*pow(p,2)*pow(z,5) - 64*sv*t*pow(p,2)*pow(z,5) - 192*sz*t*pow(p,2)*pow(z,5) + 64*s*tv*pow(p,2)*pow(z,5) + 64*s*tz*pow(p,2)*pow(z,5) + 192*fv*s*pow(p,3)*pow(z,5) - 320*fz*s*pow(p,3)*pow(z,5) + 192*pv*s*pow(p,3)*pow(z,5) + 64*fv*t*pow(p,3)*pow(z,5) - 256*fz*t*pow(p,3)*pow(z,5) + 96*pv*t*pow(p,3)*pow(z,5) + 32*sv*pow(p,4)*pow(z,5) + 32*sz*pow(p,4)*pow(z,5) - 8*tv*pow(p,4)*pow(z,5) - 8*tz*pow(p,4)*pow(z,5) - 40*fv*pow(p,5)*pow(z,5) + 104*fz*pow(p,5)*pow(z,5) - 48*pv*pow(p,5)*pow(z,5) - 128*fv*p*pow(s,2)*pow(z,5) + 128*fz*p*pow(s,2)*pow(z,5) - 128*tv*pow(s,2)*pow(z,5) - 128*tz*pow(s,2)*pow(z,5) + 128*fz*p*pow(t,2)*pow(z,5) + 256*sz*pow(t,2)*pow(z,5) + 128*p*pv*s*sz*pow(z,6) - 256*fv*fz*s*t*pow(z,6) - 256*hv*hz*s*t*pow(z,6) + 512*a*hz*p*s*t*pow(z,6) + 512*hz*m*p*s*t*pow(z,6) - 256*fz*pv*s*t*pow(z,6) - 128*p*pv*sz*t*pow(z,6) + 256*sv*sz*t*pow(z,6) - 128*s*sz*tv*pow(z,6) - 64*p*pv*s*tz*pow(z,6) + 128*s*sv*tz*pow(z,6) - 128*s*sz*tz*pow(z,6) - 128*sz*t*tz*pow(z,6) - 64*s*t*pow(az,2)*pow(z,6) + 256*s*t*pow(fz,2)*pow(z,6) + 256*s*t*pow(hz,2)*pow(z,6) + 192*fv*fz*s*pow(p,2)*pow(z,6) + 192*hv*hz*s*pow(p,2)*pow(z,6) - 128*fv*pv*s*pow(p,2)*pow(z,6) + 192*fz*pv*s*pow(p,2)*pow(z,6) - 128*sv*sz*pow(p,2)*pow(z,6) + 64*fv*fz*t*pow(p,2)*pow(z,6) + 64*hv*hz*t*pow(p,2)*pow(z,6) + 64*fz*pv*t*pow(p,2)*pow(z,6) + 32*sz*tv*pow(p,2)*pow(z,6) - 32*sv*tz*pow(p,2)*pow(z,6) + 96*sz*tz*pow(p,2)*pow(z,6) + 48*s*pow(az,2)*pow(p,2)*pow(z,6) + 16*t*pow(az,2)*pow(p,2)*pow(z,6) - 64*s*pow(fv,2)*pow(p,2)*pow(z,6) - 160*s*pow(fz,2)*pow(p,2)*pow(z,6) - 128*t*pow(fz,2)*pow(p,2)*pow(z,6) - 64*s*pow(hv,2)*pow(p,2)*pow(z,6) - 160*s*pow(hz,2)*pow(p,2)*pow(z,6) - 128*t*pow(hz,2)*pow(p,2)*pow(z,6) + 256*a*hv*s*pow(p,3)*pow(z,6) - 384*a*hz*s*pow(p,3)*pow(z,6) + 256*hv*m*s*pow(p,3)*pow(z,6) - 384*hz*m*s*pow(p,3)*pow(z,6) + 32*pv*sz*pow(p,3)*pow(z,6) - 128*a*hz*t*pow(p,3)*pow(z,6) - 128*hz*m*t*pow(p,3)*pow(z,6) + 16*pv*tz*pow(p,3)*pow(z,6) - 40*fv*fz*pow(p,4)*pow(z,6) - 40*hv*hz*pow(p,4)*pow(z,6) + 16*fv*pv*pow(p,4)*pow(z,6) - 40*fz*pv*pow(p,4)*pow(z,6) - 512*a*m*s*pow(p,4)*pow(z,6) - 320*s*t*pow(p,4)*pow(z,6) - 256*s*pow(a,2)*pow(p,4)*pow(z,6) - 10*pow(az,2)*pow(p,4)*pow(z,6) + 8*pow(fv,2)*pow(p,4)*pow(z,6) + 52*pow(fz,2)*pow(p,4)*pow(z,6) + 8*pow(hv,2)*pow(p,4)*pow(z,6) + 52*pow(hz,2)*pow(p,4)*pow(z,6) - 256*s*pow(m,2)*pow(p,4)*pow(z,6) - 32*a*hv*pow(p,5)*pow(z,6) + 80*a*hz*pow(p,5)*pow(z,6) - 32*hv*m*pow(p,5)*pow(z,6) + 80*hz*m*pow(p,5)*pow(z,6) + 64*a*m*pow(p,6)*pow(z,6) + 112*s*pow(p,6)*pow(z,6) + 56*t*pow(p,6)*pow(z,6) + 32*pow(a,2)*pow(p,6)*pow(z,6) + 32*pow(m,2)*pow(p,6)*pow(z,6) - 18*pow(p,8)*pow(z,6) - 64*s*pow(p,2)*pow(pv,2)*pow(z,6) + 8*pow(p,4)*pow(pv,2)*pow(z,6) - 128*fv*fz*pow(s,2)*pow(z,6) - 128*hv*hz*pow(s,2)*pow(z,6) - 512*a*hv*p*pow(s,2)*pow(z,6) + 256*a*hz*p*pow(s,2)*pow(z,6) - 512*hv*m*p*pow(s,2)*pow(z,6) + 256*hz*m*p*pow(s,2)*pow(z,6) + 256*fv*pv*pow(s,2)*pow(z,6) - 128*fz*pv*pow(s,2)*pow(z,6) - 32*pow(az,2)*pow(s,2)*pow(z,6) + 128*pow(fv,2)*pow(s,2)*pow(z,6) + 64*pow(fz,2)*pow(s,2)*pow(z,6) + 128*pow(hv,2)*pow(s,2)*pow(z,6) + 64*pow(hz,2)*pow(s,2)*pow(z,6) + 1024*a*m*pow(p,2)*pow(s,2)*pow(z,6) + 384*t*pow(p,2)*pow(s,2)*pow(z,6) + 512*pow(a,2)*pow(p,2)*pow(s,2)*pow(z,6) + 512*pow(m,2)*pow(p,2)*pow(s,2)*pow(z,6) - 160*pow(p,4)*pow(s,2)*pow(z,6) + 128*pow(pv,2)*pow(s,2)*pow(z,6) - 256*t*pow(sz,2)*pow(z,6) + 128*pow(p,2)*pow(sz,2)*pow(z,6) + 64*pow(fz,2)*pow(t,2)*pow(z,6) + 64*pow(hz,2)*pow(t,2)*pow(z,6) + 192*s*pow(p,2)*pow(t,2)*pow(z,6) - 40*pow(p,4)*pow(t,2)*pow(z,6) - 128*pow(s,2)*pow(t,2)*pow(z,6) + 256*s*sz*t*pow(p,2)*pow(z,7) + 64*s*t*tz*pow(p,2)*pow(z,7) + 64*fv*s*t*pow(p,3)*pow(z,7) - 384*fz*s*t*pow(p,3)*pow(z,7) + 64*pv*s*t*pow(p,3)*pow(z,7) - 64*s*sz*pow(p,4)*pow(z,7) - 64*sz*t*pow(p,4)*pow(z,7) - 32*s*tz*pow(p,4)*pow(z,7) - 8*t*tz*pow(p,4)*pow(z,7) - 32*fv*s*pow(p,5)*pow(z,7) + 128*fz*s*pow(p,5)*pow(z,7) - 32*pv*s*pow(p,5)*pow(z,7) - 8*fv*t*pow(p,5)*pow(z,7) + 80*fz*t*pow(p,5)*pow(z,7) - 8*pv*t*pow(p,5)*pow(z,7) + 16*sz*pow(p,6)*pow(z,7) + 4*tz*pow(p,6)*pow(z,7) + 4*fv*pow(p,7)*pow(z,7) - 24*fz*pow(p,7)*pow(z,7) + 4*pv*pow(p,7)*pow(z,7) - 128*fv*p*t*pow(s,2)*pow(z,7) + 256*fz*p*t*pow(s,2)*pow(z,7) - 128*p*pv*t*pow(s,2)*pow(z,7) - 128*t*tz*pow(s,2)*pow(z,7) + 64*tz*pow(p,2)*pow(s,2)*pow(z,7) + 64*fv*pow(p,3)*pow(s,2)*pow(z,7) - 128*fz*pow(p,3)*pow(s,2)*pow(z,7) + 64*pv*pow(p,3)*pow(s,2)*pow(z,7) + 256*fz*p*s*pow(t,2)*pow(z,7) - 256*s*sz*pow(t,2)*pow(z,7) + 64*sz*pow(p,2)*pow(t,2)*pow(z,7) - 64*fz*pow(p,3)*pow(t,2)*pow(z,7) - 128*s*sz*t*tz*pow(z,8) + 64*fv*fz*s*t*pow(p,2)*pow(z,8) + 64*hv*hz*s*t*pow(p,2)*pow(z,8) + 64*fz*pv*s*t*pow(p,2)*pow(z,8) + 64*s*sz*tz*pow(p,2)*pow(z,8) + 32*sz*t*tz*pow(p,2)*pow(z,8) + 16*s*t*pow(az,2)*pow(p,2)*pow(z,8) - 192*s*t*pow(fz,2)*pow(p,2)*pow(z,8) - 192*s*t*pow(hz,2)*pow(p,2)*pow(z,8) - 128*a*hz*s*t*pow(p,3)*pow(z,8) - 128*hz*m*s*t*pow(p,3)*pow(z,8) - 32*fv*fz*s*pow(p,4)*pow(z,8) - 32*hv*hz*s*pow(p,4)*pow(z,8) - 32*fz*pv*s*pow(p,4)*pow(z,8) - 8*fv*fz*t*pow(p,4)*pow(z,8) - 8*hv*hz*t*pow(p,4)*pow(z,8) - 8*fz*pv*t*pow(p,4)*pow(z,8) - 16*sz*tz*pow(p,4)*pow(z,8) - 8*s*pow(az,2)*pow(p,4)*pow(z,8) - 2*t*pow(az,2)*pow(p,4)*pow(z,8) + 64*s*pow(fz,2)*pow(p,4)*pow(z,8) + 40*t*pow(fz,2)*pow(p,4)*pow(z,8) + 64*s*pow(hz,2)*pow(p,4)*pow(z,8) + 40*t*pow(hz,2)*pow(p,4)*pow(z,8) + 64*a*hz*s*pow(p,5)*pow(z,8) + 64*hz*m*s*pow(p,5)*pow(z,8) + 16*a*hz*t*pow(p,5)*pow(z,8) + 16*hz*m*t*pow(p,5)*pow(z,8) + 4*fv*fz*pow(p,6)*pow(z,8) + 4*hv*hz*pow(p,6)*pow(z,8) + 4*fz*pv*pow(p,6)*pow(z,8) + 32*s*t*pow(p,6)*pow(z,8) + pow(az,2)*pow(p,6)*pow(z,8) - 12*pow(fz,2)*pow(p,6)*pow(z,8) - 12*pow(hz,2)*pow(p,6)*pow(z,8) - 8*a*hz*pow(p,7)*pow(z,8) - 8*hz*m*pow(p,7)*pow(z,8) - 8*s*pow(p,8)*pow(z,8) - 4*t*pow(p,8)*pow(z,8) + pow(p,10)*pow(z,8) - 128*fv*fz*t*pow(s,2)*pow(z,8) - 128*hv*hz*t*pow(s,2)*pow(z,8) + 256*a*hz*p*t*pow(s,2)*pow(z,8) + 256*hz*m*p*t*pow(s,2)*pow(z,8) - 128*fz*pv*t*pow(s,2)*pow(z,8) - 32*t*pow(az,2)*pow(s,2)*pow(z,8) + 128*t*pow(fz,2)*pow(s,2)*pow(z,8) + 128*t*pow(hz,2)*pow(s,2)*pow(z,8) + 64*fv*fz*pow(p,2)*pow(s,2)*pow(z,8) + 64*hv*hz*pow(p,2)*pow(s,2)*pow(z,8) + 64*fz*pv*pow(p,2)*pow(s,2)*pow(z,8) + 16*pow(az,2)*pow(p,2)*pow(s,2)*pow(z,8) - 64*pow(fz,2)*pow(p,2)*pow(s,2)*pow(z,8) - 64*pow(hz,2)*pow(p,2)*pow(s,2)*pow(z,8) - 128*a*hz*pow(p,3)*pow(s,2)*pow(z,8) - 128*hz*m*pow(p,3)*pow(s,2)*pow(z,8) - 64*t*pow(p,4)*pow(s,2)*pow(z,8) + 16*pow(p,6)*pow(s,2)*pow(z,8) + 128*t*pow(p,2)*pow(sz,2)*pow(z,8) - 32*pow(p,4)*pow(sz,2)*pow(z,8) + 128*s*pow(fz,2)*pow(t,2)*pow(z,8) + 128*s*pow(hz,2)*pow(t,2)*pow(z,8) - 32*pow(fz,2)*pow(p,2)*pow(t,2)*pow(z,8) - 32*pow(hz,2)*pow(p,2)*pow(t,2)*pow(z,8) - 32*s*pow(p,4)*pow(t,2)*pow(z,8) + 4*pow(p,6)*pow(t,2)*pow(z,8) + 64*pow(p,2)*pow(s,2)*pow(t,2)*pow(z,8) - 128*pow(sz,2)*pow(t,2)*pow(z,8) + 64*fz*s*t*pow(p,5)*pow(z,9) - 16*fz*s*pow(p,7)*pow(z,9) - 8*fz*t*pow(p,7)*pow(z,9) + 2*fz*pow(p,9)*pow(z,9) - 128*fz*t*pow(p,3)*pow(s,2)*pow(z,9) + 32*fz*pow(p,5)*pow(s,2)*pow(z,9) - 64*fz*s*pow(p,3)*pow(t,2)*pow(z,9) + 8*fz*pow(p,5)*pow(t,2)*pow(z,9) + 128*fz*p*pow(s,2)*pow(t,2)*pow(z,9) + 32*s*t*pow(fz,2)*pow(p,4)*pow(z,10) + 32*s*t*pow(hz,2)*pow(p,4)*pow(z,10) - 8*s*pow(fz,2)*pow(p,6)*pow(z,10) - 4*t*pow(fz,2)*pow(p,6)*pow(z,10) - 8*s*pow(hz,2)*pow(p,6)*pow(z,10) - 4*t*pow(hz,2)*pow(p,6)*pow(z,10) + pow(fz,2)*pow(p,8)*pow(z,10) + pow(hz,2)*pow(p,8)*pow(z,10) - 64*t*pow(fz,2)*pow(p,2)*pow(s,2)*pow(z,10) - 64*t*pow(hz,2)*pow(p,2)*pow(s,2)*pow(z,10) + 16*pow(fz,2)*pow(p,4)*pow(s,2)*pow(z,10) + 16*pow(hz,2)*pow(p,4)*pow(s,2)*pow(z,10) - 32*s*pow(fz,2)*pow(p,2)*pow(t,2)*pow(z,10) - 32*s*pow(hz,2)*pow(p,2)*pow(t,2)*pow(z,10) + 4*pow(fz,2)*pow(p,4)*pow(t,2)*pow(z,10) + 4*pow(hz,2)*pow(p,4)*pow(t,2)*pow(z,10) + 64*pow(fz,2)*pow(s,2)*pow(t,2)*pow(z,10) + 64*pow(hz,2)*pow(s,2)*pow(t,2)*pow(z,10) + pow(f,2)*(12 + 64*a*m*pow(z,2) + 32*pow(a,2)*pow(z,2) + 32*pow(m,2)*pow(z,2) - 8*pow(p,2)*pow(z,2) - 4*t*pow(z,2)*(-4 + pow(p,2)*pow(z,2)) + pow(p,4)*pow(z,4) + 4*pow(t,2)*pow(z,4))*pow(4 + 4*s*pow(z,2) - pow(p,2)*pow(z,2),2) + pow(h,2)*(12 + 64*a*m*pow(z,2) + 32*pow(a,2)*pow(z,2) + 32*pow(m,2)*pow(z,2) - 8*pow(p,2)*pow(z,2) - 4*t*pow(z,2)*(-4 + pow(p,2)*pow(z,2)) + pow(p,4)*pow(z,4) + 4*pow(t,2)*pow(z,4))*pow(4 + 4*s*pow(z,2) - pow(p,2)*pow(z,2),2) + 2*h*z*(-4*hv + 4*hz + 16*a*fv*z + 16*fv*m*z + 16*(a + m)*pv*z - 4*hv*t*pow(z,2) + 8*hz*t*pow(z,2) + 2*hv*pow(p,2)*pow(z,2) - 4*hz*pow(p,2)*pow(z,2) - 4*fz*(a + m)*z*(2 + 2*t*pow(z,2) - pow(p,2)*pow(z,2)) - 4*hz*t*pow(p,2)*pow(z,4) + hz*pow(p,4)*pow(z,4) + 4*hz*pow(t,2)*pow(z,4))*pow(4 + 4*s*pow(z,2) - pow(p,2)*pow(z,2),2) + 2*f*(-4*pow(p,3)*pow(z,2)*(2 + t*pow(z,2)) - 2*pow(p,2)*(-fv - pv + 2*a*hz*z + 2*hz*m*z + 2*fz*(1 + t*pow(z,2)))*pow(z,3) + pow(p,5)*pow(z,4) + 4*p*(3 + 16*a*m*pow(z,2) + 4*t*pow(z,2) + 8*pow(a,2)*pow(z,2) + 8*pow(m,2)*pow(z,2) + pow(t,2)*pow(z,4)) + fz*pow(p,4)*pow(z,5) + 4*z*(-fv - 4*a*hv*z + 2*a*hz*z - 4*hv*m*z + 2*hz*m*z - fv*t*pow(z,2) - pv*(1 + t*pow(z,2)) + 2*a*hz*t*pow(z,3) + 2*hz*m*t*pow(z,3) + fz*pow(1 + t*pow(z,2),2)))*pow(4 + 4*s*pow(z,2) - pow(p,2)*pow(z,2),2)))/64. ; 
            
        }
        
    }
    
    
}









void setupCheb(void)
{
    int ii, jj, kk ;
    
    
    /* Std - for r  */
    
    for(ii=0;ii<N;ii++) {
        
        x[ii] = (1 + cos(PI*(((double) (N-ii))-1)/(((double) N)-1)) )/2 ;
        
    }
    
    for(ii=1;ii<N-1;ii++) {
		for(jj=1;jj<N-1;jj++) {
            
            if(ii==jj) 
                Dmat[ii][jj] = - (x[jj] - 0.5)/(2*(1-x[jj])*x[jj]) ;
            else
                Dmat[ii][jj] = ((double) pow(-1,ii+jj))/( x[ii] - x[jj] ) ;
            
        }
    }
    
    Dmat[0][0] = - ( 2*((double) pow(N-1,2)) + 1 )/3 ;
    
    for(jj=1;jj<N-1;jj++) {
        
        Dmat[0][jj] = -2*((double) pow(-1.,jj))/x[jj] ;
        
    }
    
    Dmat[0][N-1] = - pow(-1,N-1) ;
    
    Dmat[N-1][N-1] = + ( 2*((double) pow(N-1,2)) + 1 )/3 ;
    
    for(jj=1;jj<N-1;jj++) {
        
        Dmat[N-1][jj] = 2*((double) pow(-1,N+jj-1))/(1 - x[jj]) ;
        
    }
    
    Dmat[N-1][0] = + pow(-1,N-1) ;
    
    for(ii=1;ii<N-1;ii++) {
        
        Dmat[ii][0] = +((double) pow(-1,ii))/x[ii]/2 ;
        
    }
    
    for(ii=1;ii<N-1;ii++) {
        
        Dmat[ii][N-1] = - ((double) pow(-1,N+ii-1))/(1 - x[ii])/2 ;
        
    }
    
    for(ii=0;ii<N;ii++) {
        for(jj=0;jj<N;jj++) {
            
            D2mat[ii][jj] = 0. ;
            
            for(kk=0;kk<N;kk++) {
                D2mat[ii][jj] += Dmat[ii][kk]*Dmat[kk][jj] ;
            }
            
        }
    }
    
    
}





void unpackLich(void)
{
    int ii, jj ;
    
	for(ii=0;ii<1+5*N;ii++) {
        for(jj=0;jj<1+5*N;jj++) {
            
            Lmat[ jj*(1+5*N) + ii ] = Lich[ii][jj] ;
            
        }
    }
    
}



/* LAPACK solver */

void linsolve(double *x, double *b)
{
    int ii, Nvec, nrhs, ldLmat, ldx, info ;
    int ipiv[1+5*Nmax];
    
    
    unpackLich() ;
    
    Nvec    = 1+5*N ;
    nrhs = 1 ;
    ldLmat  = Nvec ;
    ldx  = Nvec ;
    
    for(ii=0;ii<Nvec;ii++) x[ii] = b[ii] ;
    
    dgesv_(&Nvec, &nrhs, Lmat, &ldLmat, ipiv, x, &ldx, &info);
    
    if(info != 0) {
        
        printf("\n\nFailure to solve linear system - %d\n\n", info);
        
        exit(1) ;
        
    }
    
    
}






