(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    396811,       9840]
NotebookOptionsPosition[    394417,       9771]
NotebookOutlinePosition[    394773,       9787]
CellTagsIndexPosition[    394730,       9784]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Dynamic AdS/CMT - Superconductor - Spectral - Broken phase

Create data; using SuperSpecCN3.nb  (in AdSCMTDyn2)

q = 2 case of H^3\
\>", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
   3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
   3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
   3.495174647742872*^9, 3.460515504326817*^9}, {3.503996600043788*^9, 
   3.503996603042028*^9}, {3.507011572545054*^9, 3.460340667971311*^9}, {
   3.5374843541262083`*^9, 3.537484358716886*^9}, 3.537484391202265*^9, {
   3.537484629914453*^9, 3.537484630281348*^9}, {3.5374893532274837`*^9, 
   3.537489358050692*^9}, {3.5376274940424433`*^9, 3.537627498480837*^9}, {
   3.543863578659968*^9, 3.543863585914144*^9}, {3.544251595911763*^9, 
   3.5442516168772583`*^9}}],

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["Summary - Must Run.", "Subsubtitle",
 CellChangeTimes->{{3.538463037602364*^9, 3.538463043377323*^9}, {
  3.538464312857139*^9, 3.538464319392853*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"replasym", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p2", "\[Rule]", "asymp2"}], ",", 
      RowBox[{"h2", "\[Rule]", "asymh2"}], ",", 
      RowBox[{"a0", "\[Rule]", "asyma0"}], ",", 
      RowBox[{"a1", "\[Rule]", "asyma1"}], ",", 
      RowBox[{"T3", "\[Rule]", "asymT3"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"replhoriz", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t1", "\[Rule]", "horizt1"}], ",", 
     RowBox[{"a1", "\[Rule]", "horiza1"}], ",", 
     RowBox[{"p0", "\[Rule]", "horizp0"}], ",", 
     RowBox[{"h0", "\[Rule]", "horizh0"}], ",", 
     RowBox[{"s0", "\[Rule]", "horizs0"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.537873163678542*^9, 3.537873275606132*^9}, {
  3.538464304756454*^9, 3.53846431129167*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"horizp", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"p0", "-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"p0", "+", 
          RowBox[{"a1", " ", "h0", " ", 
           SuperscriptBox["z0", "2"]}]}], ")"}]}], 
       RowBox[{"t1", " ", 
        SuperscriptBox["z0", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["p0", "3"]}], "-", 
          RowBox[{"12", " ", "a1", " ", "h0", " ", 
           SuperscriptBox["p0", "2"], " ", 
           SuperscriptBox["z0", "2"]}], "+", 
          RowBox[{"p0", " ", 
           RowBox[{"(", 
            RowBox[{"16", "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["h0", "2"]}], "-", 
             RowBox[{"8", " ", "t1", " ", "z0"}], "-", 
             RowBox[{"11", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
          RowBox[{"a1", " ", "h0", " ", 
           SuperscriptBox["z0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"28", "-", 
             RowBox[{"12", " ", 
              SuperscriptBox["h0", "2"]}], "-", 
             RowBox[{"8", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["t1", "2"], " ", 
        SuperscriptBox["z0", "4"]}]], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"72", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "6"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"48", " ", 
          SuperscriptBox["p0", "5"]}], "+", 
         RowBox[{"96", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "4"], " ", 
          SuperscriptBox["z0", "2"]}], "-", 
         RowBox[{"24", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"36", "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"18", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"3", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"11", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"p0", " ", 
          RowBox[{"(", 
           RowBox[{"592", "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "4"]}], "-", 
            RowBox[{"576", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"972", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"396", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "-", 
            RowBox[{"51", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               RowBox[{"3", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"12", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "108"}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["h0", "4"]}], "+", 
            RowBox[{"84", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"72", "-", 
               RowBox[{"36", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"14", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"576", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"288", " ", 
          SuperscriptBox["p0", "7"]}], "-", 
         RowBox[{"96", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "6"], " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["p0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"85", "+", 
            RowBox[{"18", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"24", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"104", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"48", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "4"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"60", "-", 
            RowBox[{"6", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"48", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"85", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"6", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"2640", "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "4"]}], "+", 
            RowBox[{"864", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"940", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"57", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "60"}], "+", 
               RowBox[{"48", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"85", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"36", "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"2352", "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["h0", "4"]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"3880", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"703", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"192", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "11792"}], "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "6"]}], "+", 
            RowBox[{"576", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"1968", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"273", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"24", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "60"}], "+", 
               RowBox[{"48", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"85", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"576", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "27"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"216", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2640", "+", 
               RowBox[{"864", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"940", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"57", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"96", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"p0", " ", 
          RowBox[{"(", 
           RowBox[{"10240", "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["h0", "6"]}], "-", 
            RowBox[{"1152", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"24624", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"2847", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"27", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"432", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"24", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "592"}], "+", 
               RowBox[{"972", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "+", 
               RowBox[{"288", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"3880", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"703", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"192", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"9", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"7200", " ", 
         SuperscriptBox["t1", "5"], " ", 
         SuperscriptBox["z0", "10"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2880", " ", 
          SuperscriptBox["p0", "9"]}], "-", 
         RowBox[{"192", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "8"], " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["p0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"1158", "+", 
            RowBox[{"240", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"300", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"769", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"12", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "4"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5940", "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["h0", "4"]}], "+", 
            RowBox[{"4800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"29596", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"3345", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"60", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1000", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"12", "+", 
               RowBox[{"17", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"80860", "+", 
            RowBox[{"4320", " ", 
             SuperscriptBox["h0", "4"]}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"98520", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"50325", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"36", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1158"}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"600", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"48", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "6"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["h0", "2"]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"8", "-", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"3", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"83712", "+", 
            RowBox[{"256", " ", 
             SuperscriptBox["h0", "6"]}], "-", 
            RowBox[{"28800", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"79320", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"8952", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"165", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"240", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"4800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"36", "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"100", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2640", "+", 
               RowBox[{"940", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"57", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"5940", "+", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"29596", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3345", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"1000", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"618016", "+", 
            RowBox[{"11520", " ", 
             SuperscriptBox["h0", "6"]}], "-", 
            RowBox[{"28800", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"918720", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"467922", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"17925", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"144", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1158"}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"28800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"300", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2352", "+", 
               RowBox[{"3880", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"703", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"40", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"16172", "+", 
               RowBox[{"1440", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"19704", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"10065", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"p0", " ", 
          RowBox[{"(", 
           RowBox[{"294400", "+", 
            RowBox[{"2880", " ", 
             SuperscriptBox["h0", "8"]}], "-", 
            RowBox[{"787376", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"14400", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"176115", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"177", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1158"}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"600", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "592"}], "+", 
               RowBox[{"972", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"50", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "10240"}], "+", 
               RowBox[{"24624", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2847", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"20", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"16172", "+", 
               RowBox[{"1440", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"19704", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"10065", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"618016", "-", 
               RowBox[{"28800", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"918720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"467922", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"17925", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"28800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"9", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "+", 
                  RowBox[{"3880", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"703", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"192", " ", 
             SuperscriptBox["h0", "8"]}], "-", 
            RowBox[{"240", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"5940", "+", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"29596", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3345", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"1000", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "127904"}], "+", 
               RowBox[{"34864", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"2880", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13509", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"201", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"5760", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "27"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"1440", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"28", "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"20", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "11792"}], "+", 
                  RowBox[{"1968", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"273", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"28800", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2640", "+", 
                  RowBox[{"940", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"57", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"3", " ", 
                RowBox[{"(", 
                 RowBox[{"27904", "+", 
                  RowBox[{"26440", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"2984", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"55", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"518400", " ", 
         SuperscriptBox["t1", "6"], " ", 
         SuperscriptBox["z0", "12"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"172800", " ", 
          SuperscriptBox["p0", "11"]}], "-", 
         RowBox[{"4608", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "10"], " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"1152", " ", 
          SuperscriptBox["p0", "9"], " ", 
          RowBox[{"(", 
           RowBox[{"3655", "+", 
            RowBox[{"750", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"900", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"741", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"1152", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "8"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "124"}], "-", 
            RowBox[{"20", " ", 
             SuperscriptBox["h0", "2"]}], "+", 
            RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"5375", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"288", " ", 
          SuperscriptBox["p0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"121042", "+", 
            RowBox[{"6000", " ", 
             SuperscriptBox["h0", "4"]}], "+", 
            RowBox[{"9000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"57561", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"109660", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"60", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1158", "+", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"288", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "6"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1982"}], "+", 
            RowBox[{"160", " ", 
             SuperscriptBox["h0", "4"]}], "+", 
            RowBox[{"3000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"182508", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"42045", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"300", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"24", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "4"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"482264", "-", 
            RowBox[{"1920", " ", 
             SuperscriptBox["h0", "6"]}], "-", 
            RowBox[{"288000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"4989942", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"549546", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"42795", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"90000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"12", "+", 
               RowBox[{"17", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"180", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"5940", "+", 
               RowBox[{"29596", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3345", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"36", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1982"}], "+", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"182508", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"42045", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"351", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"72", " ", 
          SuperscriptBox["p0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"1609360", "+", 
            RowBox[{"24000", " ", 
             SuperscriptBox["h0", "6"]}], "-", 
            RowBox[{"48000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"1453810", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"2057109", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"170735", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"6000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"100", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16172"}], "+", 
               RowBox[{"19704", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"10065", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"121042", "+", 
               RowBox[{"9000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"57561", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"109660", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"1158", "+", 
                  RowBox[{"769", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"48395008", "+", 
            RowBox[{"288000", " ", 
             SuperscriptBox["h0", "8"]}], "+", 
            RowBox[{"47872928", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"864000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"62340036", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"4514562", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"71055", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1536", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"18000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "+", 
               RowBox[{"3880", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"703", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"120", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"618016", "+", 
               RowBox[{"918720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"467922", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"17925", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"121042", "+", 
               RowBox[{"9000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"57561", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"109660", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"1158", "+", 
                  RowBox[{"769", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1609360"}], "+", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"1453810", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2057109", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"170735", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"6000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16172"}], "+", 
                  RowBox[{"19704", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"10065", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"12", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1920", " ", 
             SuperscriptBox["h0", "8"]}], "-", 
            RowBox[{"384", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"72", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1982"}], "+", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"182508", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"42045", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"351", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "482264"}], "+", 
               RowBox[{"288000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"4989942", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"549546", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"42795", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"90000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"5940", "+", 
                  RowBox[{"29596", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3345", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "521600"}], "+", 
               RowBox[{"2056640", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"216000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"966577", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"52500", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "-", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"1500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2640", "+", 
                  RowBox[{"940", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"57", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"90", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"27904", "+", 
                  RowBox[{"26440", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"2984", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"55", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"3", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "33384960"}], "+", 
            RowBox[{"1536", " ", 
             SuperscriptBox["h0", "10"]}], "+", 
            RowBox[{"8375008", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"345600", " ", 
             SuperscriptBox["t1", "5"], " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{"9631980", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"342219", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"1125", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "27"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"216000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"384", " ", 
             SuperscriptBox["h0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"6000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "11792"}], "+", 
               RowBox[{"1968", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"273", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"600", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "127904"}], "+", 
               RowBox[{"34864", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13509", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"201", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1982"}], "+", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"182508", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"42045", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"351", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "482264"}], "+", 
               RowBox[{"288000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"4989942", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"549546", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"42795", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"90000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"5940", "+", 
                  RowBox[{"29596", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3345", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "521600"}], "+", 
               RowBox[{"2056640", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"216000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"966577", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"52500", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "-", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"1500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2640", "+", 
                  RowBox[{"940", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"57", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"90", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"27904", "+", 
                  RowBox[{"26440", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"2984", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"55", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"p0", " ", 
          RowBox[{"(", 
           RowBox[{"51673600", "+", 
            RowBox[{"172800", " ", 
             SuperscriptBox["h0", "10"]}], "-", 
            RowBox[{"126831744", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"1036800", " ", 
             SuperscriptBox["t1", "5"], " ", 
             SuperscriptBox["z0", "5"]}], "-", 
            RowBox[{"55181280", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"1195533", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"82845", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"648000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1152", " ", 
             SuperscriptBox["h0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"72000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "592"}], "+", 
               RowBox[{"972", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"9000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "10240"}], "+", 
               RowBox[{"24624", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2847", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "-", 
            RowBox[{"360", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"294400", "-", 
               RowBox[{"787376", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"176115", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"177", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"121042", "+", 
               RowBox[{"9000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"57561", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"109660", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"1158", "+", 
                  RowBox[{"769", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1609360"}], "+", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"1453810", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2057109", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"170735", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"6000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16172"}], "+", 
                  RowBox[{"19704", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"10065", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"48395008", "+", 
               RowBox[{"47872928", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"864000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"62340036", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"4514562", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"71055", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "-", 
               RowBox[{"1152000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"9", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"18000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "+", 
                  RowBox[{"3880", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"703", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"618016", "+", 
                  RowBox[{"918720", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"467922", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"17925", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"horizh", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"h0", "+", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "h0"}], "+", 
          RowBox[{"a1", " ", "p0", " ", 
           SuperscriptBox["z0", "2"]}]}], ")"}]}], 
       RowBox[{"t1", " ", 
        SuperscriptBox["z0", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["h0", "3"]}], "+", 
          RowBox[{"12", " ", "a1", " ", 
           SuperscriptBox["h0", "2"], " ", "p0", " ", 
           SuperscriptBox["z0", "2"]}], "+", 
          RowBox[{"h0", " ", 
           RowBox[{"(", 
            RowBox[{"16", "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["p0", "2"]}], "-", 
             RowBox[{"8", " ", "t1", " ", "z0"}], "-", 
             RowBox[{"11", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
          RowBox[{"a1", " ", "p0", " ", 
           SuperscriptBox["z0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "28"}], "+", 
             RowBox[{"12", " ", 
              SuperscriptBox["p0", "2"]}], "+", 
             RowBox[{"8", " ", "t1", " ", "z0"}], "-", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["t1", "2"], " ", 
        SuperscriptBox["z0", "4"]}]], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"72", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "6"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"48", " ", 
          SuperscriptBox["h0", "5"]}], "-", 
         RowBox[{"96", " ", "a1", " ", 
          SuperscriptBox["h0", "4"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"24", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"36", "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"18", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"3", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"11", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"h0", " ", 
          RowBox[{"(", 
           RowBox[{"592", "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"576", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"972", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"396", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "-", 
            RowBox[{"51", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               RowBox[{"3", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"12", " ", "a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "108"}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"84", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"72", "-", 
               RowBox[{"36", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"14", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"576", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"288", " ", 
          SuperscriptBox["h0", "7"]}], "+", 
         RowBox[{"96", " ", "a1", " ", 
          SuperscriptBox["h0", "6"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["h0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"85", "+", 
            RowBox[{"18", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"24", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"104", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"48", " ", "a1", " ", 
          SuperscriptBox["h0", "4"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"60", "-", 
            RowBox[{"6", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"48", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"85", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"6", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"2640", "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"864", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"940", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"57", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "60"}], "+", 
               RowBox[{"48", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"85", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"36", "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"2352", "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"3880", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"703", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"192", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "11792"}], "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "6"]}], "+", 
            RowBox[{"576", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"1968", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"273", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"24", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "60"}], "+", 
               RowBox[{"48", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"85", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"576", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "27"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"216", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2640", "+", 
               RowBox[{"864", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"940", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"57", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"96", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"h0", " ", 
          RowBox[{"(", 
           RowBox[{"10240", "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"1152", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"24624", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"2847", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"27", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"432", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"24", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "592"}], "+", 
               RowBox[{"972", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "+", 
               RowBox[{"288", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"3880", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"703", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"192", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"9", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"7200", " ", 
         SuperscriptBox["t1", "5"], " ", 
         SuperscriptBox["z0", "10"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2880", " ", 
          SuperscriptBox["h0", "9"]}], "+", 
         RowBox[{"192", " ", "a1", " ", 
          SuperscriptBox["h0", "8"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["h0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"1158", "+", 
            RowBox[{"240", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"300", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"769", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"12", " ", "a1", " ", 
          SuperscriptBox["h0", "4"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5940", "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"4800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"29596", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"3345", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"60", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1000", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"12", "+", 
               RowBox[{"17", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"80860", "+", 
            RowBox[{"4320", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"98520", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"50325", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"36", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1158"}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"600", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"48", " ", "a1", " ", 
          SuperscriptBox["h0", "6"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"8", "-", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"83712", "+", 
            RowBox[{"256", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"28800", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"79320", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"8952", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"165", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"240", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"4800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"36", "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"100", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2640", "+", 
               RowBox[{"940", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"57", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"5940", "+", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"29596", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3345", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"1000", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"618016", "+", 
            RowBox[{"11520", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"28800", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"918720", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"467922", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"17925", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"144", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1158"}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"28800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"300", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2352", "+", 
               RowBox[{"3880", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"703", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"40", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"16172", "+", 
               RowBox[{"1440", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"19704", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"10065", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"h0", " ", 
          RowBox[{"(", 
           RowBox[{"294400", "+", 
            RowBox[{"2880", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"787376", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"14400", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"176115", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"177", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1158"}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"600", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "592"}], "+", 
               RowBox[{"972", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"50", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "10240"}], "+", 
               RowBox[{"24624", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2847", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"20", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"16172", "+", 
               RowBox[{"1440", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"19704", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"10065", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"618016", "-", 
               RowBox[{"28800", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"918720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"467922", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"17925", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"28800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"9", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "+", 
                  RowBox[{"3880", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"703", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"192", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"240", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"20", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"5940", "+", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"29596", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3345", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"1000", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "127904"}], "+", 
               RowBox[{"34864", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"2880", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13509", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"201", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"5760", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "27"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"1440", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"28", "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"20", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "11792"}], "+", 
                  RowBox[{"1968", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"273", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"28800", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2640", "+", 
                  RowBox[{"940", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"57", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"3", " ", 
                RowBox[{"(", 
                 RowBox[{"27904", "+", 
                  RowBox[{"26440", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"2984", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"55", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"518400", " ", 
         SuperscriptBox["t1", "6"], " ", 
         SuperscriptBox["z0", "12"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"172800", " ", 
          SuperscriptBox["h0", "11"]}], "+", 
         RowBox[{"4608", " ", "a1", " ", 
          SuperscriptBox["h0", "10"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"1152", " ", 
          SuperscriptBox["h0", "9"], " ", 
          RowBox[{"(", 
           RowBox[{"3655", "+", 
            RowBox[{"750", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"900", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"741", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"1152", " ", "a1", " ", 
          SuperscriptBox["h0", "8"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "124"}], "-", 
            RowBox[{"20", " ", 
             SuperscriptBox["p0", "2"]}], "+", 
            RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"5375", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"288", " ", 
          SuperscriptBox["h0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"121042", "+", 
            RowBox[{"6000", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"9000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"57561", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"109660", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"60", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1158", "+", 
               RowBox[{"769", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"288", " ", "a1", " ", 
          SuperscriptBox["h0", "6"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1982"}], "+", 
            RowBox[{"160", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"3000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"182508", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"42045", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"300", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"351", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"24", " ", "a1", " ", 
          SuperscriptBox["h0", "4"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"482264", "-", 
            RowBox[{"1920", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"288000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"4989942", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"549546", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"42795", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"90000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"12", "+", 
               RowBox[{"17", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"180", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"5940", "+", 
               RowBox[{"29596", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3345", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"36", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1982"}], "+", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"182508", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"42045", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"351", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"72", " ", 
          SuperscriptBox["h0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"1609360", "+", 
            RowBox[{"24000", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"48000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"1453810", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"2057109", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"170735", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"6000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"104", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"100", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16172"}], "+", 
               RowBox[{"19704", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"10065", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"121042", "+", 
               RowBox[{"9000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"57561", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"109660", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"1158", "+", 
                  RowBox[{"769", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"48395008", "+", 
            RowBox[{"288000", " ", 
             SuperscriptBox["p0", "8"]}], "+", 
            RowBox[{"47872928", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"864000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"62340036", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"4514562", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"71055", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1536", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"18000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "+", 
               RowBox[{"3880", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"703", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"120", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"618016", "+", 
               RowBox[{"918720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"467922", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"17925", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"121042", "+", 
               RowBox[{"9000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"57561", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"109660", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"1158", "+", 
                  RowBox[{"769", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1609360"}], "+", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"1453810", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2057109", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"170735", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"6000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16172"}], "+", 
                  RowBox[{"19704", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"10065", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"12", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1920", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"384", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"72", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1982"}], "+", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"182508", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"42045", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"351", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "482264"}], "+", 
               RowBox[{"288000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"4989942", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"549546", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"42795", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"90000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"5940", "+", 
                  RowBox[{"29596", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3345", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "521600"}], "+", 
               RowBox[{"2056640", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"216000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"966577", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"52500", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "-", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"1500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2640", "+", 
                  RowBox[{"940", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"57", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"90", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"27904", "+", 
                  RowBox[{"26440", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"2984", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"55", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"3", " ", "a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "33384960"}], "+", 
            RowBox[{"1536", " ", 
             SuperscriptBox["p0", "10"]}], "+", 
            RowBox[{"8375008", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"345600", " ", 
             SuperscriptBox["t1", "5"], " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{"9631980", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"342219", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"1125", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "27"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"216000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"384", " ", 
             SuperscriptBox["p0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "124"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5375", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"6000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "11792"}], "+", 
               RowBox[{"1968", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"273", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"600", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "127904"}], "+", 
               RowBox[{"34864", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13509", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"201", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1982"}], "+", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"182508", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"42045", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"351", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "482264"}], "+", 
               RowBox[{"288000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"4989942", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"549546", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"42795", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"90000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"5940", "+", 
                  RowBox[{"29596", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3345", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "521600"}], "+", 
               RowBox[{"2056640", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"216000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"966577", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"52500", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "-", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"1500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2640", "+", 
                  RowBox[{"940", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"57", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"90", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"27904", "+", 
                  RowBox[{"26440", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"2984", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"55", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"h0", " ", 
          RowBox[{"(", 
           RowBox[{"51673600", "+", 
            RowBox[{"172800", " ", 
             SuperscriptBox["p0", "10"]}], "-", 
            RowBox[{"126831744", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"1036800", " ", 
             SuperscriptBox["t1", "5"], " ", 
             SuperscriptBox["z0", "5"]}], "-", 
            RowBox[{"55181280", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"1195533", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"82845", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"648000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1152", " ", 
             SuperscriptBox["p0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3655"}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"741", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"72000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "592"}], "+", 
               RowBox[{"972", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"9000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "10240"}], "+", 
               RowBox[{"24624", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2847", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "-", 
            RowBox[{"360", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"294400", "-", 
               RowBox[{"787376", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"176115", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"177", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"121042", "+", 
               RowBox[{"9000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"57561", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"109660", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"1158", "+", 
                  RowBox[{"769", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1609360"}], "+", 
               RowBox[{"48000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"1453810", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"2057109", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"170735", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"6000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "85"}], "+", 
                  RowBox[{"104", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16172"}], "+", 
                  RowBox[{"19704", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"10065", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"48395008", "+", 
               RowBox[{"47872928", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"864000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"62340036", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"4514562", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"71055", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "-", 
               RowBox[{"1152000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"9", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"18000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "+", 
                  RowBox[{"3880", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"703", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"618016", "+", 
                  RowBox[{"918720", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"467922", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"17925", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"horiza", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"a1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}]}], "+", 
      FractionBox[
       RowBox[{"a1", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "12"}], "+", 
          RowBox[{"12", " ", 
           SuperscriptBox["h0", "2"]}], "+", 
          RowBox[{"12", " ", 
           SuperscriptBox["p0", "2"]}], "+", 
          RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
          RowBox[{
           SuperscriptBox["a1", "2"], " ", 
           SuperscriptBox["z0", "4"]}]}], ")"}]}], 
       RowBox[{"4", " ", "t1", " ", 
        SuperscriptBox["z0", "2"]}]], "+", 
      FractionBox[
       RowBox[{"a1", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"112", " ", 
           SuperscriptBox["h0", "4"]}], "+", 
          RowBox[{"112", " ", 
           SuperscriptBox["p0", "4"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "12"}], "+", 
              RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
              RowBox[{
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}], "2"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["p0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "64"}], "+", 
             RowBox[{"36", " ", "t1", " ", "z0"}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["h0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "64"}], "+", 
             RowBox[{"28", " ", 
              SuperscriptBox["p0", "2"]}], "+", 
             RowBox[{"36", " ", "t1", " ", "z0"}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"48", " ", 
        SuperscriptBox["t1", "2"], " ", 
        SuperscriptBox["z0", "4"]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"192", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "6"]}]], "a1", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"192", " ", 
          SuperscriptBox["h0", "6"]}], "+", 
         RowBox[{"192", " ", 
          SuperscriptBox["p0", "6"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "3"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "96"}], "+", 
            RowBox[{"84", " ", "t1", " ", "z0"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "96"}], "+", 
            RowBox[{"36", " ", 
             SuperscriptBox["p0", "2"]}], "+", 
            RowBox[{"84", " ", "t1", " ", "z0"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1232", "+", 
            RowBox[{"432", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"188", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"24", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "64"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1232", "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"432", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"188", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "96"}], "+", 
               RowBox[{"84", " ", "t1", " ", "z0"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"24", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "64"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"3840", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}]], "a1", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "256"}], " ", 
          SuperscriptBox["h0", "8"]}], "-", 
         RowBox[{"256", " ", 
          SuperscriptBox["p0", "8"]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "166"}], "+", 
            RowBox[{"120", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"29", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "4"]}], "-", 
         RowBox[{"128", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"166", "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"120", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"29", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"1456", "+", 
            RowBox[{"1680", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"240", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"51", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "96"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1456"}], "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"1680", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"240", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"51", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "96"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"166", "-", 
               RowBox[{"120", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"29", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "20096"}], "+", 
            RowBox[{"5760", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"8464", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"762", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"27", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"480", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "64"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1232", "-", 
               RowBox[{"188", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"20096", "+", 
            RowBox[{"128", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"5760", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"8464", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"762", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"27", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "166"}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"29", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"480", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "64"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1232", "-", 
               RowBox[{"188", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1456", "+", 
               RowBox[{"1680", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"240", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"40", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "96"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"691200", " ", 
         SuperscriptBox["t1", "5"], " ", 
         SuperscriptBox["z0", "10"]}]], "a1", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"95232", " ", 
          SuperscriptBox["h0", "10"]}], "+", 
         RowBox[{"95232", " ", 
          SuperscriptBox["p0", "10"]}], "+", 
         RowBox[{"3840", " ", 
          SuperscriptBox["h0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{"536", "+", 
            RowBox[{"124", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"60", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"369", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"675", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "5"]}], "-", 
         RowBox[{"3840", " ", 
          SuperscriptBox["p0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "536"}], "+", 
            RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"369", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"1536", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"11825", "+", 
            RowBox[{"4500", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"3443", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"600", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"75", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"166", "+", 
               RowBox[{"29", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"1536", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"11825", "+", 
            RowBox[{"620", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"4500", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"3443", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"600", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"75", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"166", "+", 
               RowBox[{"29", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"10", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "536"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"369", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"37424", "+", 
            RowBox[{"252000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"120120", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"30459", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"1035", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"9000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "96"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"450", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1456", "-", 
               RowBox[{"240", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"20", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "23296"}], "-", 
            RowBox[{"1991040", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"518400", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"281256", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"24624", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"567", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "64"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1232", "-", 
               RowBox[{"188", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"360", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "20096"}], "+", 
               RowBox[{"8464", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"762", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"37424", "+", 
            RowBox[{"14880", " ", 
             SuperscriptBox["p0", "6"]}], "+", 
            RowBox[{"252000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"120120", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"30459", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"1035", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"9000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "96"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"360", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "536"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"369", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"450", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1456", "-", 
               RowBox[{"240", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"51", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"72", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"11825", "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"3443", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"600", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"75", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"166", "+", 
                  RowBox[{"29", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"119040", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"3840", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "536"}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"369", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"1152", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"11825", "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"3443", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"600", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"75", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"166", "+", 
                  RowBox[{"29", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"32", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"37424", "+", 
               RowBox[{"252000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"120120", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"30459", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1035", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"9000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "96"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"450", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"1456", "-", 
                  RowBox[{"240", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"51", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "23296"}], "-", 
               RowBox[{"1991040", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"518400", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"281256", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"24624", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"567", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"57600", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "64"}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"7200", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"1232", "-", 
                  RowBox[{"188", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"9", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"360", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "20096"}], "+", 
                  RowBox[{"8464", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"762", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"27", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"horizT", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"t1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["t1", "z0"]}], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a1", "2"], " ", 
           SuperscriptBox["z0", "2"]}], "2"]}], ")"}]}], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["h0", "4"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["p0", "4"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["p0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"15", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["h0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["p0", "2"]}], "+", 
             RowBox[{"15", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"48", "-", 
             RowBox[{"40", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["a1", "4"], " ", 
              SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"48", " ", "t1", " ", 
        SuperscriptBox["z0", "4"]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"48", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["h0", "6"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["p0", "6"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"18", "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"2", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"35", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "18"}], "+", 
            RowBox[{"2", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"35", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"12", "-", 
            RowBox[{"13", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "400"}], "-", 
            RowBox[{"728", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"39", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"8", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "400"}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"728", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"39", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"8", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "18"}], "+", 
               RowBox[{"2", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"3840", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "8"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1280", " ", 
          SuperscriptBox["h0", "8"]}], "+", 
         RowBox[{"1280", " ", 
          SuperscriptBox["p0", "8"]}], "-", 
         RowBox[{"128", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"20", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"67", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"40", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"20", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"67", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"604", "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"1182", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"29", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"10", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "18"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"604", "+", 
            RowBox[{"60", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"1182", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"29", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"10", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "18"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"402", "-", 
               RowBox[{"60", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"603", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"15", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "12"}], "+", 
                RowBox[{
                 SuperscriptBox["a1", "2"], " ", 
                 SuperscriptBox["z0", "4"]}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"32", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"12", "-", 
               RowBox[{"13", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"18560", "+", 
            RowBox[{"29744", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"3778", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"147", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"80", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"20", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "400"}], "-", 
               RowBox[{"728", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"18560", "+", 
            RowBox[{"640", " ", 
             SuperscriptBox["p0", "6"]}], "+", 
            RowBox[{"29744", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"3778", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"147", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"80", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"20", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "400"}], "-", 
               RowBox[{"728", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "20"}], " ", "t1", " ", "z0"}], "+", 
               RowBox[{"67", " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"32", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"604", "+", 
               RowBox[{"10", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"1182", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"29", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"10", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "18"}], "+", 
                  RowBox[{"35", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"69120", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "10"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"23040", " ", 
          SuperscriptBox["h0", "10"]}], "+", 
         RowBox[{"23040", " ", 
          SuperscriptBox["p0", "10"]}], "+", 
         RowBox[{"768", " ", 
          SuperscriptBox["h0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{"534", "+", 
            RowBox[{"150", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"90", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"437", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"768", " ", 
          SuperscriptBox["p0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "534"}], "+", 
            RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"437", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"135", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"24", "-", 
            RowBox[{"8", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"38", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
         RowBox[{"192", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"13760", "+", 
            RowBox[{"360", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"16732", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"573", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"2412", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"192", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"13760", "+", 
            RowBox[{"1200", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"360", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"16732", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"573", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"2412", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "534"}], "+", 
               RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"437", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"256", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"90", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"135", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "18"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"27", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"604", "-", 
               RowBox[{"1182", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"29", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"8", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3827"}], "+", 
               RowBox[{"5487", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"384", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5474560"}], "-", 
            RowBox[{"7142016", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"1601088", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"126936", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"3699", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "+", 
            RowBox[{"5760", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"2160", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "400"}], "-", 
               RowBox[{"728", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"216", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"18560", "+", 
               RowBox[{"29744", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"3778", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"147", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3600", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "534"}], "+", 
               RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"437", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"13760", "+", 
               RowBox[{"360", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"16732", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"573", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"2412", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"90", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"135", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "18"}], "+", 
                  RowBox[{"35", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"27", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"604", "-", 
                  RowBox[{"1182", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"29", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"8", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3827"}], "+", 
                  RowBox[{"5487", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"384", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"27", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5474560", "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["p0", "8"]}], "+", 
            RowBox[{"7142016", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"1601088", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"126936", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"3699", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"5760", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1536", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "534"}], "+", 
               RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"437", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"2160", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "400"}], "-", 
               RowBox[{"728", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"216", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"18560", "+", 
               RowBox[{"29744", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"3778", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"147", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"13760", "+", 
               RowBox[{"360", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"16732", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"573", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"2412", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"256", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"90", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"135", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "18"}], "+", 
                  RowBox[{"35", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"27", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"604", "-", 
                  RowBox[{"1182", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"29", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"8", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3827"}], "+", 
                  RowBox[{"5487", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"384", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"27", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"horizS", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"s0", "+", 
     FractionBox[
      RowBox[{"s0", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"12", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "2"]}], "-", 
         RowBox[{"4", " ", "t1", " ", "z0"}], "-", 
         RowBox[{
          SuperscriptBox["a1", "2"], " ", 
          SuperscriptBox["z0", "4"]}]}], ")"}]}], 
      RowBox[{"4", " ", "t1", " ", 
       SuperscriptBox["z0", "2"]}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h0", "2"], "+", 
         SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["a1", "2"], " ", 
          SuperscriptBox["z0", "4"]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["t1", "2"], " ", 
       SuperscriptBox["z0", "4"]}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h0", "2"], "+", 
         SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "20"}], "+", 
            RowBox[{"12", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
      RowBox[{"12", " ", 
       SuperscriptBox["t1", "3"], " ", 
       SuperscriptBox["z0", "6"]}]], "-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"288", " ", 
        SuperscriptBox["t1", "4"], " ", 
        SuperscriptBox["z0", "8"]}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h0", "2"], "+", 
        SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
      RowBox[{"(", 
       RowBox[{"800", "-", 
        RowBox[{"960", " ", "t1", " ", "z0"}], "+", 
        RowBox[{"288", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "2"]}], "+", 
        RowBox[{"816", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["z0", "4"]}], "-", 
        RowBox[{"1104", " ", 
         SuperscriptBox["a1", "2"], " ", "t1", " ", 
         SuperscriptBox["z0", "5"]}], "+", 
        RowBox[{"288", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}], "+", 
        RowBox[{"363", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "-", 
        RowBox[{"144", " ", 
         SuperscriptBox["a1", "4"], " ", "t1", " ", 
         SuperscriptBox["z0", "9"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["z0", "12"]}], "+", 
        RowBox[{"48", " ", 
         SuperscriptBox["h0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"19", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
        RowBox[{"48", " ", 
         SuperscriptBox["p0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"19", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
        RowBox[{"24", " ", 
         SuperscriptBox["p0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"22", "-", 
           RowBox[{"8", " ", "t1", " ", "z0"}], "-", 
           RowBox[{"107", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"56", " ", 
            SuperscriptBox["a1", "2"], " ", "t1", " ", 
            SuperscriptBox["z0", "5"]}], "-", 
           RowBox[{"23", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
        RowBox[{"24", " ", 
         SuperscriptBox["h0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"22", "-", 
           RowBox[{"8", " ", "t1", " ", "z0"}], "-", 
           RowBox[{"107", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"56", " ", 
            SuperscriptBox["a1", "2"], " ", "t1", " ", 
            SuperscriptBox["z0", "5"]}], "-", 
           RowBox[{"23", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"4", "+", 
              RowBox[{"76", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
     "-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"5760", " ", 
        SuperscriptBox["t1", "5"], " ", 
        SuperscriptBox["z0", "10"]}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h0", "2"], "+", 
        SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "27520"}], "+", 
        RowBox[{"48000", " ", "t1", " ", "z0"}], "-", 
        RowBox[{"28800", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "2"]}], "+", 
        RowBox[{"5760", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "3"]}], "-", 
        RowBox[{"17056", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["z0", "4"]}], "+", 
        RowBox[{"48960", " ", 
         SuperscriptBox["a1", "2"], " ", "t1", " ", 
         SuperscriptBox["z0", "5"]}], "-", 
        RowBox[{"33120", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}], "+", 
        RowBox[{"5760", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "7"]}], "-", 
        RowBox[{"25680", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "+", 
        RowBox[{"21780", " ", 
         SuperscriptBox["a1", "4"], " ", "t1", " ", 
         SuperscriptBox["z0", "9"]}], "-", 
        RowBox[{"4320", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "10"]}], "-", 
        RowBox[{"1677", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["z0", "12"]}], "+", 
        RowBox[{"540", " ", 
         SuperscriptBox["a1", "6"], " ", "t1", " ", 
         SuperscriptBox["z0", "13"]}], "-", 
        RowBox[{"9", " ", 
         SuperscriptBox["a1", "8"], " ", 
         SuperscriptBox["z0", "16"]}], "+", 
        RowBox[{"192", " ", 
         SuperscriptBox["h0", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"77", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
        RowBox[{"192", " ", 
         SuperscriptBox["p0", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"77", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
        RowBox[{"48", " ", 
         SuperscriptBox["p0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "204"}], "-", 
           RowBox[{"2005", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"845", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"60", " ", "t1", " ", 
            RowBox[{"(", 
             RowBox[{"z0", "+", 
              RowBox[{"19", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "5"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"48", " ", 
         SuperscriptBox["h0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "204"}], "-", 
           RowBox[{"2005", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"845", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "+", 
              RowBox[{"77", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
           RowBox[{"60", " ", "t1", " ", 
            RowBox[{"(", 
             RowBox[{"z0", "+", 
              RowBox[{"19", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "5"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["p0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3184"}], "+", 
           RowBox[{"11228", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"6359", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"339", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "+", 
           RowBox[{"480", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"120", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "22"}], "+", 
              RowBox[{"107", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"23", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["h0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3184"}], "+", 
           RowBox[{"11228", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"6359", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"339", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "+", 
           RowBox[{"480", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
           RowBox[{"48", " ", 
            SuperscriptBox["p0", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "+", 
              RowBox[{"77", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"120", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "22"}], "+", 
              RowBox[{"107", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"23", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "204"}], "-", 
              RowBox[{"2005", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "-", 
              RowBox[{"845", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"60", " ", "t1", " ", 
               RowBox[{"(", 
                RowBox[{"z0", "+", 
                 RowBox[{"19", " ", 
                  SuperscriptBox["a1", "2"], " ", 
                  SuperscriptBox["z0", "5"]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}], "-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"172800", " ", 
        SuperscriptBox["t1", "6"], " ", 
        SuperscriptBox["z0", "12"]}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h0", "2"], "+", 
        SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
      RowBox[{"(", 
       RowBox[{"1516800", "-", 
        RowBox[{"3302400", " ", "t1", " ", "z0"}], "+", 
        RowBox[{"2880000", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "2"]}], "-", 
        RowBox[{"1152000", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "3"]}], "+", 
        RowBox[{"153472", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["z0", "4"]}], "+", 
        RowBox[{"172800", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "4"]}], "-", 
        RowBox[{"2046720", " ", 
         SuperscriptBox["a1", "2"], " ", "t1", " ", 
         SuperscriptBox["z0", "5"]}], "+", 
        RowBox[{"2937600", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}], "-", 
        RowBox[{"1324800", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "7"]}], "+", 
        RowBox[{"2265960", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "+", 
        RowBox[{"172800", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "-", 
        RowBox[{"3081600", " ", 
         SuperscriptBox["a1", "4"], " ", "t1", " ", 
         SuperscriptBox["z0", "9"]}], "+", 
        RowBox[{"1306800", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "10"]}], "-", 
        RowBox[{"172800", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "11"]}], "+", 
        RowBox[{"313536", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["z0", "12"]}], "-", 
        RowBox[{"201240", " ", 
         SuperscriptBox["a1", "6"], " ", "t1", " ", 
         SuperscriptBox["z0", "13"]}], "+", 
        RowBox[{"32400", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "14"]}], "+", 
        RowBox[{"3915", " ", 
         SuperscriptBox["a1", "8"], " ", 
         SuperscriptBox["z0", "16"]}], "-", 
        RowBox[{"1080", " ", 
         SuperscriptBox["a1", "8"], " ", "t1", " ", 
         SuperscriptBox["z0", "17"]}], "+", 
        RowBox[{"768", " ", 
         SuperscriptBox["h0", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"15", "+", 
           RowBox[{"278", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
        RowBox[{"768", " ", 
         SuperscriptBox["p0", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"15", "+", 
           RowBox[{"278", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
        RowBox[{"384", " ", 
         SuperscriptBox["p0", "6"], " ", 
         RowBox[{"(", 
          RowBox[{"683", "-", 
           RowBox[{"7261", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"7240", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"60", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "+", 
              RowBox[{"77", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"384", " ", 
         SuperscriptBox["h0", "6"], " ", 
         RowBox[{"(", 
          RowBox[{"683", "-", 
           RowBox[{"7261", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"7240", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"60", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "+", 
              RowBox[{"77", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"15", "+", 
              RowBox[{"278", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["p0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"54040", "+", 
           RowBox[{"291390", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"328548", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"30285", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "+", 
           RowBox[{"5400", " ", 
            SuperscriptBox["t1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["z0", "2"], "+", 
              RowBox[{"19", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "6"]}]}], ")"}]}], "-", 
           RowBox[{"180", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{"204", "+", 
              RowBox[{"2005", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"845", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["p0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"437376", "-", 
           RowBox[{"1112096", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"1250343", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "-", 
           RowBox[{"162069", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "-", 
           RowBox[{"3150", " ", 
            SuperscriptBox["a1", "8"], " ", 
            SuperscriptBox["z0", "16"]}], "+", 
           RowBox[{"28800", " ", 
            SuperscriptBox["t1", "3"], " ", 
            SuperscriptBox["z0", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"10800", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "22"}], "+", 
              RowBox[{"107", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"23", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
           RowBox[{"180", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3184"}], "+", 
              RowBox[{"11228", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"6359", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"339", " ", 
               SuperscriptBox["a1", "6"], " ", 
               SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["h0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"54040", "+", 
           RowBox[{"291390", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"328548", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"30285", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "+", 
           RowBox[{"144", " ", 
            SuperscriptBox["p0", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"15", "+", 
              RowBox[{"278", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
           RowBox[{"5400", " ", 
            SuperscriptBox["t1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["z0", "2"], "+", 
              RowBox[{"19", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "6"]}]}], ")"}]}], "-", 
           RowBox[{"180", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{"204", "+", 
              RowBox[{"2005", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"845", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
           RowBox[{"36", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"683", "-", 
              RowBox[{"7261", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "-", 
              RowBox[{"7240", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"60", " ", "t1", " ", "z0", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "3"}], "+", 
                 RowBox[{"77", " ", 
                  SuperscriptBox["a1", "2"], " ", 
                  SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["h0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"437376", "-", 
           RowBox[{"1112096", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"1250343", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "-", 
           RowBox[{"162069", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "-", 
           RowBox[{"3150", " ", 
            SuperscriptBox["a1", "8"], " ", 
            SuperscriptBox["z0", "16"]}], "+", 
           RowBox[{"28800", " ", 
            SuperscriptBox["t1", "3"], " ", 
            SuperscriptBox["z0", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
           RowBox[{"384", " ", 
            SuperscriptBox["p0", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"15", "+", 
              RowBox[{"278", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"10800", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "22"}], "+", 
              RowBox[{"107", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"23", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
           RowBox[{"180", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3184"}], "+", 
              RowBox[{"11228", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"6359", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"339", " ", 
               SuperscriptBox["a1", "6"], " ", 
               SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
           RowBox[{"144", " ", 
            SuperscriptBox["p0", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"683", "-", 
              RowBox[{"7261", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "-", 
              RowBox[{"7240", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"60", " ", "t1", " ", "z0", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "3"}], "+", 
                 RowBox[{"77", " ", 
                  SuperscriptBox["a1", "2"], " ", 
                  SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"54040", "+", 
              RowBox[{"291390", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"328548", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"30285", " ", 
               SuperscriptBox["a1", "6"], " ", 
               SuperscriptBox["z0", "12"]}], "+", 
              RowBox[{"5400", " ", 
               SuperscriptBox["t1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["z0", "2"], "+", 
                 RowBox[{"19", " ", 
                  SuperscriptBox["a1", "2"], " ", 
                  SuperscriptBox["z0", "6"]}]}], ")"}]}], "-", 
              RowBox[{"180", " ", "t1", " ", "z0", " ", 
               RowBox[{"(", 
                RowBox[{"204", "+", 
                 RowBox[{"2005", " ", 
                  SuperscriptBox["a1", "2"], " ", 
                  SuperscriptBox["z0", "4"]}], "+", 
                 RowBox[{"845", " ", 
                  SuperscriptBox["a1", "4"], " ", 
                  SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5384640040309467`*^9, 3.5384640865225697`*^9}, {
  3.538464329491736*^9, 3.538464352894101*^9}, {3.543863781948699*^9, 
  3.543863800923451*^9}, {3.543863915894534*^9, 3.543863966433701*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"asymp", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"p2", " ", 
       SuperscriptBox["z", "2"]}], "+", 
      RowBox[{"2", " ", "a0", " ", "h2", " ", 
       SuperscriptBox["z", "3"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a1", " ", "h2"}], "-", 
         FractionBox[
          RowBox[{"8", " ", 
           SuperscriptBox["a0", "2"], " ", "p2"}], "3"]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["a0", "3"], " ", "h2"}], "-", 
         RowBox[{"8", " ", "a0", " ", "a1", " ", "p2"}], "-", 
         RowBox[{"p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "5"]}], "+", 
      RowBox[{
       FractionBox["1", "120"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "480"}], " ", 
          SuperscriptBox["a0", "2"], " ", "a1", " ", "h2"}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["a0", "4"], " ", "p2"}], "-", 
         RowBox[{"93", " ", 
          SuperscriptBox["a1", "2"], " ", "p2"}], "+", 
         RowBox[{"28", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}], "-", 
         RowBox[{"140", " ", "a0", " ", "h2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "+", 
      RowBox[{
       FractionBox["1", "180"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"256", " ", 
          SuperscriptBox["a0", "5"], " ", "h2"}], "+", 
         RowBox[{"768", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{"3", " ", "a0", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "139"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"52", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"132", " ", "a1", " ", "h2", " ", "T3"}], "+", 
         RowBox[{"396", " ", 
          SuperscriptBox["a0", "2"], " ", "p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8960", " ", 
           SuperscriptBox["a0", "4"], " ", "a1", " ", "h2"}], "-", 
          RowBox[{"1323", " ", 
           SuperscriptBox["a1", "3"], " ", "h2"}], "-", 
          RowBox[{"2048", " ", 
           SuperscriptBox["a0", "6"], " ", "p2"}], "+", 
          RowBox[{"1260", " ", "a1", " ", "h2", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["h2", "2"], "+", 
             SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["a0", "2"], " ", "p2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"1177", " ", 
              SuperscriptBox["a1", "2"]}], "-", 
             RowBox[{"586", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"7168", " ", 
           SuperscriptBox["a0", "3"], " ", "h2", " ", "T3"}], "+", 
          RowBox[{"6596", " ", "a0", " ", "a1", " ", "p2", " ", "T3"}], "+", 
          RowBox[{"500", " ", "p2", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "8"]}], "2520"], "+", 
      RowBox[{
       FractionBox["1", "1260"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"128", " ", 
             SuperscriptBox["a0", "6"], " ", "h2"}], "+", 
            RowBox[{"768", " ", 
             SuperscriptBox["a0", "4"], " ", "a1", " ", "p2"}], "-", 
            RowBox[{"534", " ", 
             SuperscriptBox["a1", "3"], " ", "p2"}], "+", 
            RowBox[{"650", " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"25", " ", 
             SuperscriptBox["a0", "2"], " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "53"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"36", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
         "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6176", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "h2"}], "-", 
            RowBox[{"3520", " ", 
             SuperscriptBox["a0", "4"], " ", "p2"}], "+", 
            RowBox[{"p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"1113", " ", 
                SuperscriptBox["a1", "2"]}], "-", 
               RowBox[{"334", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "+", 
         RowBox[{"1070", " ", "a0", " ", "h2", " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "9"]}], "+", 
      RowBox[{
       FractionBox["1", "362880"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "516096"}], " ", 
          SuperscriptBox["a0", "6"], " ", "a1", " ", "h2"}], "+", 
         RowBox[{"65536", " ", 
          SuperscriptBox["a0", "8"], " ", "p2"}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["a0", "4"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5191"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"4985", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"27", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4459", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"8800", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"1296", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
         RowBox[{"801792", " ", 
          SuperscriptBox["a0", "5"], " ", "h2", " ", "T3"}], "-", 
         RowBox[{"2274304", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "p2", " ", "T3"}], "-", 
         RowBox[{"72", " ", "a0", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "16279"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"6152", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "+", 
         RowBox[{"211104", " ", "a1", " ", "h2", " ", 
          SuperscriptBox["T3", "2"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"65628", " ", 
             SuperscriptBox["a1", "3"], " ", "h2"}], "-", 
            RowBox[{"106344", " ", "a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "-", 
            RowBox[{"42517", " ", "p2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "10"]}], "+", 
      RowBox[{
       FractionBox["1", "907200"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"65536", " ", 
             SuperscriptBox["a0", "8"], " ", "h2"}], "+", 
            RowBox[{"655360", " ", 
             SuperscriptBox["a0", "6"], " ", "a1", " ", "p2"}], "+", 
            RowBox[{"256", " ", 
             SuperscriptBox["a0", "4"], " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "9239"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"12877", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"128", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "24170"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"53921", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"342771", " ", 
                SuperscriptBox["a1", "4"]}], "-", 
               RowBox[{"878720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
               RowBox[{"131344", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["h2", "2"], "+", 
                   SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "690688"}], " ", 
             SuperscriptBox["a0", "4"], " ", "a1", " ", "h2"}], "+", 
            RowBox[{"165760", " ", 
             SuperscriptBox["a0", "6"], " ", "p2"}], "+", 
            RowBox[{"6", " ", "a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"15519", " ", 
                SuperscriptBox["a1", "2"]}], "-", 
               RowBox[{"14764", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a0", "2"], " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "696615"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"349432", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "-", 
         RowBox[{"80", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"31441", " ", 
             SuperscriptBox["a0", "2"], " ", "h2"}], "+", 
            RowBox[{"27384", " ", "a1", " ", "p2"}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}], "-", 
         RowBox[{"128000", " ", "p2", " ", 
          SuperscriptBox["T3", "3"]}]}], ")"}], " ", 
       SuperscriptBox["z", "11"]}], "+", 
      RowBox[{
       FractionBox["1", "19958400"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6488064", " ", 
          SuperscriptBox["a0", "8"], " ", "a1", " ", "h2"}], "-", 
         RowBox[{"524288", " ", 
          SuperscriptBox["a0", "10"], " ", "p2"}], "-", 
         RowBox[{"2048", " ", 
          SuperscriptBox["a0", "6"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "15323"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"31837", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"99", " ", "a1", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"40425", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"137664", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"53104", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "+", 
         RowBox[{"16580608", " ", 
          SuperscriptBox["a0", "7"], " ", "h2", " ", "T3"}], "+", 
         RowBox[{"95269888", " ", 
          SuperscriptBox["a0", "5"], " ", "a1", " ", "p2", " ", "T3"}], "+", 
         RowBox[{"1408", " ", 
          SuperscriptBox["a0", "3"], " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "112858"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"77229", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "+", 
         RowBox[{"1232", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "14319"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"4438", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}], "-", 
         RowBox[{"8", " ", "a0", " ", "T3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7711461", " ", 
             SuperscriptBox["a1", "3"], " ", "p2"}], "-", 
            RowBox[{"9329680", " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"1688060", " ", "h2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5047569", " ", 
             SuperscriptBox["a1", "4"], " ", "p2"}], "-", 
            RowBox[{"17420908", " ", 
             SuperscriptBox["a1", "2"], " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"3059776", " ", "p2", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}], "+", 
            RowBox[{"12810974", " ", "a1", " ", "h2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["a0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "481338"}], " ", 
             SuperscriptBox["a1", "3"], " ", "h2"}], "+", 
            RowBox[{"1519606", " ", "a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"477965", " ", "p2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}]}], "//.", "replasym"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"asymh", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"h2", " ", 
       SuperscriptBox["z", "2"]}], "-", 
      RowBox[{"2", " ", "a0", " ", "p2", " ", 
       SuperscriptBox["z", "3"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"8", " ", 
            SuperscriptBox["a0", "2"], " ", "h2"}], "3"]}], "-", 
         RowBox[{"a1", " ", "p2"}]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", "a0", " ", "a1", " ", "h2"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "3"], " ", "p2"}], "-", 
         RowBox[{"h2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "5"]}], "+", 
      RowBox[{
       FractionBox["1", "120"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"256", " ", 
          SuperscriptBox["a0", "4"], " ", "h2"}], "-", 
         RowBox[{"93", " ", 
          SuperscriptBox["a1", "2"], " ", "h2"}], "+", 
         RowBox[{"480", " ", 
          SuperscriptBox["a0", "2"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{"28", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
         RowBox[{"140", " ", "a0", " ", "p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "+", 
      RowBox[{
       FractionBox["1", "180"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"768", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "h2"}], "-", 
         RowBox[{"256", " ", 
          SuperscriptBox["a0", "5"], " ", "p2"}], "+", 
         RowBox[{"3", " ", "a0", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"139", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"52", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"396", " ", 
          SuperscriptBox["a0", "2"], " ", "h2", " ", "T3"}], "+", 
         RowBox[{"132", " ", "a1", " ", "p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2048"}], " ", 
           SuperscriptBox["a0", "6"], " ", "h2"}], "-", 
          RowBox[{"8960", " ", 
           SuperscriptBox["a0", "4"], " ", "a1", " ", "p2"}], "+", 
          RowBox[{"63", " ", "a1", " ", "p2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"21", " ", 
              SuperscriptBox["a1", "2"]}], "-", 
             RowBox[{"20", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["a0", "2"], " ", "h2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1177"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"586", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"6596", " ", "a0", " ", "a1", " ", "h2", " ", "T3"}], "-", 
          RowBox[{"7168", " ", 
           SuperscriptBox["a0", "3"], " ", "p2", " ", "T3"}], "+", 
          RowBox[{"500", " ", "h2", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "8"]}], "2520"], "+", 
      RowBox[{
       FractionBox["1", "1260"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3072"}], " ", 
          SuperscriptBox["a0", "5"], " ", "a1", " ", "h2"}], "+", 
         RowBox[{"512", " ", 
          SuperscriptBox["a0", "7"], " ", "p2"}], "+", 
         RowBox[{"8", " ", "a0", " ", "a1", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"267", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"325", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"100", " ", 
          SuperscriptBox["a0", "3"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "53"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"36", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"3520", " ", 
          SuperscriptBox["a0", "4"], " ", "h2", " ", "T3"}], "-", 
         RowBox[{"6176", " ", 
          SuperscriptBox["a0", "2"], " ", "a1", " ", "p2", " ", "T3"}], "+", 
         RowBox[{"h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1113", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"334", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "-", 
         RowBox[{"1070", " ", "a0", " ", "p2", " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "9"]}], "+", 
      RowBox[{
       FractionBox["1", "362880"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"65536", " ", 
          SuperscriptBox["a0", "8"], " ", "h2"}], "+", 
         RowBox[{"516096", " ", 
          SuperscriptBox["a0", "6"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["a0", "4"], " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5191"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"4985", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"27", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4459", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"8800", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"1296", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
         RowBox[{"2274304", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "h2", " ", "T3"}], "+", 
         RowBox[{"801792", " ", 
          SuperscriptBox["a0", "5"], " ", "p2", " ", "T3"}], "+", 
         RowBox[{"72", " ", "a0", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "16279"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"6152", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "-", 
         RowBox[{"211104", " ", "a1", " ", "p2", " ", 
          SuperscriptBox["T3", "2"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["a0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"65628", " ", 
             SuperscriptBox["a1", "3"], " ", "p2"}], "-", 
            RowBox[{"106344", " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"42517", " ", "h2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "10"]}], "+", 
      RowBox[{
       FractionBox["1", "907200"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"655360", " ", 
             SuperscriptBox["a0", "6"], " ", "a1", " ", "h2"}], "-", 
            RowBox[{"65536", " ", 
             SuperscriptBox["a0", "8"], " ", "p2"}], "-", 
            RowBox[{"256", " ", 
             SuperscriptBox["a0", "4"], " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "9239"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"12877", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"128", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "24170"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"53921", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "342771"}], " ", 
                SuperscriptBox["a1", "4"]}], "+", 
               RowBox[{"878720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}], "-", 
               RowBox[{"131344", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["h2", "2"], "+", 
                   SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"165760", " ", 
             SuperscriptBox["a0", "6"], " ", "h2"}], "+", 
            RowBox[{"690688", " ", 
             SuperscriptBox["a0", "4"], " ", "a1", " ", "p2"}], "-", 
            RowBox[{"93114", " ", 
             SuperscriptBox["a1", "3"], " ", "p2"}], "+", 
            RowBox[{"88584", " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a0", "2"], " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "696615"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"349432", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "+", 
         RowBox[{"80", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "27384"}], " ", "a1", " ", "h2"}], "+", 
            RowBox[{"31441", " ", 
             SuperscriptBox["a0", "2"], " ", "p2"}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}], "-", 
         RowBox[{"128000", " ", "h2", " ", 
          SuperscriptBox["T3", "3"]}]}], ")"}], " ", 
       SuperscriptBox["z", "11"]}], "+", 
      RowBox[{
       FractionBox["1", "19958400"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "524288"}], " ", 
          SuperscriptBox["a0", "10"], " ", "h2"}], "-", 
         RowBox[{"6488064", " ", 
          SuperscriptBox["a0", "8"], " ", "a1", " ", "p2"}], "-", 
         RowBox[{"2048", " ", 
          SuperscriptBox["a0", "6"], " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "15323"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"31837", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"99", " ", "a1", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"40425", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"137664", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"53104", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "+", 
         RowBox[{"95269888", " ", 
          SuperscriptBox["a0", "5"], " ", "a1", " ", "h2", " ", "T3"}], "-", 
         RowBox[{"16580608", " ", 
          SuperscriptBox["a0", "7"], " ", "p2", " ", "T3"}], "-", 
         RowBox[{"1408", " ", 
          SuperscriptBox["a0", "3"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "112858"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"77229", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "+", 
         RowBox[{"1232", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "14319"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"4438", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["a0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"481338", " ", 
             SuperscriptBox["a1", "3"], " ", "p2"}], "-", 
            RowBox[{"1519606", " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"477965", " ", "h2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", "a0", " ", "T3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "7711461"}], " ", 
             SuperscriptBox["a1", "3"], " ", "h2"}], "+", 
            RowBox[{"9329680", " ", "a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"1688060", " ", "p2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5047569", " ", 
             SuperscriptBox["a1", "4"], " ", "h2"}], "-", 
            RowBox[{"17420908", " ", 
             SuperscriptBox["a1", "2"], " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"3059776", " ", "h2", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}], "-", 
            RowBox[{"12810974", " ", "a1", " ", "p2", " ", 
             SuperscriptBox["T3", "2"]}]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}]}], "//.", "replasym"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"asyma", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "+", 
      RowBox[{"a1", " ", "z"}], "+", 
      RowBox[{
       FractionBox["2", "3"], " ", "a0", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["7", "15"], " ", "a1", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "5"]}], "-", 
      RowBox[{
       FractionBox["16", "45"], " ", 
       SuperscriptBox["a0", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "-", 
      RowBox[{
       FractionBox["2", "63"], " ", "a0", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"17", " ", "a0", " ", "a1"}], "+", 
         RowBox[{"10", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "a0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"32", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"101", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"86", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"325", " ", "a1", " ", "T3"}]}], ")"}], " ", 
        SuperscriptBox["z", "8"]}], "1260"], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5600", " ", 
           SuperscriptBox["a0", "4"], " ", "a1"}], "+", 
          RowBox[{"9", " ", "a1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "237"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"496", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"7168", " ", 
           SuperscriptBox["a0", "3"], " ", "T3"}]}], ")"}], " ", 
        SuperscriptBox["z", "9"]}], "22680"], "-", 
      FractionBox[
       RowBox[{"a0", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"256", " ", 
           SuperscriptBox["a0", "6"]}], "+", 
          RowBox[{
           SuperscriptBox["a0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4222"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"5864", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"7723", " ", "a0", " ", "a1", " ", "T3"}], "-", 
          RowBox[{"2740", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "10"]}], "14175"], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a0", "2"], " ", "a1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"19008", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"69085", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"208696", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"32", " ", "a0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"1314", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"3728", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"3063", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
          "-", 
          RowBox[{"52195", " ", "a1", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "11"]}], "311850"], "+", 
      RowBox[{
       FractionBox["1", "7484400"], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16384", " ", 
          SuperscriptBox["a0", "9"]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["a0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "6647"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"18283", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"18", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"40299", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"175246", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"51752", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
         RowBox[{"2703136", " ", 
          SuperscriptBox["a0", "4"], " ", "a1", " ", "T3"}], "+", 
         RowBox[{"63", " ", "a1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15201", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"29176", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "-", 
         RowBox[{"1978000", " ", 
          SuperscriptBox["a0", "3"], " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}]}], "//.", "replasym"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"asymT", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"T3", " ", 
       SuperscriptBox["z", "3"]}], "+", 
      RowBox[{
       FractionBox["1", "12"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["a1", "2"]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["2", "3"], " ", 
       SuperscriptBox["a0", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "+", 
      RowBox[{
       FractionBox["1", "9"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", "a0", " ", "a1"}], "+", "T3"}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"448", " ", 
           SuperscriptBox["a0", "4"]}], "-", 
          RowBox[{"447", " ", 
           SuperscriptBox["a1", "2"]}], "+", 
          RowBox[{"76", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["h2", "2"], "+", 
             SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["z", "8"]}], "1260"], "-", 
      RowBox[{
       FractionBox["4", "45"], " ", 
       SuperscriptBox["a0", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", "a0", " ", "a1"}], "+", 
         RowBox[{"4", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "9"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"576", " ", 
           SuperscriptBox["a0", "6"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["a0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1067"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"662", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"2900", " ", "a0", " ", "a1", " ", "T3"}], "-", 
          RowBox[{"215", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "10"]}], "5670"], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", "a0", " ", "a1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"768", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"849", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"1504", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"12384", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"8367", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"2192", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}]}], 
         ")"}], " ", 
        SuperscriptBox["z", "11"]}], "37800"], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"22528", " ", 
           SuperscriptBox["a0", "8"]}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["a0", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "12981"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"15646", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"9", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"11148", " ", 
              SuperscriptBox["a1", "4"]}], "-", 
             RowBox[{"33831", " ", 
              SuperscriptBox["a1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
             RowBox[{"2908", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["h2", "2"], "+", 
                 SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
          RowBox[{"1016240", " ", 
           SuperscriptBox["a0", "3"], " ", "a1", " ", "T3"}], "-", 
          RowBox[{"270940", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "12"]}], "1247400"]}], "//.", "replasym"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymS", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["h2", "2"]}], "-", 
        SuperscriptBox["p2", "2"]}], ")"}], " ", 
      SuperscriptBox["z", "4"]}], "+", 
     RowBox[{
      FractionBox["1", "9"], " ", 
      SuperscriptBox["a0", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h2", "2"], "+", 
        SuperscriptBox["p2", "2"]}], ")"}], " ", 
      SuperscriptBox["z", "6"]}], "+", 
     RowBox[{
      FractionBox["1", "63"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h2", "2"], "+", 
        SuperscriptBox["p2", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "a0", " ", "a1"}], "+", 
        RowBox[{"5", " ", "T3"}]}], ")"}], " ", 
      SuperscriptBox["z", "7"]}], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"224", " ", 
          SuperscriptBox["a0", "4"]}], "+", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "39"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"74", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "8"]}], "5040"], "-", 
     RowBox[{
      FractionBox["1", "405"], " ", 
      SuperscriptBox["a0", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h2", "2"], "+", 
        SuperscriptBox["p2", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"26", " ", "a0", " ", "a1"}], "+", 
        RowBox[{"37", " ", "T3"}]}], ")"}], " ", 
      SuperscriptBox["z", "9"]}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"576", " ", 
          SuperscriptBox["a0", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["a0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3133"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"4738", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"3340", " ", "a0", " ", "a1", " ", "T3"}], "-", 
         RowBox[{"2875", " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "10"]}], "56700"], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "a0", " ", "a1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"832", " ", 
             SuperscriptBox["a0", "4"]}], "-", 
            RowBox[{"771", " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"2196", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2528", " ", 
             SuperscriptBox["a0", "4"]}], "-", 
            RowBox[{"1309", " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"2684", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}]}], 
        ")"}], " ", 
       SuperscriptBox["z", "11"]}], "138600"], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"22528", " ", 
          SuperscriptBox["a0", "8"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "33238"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"77633", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"27", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2716", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"14037", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"9886", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
         RowBox[{"1322560", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "T3"}], "-", 
         RowBox[{"1103800", " ", 
          SuperscriptBox["a0", "2"], " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}], "14968800"]}], "//.", "replasym"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.537640798221807*^9, 3.5376408063887777`*^9}, {
  3.538462913984427*^9, 3.53846295871097*^9}, {3.538463135071212*^9, 
  3.538463146908863*^9}, {3.538464374794805*^9, 3.538464392634185*^9}, {
  3.5438638049546547`*^9, 3.543863817644617*^9}, {3.5438638714988747`*^9, 
  3.54386390248771*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqlist", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["p", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"p", "[", "z", "]"}], "2"], " ", 
          RowBox[{"S", "[", "z", "]"}], " ", 
          SuperscriptBox[
           RowBox[{"T", "[", "z", "]"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"S", "[", "z", "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["S", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]]}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"a", "[", "z", "]"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"h", "[", "z", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], " ", 
          RowBox[{"S", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"], " ", 
             RowBox[{"S", "[", "z", "]"}], " ", 
             RowBox[{
              SuperscriptBox["p", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], "+", 
            RowBox[{"z", " ", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "2"], " ", 
             RowBox[{"S", "[", "z", "]"}], " ", 
             RowBox[{
              SuperscriptBox["p", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], "-", 
            RowBox[{"4", " ", 
             RowBox[{"p", "[", "z", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"S", "[", "z", "]"}], "-", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["S", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"8", " ", "z", " ", 
          RowBox[{"a", "[", "z", "]"}], " ", 
          RowBox[{"h", "[", "z", "]"}], " ", 
          RowBox[{"T", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{"S", "[", "z", "]"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["p", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"p", "[", "z", "]"}], " ", 
             RowBox[{"S", "[", "z", "]"}], " ", 
             RowBox[{
              SuperscriptBox["p", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"S", "[", "z", "]"}]}], "+", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["S", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox[
                 RowBox[{"S", "[", "z", "]"}], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["p", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                 ")"}]}], "-", 
               RowBox[{"4", " ", "z", " ", 
                RowBox[{"S", "[", "z", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["S", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["z", "2"], " ", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["S", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
              ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"T", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "z", " ", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "4"], " ", 
             SuperscriptBox[
              RowBox[{"S", "[", "z", "]"}], "2"], " ", 
             RowBox[{
              SuperscriptBox["p", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "3"], " ", 
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{"S", "[", "z", "]"}], "2"], " ", 
             RowBox[{"T", "[", "z", "]"}], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["p", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "3"]}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "3"], " ", 
             RowBox[{"S", "[", "z", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"S", "[", "z", "]"}], "-", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["S", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"h", "[", "z", "]"}], "2"], " ", 
                SuperscriptBox[
                 RowBox[{"S", "[", "z", "]"}], "2"], " ", 
                RowBox[{
                 SuperscriptBox["p", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}], "+", 
               RowBox[{"8", " ", "z", " ", 
                RowBox[{"h", "[", "z", "]"}], " ", 
                RowBox[{"S", "[", "z", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["a", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"S", "[", "z", "]"}], "-", 
                  RowBox[{"z", " ", 
                   RowBox[{
                    SuperscriptBox["S", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["p", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"S", "[", "z", "]"}], "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{"12", "-", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"T", "[", "z", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["p", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"T", "[", "z", "]"}], " ", 
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["S", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{
        RowBox[{"8", " ", 
         RowBox[{"a", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"h", "[", "z", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], " ", 
         RowBox[{"S", "[", "z", "]"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"T", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"S", "[", "z", "]"}], " ", 
        RowBox[{"T", "[", "z", "]"}]}]]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "\[Equal]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"h", "[", "z", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], " ", 
         RowBox[{"S", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"a", "[", "z", "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"h", "[", "z", "]"}], "2"], "+", 
              SuperscriptBox[
               RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"a", "[", "z", "]"}], " ", 
            RowBox[{"h", "[", "z", "]"}], " ", 
            RowBox[{"T", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"T", "[", "z", "]"}], "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}], "2"]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", "z", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"T", "[", "z", "]"}], "2"]}]]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "\[Equal]", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"4", " ", "z", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", "z", "]"}], "2"], " ", 
         RowBox[{"S", "[", "z", "]"}], " ", 
         RowBox[{"T", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"S", "[", "z", "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"a", "[", "z", "]"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"S", "[", "z", "]"}], "2"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"a", "[", "z", "]"}], " ", 
          RowBox[{"h", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"h", "[", "z", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"S", "[", "z", "]"}], "2"], " ", 
          RowBox[{"T", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["p", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "+", 
         RowBox[{
          RowBox[{"T", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "4"], " ", 
             SuperscriptBox[
              RowBox[{"S", "[", "z", "]"}], "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{"h", "[", "z", "]"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{"S", "[", "z", "]"}], "2"], " ", 
             RowBox[{"T", "[", "z", "]"}], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["p", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"p", "[", "z", "]"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox[
                 RowBox[{"S", "[", "z", "]"}], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"12", "+", 
                  RowBox[{"4", " ", 
                   SuperscriptBox[
                    RowBox[{"h", "[", "z", "]"}], "2"]}], "-", 
                  RowBox[{
                   SuperscriptBox["z", "4"], " ", 
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                  RowBox[{"2", " ", 
                   RowBox[{"T", "[", "z", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "6"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["p", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                    ")"}]}]}], ")"}]}], "+", 
               RowBox[{"16", " ", "z", " ", 
                RowBox[{"S", "[", "z", "]"}], " ", 
                RowBox[{"T", "[", "z", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["S", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"T", "[", "z", "]"}], " ", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["S", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
              ")"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"a", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"h", "[", "z", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"p", "[", "z", "]"}], "2"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{"T", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], 
       RowBox[{
        RowBox[{"p", "[", "z", "]"}], " ", 
        RowBox[{"T", "[", "z", "]"}]}]]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.53804704493528*^9, 3.538047048094969*^9}, 
   3.538047118025202*^9, 3.538118653167184*^9, {3.5384641317446833`*^9, 
   3.538464140783781*^9}, {3.543863826974758*^9, 3.5438638283529997`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerics - High precision", "Subsubtitle",
 CellChangeTimes->{{3.538463013798025*^9, 3.5384630213987093`*^9}, {
  3.538467402992407*^9, 3.5384674058714247`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"precision", "=", "25"}], ";"}]], "Input",
 CellChangeTimes->{{3.538467418163487*^9, 3.5384674209374638`*^9}, {
  3.538467503829393*^9, 3.538467504196958*^9}, {3.5384675867083883`*^9, 
  3.5384675867768393`*^9}, {3.538475778689355*^9, 3.538475779473031*^9}, {
  3.5384759893975153`*^9, 3.538475989501337*^9}, {3.538483715861815*^9, 
  3.5384837159415283`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"inteq", ",", "zhoriz", ",", "eps"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"inteq", "[", 
    RowBox[{
    "z0in_Real", ",", "horizp0in_Real", ",", "horiza1in_Real", ",", 
     "horizt1in_Real", ",", "horizs0in_Real", ",", "asymp2in_Real", ",", 
     "asymh2in_Real", ",", "asyma0in_Real", ",", "asyma1in_Real", ",", 
     "asymT3in_Real", ",", "output_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"z0", "=", "z0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizp0", "=", "horizp0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizh0", "=", "0"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horiza1", "=", "horiza1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizt1", "=", "horizt1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"horizs0", "=", "horizs0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymp2", "=", "asymp2in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymh2", "=", "asymh2in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asyma0", "=", "asyma0in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asyma1", "=", "asyma1in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"asymT3", "=", "asymT3in"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"eps", "=", 
      RowBox[{"SetPrecision", "[", 
       RowBox[{"0.0001", ",", "30"}], "]"}]}], " ", ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"eps2", "=", 
      RowBox[{"SetPrecision", "[", 
       RowBox[{"0.0001", ",", "30"}], "]"}]}], " ", ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"zmid", " ", "=", " ", 
      RowBox[{"SetPrecision", "[", 
       RowBox[{"0.4", ",", "30"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zhoriz", "=", 
      RowBox[{"1", "-", "eps2"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"nsol1", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"eqlist", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"p", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymp", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asymp", "'"}], "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"h", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymh", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"a", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asyma", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asyma", "'"}], "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"T", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymT", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{"S", "[", "eps", "]"}], "\[Equal]", 
              RowBox[{"asymS", "[", "eps", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "eps", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"asymS", "'"}], "[", "eps", "]"}]}]}], "}"}]}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "eps", ",", "zhoriz"}], "}"}], ",", 
         RowBox[{"WorkingPrecision", "\[Rule]", "precision"}], ",", 
         RowBox[{"MaxSteps", "\[Rule]", "100000"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zcut1", "=", 
      RowBox[{"nsol1", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "2"}], "]"}], "]"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"zcut1", "<", "zmid"}], ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Error  \>\"", ",", "zcut2"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"nsol2", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"eqlist", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"p", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizp", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horizp", "'"}], "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"h", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizh", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"a", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horiza", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horiza", "'"}], "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"T", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizT", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{"S", "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{"horizS", "[", "zhoriz", "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zhoriz", "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"horizS", "'"}], "[", "zhoriz", "]"}]}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", "h", ",", "a", ",", "T", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "eps", ",", "zhoriz"}], "}"}], ",", 
         RowBox[{"WorkingPrecision", "\[Rule]", "precision"}], ",", 
         RowBox[{"MaxSteps", "\[Rule]", "100000"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"zcut2", "=", 
      RowBox[{"nsol2", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "1"}], "]"}], "]"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"zcut2", ">", "zmid"}], ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Error  \>\"", ",", "zcut2"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", 
      RowBox[{
      "horizp0", ",", "horizh0", ",", "horiza1", ",", "horizt1", ",", 
       "horizs0", ",", "asymp2", ",", "asymh2", ",", "asyma0", ",", "asyma1", 
       ",", "asymT3"}], "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Return", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"h", "'"}], "[", "eps", "]"}], ",", 
             RowBox[{
              RowBox[{"T", "'"}], "[", "eps", "]"}]}], "}"}], "/.", "nsol2"}],
           "]"}], ";"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"htab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"h", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Ttab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"T", "[", "z", "]"}], "-", "1"}], "/.", "nsol2"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Coefficient", "[", 
            RowBox[{"hfit", ",", "z"}], "]"}], ",", 
           RowBox[{"Coefficient", "[", 
            RowBox[{"Tfit", ",", "z"}], "]"}]}], "}"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "2"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"T", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"T", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"S", "[", "zmid", "]"}], "/.", "nsol1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"S", "[", "zmid", "]"}], "/.", "nsol2"}], ")"}]}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"dlist", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"p", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zmid", "]"}], "/.", "nsol1"}], ")"}],
             "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"S", "'"}], "[", "zmid", "]"}], "/.", "nsol2"}], 
             ")"}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"Join", "[", 
          RowBox[{"list", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"dlist", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"dlist", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"dlist", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}], "]"}], 
        ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"output", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ptab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"p", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"htab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"h", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"atab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"a", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Ttab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"T", "[", "z", "]"}], "-", "1"}], "/.", "nsol2"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Stab", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{
              RowBox[{"S", "[", "z", "]"}], "/.", "nsol2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"20", "eps"}], ",", 
             RowBox[{"100", "eps"}], ",", 
             RowBox[{"10", "eps"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"pfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"ptab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"afit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"atab", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "z"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", "^", "2"}], ",", 
             RowBox[{"z", "^", "3"}]}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Sfit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Stab", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "z"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"pfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"ptab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "2"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"hfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"htab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "2"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Tfit2", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"Ttab", ",", 
           RowBox[{"{", 
            RowBox[{"z", "^", "3"}], "}"}], ",", "z"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"pf", "==", "pfit"}], ",", 
             RowBox[{"hf", "\[Equal]", "hfit"}], ",", 
             RowBox[{"af", "\[Equal]", "afit"}], ",", 
             RowBox[{"Tf", "\[Equal]", "Tfit"}], ",", 
             RowBox[{"Sf", "\[Equal]", "Sfit"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"pfit2", ",", "hfit2", ",", "Tfit2"}], "}"}]}], "}"}], 
         "]"}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], 
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.5376407771099586`*^9, 3.53764077742128*^9}, {
   3.537640849432414*^9, 3.537641029700471*^9}, {3.537641083186082*^9, 
   3.5376410832815037`*^9}, {3.537641227496984*^9, 3.537641241071927*^9}, {
   3.537641278231781*^9, 3.53764129200132*^9}, {3.537811594660029*^9, 
   3.537811661635552*^9}, 3.537811712330718*^9, {3.537812313668707*^9, 
   3.537812329718534*^9}, {3.537812368025175*^9, 3.537812466952651*^9}, {
   3.537812574550178*^9, 3.53781262207281*^9}, {3.537855902100842*^9, 
   3.537855910975484*^9}, {3.537863637889791*^9, 3.537863642968212*^9}, {
   3.53786405512639*^9, 3.5378640577014513`*^9}, {3.5378642740193357`*^9, 
   3.5378642823266706`*^9}, {3.537864945886372*^9, 3.537864949610241*^9}, {
   3.537865324468916*^9, 3.5378653414829493`*^9}, {3.537865422417637*^9, 
   3.537865426010881*^9}, {3.537865668894218*^9, 3.5378656720161123`*^9}, {
   3.537866060689427*^9, 3.537866086110963*^9}, {3.537866821965849*^9, 
   3.537866824468356*^9}, {3.537866935754058*^9, 3.5378669532770844`*^9}, {
   3.537867277477654*^9, 3.537867283864683*^9}, {3.5378673736645327`*^9, 
   3.53786741047612*^9}, {3.537867724358015*^9, 3.537867770909184*^9}, {
   3.537867812374217*^9, 3.537867814824875*^9}, {3.537867862682262*^9, 
   3.537867863608501*^9}, {3.537867935345325*^9, 3.537867952471974*^9}, {
   3.537867984898217*^9, 3.5378679871300287`*^9}, {3.537870400150711*^9, 
   3.537870402077724*^9}, {3.537870448958918*^9, 3.5378704524785967`*^9}, {
   3.537870930220189*^9, 3.537870930900414*^9}, 3.537871139674671*^9, {
   3.537871192589308*^9, 3.53787120155658*^9}, {3.537871653378598*^9, 
   3.5378716648098917`*^9}, {3.537871703252593*^9, 3.537871787942024*^9}, {
   3.537871824557847*^9, 3.537871910740779*^9}, {3.537871941253039*^9, 
   3.5378719525649443`*^9}, {3.537871994498852*^9, 3.537872049059258*^9}, {
   3.537872138421897*^9, 3.537872144006673*^9}, {3.537872196836445*^9, 
   3.53787224947705*^9}, {3.5378722878468122`*^9, 3.537872372883222*^9}, {
   3.537872490150178*^9, 3.537872496093255*^9}, {3.537872547385435*^9, 
   3.537872561998753*^9}, {3.537872800792879*^9, 3.5378728967451353`*^9}, {
   3.537872969967389*^9, 3.537872993322166*^9}, {3.5378733845638*^9, 
   3.537873523491342*^9}, {3.537874990501849*^9, 3.5378750749448233`*^9}, {
   3.538046326178605*^9, 3.5380463263452587`*^9}, {3.538046359506956*^9, 
   3.5380464610359497`*^9}, {3.538046502103581*^9, 3.538046513481264*^9}, {
   3.53804657410702*^9, 3.538046614577108*^9}, {3.53804665505602*^9, 
   3.538046715360199*^9}, {3.538046757351519*^9, 3.53804676998315*^9}, {
   3.5380468595384607`*^9, 3.5380468659616413`*^9}, {3.538046897437215*^9, 
   3.538046897572302*^9}, {3.538047066640044*^9, 3.538047074544244*^9}, {
   3.538047229999874*^9, 3.5380472836305647`*^9}, {3.538047353035921*^9, 
   3.538047363818179*^9}, {3.538047476249525*^9, 3.538047522111104*^9}, {
   3.5380475966181917`*^9, 3.5380475967702713`*^9}, {3.538047801532692*^9, 
   3.538047822201064*^9}, {3.538047948516816*^9, 3.538047948684765*^9}, {
   3.538114366350466*^9, 3.5381144299925222`*^9}, {3.538114576757052*^9, 
   3.5381146749454412`*^9}, {3.538114791107875*^9, 3.5381148266944447`*^9}, {
   3.538114878968347*^9, 3.538115127215603*^9}, {3.53811552595366*^9, 
   3.538115590252236*^9}, {3.5381156363832006`*^9, 3.538115704042387*^9}, {
   3.53811589099817*^9, 3.53811590783984*^9}, {3.538115999280501*^9, 
   3.5381160364460382`*^9}, 3.538116068499432*^9, {3.5381163172614202`*^9, 
   3.5381163185592117`*^9}, 3.538116587083933*^9, {3.538116795975728*^9, 
   3.5381167961435547`*^9}, {3.538116915101754*^9, 3.538116916845715*^9}, {
   3.538117082639504*^9, 3.5381170838467207`*^9}, {3.538117120446578*^9, 
   3.538117121605109*^9}, {3.538117912630061*^9, 3.5381179255489893`*^9}, {
   3.538118168821506*^9, 3.538118170682723*^9}, {3.5381182778513527`*^9, 
   3.538118288943109*^9}, {3.5381183580154047`*^9, 3.5381183581193533`*^9}, {
   3.538118848337666*^9, 3.538118920486744*^9}, {3.538119184188271*^9, 
   3.53811918440349*^9}, {3.5381193489118156`*^9, 3.538119350612996*^9}, {
   3.538119892508926*^9, 3.538119895751055*^9}, {3.538119927591441*^9, 
   3.538119936248074*^9}, {3.538120029047421*^9, 3.538120037965654*^9}, {
   3.538120194027095*^9, 3.538120201471917*^9}, {3.53812028017563*^9, 
   3.538120301265314*^9}, {3.5381381252717533`*^9, 3.538138126469459*^9}, {
   3.538328246372367*^9, 3.5383282504354353`*^9}, {3.5383283005077343`*^9, 
   3.538328335488717*^9}, {3.538329001230315*^9, 3.538329010372521*^9}, {
   3.5383292041149054`*^9, 3.538329214953123*^9}, {3.5383314262207823`*^9, 
   3.538331427882743*^9}, {3.538467415297628*^9, 3.538467417025399*^9}, {
   3.538467483475766*^9, 3.538467496260305*^9}, {3.53846768282121*^9, 
   3.538467684491909*^9}, 3.538467751698575*^9, 3.538467834293067*^9, 
   3.538467910310305*^9, {3.538474665252652*^9, 3.5384747132015*^9}, {
   3.53847578605576*^9, 3.538475802638404*^9}, {3.538483710131217*^9, 
   3.5384837122828617`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"veclist", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.868`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.07409605574209051`", ",", "2.120168551991567`", ",", 
         "0.9979641465626632`", ",", 
         RowBox[{"-", "0.13206619699953426`"}], ",", "0.1096803066408052`", 
         ",", "1.8798507183251827`", ",", 
         RowBox[{"-", "1.8883455741980362`"}], ",", 
         RowBox[{"-", "1.8849422184581242`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8630000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.10094946961325645`", ",", "2.11843896557585`", ",", 
         "0.996221622879231`", ",", 
         RowBox[{"-", "0.1804917165177124`"}], ",", "0.1492701497125977`", 
         ",", "1.884992279481818`", ",", 
         RowBox[{"-", "1.9007800178918746`"}], ",", 
         RowBox[{"-", "1.8930351877297216`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.858`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.12197000170131408`", ",", "2.1167233983193694`", ",", 
         "0.9944850339762491`", ",", 
         RowBox[{"-", "0.21876327909130314`"}], ",", "0.1801886009746716`", 
         ",", "1.8900978504268293`", ",", 
         RowBox[{"-", "1.9131742069140136`"}], ",", 
         RowBox[{"-", "1.9016726924990976`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8530000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.13991378424453033`", ",", "2.1149837348926606`", ",", 
         "0.9927440162648846`", ",", 
         RowBox[{"-", "0.2517293820681301`"}], ",", "0.20648020601257608`", 
         ",", "1.8952275889273653`", ",", 
         RowBox[{"-", "1.9256311591239745`"}], ",", 
         RowBox[{"-", "1.909808191488722`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.848`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.1558346013771002`", ",", "2.113225412671581`", ",", 
         "0.9910000469003952`", ",", 
         RowBox[{"-", "0.28124731545350495`"}], ",", "0.22972733575964316`", 
         ",", "1.900372935353736`", ",", 
         RowBox[{"-", "1.9381362448249575`"}], ",", 
         RowBox[{"-", "1.9180104248625407`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8430000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17016875000194848`", ",", "2.1115098780778703`", ",", 
         "0.9892697750637398`", ",", 
         RowBox[{"-", "0.3080592423512553`"}], ",", "0.2506153749130479`", 
         ",", "1.9054371593492085`", ",", 
         RowBox[{"-", "1.9505236948034614`"}], ",", 
         RowBox[{"-", "1.9261627936566683`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.84`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17826167507411272`", ",", "2.1104559051192573`", ",", 
         "0.9882259326796118`", ",", 
         RowBox[{"-", "0.32330581600520547`"}], ",", "0.26236779856342607`", 
         ",", "1.9085078859494449`", ",", 
         RowBox[{"-", "1.9580215612745053`"}], ",", 
         RowBox[{"-", "1.931121256897245`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.82`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.22488694197749054`", ",", "2.103380714521802`", ",", 
         "0.9812728968525489`", ",", 
         RowBox[{"-", "0.41286781222427793`"}], ",", "0.3296044742182707`", 
         ",", "1.9289306281682954`", ",", 
         RowBox[{"-", "2.008120303091178`"}], ",", 
         RowBox[{"-", "1.9650601848404534`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.263403558765456`", ",", "2.096205608174961`", ",", 
         "0.9743256730333851`", ",", 
         RowBox[{"-", "0.48939211154605033`"}], ",", "0.3843975474769295`", 
         ",", "1.9492937907951573`", ",", 
         RowBox[{"-", "2.05845848599753`"}], ",", 
         RowBox[{"-", "1.9995561358962997`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.78`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.29697518455095745`", ",", "2.0889423128476263`", ",", 
         "0.9673869185290676`", ",", 
         RowBox[{"-", "0.558279652709024`"}], ",", "0.4315291947985173`", ",",
          "1.9695814694547868`", ",", 
         RowBox[{"-", "2.1090091196394116`"}], ",", 
         RowBox[{"-", "2.0352685093571585`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.76`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.3271598204456268`", ",", "2.081567124294121`", ",", 
         "0.9604497669481518`", ",", 
         RowBox[{"-", "0.6221486306454592`"}], ",", "0.47328486423405836`", 
         ",", "1.9898325723528631`", ",", 
         RowBox[{"-", "2.1598388644472086`"}], ",", 
         RowBox[{"-", "2.071552595488018`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7200000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.3805021914087528`", ",", "2.066514870321669`", ",", 
         "0.9465874464830879`", ",", 
         RowBox[{"-", "0.7400039977668367`"}], ",", "0.5455047926770815`", 
         ",", "2.0301803808864767`", ",", 
         RowBox[{"-", "2.2622601874863317`"}], ",", 
         RowBox[{"-", "2.1473061767619304`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7000000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.4046128853375105`", ",", "2.0588198731087877`", ",", 
         "0.9396565452523309`", ",", 
         RowBox[{"-", "0.795537154126863`"}], ",", "0.5773661902403812`", ",",
          "2.0503081121045224`", ",", 
         RowBox[{"-", "2.3139052814335432`"}], ",", 
         RowBox[{"-", "2.186433658947585`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6800000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.42738986570203724`", ",", "2.0510415737040817`", ",", 
         "0.932732941463491`", ",", 
         RowBox[{"-", "0.8493817405747806`"}], ",", "0.607017515193857`", ",",
          "2.070362854344421`", ",", 
         RowBox[{"-", "2.3657698062065`"}], ",", 
         RowBox[{"-", "2.226488748803607`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6600000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.4490644897242795`", ",", "2.0431503052332096`", ",", 
         "0.9258082749841597`", ",", 
         RowBox[{"-", "0.9019290716600774`"}], ",", "0.6347851658005186`", 
         ",", "2.090391510684943`", ",", 
         RowBox[{"-", "2.4179342410329308`"}], ",", 
         RowBox[{"-", "2.2678968345073445`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.62`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.48966127102623513`", ",", "2.0270829673417428`", ",", 
         "0.9119680934315914`", ",", 
         RowBox[{"-", "1.0038852676290009`"}], ",", "0.6855185237246182`", 
         ",", "2.13029486109991`", ",", 
         RowBox[{"-", "2.5230393049728153`"}], ",", 
         RowBox[{"-", "2.3528071117321376`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5088314372895092`", ",", "2.018878236095998`", ",", 
         "0.9050440626366997`", ",", 
         RowBox[{"-", "1.0536960221886291`"}], ",", "0.7088332820279133`", 
         ",", "2.1502152257033487`", ",", 
         RowBox[{"-", "2.5760592963152127`"}], ",", 
         RowBox[{"-", "2.3967672740185004`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.58`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5273545275263245`", ",", "2.010575258529651`", ",", 
         "0.8981208966176263`", ",", 
         RowBox[{"-", "1.1028793495786011`"}], ",", "0.7309985511711032`", 
         ",", "2.170093522850811`", ",", 
         RowBox[{"-", "2.6293577550798335`"}], ",", 
         RowBox[{"-", "2.442127737440482`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.56`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5453077255774209`", ",", "2.0021626572013895`", ",", 
         "0.8911951179108348`", ",", 
         RowBox[{"-", "1.1515364877849836`"}], ",", "0.7520675842519604`", 
         ",", "2.189947276035549`", ",", 
         RowBox[{"-", "2.682965705949222`"}], ",", 
         RowBox[{"-", "2.4880947291761606`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.52`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5797281594432059`", ",", "1.9850115064241494`", ",", 
         "0.8773345210374353`", ",", 
         RowBox[{"-", "1.2476078725156199`"}], ",", "0.7913395670399445`", 
         ",", "2.229582003315571`", ",", 
         RowBox[{"-", "2.791119378501514`"}], ",", 
         RowBox[{"-", "2.5830794221371645`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5962865178030728`", ",", "1.9762766204423838`", ",", 
         "0.8703996350381962`", ",", 
         RowBox[{"-", "1.2951477748864133`"}], ",", "0.8097010177996378`", 
         ",", "2.2493599143445286`", ",", 
         RowBox[{"-", "2.845665400722957`"}], ",", 
         RowBox[{"-", "2.6321062777511957`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.48`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6124714214301092`", ",", "1.9674207398689028`", ",", 
         "0.8634571985828617`", ",", 
         RowBox[{"-", "1.3424501191023754`"}], ",", "0.8272732318349333`", 
         ",", "2.2691341396915985`", ",", 
         RowBox[{"-", "2.9005642737031407`"}], ",", 
         RowBox[{"-", "2.6822204172706203`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.44`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6438209671286115`", ",", "1.9493940340092228`", ",", 
         "0.849559994780463`", ",", 
         RowBox[{"-", "1.4364446858730455`"}], ",", "0.8603685854903844`", 
         ",", "2.308605812587862`", ",", 
         RowBox[{"-", "3.011326105997462`"}], ",", 
         RowBox[{"-", "2.7860539537726856`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.4200000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6590456785721874`", ",", "1.9402159607617797`", ",", 
         "0.8426022906426062`", ",", 
         RowBox[{"-", "1.4832140488394734`"}], ",", "0.8759550669907962`", 
         ",", "2.328315490980453`", ",", 
         RowBox[{"-", "3.067216233533839`"}], ",", 
         RowBox[{"-", "2.839376372487654`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.3800000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6887287617582241`", ",", "1.9215013977136444`", ",", 
         "0.8286586577921988`", ",", 
         RowBox[{"-", "1.5764938761555642`"}], ",", "0.9053719458902377`", 
         ",", "2.367726088123225`", ",", 
         RowBox[{"-", "3.1801001723213007`"}], ",", 
         RowBox[{"-", "2.9494204405805933`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.36`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7032264406191593`", ",", "1.911966636481573`", ",", 
         "0.8216720594144495`", ",", 
         RowBox[{"-", "1.6230575588931981`"}], ",", "0.9192800184979449`", 
         ",", "2.3874262771487995`", ",", 
         RowBox[{"-", "3.2371024942745943`"}], ",", 
         RowBox[{"-", "3.0061441868231955`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.34`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7175184633466903`", ",", "1.9023140363077047`", ",", 
         "0.8146750132812847`", ",", 
         RowBox[{"-", "1.6695961776918746`"}], ",", "0.9326989945280368`", 
         ",", "2.4071224483050213`", ",", 
         RowBox[{"-", "3.2944823760345705`"}], ",", 
         RowBox[{"-", "3.0640137430428847`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.32`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7316236278236997`", ",", "1.892538357642916`", ",", 
         "0.8076656225360733`", ",", 
         RowBox[{"-", "1.716138544533985`"}], ",", "0.9456473034737107`", ",",
          "2.4268225920081994`", ",", 
         RowBox[{"-", "3.352257372105316`"}], ",", 
         RowBox[{"-", "3.1230544109686846`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.28`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.759327630044047`", ",", "1.8726252884090915`", ",", 
         "0.7936093988176277`", ",", 
         RowBox[{"-", "1.8092946252978641`"}], ",", "0.9702715256209089`", 
         ",", "2.4662250249723754`", ",", 
         RowBox[{"-", "3.468998672177377`"}], ",", 
         RowBox[{"-", "3.244691808425779`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.23`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.793157516173759`", ",", "1.8470221833116771`", ",", 
         "0.7759543195536678`", ",", 
         RowBox[{"-", "1.926084168284337`"}], ",", "0.9988649230120109`", ",",
          "2.5155298343116375`", ",", 
         RowBox[{"-", "3.6172923759074913`"}], ",", 
         RowBox[{"-", "3.403639782925374`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.18`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.8262833012364006`", ",", "1.8205837200802935`", ",", 
         "0.7581849149437223`", ",", 
         RowBox[{"-", "2.043517834789346`"}], ",", "1.0252809707518953`", ",",
          "2.564951928019079`", ",", 
         RowBox[{"-", "3.768399956744153`"}], ",", 
         RowBox[{"-", "3.5705963723620657`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.03`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.9230488688213225`", ",", "1.73588609398436`", ",", 
         "0.7039940643249193`", ",", 
         RowBox[{"-", "2.4019805149276023`"}], ",", "1.0942543883857436`", 
         ",", "2.7143508760863733`", ",", 
         RowBox[{"-", "4.240489973931262`"}], ",", 
         RowBox[{"-", "4.123436603974003`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.98`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.9549279981238569`", ",", "1.7056750601798654`", ",", 
         "0.6855521428817635`", ",", 
         RowBox[{"-", "2.5242985092271657`"}], ",", "1.114555308899134`", ",",
          "2.7647280495543316`", ",", 
         RowBox[{"-", "4.404914229188696`"}], ",", 
         RowBox[{"-", "4.326628213569345`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9299999999999999`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.986857615616634`", ",", "1.6743550719995128`", ",", 
         "0.6668700888623107`", ",", 
         RowBox[{"-", "2.6484410797834674`"}], ",", "1.1338173625182217`", 
         ",", "2.815515897460275`", ",", 
         RowBox[{"-", "4.573359485184544`"}], ",", 
         RowBox[{"-", "4.540306961248853`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.88`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0189782070091018`", ",", "1.6418495888986004`", ",", 
         "0.6479144619747503`", ",", 
         RowBox[{"-", "2.7746598884801315`"}], ",", "1.1522566054543582`", 
         ",", "2.8667820124242054`", ",", 
         RowBox[{"-", "4.746155719065648`"}], ",", 
         RowBox[{"-", "4.76514244154874`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8300000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0514363539949725`", ",", "1.6080712188475348`", ",", 
         "0.6286476155983801`", ",", 
         RowBox[{"-", "2.903241545154152`"}], ",", "1.1701212378997488`", ",",
          "2.9185998862859255`", ",", 
         RowBox[{"-", "4.923682903219094`"}], ",", 
         RowBox[{"-", "5.002008900278566`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.78`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0844010454097461`", ",", "1.572887661093316`", ",", 
         "0.6090193365955197`", ",", 
         RowBox[{"-", "3.034504887082299`"}], ",", "1.1875031258439983`", ",",
          "2.971090532668834`", ",", 
         RowBox[{"-", "5.106421449956452`"}], ",", 
         RowBox[{"-", "5.251811873544956`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.73`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1180479966266779`", ",", "1.5361730163991627`", ",", 
         "0.588978613592471`", ",", 
         RowBox[{"-", "3.1688120759508878`"}], ",", "1.2046503944973106`", 
         ",", "3.024353579034675`", ",", 
         RowBox[{"-", "5.294886464737035`"}], ",", 
         RowBox[{"-", "5.515627155864887`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.6799999999999999`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1525837188902464`", ",", "1.4977570080308695`", ",", 
         "0.568461058774028`", ",", 
         RowBox[{"-", "3.306576091782493`"}], ",", "1.2217108459212238`", ",",
          "3.078528825897698`", ",", 
         RowBox[{"-", "5.489706657652221`"}], ",", 
         RowBox[{"-", "5.794792774146105`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.63`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1882418065099052`", ",", "1.4574526479500487`", ",", 
         "0.5473946051470174`", ",", 
         RowBox[{"-", "3.44828153950453`"}], ",", "1.2389675741800101`", ",", 
         "3.1337571079417206`", ",", 
         RowBox[{"-", "5.69160646740515`"}], ",", 
         RowBox[{"-", "6.091006264154231`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.58`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.225305531795742`", ",", "1.415017305618747`", ",", 
         "0.5256894636474833`", ",", 
         RowBox[{"-", "3.5945070249561994`"}], ",", "1.2566285813178981`", 
         ",", "3.190224734457376`", ",", 
         RowBox[{"-", "5.901477288136015`"}], ",", 
         RowBox[{"-", "6.406073534076588`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.53`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.2641202878210855`", ",", "1.3701532912838383`", ",", 
         "0.5032367592682069`", ",", 
         RowBox[{"-", "3.745944023702552`"}], ",", "1.2749492456089138`", ",",
          "3.2481515787097424`", ",", 
         RowBox[{"-", "6.12039536605819`"}], ",", 
         RowBox[{"-", "6.742346946394514`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.48`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3051173605423914`", ",", "1.3224924070876931`", ",", 
         "0.47990281899507703`", ",", 
         RowBox[{"-", "3.903453166116109`"}], ",", "1.2942804705700126`", ",",
          "3.3078010338537096`", ",", 
         RowBox[{"-", "6.3496994746537645`"}], ",", 
         RowBox[{"-", "7.102722008787847`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.42999999999999994`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3488591460162878`", ",", "1.271548393431121`", ",", 
         "0.4555152710323542`", ",", 
         RowBox[{"-", "4.0681096407769`"}], ",", "1.3149514902873514`", ",", 
         "3.3695179164521227`", ",", 
         RowBox[{"-", "6.591085402958407`"}], ",", 
         RowBox[{"-", "7.490873737285019`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.38`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3960957591064582`", ",", "1.216685753047732`", ",", 
         "0.42985107157498326`", ",", 
         RowBox[{"-", "4.241312742141526`"}], ",", "1.337427292084789`", ",", 
         "3.4337399590177204`", ",", 
         RowBox[{"-", "6.84675801294185`"}], ",", 
         RowBox[{"-", "7.911597762080053`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.32999999999999996`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.447873230106782`", ",", "1.1570340351583543`", ",", 
         "0.4026093032641672`", ",", 
         RowBox[{"-", "4.4249325467136185`"}], ",", "1.3622900283129145`", 
         ",", "3.501054633931335`", ",", 
         RowBox[{"-", "7.119675995248774`"}], ",", 
         RowBox[{"-", "8.371305919012228`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.28`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.5057236960045268`", ",", "1.0913518674675085`", ",", 
         "0.373367196787542`", ",", 
         RowBox[{"-", "4.621576053138501`"}], ",", "1.390318997704208`", ",", 
         "3.572281474924267`", ",", 
         RowBox[{"-", "7.413971974028285`"}], ",", 
         RowBox[{"-", "8.878975020794677`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.22999999999999998`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.57203980735116`", ",", "1.0177678673734798`", ",", 
         "0.34149736181382523`", ",", 
         RowBox[{"-", "4.835076798074535`"}], ",", "1.4226214179605465`", ",",
          "3.6486273990264926`", ",", 
         RowBox[{"-", "7.735734242987447`"}], ",", 
         RowBox[{"-", "9.44782848881641`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.07999999999999985`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.8892842980600542`", ",", "0.7021647764329307`", ",", 
         "0.21477094825370602`", ",", 
         RowBox[{"-", "5.668698911077289`"}], ",", "1.571068461292025`", ",", 
         "3.937321470523456`", ",", 
         RowBox[{"-", "9.011955267383346`"}], ",", 
         RowBox[{"-", "11.838448294690265`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.030000000000000027`", ",", 
       RowBox[{"{", 
        RowBox[{
        "2.14505629502275`", ",", "0.5002442116584971`", ",", 
         "0.14210334806045316`", ",", 
         RowBox[{"-", "6.127329861034945`"}], ",", "1.6695931030439755`", ",",
          "4.090153831975672`", ",", 
         RowBox[{"-", "9.72589898707181`"}], ",", 
         RowBox[{"-", "13.263510038735388`"}]}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", "10"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"veclist", "[", 
  RowBox[{"[", "pos", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.543869146102605*^9, 3.54386916194459*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", 
    RowBox[{"-", "2"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"veclist", "[", 
  RowBox[{"[", "pos", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5438974702824497`*^9, 3.5438974936199408`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", 
    RowBox[{"-", "4"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"veclist", "[", 
  RowBox[{"[", "pos", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.543904987541423*^9, 3.543904987620802*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", 
    RowBox[{"-", "10"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"veclist", "[", 
  RowBox[{"[", "pos", "]"}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos", "=", 
    RowBox[{"-", "15"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"veclist", "[", 
  RowBox[{"[", "pos", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.543869146102605*^9, 3.54386916194459*^9}, {
  3.543900205228382*^9, 3.5439002066761827`*^9}, {3.544360047505619*^9, 
  3.544360047560308*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{
     RowBox[{"veclist", "[", 
      RowBox[{"[", 
       RowBox[{"pos", ",", "2"}], "]"}], "]"}], ",", "30"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.538395488974235*^9, 3.538395494671344*^9}, {
  3.538475270148683*^9, 3.538475278100976*^9}, {3.5384753323016653`*^9, 
  3.538475399427929*^9}, {3.5384755290732517`*^9, 3.538475544392206*^9}, {
  3.543869127892708*^9, 3.54386915139429*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"q", "=", 
    RowBox[{"SetPrecision", "[", 
     RowBox[{
      RowBox[{"veclist", "[", 
       RowBox[{"[", 
        RowBox[{"pos", ",", "1"}], "]"}], "]"}], ",", "30"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"z0", "=", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{"1.0", ",", "30"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5384755568817177`*^9, 3.5384755586157703`*^9}, {
  3.5384757492560873`*^9, 3.538475756552244*^9}, {3.543869138276383*^9, 
  3.5438691571702213`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "pos"}], "=", "10"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"vec", "=", 
    RowBox[{"SetPrecision", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "0.29697363542613545937691590416647227748`17.20250397781238", ",", 
        "2.08894358534780424367318105192768800917`18.13685924825164", ",", 
        "0.96738725367736208075386374888031263026`18.372428591509202", ",", 
        RowBox[{
        "-", "0.55827474229845810904233306344697176166`17.107865265240648"}], 
        ",", "0.43154252960170968610754051615184673972`17.519179915607896", 
        ",", "1.96957958849580014784243259519123048591`17.91790748377006", 
        ",", 
        RowBox[{
        "-", "2.10900610437849584091238444794489094089`17.710818168552525"}], 
        ",", 
        RowBox[{
        "-", "2.02035177575709567233601406563594564888`17.505433280375204"}]}]\
, "}"}], ",", "30"}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.538395488974235*^9, 3.538395494671344*^9}, {
   3.538487155497856*^9, 3.5384871600489283`*^9}, {3.538487422110376*^9, 
   3.53848743906916*^9}, 3.543869321101018*^9, {3.543897522162199*^9, 
   3.5438975310016108`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "pos"}], "=", 
    RowBox[{"-", "2"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"vec", "=", 
    RowBox[{"SetPrecision", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "1.8892844524867614437504491639893515186971844353659410873146`20.\
22423459005405", ",", 
        "0.7021645475278859333939346880403492965507353157484182216638`19.\
17347823010585", ",", 
        "0.2147708913389526631402214769327323266982326252288431498949`19.\
313177032768163", ",", 
        RowBox[{
        "-", "5.66870034036873178374394749293889384491`19.150132294414927"}], 
        ",", "1.57105272049004662649142397540219506392`18.394179673138456", 
        ",", "3.93732173764543766712035444763577872493`19.459340637655462", 
        ",", 
        RowBox[{
        "-", "9.01195460356254563516825487611162135223`19.337931527630595"}], 
        ",", 
        RowBox[{
        "-", "11.82129051889452589779289842894425894981`19.025886865407752"}]}\
], "}"}], ",", "30"}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.543897655458242*^9, 3.543897671955442*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "pos"}], "=", 
    RowBox[{"-", "4"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"vec", "=", 
    RowBox[{"SetPrecision", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "1.5057237131236946149572585277001824715547604249937523528014`20.\
198489839014602", ",", 
        "1.0913520186069008169023962405756889384286004585925752288334`19.\
45425754351719", ",", 
        "0.3733671977741275317827716090449990681224663915491298672491`19.\
609798741566237", ",", 
        RowBox[{
        "-", "4.62160136115503603924571522000341036396`19.37673763017697"}], 
        ",", "1.3903207060443585196081175574042790746`18.643859092522224", 
        ",", "3.57228115704934353697166528552304459294`19.66148809577124", 
        ",", 
        RowBox[{
        "-", "7.41397203469514625133211363434975096847`19.578083192017885"}], 
        ",", 
        RowBox[{
        "-", "8.86898196995222814779997966770086529663`19.23867673419304"}]}],
        "}"}], ",", "30"}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.543905189672185*^9, 3.543905197098374*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "pos"}], "=", 
    RowBox[{"-", "10"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"vec", "=", 
    RowBox[{"SetPrecision", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "1.2253058947424784588215155611788016165515547704948190356405`19.\
645376195503864", ",", 
        "1.41501644238059762867360974244311560369`19.174568259913467", ",", 
        "0.5256892109567251090535488404918756067355932361892882240715`19.\
351077820461178", ",", 
        RowBox[{
        "-", "3.5945959466535168245217380912834868539`19.025902052129865"}], 
        ",", "1.25663965001164235059577719311566080406`18.37333071547694", 
        ",", "3.1902258454721581346468094202216547031`19.297085788079837", 
        ",", 
        RowBox[{
        "-", "5.90147885173273852073711409536465271795`19.23740566531368"}], 
        ",", 
        RowBox[{
        "-", "6.39244021232910792635573669843619841537`18.876704127014893"}]}]\
, "}"}], ",", "30"}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.543900252999133*^9, 3.543900269953738*^9}, {
  3.543900610457769*^9, 3.543900611410213*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "pos"}], "=", 
    RowBox[{"-", "15"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"vec", "=", 
    RowBox[{"SetPrecision", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "1.0514372429042203375562594196243562228373953569940051398153`19.\
575737080677218", ",", 
        "1.60806906929638127795544371494463124145`19.292411507784227", ",", 
        "0.6286470349209578111109977926158731683829688337958375306897`19.\
484682135155662", ",", 
        RowBox[{
        "-", "2.90336942339238371772102781826423056419`19.07274839606759"}], 
        ",", "1.17014687176092472413088338629161576568`18.52453289805585", 
        ",", "2.91860268717924982569977129865931673798`19.35231759205413", 
        ",", 
        RowBox[{
        "-", "4.92368667325038081812426738727014797736`19.292355909532297"}], 
        ",", 
        RowBox[{
        "-", "4.99184034619885460045701727438889923335`18.95896208462151"}]}],
        "}"}], ",", "30"}], "]"}]}], ";"}]}]], "Input"],

Cell[BoxData["q"], "Input",
 CellChangeTimes->{{3.5384871726643677`*^9, 3.538487176504283*^9}, 
   3.543869337075305*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nsol", "=", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"inteq", "[", 
      RowBox[{
       RowBox[{"SetPrecision", "[", 
        RowBox[{"1.", ",", "30"}], "]"}], ",", "x1", ",", "q", ",", "x2", ",",
        "x3", ",", "x4", ",", "x5", ",", "x6", ",", "x7", ",", "x8", ",", 
       "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x3", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x4", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x5", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x6", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "6", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x7", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "7", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x8", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"[", "8", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "25"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"inteq", "[", 
     RowBox[{
     "1.", ",", "x1", ",", "q", ",", "x2", ",", "x3", ",", "x4", ",", "x5", 
      ",", "x6", ",", "x7", ",", "x8", ",", "2"}], "]"}], "/.", "nsol"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5383955289097357`*^9, 3.538395607280014*^9}, {
  3.5384675702538347`*^9, 3.538467573581067*^9}, {3.538467922768297*^9, 
  3.5384679239991417`*^9}, {3.5384871845792227`*^9, 3.538487189060872*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"NR", "=", "30"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"filename", "=", "\"\<~/Work/AdSCMTDyn4/C/results30/init.dat\>\""}],
   ";"}]}], "Input",
 CellChangeTimes->{{3.51763841954007*^9, 3.517638421220167*^9}, {
   3.53850182798134*^9, 3.538501830676206*^9}, {3.53873119805525*^9, 
   3.538731198141795*^9}, 3.538741113249531*^9, 3.538808539493106*^9, 
   3.538808990452856*^9, {3.5388105439971848`*^9, 3.538810586676996*^9}, {
   3.543736247015036*^9, 3.543736247074452*^9}, {3.543870715483357*^9, 
   3.543870715611312*^9}, {3.5438978857628527`*^9, 3.543897885919701*^9}, {
   3.5439006298100147`*^9, 3.543900629881624*^9}, {3.543903426456932*^9, 
   3.5439034280245743`*^9}, {3.543903488357287*^9, 3.54390348850725*^9}, {
   3.5439052037907667`*^9, 3.543905203894629*^9}, {3.543905298643736*^9, 
   3.5439052990099363`*^9}, {3.5439053567107677`*^9, 3.543905356851726*^9}, {
   3.543906198943074*^9, 3.543906199078765*^9}, {3.543906294584394*^9, 
   3.543906294655184*^9}, {3.543909603963183*^9, 3.543909604089979*^9}, {
   3.543909770014927*^9, 3.5439097701162148`*^9}, {3.5439852233386717`*^9, 
   3.543985223449888*^9}, {3.543993530100072*^9, 3.543993532539686*^9}, {
   3.5440130884367943`*^9, 3.5440130889003887`*^9}, {3.5440157640141783`*^9, 
   3.544015764108427*^9}, {3.544017796041869*^9, 3.54401779614489*^9}, {
   3.544018008043001*^9, 3.54401800814524*^9}, {3.5440184195612793`*^9, 
   3.544018419639524*^9}, {3.544189083309032*^9, 3.544189083412706*^9}, {
   3.54425239203193*^9, 3.544252392099689*^9}, {3.544252991826147*^9, 
   3.544252991916683*^9}, {3.544253031171064*^9, 3.544253058763973*^9}, {
   3.544262981102045*^9, 3.544262981157898*^9}, {3.544271648797222*^9, 
   3.544271648868958*^9}, {3.544272837438056*^9, 3.544272837853793*^9}, {
   3.544273340190439*^9, 3.544273340365365*^9}, {3.544274354472459*^9, 
   3.5442743545159492`*^9}, {3.544274874816003*^9, 3.54427487494139*^9}, {
   3.5442863504535*^9, 3.5442863505314302`*^9}, {3.5442870190212307`*^9, 
   3.5442870191481256`*^9}, {3.5443299930178747`*^9, 3.544329993063661*^9}, {
   3.5443302084393787`*^9, 3.544330208534906*^9}, {3.544330761266027*^9, 
   3.544330761369117*^9}, {3.5443327324534883`*^9, 3.544332732555369*^9}, {
   3.544337774473035*^9, 3.544337777969997*^9}, {3.5443460476714*^9, 
   3.544346048917741*^9}, {3.544346223516473*^9, 3.54434622360282*^9}, {
   3.544354274176853*^9, 3.544354274444755*^9}, {3.544356076882224*^9, 
   3.5443560770323877`*^9}, {3.544356297018445*^9, 3.544356297353506*^9}, {
   3.5443565628311462`*^9, 3.544356562973846*^9}, {3.544357068021755*^9, 
   3.544357068180419*^9}, {3.544357506530333*^9, 3.544357506593233*^9}, {
   3.544358127931398*^9, 3.5443581279783163`*^9}, {3.544359000651141*^9, 
   3.544359001002852*^9}, {3.544359271784672*^9, 3.5443592718794527`*^9}, {
   3.544359572598427*^9, 3.544359572692374*^9}, {3.544361584838049*^9, 
   3.5443615849809732`*^9}, {3.544362140141363*^9, 3.544362140219472*^9}, {
   3.544425022511558*^9, 3.544425027334375*^9}, {3.54442526173431*^9, 
   3.544425261893257*^9}, {3.5444337183551188`*^9, 3.544433733622573*^9}, {
   3.5444338850151453`*^9, 3.5444338850874968`*^9}, {3.544434618018178*^9, 
   3.544434673655767*^9}, {3.544435263501852*^9, 3.544435299916265*^9}, {
   3.544435347596054*^9, 3.544435350027239*^9}, {3.5444353884835243`*^9, 
   3.5444354084257507`*^9}, {3.5444367115619497`*^9, 3.544436712121657*^9}, {
   3.54450723403752*^9, 3.544507234317377*^9}, {3.5445082484841957`*^9, 
   3.544508248578281*^9}, {3.544508819890078*^9, 3.544508819988517*^9}, {
   3.544509179906464*^9, 3.544509180056974*^9}, {3.544509220192216*^9, 
   3.544509224383067*^9}, {3.544510049652052*^9, 3.5445100497341127`*^9}, {
   3.544511689130064*^9, 3.544511689777046*^9}, {3.544529196809538*^9, 
   3.54452919688062*^9}, {3.5445293076396713`*^9, 3.5445293077979393`*^9}, {
   3.544780717204665*^9, 3.5447807175858803`*^9}, {3.544781315837915*^9, 
   3.5447813159562063`*^9}, {3.544782309606492*^9, 3.544782310453442*^9}, {
   3.5447830835491962`*^9, 3.54478308371568*^9}, {3.544789814222258*^9, 
   3.5447898405330353`*^9}, {3.544790201938601*^9, 3.544790202113593*^9}, {
   3.544804751403654*^9, 3.5448047514906*^9}, {3.544805047693344*^9, 
   3.54480504779711*^9}, {3.544805134400548*^9, 3.544805134500454*^9}, {
   3.544859660855748*^9, 3.544859661208118*^9}, 3.5448598181114473`*^9, {
   3.544864777665333*^9, 3.544864778303286*^9}, {3.544864825713305*^9, 
   3.544864839030218*^9}, {3.544864884440634*^9, 3.544864884566297*^9}, 
   3.544865147768187*^9, {3.544867203080557*^9, 3.544867203206509*^9}, {
   3.544867807696823*^9, 3.5448678080865517`*^9}, 3.544870045906448*^9, {
   3.544870946231864*^9, 3.54487094630343*^9}, 3.5448710973288593`*^9, {
   3.5448712919133387`*^9, 3.544871292056027*^9}, {3.54489447853442*^9, 
   3.5448944786452093`*^9}, {3.5448948178122387`*^9, 3.544894854546524*^9}, {
   3.549628724806429*^9, 3.549628727415605*^9}, {3.549628823186996*^9, 
   3.549628825458234*^9}, {3.549628949393957*^9, 3.5496289539036703`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"NN", "=", 
    RowBox[{"NR", "-", "1"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ChebR", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"\[Pi]", " ", "ii"}], "NN"], "]"}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "NN", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N", "[", "ChebR", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aval", "=", 
   RowBox[{
    RowBox[{"asyma0", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"asymp2", "\[Rule]", "x4"}], ",", 
       RowBox[{"asymh2", "\[Rule]", "x5"}], ",", 
       RowBox[{"asyma0", "\[Rule]", "x6"}], ",", 
       RowBox[{"asyma1", "\[Rule]", "x7"}], ",", 
       RowBox[{"asymT3", "\[Rule]", "x8"}]}], "}"}]}], "/.", "nsol"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", "z"], 
         RowBox[{"p", "[", "z", "]"}]}], "/.", "nsol1"}], "/.", 
       RowBox[{"{", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", 
            RowBox[{"-", "2"}]}], "]"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{"horizp", "[", "z", "]"}], "z"], "/.", 
          RowBox[{"{", 
           RowBox[{"z", "\[Rule]", "1"}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"horizp0", "\[Rule]", "x1"}], ",", 
           RowBox[{"horizh0", "\[Rule]", "0"}], ",", 
           RowBox[{"horiza1", "\[Rule]", "q"}], ",", 
           RowBox[{"horizt1", "\[Rule]", "x2"}], ",", 
           RowBox[{"horizs0", "\[Rule]", "x3"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hlist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", "z"], 
         RowBox[{"h", "[", "z", "]"}]}], "/.", "nsol1"}], "/.", 
       RowBox[{"{", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", 
            RowBox[{"-", "2"}]}], "]"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{"horizh", "[", "z", "]"}], "z"], "/.", 
          RowBox[{"{", 
           RowBox[{"z", "\[Rule]", "1"}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"horizp0", "\[Rule]", "x1"}], ",", 
           RowBox[{"horizh0", "\[Rule]", "0"}], ",", 
           RowBox[{"horiza1", "\[Rule]", "q"}], ",", 
           RowBox[{"horizt1", "\[Rule]", "x2"}], ",", 
           RowBox[{"horizs0", "\[Rule]", "x3"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"alist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Expand", "[", 
           RowBox[{"asyma", "[", "z", "]"}], "]"}], "/.", 
          RowBox[{"{", 
           RowBox[{"z", "\[Rule]", "0"}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"asymp2", "\[Rule]", "x4"}], ",", 
           RowBox[{"asymh2", "\[Rule]", "x5"}], ",", 
           RowBox[{"asyma0", "\[Rule]", "x6"}], ",", 
           RowBox[{"asyma1", "\[Rule]", "x7"}], ",", 
           RowBox[{"asymT3", "\[Rule]", "x8"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "[", "z", "]"}], ")"}], "/.", "nsol1"}], "/.", 
         RowBox[{"{", 
          RowBox[{"z", "\[Rule]", 
           RowBox[{"ChebR", "[", 
            RowBox[{"[", 
             RowBox[{"2", ";;", 
              RowBox[{"-", "2"}]}], "]"}], "]"}]}], "}"}]}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"asymp2", "\[Rule]", "x4"}], ",", 
          RowBox[{"asymh2", "\[Rule]", "x5"}], ",", 
          RowBox[{"asyma0", "\[Rule]", "x6"}], ",", 
          RowBox[{"asyma1", "\[Rule]", "x7"}], ",", 
          RowBox[{"asymT3", "\[Rule]", "x8"}]}], "}"}]}], "/.", "nsol"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"horiza", "[", "z", "]"}], "/.", 
           RowBox[{"{", 
            RowBox[{"z", "\[Rule]", "1"}], "}"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"horizp0", "\[Rule]", "x1"}], ",", 
            RowBox[{"horizh0", "\[Rule]", "0"}], ",", 
            RowBox[{"horiza1", "\[Rule]", "q"}], ",", 
            RowBox[{"horizt1", "\[Rule]", "x2"}], ",", 
            RowBox[{"horizs0", "\[Rule]", "x3"}]}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"asymp2", "\[Rule]", "x4"}], ",", 
           RowBox[{"asymh2", "\[Rule]", "x5"}], ",", 
           RowBox[{"asyma0", "\[Rule]", "x6"}], ",", 
           RowBox[{"asyma1", "\[Rule]", "x7"}], ",", 
           RowBox[{"asymT3", "\[Rule]", "x8"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tlist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", 
          RowBox[{"z", "^", "2"}]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"T", "[", "z", "]"}], "-", "1"}], ")"}]}], "/.", "nsol1"}],
        "/.", 
       RowBox[{"{", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", 
            RowBox[{"-", "2"}]}], "]"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{
            RowBox[{"horizT", "[", "z", "]"}], "-", "1"}], 
           RowBox[{"z", "^", "2"}]], "/.", 
          RowBox[{"{", 
           RowBox[{"z", "\[Rule]", "1"}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"horizp0", "\[Rule]", "x1"}], ",", 
           RowBox[{"horizh0", "\[Rule]", "0"}], ",", 
           RowBox[{"horiza1", "\[Rule]", "q"}], ",", 
           RowBox[{"horizt1", "\[Rule]", "x2"}], ",", 
           RowBox[{"horizs0", "\[Rule]", "x3"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Slist", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["1", 
          RowBox[{"z", "^", "2"}]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"S", "[", "z", "]"}], "-", "1"}], ")"}]}], "/.", "nsol1"}],
        "/.", 
       RowBox[{"{", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"ChebR", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", 
            RowBox[{"-", "2"}]}], "]"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{
            RowBox[{"horizS", "[", "z", "]"}], "-", "1"}], 
           RowBox[{"z", "^", "2"}]], "/.", 
          RowBox[{"{", 
           RowBox[{"z", "\[Rule]", "1"}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"horizp0", "\[Rule]", "x1"}], ",", 
           RowBox[{"horizh0", "\[Rule]", "0"}], ",", 
           RowBox[{"horiza1", "\[Rule]", "q"}], ",", 
           RowBox[{"horizt1", "\[Rule]", "x2"}], ",", 
           RowBox[{"horizs0", "\[Rule]", "x3"}]}], "}"}]}], "/.", "nsol"}], 
       "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]", "=", 
    RowBox[{"Arg", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Interpolation", "[", 
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{"ChebR", ",", 
           RowBox[{"plist", "+", 
            RowBox[{"I", " ", "hlist"}]}]}], "}"}], "]"}], "]"}], "'"}], "[", 
      "0", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"\[Theta]", "=", 
     RowBox[{"Arg", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"plist", "+", 
          RowBox[{"I", " ", "hlist"}]}], ")"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], "/", 
       RowBox[{"ChebR", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<\[Theta] = \>\"", ",", "\[Theta]"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]list", "=", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "I"}], " ", "\[Theta]"}], "]"}], 
     RowBox[{"(", 
      RowBox[{"plist", "+", 
       RowBox[{"I", " ", "hlist"}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plist2", "=", 
    RowBox[{"Re", "[", "\[Psi]list", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hlist2", "=", 
    RowBox[{"Im", "[", "\[Psi]list", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"file", " ", "=", " ", 
    RowBox[{"OpenWrite", "[", 
     RowBox[{"filename", ",", " ", 
      RowBox[{"BinaryFormat", " ", "\[Rule]", " ", "True"}]}], "]"}]}], ";"}],
   "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "file", "]"}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", "NR", ",", " ", "\"\<Integer32\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", "aval", ",", " ", "\"\<Real64\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", " ", "plist2", ",", " ", "\"\<Real64\>\""}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", " ", "hlist2", ",", " ", "\"\<Real64\>\""}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", " ", "alist", ",", " ", "\"\<Real64\>\""}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", " ", "Tlist", ",", " ", "\"\<Real64\>\""}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", " ", "Slist", ",", " ", "\"\<Real64\>\""}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJwdxU8oQ3EcAPBnmchhB9nFKz3tYPUalqxR6ina2KxZDlYrVvMnMWWFHUzN
VmtLsevebIrTpDRPiXZXMrYcxhhqW8PQEs3L/L6/w6cPZbaOWAQEQZAILM99
Ma2mAmPTx9SwmArHYNoxF4e5xlASJlPFW/jeOvUMry/yObg5+/ILy4U0D2/0
pqul6E5Lhwi+DihJWJHIUzDnpAfgnXqRCs7MFifgYJfNDBtdvEs7XWC0W3Vu
+E166YUjfJ0PZnMS9Qra0BbFn9716OCl9gt86qApGEA7Ysu7sNiZjsBro9Q+
3KebT7PoMi1+hL3j5z9wyF3Cv5oeaoNof/8n3jfptcNjURbPKdi/PXSNM4w/
FCrJlpkC85FS4elSWQ/LZJwB7iYaMhJ0Ja/Bb64OXw2ibyoBvFFL2jXos+MF
fDZk88Dy9wTecxT3w0OCJP7k+2kb9lXl8f8tP+Df
  "]],

Cell[BoxData[
 RowBox[{"\[Theta]", "=", 
  RowBox[{"Arg", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Interpolation", "[", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"ChebR", ",", 
         RowBox[{"plist", "+", 
          RowBox[{"I", " ", "hlist"}]}]}], "}"}], "]"}], "]"}], "'"}], "[", 
    "0", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544507369623145*^9, 3.544507432382393*^9}, {
  3.544507489828068*^9, 3.5445075777019043`*^9}}],

Cell[BoxData[
 RowBox[{"Arg", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"ChebR", ",", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "I"}], " ", "\[Theta]"}], "]"}], 
         RowBox[{"(", 
          RowBox[{"plist", "+", 
           RowBox[{"I", " ", "hlist"}]}], ")"}]}]}], "}"}], "]"}], "]"}], 
    "'"}], "[", "0", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.544507612806918*^9, 3.5445076149014378`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerics - Unbroken", "Subsubtitle",
 CellChangeTimes->{{3.538463013798025*^9, 3.5384630213987093`*^9}, {
  3.538467402992407*^9, 3.5384674058714247`*^9}, {3.538985525635343*^9, 
  3.538985527153359*^9}, {3.544507260924809*^9, 3.544507264123662*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"NR", "=", "20"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NN", "=", 
   RowBox[{"NR", "-", "1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.51763841954007*^9, 3.517638421220167*^9}, {
   3.53850182798134*^9, 3.538501830676206*^9}, {3.53873119805525*^9, 
   3.538731198141795*^9}, 3.538741113249531*^9, 3.538808539493106*^9, 
   3.538808990452856*^9, {3.5388105439971848`*^9, 3.538810586676996*^9}, {
   3.543734747237671*^9, 3.5437347473106213`*^9}, 3.5437353134547043`*^9, 
   3.543749518444067*^9, {3.544183116641727*^9, 3.544183116712715*^9}, {
   3.544185774514337*^9, 3.544185774633152*^9}, {3.54418629459544*^9, 
   3.544186296250272*^9}, {3.5441871346949663`*^9, 3.544187134830748*^9}, {
   3.5441884512644587`*^9, 3.544188451335978*^9}, {3.544254134465604*^9, 
   3.5442541346074963`*^9}, {3.54425433600432*^9, 3.544254336074218*^9}, {
   3.544254483790492*^9, 3.544254506253615*^9}, {3.544254691233963*^9, 
   3.5442547118571177`*^9}, {3.544254873132792*^9, 3.5442548759486094`*^9}, {
   3.544255115027749*^9, 3.544255115105729*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ChebR", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"\[Pi]", " ", "ii"}], "NN"], "]"}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "NN", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "ChebR", "]"}]}], "Input",
 CellChangeTimes->{{3.5175504275379143`*^9, 3.517550473868642*^9}, {
   3.5175505088539352`*^9, 3.51755057150263*^9}, {3.5175531815270977`*^9, 
   3.517553182781066*^9}, {3.5175532841430807`*^9, 3.517553285717567*^9}, {
   3.5175533447190742`*^9, 3.517553345933249*^9}, {3.517553478839162*^9, 
   3.5175534801413918`*^9}, {3.517553697086974*^9, 3.5175537300535307`*^9}, {
   3.517636043667302*^9, 3.517636082342285*^9}, {3.517636156121964*^9, 
   3.517636163909718*^9}, 3.517636245951754*^9, {3.517637708503521*^9, 
   3.517637710805746*^9}, {3.5176384245898523`*^9, 3.5176384266140013`*^9}, {
   3.517639920088458*^9, 3.517639921413632*^9}, {3.517639981975692*^9, 
   3.517640027901559*^9}, {3.5389860399222803`*^9, 3.538986051129409*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "aval", ",", "p", ",", "h", ",", "a", ",", "T", ",", "S", ",", "q"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5389856150179768`*^9, 3.538985619269599*^9}, {
  3.5389867130184183`*^9, 3.538986714170092*^9}, {3.538986804615107*^9, 
  3.538986816726158*^9}, {3.544185784218293*^9, 3.5441857842780457`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", "\[Epsilon]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", "z_", "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{"3", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        FractionBox["1", "4"], 
        RowBox[{"q", "^", "2"}]}]}], ")"}], " ", 
     RowBox[{"z", "^", "3"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", "z_", "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.538985584177477*^9, 3.538985599024313*^9}, {
   3.53898566037003*^9, 3.538985663298764*^9}, {3.538985694375431*^9, 
   3.538985752536989*^9}, 3.538985795674563*^9}],

Cell[BoxData[
 RowBox[{"T", "[", "1", "]"}]], "Input",
 CellChangeTimes->{{3.538985754767921*^9, 3.5389857560546093`*^9}}],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"T", "'"}], "[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.543856049182849*^9, 3.5438560548742228`*^9}}],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     FractionBox[
      SuperscriptBox["q", "2"], "4"]}], "\[Equal]", "0"}], ",", "q"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.54385607503798*^9, 3.543856082329897*^9}}],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"2", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5438560862931547`*^9, 3.5438560893374767`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", "eqlist", "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"\[Epsilon]", "\[Rule]", "0"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5389856530849533`*^9, 3.538985700420933*^9}, {
  3.538985764598106*^9, 3.5389857663737926`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "p", ",", "h", ",", "a", ",", "T", ",", "S", ",", "q", ",", "aval"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5389867601265717`*^9, 3.538986761510334*^9}, {
  3.54418495562226*^9, 3.544184955734089*^9}, {3.5442543436183434`*^9, 
  3.5442543444902763`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", "z_", "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "z_", "]"}], ":=", 
   RowBox[{"3", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        FractionBox["1", "4"], 
        RowBox[{"q", "^", "2"}]}]}], ")"}], " ", 
     RowBox[{"z", "^", "3"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", "z_", "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.538985584177477*^9, 3.538985599024313*^9}, {
   3.53898566037003*^9, 3.538985663298764*^9}, {3.538985694375431*^9, 
   3.538985752536989*^9}, 3.538985795674563*^9, 3.538986011486863*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plist", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        FractionBox["1", "z"], 
        RowBox[{"p", "[", "z", "]"}]}], "]"}], "/.", 
      RowBox[{"z", "\[Rule]", 
       RowBox[{"ChebR", "[", 
        RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "NR"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hlist", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{
         FractionBox["1", "z"], 
         RowBox[{"h", "[", "z", "]"}]}], "]"}], "/.", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"ChebR", "[", 
         RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "NR"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"alist", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{
         FractionBox["1", "z"], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "[", "z", "]"}], "-", 
           RowBox[{"a", "[", "0", "]"}]}], ")"}]}], "]"}], "/.", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"ChebR", "[", 
         RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "NR"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tlist", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"z", "^", "2"}]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"T", "[", "z", "]"}], "-", "1"}], ")"}]}], "]"}], "/.", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"ChebR", "[", 
         RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "NR"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Slist", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"z", "^", "2"}]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"S", "[", "z", "]"}], "-", "1"}], ")"}]}], "]"}], "/.", 
      RowBox[{"z", "\[Rule]", 
       RowBox[{"ChebR", "[", 
        RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "NR"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538502159684472*^9, 3.538502221978693*^9}, {
  3.538503165035289*^9, 3.538503299421774*^9}, {3.5385033330026503`*^9, 
  3.5385033914641247`*^9}, {3.5385034512324057`*^9, 3.538503487889101*^9}, {
  3.538503647371841*^9, 3.538503649375634*^9}, {3.538503718913886*^9, 
  3.538503801543604*^9}, {3.538503905800393*^9, 3.538503951275783*^9}, {
  3.538504241391078*^9, 3.53850425647017*^9}, {3.5385044634506683`*^9, 
  3.538504467631667*^9}, {3.538985892124278*^9, 3.538985994625936*^9}, {
  3.538986027757465*^9, 3.5389860283252296`*^9}, {3.538986835591592*^9, 
  3.538986835671126*^9}, {3.538999265602706*^9, 3.538999328993082*^9}, {
  3.5442548531308804`*^9, 3.544254853648411*^9}, {3.5442548996976643`*^9, 
  3.544254974359164*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"aval", "=", 
   RowBox[{"a", "[", "0", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538503869006027*^9, 3.538503871118003*^9}, {
  3.538504557033042*^9, 3.538504557751896*^9}, {3.538985779939569*^9, 
  3.538985810144496*^9}, {3.544184963629833*^9, 3.544184965661772*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", "1.5"}], ";"}]], "Input",
 CellChangeTimes->{{3.5389867796132174`*^9, 3.538986782685376*^9}, {
   3.543749500757925*^9, 3.543749501435857*^9}, {3.544184967589922*^9, 
   3.544184970277432*^9}, {3.5441871185849543`*^9, 3.544187124782961*^9}, {
   3.5441874014648533`*^9, 3.544187401562845*^9}, {3.5441881579959087`*^9, 
   3.544188158082137*^9}, {3.544188251954484*^9, 3.5441882524721317`*^9}, {
   3.544188445473291*^9, 3.5441884456001797`*^9}, 3.5443290203578777`*^9, {
   3.5443291761474237`*^9, 3.5443291764891644`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"file", " ", "=", " ", 
    RowBox[{"OpenWrite", "[", 
     RowBox[{"\"\<~/Work/AdSCMTDyn2/C/test/init.dat\>\"", ",", " ", 
      RowBox[{"BinaryFormat", " ", "\[Rule]", " ", "True"}]}], "]"}]}], ";"}],
   "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "file", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", "NR", ",", " ", "\"\<Integer32\>\""}], "]"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", "aval", ",", " ", "\"\<Real64\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", " ", "plist", ",", " ", "\"\<Real64\>\""}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", " ", "hlist", ",", " ", "\"\<Real64\>\""}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", " ", "alist", ",", " ", "\"\<Real64\>\""}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", " ", "Tlist", ",", " ", "\"\<Real64\>\""}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file", ",", " ", "Slist", ",", " ", "\"\<Real64\>\""}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.5385020074997997`*^9, 3.538502020253977*^9}, {
   3.538502054087071*^9, 3.5385021529179296`*^9}, {3.538504511144497*^9, 
   3.538504585717393*^9}, {3.538504623909217*^9, 3.5385046463399553`*^9}, {
   3.538726443406577*^9, 3.538726445469967*^9}, {3.5389858674047813`*^9, 
   3.538985868491022*^9}, 3.543734330538042*^9, {3.5441831500034533`*^9, 
   3.544183150875201*^9}, {3.544251770602817*^9, 3.5442517744806957`*^9}, {
   3.5442541722593517`*^9, 3.5442541731471*^9}, {3.544254280635108*^9, 
   3.544254297497047*^9}}],

Cell[BoxData["aval"], "Input",
 CellChangeTimes->{{3.538727363712104*^9, 3.538727364132785*^9}, {
  3.538727421558289*^9, 3.5387274460290956`*^9}}],

Cell[BoxData["NR"], "Input",
 CellChangeTimes->{{3.538727377866576*^9, 3.538727377933123*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "p", ",", "h", ",", "a", ",", "T", ",", "S", ",", "q", ",", "aval"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.544254180209392*^9, 3.544254180313586*^9}, {
  3.544254352282263*^9, 3.544254353153924*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1246, 869},
WindowMargins->{{179, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 846, 16, 146, "Subtitle"],
Cell[1428, 40, 68, 1, 27, "Input"],
Cell[CellGroupData[{
Cell[1521, 45, 157, 2, 26, "Subsubtitle"],
Cell[1681, 49, 856, 22, 58, "Input"],
Cell[2540, 73, 229421, 5577, 4409, "Input"],
Cell[231964, 5652, 52820, 1419, 1612, "Input"],
Cell[284787, 7073, 17051, 436, 324, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[301875, 7514, 167, 2, 26, "Subsubtitle"],
Cell[302045, 7518, 394, 7, 27, "Input"],
Cell[302442, 7527, 23926, 542, 1783, "Input"],
Cell[326371, 8071, 21829, 505, 1528, "Input"],
Cell[348203, 8578, 263, 7, 58, "Input"],
Cell[348469, 8587, 287, 8, 58, "Input"],
Cell[348759, 8597, 283, 8, 58, "Input"],
Cell[349045, 8607, 218, 7, 58, "Input"],
Cell[349266, 8616, 383, 10, 58, "Input"],
Cell[349652, 8628, 494, 12, 27, "Input"],
Cell[350149, 8642, 583, 16, 58, "Input"],
Cell[350735, 8660, 1274, 29, 103, "Input"],
Cell[352012, 8691, 1186, 30, 118, "Input"],
Cell[353201, 8723, 1188, 30, 118, "Input"],
Cell[354392, 8755, 1211, 30, 118, "Input"],
Cell[355606, 8787, 1102, 28, 118, "Input"],
Cell[356711, 8817, 121, 2, 27, "Input"],
Cell[356835, 8821, 1976, 55, 73, "Input"],
Cell[358814, 8878, 5108, 73, 58, "Input"],
Cell[363925, 8953, 12257, 358, 985, "Input"],
Cell[376185, 9313, 470, 13, 27, "Input"],
Cell[376658, 9328, 543, 16, 27, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[377238, 9349, 256, 3, 26, "Subsubtitle"],
Cell[377497, 9354, 1130, 20, 58, "Input"],
Cell[378630, 9376, 1283, 27, 79, "Input"],
Cell[379916, 9405, 356, 7, 27, "Input"],
Cell[380275, 9414, 2828, 58, 169, "Input"],
Cell[383106, 9474, 122, 2, 27, "Input"],
Cell[383231, 9478, 176, 4, 27, "Input"],
Cell[383410, 9484, 278, 9, 49, "Input"],
Cell[383691, 9495, 174, 4, 27, "Input"],
Cell[383868, 9501, 271, 6, 27, "Input"],
Cell[384142, 9509, 309, 7, 27, "Input"],
Cell[384454, 9518, 2841, 58, 169, "Input"],
Cell[387298, 9578, 3423, 97, 235, "Input"],
Cell[390724, 9677, 309, 6, 27, "Input"],
Cell[391036, 9685, 567, 9, 27, "Input"],
Cell[391606, 9696, 2278, 56, 313, "Input"],
Cell[393887, 9754, 147, 2, 27, "Input"],
Cell[394037, 9758, 94, 1, 27, "Input"],
Cell[394134, 9761, 255, 6, 27, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
